\name{HybridModel}
\alias{HybridModel}

\title{
Specifying graphical models
}
\description{
Functions to create instances of Graphical models.
}
\usage{
HybridModel(edges, nodes, distributions)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{edges}{ a matrix with 2 columns, either numeric or
    character. Each row represents a directed edge in the graph. The first
    column specifies the source node, the second the destination node of
    an edge. 
}
  \item{nodes}{ a vector of nodes (either numeric or character) in the graph.
}
  \item{distributions}{ a list of distributions for each node.
}
}
\details{
%%  ~~ If necessary, more details than the description above ~~
}
\value{
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
}
\references{
%% ~put references to the literature/web site here ~
}
\author{
%%  ~~who you are~~
}
\note{
%%  ~~further notes~~
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
##---- Should be DIRECTLY executable !! ----
##-- ==>  Define data, use random,
##--	or do  help(data=index)  for the standard data sets.

## The function is currently defined as
function (edges, nodes, distributions) 
{
    model = list()
    class(model) = "HybridModel"
    model$nodes = nodes
    model$edges = edges
    model$distributions = distributions
    model$nodeTypes = rep("continuous", length(nodes))
    names(model$nodeTypes) = nodes
    model$nodeTypes[sapply(distributions, class) == "Multinomial"] = "discrete"
    if (length(model$distributions) > 0) 
        model$n.param = sum(sapply(model$distributions, "[[", 
            "n.param"))
    else model$n.param = 0
    model$topological.order = topological.order(edges, nodes)
    return(model)
  }
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~kwd1 }
\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
