\name{GraphicalModels-package}
\alias{GraphicalModels-package}
\alias{GraphicalModels}
\docType{package}
\title{
Likelihood based model selection using graphical models
}
\description{
Likelihood based model selection using graphical models
}
\details{
\tabular{ll}{
Package: \tab GraphicalModels\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2014-03-04\cr
License: \tab LGPL\cr
}
Models are specified by a directed acyclic graph and a set of distributions.
The function \code{HybridModel(edges, nodes, distributions)} creates an
instance of such a model. The function \code{logLik.HybridModel}
computes the loglikelihood of the data and \code{information.criteria}
computes AIC and BIC.
}
\author{
Matthias Heinig
Maintainer: Matthias Heinig <heinig@molgen.mpg.de>
}
\references{

Schadt EE, Lamb J, Yang X, Zhu J, Edwards S, Guhathakurta D, Sieberts
SK, Monks S, Reitman M, Zhang C, Lum PY, Leonardson A, Thieringer R,
Metzger JM, Yang L, Castle J, Zhu H, Kash SF, Drake TA, Sachs A, Lusis
AJ. An integrative genomics approach to infer causal associations
between gene expression and disease. Nat Genet. 2005 Jul;37(7):710-7.

}
\keyword{ package }
\seealso{
}
\examples{

data(histoneQTLModels)
data(histoneQTLData)
genes = head(unique(histoneQTLData[,"trait"]))
modelSelection = single.locus.bootstrap(genes, models, histoneQTLData, q.cols=c("eqtl_q", "k4qtl_q", "k27qtl_q"), "histoneQTLModelSelection.txt", 100)

}
