topological.order <-
function(edges, nodes) {
  L = c()# Empty list that will contain the sorted elements
  S = setdiff(nodes, edges[,2]) # Set of all nodes with no incoming edges
  while (length(S) > 0) {
    n = S[1]
    S = S[-1]
    L = c(L, n)
    for (m in children(edges, n)) {
      # remove edge from the graph
      edges = edges[!(edges[,1] == n & edges[,2] == m),,drop=F]
      # if m has no other incoming edges then insert m into S
      if (length(parents(edges, m)) == 0) {
        S = c(S, m)
      }
    }
  }
  if (nrow(edges) != 0) {
    stop("graph has at least one cycle")
  }
  return(L)
}
