single.locus.bootstrap <-
function(genes, models, data, q.cols, fname, n.bootstrap, redo=T, covar=NULL) {
  if (redo || !file.exists(fname)) {
    results = NULL
    for (s in genes) {
      cat(s, "\n")
    
      tab = best.marker(s, data, q.cols)
      if (nrow(tab) == 0) {
        cat("strange, data not retrieved\n")
        next
      }
      
      gtab = tab[,c("expr", "k4", "k27", "genotype", covar)]
      colnames(gtab) = c("expr", "h3k4", "h3k27", "snp", covar)
      gtab[,1:3] = log(gtab[,1:3] + 1)

      # if all values of a column are NA remove the column
      gtab = gtab[,!apply(is.na(gtab), 2, all)]
      # remove samples with NAs in the remaining columns
      gtab = gtab[apply(!is.na(gtab), 1, all),]

      minor.allele.count = min(table(gtab[,"snp"]))
      
      # first the global fit
      fits = t(sapply(models, information.criteria, data=gtab))

      # then draw boot strap samples and count how many times each model
      # is chosen
      bs.counts = rep(0, length(models))
      for (i in 1:n.bootstrap) {
        # sample s.t. the genotype distr. is preserved
        s1 = which(as.numeric(gtab[,"snp"]) == 1)
        s2 = which(as.numeric(gtab[,"snp"]) == 2)
        bs.data = gtab[c(sample(s1, length(s1), replace=T), sample(s2, length(s2), replace=T)),]
        check = table(bs.data[,"snp"])
        bs.fits = t(sapply(models, information.criteria, data=bs.data))
        min.aic = min(bs.fits[,"AIC"])
        min.model = bs.fits[,"AIC"] == min.aic # in case of ties
        bs.counts[min.model] = bs.counts[min.model] + 1
      }
    
      fits = data.frame(gene=s, marker=tab$marker[1], model=rownames(fits), fits, bs.counts, bs.prob=bs.counts/n.bootstrap, stringsAsFactors=F, check.names=F)
      
      results = rbind(results, fits)
    }
    rownames(results) = NULL
  
    write.table(results, fname, sep="\t", quote=F, row.names=F)
  } else {
    results = read.csv(fname, sep="\t", stringsAsFactors=F)
  }
  return(results)
}
