plot.model <-
function(model, data) {
  require(Rgraphviz)
  # try to make the plot as square as possible
  n = length(model$nodes)
  size = ceiling(sqrt(n))
  split.screen(c(size + 1, size))
  for (i in 1:n) {
    screen(i)
    node = model$nodes[i]
    plot = switch(class(model$distributions[[node]]),
      Multinomial={
        barplot(model$distributions[[node]]$freq, main=node)
      },
      Normal={
        hist(data[,node], main=node, xlab="")
      },
      Linear={
        x = predict(model$distributions[[node]]$model)
        y = data[,node]
        plot(x, y, main=node, xlab="predicted", ylab="observed")
        abline(lm(y~x))
      })
  }

  screen(i + 1)
  g = make.GraphNEL(model$edges, model$nodes)
  plot(g)
  
  close.screen(all.screens=TRUE)
}
