logLik.HybridModel <-
function(model, data) {

  logLik.Linear <- function(x, data)
    logLik(x$model)
  logLik.Multinomial <- function(x, data) {
    sum(log(x$freq) * table(data[,x$node]))
  }
  logLik.Normal <- function(x, data) {
    sum(dnorm(data[,x$node], mean=x$mean, sd=x$sigma, log=T))
  }

  ll = sum(sapply(model$distributions, function(x) {
    l = switch(class(x),
           Linear=logLik.Linear(x, data),
           Multinomial=logLik.Multinomial(x, data),
           Normal=logLik.Normal(x, data))
    # cat(class(x), l, "\n")
    return(l)
  }))
  return(ll)
}
