generate <-
function(model, nsamples, data=NULL) {  
  switch(class(model),
         Normal=rnorm(nsamples, mean=model$mean, sd=model$sigma),
         Multinomial={
           n = rmultinom(1, size=nsamples, prob=model$freq)
           x = c()
           for (i in 1:length(model$levels)) {
             x = c(x, rep(model$levels[i], n[i]))
           }
           factor(x[sample(1:nsamples, size=nsamples)])
         },
         Linear={
           stopifnot(nrow(data) == nsamples)
           cols = which(sapply(colnames(data), function(cn) length(grep(cn, names(model$beta))) > 0))
           X = model.matrix(~., data=data[, cols, drop=F])
           y = X %*% model$beta[colnames(X)]
           rnorm(nsamples, mean=y, sd=model$sigma)
         },
         HybridModel={
           data = data.frame(matrix(ncol=0, nrow=nsamples))
           # generate data for nodes without parents
           orphans = setdiff(model$nodes, model$edges[,2])
           for (node in orphans) {
             data = data.frame(data, generate(model$distributions[[node]], nsamples))
             colnames(data)[ncol(data)] = node
           }
           # using this data, generate data for the rest
           rest = model$topological.order[!model$topological.order %in% orphans]
           for (node in rest) {
             data = data.frame(data, generate(model$distributions[[node]], nsamples, data))
             colnames(data)[ncol(data)] = node
           }
           return(data)
         })
}
