fit <-
function(edges, data, nodes=NULL) {

  if (is.null(nodes)) {
    nodes = colnames(data)
  }

  model = HybridModel(edges, nodes, list())

  # find all nodes that have no parents
  orphans = setdiff(nodes, edges[,2])

  # ML fit of the orphans
  for (node in orphans) {
    # fit normal / multinomial for continuous / discrete nodes
    if (is.factor(data[,node])) {
      model$nodeTypes[node] = "discrete"
      model$distributions[[node]] = Multinomial(node, table(data[,node]), levels(data[,node]))
    } else {
      model$distributions[[node]] = Normal(node, mean(data[,node]), sd(data[,node]))
    }
  }
  
  # use lm to fit the models of internal nodes  
  for (node in setdiff(nodes, orphans)) {
    m = lm(as.formula(paste(node, "~", paste(parents(edges, node), collapse="+"))), data=data)
    model$distributions[[node]] = Linear(node, m)
  }

  model$n.param = sum(sapply(model$distributions, "[[", "n.param"))
  
  return(model)
}
