HybridModel <-
function(edges, nodes, distributions) {
  model = list()
  class(model) = "HybridModel"
  model$nodes = nodes
  model$edges = edges
  model$distributions = distributions
  model$nodeTypes = rep("continuous", length(nodes))
  names(model$nodeTypes) = nodes
  model$nodeTypes[sapply(distributions, class) == "Multinomial"] = "discrete"
  if (length(model$distributions) > 0)
    model$n.param = sum(sapply(model$distributions, "[[", "n.param"))
  else
    model$n.param = 0
  model$topological.order = topological.order(edges, nodes)
  return(model)
}
