####################################################################################################
####################################################################################################
#TOTAL EXPRESSION ANALYSES for Coolon et al 2014
####################################################################################################
####################################################################################################
#FILE STRUCTURE
#Final
	#zhr_z30
		#Separate
		#resequencing
		#mel-mel_P+H1
			#outputs
		#mel-mel_P+H2
			#outputs
		#mel-mel_H1+H2
			#outputs
		#mismapping
	#sim_sec
		#Separate
		#resequencing
		#sim-sec_P+H1
			#outputs
		#sim-sec_P+H2
			#outputs
		#sim-sec_H1+H2
			#outputs
		#mismapping
	#mel_sim
		#Separate
		#resequencing
		#mel-sim_P+H1
			#outputs
		#mel-sim_P+H2
			#outputs
		#mel-sim_H1+H2
			#outputs
		#mismapping
	#Meta
	#Total
	#separate
#gene_positions
	#chrX.genes.bed (BED FILE FOR GENES FOR EACH CHROMOSOME ARM)
	#chr2L.genes.bed (BED FILE FOR GENES FOR EACH CHROMOSOME ARM)
	#chr2R.genes.bed (BED FILE FOR GENES FOR EACH CHROMOSOME ARM)
	#chr3L.genes.bed (BED FILE FOR GENES FOR EACH CHROMOSOME ARM)
	#chr3R.genes.bed (BED FILE FOR GENES FOR EACH CHROMOSOME ARM)

####################################################################################################
#CORRECTIONS FOR DIFFERENCES IN SAMPLING
####################################################################################################

#read in data

#mel-mel genes
data1<-read.delim("/Final/zhr_z30/separate/zhr_z30_mRNA.mosaik.genes.txt", header=TRUE)

#sim-sec genes
data2<-read.delim("/Final/sim_sec/separate/tsimbazaza_droSec1_mRNA.mosaik.genes.txt", header=TRUE)

#mel-sim genes
data3<-read.delim("/Final/mel_sim/separate/zhr_tsimbazaza_mRNA.mosaik.genes.txt", header=TRUE)

#mel-mel hybrids
data4<-read.delim("/Final/zhr_z30/mel-mel_H1+H2/zhrXz30_z30Xzhr_mRNA.mosaik.genes.txt", header=TRUE)

#sim-sec hybrids
data5<-read.delim("/Final/sim_sec/sim-sec_H1+H2/tsimbazazaXdroSec1_droSec1Xtsimbazaza_mRNA.mosaik.genes.txt", header=TRUE)

#mel-sim hybrids
data6<-read.delim("/Final/mel_sim/mel-sim_H1+H2/zhrXtsimbazaza_tsimbazazaXzhr_mRNA.mosaik.genes.txt", header=TRUE)


#get number of reads mapping in each sample

sum(data1[,2]+data1[,3]+data1[,4])
sum(data1[,5]+data1[,6]+data1[,7])

sum(data2[,2]+data2[,3]+data2[,4])
sum(data2[,5]+data2[,6]+data2[,7])

sum(data3[,2]+data3[,3]+data3[,4])
sum(data3[,5]+data3[,6]+data3[,7])

sum(data4[,2]+data4[,3]+data4[,4])
sum(data4[,5]+data4[,6]+data4[,7])

sum(data5[,2]+data5[,3]+data5[,4])
sum(data5[,5]+data5[,6]+data5[,7])

sum(data6[,2]+data6[,3]+data6[,4])
sum(data6[,5]+data6[,6]+data6[,7])


# get minimum mapping number

min<-min(sum(data1[,2]+data1[,3]+data1[,4]),sum(data1[,5]+data1[,6]+data1[,7]),sum(data2[,2]+data2[,3]+data2[,4]),sum(data2[,5]+data2[,6]+data2[,7]),sum(data3[,2]+data3[,3]+data3[,4]),sum(data3[,5]+data3[,6]+data3[,7]),sum(data4[,2]+data4[,3]+data4[,4]),sum(data4[,5]+data4[,6]+data4[,7]),sum(data5[,2]+data5[,3]+data5[,4]),sum(data5[,5]+data5[,6]+data5[,7]),sum(data6[,2]+data6[,3]+data6[,4]),sum(data6[,5]+data6[,6]+data6[,7]))

min

####################################################################################################
####################################################################################################
#read totals

#sum(dataZHR1[,2]) 16464075
#sum(dataZ30[,2]) 21806797
#sum(dataSIM1[,2]) 18006673
#sum(dataSEC[,2]) 15817452
#sum(dataZHR2[,2]) 16464075
#sum(dataSIM2[,2]) 18006673
#sum(dataMMH1[,2]) 31432754
#sum(dataMMH2[,2]) 31439998
#sum(dataSSH1[,2]) 19787136
#sum(dataSSH2[,2]) 20059660
#sum(dataMSH1[,2]) 23929242
#sum(dataMSH2[,2]) 25875801

#MAPPABLE COUNTS
#sum(dataZHR1[,2]) = 12915170
#sum(dataZHR2[,2]) = 12905538
#sum(dataZ30[,2]) = 18231082
#sum(dataSIM1[,2]) = 14811651
#sum(dataSIM2[,2]) = 14818358
#sum(dataSEC[,2]) = 12704991

#12915170/16464075
#12905538/16464075
#18231082/21806797
#14811651/18006673
#14818358/18006673
#12704991/15817452

#25957434/31432754
#26515174/31439998
#17169600/19787136
#17517914/20059660
#19484335/23929242
#20936819/25875801

####################################################################################################
####################################################################################################


#make merged data

data7<-merge(data1, data4, by = 'gene')
data8<-merge(data7,data2, by = 'gene')
data9<-merge(data8,data5, by = 'gene')
data10<-merge(data9,data3, by = 'gene')
data11<-merge(data10, data6, by = 'gene')

key1<-data.frame(key<-cbind(as.character(data11[,1]),(1:nrow(data11))))
colnames(key1)<-c('gene','number')

data11<-merge(key1,data11, by = 'gene')
colnames(data11)<-c('gene','number','mmp11','mmp12','mmp1b','mmp21','mmp22','mmp2b','mmh111','mmh112','mmh11b','mmh221','mmh222','mmh22b','ssp11','ssp12','ssp1b','ssp21','ssp22','ssp2b','ssh111','ssh112','ssh11b','ssh221','ssh222','ssh22b','msp11','msp12','msp1b','msp21','msp22','msp2b','msh111','msh112','msh11b','msh221','msh222','msh22b')

key<-data11[,1:2]

SSP2<-data.frame(SSP2<-cbind(data2[,1],c(1:14011),data2[,5:7]))
colnames(MMH2)<-c('gene','number','ssp21','sss22','ssp2b')

SSP2<-cbind(SSP2[,1:2],SSP2[,3:5]-1)

write.table(SSP2,file ="/Final/Total/SSP2.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(data1,data2,data3,data4,data5,data6,data7,data8,data9,data10,key1,SSP2)

genes<-c(1:14011)
genes2<-data.frame(genes)
genes2<-cbind(genes2,data.frame(as.factor(rep(0,nrow(genes2)))))
genes2[,1]<-as.factor(genes2[,1])
colnames(genes2)<-c('number','set')

genenames<-data.frame(genenames<-data11[,1])
colnames(genenames)<-c('gene')
write.table(genenames,file ="/Final/Total/genenames.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(data11,file ="/Final/Total/before_downsample.txt",sep="\t",quote=FALSE,row.names=FALSE)

####################################################################################################
#column names#
####################################################################################################
#general 
#1-2 gene and number
#3-8 mmp
#9-14 mmh
#15-20 ssp
#22-26 ssh
#29-32 msp
#33-38 msh

#within coding
#1 = p1 or h1 correct
#2 = p1 or h1 incorrect
#3 = p1 or h1 both
#4 = p2 or h2 incorrect
#5 = p2 or h2 correct
#6 = p2 or h2 both
####################################################################################################

#rm(a1,a2,a3,b1,b2,b3)
#rm(a4,b4,c,d,e,f,g,h,j,k,table1,table2,table3,temp1,temp2,temp3)
#rm(i,temp)

####################################################################################################
#randomly down-sample to make dataset sizes the same for all

#MMP1

a1<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,3])
	a1<-c(a1,temp)
	}

b1<-rep.int(1,sum(data11[,3]))

rm(i,temp)

a2<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,4])
	a2<-c(a2,temp)
	}
	
rm(i,temp)

b2<-rep.int(2,sum(data11[,4]))

a3<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,5])
	a3<-c(a3,temp)
	}

b3<-rep.int(3,sum(data11[,5]))

rm(i,temp)

a4<-c(a1,a2,a3)
b4<-c(b1,b2,b3)

rm(a1,a2,a3,b1,b2,b3)

c<-c(1:length(a4))

d<-sample(c,min,replace = FALSE)

e<-a4[d]
f<-b4[d]

rm(a4,b4,c,d)

g<-data.frame(t(g<-rbind(e,f)))

rm(e,f)

h<-subset(g, g[,2] == 1)
colnames(h)<-c('number','set')
j<-subset(g, g[,2] == 2)
colnames(j)<-c('number','set')
k<-subset(g, g[,2] == 3)
colnames(k)<-c('number','set')

rm(g)

h2<-rbind(h,genes2)
h2<-h2[,1]
rm(h)

j2<-rbind(j,genes2)
j2<-j2[,1]
rm(j)

k2<-rbind(k,genes2)
k2<-k2[,1]
rm(k)

#h2<-c((as.numeric(h2<-h[,1])),genes)
#j2<-c((as.numeric(j2<-j[,1])),genes)
#k2<-c((as.numeric(k2<-k[,1])),genes)

table1<-data.frame(table1<-table(h2))
colnames(table1)<-c('number','table1')
table2<-data.frame(table2<-table(j2))
colnames(table2)<-c('number','table2')
table3<-data.frame(table3<-table(k2))
colnames(table3)<-c('number','table3')

rm(k2,j2,h2)

temp1<-merge(key,table1, by = 'number')
temp2<-merge(temp1,table2, by = 'number')
temp3<-merge(temp2,table3, by = 'number')

MMP1<-merge(genenames,temp3, by = 'gene')

colnames(MMP1)<-c('gene','number','mmp11','mmp12','mmp1b')

MMP1<-cbind(MMP1[,1:2],MMP1[,3:5]-1)

write.table(MMP1,file ="/Final/Total/MMP1.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(table1,table2,table3,temp1,temp2,temp3,MMP1)

ls()

####################################################################################################

#MMP2

a1<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,6])
	a1<-c(a1,temp)
	}

b1<-rep.int(1,sum(data11[,6]))

rm(i,temp)

a2<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,7])
	a2<-c(a2,temp)
	}
	
rm(i,temp)

b2<-rep.int(2,sum(data11[,7]))

a3<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,8])
	a3<-c(a3,temp)
	}

b3<-rep.int(3,sum(data11[,8]))

rm(i,temp)

a4<-c(a1,a2,a3)
b4<-c(b1,b2,b3)

rm(a1,a2,a3,b1,b2,b3)

c<-c(1:length(a4))

d<-sample(c,min,replace = FALSE)

e<-a4[d]
f<-b4[d]

rm(a4,b4,c,d)

g<-data.frame(t(g<-rbind(e,f)))

rm(e,f)

h<-subset(g, g[,2] == 1)
colnames(h)<-c('number','set')
j<-subset(g, g[,2] == 2)
colnames(j)<-c('number','set')
k<-subset(g, g[,2] == 3)
colnames(k)<-c('number','set')

rm(g)

h2<-rbind(h,genes2)
h2<-h2[,1]
rm(h)

j2<-rbind(j,genes2)
j2<-j2[,1]
rm(j)

k2<-rbind(k,genes2)
k2<-k2[,1]
rm(k)

table1<-data.frame(table1<-table(h2))
colnames(table1)<-c('number','table1')
table2<-data.frame(table2<-table(j2))
colnames(table2)<-c('number','table2')
table3<-data.frame(table3<-table(k2))
colnames(table3)<-c('number','table3')

rm(k2,j2,h2)

temp1<-merge(key,table1, by = 'number')
temp2<-merge(temp1,table2, by = 'number')
temp3<-merge(temp2,table3, by = 'number')

MMP2<-merge(genenames,temp3, by = 'gene')

colnames(MMP2)<-c('gene','number','mmp21','mmp22','mmp2b')

MMP2<-cbind(MMP2[,1:2],MMP2[,3:5]-1)

write.table(MMP2,file ="/Final/Total/MMP2.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(table1,table2,table3,temp1,temp2,temp3,MMP2)

ls()

####################################################################################################

#MMH1

a1<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,9])
	a1<-c(a1,temp)
	}

b1<-rep.int(1,sum(data11[,9]))

rm(i,temp)

a2<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,10])
	a2<-c(a2,temp)
	}
	
rm(i,temp)

b2<-rep.int(2,sum(data11[,10]))

a3<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,11])
	a3<-c(a3,temp)
	}

b3<-rep.int(3,sum(data11[,11]))

rm(i,temp)

a4<-c(a1,a2,a3)
b4<-c(b1,b2,b3)

rm(a1,a2,a3,b1,b2,b3)

c<-c(1:length(a4))

d<-sample(c,min,replace = FALSE)

e<-a4[d]
f<-b4[d]

rm(a4,b4,c,d)

g<-data.frame(t(g<-rbind(e,f)))

rm(e,f)

h<-subset(g, g[,2] == 1)
colnames(h)<-c('number','set')
j<-subset(g, g[,2] == 2)
colnames(j)<-c('number','set')
k<-subset(g, g[,2] == 3)
colnames(k)<-c('number','set')

rm(g)

h2<-rbind(h,genes2)
h2<-h2[,1]
rm(h)

j2<-rbind(j,genes2)
j2<-j2[,1]
rm(j)

k2<-rbind(k,genes2)
k2<-k2[,1]
rm(k)

table1<-data.frame(table1<-table(h2))
colnames(table1)<-c('number','table1')
table2<-data.frame(table2<-table(j2))
colnames(table2)<-c('number','table2')
table3<-data.frame(table3<-table(k2))
colnames(table3)<-c('number','table3')

rm(k2,j2,h2)

temp1<-merge(key,table1, by = 'number')
temp2<-merge(temp1,table2, by = 'number')
temp3<-merge(temp2,table3, by = 'number')

MMH1<-merge(genenames,temp3, by = 'gene')

colnames(MMH1)<-c('gene','number','mmh11','mmh12','mmh1b')

MMH1<-cbind(MMH1[,1:2],MMH1[,3:5]-1)

write.table(MMH1,file ="/Final/Total/MMH1.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(table1,table2,table3,temp1,temp2,temp3,MMH1)

ls()

####################################################################################################

#MMH2

a1<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,12])
	a1<-c(a1,temp)
	}

b1<-rep.int(1,sum(data11[,12]))

rm(i,temp)

a2<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,13])
	a2<-c(a2,temp)
	}
	
rm(i,temp)

b2<-rep.int(2,sum(data11[,13]))

a3<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,14])
	a3<-c(a3,temp)
	}

b3<-rep.int(3,sum(data11[,14]))

rm(i,temp)

a4<-c(a1,a2,a3)
b4<-c(b1,b2,b3)

rm(a1,a2,a3,b1,b2,b3)

c<-c(1:length(a4))

d<-sample(c,min,replace = FALSE)

e<-a4[d]
f<-b4[d]

rm(a4,b4,c,d)

g<-data.frame(t(g<-rbind(e,f)))

rm(e,f)

h<-subset(g, g[,2] == 1)
colnames(h)<-c('number','set')
j<-subset(g, g[,2] == 2)
colnames(j)<-c('number','set')
k<-subset(g, g[,2] == 3)
colnames(k)<-c('number','set')

rm(g)

h2<-rbind(h,genes2)
h2<-h2[,1]
rm(h)

j2<-rbind(j,genes2)
j2<-j2[,1]
rm(j)

k2<-rbind(k,genes2)
k2<-k2[,1]
rm(k)

table1<-data.frame(table1<-table(h2))
colnames(table1)<-c('number','table1')
table2<-data.frame(table2<-table(j2))
colnames(table2)<-c('number','table2')
table3<-data.frame(table3<-table(k2))
colnames(table3)<-c('number','table3')

rm(k2,j2,h2)

temp1<-merge(key,table1, by = 'number')
temp2<-merge(temp1,table2, by = 'number')
temp3<-merge(temp2,table3, by = 'number')

MMH2<-merge(genenames,temp3, by = 'gene')

colnames(MMH2)<-c('gene','number','mmh21','mmh22','mmh2b')

MMH2<-cbind(MMH2[,1:2],MMH2[,3:5]-1)

write.table(MMH2,file ="/Final/Total/MMH2.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(table1,table2,table3,temp1,temp2,temp3,MMH2)

ls()

####################################################################################################

#SSP1

a1<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,15])
	a1<-c(a1,temp)
	}

b1<-rep.int(1,sum(data11[,15]))

rm(i,temp)

a2<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,16])
	a2<-c(a2,temp)
	}
	
rm(i,temp)

b2<-rep.int(2,sum(data11[,16]))

a3<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,17])
	a3<-c(a3,temp)
	}

b3<-rep.int(3,sum(data11[,17]))

rm(i,temp)

a4<-c(a1,a2,a3)
b4<-c(b1,b2,b3)

rm(a1,a2,a3,b1,b2,b3)

c<-c(1:length(a4))

d<-sample(c,min,replace = FALSE)

e<-a4[d]
f<-b4[d]

rm(a4,b4,c,d)

g<-data.frame(t(g<-rbind(e,f)))

rm(e,f)

h<-subset(g, g[,2] == 1)
colnames(h)<-c('number','set')
j<-subset(g, g[,2] == 2)
colnames(j)<-c('number','set')
k<-subset(g, g[,2] == 3)
colnames(k)<-c('number','set')

rm(g)

h2<-rbind(h,genes2)
h2<-h2[,1]
rm(h)

j2<-rbind(j,genes2)
j2<-j2[,1]
rm(j)

k2<-rbind(k,genes2)
k2<-k2[,1]
rm(k)

table1<-data.frame(table1<-table(h2))
colnames(table1)<-c('number','table1')
table2<-data.frame(table2<-table(j2))
colnames(table2)<-c('number','table2')
table3<-data.frame(table3<-table(k2))
colnames(table3)<-c('number','table3')

rm(k2,j2,h2)

temp1<-merge(key,table1, by = 'number')
temp2<-merge(temp1,table2, by = 'number')
temp3<-merge(temp2,table3, by = 'number')

SSP1<-merge(genenames,temp3, by = 'gene')

colnames(SSP1)<-c('gene','number','ssp11','ssp12','ssp1b')

SSP1<-cbind(SSP1[,1:2],SSP1[,3:5]-1)

write.table(SSP1,file ="/Final/Total/SSP1.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(table1,table2,table3,temp1,temp2,temp3,SSP1)

ls()

####################################################################################################

#SSH1

a1<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,21])
	a1<-c(a1,temp)
	}

b1<-rep.int(1,sum(data11[,21]))

rm(i,temp)

a2<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,22])
	a2<-c(a2,temp)
	}
	
rm(i,temp)

b2<-rep.int(2,sum(data11[,22]))

a3<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,23])
	a3<-c(a3,temp)
	}

b3<-rep.int(3,sum(data11[,23]))

rm(i,temp)

a4<-c(a1,a2,a3)
b4<-c(b1,b2,b3)

rm(a1,a2,a3,b1,b2,b3)

c<-c(1:length(a4))

d<-sample(c,min,replace = FALSE)

e<-a4[d]
f<-b4[d]

rm(a4,b4,c,d)

g<-data.frame(t(g<-rbind(e,f)))

rm(e,f)

h<-subset(g, g[,2] == 1)
colnames(h)<-c('number','set')
j<-subset(g, g[,2] == 2)
colnames(j)<-c('number','set')
k<-subset(g, g[,2] == 3)
colnames(k)<-c('number','set')

rm(g)

h2<-rbind(h,genes2)
h2<-h2[,1]
rm(h)

j2<-rbind(j,genes2)
j2<-j2[,1]
rm(j)

k2<-rbind(k,genes2)
k2<-k2[,1]
rm(k)

table1<-data.frame(table1<-table(h2))
colnames(table1)<-c('number','table1')
table2<-data.frame(table2<-table(j2))
colnames(table2)<-c('number','table2')
table3<-data.frame(table3<-table(k2))
colnames(table3)<-c('number','table3')

rm(k2,j2,h2)

temp1<-merge(key,table1, by = 'number')
temp2<-merge(temp1,table2, by = 'number')
temp3<-merge(temp2,table3, by = 'number')

SSH1<-merge(genenames,temp3, by = 'gene')

colnames(SSH1)<-c('gene','number','ssh11','ssh12','ssh1b')

SSH1<-cbind(SSH1[,1:2],SSH1[,3:5]-1)

write.table(SSH1,file ="/Final/Total/SSH1.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(table1,table2,table3,temp1,temp2,temp3,SSH1)

ls()

####################################################################################################

#SSH2

a1<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,24])
	a1<-c(a1,temp)
	}

b1<-rep.int(1,sum(data11[,24]))

rm(i,temp)

a2<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,25])
	a2<-c(a2,temp)
	}
	
rm(i,temp)

b2<-rep.int(2,sum(data11[,25]))

a3<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,26])
	a3<-c(a3,temp)
	}

b3<-rep.int(3,sum(data11[,26]))

rm(i,temp)

a4<-c(a1,a2,a3)
b4<-c(b1,b2,b3)

rm(a1,a2,a3,b1,b2,b3)

c<-c(1:length(a4))

d<-sample(c,min,replace = FALSE)

e<-a4[d]
f<-b4[d]

rm(a4,b4,c,d)

g<-data.frame(t(g<-rbind(e,f)))

rm(e,f)

h<-subset(g, g[,2] == 1)
colnames(h)<-c('number','set')
j<-subset(g, g[,2] == 2)
colnames(j)<-c('number','set')
k<-subset(g, g[,2] == 3)
colnames(k)<-c('number','set')

rm(g)

h2<-rbind(h,genes2)
h2<-h2[,1]
rm(h)

j2<-rbind(j,genes2)
j2<-j2[,1]
rm(j)

k2<-rbind(k,genes2)
k2<-k2[,1]
rm(k)

table1<-data.frame(table1<-table(h2))
colnames(table1)<-c('number','table1')
table2<-data.frame(table2<-table(j2))
colnames(table2)<-c('number','table2')
table3<-data.frame(table3<-table(k2))
colnames(table3)<-c('number','table3')

rm(k2,j2,h2)

temp1<-merge(key,table1, by = 'number')
temp2<-merge(temp1,table2, by = 'number')
temp3<-merge(temp2,table3, by = 'number')

SSH2<-merge(genenames,temp3, by = 'gene')

colnames(SSH2)<-c('gene','number','ssh21','ssh22','ssh2b')

SSH2<-cbind(SSH2[,1:2],SSH2[,3:5]-1)

write.table(SSH2,file ="/Final/Total/SSH2.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(table1,table2,table3,temp1,temp2,temp3,SSH2)

ls()

####################################################################################################

#MSP1

a1<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,27])
	a1<-c(a1,temp)
	}

b1<-rep.int(1,sum(data11[,27]))

rm(i,temp)

a2<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,28])
	a2<-c(a2,temp)
	}
	
rm(i,temp)

b2<-rep.int(2,sum(data11[,28]))

a3<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,29])
	a3<-c(a3,temp)
	}

b3<-rep.int(3,sum(data11[,29]))

rm(i,temp)

a4<-c(a1,a2,a3)
b4<-c(b1,b2,b3)

rm(a1,a2,a3,b1,b2,b3)

c<-c(1:length(a4))

d<-sample(c,min,replace = FALSE)

e<-a4[d]
f<-b4[d]

rm(a4,b4,c,d)

g<-data.frame(t(g<-rbind(e,f)))

rm(e,f)

h<-subset(g, g[,2] == 1)
colnames(h)<-c('number','set')
j<-subset(g, g[,2] == 2)
colnames(j)<-c('number','set')
k<-subset(g, g[,2] == 3)
colnames(k)<-c('number','set')

rm(g)

h2<-rbind(h,genes2)
h2<-h2[,1]
rm(h)

j2<-rbind(j,genes2)
j2<-j2[,1]
rm(j)

k2<-rbind(k,genes2)
k2<-k2[,1]
rm(k)

table1<-data.frame(table1<-table(h2))
colnames(table1)<-c('number','table1')
table2<-data.frame(table2<-table(j2))
colnames(table2)<-c('number','table2')
table3<-data.frame(table3<-table(k2))
colnames(table3)<-c('number','table3')

rm(k2,j2,h2)

temp1<-merge(key,table1, by = 'number')
temp2<-merge(temp1,table2, by = 'number')
temp3<-merge(temp2,table3, by = 'number')

MSP1<-merge(genenames,temp3, by = 'gene')

colnames(MSP1)<-c('gene','number','msp11','msp12','msp1b')

MSP1<-cbind(MSP1[,1:2],MSP1[,3:5]-1)

write.table(MSP1,file ="/Final/Total/MSP1.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(table1,table2,table3,temp1,temp2,temp3,MSP1)

ls()

####################################################################################################

#MSP2

a1<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,30])
	a1<-c(a1,temp)
	}

b1<-rep.int(1,sum(data11[,30]))

rm(i,temp)

a2<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,31])
	a2<-c(a2,temp)
	}
	
rm(i,temp)

b2<-rep.int(2,sum(data11[,31]))

a3<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,32])
	a3<-c(a3,temp)
	}

b3<-rep.int(3,sum(data11[,32]))

rm(i,temp)

a4<-c(a1,a2,a3)
b4<-c(b1,b2,b3)

rm(a1,a2,a3,b1,b2,b3)

c<-c(1:length(a4))

d<-sample(c,min,replace = FALSE)

e<-a4[d]
f<-b4[d]

rm(a4,b4,c,d)

g<-data.frame(t(g<-rbind(e,f)))

rm(e,f)

h<-subset(g, g[,2] == 1)
colnames(h)<-c('number','set')
j<-subset(g, g[,2] == 2)
colnames(j)<-c('number','set')
k<-subset(g, g[,2] == 3)
colnames(k)<-c('number','set')

rm(g)

h2<-rbind(h,genes2)
h2<-h2[,1]
rm(h)

j2<-rbind(j,genes2)
j2<-j2[,1]
rm(j)

k2<-rbind(k,genes2)
k2<-k2[,1]
rm(k)

table1<-data.frame(table1<-table(h2))
colnames(table1)<-c('number','table1')
table2<-data.frame(table2<-table(j2))
colnames(table2)<-c('number','table2')
table3<-data.frame(table3<-table(k2))
colnames(table3)<-c('number','table3')

rm(k2,j2,h2)

temp1<-merge(key,table1, by = 'number')
temp2<-merge(temp1,table2, by = 'number')
temp3<-merge(temp2,table3, by = 'number')

MSP2<-merge(genenames,temp3, by = 'gene')

colnames(MSP2)<-c('gene','number','msp21','msp22','msp2b')

MSP2<-cbind(MSP2[,1:2],MSP2[,3:5]-1)

write.table(MSP2,file ="/Final/Total/MSP2.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(table1,table2,table3,temp1,temp2,temp3,MSP2)

ls()

####################################################################################################

#MSH1

a1<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,33])
	a1<-c(a1,temp)
	}

b1<-rep.int(1,sum(data11[,33]))

rm(i,temp)

a2<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,34])
	a2<-c(a2,temp)
	}
	
rm(i,temp)

b2<-rep.int(2,sum(data11[,34]))

a3<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,35])
	a3<-c(a3,temp)
	}

b3<-rep.int(3,sum(data11[,35]))

rm(i,temp)

a4<-c(a1,a2,a3)
b4<-c(b1,b2,b3)

rm(a1,a2,a3,b1,b2,b3)

c<-c(1:length(a4))

d<-sample(c,min,replace = FALSE)

e<-a4[d]
f<-b4[d]

rm(a4,b4,c,d)

g<-data.frame(t(g<-rbind(e,f)))

rm(e,f)

h<-subset(g, g[,2] == 1)
colnames(h)<-c('number','set')
j<-subset(g, g[,2] == 2)
colnames(j)<-c('number','set')
k<-subset(g, g[,2] == 3)
colnames(k)<-c('number','set')

rm(g)

h2<-rbind(h,genes2)
h2<-h2[,1]
rm(h)

j2<-rbind(j,genes2)
j2<-j2[,1]
rm(j)

k2<-rbind(k,genes2)
k2<-k2[,1]
rm(k)

table1<-data.frame(table1<-table(h2))
colnames(table1)<-c('number','table1')
table2<-data.frame(table2<-table(j2))
colnames(table2)<-c('number','table2')
table3<-data.frame(table3<-table(k2))
colnames(table3)<-c('number','table3')

rm(k2,j2,h2)

temp1<-merge(key,table1, by = 'number')
temp2<-merge(temp1,table2, by = 'number')
temp3<-merge(temp2,table3, by = 'number')

MSH1<-merge(genenames,temp3, by = 'gene')

colnames(MSH1)<-c('gene','number','msh11','msh12','msh1b')

MSH1<-cbind(MSH1[,1:2],MSH1[,3:5]-1)

write.table(MSH1,file ="/Final/Total/MSH1.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(table1,table2,table3,temp1,temp2,temp3,MSH1)

ls()

####################################################################################################

#MSH2

a1<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,36])
	a1<-c(a1,temp)
	}

b1<-rep.int(1,sum(data11[,36]))

rm(i,temp)

a2<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,37])
	a2<-c(a2,temp)
	}
	
rm(i,temp)

b2<-rep.int(2,sum(data11[,37]))

a3<-c()
for (i in data11[,2]) {
	temp<-rep.int(i,data11[i,38])
	a3<-c(a3,temp)
	}

b3<-rep.int(3,sum(data11[,38]))

rm(i,temp)

a4<-c(a1,a2,a3)
b4<-c(b1,b2,b3)

rm(a1,a2,a3,b1,b2,b3)

c<-c(1:length(a4))

d<-sample(c,min,replace = FALSE)

e<-a4[d]
f<-b4[d]

rm(a4,b4,c,d)

g<-data.frame(t(g<-rbind(e,f)))

rm(e,f)

h<-subset(g, g[,2] == 1)
colnames(h)<-c('number','set')
j<-subset(g, g[,2] == 2)
colnames(j)<-c('number','set')
k<-subset(g, g[,2] == 3)
colnames(k)<-c('number','set')

rm(g)

h2<-rbind(h,genes2)
h2<-h2[,1]
rm(h)

j2<-rbind(j,genes2)
j2<-j2[,1]
rm(j)

k2<-rbind(k,genes2)
k2<-k2[,1]
rm(k)

table1<-data.frame(table1<-table(h2))
colnames(table1)<-c('number','table1')
table2<-data.frame(table2<-table(j2))
colnames(table2)<-c('number','table2')
table3<-data.frame(table3<-table(k2))
colnames(table3)<-c('number','table3')

rm(k2,j2,h2)

temp1<-merge(key,table1, by = 'number')
temp2<-merge(temp1,table2, by = 'number')
temp3<-merge(temp2,table3, by = 'number')

MSH2<-merge(genenames,temp3, by = 'gene')

colnames(MSH2)<-c('gene','number','msh21','msh22','msh2b')

MSH2<-cbind(MSH2[,1:2],MSH2[,3:5]-1)

write.table(MSH2,file ="/Final/Total/MSH2.txt",sep="\t",quote=FALSE,row.names=FALSE)


rm(table1,table2,table3,temp1,temp2,temp3,genes,min,key,MSH2)

ls()

proc.time()-ptm

rm(list = ls())

####################################################################################################
####################################################################################################
# Make output files
####################################################################################################
####################################################################################################
#read data back in

MMP1<-read.delim("/Final/Total/MMP1.txt", header = TRUE)
MMP2<-read.delim("/Final/Total/MMP2.txt", header = TRUE)
MMH1<-read.delim("/Final/Total/MMH1.txt", header = TRUE)
MMH2<-read.delim("/Final/Total/MMH2.txt", header = TRUE)

SSP1<-read.delim("/Final/Total/SSP1.txt", header = TRUE)
SSP2<-read.delim("/Final/Total/SSP2.txt", header = TRUE)
SSH1<-read.delim("/Final/Total/SSH1.txt", header = TRUE)
SSH2<-read.delim("/Final/Total/SSH2.txt", header = TRUE)

MSP1<-read.delim("/Final/Total/MSP1.txt", header = TRUE)
MSP2<-read.delim("/Final/Total/MSP2.txt", header = TRUE)
MSH1<-read.delim("/Final/Total/MSH1.txt", header = TRUE)
MSH2<-read.delim("/Final/Total/MSH2.txt", header = TRUE)

genenames<-read.delim("/Final/Total/genenames.txt", header = TRUE)

all<-read.delim("/Final/Total/before_downsample.txt", header = TRUE)


#total expression outputs

MMPH1<-data.frame(MMPH1<-cbind(genenames, (MMP1[,3]+MMP2[,3]),(MMP1[,4]+MMP2[,4]),(MMP1[,5]+MMP2[,5]),MMH1[,3:5]))
colnames(MMPH1)<-c('gene','mmp1','mmp2','mmpb','mmh11','mmh12','mmh1b')

MMPH2<-data.frame(MMPH2<-cbind(genenames, (MMP1[,3]+MMP2[,3]),(MMP1[,4]+MMP2[,4]),(MMP1[,5]+MMP2[,5]),MMH2[,3:5]))
colnames(MMPH2)<-c('gene','mmp1','mmp2','mmpb','mmh21','mmh22','mmh2b')

MMH1H2<-data.frame(MMH1H2<-cbind(genenames, MMH1[,3:5],MMH2[,3:5]))
colnames(MMH1H2)<-c('gene','mmh11','mmh12','mmh1b','mmh21','mmh22','mmh2b')


SSPH1<-data.frame(SSPH1<-cbind(genenames, (SSP1[,3]+SSP2[,3]),(SSP1[,4]+SSP2[,4]),(SSP1[,5]+SSP2[,5]),SSH1[,3:5]))
colnames(SSPH1)<-c('gene','ssp1','ssp2','sspb','ssh11','ssh12','ssh1b')

SSPH2<-data.frame(SSPH2<-cbind(genenames, (SSP1[,3]+SSP2[,3]),(SSP1[,4]+SSP2[,4]),(SSP1[,5]+SSP2[,5]),SSH2[,3:5]))
colnames(SSPH2)<-c('gene','ssp1','ssp2','sspb','ssh21','ssh22','ssh2b')

SSH1H2<-data.frame(SSH1H2<-cbind(genenames,SSH1[,3:5],SSH2[,3:5]))
colnames(SSH1H2)<-c('gene','ssh11','ssh12','ssh1b','ssh21','ssh22','ssh2b')


MSPH1<-data.frame(MSPH1<-cbind(genenames, (MSP1[,3]+MSP2[,3]),(MSP1[,4]+MSP2[,4]),(MSP1[,5]+MSP2[,5]),MSH1[,3:5]))
colnames(MSPH1)<-c('gene','msp1','msp2','mspb','msh11','msh12','msh1b')

MSPH2<-data.frame(MSPH2<-cbind(genenames, (MSP1[,3]+MSP2[,3]),(MSP1[,4]+MSP2[,4]),(MSP1[,5]+MSP2[,5]),MSH2[,3:5]))
colnames(MSPH2)<-c('gene','msp1','msp2','mspb','msh21','msh22','msh2b')

MSH1H2<-data.frame(MSH1H2<-cbind(genenames,MSH1[,3:5],MSH2[,3:5]))
colnames(MSH1H2)<-c('gene','msh11','msh12','msh1b','msh21','msh22','msh2b')


write.table(MMPH1,file ="/Final/zhr_z30/mel-mel_P+H1/zhr+z30_zhrXz30_mRNA.mosaik.genes_down.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(MMPH2,file ="/Final/zhr_z30/mel-mel_P+H2/zhr+z30_z30Xzhr_mRNA.mosaik.genes_down.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(MMH1H2,file ="/Final/zhr_z30/mel-mel_H1+H2/zhrXz30_z30Xzhr_mRNA.mosaik.genes_down.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(SSPH1,file ="/Final/sim_sec/sim-sec_P+H1/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA.mosaik.genes_down.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(SSPH2,file ="/Final/sim_sec/sim-sec_P+H2/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA.mosaik.genes_down.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(SSH1H2,file ="/Final/sim_sec/sim-sec_H1+H2/tsimbazazaXdroSec1_droSec1Xtsimbazaza_mRNA.mosaik.genes_down.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(MSPH1,file ="/Final/mel_sim/mel-sim_P+H1/zhr+tsimbazaza_zhrXtsimbazaza_mRNA.mosaik.genes_down.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(MSPH2,file ="/Final/mel_sim/mel-sim_P+H2/zhr+tsimbazaza_tsimbazazaXzhr_mRNA.mosaik.genes_down.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(MSH1H2,file ="/Final/mel_sim/mel-sim_H1+H2/zhrXtsimbazaza_tsimbazazaXzhr_mRNA.mosaik.genes_down.txt",sep="\t",quote=FALSE,row.names=FALSE)

#rm(MMPH1,MMPH2,MMH1H2,SSPH1,SSPH2,SSH1H2,MSPH1,MSPH2,MSH1H2)

####################################################################################################
####################################################################################################
# Filter to > 20 reads
####################################################################################################
####################################################################################################
#data processing for total expression

dataGENENAMES<-(data.frame(dataGENENAMES<-MMP1[,1]))
dataMMP1<-data.frame(dataMMP1<-cbind(dataGENENAMES,(MMP1[,3]+MMP1[,4]+MMP1[,5])))
colnames(dataMMP1)<-c('gene','count')

dataGENENAMES<-(data.frame(dataGENENAMES<-MMP2[,1]))
dataMMP2<-data.frame(dataMMP2<-cbind(dataGENENAMES,(MMP2[,3]+MMP2[,4]+MMP2[,5])))
colnames(dataMMP2)<-c('gene','count')

dataGENENAMES<-(data.frame(dataGENENAMES<-SSP1[,1]))
dataSSP1<-data.frame(dataSSP1<-cbind(dataGENENAMES,(SSP1[,3]+SSP1[,4]+SSP1[,5])))
colnames(dataSSP1)<-c('gene','count')

dataGENENAMES<-(data.frame(dataGENENAMES<-SSP2[,1]))
dataSSP2<-data.frame(dataSSP2<-cbind(dataGENENAMES,(SSP2[,3]+SSP2[,4]+SSP2[,5])))
colnames(dataSSP2)<-c('gene','count')

dataGENENAMES<-(data.frame(dataGENENAMES<-MSP1[,1]))
dataMSP1<-data.frame(dataMSP1<-cbind(dataGENENAMES,(MSP1[,3]+MSP1[,4]+MSP1[,5])))
colnames(dataMSP1)<-c('gene','count')

dataGENENAMES<-(data.frame(dataGENENAMES<-MSP2[,1]))
dataMSP2<-data.frame(dataMSP2<-cbind(dataGENENAMES,(MSP2[,3]+MSP2[,4]+MSP2[,5])))
colnames(dataMSP2)<-c('gene','count')

dataGENENAMES<-(data.frame(dataGENENAMES<-MMH1[,1]))
dataMMH1<-data.frame(dataMMH1<-cbind(dataGENENAMES,(MMH1[,3]+MMH1[,4]+MMH1[,5])))
colnames(dataMMH1)<-c('gene','count')

dataGENENAMES<-(data.frame(dataGENENAMES<-MMH2[,1]))
dataMMH2<-data.frame(dataMMH2<-cbind(dataGENENAMES,(MMH2[,3]+MMH2[,4]+MMH2[,5])))
colnames(dataMMH2)<-c('gene','count')

dataGENENAMES<-(data.frame(dataGENENAMES<-SSH1[,1]))
dataSSH1<-data.frame(dataSSH1<-cbind(dataGENENAMES,(SSH1[,3]+SSH1[,4]+SSH1[,5])))
colnames(dataSSH1)<-c('gene','count')

dataGENENAMES<-(data.frame(dataGENENAMES<-SSH2[,1]))
dataSSH2<-data.frame(dataSSH2<-cbind(dataGENENAMES,(SSH2[,3]+SSH2[,4]+SSH2[,5])))
colnames(dataSSH2)<-c('gene','count')

dataGENENAMES<-(data.frame(dataGENENAMES<-MSH1[,1]))
dataMSH1<-data.frame(dataMSH1<-cbind(dataGENENAMES,(MSH1[,3]+MSH1[,4]+MSH1[,5])))
colnames(dataMSH1)<-c('gene','count')

dataGENENAMES<-(data.frame(dataGENENAMES<-MSH2[,1]))
dataMSH2<-data.frame(dataMSH2<-cbind(dataGENENAMES,(MSH2[,3]+MSH2[,4]+MSH2[,5])))
colnames(dataMSH2)<-c('gene','count')


dataMMP1<-subset(dataMMP1, ((dataMMP1[,2]) >= 20))
dataMMP2<-subset(dataMMP2, ((dataMMP2[,2]) >= 20))
dataSSP1<-subset(dataSSP1, ((dataSSP1[,2]) >= 20))
dataSSP2<-subset(dataSSP2, ((dataSSP2[,2]) >= 20))
dataMSP1<-subset(dataMSP1, ((dataMSP1[,2]) >= 20))
dataMSP2<-subset(dataMSP2, ((dataMSP2[,2]) >= 20))

dataMMH1<-subset(dataMMH1, (dataMMH1[,2] >= 20))
dataMMH2<-subset(dataMMH2, (dataMMH2[,2] >= 20))
dataSSH1<-subset(dataSSH1, (dataSSH1[,2] >= 20))
dataSSH2<-subset(dataSSH2, (dataSSH2[,2] >= 20))
dataMSH1<-subset(dataMSH1, (dataMSH1[,2] >= 20))
dataMSH2<-subset(dataMSH2, (dataMSH2[,2] >= 20))

rm(all,MMP1,MMP2,MMH1,MMH2,SSP1,SSP2,SSH1,SSH2,MSP1,MSP2,MSH1,MSH2,MMPH1,MMPH2,MMH1H2,SSPH1,SSPH2,SSH1H2,MSPH1,MSPH2,MSH1H2)

####################################################################################################

#count number of genes

data1<-merge(dataMMP1, dataMSP1, by = 'gene')
data2<-merge(data1, dataMMP2, by = 'gene')
data3<-merge(data2, dataSSP1, by = 'gene')
data4<-merge(data3, dataMSP2, by = 'gene')
data5<-merge(data4, dataSSP2, by = 'gene')
data6<-merge(data5, dataMMH1, by = 'gene')
data7<-merge(data6, dataMMH2, by = 'gene')
data8<-merge(data7, dataSSH1, by = 'gene')
data9<-merge(data8, dataSSH2, by = 'gene')
data10<-merge(data9, dataMSH1, by = 'gene')
data11<-merge(data10, dataMSH2, by = 'gene')
nrow(data11)
dataGENES<-data11[,1]
dataGENES<-data.frame(as.factor(dataGENES))
colnames(dataGENES) <- c('gene')

rm(data1,data2,data3,data4,data5,data6,data7,data8,data9,data10,data11)

write.table(dataGENES,file ="/Final/total-genes.txt",sep="\t",quote=FALSE,row.names=FALSE)

MMP1_TOTAL<-merge(dataGENES, MMP1, by = 'gene')
MMP2_TOTAL<-merge(dataGENES, MMP2, by = 'gene')
MMH1_TOTAL<-merge(dataGENES, MMH1, by = 'gene')
MMH2_TOTAL<-merge(dataGENES, MMH2, by = 'gene')

SSP1_TOTAL<-merge(dataGENES, SSP1, by = 'gene')
SSP2_TOTAL<-merge(dataGENES, SSP2, by = 'gene')
SSH1_TOTAL<-merge(dataGENES, SSH1, by = 'gene')
SSH2_TOTAL<-merge(dataGENES, SSH2, by = 'gene')

MSP1_TOTAL<-merge(dataGENES, MSP1, by = 'gene')
MSP2_TOTAL<-merge(dataGENES, MSP2, by = 'gene')
MSH1_TOTAL<-merge(dataGENES, MSH1, by = 'gene')
MSH2_TOTAL<-merge(dataGENES, MSH2, by = 'gene')

write.table(MMP1_TOTAL,file ="/Final/Total/MMP1_TOTAL.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(MMP2_TOTAL,file ="/Final/Total/MMP2_TOTAL.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(MMH1_TOTAL,file ="/Final/Total/MMH1_TOTAL.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(MMH2_TOTAL,file ="/Final/Total/MMH2_TOTAL.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(SSP1_TOTAL,file ="/Final/Total/SSP1_TOTAL.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(SSP2_TOTAL,file ="/Final/Total/SSP2_TOTAL.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(SSH1_TOTAL,file ="/Final/Total/SSH1_TOTAL.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(SSH2_TOTAL,file ="/Final/Total/SSH2_TOTAL.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(MSP1_TOTAL,file ="/Final/Total/MSP1_TOTAL.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(MSP2_TOTAL,file ="/Final/Total/MSP2_TOTAL.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(MSH1_TOTAL,file ="/Final/Total/MSH1_TOTAL.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(MSH2_TOTAL,file ="/Final/Total/MSH2_TOTAL.txt",sep="\t",quote=FALSE,row.names=FALSE)

####################################################################################################
####################################################################################################
#make merged files for comparisons

data1<-merge(dataMMP1, dataMMP2, by = 'gene')
data1<-merge(dataGENES,data1, by = 'gene')
data2<-merge(dataSSP1, dataSSP2, by = 'gene')
data2<-merge(dataGENES,data2, by = 'gene')
data3<-merge(dataMSP1, dataMSP2, by = 'gene')
data3<-merge(dataGENES,data3, by = 'gene')

data4<-merge(dataMMP1, dataMMH1, by = 'gene')
data4<-merge(dataGENES,data4, by = 'gene')
data5<-merge(dataMMP1, dataMMH2, by = 'gene')
data5<-merge(dataGENES,data5, by = 'gene')
data6<-merge(dataMMP2, dataMMH1, by = 'gene')
data6<-merge(dataGENES,data6, by = 'gene')
data7<-merge(dataMMP2, dataMMH2, by = 'gene')
data7<-merge(dataGENES,data7, by = 'gene')
data8<-merge(dataMMH1, dataMMH2, by = 'gene')
data8<-merge(dataGENES,data8, by = 'gene')

data9<-merge(dataSSP1, dataSSH1, by = 'gene')
data9<-merge(dataGENES,data9, by = 'gene')
data10<-merge(dataSSP1, dataSSH2, by = 'gene')
data10<-merge(dataGENES,data10, by = 'gene')
data11<-merge(dataSSP2, dataSSH1, by = 'gene')
data11<-merge(dataGENES,data11, by = 'gene')
data12<-merge(dataSSP2, dataSSH2, by = 'gene')
data12<-merge(dataGENES,data12, by = 'gene')
data13<-merge(dataSSH1, dataSSH2, by = 'gene')
data13<-merge(dataGENES,data13, by = 'gene')

data14<-merge(dataMSP1, dataMSH1, by = 'gene')
data14<-merge(dataGENES,data14, by = 'gene')
data15<-merge(dataMSP1, dataMSH2, by = 'gene')
data15<-merge(dataGENES,data15, by = 'gene')
data16<-merge(dataMSP2, dataMSH1, by = 'gene')
data16<-merge(dataGENES,data16, by = 'gene')
data17<-merge(dataMSP2, dataMSH2, by = 'gene')
data17<-merge(dataGENES,data17, by = 'gene')
data18<-merge(dataMSH1, dataMSH2, by = 'gene')
data18<-merge(dataGENES,data18, by = 'gene')


####################################################################################################
####################################################################################################
#spearman correlation coefficients

cor(data1[,2],data1[,3], method = c('s'))
cor(data2[,2],data2[,3], method = c('s'))
cor(data3[,2],data3[,3], method = c('s'))
cor(data4[,2],data4[,3], method = c('s'))
cor(data5[,2],data5[,3], method = c('s'))
cor(data6[,2],data6[,3], method = c('s'))
cor(data7[,2],data7[,3], method = c('s'))
cor(data8[,2],data8[,3], method = c('s'))
cor(data9[,2],data9[,3], method = c('s'))
cor(data10[,2],data10[,3], method = c('s'))
cor(data11[,2],data11[,3], method = c('s'))
cor(data12[,2],data12[,3], method = c('s'))
cor(data13[,2],data13[,3], method = c('s'))
cor(data14[,2],data14[,3], method = c('s'))
cor(data15[,2],data15[,3], method = c('s'))
cor(data16[,2],data16[,3], method = c('s'))
cor(data17[,2],data17[,3], method = c('s'))
cor(data18[,2],data18[,3], method = c('s'))

#R2 correlation coefficients

fit1<-lm(data1[,3]~data1[,2])
summary(fit1)
fit2<-lm(data2[,3]~data2[,2])
summary(fit2)
fit3<-lm(data3[,3]~data3[,2])
summary(fit3)
fit4<-lm(data4[,3]~data4[,2])
summary(fit4)
fit5<-lm(data5[,3]~data5[,2])
summary(fit5)
fit6<-lm(data6[,3]~data6[,2])
summary(fit6)
fit7<-lm(data7[,3]~data7[,2])
summary(fit7)
fit8<-lm(data8[,3]~data8[,2])
summary(fit8)
fit9<-lm(data9[,3]~data9[,2])
summary(fit9)
fit10<-lm(data10[,3]~data10[,2])
summary(fit10)
fit11<-lm(data11[,3]~data11[,2])
summary(fit11)
fit12<-lm(data12[,3]~data12[,2])
summary(fit12)
fit13<-lm(data13[,3]~data13[,2])
summary(fit13)
fit14<-lm(data14[,3]~data14[,2])
summary(fit14)
fit15<-lm(data15[,3]~data15[,2])
summary(fit15)
fit16<-lm(data16[,3]~data16[,2])
summary(fit16)
fit17<-lm(data17[,3]~data17[,2])
summary(fit17)
fit18<-lm(data18[,3]~data18[,2])
summary(fit18)

####################################################################################################
####################################################################################################
#plots
####################################################################################################
####################################################################################################
#separate parentals

pdf(file='/final/separate/zhr-z30_112213.pdf')
plot(log2(data1[,2]),log2(data1[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15))

dev.off()

pdf(file='/final/separate/sim-sec_112213.pdf')
plot(log2(data2[,2]),log2(data2[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15))

dev.off()

pdf(file='/final/separate/zhr-sim_112213.pdf')
plot(log2(data3[,2]),log2(data3[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15))

dev.off()

####################################################################################################
####################################################################################################
#parent vs hybrid

#zhr-z30

pdf(file='/final/separate/zhr-MMH1_112213.pdf')
plot(log2(data4[,2]),log2(data4[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15))

dev.off()

pdf(file='/final/separate/zhr-MMH2_112213.pdf')
plot(log2(data5[,2]),log2(data5[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15))

dev.off()

pdf(file='/final/separate/z30-MMH1_112213.pdf')
plot(log2(data6[,2]),log2(data6[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15))

dev.off()

pdf(file='/final/separate/z30-MMH2_112213.pdf')
plot(log2(data7[,2]),log2(data7[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15))

dev.off()

#sim-sec

pdf(file='/final/separate/sim-SSH1_112213.pdf')
plot(log2(data9[,2]),log2(data9[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15))

dev.off()


pdf(file='/final/separate/sim-SSH2_112213.pdf')
plot(log2(data10[,2]),log2(data10[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15))

dev.off()


pdf(file='/final/separate/sec-SSH1_112213.pdf')
plot(log2(data11[,2]),log2(data11[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15))

dev.off()


pdf(file='/final/separate/sec-SSH2_112213.pdf')
plot(log2(data12[,2]),log2(data12[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15))

dev.off()

#mel-sim

pdf(file='/final/separate/mel-MSH1_112213.pdf')
plot(log2(data14[,2]),log2(data14[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15))

dev.off()

pdf(file='/final/separate/mel-MSH2_112213.pdf')
plot(log2(data15[,2]),log2(data15[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15))

dev.off()

pdf(file='/final/separate/sim-MSH1_112213.pdf')
plot(log2(data16[,2]),log2(data16[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15))

dev.off()

pdf(file='/final/separate/sim-MSH2_112213.pdf')
plot(log2(data17[,2]),log2(data17[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15))

dev.off()

####################################################################################################
####################################################################################################
#hybrid vs hybrid/parent of origin

pdf(file='/final/separate/MMH1-MMH2_112213.pdf')
plot(log2(data8[,2]),log2(data8[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15))

dev.off()

pdf(file='/final/separate/SSH1-SSH2_112213.pdf')
plot(log2(data13[,2]),log2(data13[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15))

dev.off()

pdf(file='/final/separate/MSH1-MSH2_112213.pdf')
plot(log2(data18[,2]),log2(data18[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15))

dev.off()


####################################################################################################
####################################################################################################
#Allele 1 vs Allele 2
####################################################################################################
####################################################################################################
#perform comparison of allelic expression

dataA<-read.delim("/Final/zhr_z30/mel-mel_H1+H2/zhrXz30_z30Xzhr_mRNA.mosaik.genes_down.txt",header = TRUE)

dataB<-read.delim("/Final/sim_sec/sim-sec_H1+H2/tsimbazazaXdroSec1_droSec1Xtsimbazaza_mRNA.mosaik.genes_down.txt",header = TRUE)

dataC<-read.delim("/Final/mel_sim/mel-sim_H1+H2/zhrXtsimbazaza_tsimbazazaXzhr_mRNA.mosaik.genes_down.txt",header = TRUE)

#mel-mel hybrids = dataA
#sim-sec hybrids = dataB
#mel-sim hybrids = dataC

#hybrids
dataMMH1A<-dataA[,1:3]
colnames(dataMMH1A)<-c('gene','zhr','z30')
#dataMMH1A<-subset(dataMMH1A,((dataMMH1A[,2] > 20) & (dataMMH1A[,3] > 20)))
dataMMH1A<-merge(dataGENES, dataMMH1A, by = 'gene')

dataMMH2A<-cbind(dataA[,1], dataA[,5:6])
colnames(dataMMH2A)<-c('gene','zhr','z30')
#dataMMH2A<-subset(dataMMH2A,((dataMMH2A[,2] > 20) & (dataMMH2A[,3] > 20)))
dataMMH2A<-merge(dataGENES, dataMMH2A, by = 'gene')

dataSSH1A<-dataB[,1:3]
colnames(dataSSH1A)<-c('gene','sim','sec')
#dataSSH1A<-subset(dataSSH1A,((dataSSH1A[,2] > 20) & (dataSSH1A[,3] > 20)))
dataSSH1A<-merge(dataGENES, dataSSH1A, by = 'gene')

dataSSH2A<-cbind(dataB[,1], dataB[,5:6])
colnames(dataSSH2A)<-c('gene','sim','sec')
#dataSSH2A<-subset(dataSSH2A,((dataSSH2A[,2] > 20) & (dataSSH2A[,3] > 20)))
dataSSH2A<-merge(dataGENES, dataSSH2A, by = 'gene')

dataMSH1A<-dataC[,1:3]
colnames(dataMSH1A)<-c('gene','mel','sim')
#dataMSH1A<-subset(dataMSH1A,((dataMSH1A[,2] > 20) & (dataMSH1A[,3] > 20)))
dataMSH1A<-merge(dataGENES, dataMSH1A, by = 'gene')

dataMSH2A<-cbind(dataC[,1], dataC[,5:6])
colnames(dataMSH2A)<-c('gene','mel','sim')
#dataMSH2A<-subset(dataMSH2A,((dataMSH2A[,2] > 20) & (dataMSH2A[,3] > 20)))
dataMSH2A<-merge(dataGENES, dataMSH2A, by = 'gene')

####################################################################################################
####################################################################################################
#plots

#mel-mel H1 A1 vs A2

pdf(file='/final/separate/MMH1_A1vsA2_112213.pdf')
plot(log2(dataMMH1A[,2]),log2(dataMMH1A[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(melXsim)',ylab='log2(simXmel)')

dev.off()

####################################################################################################

#mel-mel H2 A1 vs A2

pdf(file='/final/separate/MMH2_A1vsA2_112213.pdf')
plot(log2(dataMMH2A[,2]),log2(dataMMH2A[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(melXsim)',ylab='log2(simXmel)')

dev.off()

####################################################################################################

#sim-sec H1 A1 vs A2

pdf(file='/final/separate/SSH1_A1vsA2_112213.pdf')
plot(log2(dataSSH1A[,2]),log2(dataSSH1A[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(melXsim)',ylab='log2(simXmel)')

dev.off()

####################################################################################################

#sim-sec H2 A1 vs A2

pdf(file='/final/separate/SSH2_A1vsA2_112213.pdf')
plot(log2(dataSSH2A[,2]),log2(dataSSH2A[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(melXsim)',ylab='log2(simXmel)')

dev.off()

####################################################################################################

#mel-sim H1 A1 vs A2

pdf(file='/final/separate/MSH1_A1vsA2_112213.pdf')
plot(log2(dataMSH1A[,2]),log2(dataMSH1A[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(melXsim)',ylab='log2(simXmel)')

dev.off()

####################################################################################################

#mel-sim H2 A1 vs A2

pdf(file='/final/separate/MSH2_A1vsA2_112213.pdf')
plot(log2(dataMSH2A[,2]),log2(dataMSH2A[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(melXsim)',ylab='log2(simXmel)')

dev.off()

####################################################################################################
####################################################################################################

dataMMH1A<-dataA[,1:3]
colnames(dataMMH1A)<-c('gene','zhr','z30')
#dataMMH1A<-subset(dataMMH1A,((dataMMH1A[,2] + dataMMH1A[,3]) > 20))
#dataMMH1A<-subset(dataMMH1A,((dataMMH1A[,2] > 1) & (dataMMH1A[,3] > 1)))
dataMMH1A<-merge(dataGENES, dataMMH1A, by = 'gene')


dataMMH2A<-cbind(dataA[,1], dataA[,5:6])
colnames(dataMMH2A)<-c('gene','zhr','z30')
#dataMMH2A<-subset(dataMMH2A,((dataMMH2A[,2] + dataMMH2A[,3]) > 20))
#dataMMH2A<-subset(dataMMH2A,((dataMMH2A[,2] > 1) & (dataMMH2A[,3] > 1)))
dataMMH2A<-merge(dataGENES, dataMMH2A, by = 'gene')

dataSSH1A<-dataB[,1:3]
colnames(dataSSH1A)<-c('gene','sim','sec')
#dataSSH1A<-subset(dataSSH1A,((dataSSH1A[,2] + dataSSH1A[,3]) > 20))
#dataSSH1A<-subset(dataSSH1A,((dataSSH1A[,2] > 1) & (dataSSH1A[,3] > 1)))
dataSSH1A<-merge(dataGENES, dataSSH1A, by = 'gene')

dataSSH2A<-cbind(dataB[,1], dataB[,5:6])
colnames(dataSSH2A)<-c('gene','sim','sec')
#dataSSH2A<-subset(dataSSH2A,((dataSSH2A[,2] + dataSSH2A[,3]) > 20))
#dataSSH2A<-subset(dataSSH2A,((dataSSH2A[,2] > 1) & (dataSSH2A[,3] > 1)))
dataSSH2A<-merge(dataGENES, dataSSH2A, by = 'gene')

dataMSH1A<-dataC[,1:3]
colnames(dataMSH1A)<-c('gene','mel','sim')
#dataMSH1A<-subset(dataMSH1A,((dataMSH1A[,2] + dataMSH1A[,3]) > 20))
#dataMSH1A<-subset(dataMSH1A,((dataMSH1A[,2] > 1) & (dataMSH1A[,3] > 1)))
dataMSH1A<-merge(dataGENES, dataMSH1A, by = 'gene')

dataMSH2A<-cbind(dataC[,1], dataC[,5:6])
colnames(dataMSH2A)<-c('gene','mel','sim')
#dataMSH2A<-subset(dataMSH2A,((dataMSH2A[,2] + dataMSH2A[,3]) > 20))
#dataMSH2A<-subset(dataMSH2A,((dataMSH2A[,2] > 1) & (dataMSH2A[,3] > 1)))
dataMSH2A<-merge(dataGENES, dataMSH2A, by = 'gene')

####################################################################################################
####################################################################################################
#calculate spearman correlation coefficients

cor(log2(dataMMH1A[,2]),log2(dataMMH1A[,3]), method = c("s"))
cor(log2(dataMMH2A[,2]),log2(dataMMH2A[,3]), method = c("s"))
cor(log2(dataSSH1A[,2]),log2(dataSSH1A[,3]), method = c("s"))
cor(log2(dataSSH2A[,2]),log2(dataSSH2A[,3]), method = c("s"))
cor(log2(dataMSH1A[,2]),log2(dataMSH1A[,3]), method = c("s"))
cor(log2(dataMSH2A[,2]),log2(dataMSH2A[,3]), method = c("s"))

####################################################################################################
####################################################################################################
# significance tests
####################################################################################################
####################################################################################################

# Analysis of Data1

Par1_FET <- NULL;
pvalsPar1 <- NULL;

psum1 = round((sum(data1[,2])+sum(data1[,3]))/2)

for (i in 1:nrow(data1)) 

	{
	Par1_FET <- fisher.test(matrix(c(data1[i,2],(psum1-data1[i,2]),data1[i,3],(psum1-data1[i,3])),nr=2));
	pvalsPar1 <- rbind(pvalsPar1, Par1_FET$p.value);
	}

#FDR correct pvalues
pvalsPar1.adj <- p.adjust(pvalsPar1,method="fdr");
data1$pvalsPar1.adj<-pvalsPar1.adj

write.table(data1, file = "/Final/Meta/MM_112213.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(i)

####################################################################################################
####################################################################################################

# Analysis of Data2

Par2_FET <- NULL;
pvalsPar2 <- NULL;

psum2 = round((sum(data2[,2])+sum(data2[,3]))/2)

for (i in 1:nrow(data2)) 

	{
	Par2_FET <- fisher.test(matrix(c(data2[i,2],(psum2-data2[i,2]),data2[i,3],(psum2-data2[i,3])),nr=2));
	pvalsPar2 <- rbind(pvalsPar2, Par2_FET$p.value);
	}

#FDR correct pvalues
pvalsPar2.adj <- p.adjust(pvalsPar2,method="fdr");
data2$pvalsPar2.adj<-pvalsPar2.adj

write.table(data2, file = "/Final/Meta/SS_112213.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(i)

####################################################################################################
####################################################################################################

# Analysis of Data3

Par3_FET <- NULL;
pvalsPar3 <- NULL;

psum3 = round((sum(data3[,2])+sum(data3[,3]))/2)

for (i in 1:nrow(data3)) 

	{
	Par3_FET <- fisher.test(matrix(c(data3[i,2],(psum3-data3[i,2]),data3[i,3],(psum3-data3[i,3])),nr=2));
	pvalsPar3 <- rbind(pvalsPar3, Par3_FET$p.value);
	}

#FDR correct pvalues
pvalsPar3.adj <- p.adjust(pvalsPar3,method="fdr");
data3$pvalsPar3.adj<-pvalsPar3.adj

write.table(data3, file = "/Final/Meta/MS_112213.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(i)

####################################################################################################
####################################################################################################

# Analysis of Data4

Par4_FET <- NULL;
pvalsPar4 <- NULL;

psum4 = round((sum(data4[,2])+sum(data4[,3]))/2)

for (i in 1:nrow(data4)) 

	{
	Par4_FET <- fisher.test(matrix(c(data4[i,2],(psum4-data4[i,2]),data4[i,3],(psum4-data4[i,3])),nr=2));
	pvalsPar4 <- rbind(pvalsPar4, Par4_FET$p.value);
	}

#FDR correct pvalues
pvalsPar4.adj <- p.adjust(pvalsPar4,method="fdr");
data4$pvalsPar4.adj<-pvalsPar4.adj

write.table(data4, file = "/Final/Meta/ZHR1H1_112213.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(i)

####################################################################################################
####################################################################################################

# Analysis of Data5

Par5_FET <- NULL;
pvalsPar5 <- NULL;

psum5 = round((sum(data5[,2])+sum(data5[,3]))/2)

for (i in 1:nrow(data5)) 

	{
	Par5_FET <- fisher.test(matrix(c(data5[i,2],(psum5-data5[i,2]),data5[i,3],(psum5-data5[i,3])),nr=2));
	pvalsPar5 <- rbind(pvalsPar5, Par5_FET$p.value);
	}

#FDR correct pvalues
pvalsPar5.adj <- p.adjust(pvalsPar5,method="fdr");
data5$pvalsPar5.adj<-pvalsPar5.adj

write.table(data5, file = "/Final/Meta/ZHR1H2_112213.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(i)

####################################################################################################
####################################################################################################

# Analysis of Data6

Par6_FET <- NULL;
pvalsPar6 <- NULL;

psum6 = round((sum(data6[,2])+sum(data6[,3]))/2)

for (i in 1:nrow(data6)) 

	{
	Par6_FET <- fisher.test(matrix(c(data6[i,2],(psum6-data6[i,2]),data6[i,3],(psum6-data6[i,3])),nr=2));
	pvalsPar6 <- rbind(pvalsPar6, Par6_FET$p.value);
	}

#FDR correct pvalues
pvalsPar6.adj <- p.adjust(pvalsPar6,method="fdr");
data6$pvalsPar6.adj<-pvalsPar6.adj

write.table(data6, file = "/Final/Meta/Z30H1_112213.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(i)

####################################################################################################
####################################################################################################

# Analysis of Data7

Par7_FET <- NULL;
pvalsPar7 <- NULL;

psum7 = round((sum(data7[,2])+sum(data7[,3]))/2)

for (i in 1:nrow(data7)) 

	{
	Par7_FET <- fisher.test(matrix(c(data7[i,2],(psum7-data7[i,2]),data7[i,3],(psum7-data7[i,3])),nr=2));
	pvalsPar7 <- rbind(pvalsPar7, Par7_FET$p.value);
	}

#FDR correct pvalues
pvalsPar7.adj <- p.adjust(pvalsPar7,method="fdr");
data7$pvalsPar7.adj<-pvalsPar7.adj

write.table(data7, file = "/Final/Meta/Z30H2_112213.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(i)

####################################################################################################
####################################################################################################

# Analysis of Data8

Par8_FET <- NULL;
pvalsPar8 <- NULL;

psum8 = round((sum(data8[,2])+sum(data8[,3]))/2)

for (i in 1:nrow(data8)) 

	{
	Par8_FET <- fisher.test(matrix(c(data8[i,2],(psum8-data8[i,2]),data8[i,3],(psum8-data8[i,3])),nr=2));
	pvalsPar8 <- rbind(pvalsPar8, Par8_FET$p.value);
	}

#FDR correct pvalues
pvalsPar8.adj <- p.adjust(pvalsPar8,method="fdr");
data8$pvalsPar8.adj<-pvalsPar8.adj

write.table(data8, file = "/Final/Meta/MMPoO_112213.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(i)

####################################################################################################
####################################################################################################

# Analysis of Data9

Par9_FET <- NULL;
pvalsPar9 <- NULL;

psum9 = round((sum(data9[,2])+sum(data9[,3]))/2)

for (i in 1:nrow(data9)) 

	{
	Par9_FET <- fisher.test(matrix(c(data9[i,2],(psum9-data9[i,2]),data9[i,3],(psum9-data9[i,3])),nr=2));
	pvalsPar9 <- rbind(pvalsPar9, Par9_FET$p.value);
	}

#FDR correct pvalues
pvalsPar9.adj <- p.adjust(pvalsPar9,method="fdr");
data9$pvalsPar9.adj<-pvalsPar9.adj

write.table(data9, file = "/Final/Meta/SIM1H1_112213.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(i)

####################################################################################################
####################################################################################################

# Analysis of Data10

Par10_FET <- NULL;
pvalsPar10 <- NULL;

psum10 = round((sum(data10[,2])+sum(data10[,3]))/2)

for (i in 1:nrow(data10)) 

	{
	Par10_FET <- fisher.test(matrix(c(data10[i,2],(psum10-data10[i,2]),data10[i,3],(psum10-data10[i,3])),nr=2));
	pvalsPar10 <- rbind(pvalsPar10, Par10_FET$p.value);
	}

#FDR correct pvalues
pvalsPar10.adj <- p.adjust(pvalsPar10,method="fdr");
data10$pvalsPar10.adj<-pvalsPar10.adj

write.table(data10, file = "/Final/Meta/SIM1H2_112213.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(i)

####################################################################################################
####################################################################################################

# Analysis of Data11

Par11_FET <- NULL;
pvalsPar11 <- NULL;

psum11 = round((sum(data11[,2])+sum(data11[,3]))/2)

for (i in 1:nrow(data11)) 

	{
	Par11_FET <- fisher.test(matrix(c(data11[i,2],(psum11-data11[i,2]),data11[i,3],(psum11-data11[i,3])),nr=2));
	pvalsPar11 <- rbind(pvalsPar11, Par11_FET$p.value);
	}

#FDR correct pvalues
pvalsPar11.adj <- p.adjust(pvalsPar11,method="fdr");
data11$pvalsPar11.adj<-pvalsPar11.adj

write.table(data9, file = "/Final/Meta/SECH1_112213.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(i)

####################################################################################################
####################################################################################################

# Analysis of Data12

Par12_FET <- NULL;
pvalsPar12 <- NULL;

psum12 = round((sum(data12[,2])+sum(data12[,3]))/2)

for (i in 1:nrow(data12)) 

	{
	Par12_FET <- fisher.test(matrix(c(data12[i,2],(psum12-data12[i,2]),data12[i,3],(psum12-data12[i,3])),nr=2));
	pvalsPar12 <- rbind(pvalsPar12, Par12_FET$p.value);
	}

#FDR correct pvalues
pvalsPar12.adj <- p.adjust(pvalsPar12,method="fdr");
data12$pvalsPar12.adj<-pvalsPar12.adj

write.table(data11, file = "/Final/Meta/SECH2_112213.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(i)

####################################################################################################
####################################################################################################

# Analysis of Data13

Par13_FET <- NULL;
pvalsPar13 <- NULL;

psum13 = round((sum(data13[,2])+sum(data13[,3]))/2)

for (i in 1:nrow(data13)) 

	{
	Par13_FET <- fisher.test(matrix(c(data13[i,2],(psum13-data13[i,2]),data13[i,3],(psum13-data13[i,3])),nr=2));
	pvalsPar13 <- rbind(pvalsPar13, Par13_FET$p.value);
	}

#FDR correct pvalues
pvalsPar13.adj <- p.adjust(pvalsPar13,method="fdr");
data13$pvalsPar13.adj<-pvalsPar13.adj

write.table(data13, file = "/Final/Meta/SSPoO_112213.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(i)

####################################################################################################
####################################################################################################

# Analysis of Data14

Par14_FET <- NULL;
pvalsPar14 <- NULL;

psum14 = round((sum(data14[,2])+sum(data14[,3]))/2)

for (i in 1:nrow(data14)) 

	{
	Par14_FET <- fisher.test(matrix(c(data14[i,2],(psum14-data14[i,2]),data14[i,3],(psum14-data14[i,3])),nr=2));
	pvalsPar14 <- rbind(pvalsPar14, Par14_FET$p.value);
	}

#FDR correct pvalues
pvalsPar14.adj <- p.adjust(pvalsPar14,method="fdr");
data14$pvalsPar14.adj<-pvalsPar14.adj

write.table(data14, file = "/Final/Meta/ZHR2H1_112213.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(i)

####################################################################################################
####################################################################################################

# Analysis of Data15

Par15_FET <- NULL;
pvalsPar15 <- NULL;

psum15 = round((sum(data15[,2])+sum(data15[,3]))/2)

for (i in 1:nrow(data15)) 

	{
	Par15_FET <- fisher.test(matrix(c(data15[i,2],(psum15-data15[i,2]),data15[i,3],(psum15-data15[i,3])),nr=2));
	pvalsPar15 <- rbind(pvalsPar15, Par15_FET$p.value);
	}

#FDR correct pvalues
pvalsPar15.adj <- p.adjust(pvalsPar15,method="fdr");
data15$pvalsPar15.adj<-pvalsPar15.adj

write.table(data15, file = "/Final/Meta/ZHR2H2_112213.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(i)

####################################################################################################
####################################################################################################

# Analysis of Data16

Par16_FET <- NULL;
pvalsPar16 <- NULL;

psum16 = round((sum(data16[,2])+sum(data16[,3]))/2)

for (i in 1:nrow(data16)) 

	{
	Par16_FET <- fisher.test(matrix(c(data16[i,2],(psum16-data16[i,2]),data16[i,3],(psum16-data16[i,3])),nr=2));
	pvalsPar16 <- rbind(pvalsPar16, Par16_FET$p.value);
	}

#FDR correct pvalues
pvalsPar16.adj <- p.adjust(pvalsPar16,method="fdr");
data16$pvalsPar16.adj<-pvalsPar16.adj

write.table(data16, file = "/Final/Meta/SIM2H1_112213.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(i)

####################################################################################################
####################################################################################################

# Analysis of Data17

Par17_FET <- NULL;
pvalsPar17 <- NULL;

psum17 = round((sum(data17[,2])+sum(data17[,3]))/2)

for (i in 1:nrow(data17)) 

	{
	Par17_FET <- fisher.test(matrix(c(data17[i,2],(psum17-data17[i,2]),data17[i,3],(psum17-data17[i,3])),nr=2));
	pvalsPar17 <- rbind(pvalsPar17, Par17_FET$p.value);
	}

#FDR correct pvalues
pvalsPar17.adj <- p.adjust(pvalsPar17,method="fdr");
data17$pvalsPar17.adj<-pvalsPar17.adj

write.table(data17, file = "/Final/Meta/SIM2H2_112213.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(i)

####################################################################################################
####################################################################################################

# Analysis of Data18

Par18_FET <- NULL;
pvalsPar18 <- NULL;

psum18 = round((sum(data18[,2])+sum(data18[,3]))/2)

for (i in 1:nrow(data18)) 

	{
	Par18_FET <- fisher.test(matrix(c(data18[i,2],(psum18-data18[i,2]),data18[i,3],(psum18-data18[i,3])),nr=2));
	pvalsPar18 <- rbind(pvalsPar18, Par18_FET$p.value);
	}

#FDR correct pvalues
pvalsPar18.adj <- p.adjust(pvalsPar18,method="fdr");
data18$pvalsPar18.adj<-pvalsPar18.adj

write.table(data18, file = "/Final/Meta/MSPoO_112213.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(i)

####################################################################################################

nrow(subset<-subset(data1,data1[,4] < 0.05))
nrow(subset<-subset(data2,data2[,4] < 0.05))
nrow(subset<-subset(data3,data3[,4] < 0.05))
nrow(subset<-subset(data4,data4[,4] < 0.05))
nrow(subset<-subset(data5,data5[,4] < 0.05))
nrow(subset<-subset(data6,data6[,4] < 0.05))
nrow(subset<-subset(data7,data7[,4] < 0.05))
nrow(subset<-subset(data8,data8[,4] < 0.05))
nrow(subset<-subset(data9,data9[,4] < 0.05))
nrow(subset<-subset(data10,data10[,4] < 0.05))
nrow(subset<-subset(data11,data11[,4] < 0.05))
nrow(subset<-subset(data12,data12[,4] < 0.05))
nrow(subset<-subset(data13,data13[,4] < 0.05))
nrow(subset<-subset(data14,data14[,4] < 0.05))
nrow(subset<-subset(data15,data15[,4] < 0.05))
nrow(subset<-subset(data16,data16[,4] < 0.05))
nrow(subset<-subset(data17,data17[,4] < 0.05))
nrow(subset<-subset(data18,data18[,4] < 0.05))

####################################################################################################
####################################################################################################
####################################################################################################

rm(list=ls())

####################################################################################################
####################################################################################################
#Genomics plots

#make log ratios

data1$log2rat<-log2(data1[,2]/data1[,3])
data2$log2rat<-log2(data2[,2]/data2[,3])
data3$log2rat<-log2(data3[,2]/data3[,3])

####################################################################################################
####################################################################################################

#merge data

data20<-merge(dataGENES,data1, by = 'gene')
data20a<-merge(data20, data2, by='gene')
data21<-merge(data20a, data3, by='gene')

####################################################################################################
####################################################################################################

#column atributes

#1:gene
#zhr-z30		sim-sec		zhr-sim
#2:species1		6			10
#3:species2		7			11
#4:p-value		8			12
#5:log2rat		9			13

####################################################################################################
####################################################################################################

#9 patterns

one<-subset(data21, (((abs(data21[,5]) - abs(data21[,9])) > log2(1.25)) & ((abs(data21[,9]) - abs(data21[,13])) > log2(1.25))))
two<-subset(data21, (((abs(data21[,5]) - abs(data21[,9])) > log2(1.25)) & ((abs(data21[,9]) - abs(data21[,13])) < -log2(1.25))))
three<-subset(data21, (((abs(data21[,5]) - abs(data21[,9])) > log2(1.25)) & (abs((abs(data21[,9]) - abs(data21[,13]))) < log2(1.25))))
four<-subset(data21, ((abs((abs(data21[,5]) - abs(data21[,9]))) < log2(1.25)) & ((abs(data21[,9]) - abs(data21[,13])) > log2(1.25))))
five<-subset(data21, ((abs((abs(data21[,5]) - abs(data21[,9]))) < log2(1.25)) & ((abs(data21[,9]) - abs(data21[,13])) < -log2(1.25))))
six<-subset(data21, ((abs((abs(data21[,5]) - abs(data21[,9]))) < log2(1.25)) & (abs((abs(data21[,9]) - abs(data21[,13]))) < log2(1.25))))
seven<-subset(data21, (((abs(data21[,5]) - abs(data21[,9])) < -log2(1.25)) & ((abs(data21[,9]) - abs(data21[,13])) > log2(1.25))))
eight<-subset(data21, (((abs(data21[,5]) - abs(data21[,9])) < -log2(1.25)) & ((abs(data21[,9]) - abs(data21[,13])) < -log2(1.25))))
nine<-subset(data21, (((abs(data21[,5]) - abs(data21[,9])) < -log2(1.25)) & (abs((abs(data21[,9]) - abs(data21[,13]))) < log2(1.25))))

nrow(one)
nrow(two)
nrow(three)
nrow(four)
nrow(five)
nrow(six)
nrow(seven)
nrow(eight)
nrow(nine)


sech<-subset(data21, ((abs(data21[,7]) > log2(1.25)) & (abs(data21[,10]) < log2(1.25))))

sim<-subset(data21, ((abs(data21[,7]) > log2(1.25)) & (abs(data21[,10]) > log2(1.25)) & ((abs(data21[,7]) - abs(data21[,10])) < log2(1.25)) & ((abs(data21[,7]) - abs(data21[,10])) < -log2(1.25))))

write.table(one[,1], file = "/Final/Total/one.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(two[,1], file = "/Final/Total/two.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(three[,1], file = "/Final/Total/three.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(four[,1], file = "/Final/Total/four.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(five[,1], file = "/Final/Total/five.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(six[,1], file = "/Final/Total/six.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(seven[,1], file = "/Final/Total/seven.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(eight[,1], file = "/Final/Total/eight.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(nine[,1], file = "/Final/Total/nine.txt",sep="\t",quote=FALSE,row.names=FALSE)

summary(abs(one[,5]))
summary(abs(one[,9]))
summary(abs(one[,13]))

summary(abs(two[,5]))
summary(abs(two[,9]))
summary(abs(two[,13]))

summary(abs(three[,5]))
summary(abs(three[,9]))
summary(abs(three[,13]))

summary(abs(four[,5]))
summary(abs(four[,9]))
summary(abs(four[,13]))

summary(abs(five[,5]))
summary(abs(five[,9]))
summary(abs(five[,13]))

summary(abs(six[,5]))
summary(abs(six[,9]))
summary(abs(six[,13]))

summary(abs(seven[,5]))
summary(abs(seven[,9]))
summary(abs(seven[,13]))

summary(abs(eight[,5]))
summary(abs(eight[,9]))
summary(abs(eight[,13]))

summary(abs(nine[,5]))
summary(abs(nine[,9]))
summary(abs(nine[,13]))


#six$ave<-((abs(six[,4])+abs(six[,7])+abs(six[,10]))/3)
#sixsmall<-subset(six,(six[,20] < log2(1.25)))

####################################################################################################
####################################################################################################
#make plots
####################################################################################################
####################################################################################################

pdf(file='/Final/Figs/one_parental_112213.pdf')

one1<-cbind(abs(one[,5]),abs(one[,9]),abs(one[,13]))
one1trans<-t(one1)
one1data<-data.frame(one1)
one1data$MM=0.4171861
one1data$SS=2.866096
one1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(one1data[,4],one1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(one1data[,5],one1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(one1data[,6],one1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(one1data[,4],one1data[,1],one1data[,5],one1data[,2])
segments(one1data[,5],one1data[,2],one1data[,6],one1data[,3])

dev.off()

pdf(file='/Final/Figs/two_parental_112213.pdf')

####################################################################################################

two1<-cbind(abs(two[,5]),abs(two[,9]),abs(two[,13]))
two1trans<-t(two1)
two1data<-data.frame(two1)
two1data$MM=0.4171861
two1data$SS=2.866096
two1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(two1data[,4],two1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(two1data[,5],two1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(two1data[,6],two1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(two1data[,4],two1data[,1],two1data[,5],two1data[,2])
segments(two1data[,5],two1data[,2],two1data[,6],two1data[,3])

dev.off()

pdf(file='/Final/Figs/three_parental_112213.pdf')

####################################################################################################

three1<-cbind(abs(three[,5]),abs(three[,9]),abs(three[,13]))
three1trans<-t(three1)
three1data<-data.frame(three1)
three1data$MM=0.4171861
three1data$SS=2.866096
three1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(three1data[,4],three1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(three1data[,5],three1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(three1data[,6],three1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(three1data[,4],three1data[,1],three1data[,5],three1data[,2])
segments(three1data[,5],three1data[,2],three1data[,6],three1data[,3])

dev.off()

pdf(file='/Final/Figs/four_parental_112213.pdf')

####################################################################################################

four1<-cbind(abs(four[,5]),abs(four[,9]),abs(four[,13]))
four1trans<-t(four1)
four1data<-data.frame(four1)
four1data$MM=0.4171861
four1data$SS=2.866096
four1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(four1data[,4],four1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(four1data[,5],four1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(four1data[,6],four1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(four1data[,4],four1data[,1],four1data[,5],four1data[,2])
segments(four1data[,5],four1data[,2],four1data[,6],four1data[,3])

dev.off()

pdf(file='/Final/Figs/five_parental_112213.pdf')

####################################################################################################

five1<-cbind(abs(five[,5]),abs(five[,9]),abs(five[,13]))
five1trans<-t(five1)
five1data<-data.frame(five1)
five1data$MM=0.4171861
five1data$SS=2.866096
five1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(five1data[,4],five1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(five1data[,5],five1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(five1data[,6],five1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(five1data[,4],five1data[,1],five1data[,5],five1data[,2])
segments(five1data[,5],five1data[,2],five1data[,6],five1data[,3])

dev.off()

pdf(file='/Final/Figs/six_parental_112213.pdf')

####################################################################################################

six1<-cbind(abs(six[,5]),abs(six[,9]),abs(six[,13]))
six1trans<-t(six1)
six1data<-data.frame(six1)
six1data$MM=0.4171861
six1data$SS=2.866096
six1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(six1data[,4],six1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(six1data[,5],six1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(six1data[,6],six1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(six1data[,4],six1data[,1],six1data[,5],six1data[,2])
segments(six1data[,5],six1data[,2],six1data[,6],six1data[,3])

dev.off()

pdf(file='/Final/Figs/seven_parental_112213.pdf')

####################################################################################################

seven1<-cbind(abs(seven[,5]),abs(seven[,9]),abs(seven[,13]))
seven1trans<-t(seven1)
seven1data<-data.frame(seven1)
seven1data$MM=0.4171861
seven1data$SS=2.866096
seven1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(seven1data[,4],seven1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(seven1data[,5],seven1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(seven1data[,6],seven1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(seven1data[,4],seven1data[,1],seven1data[,5],seven1data[,2])
segments(seven1data[,5],seven1data[,2],seven1data[,6],seven1data[,3])

dev.off()

pdf(file='/Final/Figs/eight_parental_112213.pdf')

####################################################################################################

eight1<-cbind(abs(eight[,5]),abs(eight[,9]),abs(eight[,13]))
eight1trans<-t(eight1)
eight1data<-data.frame(eight1)
eight1data$MM=0.4171861
eight1data$SS=2.866096
eight1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(eight1data[,4],eight1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(eight1data[,5],eight1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(eight1data[,6],eight1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(eight1data[,4],eight1data[,1],eight1data[,5],eight1data[,2])
segments(eight1data[,5],eight1data[,2],eight1data[,6],eight1data[,3])

dev.off()

pdf(file='/Final/Figs/nine_parental_112213.pdf')

####################################################################################################

nine1<-cbind(abs(nine[,5]),abs(nine[,9]),abs(nine[,13]))
nine1trans<-t(nine1)
nine1data<-data.frame(nine1)
nine1data$MM=0.4171861
nine1data$SS=2.866096
nine1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(nine1data[,4],nine1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(nine1data[,5],nine1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(nine1data[,6],nine1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(nine1data[,4],nine1data[,1],nine1data[,5],nine1data[,2])
segments(nine1data[,5],nine1data[,2],nine1data[,6],nine1data[,3])

dev.off()


####################################################################################################
####################################################################################################

####################################################################################################
####################################################################################################
#make plots
####################################################################################################
####################################################################################################

pdf(file='/Final/Figs/one_parental_B_112213.pdf')

one1<-cbind(abs(one[,5]),abs(one[,9]),abs(one[,13]))
one1trans<-t(one1)
one1data<-data.frame(one1)
one1data$MM=0.4171861
one1data$SS=2.866096
one1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(one1data[,4],one1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(one1data[,5],one1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(one1data[,6],one1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(one1data[,4],one1data[,1],one1data[,5],one1data[,2])
segments(one1data[,5],one1data[,2],one1data[,6],one1data[,3])

points(0.4171861,1.65,col = 'red',pch=19,cex=2)
points(2.866096,0.94,col = 'red',pch=19,cex=2)
points(6.367003,0.33,col = 'red',pch=19,cex=2)

segments(0.4171861,1.65,2.866096,0.94, col = 'red',lwd = 8)
segments(2.866096,0.94,6.367003,0.33, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/two_parental_B_112213.pdf')

####################################################################################################

two1<-cbind(abs(two[,5]),abs(two[,9]),abs(two[,13]))
two1trans<-t(two1)
two1data<-data.frame(two1)
two1data$MM=0.4171861
two1data$SS=2.866096
two1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(two1data[,4],two1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(two1data[,5],two1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(two1data[,6],two1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(two1data[,4],two1data[,1],two1data[,5],two1data[,2])
segments(two1data[,5],two1data[,2],two1data[,6],two1data[,3])

points(0.4171861,1.03,col = 'red',pch=19,cex=2)
points(2.866096,0.2,col = 'red',pch=19,cex=2)
points(6.367003,1.09,col = 'red',pch=19,cex=2)

segments(0.4171861,1.03,2.866096,0.2, col = 'red',lwd = 8)
segments(2.866096,0.2,6.367003,1.09, col = 'red',lwd = 8)


dev.off()

pdf(file='/Final/Figs/three_parental_B_112213.pdf')

####################################################################################################

three1<-cbind(abs(three[,5]),abs(three[,9]),abs(three[,13]))
three1trans<-t(three1)
three1data<-data.frame(three1)
three1data$MM=0.4171861
three1data$SS=2.866096
three1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(three1data[,4],three1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(three1data[,5],three1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(three1data[,6],three1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(three1data[,4],three1data[,1],three1data[,5],three1data[,2])
segments(three1data[,5],three1data[,2],three1data[,6],three1data[,3])

points(0.4171861,0.78,col = 'red',pch=19,cex=2)
points(2.866096,0.24,col = 'red',pch=19,cex=2)
points(6.367003,0.34,col = 'red',pch=19,cex=2)

segments(0.4171861,0.78,2.866096,0.24, col = 'red',lwd = 8)
segments(2.866096,0.24,6.367003,0.34, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/four_parental_B_112213.pdf')

####################################################################################################

four1<-cbind(abs(four[,5]),abs(four[,9]),abs(four[,13]))
four1trans<-t(four1)
four1data<-data.frame(four1)
four1data$MM=0.4171861
four1data$SS=2.866096
four1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(four1data[,4],four1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(four1data[,5],four1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(four1data[,6],four1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(four1data[,4],four1data[,1],four1data[,5],four1data[,2])
segments(four1data[,5],four1data[,2],four1data[,6],four1data[,3])

points(0.4171861,0.49,col = 'red',pch=19,cex=2)
points(2.866096,0.62,col = 'red',pch=19,cex=2)
points(6.367003,0.12,col = 'red',pch=19,cex=2)

segments(0.4171861,0.49,2.866096,0.62, col = 'red',lwd = 8)
segments(2.866096,0.62,6.367003,0.12, col = 'red',lwd = 8)


dev.off()

pdf(file='/Final/Figs/five_parental_B_112213.pdf')

####################################################################################################

five1<-cbind(abs(five[,5]),abs(five[,9]),abs(five[,13]))
five1trans<-t(five1)
five1data<-data.frame(five1)
five1data$MM=0.4171861
five1data$SS=2.866096
five1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(five1data[,4],five1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(five1data[,5],five1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(five1data[,6],five1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(five1data[,4],five1data[,1],five1data[,5],five1data[,2])
segments(five1data[,5],five1data[,2],five1data[,6],five1data[,3])

points(0.4171861,0.31,col = 'red',pch=19,cex=2)
points(2.866096,0.22,col = 'red',pch=19,cex=2)
points(6.367003,0.78,col = 'red',pch=19,cex=2)

segments(0.4171861,0.31,2.866096,0.22, col = 'red',lwd = 8)
segments(2.866096,0.22,6.367003,0.78, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/six_parental_B_112213.pdf')

####################################################################################################

six1<-cbind(abs(six[,5]),abs(six[,9]),abs(six[,13]))
six1trans<-t(six1)
six1data<-data.frame(six1)
six1data$MM=0.4171861
six1data$SS=2.866096
six1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(six1data[,4],six1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(six1data[,5],six1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(six1data[,6],six1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(six1data[,4],six1data[,1],six1data[,5],six1data[,2])
segments(six1data[,5],six1data[,2],six1data[,6],six1data[,3])

points(0.4171861,0.22,col = 'red',pch=19,cex=2)
points(2.866096,0.22,col = 'red',pch=19,cex=2)
points(6.367003,0.23,col = 'red',pch=19,cex=2)

segments(0.4171861,0.22,2.866096,0.22, col = 'red',lwd = 8)
segments(2.866096,0.22,6.367003,0.23, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/seven_parental_B_112213.pdf')

####################################################################################################

seven1<-cbind(abs(seven[,5]),abs(seven[,9]),abs(seven[,13]))
seven1trans<-t(seven1)
seven1data<-data.frame(seven1)
seven1data$MM=0.4171861
seven1data$SS=2.866096
seven1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(seven1data[,4],seven1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(seven1data[,5],seven1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(seven1data[,6],seven1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(seven1data[,4],seven1data[,1],seven1data[,5],seven1data[,2])
segments(seven1data[,5],seven1data[,2],seven1data[,6],seven1data[,3])

points(0.4171861,0.24,col = 'red',pch=19,cex=2)
points(2.866096,1.04,col = 'red',pch=19,cex=2)
points(6.367003,0.29,col = 'red',pch=19,cex=2)

segments(0.4171861,0.24,2.866096,1.04, col = 'red',lwd = 8)
segments(2.866096,1.04,6.367003,0.29, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/eight_parental_B_112213.pdf')

####################################################################################################

eight1<-cbind(abs(eight[,5]),abs(eight[,9]),abs(eight[,13]))
eight1trans<-t(eight1)
eight1data<-data.frame(eight1)
eight1data$MM=0.4171861
eight1data$SS=2.866096
eight1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(eight1data[,4],eight1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(eight1data[,5],eight1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(eight1data[,6],eight1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(eight1data[,4],eight1data[,1],eight1data[,5],eight1data[,2])
segments(eight1data[,5],eight1data[,2],eight1data[,6],eight1data[,3])

points(0.4171861,0.27,col = 'red',pch=19,cex=2)
points(2.866096,1.05,col = 'red',pch=19,cex=2)
points(6.367003,1.79,col = 'red',pch=19,cex=2)

segments(0.4171861,0.27,2.866096,1.05, col = 'red',lwd = 8)
segments(2.866096,1.05,6.367003,1.79, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/nine_parental_B_112213.pdf')

####################################################################################################

nine1<-cbind(abs(nine[,5]),abs(nine[,9]),abs(nine[,13]))
nine1trans<-t(nine1)
nine1data<-data.frame(nine1)
nine1data$MM=0.4171861
nine1data$SS=2.866096
nine1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(nine1data[,4],nine1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(nine1data[,5],nine1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(nine1data[,6],nine1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(nine1data[,4],nine1data[,1],nine1data[,5],nine1data[,2])
segments(nine1data[,5],nine1data[,2],nine1data[,6],nine1data[,3])

points(0.4171861,0.15,col = 'red',pch=19,cex=2)
points(2.866096,0.71,col = 'red',pch=19,cex=2)
points(6.367003,0.63,col = 'red',pch=19,cex=2)

segments(0.4171861,0.15,2.866096,0.71, col = 'red',lwd = 8)
segments(2.866096,0.71,6.367003,0.63, col = 'red',lwd = 8)

dev.off()

####################################################################################################
####################################################################################################
#dominance classifications
####################################################################################################
####################################################################################################
#make data frames

totalGENES<-read.delim("/Final/total-genes.txt", header = TRUE)

data1b<-merge(dataMMP1,dataMMP2, by = 'gene')
data1b<-merge(data1b,dataMMH1, by = 'gene')
data1b<-merge(totalGENES, data1b, by = 'gene')

data2b<-merge(dataMMP1,dataMMP2, by = 'gene')
data2b<-merge(data2b,dataMMH2, by = 'gene')
data2b<-merge(totalGENES, data2b, by = 'gene')

data3b<-merge(dataSSP1,dataSSP2, by = 'gene')
data3b<-merge(data3b,dataSSH1, by = 'gene')
data3b<-merge(totalGENES, data3b, by = 'gene')

data4b<-merge(dataSSP1,dataSSP2, by = 'gene')
data4b<-merge(data4b,dataSSH2, by = 'gene')
data4b<-merge(totalGENES, data4b, by = 'gene')

data5b<-merge(dataMSP1,dataMSP2, by = 'gene')
data5b<-merge(data5b,dataMSH1, by = 'gene')
data5b<-merge(totalGENES, data5b, by = 'gene')

data6b<-merge(dataMSP1,dataMSP2, by = 'gene')
data6b<-merge(data6b,dataMSH2, by = 'gene')
data6b<-merge(totalGENES, data6b, by = 'gene')


####################################################################################################
####################################################################################################
####################################################################################################
# MMH1 dominance

for (i in 1:nrow(data1b)) 
	{
	if (data1b[i,2] == 0) {data1b[i,2] = 1} else {data1b[i,2] == data1b[i,2]}
	if (data1b[i,3] == 0) {data1b[i,3] = 1} else {data1b[i,3] == data1b[i,3]}
	if (data1b[i,4] == 0) {data1b[i,4] = 1} else {data1b[i,4] == data1b[i,4]}
	}

#5
data1b$H_P1diff = ((log2(((data1b[,4])/(sum(data1b[,4])))*100)) - (log2(((data1b[,2])/sum(data1b[,2]))*100)))
#6
data1b$H_P2diff = ((log2(((data1b[,4])/(sum(data1b[,4])))*100)) - (log2(((data1b[,3])/sum(data1b[,3]))*100)))

#7
data1b$additive = c(2:2)
#8
data1b$underdominant = c(2:2)
#9
data1b$overdominant = c(2:2)
#10
data1b$par1dominant = c(2:2)
#11
data1b$par2dominant = c(2:2)
#12
data1b$conserved2 = c(2:2)

for (j in 1:nrow(data1b)) 
	{
	if (((data1b[j,5] < (-log2(1.25))) && (data1b[j,6] > log2(1.25))) || ((data1b[j,5] > log2(1.25)) && (data1b[j,6] < (-log2(1.25))))) {data1b[j,7] = 1} else {data1b[j,7] = 0}
	if ((data1b[j,5] < (-log2(1.25))) && (data1b[j,6] < (-log2(1.25)))) {data1b[j,8] = 1} else {data1b[j,8] = 0}
	if ((data1b[j,5] > log2(1.25)) && (data1b[j,6] > log2(1.25))) {data1b[j,9] = 1} else {data1b[j,9] = 0}
	if (((data1b[j,5] < -log2(1.25)) && (data1b[j,6] > -log2(1.25)) && (data1b[j,6] < log2(1.25))) || ((data1b[j,5] > log2(1.25)) && (data1b[j,6] > -log2(1.25)) && (data1b[j,6] < log2(1.25)))) {data1b[j,10] = 1} else {data1b[j,10] = 0}
	if (((data1b[j,5] > -log2(1.25)) && (data1b[j,5] < log2(1.25)) && (data1b[j,6] < (-log2(1.25)))) || ((data1b[j,5] > -log2(1.25)) && (data1b[j,5] < log2(1.25)) && (data1b[j,6] > log2(1.25)))) {data1b[j,11] = 1} else {data1b[j,11] = 0}
	if ((data1b[j,5] > -log2(1.25)) && (data1b[j,5] < log2(1.25)) && (data1b[j,6] < log2(1.25)) && (data1b[j,6] > -log2(1.25))) {data1b[j,12] = 1} else {data1b[j,12] = 0}
	}
	
write.table(data1b,  file = "/Final/zhr_z30/mel-mel_P+H1/outputs/total_dominance_MMH1_classified_B.txt",sep="\t",quote=FALSE,row.names=FALSE)

####################################################################################################
####################################################################################################
# MMH2 dominance

for (i in 1:nrow(data2b)) 
	{
	if (data2b[i,2] == 0) {data2b[i,2] = 1} else {data2b[i,2] == data2b[i,2]}
	if (data2b[i,3] == 0) {data2b[i,3] = 1} else {data2b[i,3] == data2b[i,3]}
	if (data2b[i,4] == 0) {data2b[i,4] = 1} else {data2b[i,4] == data2b[i,4]}
	}

#5
data2b$H_P1diff = ((log2(((data2b[,4])/(sum(data2b[,4])))*100)) - (log2(((data2b[,2])/sum(data2b[,2]))*100)))
#6
data2b$H_P2diff = ((log2(((data2b[,4])/(sum(data2b[,4])))*100)) - (log2(((data2b[,3])/sum(data2b[,3]))*100)))

#7
data2b$additive = c(2:2)
#8
data2b$underdominant = c(2:2)
#9
data2b$overdominant = c(2:2)
#10
data2b$par1dominant = c(2:2)
#11
data2b$par2dominant = c(2:2)
#12
data2b$conserved2 = c(2:2)

for (j in 1:nrow(data2b)) 
	{
	if (((data2b[j,5] < (-log2(1.25))) && (data2b[j,6] > log2(1.25))) || ((data2b[j,5] > log2(1.25)) && (data2b[j,6] < (-log2(1.25))))) {data2b[j,7] = 1} else {data2b[j,7] = 0}
	if ((data2b[j,5] < (-log2(1.25))) && (data2b[j,6] < (-log2(1.25)))) {data2b[j,8] = 1} else {data2b[j,8] = 0}
	if ((data2b[j,5] > log2(1.25)) && (data2b[j,6] > log2(1.25))) {data2b[j,9] = 1} else {data2b[j,9] = 0}
	if (((data2b[j,5] < -log2(1.25)) && (data2b[j,6] > -log2(1.25)) && (data2b[j,6] < log2(1.25))) || ((data2b[j,5] > log2(1.25)) && (data2b[j,6] > -log2(1.25)) && (data2b[j,6] < log2(1.25)))) {data2b[j,10] = 1} else {data2b[j,10] = 0}
	if (((data2b[j,5] > -log2(1.25)) && (data2b[j,5] < log2(1.25)) && (data2b[j,6] < (-log2(1.25)))) || ((data2b[j,5] > -log2(1.25)) && (data2b[j,5] < log2(1.25)) && (data2b[j,6] > log2(1.25)))) {data2b[j,11] = 1} else {data2b[j,11] = 0}
	if ((data2b[j,5] > -log2(1.25)) && (data2b[j,5] < log2(1.25)) && (data2b[j,6] < log2(1.25)) && (data2b[j,6] > -log2(1.25))) {data2b[j,12] = 1} else {data2b[j,12] = 0}
	}
	
write.table(data2b,  file = "/Final/zhr_z30/mel-mel_P+H2/outputs/total_dominance_MMH2_classified_B.txt",sep="\t",quote=FALSE,row.names=FALSE)

####################################################################################################
####################################################################################################
# SSH1 dominance

for (i in 1:nrow(data3b)) 
	{
	if (data3b[i,2] == 0) {data3b[i,2] = 1} else {data3b[i,2] == data3b[i,2]}
	if (data3b[i,3] == 0) {data3b[i,3] = 1} else {data3b[i,3] == data3b[i,3]}
	if (data3b[i,4] == 0) {data3b[i,4] = 1} else {data3b[i,4] == data3b[i,4]}
	}

#5
data3b$H_P1diff = ((log2(((data3b[,4])/(sum(data3b[,4])))*100)) - (log2(((data3b[,2])/sum(data3b[,2]))*100)))
#6
data3b$H_P2diff = ((log2(((data3b[,4])/(sum(data3b[,4])))*100)) - (log2(((data3b[,3])/sum(data3b[,3]))*100)))

#7
data3b$additive = c(2:2)
#8
data3b$underdominant = c(2:2)
#9
data3b$overdominant = c(2:2)
#10
data3b$par1dominant = c(2:2)
#11
data3b$par2dominant = c(2:2)
#12
data3b$conserved2 = c(2:2)

for (j in 1:nrow(data3b)) 
	{
	if (((data3b[j,5] < (-log2(1.25))) && (data3b[j,6] > log2(1.25))) || ((data3b[j,5] > log2(1.25)) && (data3b[j,6] < (-log2(1.25))))) {data3b[j,7] = 1} else {data3b[j,7] = 0}
	if ((data3b[j,5] < (-log2(1.25))) && (data3b[j,6] < (-log2(1.25)))) {data3b[j,8] = 1} else {data3b[j,8] = 0}
	if ((data3b[j,5] > log2(1.25)) && (data3b[j,6] > log2(1.25))) {data3b[j,9] = 1} else {data3b[j,9] = 0}
	if (((data3b[j,5] < -log2(1.25)) && (data3b[j,6] > -log2(1.25)) && (data3b[j,6] < log2(1.25))) || ((data3b[j,5] > log2(1.25)) && (data3b[j,6] > -log2(1.25)) && (data3b[j,6] < log2(1.25)))) {data3b[j,10] = 1} else {data3b[j,10] = 0}
	if (((data3b[j,5] > -log2(1.25)) && (data3b[j,5] < log2(1.25)) && (data3b[j,6] < (-log2(1.25)))) || ((data3b[j,5] > -log2(1.25)) && (data3b[j,5] < log2(1.25)) && (data3b[j,6] > log2(1.25)))) {data3b[j,11] = 1} else {data3b[j,11] = 0}
	if ((data3b[j,5] > -log2(1.25)) && (data3b[j,5] < log2(1.25)) && (data3b[j,6] < log2(1.25)) && (data3b[j,6] > -log2(1.25))) {data3b[j,12] = 1} else {data3b[j,12] = 0}
	}
	
write.table(data3b,  file = "/Final/sim_sec/sim-sec_P+H1/outputs/total_dominance_SSH1_classified_B.txt",sep="\t",quote=FALSE,row.names=FALSE)

####################################################################################################
####################################################################################################
# SSH2 dominance

for (i in 1:nrow(data4b)) 
	{
	if (data4b[i,2] == 0) {data4b[i,2] = 1} else {data4b[i,2] == data4b[i,2]}
	if (data4b[i,3] == 0) {data4b[i,3] = 1} else {data4b[i,3] == data4b[i,3]}
	if (data4b[i,4] == 0) {data4b[i,4] = 1} else {data4b[i,4] == data4b[i,4]}
	}

#5
data4b$H_P1diff = ((log2(((data4b[,4])/(sum(data4b[,4])))*100)) - (log2(((data4b[,2])/sum(data4b[,2]))*100)))
#6
data4b$H_P2diff = ((log2(((data4b[,4])/(sum(data4b[,4])))*100)) - (log2(((data4b[,3])/sum(data4b[,3]))*100)))

#7
data4b$additive = c(2:2)
#8
data4b$underdominant = c(2:2)
#9
data4b$overdominant = c(2:2)
#10
data4b$par1dominant = c(2:2)
#11
data4b$par2dominant = c(2:2)
#12
data4b$conserved2 = c(2:2)

for (j in 1:nrow(data4b)) 
	{
	if (((data4b[j,5] < (-log2(1.25))) && (data4b[j,6] > log2(1.25))) || ((data4b[j,5] > log2(1.25)) && (data4b[j,6] < (-log2(1.25))))) {data4b[j,7] = 1} else {data4b[j,7] = 0}
	if ((data4b[j,5] < (-log2(1.25))) && (data4b[j,6] < (-log2(1.25)))) {data4b[j,8] = 1} else {data4b[j,8] = 0}
	if ((data4b[j,5] > log2(1.25)) && (data4b[j,6] > log2(1.25))) {data4b[j,9] = 1} else {data4b[j,9] = 0}
	if (((data4b[j,5] < -log2(1.25)) && (data4b[j,6] > -log2(1.25)) && (data4b[j,6] < log2(1.25))) || ((data4b[j,5] > log2(1.25)) && (data4b[j,6] > -log2(1.25)) && (data4b[j,6] < log2(1.25)))) {data4b[j,10] = 1} else {data4b[j,10] = 0}
	if (((data4b[j,5] > -log2(1.25)) && (data4b[j,5] < log2(1.25)) && (data4b[j,6] < (-log2(1.25)))) || ((data4b[j,5] > -log2(1.25)) && (data4b[j,5] < log2(1.25)) && (data4b[j,6] > log2(1.25)))) {data4b[j,11] = 1} else {data4b[j,11] = 0}
	if ((data4b[j,5] > -log2(1.25)) && (data4b[j,5] < log2(1.25)) && (data4b[j,6] < log2(1.25)) && (data4b[j,6] > -log2(1.25))) {data4b[j,12] = 1} else {data4b[j,12] = 0}
	}
	
write.table(data4b,  file = "/Final/sim_sec/sim-sec_P+H2/outputs/total_dominance_SSH2_classified_B.txt",sep="\t",quote=FALSE,row.names=FALSE)

####################################################################################################
####################################################################################################
# MSH1 dominance

for (i in 1:nrow(data5b)) 
	{
	if (data5b[i,2] == 0) {data5b[i,2] = 1} else {data5b[i,2] == data5b[i,2]}
	if (data5b[i,3] == 0) {data5b[i,3] = 1} else {data5b[i,3] == data5b[i,3]}
	if (data5b[i,4] == 0) {data5b[i,4] = 1} else {data5b[i,4] == data5b[i,4]}
	}

#5
data5b$H_P1diff = ((log2(((data5b[,4])/(sum(data5b[,4])))*100)) - (log2(((data5b[,2])/sum(data5b[,2]))*100)))
#6
data5b$H_P2diff = ((log2(((data5b[,4])/(sum(data5b[,4])))*100)) - (log2(((data5b[,3])/sum(data5b[,3]))*100)))

#7
data5b$additive = c(2:2)
#8
data5b$underdominant = c(2:2)
#9
data5b$overdominant = c(2:2)
#10
data5b$par1dominant = c(2:2)
#11
data5b$par2dominant = c(2:2)
#12
data5b$conserved2 = c(2:2)

for (j in 1:nrow(data5b)) 
	{
	if (((data5b[j,5] < (-log2(1.25))) && (data5b[j,6] > log2(1.25))) || ((data5b[j,5] > log2(1.25)) && (data5b[j,6] < (-log2(1.25))))) {data5b[j,7] = 1} else {data5b[j,7] = 0}
	if ((data5b[j,5] < (-log2(1.25))) && (data5b[j,6] < (-log2(1.25)))) {data5b[j,8] = 1} else {data5b[j,8] = 0}
	if ((data5b[j,5] > log2(1.25)) && (data5b[j,6] > log2(1.25))) {data5b[j,9] = 1} else {data5b[j,9] = 0}
	if (((data5b[j,5] < -log2(1.25)) && (data5b[j,6] > -log2(1.25)) && (data5b[j,6] < log2(1.25))) || ((data5b[j,5] > log2(1.25)) && (data5b[j,6] > -log2(1.25)) && (data5b[j,6] < log2(1.25)))) {data5b[j,10] = 1} else {data5b[j,10] = 0}
	if (((data5b[j,5] > -log2(1.25)) && (data5b[j,5] < log2(1.25)) && (data5b[j,6] < (-log2(1.25)))) || ((data5b[j,5] > -log2(1.25)) && (data5b[j,5] < log2(1.25)) && (data5b[j,6] > log2(1.25)))) {data5b[j,11] = 1} else {data5b[j,11] = 0}
	if ((data5b[j,5] > -log2(1.25)) && (data5b[j,5] < log2(1.25)) && (data5b[j,6] < log2(1.25)) && (data5b[j,6] > -log2(1.25))) {data5b[j,12] = 1} else {data5b[j,12] = 0}
	}
	
write.table(data5b,  file = "/Final/mel_sim/mel-sim_P+H1/outputs/total_dominance_MSH1_classified_B.txt",sep="\t",quote=FALSE,row.names=FALSE)

####################################################################################################
####################################################################################################
# MSH2 dominance

for (i in 1:nrow(data6b)) 
	{
	if (data6b[i,2] == 0) {data6b[i,2] = 1} else {data6b[i,2] == data6b[i,2]}
	if (data6b[i,3] == 0) {data6b[i,3] = 1} else {data6b[i,3] == data6b[i,3]}
	if (data6b[i,4] == 0) {data6b[i,4] = 1} else {data6b[i,4] == data6b[i,4]}
	}

#5
data6b$H_P1diff = ((log2(((data6b[,4])/(sum(data6b[,4])))*100)) - (log2(((data6b[,2])/sum(data6b[,2]))*100)))
#6
data6b$H_P2diff = ((log2(((data6b[,4])/(sum(data6b[,4])))*100)) - (log2(((data6b[,3])/sum(data6b[,3]))*100)))

#7
data6b$additive = c(2:2)
#8
data6b$underdominant = c(2:2)
#9
data6b$overdominant = c(2:2)
#10
data6b$par1dominant = c(2:2)
#11
data6b$par2dominant = c(2:2)
#12
data6b$conserved2 = c(2:2)

for (j in 1:nrow(data6b)) 
	{
	if (((data6b[j,5] < (-log2(1.25))) && (data6b[j,6] > log2(1.25))) || ((data6b[j,5] > log2(1.25)) && (data6b[j,6] < (-log2(1.25))))) {data6b[j,7] = 1} else {data6b[j,7] = 0}
	if ((data6b[j,5] < (-log2(1.25))) && (data6b[j,6] < (-log2(1.25)))) {data6b[j,8] = 1} else {data6b[j,8] = 0}
	if ((data6b[j,5] > log2(1.25)) && (data6b[j,6] > log2(1.25))) {data6b[j,9] = 1} else {data6b[j,9] = 0}
	if (((data6b[j,5] < -log2(1.25)) && (data6b[j,6] > -log2(1.25)) && (data6b[j,6] < log2(1.25))) || ((data6b[j,5] > log2(1.25)) && (data6b[j,6] > -log2(1.25)) && (data6b[j,6] < log2(1.25)))) {data6b[j,10] = 1} else {data6b[j,10] = 0}
	if (((data6b[j,5] > -log2(1.25)) && (data6b[j,5] < log2(1.25)) && (data6b[j,6] < (-log2(1.25)))) || ((data6b[j,5] > -log2(1.25)) && (data6b[j,5] < log2(1.25)) && (data6b[j,6] > log2(1.25)))) {data6b[j,11] = 1} else {data6b[j,11] = 0}
	if ((data6b[j,5] > -log2(1.25)) && (data6b[j,5] < log2(1.25)) && (data6b[j,6] < log2(1.25)) && (data6b[j,6] > -log2(1.25))) {data6b[j,12] = 1} else {data6b[j,12] = 0}
	}
	
write.table(data6b,  file = "/Final/mel_sim/mel-sim_P+H2/outputs/total_dominance_MSH2_classified_B.txt",sep="\t",quote=FALSE,row.names=FALSE)

####################################################################################################
#SUMMARIZE DOMINANCE

#7 = additive 
#8 = underdominant 
#9 = overdominant 
#10 = par1dominant 
#11 = par2dominant 
#12 = conserved2 

#MMPH1

sum(data1b[,7])
sum(data1b[,8])
sum(data1b[,9])
sum(data1b[,10])
sum(data1b[,11])
sum(data1b[,12])

#MMPH2

sum(data2b[,7])
sum(data2b[,8])
sum(data2b[,9])
sum(data2b[,10])
sum(data2b[,11])
sum(data2b[,12])

#SSPH1

sum(data3b[,7])
sum(data3b[,8])
sum(data3b[,9])
sum(data3b[,10])
sum(data3b[,11])
sum(data3b[,12])

#SSPH2

sum(data4b[,7])
sum(data4b[,8])
sum(data4b[,9])
sum(data4b[,10])
sum(data4b[,11])
sum(data4b[,12])

#MSPH1

sum(data5b[,7])
sum(data5b[,8])
sum(data5b[,9])
sum(data5b[,10])
sum(data5b[,11])
sum(data5b[,12])

#MSPH2

sum(data6b[,7])
sum(data6b[,8])
sum(data6b[,9])
sum(data6b[,10])
sum(data6b[,11])
sum(data6b[,12])

####################################################################################################
####################################################################################################
#analyze dominance in total gene set
####################################################################################################
####################################################################################################
#columns

#5=data1$H_P1diff = ((log2(((data1[,4])/(sum(data1[,4])))*100)) - (log2(((data1[,2])/sum(data1[,2]))*100)))
#6=data1$H_P2diff = ((log2(((data1[,4])/(sum(data1[,4])))*100)) - (log2(((data1[,3])/sum(data1[,3]))*100)))
#7=data1$additive 
#8=data1$underdominant
#9=data1$overdominant
#10=data1$par1dominant
#11=data1$par2dominant
#12=data1$conserved2

####################################################################################################
####################################################################################################
####################################################################################################
rm(list = ls())

data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/total_dominance_MMH1_classified_B.txt",header = TRUE)
data3<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/total_dominance_SSH1_classified_B.txt",header = TRUE)
data5<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/total_dominance_MSH1_classified_B.txt",header = TRUE)

data2<-read.delim("/Final/zhr_z30/mel-mel_P+H2/outputs/total_dominance_MMH2_classified_B.txt",header = TRUE)
data4<-read.delim("/Final/sim_sec/sim-sec_P+H2/outputs/total_dominance_SSH2_classified_B.txt",header = TRUE)
data6<-read.delim("/Final/mel_sim/mel-sim_P+H2/outputs/total_dominance_MSH2_classified_B.txt",header = TRUE)

####################################################################################################
####################################################################################################
####################################################################################################
#plots

#MMH1

a1<-subset(data1,data1[,8] == 1)
b1<-subset(data1,data1[,7] == 1)
c1<-subset(data1,data1[,9] == 1)
d1<-subset(data1,data1[,10] == 1)
e1<-subset(data1,data1[,11] == 1)
f1<-subset(data1,data1[,12] == 1)

pdf(file = "/Final/Figs/MMH1_DOM_120113.pdf")

plot(data1[,5], data1[,6], type = "n", ylim = c(-10,10),xlim = c(-10,10),xlab="Parental", ylab="Hybrid")

#underdominant
points(a1[,5],a1[,6], col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#additive
points(b1[,5],b1[,6], col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#overdominant
points(c1[,5],c1[,6], col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par1 dominant
points(d1[,5],d1[,6], col=rgb(t(col2rgb("3")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par2 dominant
points(e1[,5],e1[,6],col=rgb(t(col2rgb("6")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#conserved
points(f1[,5],f1[,6], col=rgb(t(col2rgb("5")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

abline(h=0)
abline(v=0)
abline(a=0,b=1)

dev.off()

data11<-c(nrow(f1),nrow(b1),nrow(d1),nrow(e1),nrow(a1),nrow(c1),nrow(data1));
data111 <- matrix(data=data11,nrow=1, ncol=7, byrow=FALSE)
colnames(data111)<- c('Conserved','Additive','par1 Dominant','Par2 Dominant','Underdominant', 'Overdominant','total');

write.table(data111, file = "/Final/Figs/dominance_classified_MMH1_120113.txt",sep="\t",quote=FALSE,row.names=FALSE);

lblsdata1<-c('Conserved','Additive',"par1 Dominant","Par2 Dominant",'Underdominant', 'Overdominant')
colorsdata1<-c("5","orange","3","6","red","blue")
slicesdata1<-(data11[1:6]/data11[7])

pdf(file = "/Final/Figs/MMH1_domiance_pie_120113.pdf")

pie(slicesdata1,labels = lblsdata1, col = colorsdata1, main = "MMH1 dominance pie")

dev.off()

####################################################################################################
####################################################################################################
#plots

#MMH2

a1<-subset(data2,data2[,8] == 1)
b1<-subset(data2,data2[,7] == 1)
c1<-subset(data2,data2[,9] == 1)
d1<-subset(data2,data2[,10] == 1)
e1<-subset(data2,data2[,11] == 1)
f1<-subset(data2,data2[,12] == 1)

pdf(file = "/Final/Figs/MMH2_DOM_120113.pdf")

plot(data2[,5], data2[,6], type = "n", ylim = c(-10,10),xlim = c(-10,10),xlab="Parental", ylab="Hybrid")

#underdominant
points(a1[,5],a1[,6], col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#additive
points(b1[,5],b1[,6], col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#overdominant
points(c1[,5],c1[,6], col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par1 dominant
points(d1[,5],d1[,6], col=rgb(t(col2rgb("3")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par2 dominant
points(e1[,5],e1[,6],col=rgb(t(col2rgb("6")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#conserved
points(f1[,5],f1[,6], col=rgb(t(col2rgb("5")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

abline(h=0)
abline(v=0)
abline(a=0,b=1)

dev.off()

data21<-c(nrow(f1),nrow(b1),nrow(d1),nrow(e1),nrow(a1),nrow(c1),nrow(data2));
data211 <- matrix(data=data21,nrow=1, ncol=7, byrow=FALSE)
colnames(data211)<- c('Conserved','Additive','par1 Dominant','Par2 Dominant','Underdominant', 'Overdominant','total');

write.table(data211, file = "/Final/Figs/dominance_classified_MMH2_120113.txt",sep="\t",quote=FALSE,row.names=FALSE);

lblsdata2<-c('Conserved','Additive',"par1 Dominant","Par2 Dominant",'Underdominant', 'Overdominant')
colorsdata2<-c("5","orange","3","6","red","blue")
slicesdata2<-(data21[1:6]/data21[7])

pdf(file = "/Final/Figs/MMH2_domiance_pie_120113.pdf")

pie(slicesdata2,labels = lblsdata2, col = colorsdata2, main = "MMH2 dominance pie")

dev.off()

####################################################################################################
####################################################################################################
#plots

#SSH1

a1<-subset(data3,data3[,8] == 1)
b1<-subset(data3,data3[,7] == 1)
c1<-subset(data3,data3[,9] == 1)
d1<-subset(data3,data3[,10] == 1)
e1<-subset(data3,data3[,11] == 1)
f1<-subset(data3,data3[,12] == 1)

pdf(file = "/Final/Figs/SSH1_DOM_120113.pdf")

plot(data3[,5], data3[,6], type = "n", ylim = c(-10,10),xlim = c(-10,10),xlab="Parental", ylab="Hybrid")

#underdominant
points(a1[,5],a1[,6], col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#additive
points(b1[,5],b1[,6], col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#overdominant
points(c1[,5],c1[,6], col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par1 dominant
points(d1[,5],d1[,6], col=rgb(t(col2rgb("3")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par2 dominant
points(e1[,5],e1[,6],col=rgb(t(col2rgb("6")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#conserved
points(f1[,5],f1[,6], col=rgb(t(col2rgb("5")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

abline(h=0)
abline(v=0)
abline(a=0,b=1)

dev.off()

data31<-c(nrow(f1),nrow(b1),nrow(d1),nrow(e1),nrow(a1),nrow(c1),nrow(data3));
data311 <- matrix(data=data31,nrow=1, ncol=7, byrow=FALSE)
colnames(data311)<- c('Conserved','Additive','par1 Dominant','Par2 Dominant','Underdominant', 'Overdominant','total');

write.table(data311, file = "/Final/Figs/dominance_classified_SSH1_120113.txt",sep="\t",quote=FALSE,row.names=FALSE);

lblsdata3<-c('Conserved','Additive',"par1 Dominant","Par2 Dominant",'Underdominant', 'Overdominant')
colorsdata3<-c("5","orange","3","6","red","blue")
slicesdata3<-(data31[1:6]/data31[7])

pdf(file = "/Final/Figs/SSH1_domiance_pie_120113.pdf")

pie(slicesdata3,labels = lblsdata3, col = colorsdata3, main = "SSH1 dominance pie")

dev.off()

####################################################################################################
####################################################################################################
#plots

#SSH2

a1<-subset(data4,data4[,8] == 1)
b1<-subset(data4,data4[,7] == 1)
c1<-subset(data4,data4[,9] == 1)
d1<-subset(data4,data4[,10] == 1)
e1<-subset(data4,data4[,11] == 1)
f1<-subset(data4,data4[,12] == 1)

pdf(file = "/Final/Figs/SSH2_DOM_120113.pdf")

plot(data4[,5], data4[,6], type = "n", ylim = c(-10,10),xlim = c(-10,10),xlab="Parental", ylab="Hybrid")

#underdominant
points(a1[,5],a1[,6], col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#additive
points(b1[,5],b1[,6], col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#overdominant
points(c1[,5],c1[,6], col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par1 dominant
points(d1[,5],d1[,6], col=rgb(t(col2rgb("3")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par2 dominant
points(e1[,5],e1[,6],col=rgb(t(col2rgb("6")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#conserved
points(f1[,5],f1[,6], col=rgb(t(col2rgb("5")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

abline(h=0)
abline(v=0)
abline(a=0,b=1)

dev.off()

data41<-c(nrow(f1),nrow(b1),nrow(d1),nrow(e1),nrow(a1),nrow(c1),nrow(data4));
data411 <- matrix(data=data41,nrow=1, ncol=7, byrow=FALSE)
colnames(data411)<- c('Conserved','Additive','par1 Dominant','Par2 Dominant','Underdominant', 'Overdominant','total');

write.table(data411, file = "/Final/Figs/dominance_classified_SSH2_120113.txt",sep="\t",quote=FALSE,row.names=FALSE);

lblsdata4<-c('Conserved','Additive',"par1 Dominant","Par2 Dominant",'Underdominant', 'Overdominant')
colorsdata4<-c("5","orange","3","6","red","blue")
slicesdata4<-(data41[1:6]/data41[7])

pdf(file = "/Final/Figs/SSH2_domiance_pie_120113.pdf")

pie(slicesdata4,labels = lblsdata4, col = colorsdata4, main = "SSH2 dominance pie")

dev.off()

####################################################################################################
####################################################################################################
#plots

#MSH1

a1<-subset(data5,data5[,8] == 1)
b1<-subset(data5,data5[,7] == 1)
c1<-subset(data5,data5[,9] == 1)
d1<-subset(data5,data5[,10] == 1)
e1<-subset(data5,data5[,11] == 1)
f1<-subset(data5,data5[,12] == 1)

pdf(file = "/Final/Figs/MSH1_DOM_120113.pdf")

plot(data5[,5], data5[,6], type = "n", ylim = c(-10,10),xlim = c(-10,10),xlab="Parental", ylab="Hybrid")

#underdominant
points(a1[,5],a1[,6], col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#additive
points(b1[,5],b1[,6], col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#overdominant
points(c1[,5],c1[,6], col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par1 dominant
points(d1[,5],d1[,6], col=rgb(t(col2rgb("3")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par2 dominant
points(e1[,5],e1[,6],col=rgb(t(col2rgb("6")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#conserved
points(f1[,5],f1[,6], col=rgb(t(col2rgb("5")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

abline(h=0)
abline(v=0)
abline(a=0,b=1)

dev.off()

data51<-c(nrow(f1),nrow(b1),nrow(d1),nrow(e1),nrow(a1),nrow(c1),nrow(data5));
data511 <- matrix(data=data51,nrow=1, ncol=7, byrow=FALSE)
colnames(data511)<- c('Conserved','Additive','par1 Dominant','Par2 Dominant','Underdominant', 'Overdominant','total');

write.table(data511, file = "/Final/Figs/dominance_classified_MSH1_120113.txt",sep="\t",quote=FALSE,row.names=FALSE);

lblsdata5<-c('Conserved','Additive',"par1 Dominant","Par2 Dominant",'Underdominant', 'Overdominant')
colorsdata5<-c("5","orange","3","6","red","blue")
slicesdata5<-(data51[1:6]/data51[7])

pdf(file = "/Final/Figs/MSH1_domiance_pie_120113.pdf")

pie(slicesdata5,labels = lblsdata5, col = colorsdata5, main = "MSH1 dominance pie")

dev.off()

####################################################################################################
####################################################################################################
#plots

#MSH2

a1<-subset(data6,data6[,8] == 1)
b1<-subset(data6,data6[,7] == 1)
c1<-subset(data6,data6[,9] == 1)
d1<-subset(data6,data6[,10] == 1)
e1<-subset(data6,data6[,11] == 1)
f1<-subset(data6,data6[,12] == 1)

pdf(file = "/Final/Figs/MSH2_DOM_120113.pdf")

plot(data6[,5], data6[,6], type = "n", ylim = c(-10,10),xlim = c(-10,10),xlab="Parental", ylab="Hybrid")

#underdominant
points(a1[,5],a1[,6], col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#additive
points(b1[,5],b1[,6], col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#overdominant
points(c1[,5],c1[,6], col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par1 dominant
points(d1[,5],d1[,6], col=rgb(t(col2rgb("3")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par2 dominant
points(e1[,5],e1[,6],col=rgb(t(col2rgb("6")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#conserved
points(f1[,5],f1[,6], col=rgb(t(col2rgb("5")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

abline(h=0)
abline(v=0)
abline(a=0,b=1)

dev.off()

data61<-c(nrow(f1),nrow(b1),nrow(d1),nrow(e1),nrow(a1),nrow(c1),nrow(data6));
data611 <- matrix(data=data61,nrow=1, ncol=7, byrow=FALSE)
colnames(data611)<- c('Conserved','Additive','par1 Dominant','Par2 Dominant','Underdominant', 'Overdominant','total');

write.table(data611, file = "/Final/Figs/dominance_classified_MSH2_120113.txt",sep="\t",quote=FALSE,row.names=FALSE);

lblsdata6<-c('Conserved','Additive',"par1 Dominant","Par2 Dominant",'Underdominant', 'Overdominant')
colorsdata6<-c("5","orange","3","6","red","blue")
slicesdata6<-(data61[1:6]/data61[7])

pdf(file = "/Final/Figs/MSH2_domiance_pie_120113.pdf")

pie(slicesdata6,labels = lblsdata6, col = colorsdata6, main = "MSH2 dominance pie")

dev.off()

rm(list = ls())

####################################################################################################
####################################################################################################
#make volcano plots
####################################################################################################
####################################################################################################
#get data

data1<-read.delim("/Final/Meta/MM_112213.txt",header = TRUE)
data2<-read.delim("/Final/Meta/SS_112213.txt",header = TRUE)
data3<-read.delim("/Final/Meta/MS_112213.txt",header = TRUE)
data4<-read.delim("/Final/Meta/ZHR1H1_112213.txt",header = TRUE)
data5<-read.delim("/Final/Meta/ZHR1H2_112213.txt",header = TRUE)
data6<-read.delim("/Final/Meta/Z30H1_112213.txt",header = TRUE)
data7<-read.delim("/Final/Meta/Z30H2_112213.txt",header = TRUE)
data8<-read.delim("/Final/Meta/MMPoO_112213.txt",header = TRUE)
data9<-read.delim("/Final/Meta/SIM1H1_112213.txt",header = TRUE)
data10<-read.delim("/Final/Meta/SIM1H2_112213.txt",header = TRUE)
data11<-read.delim("/Final/Meta/SECH1_112213.txt",header = TRUE)
data12<-read.delim("/Final/Meta/SECH2_112213.txt",header = TRUE)
data13<-read.delim("/Final/Meta/SSPoO_112213.txt",header = TRUE)
data14<-read.delim("/Final/Meta/ZHR2H1_112213.txt",header = TRUE)
data15<-read.delim("/Final/Meta/ZHR2H2_112213.txt",header = TRUE)
data16<-read.delim("/Final/Meta/SIM2H1_112213.txt",header = TRUE)
data17<-read.delim("/Final/Meta/SIM2H2_112213.txt",header = TRUE)
data18<-read.delim("/Final/Meta/MSPoO_112213.txt",header = TRUE)

####################################################################################################
####################################################################################################
#make plots

####################################################################################################

pdf(file='/final/Figs/data1_zoom_volplot_120113.pdf')
plot(log2(data1[,2]/data1[,3]), -log10(data1[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',ylim = c(0,10),xlim = c(-2,2))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

pdf(file='/final/Figs/data1_all_volplot_120113.pdf')
plot(log2(data1[,2]/data1[,3]), -log10(data1[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',xlim = c(-5,5),ylim = c(0,350))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

####################################################################################################

####################################################################################################

pdf(file='/final/Figs/data2_zoom_volplot_120113.pdf')
plot(log2(data2[,2]/data2[,3]), -log10(data2[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',ylim = c(0,10),xlim = c(-2,2))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

pdf(file='/final/Figs/data2_all_volplot_120113.pdf')
plot(log2(data2[,2]/data2[,3]), -log10(data2[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',xlim = c(-5,5),ylim = c(0,350))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

####################################################################################################

####################################################################################################

pdf(file='/final/Figs/data3_zoom_volplot_120113.pdf')
plot(log2(data3[,2]/data3[,3]), -log10(data3[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',ylim = c(0,10),xlim = c(-2,2))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

pdf(file='/final/Figs/data3_all_volplot_120113.pdf')
plot(log2(data3[,2]/data3[,3]), -log10(data3[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',xlim = c(-5,5),ylim = c(0,350))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

####################################################################################################

####################################################################################################

pdf(file='/final/Figs/data4_zoom_volplot_120113.pdf')
plot(log2(data4[,2]/data4[,3]), -log10(data4[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',ylim = c(0,10),xlim = c(-2,2))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

pdf(file='/final/Figs/data4_all_volplot_120113.pdf')
plot(log2(data4[,2]/data4[,3]), -log10(data4[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',xlim = c(-5,5),ylim = c(0,350))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

####################################################################################################

####################################################################################################

pdf(file='/final/Figs/data5_zoom_volplot_120113.pdf')
plot(log2(data5[,2]/data5[,3]), -log10(data5[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',ylim = c(0,10),xlim = c(-2,2))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

pdf(file='/final/Figs/data5_all_volplot_120113.pdf')
plot(log2(data5[,2]/data5[,3]), -log10(data5[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',xlim = c(-5,5),ylim = c(0,350))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

####################################################################################################

####################################################################################################

pdf(file='/final/Figs/data6_zoom_volplot_120113.pdf')
plot(log2(data6[,2]/data6[,3]), -log10(data6[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',ylim = c(0,10),xlim = c(-2,2))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

pdf(file='/final/Figs/data6_all_volplot_120113.pdf')
plot(log2(data6[,2]/data6[,3]), -log10(data6[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',xlim = c(-5,5),ylim = c(0,350))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

####################################################################################################

####################################################################################################

pdf(file='/final/Figs/data7_zoom_volplot_120113.pdf')
plot(log2(data7[,2]/data7[,3]), -log10(data7[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',ylim = c(0,10),xlim = c(-2,2))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

pdf(file='/final/Figs/data7_all_volplot_120113.pdf')
plot(log2(data7[,2]/data7[,3]), -log10(data7[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',xlim = c(-5,5),ylim = c(0,350))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

####################################################################################################

####################################################################################################

pdf(file='/final/Figs/data8_zoom_volplot_120113.pdf')
plot(log2(data8[,2]/data8[,3]), -log10(data8[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',ylim = c(0,10),xlim = c(-2,2))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

pdf(file='/final/Figs/data8_all_volplot_120113.pdf')
plot(log2(data8[,2]/data8[,3]), -log10(data8[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',xlim = c(-5,5),ylim = c(0,350))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(v = -log2(1.5),lwd = 3,col = 'red')
abline(v = log2(1.5),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

####################################################################################################

####################################################################################################

pdf(file='/final/Figs/data9_zoom_volplot_120113.pdf')
plot(log2(data9[,2]/data9[,3]), -log10(data9[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',ylim = c(0,10),xlim = c(-2,2))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

pdf(file='/final/Figs/data9_all_volplot_120113.pdf')
plot(log2(data9[,2]/data9[,3]), -log10(data9[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',xlim = c(-5,5),ylim = c(0,350))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

####################################################################################################

####################################################################################################

pdf(file='/final/Figs/data10_zoom_volplot_120113.pdf')
plot(log2(data10[,2]/data10[,3]), -log10(data10[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',ylim = c(0,10),xlim = c(-2,2))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

pdf(file='/final/Figs/data10_all_volplot_120113.pdf')
plot(log2(data10[,2]/data10[,3]), -log10(data10[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',xlim = c(-5,5),ylim = c(0,350))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

####################################################################################################

####################################################################################################

pdf(file='/final/Figs/data11_zoom_volplot_120113.pdf')
plot(log2(data11[,2]/data11[,3]), -log10(data11[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',ylim = c(0,10),xlim = c(-2,2))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

pdf(file='/final/Figs/data11_all_volplot_120113.pdf')
plot(log2(data11[,2]/data11[,3]), -log10(data11[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',xlim = c(-5,5),ylim = c(0,350))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

####################################################################################################

####################################################################################################

pdf(file='/final/Figs/data12_zoom_volplot_120113.pdf')
plot(log2(data12[,2]/data12[,3]), -log10(data12[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',ylim = c(0,10),xlim = c(-2,2))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

pdf(file='/final/Figs/data12_all_volplot_120113.pdf')
plot(log2(data12[,2]/data12[,3]), -log10(data12[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',xlim = c(-5,5),ylim = c(0,350))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

####################################################################################################

####################################################################################################

pdf(file='/final/Figs/data13_zoom_volplot_120113.pdf')
plot(log2(data13[,2]/data13[,3]), -log10(data13[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',ylim = c(0,10),xlim = c(-2,2))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

pdf(file='/final/Figs/data13_all_volplot_120113.pdf')
plot(log2(data13[,2]/data13[,3]), -log10(data13[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',xlim = c(-5,5),ylim = c(0,350))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

####################################################################################################

####################################################################################################

pdf(file='/final/Figs/data14_zoom_volplot_120113.pdf')
plot(log2(data14[,2]/data14[,3]), -log10(data14[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',ylim = c(0,10),xlim = c(-2,2))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

pdf(file='/final/Figs/data14_all_volplot_120113.pdf')
plot(log2(data14[,2]/data14[,3]), -log10(data14[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',xlim = c(-5,5),ylim = c(0,350))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

####################################################################################################

####################################################################################################

pdf(file='/final/Figs/data15_zoom_volplot_120113.pdf')
plot(log2(data15[,2]/data15[,3]), -log10(data15[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',ylim = c(0,10),xlim = c(-2,2))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

pdf(file='/final/Figs/data15_all_volplot_120113.pdf')
plot(log2(data15[,2]/data15[,3]), -log10(data15[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',xlim = c(-5,5),ylim = c(0,350))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

####################################################################################################

####################################################################################################

pdf(file='/final/Figs/data16_zoom_volplot_120113.pdf')
plot(log2(data16[,2]/data16[,3]), -log10(data16[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',ylim = c(0,10),xlim = c(-2,2))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

pdf(file='/final/Figs/data16_all_volplot_120113.pdf')
plot(log2(data16[,2]/data16[,3]), -log10(data16[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',xlim = c(-5,5),ylim = c(0,350))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

####################################################################################################

####################################################################################################

pdf(file='/final/Figs/data17_zoom_volplot_120113.pdf')
plot(log2(data17[,2]/data17[,3]), -log10(data17[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',ylim = c(0,10),xlim = c(-2,2))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

pdf(file='/final/Figs/data17_all_volplot_120113.pdf')
plot(log2(data17[,2]/data17[,3]), -log10(data17[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',xlim = c(-5,5),ylim = c(0,350))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

####################################################################################################

####################################################################################################

pdf(file='/final/Figs/data18_zoom_volplot_120113.pdf')
plot(log2(data18[,2]/data18[,3]), -log10(data18[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',ylim = c(0,10),xlim = c(-2,2))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

pdf(file='/final/Figs/data18_all_volplot_120113.pdf')
plot(log2(data18[,2]/data18[,3]), -log10(data18[,4]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlab='log2(P1/P2)',ylab='-log10(q)',xlim = c(-5,5),ylim = c(0,350))
abline(v = -log2(1.25),lwd = 3,col = 'red')
abline(v = log2(1.25),lwd = 3,col = 'red')
abline(h = -log10(0.05),lwd = 3,col = 'red')
dev.off()

rm(list = ls())

####################################################################################################
####################################################################################################
#BOOTSTRAPPING
####################################################################################################
####################################################################################################

#read data

MMP1<-read.delim("/Final/Total/MMP1_TOTAL.TXT", header = TRUE)
MMP2<-read.delim("/Final/Total/MMP2_TOTAL.TXT", header = TRUE)
MMH1<-read.delim("/Final/Total/MMH1_TOTAL.TXT", header = TRUE)
MMH2<-read.delim("/Final/Total/MMH2_TOTAL.TXT", header = TRUE)

SSP1<-read.delim("/Final/Total/SSP1_TOTAL.TXT", header = TRUE)
SSP2<-read.delim("/Final/Total/SSP2_TOTAL.TXT", header = TRUE)
SSH1<-read.delim("/Final/Total/SSH1_TOTAL.TXT", header = TRUE)
SSH2<-read.delim("/Final/Total/SSH2_TOTAL.TXT", header = TRUE)

MSP1<-read.delim("/Final/Total/MSP1_TOTAL.TXT", header = TRUE)
MSP2<-read.delim("/Final/Total/MSP2_TOTAL.TXT", header = TRUE)
MSH1<-read.delim("/Final/Total/MSH1_TOTAL.TXT", header = TRUE)
MSH2<-read.delim("/Final/Total/MSH2_TOTAL.TXT", header = TRUE)

####################################################################################################
####################################################################################################

# processing for total expression

genenames<-data.frame(genenames<-MMP1[,1])
MMP1<-data.frame(MMP1<-cbind(genenames,(MMP1[,3]+MMP1[,4]+MMP1[,5])))
colnames(MMP1)<-c('gene','count')

genenames<-data.frame(genenames<-MMP2[,1])
MMP2<-data.frame(MMP2<-cbind(genenames,(MMP2[,3]+MMP2[,4]+MMP2[,5])))
colnames(MMP2)<-c('gene','count')

genenames<-data.frame(genenames<-SSP1[,1])
SSP1<-data.frame(SSP1<-cbind(genenames,(SSP1[,3]+SSP1[,4]+SSP1[,5])))
colnames(SSP1)<-c('gene','count')

genenames<-data.frame(genenames<-SSP2[,1])
SSP2<-data.frame(SSP2<-cbind(genenames,(SSP2[,3]+SSP2[,4]+SSP2[,5])))
colnames(SSP2)<-c('gene','count')

genenames<-data.frame(genenames<-MSP1[,1])
MSP1<-data.frame(MSP1<-cbind(genenames,(MSP1[,3]+MSP1[,4]+MSP1[,5])))
colnames(MSP1)<-c('gene','count')

genenames<-data.frame(genenames<-MSP2[,1])
MSP2<-data.frame(MSP2<-cbind(genenames,(MSP2[,3]+MSP2[,4]+MSP2[,5])))
colnames(MSP2)<-c('gene','count')

genenames<-data.frame(genenames<-MMH1[,1])
MMH1<-data.frame(MMH1<-cbind(genenames,(MMH1[,3]+MMH1[,4]+MMH1[,5])))
colnames(MMH1)<-c('gene','count')

genenames<-data.frame(genenames<-MMH2[,1])
MMH2<-data.frame(MMH2<-cbind(genenames,(MMH2[,3]+MMH2[,4]+MMH2[,5])))
colnames(MMH2)<-c('gene','count')

genenames<-data.frame(genenames<-SSH1[,1])
SSH1<-data.frame(SSH1<-cbind(genenames,(SSH1[,3]+SSH1[,4]+SSH1[,5])))
colnames(SSH1)<-c('gene','count')

genenames<-data.frame(genenames<-SSH2[,1])
SSH2<-data.frame(SSH2<-cbind(genenames,(SSH2[,3]+SSH2[,4]+SSH2[,5])))
colnames(SSH2)<-c('gene','count')

genenames<-data.frame(genenames<-MSH1[,1])
MSH1<-data.frame(MSH1<-cbind(genenames,(MSH1[,3]+MSH1[,4]+MSH1[,5])))
colnames(MSH1)<-c('gene','count')

genenames<-data.frame(genenames<-MSH2[,1])
MSH2<-data.frame(MSH2<-cbind(genenames,(MSH2[,3]+MSH2[,4]+MSH2[,5])))
colnames(MSH2)<-c('gene','count')

####################################################################################################
####################################################################################################

data1<-merge(MMP1, MMP2, by = 'gene')
data2<-merge(SSP1, SSP2, by = 'gene')
data3<-merge(MSP1, MSP2, by = 'gene')

data4<-merge(MMP1, MMH1, by = 'gene')
data5<-merge(MMP1, MMH2, by = 'gene')
data6<-merge(MMP2, MMH1, by = 'gene')
data7<-merge(MMP2, MMH2, by = 'gene')
data8<-merge(MMH1, MMH2, by = 'gene')

data9<-merge(SSP1, SSH1, by = 'gene')
data10<-merge(SSP1, SSH2, by = 'gene')
data11<-merge(SSP2, SSH1, by = 'gene')
data12<-merge(SSP2, SSH2, by = 'gene')
data13<-merge(SSH1, SSH2, by = 'gene')

data14<-merge(MSP1, MSH1, by = 'gene')
data15<-merge(MSP1, MSH2, by = 'gene')
data16<-merge(MSP2, MSH1, by = 'gene')
data17<-merge(MSP2, MSH2, by = 'gene')
data18<-merge(MSH1, MSH2, by = 'gene')

####################################################################################################
####################################################################################################

#RHO correlation coefficients

cor(data1[,3],data1[,2],method = "s")
cor(data2[,3],data2[,2],method = "s")
cor(data3[,3],data3[,2],method = "s")
cor(data4[,3],data4[,2],method = "s")
cor(data5[,3],data5[,2],method = "s")
cor(data6[,3],data6[,2],method = "s")
cor(data7[,3],data7[,2],method = "s")
cor(data8[,3],data8[,2],method = "s")
cor(data9[,3],data9[,2],method = "s")
cor(data10[,3],data10[,2],method = "s")
cor(data11[,3],data11[,2],method = "s")
cor(data12[,3],data12[,2],method = "s")
cor(data13[,3],data13[,2],method = "s")
cor(data14[,3],data14[,2],method = "s")
cor(data15[,3],data15[,2],method = "s")
cor(data16[,3],data16[,2],method = "s")
cor(data17[,3],data17[,2],method = "s")
cor(data18[,3],data18[,2],method = "s")

####################################################################################################
####################################################################################################
#bootstrapping parental diferrences, parent of origin differences and regulatory differences

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0

for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value1<-cor(data1_1B[,3],data1_1B[,2],method = "s")
	value1<-data.frame(value1)
	results1[i,2] = value1[,1]
	}
rm(i)

####################################################################################################

data2_1 <-data2

results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0

for (i in 1:10000) 
	{
	data2_1B <- data2_1[sample(nrow(data2_1), replace = TRUE),]
	value2<-cor(data2_1B[,3],data2_1B[,2],method = "s")
	value2<-data.frame(value2)
	results2[i,2] = value2[,1]
	}
rm(i)

####################################################################################################

data3_1 <-data3

results3 <- 1:20000 ; dim(results3) <- c(10000,2)
results3[,2]=0

for (i in 1:10000) 
	{
	data3_1B <- data3_1[sample(nrow(data3_1), replace = TRUE),]
	value3<-cor(data3_1B[,3],data3_1B[,2],method = "s")
	value3<-data.frame(value3)
	results3[i,2] = value3[,1]
	}
rm(i)

####################################################################################################

data4_1 <-data4

results4 <- 1:20000 ; dim(results4) <- c(10000,2)
results4[,2]=0

for (i in 1:10000) 
	{
	data4_1B <- data4_1[sample(nrow(data4_1), replace = TRUE),]
	value4<-cor(data4_1B[,3],data4_1B[,2],method = "s")
	value4<-data.frame(value4)
	results4[i,2] = value4[,1]
	}
rm(i)

####################################################################################################

data5_1 <-data5

results5 <- 1:20000 ; dim(results5) <- c(10000,2)
results5[,2]=0

for (i in 1:10000) 
	{
	data5_1B <- data5_1[sample(nrow(data5_1), replace = TRUE),]
	value5<-cor(data5_1B[,3],data5_1B[,2],method = "s")
	value5<-data.frame(value5)
	results5[i,2] = value5[,1]
	}
rm(i)

####################################################################################################
data6_1 <-data6

results6 <- 1:20000 ; dim(results6) <- c(10000,2)
results6[,2]=0

for (i in 1:10000) 
	{
	data6_1B <- data6_1[sample(nrow(data6_1), replace = TRUE),]
	value6<-cor(data6_1B[,3],data6_1B[,2],method = "s")
	value6<-data.frame(value6)
	results6[i,2] = value6[,1]
	}
rm(i)

####################################################################################################
data7_1 <-data7

results7 <- 1:20000 ; dim(results7) <- c(10000,2)
results7[,2]=0

for (i in 1:10000) 
	{
	data7_1B <- data7_1[sample(nrow(data7_1), replace = TRUE),]
	value7<-cor(data7_1B[,3],data7_1B[,2],method = "s")
	value7<-data.frame(value7)
	results7[i,2] = value7[,1]
	}
rm(i)

####################################################################################################
data8_1 <-data8

results8 <- 1:20000 ; dim(results8) <- c(10000,2)
results8[,2]=0

for (i in 1:10000) 
	{
	data8_1B <- data8_1[sample(nrow(data8_1), replace = TRUE),]
	value8<-cor(data8_1B[,3],data8_1B[,2],method = "s")
	value8<-data.frame(value8)
	results8[i,2] = value8[,1]
	}
rm(i)

####################################################################################################
data9_1 <-data9

results9 <- 1:20000 ; dim(results9) <- c(10000,2)
results9[,2]=0

for (i in 1:10000) 
	{
	data9_1B <- data9_1[sample(nrow(data9_1), replace = TRUE),]
	value9<-cor(data9_1B[,3],data9_1B[,2],method = "s")
	value9<-data.frame(value9)
	results9[i,2] = value9[,1]
	}
rm(i)

####################################################################################################
data10_1 <-data10

results10 <- 1:20000 ; dim(results10) <- c(10000,2)
results10[,2]=0

for (i in 1:10000) 
	{
	data10_1B <- data10_1[sample(nrow(data10_1), replace = TRUE),]
	value10<-cor(data10_1B[,3],data10_1B[,2],method = "s")
	value10<-data.frame(value10)
	results10[i,2] = value10[,1]
	}
rm(i)

####################################################################################################
data11_1 <-data11

results11 <- 1:20000 ; dim(results11) <- c(10000,2)
results11[,2]=0

for (i in 1:10000) 
	{
	data11_1B <- data11_1[sample(nrow(data11_1), replace = TRUE),]
	value11<-cor(data11_1B[,3],data11_1B[,2],method = "s")
	value11<-data.frame(value11)
	results11[i,2] = value11[,1]
	}
rm(i)

####################################################################################################
data12_1 <-data12

results12 <- 1:20000 ; dim(results12) <- c(10000,2)
results12[,2]=0

for (i in 1:10000) 
	{
	data12_1B <- data12_1[sample(nrow(data12_1), replace = TRUE),]
	value12<-cor(data12_1B[,3],data12_1B[,2],method = "s")
	value12<-data.frame(value12)
	results12[i,2] = value12[,1]
	}
rm(i)

####################################################################################################
data13_1 <-data13

results13 <- 1:20000 ; dim(results13) <- c(10000,2)
results13[,2]=0

for (i in 1:10000) 
	{
	data13_1B <- data13_1[sample(nrow(data13_1), replace = TRUE),]
	value13<-cor(data13_1B[,3],data13_1B[,2],method = "s")
	value13<-data.frame(value13)
	results13[i,2] = value13[,1]
	}
rm(i)

####################################################################################################
data14_1 <-data14

results14 <- 1:20000 ; dim(results14) <- c(10000,2)
results14[,2]=0

for (i in 1:10000) 
	{
	data14_1B <- data14_1[sample(nrow(data14_1), replace = TRUE),]
	value14<-cor(data14_1B[,3],data14_1B[,2],method = "s")
	value14<-data.frame(value14)
	results14[i,2] = value14[,1]
	}
rm(i)

####################################################################################################
data15_1 <-data15

results15 <- 1:20000 ; dim(results15) <- c(10000,2)
results15[,2]=0

for (i in 1:10000) 
	{
	data15_1B <- data15_1[sample(nrow(data15_1), replace = TRUE),]
	value15<-cor(data15_1B[,3],data15_1B[,2],method = "s")
	value15<-data.frame(value15)
	results15[i,2] = value15[,1]
	}
rm(i)

####################################################################################################
data16_1 <-data16

results16 <- 1:20000 ; dim(results16) <- c(10000,2)
results16[,2]=0

for (i in 1:10000) 
	{
	data16_1B <- data16_1[sample(nrow(data16_1), replace = TRUE),]
	value16<-cor(data16_1B[,3],data16_1B[,2],method = "s")
	value16<-data.frame(value16)
	results16[i,2] = value16[,1]
	}
rm(i)

####################################################################################################
data17_1 <-data17

results17 <- 1:20000 ; dim(results17) <- c(10000,2)
results17[,2]=0

for (i in 1:10000) 
	{
	data17_1B <- data17_1[sample(nrow(data17_1), replace = TRUE),]
	value17<-cor(data17_1B[,3],data17_1B[,2],method = "s")
	value17<-data.frame(value17)
	results17[i,2] = value17[,1]
	}
rm(i)

####################################################################################################
data18_1 <-data18

results18 <- 1:20000 ; dim(results18) <- c(10000,2)
results18[,2]=0

for (i in 1:10000) 
	{
	data18_1B <- data18_1[sample(nrow(data18_1), replace = TRUE),]
	value18<-cor(data18_1B[,3],data18_1B[,2],method = "s")
	value18<-data.frame(value18)
	results18[i,2] = value18[,1]
	}
rm(i)

####################################################################################################
####################################################################################################
####################################################################################################
#bootstrap regulatory incompatibility

dataMMH1<-merge(data4,data5, by = 'gene')
dataMMH2<-merge(dataMMH1,data6, by = 'gene')
dataMMH3<-merge(dataMMH2,data7, by = 'gene')

resultsMMH3 <- 1:20000 ; dim(resultsMMH3) <- c(10000,2)
resultsMMH3[,2]=0

val5<-cor(data4[,3],data4[,2],method = "s")
val5B<-cor(data5[,3],data5[,2],method = "s")
val5C<-cor(data6[,3],data6[,2],method = "s")
val5D<-cor(data7[,3],data7[,2],method = "s")

data.frame(val5)
data.frame(val5B)
data.frame(val5C)
data.frame(val5D)

fitMMH<-(val5[,1]+val5B[,1]+val5C[,1]+val5D[,1])/4

for (i in 1:10000) 
	{
	dataMMH3B <- dataMMH3[sample(nrow(dataMMH3), replace = TRUE),]
	fit6<-cor(dataMMH3B[,3],dataMMH3B[,2],method = "s")
	fit6B<-cor(dataMMH3B[,5],dataMMH3B[,2],method = "s")
	fit6C<-cor(dataMMH3B[,7],dataMMH3B[,6],method = "s")
	fit6D<-cor(dataMMH3B[,9],dataMMH3B[,8],method = "s")
	val6<-data.frame(fit6)
	val6B<-data.frame(fit6B)
	val6C<-data.frame(fit6C)
	val6D<-data.frame(fit6D)
	valueMMH3<-(val6[,1]+val6B[,1]+val6C[,1]+val6D[,1])/4
	valueMMH3<-data.frame(valueMMH3)
	resultsMMH3[i,2] = valueMMH3[,1]
	}
rm(i)

####################################################################################################
#bootstrap regulatory incompatibility

dataSSH1<-merge(data9,data10, by = 'gene')
dataSSH2<-merge(dataSSH1,data11, by = 'gene')
dataSSH3<-merge(dataSSH2,data12, by = 'gene')

resultsSSH3 <- 1:20000 ; dim(resultsSSH3) <- c(10000,2)
resultsSSH3[,2]=0

val5E<-cor(data9[,3],data9[,2],method = "s")
val5F<-cor(data10[,3],data10[,2],method = "s")
val5G<-cor(data11[,3],data11[,2],method = "s")
val5H<-cor(data12[,3],data12[,2],method = "s")

data.frame(val5E)
data.frame(val5F)
data.frame(val5G)
data.frame(val5H)


fitSSH<-(val5E[,1]+val5F[,1]+val5G[,1]+val5H[,1])/4

for (i in 1:10000) 
	{
	dataSSH3B <- dataSSH3[sample(nrow(dataSSH3), replace = TRUE),]
	fit6E<-cor(dataSSH3B[,3],dataSSH3B[,2],method = "s")
	fit6F<-cor(dataSSH3B[,5],dataSSH3B[,4],method = "s")
	fit6G<-cor(dataSSH3B[,7],dataSSH3B[,6],method = "s")
	fit6H<-cor(dataSSH3B[,9],dataSSH3B[,8],method = "s")
	val6E<-data.frame(fit6E)
	val6F<-data.frame(fit6F)
	val6G<-data.frame(fit6G)
	val6H<-data.frame(fit6H)
	valueSSH3<-(val6E[,1]+val6F[,1]+val6G[,1]+val6H[,1])/4
	valueSSH3<-data.frame(valueSSH3)
	resultsSSH3[i,2] = valueSSH3[,1]
	}
rm(i)

####################################################################################################
#bootstrap regulatory incompatibility

dataMSH1<-merge(data14,data15, by = 'gene')
dataMSH2<-merge(dataMSH1,data16, by = 'gene')
dataMSH3<-merge(dataMSH2,data17, by = 'gene')

resultsMSH3 <- 1:20000 ; dim(resultsMSH3) <- c(10000,2)
resultsMSH3[,2]=0

val5I<-cor(data14[,3],data14[,2],method = "s")
val5J<-cor(data15[,3],data15[,2],method = "s")
val5K<-cor(data16[,3],data16[,2],method = "s")
val5L<-cor(data17[,3],data17[,2],method = "s")

data.frame(val5I)
data.frame(val5J)
data.frame(val5K)
data.frame(val5L)

fitMSH<-(val5I[,1]+val5J[,1]+val5K[,1]+val5L[,1])/4

for (i in 1:10000) 
	{
	dataMSH3B <- dataMSH3[sample(nrow(dataMSH3), replace = TRUE),]
	fit6I<-cor(dataMSH3B[,3],dataMSH3B[,2],method = "s")
	fit6J<-cor(dataMSH3B[,5],dataMSH3B[,4],method = "s")
	fit6K<-cor(dataMSH3B[,7],dataMSH3B[,6],method = "s")
	fit6L<-cor(dataMSH3B[,9],dataMSH3B[,8],method = "s")
	val6I<-data.frame(fit6I)
	val6J<-data.frame(fit6J)
	val6K<-data.frame(fit6K)
	val6L<-data.frame(fit6L)
	valueMSH3<-(val6I[,1]+val6J[,1]+val6K[,1]+val6L[,1])/4	
	valueMSH3<-data.frame(valueMSH3)
	resultsMSH3[i,2] = valueMSH3[,1]
	}
rm(i)

####################################################################################################

#MM=0.4169984
#SS=1.928764
#MS=5.064166

#val=0.2

W1<-wilcox.test(results1[,2],results2[,2],paired = FALSE,alternative = c("two.sided"),conf.int = 0.95)
W2<-wilcox.test(results2[,2],results3[,2],paired = FALSE,alternative = c("two.sided"),conf.int = 0.95)
W3<-wilcox.test(results1[,2],results3[,2],paired = FALSE,alternative = c("two.sided"),conf.int = 0.95)

W4<-wilcox.test(results8[,2],results13[,2],paired = FALSE,alternative = c("two.sided"),conf.int = 0.95)
W5<-wilcox.test(results13[,2],results18[,2],paired = FALSE,alternative = c("two.sided"),conf.int = 0.95)
W6<-wilcox.test(results8[,2],results18[,2],paired = FALSE,alternative = c("two.sided"),conf.int = 0.95)

W7<-wilcox.test(resultsMMH3[,2],resultsSSH3[,2],paired = FALSE,alternative = c("two.sided"),conf.int = 0.95)
W8<-wilcox.test(resultsSSH3[,2],resultsMSH3[,2],paired = FALSE,alternative = c("two.sided"),conf.int = 0.95)
W9<-wilcox.test(resultsMMH3[,2],resultsMSH3[,2],paired = FALSE,alternative = c("two.sided"),conf.int = 0.95)

####################################################################################################
####################################################################################################
####################################################################################################

write.table(results1, file = "/Final/Separate/results1B.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(results2, file = "/Final/Separate/results2B.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(results3, file = "/Final/Separate/results3B.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(results4, file = "/Final/Separate/results4B.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(results5, file = "/Final/Separate/results5B.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(results6, file = "/Final/Separate/results6B.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(results7, file = "/Final/Separate/results7B.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(results8, file = "/Final/Separate/results8B.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(results9, file = "/Final/Separate/results9B.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(results10, file = "/Final/Separate/results10B.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(results11, file = "/Final/Separate/results11B.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(results12, file = "/Final/Separate/results12B.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(results13, file = "/Final/Separate/results13B.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(results14, file = "/Final/Separate/results14B.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(results15, file = "/Final/Separate/results15B.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(results16, file = "/Final/Separate/results16B.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(results17, file = "/Final/Separate/results17B.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(results18, file = "/Final/Separate/results18B.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(resultsMMH3, file = "/Final/Separate/resultsMMH3B.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(resultsSSH3, file = "/Final/Separate/resultsSSH3B.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(resultsMSH3, file = "/Final/Separate/resultsMSH3B.txt",sep="\t",quote=FALSE,row.names=FALSE)

#rm(list = ls())

####################################################################################################
####################################################################################################

#RHO correlation coefficient differences

(cor(data1[,3],data1[,2],method = "s")-cor(data2[,3],data2[,2],method = "s"))
(cor(data2[,3],data2[,2],method = "s")-cor(data3[,3],data3[,2],method = "s"))
(cor(data1[,3],data1[,2],method = "s")-cor(data3[,3],data3[,2],method = "s"))

####################################################################################################
####################################################################################################
#bootstrapping parental diferrences

data1_2<-merge(data1,data2, by = 'gene')
data1_2_3<-merge(data1_2,data3, by = 'gene')

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0
results3 <- 1:20000 ; dim(results3) <- c(10000,2)
results3[,2]=0

for (i in 1:10000) 
	{
	data1_2_3B <- data1_2_3[sample(nrow(data1_2_3), replace = TRUE),]
	value1A<-cor(data1_2_3B[,3],data1_2_3B[,2],method = "s")
	value1B<-cor(data1_2_3B[,5],data1_2_3B[,4],method = "s")
	value1C<-cor(data1_2_3B[,7],data1_2_3B[,6],method = "s")
	value1D<-data.frame(value1D<-(value1A-value1B))
	value1E<-data.frame(value1E<-(value1B-value1C))
	value1F<-data.frame(value1F<-(value1A-value1C))	
	results1[i,2] = value1D[,1]
	results2[i,2] = value1E[,1]
	results3[i,2] = value1F[,1]
	}
rm(i)

pvalue12<-(nrow(subset(results1,results1[,2] <=0)))
pvalue23<-(nrow(subset(results2,results2[,2] <=0)))
pvalue13<-(nrow(subset(results3,results3[,2] <=0)))

pvalue12
pvalue23
pvalue13

####################################################################################################
####################################################################################################
#bootstrap regulatory incompatibility

dataMMH1<-merge(data4,data5, by = 'gene')
dataMMH2<-merge(dataMMH1,data6, by = 'gene')
dataMMH3<-merge(dataMMH2,data7, by = 'gene')

dataSSH1<-merge(data9,data10, by = 'gene')
dataSSH2<-merge(dataSSH1,data11, by = 'gene')
dataSSH3<-merge(dataSSH2,data12, by = 'gene')

dataMSH1<-merge(data14,data15, by = 'gene')
dataMSH2<-merge(dataMSH1,data16, by = 'gene')
dataMSH3<-merge(dataMSH2,data17, by = 'gene')

dataMM_SS<-merge(dataMMH3,dataSSH3, by = 'gene')
dataMM_SS_MS<-merge(dataMM_SS,dataMSH3, by = 'gene')

#RHO correlation coefficient differences

val1<-data.frame(val1<-cor(dataMM_SS_MS[,3],dataMM_SS_MS[,2],method = "s"))
val1B<-data.frame(val1B<-cor(dataMM_SS_MS[,5],dataMM_SS_MS[,4],method = "s"))
val1C<-data.frame(val1C<-cor(dataMM_SS_MS[,7],dataMM_SS_MS[,6],method = "s"))
val1D<-data.frame(val1D<-cor(dataMM_SS_MS[,9],dataMM_SS_MS[,8],method = "s"))	
val2<-data.frame(val2<-cor(dataMM_SS_MS[,11],dataMM_SS_MS[,10],method = "s"))
val2B<-data.frame(val2B<-cor(dataMM_SS_MS[,13],dataMM_SS_MS[,12],method = "s"))
val2C<-data.frame(val2C<-cor(dataMM_SS_MS[,15],dataMM_SS_MS[,14],method = "s"))
val2D<-data.frame(val2D<-cor(dataMM_SS_MS[,17],dataMM_SS_MS[,16],method = "s"))
val3<-data.frame(val3<-cor(dataMM_SS_MS[,19],dataMM_SS_MS[,18],method = "s"))
val3B<-data.frame(val3B<-cor(dataMM_SS_MS[,21],dataMM_SS_MS[,20],method = "s"))
val3C<-data.frame(val3C<-cor(dataMM_SS_MS[,23],dataMM_SS_MS[,22],method = "s"))
val3D<-data.frame(val3D<-cor(dataMM_SS_MS[,25],dataMM_SS_MS[,24],method = "s"))
numberMM<-data.frame(numberMM<-(val1[,1]+val1B[,1]+val1C[,1]+val1D[,1])/4)
numberSS<-data.frame(numberSS<-(val2[,1]+val2B[,1]+val2C[,1]+val2D[,1])/4)
numberMS<-data.frame(numberMS<-(val3[,1]+val3B[,1]+val3C[,1]+val3D[,1])/4)
numberMM_SS<-numberMM-numberSS
numberSS_MS<-numberSS-numberMS
numberMM_MS<-numberMM-numberMS

resultsMM_SS <- 1:20000 ; dim(resultsMM_SS) <- c(10000,2)
resultsMM_SS[,2]=0

resultsSS_MS <- 1:20000 ; dim(resultsSS_MS) <- c(10000,2)
resultsSS_MS[,2]=0

resultsMM_MS <- 1:20000 ; dim(resultsMM_MS) <- c(10000,2)
resultsMM_MS[,2]=0


for (i in 1:10000) 
	{
	dataMM_SS_MSB <- dataMM_SS_MS[sample(nrow(dataMM_SS_MS), replace = TRUE),]
	fit1<-data.frame(fit1<-cor(dataMM_SS_MSB[,3],dataMM_SS_MSB[,2],method = "s"))
	fit1B<-data.frame(fit1B<-cor(dataMM_SS_MSB[,5],dataMM_SS_MSB[,4],method = "s"))
	fit1C<-data.frame(fit1C<-cor(dataMM_SS_MSB[,7],dataMM_SS_MSB[,6],method = "s"))
	fit1D<-data.frame(fit1D<-cor(dataMM_SS_MSB[,9],dataMM_SS_MSB[,8],method = "s"))
	
	fit2<-data.frame(fit2<-cor(dataMM_SS_MSB[,11],dataMM_SS_MSB[,10],method = "s"))
	fit2B<-data.frame(fit2B<-cor(dataMM_SS_MSB[,13],dataMM_SS_MSB[,12],method = "s"))
	fit2C<-data.frame(fit2C<-cor(dataMM_SS_MSB[,15],dataMM_SS_MSB[,14],method = "s"))
	fit2D<-data.frame(fit2D<-cor(dataMM_SS_MSB[,17],dataMM_SS_MSB[,16],method = "s"))
	
	fit3<-data.frame(fit3<-cor(dataMM_SS_MSB[,19],dataMM_SS_MSB[,18],method = "s"))
	fit3B<-data.frame(fit3B<-cor(dataMM_SS_MSB[,21],dataMM_SS_MSB[,20],method = "s"))
	fit3C<-data.frame(fit3C<-cor(dataMM_SS_MSB[,23],dataMM_SS_MSB[,22],method = "s"))
	fit3D<-data.frame(fit3D<-cor(dataMM_SS_MSB[,25],dataMM_SS_MSB[,24],method = "s"))

	valueMM<-data.frame(valueMM<-((fit1[,1]+fit1B[,1]+fit1C[,1]+fit1D[,1])/4))
	valueSS<-data.frame(valueSS<-((fit2[,1]+fit2B[,1]+fit2C[,1]+fit2D[,1])/4))
	valueMS<-data.frame(valueMS<-((fit3[,1]+fit3B[,1]+fit3C[,1]+fit3D[,1])/4))
	valueMM_SS<-data.frame(valueMM_SS<-(valueMM[,1]-valueSS[,1]))
	valueSS_MS<-data.frame(valueSS_MS<-(valueSS[,1]-valueMS[,1]))
	valueMM_MS<-data.frame(valueMM_MS<-(valueMM[,1]-valueMS[,1]))
	resultsMM_SS[i,2] = valueMM_SS[,1]
	resultsSS_MS[i,2] = valueSS_MS[,1]
	resultsMM_MS[i,2] = valueMM_MS[,1]
	}
rm(i)


pvalueMM_SS<-(nrow(subset(resultsMM_SS,resultsMM_SS[,2] <=0)))
pvalueSS_MS<-(nrow(subset(resultsSS_MS,resultsSS_MS[,2] <=0)))
pvalueMM_MS<-(nrow(subset(resultsMM_MS,resultsMM_MS[,2] <=0)))

pvalueMM_SS
pvalueSS_MS
pvalueMM_MS

rm(list = ls())

####################################################################################################
####################################################################################################
#final total bootstrapping

#read data

MMP1<-read.delim("/Final/Total/MMP1_TOTAL.txt", header = TRUE)
MMP2<-read.delim("/Final/Total/MMP2_TOTAL.txt", header = TRUE)
MMH1<-read.delim("/Final/Total/MMH1_TOTAL.txt", header = TRUE)
MMH2<-read.delim("/Final/Total/MMH2_TOTAL.txt", header = TRUE)

SSP1<-read.delim("/Final/Total/SSP1_TOTAL.txt", header = TRUE)
SSP2<-read.delim("/Final/Total/SSP2_TOTAL.txt", header = TRUE)
SSH1<-read.delim("/Final/Total/SSH1_TOTAL.txt", header = TRUE)
SSH2<-read.delim("/Final/Total/SSH2_TOTAL.txt", header = TRUE)

MSP1<-read.delim("/Final/Total/MSP1_TOTAL.txt", header = TRUE)
MSP2<-read.delim("/Final/Total/MSP2_TOTAL.txt", header = TRUE)
MSH1<-read.delim("/Final/Total/MSH1_TOTAL.txt", header = TRUE)
MSH2<-read.delim("/Final/Total/MSH2_TOTAL.txt", header = TRUE)

genenames<-read.delim("/Final/total-genes.txt", header = TRUE)

####################################################################################################
####################################################################################################

# processing for total expression

MMP1<-data.frame(MMP1<-cbind(genenames,(MMP1[,3]+MMP1[,4]+MMP1[,5])))
colnames(MMP1)<-c('gene','count')

MMP2<-data.frame(MMP2<-cbind(genenames,(MMP2[,3]+MMP2[,4]+MMP2[,5])))
colnames(MMP2)<-c('gene','count')

SSP1<-data.frame(SSP1<-cbind(genenames,(SSP1[,3]+SSP1[,4]+SSP1[,5])))
colnames(SSP1)<-c('gene','count')

SSP2<-data.frame(SSP2<-cbind(genenames,(SSP2[,3]+SSP2[,4]+SSP2[,5])))
colnames(SSP2)<-c('gene','count')

MSP1<-data.frame(MSP1<-cbind(genenames,(MSP1[,3]+MSP1[,4]+MSP1[,5])))
colnames(MSP1)<-c('gene','count')

MSP2<-data.frame(MSP2<-cbind(genenames,(MSP2[,3]+MSP2[,4]+MSP2[,5])))
colnames(MSP2)<-c('gene','count')

MMH1<-data.frame(MMH1<-cbind(genenames,(MMH1[,3]+MMH1[,4]+MMH1[,5])))
colnames(MMH1)<-c('gene','count')

MMH2<-data.frame(MMH2<-cbind(genenames,(MMH2[,3]+MMH2[,4]+MMH2[,5])))
colnames(MMH2)<-c('gene','count')

SSH1<-data.frame(SSH1<-cbind(genenames,(SSH1[,3]+SSH1[,4]+SSH1[,5])))
colnames(SSH1)<-c('gene','count')

SSH2<-data.frame(SSH2<-cbind(genenames,(SSH2[,3]+SSH2[,4]+SSH2[,5])))
colnames(SSH2)<-c('gene','count')

MSH1<-data.frame(MSH1<-cbind(genenames,(MSH1[,3]+MSH1[,4]+MSH1[,5])))
colnames(MSH1)<-c('gene','count')

MSH2<-data.frame(MSH2<-cbind(genenames,(MSH2[,3]+MSH2[,4]+MSH2[,5])))
colnames(MSH2)<-c('gene','count')

####################################################################################################
####################################################################################################

data1<-merge(MMP1, MMP2, by = 'gene')
data2<-merge(SSP1, SSP2, by = 'gene')
data3<-merge(MSP1, MSP2, by = 'gene')

data4<-merge(MMP1, MMH1, by = 'gene')
data5<-merge(MMP1, MMH2, by = 'gene')
data6<-merge(MMP2, MMH1, by = 'gene')
data7<-merge(MMP2, MMH2, by = 'gene')
data8<-merge(MMH1, MMH2, by = 'gene')

data9<-merge(SSP1, SSH1, by = 'gene')
data10<-merge(SSP1, SSH2, by = 'gene')
data11<-merge(SSP2, SSH1, by = 'gene')
data12<-merge(SSP2, SSH2, by = 'gene')
data13<-merge(SSH1, SSH2, by = 'gene')

data14<-merge(MSP1, MSH1, by = 'gene')
data15<-merge(MSP1, MSH2, by = 'gene')
data16<-merge(MSP2, MSH1, by = 'gene')
data17<-merge(MSP2, MSH2, by = 'gene')
data18<-merge(MSH1, MSH2, by = 'gene')

####################################################################################################
####################################################################################################

#RHO correlation coefficient differences

(cor(data1[,3],data1[,2],method = "s")-cor(data2[,3],data2[,2],method = "s"))
(cor(data2[,3],data2[,2],method = "s")-cor(data3[,3],data3[,2],method = "s"))
(cor(data1[,3],data1[,2],method = "s")-cor(data3[,3],data3[,2],method = "s"))

####################################################################################################
####################################################################################################
#bootstrapping parental diferrences

data1_2<-merge(data1,data2, by = 'gene')
data1_2_3<-merge(data1_2,data3, by = 'gene')

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0
results3 <- 1:20000 ; dim(results3) <- c(10000,2)
results3[,2]=0

for (i in 1:10000) 
	{
	data1_2_3B <- data1_2_3[sample(nrow(data1_2_3), replace = TRUE),]
	value1A<-cor(data1_2_3B[,3],data1_2_3B[,2],method = "s")
	value1B<-cor(data1_2_3B[,5],data1_2_3B[,4],method = "s")
	value1C<-cor(data1_2_3B[,7],data1_2_3B[,6],method = "s")
	value1D<-data.frame(value1D<-(value1A-value1B))
	value1E<-data.frame(value1E<-(value1B-value1C))
	value1F<-data.frame(value1F<-(value1A-value1C))	
	results1[i,2] = value1D[,1]
	results2[i,2] = value1E[,1]
	results3[i,2] = value1F[,1]
	}
rm(i)

pvalue12<-(nrow(subset(results1,results1[,2] <=0)))
pvalue23<-(nrow(subset(results2,results2[,2] <=0)))
pvalue13<-(nrow(subset(results3,results3[,2] <=0)))

pvalue12
pvalue23
pvalue13

####################################################################################################
####################################################################################################
#bootstrap regulatory incompatibility

dataMMH1<-merge(data4,data5, by = 'gene')
dataMMH2<-merge(dataMMH1,data6, by = 'gene')
dataMMH3<-merge(dataMMH2,data7, by = 'gene')

dataSSH1<-merge(data9,data10, by = 'gene')
dataSSH2<-merge(dataSSH1,data11, by = 'gene')
dataSSH3<-merge(dataSSH2,data12, by = 'gene')

dataMSH1<-merge(data14,data15, by = 'gene')
dataMSH2<-merge(dataMSH1,data16, by = 'gene')
dataMSH3<-merge(dataMSH2,data17, by = 'gene')

dataMM_SS<-merge(dataMMH3,dataSSH3, by = 'gene')
dataMM_SS_MS<-merge(dataMM_SS,dataMSH3, by = 'gene')

#RHO correlation coefficient differences

val1<-data.frame(val1<-cor(dataMM_SS_MS[,3],dataMM_SS_MS[,2],method = "s"))
val1B<-data.frame(val1B<-cor(dataMM_SS_MS[,5],dataMM_SS_MS[,4],method = "s"))
val1C<-data.frame(val1C<-cor(dataMM_SS_MS[,7],dataMM_SS_MS[,6],method = "s"))
val1D<-data.frame(val1D<-cor(dataMM_SS_MS[,9],dataMM_SS_MS[,8],method = "s"))	
val2<-data.frame(val2<-cor(dataMM_SS_MS[,11],dataMM_SS_MS[,10],method = "s"))
val2B<-data.frame(val2B<-cor(dataMM_SS_MS[,13],dataMM_SS_MS[,12],method = "s"))
val2C<-data.frame(val2C<-cor(dataMM_SS_MS[,15],dataMM_SS_MS[,14],method = "s"))
val2D<-data.frame(val2D<-cor(dataMM_SS_MS[,17],dataMM_SS_MS[,16],method = "s"))
val3<-data.frame(val3<-cor(dataMM_SS_MS[,19],dataMM_SS_MS[,18],method = "s"))
val3B<-data.frame(val3B<-cor(dataMM_SS_MS[,21],dataMM_SS_MS[,20],method = "s"))
val3C<-data.frame(val3C<-cor(dataMM_SS_MS[,23],dataMM_SS_MS[,22],method = "s"))
val3D<-data.frame(val3D<-cor(dataMM_SS_MS[,25],dataMM_SS_MS[,24],method = "s"))
numberMM<-data.frame(numberMM<-(val1[,1]+val1B[,1]+val1C[,1]+val1D[,1])/4)
numberSS<-data.frame(numberSS<-(val2[,1]+val2B[,1]+val2C[,1]+val2D[,1])/4)
numberMS<-data.frame(numberMS<-(val3[,1]+val3B[,1]+val3C[,1]+val3D[,1])/4)
numberMM_SS<-numberMM-numberSS
numberSS_MS<-numberSS-numberMS
numberMM_MS<-numberMM-numberMS

resultsMM_SS <- 1:20000 ; dim(resultsMM_SS) <- c(10000,2)
resultsMM_SS[,2]=0

resultsSS_MS <- 1:20000 ; dim(resultsSS_MS) <- c(10000,2)
resultsSS_MS[,2]=0

resultsMM_MS <- 1:20000 ; dim(resultsMM_MS) <- c(10000,2)
resultsMM_MS[,2]=0


for (i in 1:10000) 
	{
	dataMM_SS_MSB <- dataMM_SS_MS[sample(nrow(dataMM_SS_MS), replace = TRUE),]
	fit1<-data.frame(fit1<-cor(dataMM_SS_MSB[,3],dataMM_SS_MSB[,2],method = "s"))
	fit1B<-data.frame(fit1B<-cor(dataMM_SS_MSB[,5],dataMM_SS_MSB[,4],method = "s"))
	fit1C<-data.frame(fit1C<-cor(dataMM_SS_MSB[,7],dataMM_SS_MSB[,6],method = "s"))
	fit1D<-data.frame(fit1D<-cor(dataMM_SS_MSB[,9],dataMM_SS_MSB[,8],method = "s"))
	
	fit2<-data.frame(fit2<-cor(dataMM_SS_MSB[,11],dataMM_SS_MSB[,10],method = "s"))
	fit2B<-data.frame(fit2B<-cor(dataMM_SS_MSB[,13],dataMM_SS_MSB[,12],method = "s"))
	fit2C<-data.frame(fit2C<-cor(dataMM_SS_MSB[,15],dataMM_SS_MSB[,14],method = "s"))
	fit2D<-data.frame(fit2D<-cor(dataMM_SS_MSB[,17],dataMM_SS_MSB[,16],method = "s"))
	
	fit3<-data.frame(fit3<-cor(dataMM_SS_MSB[,19],dataMM_SS_MSB[,18],method = "s"))
	fit3B<-data.frame(fit3B<-cor(dataMM_SS_MSB[,21],dataMM_SS_MSB[,20],method = "s"))
	fit3C<-data.frame(fit3C<-cor(dataMM_SS_MSB[,23],dataMM_SS_MSB[,22],method = "s"))
	fit3D<-data.frame(fit3D<-cor(dataMM_SS_MSB[,25],dataMM_SS_MSB[,24],method = "s"))

	valueMM<-data.frame(valueMM<-((fit1[,1]+fit1B[,1]+fit1C[,1]+fit1D[,1])/4))
	valueSS<-data.frame(valueSS<-((fit2[,1]+fit2B[,1]+fit2C[,1]+fit2D[,1])/4))
	valueMS<-data.frame(valueMS<-((fit3[,1]+fit3B[,1]+fit3C[,1]+fit3D[,1])/4))
	valueMM_SS<-data.frame(valueMM_SS<-(valueMM[,1]-valueSS[,1]))
	valueSS_MS<-data.frame(valueSS_MS<-(valueSS[,1]-valueMS[,1]))
	valueMM_MS<-data.frame(valueMM_MS<-(valueMM[,1]-valueMS[,1]))
	resultsMM_SS[i,2] = valueMM_SS[,1]
	resultsSS_MS[i,2] = valueSS_MS[,1]
	resultsMM_MS[i,2] = valueMM_MS[,1]
	}
rm(i)


pvalueMM_SS<-(nrow(subset(resultsMM_SS,resultsMM_SS[,2] <=0)))
pvalueSS_MS<-(nrow(subset(resultsSS_MS,resultsSS_MS[,2] <=0)))
pvalueMM_MS<-(nrow(subset(resultsMM_MS,resultsMM_MS[,2] <=0)))

pvalueMM_SS
pvalueSS_MS
pvalueMM_MS

rm(list = ls())

####################################################################################################
####################################################################################################
#ovary vs non-ovary
####################################################################################################
####################################################################################################

#read in data

#mel-mel

data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/total_dominance_MMH1_classified_B.txt",header = TRUE)
#data1<-read.delim("/Final/zhr_z30/mel-mel_P+H2/outputs/total_dominance_MMH2_classified_B.txt",header = TRUE)

#sim-sec

data2<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/total_dominance_SSH1_classified_B.txt",header = TRUE)
#data2<-read.delim("/Final/sim_sec/sim-sec_P+H2/outputs/total_dominance_SSH2_classified_B.txt",header = TRUE)

#mel-sim

data3<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/total_dominance_MSH1_classified_B.txt",header = TRUE)
#data3<-read.delim("/Final/mel_sim/mel-sim_P+H2/outputs/total_dominance_MSH2_classified_B.txt",header = TRUE)

#tot<-read.delim("/Final/total-genes.txt", header = TRUE)
#IN MODENCODE, FPKM > 1 IN 4 DAY OLD MATED ADULT FEMALE OVARIES AND FPKM < 1 IN ADULT MATED 4-DAY OLD FEMALE HEADS AND CARCASS
ovary <- read.delim("/Final/revision/ovary2.txt",header = TRUE)
#notovary <- read.delim("/Final/revision/NotOvary.txt",header = TRUE)

####################################################################################################
####################################################################################################

#columns in total dominance classifications

#5=data1$H_P1diff = ((log2(((data1[,4])/(sum(data1[,4])))*100)) - (log2(((data1[,2])/sum(data1[,2]))*100)))
#6=data1$H_P2diff = ((log2(((data1[,4])/(sum(data1[,4])))*100)) - (log2(((data1[,3])/sum(data1[,3]))*100)))
#7=data1$additive 
#8=data1$underdominant
#9=data1$overdominant
#10=data1$par1dominant
#11=data1$par2dominant
#12=data1$conserved2

####################################################################################################
####################################################################################################

#merge data

data1O<-merge(ovary,data1, by = 'gene')
data1NO<-data.frame(data1NO<-data1[!(data1[,1] %in% data1O[,1]), 1:12])
#data1NO<-merge(notovary,data1, by = 'gene')

data2O<-merge(ovary,data2, by = 'gene')
data2NO<-data.frame(data2NO<-data2[!(data2[,1] %in% data2O[,1]), 1:12])
#data2NO<-merge(notovary,data2, by = 'gene')

data3O<-merge(ovary,data3, by = 'gene')
data3NO<-data.frame(data3NO<-data3[!(data3[,1] %in% data3O[,1]), 1:12])
#data3NO<-merge(notovary,data3, by = 'gene')

####################################################################################################
####################################################################################################

subset1O<-subset(data1O, (data1O[,8] == 1))
subset2O<-subset(data2O, (data2O[,8] == 1))
subset3O<-subset(data3O, (data3O[,8] == 1))

subset1NO<-subset(data1NO, (data1NO[,8] == 1))
subset2NO<-subset(data2NO, (data2NO[,8] == 1))
subset3NO<-subset(data3NO, (data3NO[,8] == 1))

####################################################################################################
####################################################################################################

#FETs

fisher.test(matrix(c(nrow(subset1O),(nrow(data1O)-nrow(subset1O)),nrow(subset1NO),(nrow(data1NO)-nrow(subset1NO))),nr=2),alternative = "greater");
fisher.test(matrix(c(nrow(subset2O),(nrow(data2O)-nrow(subset2O)),nrow(subset2NO),(nrow(data2NO)-nrow(subset2NO))),nr=2),alternative = "greater");
fisher.test(matrix(c(nrow(subset3O),(nrow(data3O)-nrow(subset3O)),nrow(subset3NO),(nrow(data3NO)-nrow(subset3NO))),nr=2),alternative = "greater");

nrow(subset1O)/nrow(data1O)
nrow(subset1NO)/nrow(data1NO)

nrow(subset2O)/nrow(data2O)
nrow(subset2NO)/nrow(data2NO)

nrow(subset3O)/nrow(data3O)
nrow(subset3NO)/nrow(data3NO)

rm(list = ls())

####################################################################################################
####################################################################################################

#DONE WITH TOTAL EXPRESSION ANALYSES, MOVE TO ALLELIC EXPRESSION ANALYSES.R