####################################################################################################
####################################################################################################
# ASE analyses for Coolon et al 2014
####################################################################################################
####################################################################################################

#Remove mismapping genes

####################################################################################################
####################################################################################################

#mel-mel

####################################################################################################

data1<-read.delim("/Final/zhr_z30/resequencing/zhr_z30_gDNA.mosaik.genes.txt", header=TRUE)

data1$wr1<-data1[,3]/(data1[,2]+data1[,3])
data1$wr2<-data1[,5]/(data1[,6]+data1[,5])

for (i in 1:nrow(data1)) 
	{
	if ((data1[i,2] == 0) & (data1[i,3] == 0)) {data1[i,8] = 0} else {data1[i,8] = data1[i,8]}
	if ((data1[i,5] == 0) & (data1[i,6] == 0)) {data1[i,9] = 0} else {data1[i,9] = data1[i,9]}
	}

data2<-cbind(as.character(data1[,1]), data1[,8], data1[,9])
colnames(data2)<-c('gene','mmG1','mmG2')
data2<-data.frame(data2)

MMP1<-read.delim("/Final/Total/MMP1.txt", header = TRUE)
MMP2<-read.delim("/Final/Total/MMP2.txt", header = TRUE)

MMPgenes<-(data.frame(MMP1genes<-MMP1[,1]))

data1B<-cbind(MMPgenes,MMP1[,3:5],MMP2[,3:5])
colnames(data1B)<-c('gene','MMP11','MMP12','MMP1B','MMP21','MMP22','MMP2B')

#data1B<-read.delim("/Final/zhr_z30/separate/zhr_z30_mRNA.mosaik.genes.txt", header=TRUE)

data1B$wr1<-data1B[,3]/(data1B[,2]+data1B[,3])
data1B$wr2<-data1B[,5]/(data1B[,6]+data1B[,5])

for (j in 1:nrow(data1B)) 
	{
	if ((data1B[j,2] == 0) & (data1B[j,3] == 0)) {data1B[j,8] = 0} else {data1B[j,8] = data1B[j,8]}
	if ((data1B[j,5] == 0) & (data1B[j,6] == 0)) {data1B[j,9] = 0} else {data1B[j,9] = data1B[j,9]}
	}

data2B<-cbind(as.character(data1B[,1]), data1B[,8], data1B[,9])
colnames(data2B)<-c('gene','mmC1','mmC2')
data2B<-data.frame(data2B)

data3<-merge(data2,data2B, by = 'gene')

write.table(data3, file = "/Final/zhr_z30/resequencing/zhr_z30_mismap-prop_genes_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(data3, file = "/Final/zhr_z30/separate/zhr_z30_mismap-prop_genes_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(i,j,data1,data1B,data2,data2B,data3)

data1<-read.delim("/Final/zhr_z30/resequencing/zhr_z30_mismap-prop_genes_120113.txt", header=TRUE)

data2<-subset(data1,((data1[,2] <= 0.1) & (data1[,3] <= 0.1)))
data2B<-subset(data1,((data1[,4] <= 0.1) & (data1[,5] <= 0.1)))

data3<-subset(data1, ((data1[,2] <= 0.1) & (data1[,3] <= 0.1) & (data1[,4] <= 0.1) & (data1[,5] <= 0.1)))
data3B<-data3[,1]
data3B<-data.frame(data3B)
colnames(data3B)<-c('gene')

write.table(data3B, file = "/Final/zhr_z30/mismapping/zhr_z30_bad_genes_removed_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)

pdf(file = "/Final/zhr_z30/resequencing/zhr_z30_mtozG-mismap_120113.pdf")
hist(log2(data1[,2]), freq = FALSE, breaks = 20)
dev.off()
pdf(file = "/Final/zhr_z30/resequencing/zhr_z30_ztomG-mismap_120113.pdf")
hist(log2(data1[,3]), freq = FALSE, breaks = 20)
dev.off()
pdf(file = "/Final/zhr_z30/separate/zhr_z30_mtozC-mismap_120113.pdf")
hist(log2(data1[,4]), freq = FALSE, breaks = 20)
dev.off()
pdf(file = "/Final/zhr_z30/separate/zhr_z30_ztomC-mismap_120113.pdf")
hist(log2(data1[,5]), freq = FALSE, breaks = 20)
dev.off()

rm(list=ls())

####################################################################################################
####################################################################################################
####################################################################################################

#sim-sec

####################################################################################################

data1<-read.delim("/Final/sim_sec/resequencing/tsimbazaza_droSec1_gDNA.mosaik.genes.txt", header=TRUE)

data1$wr1<-data1[,3]/(data1[,2]+data1[,3])
data1$wr2<-data1[,5]/(data1[,6]+data1[,5])

for (i in 1:nrow(data1)) 
	{
	if ((data1[i,2] == 0) & (data1[i,3] == 0)) {data1[i,8] = 0} else {data1[i,8] = data1[i,8]}
	if ((data1[i,5] == 0) & (data1[i,6] == 0)) {data1[i,9] = 0} else {data1[i,9] = data1[i,9]}
	}

data2<-cbind(as.character(data1[,1]), data1[,8], data1[,9])
colnames(data2)<-c('gene','mmG1','mmG2')
data2<-data.frame(data2)

SSP1<-read.delim("/Final/Total/SSP1.txt", header = TRUE)
SSP2<-read.delim("/Final/Total/SSP2.txt", header = TRUE)

SSPgenes<-(data.frame(SSP1genes<-SSP1[,1]))

data1B<-cbind(SSPgenes,SSP1[,3:5],SSP2[,3:5])
colnames(data1B)<-c('gene','SSP11','SSP12','SSP1B','SSP21','SSP22','SSP2B')

#data1B<-read.delim("/Final/sim_sec/separate/tsimbazaza_droSec1_mRNA.mosaik.genes.txt", header=TRUE)

data1B$wr1<-data1B[,3]/(data1B[,2]+data1B[,3])
data1B$wr2<-data1B[,5]/(data1B[,6]+data1B[,5])

for (j in 1:nrow(data1B)) 
	{
	if ((data1B[j,2] == 0) & (data1B[j,3] == 0)) {data1B[j,8] = 0} else {data1B[j,8] = data1B[j,8]}
	if ((data1B[j,5] == 0) & (data1B[j,6] == 0)) {data1B[j,9] = 0} else {data1B[j,9] = data1B[j,9]}
	}

data2B<-cbind(as.character(data1B[,1]), data1B[,8], data1B[,9])
colnames(data2B)<-c('gene','mmC1','mmC2')
data2B<-data.frame(data2B)

data3<-merge(data2,data2B, by = 'gene')

write.table(data3, file = "/Final/sim_sec/resequencing/tsimbazaza_droSec1_mismap-prop_genes_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(data3, file = "/Final/sim_sec/separate/tsimbazaza_droSec1_mismap-prop_genes_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(i,j,data1,data1B,data2,data2B,data3)

data1<-read.delim("/Final/sim_sec/resequencing/tsimbazaza_droSec1_mismap-prop_genes_120113.txt", header=TRUE)

data2<-subset(data1,((data1[,2] <= 0.1) & (data1[,3] <= 0.1)))
data2B<-subset(data1,((data1[,4] <= 0.1) & (data1[,5] <= 0.1)))

data3<-subset(data1, ((data1[,2] <= 0.1) & (data1[,3] <= 0.1) & (data1[,4] <= 0.1) & (data1[,5] <= 0.1)))
data3B<-data3[,1]
data3B<-data.frame(data3B)
colnames(data3B)<-c('gene')

write.table(data3B, file = "/Final/sim_sec/mismapping/tsimbazaza_droSec1_bad_genes_removed_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)

pdf(file = "/Final/sim_sec/resequencing/sim_sec_sitoseG-mismap_120113.pdf")
hist(log2(data1[,2]), freq = FALSE, breaks = 20)
dev.off()
pdf(file = "/Final/sim_sec/resequencing/sim_sec_setosiG-mismap_120113.pdf")
hist(log2(data1[,3]), freq = FALSE, breaks = 20)
dev.off()
pdf(file = "/Final/sim_sec/separate/sim_sec_sitoseC-mismap_120113.pdf")
hist(log2(data1[,4]), freq = FALSE, breaks = 20)
dev.off()
pdf(file = "/Final/sim_sec/separate/sim_sec_setosiC-mismap_120113.pdf")
hist(log2(data1[,5]), freq = FALSE, breaks = 20)
dev.off()

rm(list=ls())

####################################################################################################
####################################################################################################
####################################################################################################

#mel-sim

####################################################################################################

data1<-read.delim("/Final/mel_sim/resequencing/zhr_tsimbazaza_gDNA.mosaik.genes.txt", header=TRUE)

data1$wr1<-data1[,3]/(data1[,2]+data1[,3])
data1$wr2<-data1[,5]/(data1[,6]+data1[,5])

for (i in 1:nrow(data1)) 
	{
	if ((data1[i,2] == 0) & (data1[i,3] == 0)) {data1[i,8] = 0} else {data1[i,8] = data1[i,8]}
	if ((data1[i,5] == 0) & (data1[i,6] == 0)) {data1[i,9] = 0} else {data1[i,9] = data1[i,9]}
	}

data2<-cbind(as.character(data1[,1]), data1[,8], data1[,9])
colnames(data2)<-c('gene','mmG1','mmG2')
data2<-data.frame(data2)

MSP1<-read.delim("/Final/Total/MSP1.txt", header = TRUE)
MSP2<-read.delim("/Final/Total/MSP2.txt", header = TRUE)

MSPgenes<-(data.frame(MSP1genes<-MSP1[,1]))

data1B<-cbind(MSPgenes,MSP1[,3:5],MSP2[,3:5])
colnames(data1B)<-c('gene','MSP11','MSP12','MSP1B','MSP21','MSP22','MSP2B')

#data1B<-read.delim("/Final/mel_sim/separate/zhr_tsimbazaza_mRNA.mosaik.genes.txt", header=TRUE)

data1B$wr1<-data1B[,3]/(data1B[,2]+data1B[,3])
data1B$wr2<-data1B[,5]/(data1B[,6]+data1B[,5])

for (j in 1:nrow(data1B)) 
	{
	if ((data1B[j,2] == 0) & (data1B[j,3] == 0)) {data1B[j,8] = 0} else {data1B[j,8] = data1B[j,8]}
	if ((data1B[j,5] == 0) & (data1B[j,6] == 0)) {data1B[j,9] = 0} else {data1B[j,9] = data1B[j,9]}
	}

data2B<-cbind(as.character(data1B[,1]), data1B[,8], data1B[,9])
colnames(data2B)<-c('gene','mmC1','mmC2')
data2B<-data.frame(data2B)

data3<-merge(data2,data2B, by = 'gene')

write.table(data3, file = "/Final/mel_sim/resequencing/zhr_tsimbazaza_mismap-prop_genes_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(data3, file = "/Final/mel_sim/separate/zhr_tsimbazaza_mismap-prop_genes_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(i,j,data1,data1B,data2,data2B,data3)

data1<-read.delim("/Final/mel_sim/resequencing/zhr_tsimbazaza_mismap-prop_genes_120113.txt", header=TRUE)

data2<-subset(data1,((data1[,2] <= 0.1) & (data1[,3] <= 0.1)))
data2B<-subset(data1,((data1[,4] <= 0.1) & (data1[,5] <= 0.1)))

data3<-subset(data1, ((data1[,2] <= 0.1) & (data1[,3] <= 0.1) & (data1[,4] <= 0.1) & (data1[,5] <= 0.1)))
data3B<-data3[,1]
data3B<-data.frame(data3B)
colnames(data3B)<-c('gene')

write.table(data3B, file = "/Final/mel_sim/mismapping/zhr_tsimbazaza_bad_genes_removed_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)

pdf(file = "/Final/mel_sim/resequencing/mel-sim_mtosG-mismap_120113.pdf")
hist(log2(data1[,2]), freq = FALSE, breaks = 20)
dev.off()
pdf(file = "/Final/mel_sim/resequencing/mel-sim_stomG-mismap_120113.pdf")
hist(log2(data1[,3]), freq = FALSE, breaks = 20)
dev.off()
pdf(file = "/Final/mel_sim/separate/mel-sim_mtosC-mismap_120113.pdf")
hist(log2(data1[,4]), freq = FALSE, breaks = 20)
dev.off()
pdf(file = "/Final/mel_sim/separate/mel-sim_stomC-mismap_120113.pdf")
hist(log2(data1[,5]), freq = FALSE, breaks = 20)
dev.off()

rm(list=ls())

####################################################################################################
####################################################################################################
####################################################################################################
#create new ASE datasets without mismapping genes

data1A<-read.delim("/Final/zhr_z30/mismapping/zhr_z30_bad_genes_removed_120113.txt",header = TRUE)
data2A<-read.delim("/Final/zhr_z30/mel-mel_P+H1/zhr+z30_zhrXz30_mRNA.mosaik.genes_down.txt",header = TRUE)
data3A<-read.delim("/Final/zhr_z30/mel-mel_P+H2/zhr+z30_z30Xzhr_mRNA.mosaik.genes_down.txt",header = TRUE)
data4A<-read.delim("/Final/zhr_z30/mel-mel_H1+H2/zhrXz30_z30Xzhr_mRNA.mosaik.genes_down.txt",header = TRUE)

data2A2<-merge(data1A,data2A, by = 'gene')
write.table(data2A2, file = "/Final/zhr_z30/mel-mel_P+H1/zhr+z30_zhrXz30_mRNA.mosaik.genes_ASE.txt",sep="\t",quote=FALSE,row.names=FALSE)

data3A2<-merge(data1A,data3A, by = 'gene')
write.table(data3A2, file = "/Final/zhr_z30/mel-mel_P+H2/zhr+z30_z30Xzhr_mRNA.mosaik.genes_ASE.txt",sep="\t",quote=FALSE,row.names=FALSE)

data4A2<-merge(data1A,data4A, by = 'gene')
write.table(data4A2, file = "/Final/zhr_z30/mel-mel_H1+H2/zhrXz30_z30Xzhr_mRNA.mosaik.genes_ASE.txt",sep="\t",quote=FALSE,row.names=FALSE)

data1B<-read.delim("/Final/sim_sec/mismapping/tsimbazaza_droSec1_bad_genes_removed_120113.txt",header = TRUE)
data2B<-read.delim("/Final/sim_sec/sim-sec_P+H1/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA.mosaik.genes_down.txt",header = TRUE)
data3B<-read.delim("/Final/sim_sec/sim-sec_P+H2/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA.mosaik.genes_down.txt",header = TRUE)
data4B<-read.delim("/Final/sim_sec/sim-sec_H1+H2/tsimbazazaXdroSec1_droSec1Xtsimbazaza_mRNA.mosaik.genes_down.txt",header = TRUE)

data2B2<-merge(data1B,data2B, by = 'gene')
write.table(data2B2, file = "/Final/sim_sec/sim-sec_P+H1/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA.mosaik.genes_ASE.txt",sep="\t",quote=FALSE,row.names=FALSE)

data3B2<-merge(data1B,data3B, by = 'gene')
write.table(data3B2, file = "/Final/sim_sec/sim-sec_P+H2/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA.mosaik.genes_ASE.txt",sep="\t",quote=FALSE,row.names=FALSE)

data4B2<-merge(data1B,data4B, by = 'gene')
write.table(data4B2, file = "/Final/sim_sec/sim-sec_H1+H2/tsimbazazaXdroSec1_droSec1Xtsimbazaza_mRNA.mosaik.genes_ASE.txt",sep="\t",quote=FALSE,row.names=FALSE)

data1C<-read.delim("/Final/mel_sim/mismapping/zhr_tsimbazaza_bad_genes_removed_120113.txt",header = TRUE)
data2C<-read.delim("/Final/mel_sim/mel-sim_P+H1/zhr+tsimbazaza_zhrXtsimbazaza_mRNA.mosaik.genes_down.txt",header = TRUE)
data3C<-read.delim("/Final/mel_sim/mel-sim_P+H2/zhr+tsimbazaza_tsimbazazaXzhr_mRNA.mosaik.genes_down.txt",header = TRUE)
data4C<-read.delim("/Final/mel_sim/mel-sim_H1+H2/zhrXtsimbazaza_tsimbazazaXzhr_mRNA.mosaik.genes_down.txt",header = TRUE)

data2C2<-merge(data1C,data2C, by = 'gene')
write.table(data2C2, file = "/Final/mel_sim/mel-sim_P+H1/zhr+tsimbazaza_zhrXtsimbazaza_mRNA.mosaik.genes_ASE.txt",sep="\t",quote=FALSE,row.names=FALSE)

data3C2<-merge(data1C,data3C, by = 'gene')
write.table(data3C2, file = "/Final/mel_sim/mel-sim_P+H2/zhr+tsimbazaza_tsimbazazaXzhr_mRNA.mosaik.genes_ASE.txt",sep="\t",quote=FALSE,row.names=FALSE)

data4C2<-merge(data1C,data4C, by = 'gene')
write.table(data4C2, file = "/Final/mel_sim/mel-sim_H1+H2/zhrXtsimbazaza_tsimbazazaXzhr_mRNA.mosaik.genes_ASE.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################

#read in data

data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/zhr+z30_zhrXz30_mRNA.mosaik.genes_ASE.txt",header = TRUE)
data2<-read.delim("/Final/zhr_z30/mel-mel_P+H2/zhr+z30_z30Xzhr_mRNA.mosaik.genes_ASE.txt",header = TRUE)
data3<-read.delim("/Final/zhr_z30/mel-mel_H1+H2/zhrXz30_z30Xzhr_mRNA.mosaik.genes_ASE.txt",header = TRUE)


data7<-read.delim("/Final/sim_sec/sim-sec_P+H1/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA.mosaik.genes_ASE.txt",header = TRUE)
data8<-read.delim("/Final/sim_sec/sim-sec_P+H2/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA.mosaik.genes_ASE.txt",header = TRUE)
data9<-read.delim("/Final/sim_sec/sim-sec_H1+H2/tsimbazazaXdroSec1_droSec1Xtsimbazaza_mRNA.mosaik.genes_ASE.txt",header = TRUE)


data4<-read.delim("/Final/mel_sim/mel-sim_P+H1/zhr+tsimbazaza_zhrXtsimbazaza_mRNA.mosaik.genes_ASE.txt",header = TRUE)
data5<-read.delim("/Final/mel_sim/mel-sim_P+H2/zhr+tsimbazaza_tsimbazazaXzhr_mRNA.mosaik.genes_ASE.txt",header = TRUE)
data6<-read.delim("/Final/mel_sim/mel-sim_H1+H2/zhrXtsimbazaza_tsimbazazaXzhr_mRNA.mosaik.genes_ASE.txt",header = TRUE)

####################################################################################################
####################################################################################################
#mel-mel genes

data11<-subset(data1, ((data1[,2]+data1[,3]) >= 20 & (data1[,5]+data1[,6] >= 20)))
data21<-subset(data2, ((data2[,2]+data2[,3]) >= 20 & (data2[,5]+data2[,6] >= 20)))
data31<-subset(data3, ((data3[,2]+data3[,3]) >= 20 & (data3[,5]+data3[,6] >= 20)))

####################################################################################################

#sim-sec genes

data71<-subset(data7, ((data7[,2]+data7[,3]) >= 20 & (data7[,5]+data7[,6] >= 20)))
data81<-subset(data8, ((data8[,2]+data8[,3]) >= 20 & (data8[,5]+data8[,6] >= 20)))
data91<-subset(data9, ((data9[,2]+data9[,3]) >= 20 & (data9[,5]+data9[,6] >= 20)))

###################################################################################################

#mel-sim genes

data41<-subset(data4, ((data4[,2]+data4[,3]) >= 20 & (data4[,5]+data4[,6] >= 20)))
data51<-subset(data5, ((data5[,2]+data5[,3]) >= 20 & (data5[,5]+data5[,6] >= 20)))
data61<-subset(data6, ((data6[,2]+data6[,3]) >= 20 & (data6[,5]+data6[,6] >= 20)))

###################################################################################################
###################################################################################################

#write out files for all genes 

#zhr-z30

write.table(data11,file = "/Final/zhr_z30/mel-mel_P+H1/zhr+z30_zhrXz30_mRNA.mosaik.genes.ALL.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(data21,file = "/Final/zhr_z30/mel-mel_P+H2/zhr+z30_z30Xzhr_mRNA.mosaik.genes.ALL.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(data31,file = "/Final/zhr_z30/mel-mel_H1+H2/zhrXz30_z30Xzhr_mRNA.mosaik.genes.ALL.txt",sep="\t",quote=FALSE,row.names=FALSE)

#sim-sec

write.table(data71,file = "/Final/sim_sec/sim-sec_P+H1/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA.mosaik.genes.ALL.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(data81,file = "/Final/sim_sec/sim-sec_P+H2/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA.mosaik.genes.ALL.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(data91,file = "/Final/sim_sec/sim-sec_H1+H2/tsimbazazaXdroSec1_droSec1Xtsimbazaza_mRNA.mosaik.genes.ALL.txt",sep="\t",quote=FALSE,row.names=FALSE)

#mel-sim

write.table(data41,file = "/Final/mel_sim/mel-sim_P+H1/zhr+tsimbazaza_zhrXtsimbazaza_mRNA.mosaik.genes.ALL.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(data51,file = "/Final/mel_sim/mel-sim_P+H2/zhr+tsimbazaza_tsimbazazaXzhr_mRNA.mosaik.genes.ALL.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(data61,file = "/Final/mel_sim/mel-sim_H1+H2/zhrXtsimbazaza_tsimbazazaXzhr_mRNA.mosaik.genes.ALL.txt",sep="\t",quote=FALSE,row.names=FALSE)

####################################################################################################
####################################################################################################

#make common gene set

dataA<-merge(data11,data21, by = 'gene')
dataB<-merge(dataA,data31, by = 'gene')
dataC<-merge(dataB,data71, by = 'gene')
dataD<-merge(dataC,data81, by = 'gene')
dataE<-merge(dataD,data91, by = 'gene')
dataF<-merge(dataE,data41, by = 'gene')
dataG<-merge(dataF,data51, by = 'gene')
dataH<-merge(dataG,data61, by = 'gene')

dataGENES<-dataH[,1]
dataGENES<-data.frame(dataGENES)
colnames(dataGENES)<-c('gene')

####################################################################################################
####################################################################################################
#reduce to common set

data11<-merge(dataGENES,data11, by = 'gene')
data21<-merge(dataGENES,data21, by = 'gene')
data31<-merge(dataGENES,data31, by = 'gene')
data71<-merge(dataGENES,data71, by = 'gene')
data81<-merge(dataGENES,data81, by = 'gene')
data91<-merge(dataGENES,data91, by = 'gene')
data41<-merge(dataGENES,data41, by = 'gene')
data51<-merge(dataGENES,data51, by = 'gene')
data61<-merge(dataGENES,data61, by = 'gene')

####################################################################################################
####################################################################################################
#write out files 

#zhr-z30

write.table(data11,file = "/Final/zhr_z30/mel-mel_P+H1/zhr+z30_zhrXz30_mRNA.mosaik.genes_CUT.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(data21,file = "/Final/zhr_z30/mel-mel_P+H2/zhr+z30_z30Xzhr_mRNA.mosaik.genes_CUT.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(data31,file = "/Final/zhr_z30/mel-mel_H1+H2/zhrXz30_z30Xzhr_mRNA.mosaik.genes_CUT.txt",sep="\t",quote=FALSE,row.names=FALSE)

#sim-sec

write.table(data71,file = "/Final/sim_sec/sim-sec_P+H1/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA.mosaik.genes_CUT.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(data81,file = "/Final/sim_sec/sim-sec_P+H2/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA.mosaik.genes_CUT.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(data91,file = "/Final/sim_sec/sim-sec_H1+H2/tsimbazazaXdroSec1_droSec1Xtsimbazaza_mRNA.mosaik.genes_CUT.txt",sep="\t",quote=FALSE,row.names=FALSE)

#mel-sim

write.table(data41,file = "/Final/mel_sim/mel-sim_P+H1/zhr+tsimbazaza_zhrXtsimbazaza_mRNA.mosaik.genes_CUT.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(data51,file = "/Final/mel_sim/mel-sim_P+H2/zhr+tsimbazaza_tsimbazazaXzhr_mRNA.mosaik.genes_CUT.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(data61,file = "/Final/mel_sim/mel-sim_H1+H2/zhrXtsimbazaza_tsimbazazaXzhr_mRNA.mosaik.genes_CUT.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################
#hypergeometric downsampling
####################################################################################################
####################################################################################################

#read in data

#mel-mel
data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/zhr+z30_zhrXz30_mRNA.mosaik.genes_CUT.txt", header=TRUE)
data2<-read.delim("/Final/zhr_z30/mel-mel_P+H2/zhr+z30_z30Xzhr_mRNA.mosaik.genes_CUT.txt", header=TRUE)

#sim-sec
data3<-read.delim("/Final/sim_sec/sim-sec_P+H1/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA.mosaik.genes_CUT.txt", header=TRUE)
data4<-read.delim("/Final/sim_sec/sim-sec_P+H2/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA.mosaik.genes_CUT.txt", header=TRUE)

#mel-sim
data5<-read.delim("/Final/mel_sim/mel-sim_P+H1/zhr+tsimbazaza_zhrXtsimbazaza_mRNA.mosaik.genes_CUT.txt", header=TRUE)
data6<-read.delim("/Final/mel_sim/mel-sim_P+H2/zhr+tsimbazaza_tsimbazazaXzhr_mRNA.mosaik.genes_CUT.txt", header=TRUE)

#############################################column additions#######################################

data1$ptot = data1[,2]+data1[,3]
data1$htot = data1[,5]+data1[,6]

data2$ptot = data2[,2]+data2[,3]
data2$htot = data2[,5]+data2[,6]

data3$ptot = data3[,2]+data3[,3]
data3$htot = data3[,5]+data3[,6]

data4$ptot = data4[,2]+data4[,3]
data4$htot = data4[,5]+data4[,6]

data5$ptot = data5[,2]+data5[,3]
data5$htot = data5[,5]+data5[,6]

data6$ptot = data6[,2]+data6[,3]
data6$htot = data6[,5]+data6[,6]

#############################################column names###########################################

#1 = locus
#2 = p1
#3 = p2
#4 = pboth
#5 = h1
#6 = h2
#7 = hboth
#8 = ptot
#9 = htot

####################################################################################################

#reconfigure

data1b<-cbind(as.character(data1[,1]), data1[,2], data1[,3], data1[,8], data1[,5], data1[,6], data1[,9])
colnames(data1b)<-c('gene','mm1P1','mm1P2','mm1Ptot','mm1H1','mm1H2','mm1Htot')
data1b<-data.frame(data1b)

data2b<-cbind(as.character(data2[,1]), data2[,2], data2[,3], data2[,8], data2[,5], data2[,6], data2[,9])
colnames(data2b)<-c('gene','mm2P1','mm2P2','mm1Ptot','mm2H1','mm2H2','mm2Htot')
data2b<-data.frame(data2b)

data3b<-cbind(as.character(data3[,1]), data3[,2], data3[,3], data3[,8], data3[,5], data3[,6], data3[,9])
colnames(data3b)<-c('gene','ss1P1','ss1P2','ss1Ptot','ss1H1','ss1H2','ss1Htot')
data3b<-data.frame(data3b)

data4b<-cbind(as.character(data4[,1]), data4[,2], data4[,3], data4[,8], data4[,5], data4[,6], data4[,9])
colnames(data4b)<-c('gene','ss2P1','ss2P2','ss1Ptot','ss2H1','ss2H2','ss2Htot')
data4b<-data.frame(data4b)

data5b<-cbind(as.character(data5[,1]), data5[,2], data5[,3], data5[,8], data5[,5], data5[,6], data5[,9])
colnames(data5b)<-c('gene','ms1P1','ms1P2','ms1Ptot','ms1H1','ms1H2','ms1Htot')
data5b<-data.frame(data5b)

data6b<-cbind(as.character(data6[,1]), data6[,2], data6[,3], data6[,8], data6[,5], data6[,6], data6[,9])
colnames(data6b)<-c('gene','ms2P1','ms2P2','ms1Ptot','ms2H1','ms2H2','ms2Htot')
data6b<-data.frame(data6b)

#############################################subset common#########################################

data8a<-merge(data1b, data2b, by='gene')
data8b<-merge(data8a, data3b, by='gene')
data8c<-merge(data8b, data4b, by='gene')
data8d<-merge(data8c, data5b, by='gene')
data8e<-merge(data8d, data6b, by='gene')

data9<-cbind(data8e[,1:7],data8e[,1],data8e[,8:13],data8e[,1],data8e[,14:19],data8e[,1],data8e[,20:25],data8e[,1],data8e[,26:31],data8e[,1],data8e[,32:37])

write.table(data9, file = "/Final/Meta/meta_all_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

data1<-read.delim("/Final/Meta/meta_all_120113.txt", header=TRUE)

#############################################column names###########################################

#file	gene	P1		P2		Ptot	H1		H2		Htot
#mm1	1		2		3		4		5		6		7
#mm2			8		9		10		11		12		13
#ss1			14		15		16		17		18		19
#ss2			20		21		22		23		24		25
#ms1			26		27		28		29		30		31
#ms2			32		33		34		35		36		37

###################################################################################################
#############################################column names###########################################

#file	gene	P1		P2		Ptot	H1		H2		Htot
#mm1	1		2		3		4		5		6		7
#mm2	8		9		10		11		12		13		14
#ss1	15		16		17		18		19		20		21
#ss2	22		23		24		25		26		27		28
#ms1	29		30		31		32		33		34		35
#ms2	36		37		38		39		40		41		42

###################################################################################################

#43
data1$mmP1 = c(-1:-1)
#44
data1$mmP2 = c(-1:-1)

#45
data1$siseP1 = c(-1:-1)
#46
data1$siseP2 = c(-1:-1)

#47
data1$msiP1 = c(-1:-1)
#48
data1$msiP2 = c(-1:-1)

#49
data1$mm1H1new = c(-1:-1)
#50
data1$mm1H2new = c(-1:-1)
#51
data1$mm2H1new = c(-1:-1)
#52
data1$mm2H2new = c(-1:-1)

#53
data1$sise1H1new = c(-1:-1)
#54
data1$sise1H2new = c(-1:-1)
#55
data1$sise2H1new = c(-1:-1)
#56
data1$sise2H2new = c(-1:-1)

#57
data1$msi1H1new = c(-1:-1)
#58
data1$msi1H2new = c(-1:-1)
#59
data1$msi2H1new = c(-1:-1)
#60
data1$msi2H2new = c(-1:-1)

for (i in 1:nrow(data1)) 
	{
	min<-min(data1[i,4],data1[i,18],data1[i,32],data1[i,7],data1[i,14],data1[i,21],data1[i,28],data1[i,35],data1[i,42])
	data1[i,43] <- rhyper(1,data1[i,2],data1[i,3],min)
	data1[i,44] <- min-data1[i,43]
	data1[i,45] <- rhyper(1,data1[i,16],data1[i,17],min)
	data1[i,46] <- min-data1[i,45]
	data1[i,47] <- rhyper(1,data1[i,30],data1[i,31],min)
	data1[i,48] <- min-data1[i,47]
	data1[i,49] <- rhyper(1,data1[i,5],data1[i,6],min)
	data1[i,50] <- min-data1[i,49]
	data1[i,51] <- rhyper(1,data1[i,12],data1[i,13],min)
	data1[i,52] <- min-data1[i,51]
	data1[i,53] <- rhyper(1,data1[i,19],data1[i,20],min)
	data1[i,54] <- min-data1[i,53]
	data1[i,55] <- rhyper(1,data1[i,26],data1[i,27],min)
	data1[i,56] <- min-data1[i,55]
	data1[i,57] <- rhyper(1,data1[i,33],data1[i,34],min)
	data1[i,58] <- min-data1[i,57]
	data1[i,59] <- rhyper(1,data1[i,40],data1[i,41],min)
	data1[i,60] <- min-data1[i,59]
	}

###################################################################################################
#cbind columns for files

data2<-cbind(as.character(data1[,1]),data1[,43],data1[,44],data1[,1],data1[,49],data1[,50],data1[,1])
colnames(data2)<-c('gene', 'P1zhr', 'P2z30', 'name2', 'H1zhr', 'H1z30','name3')
data2<-data.frame(data2)

data3<-cbind(as.character(data1[,1]),data1[,43],data1[,44],data1[,1],data1[,51],data1[,52],data1[,1])
colnames(data3)<-c('gene', 'P1zhr', 'P2z30', 'name2', 'H2zhr', 'H2z30','name3')
data3<-data.frame(data3)

data4<-cbind(as.character(data1[,1]),data1[,49],data1[,50],data1[,1],data1[,51],data1[,52],data1[,1])
colnames(data4)<-c('gene', 'H1zhr', 'H1z30', 'name2', 'H2zhr', 'H2z30','name3')
data4<-data.frame(data4)


data5<-cbind(as.character(data1[,1]),data1[,45],data1[,46],data1[,1],data1[,53],data1[,54],data1[,1])
colnames(data5)<-c('gene', 'P1sim', 'P2sec', 'name2', 'H1sim', 'H1sec','name3')
data5<-data.frame(data5)

data6<-cbind(as.character(data1[,1]),data1[,45],data1[,46],data1[,1],data1[,55],data1[,56],data1[,1])
colnames(data6)<-c('gene', 'P1sim', 'P2sec', 'name2', 'H2sim', 'H2sec','name3')
data6<-data.frame(data6)

data7<-cbind(as.character(data1[,1]),data1[,53],data1[,54],data1[,1],data1[,55],data1[,56],data1[,1])
colnames(data7)<-c('gene', 'H1sim', 'H1sec', 'name2', 'H2sim', 'H2sec','name3')
data7<-data.frame(data7)


data8<-cbind(as.character(data1[,1]),data1[,47],data1[,48],data1[,1],data1[,57],data1[,58],data1[,1])
colnames(data8)<-c('gene', 'P1mel', 'P2sim', 'name2', 'H1mel', 'H1sim','name3')
data8<-data.frame(data8)

data9<-cbind(as.character(data1[,1]),data1[,47],data1[,48],data1[,1],data1[,59],data1[,60],data1[,1])
colnames(data9)<-c('gene', 'P1mel', 'P2sim', 'name2', 'H2mel', 'H2sim','name3')
data9<-data.frame(data9)

data10<-cbind(as.character(data1[,1]),data1[,57],data1[,58],data1[,1],data1[,59],data1[,60],data1[,1])
colnames(data10)<-c('gene', 'H1mel', 'H1sim', 'name2', 'H2mel', 'H2sim','name3')
data10<-data.frame(data10)


#write out corrected files
write.table(data2, file = '/Final/zhr_z30/mel-mel_P+H1/zhr+z30_zhrXz30_mRNA_meta.mosaik.genes.FINAL.txt',sep="\t",quote=FALSE,row.names=FALSE)
write.table(data3, file = '/Final/zhr_z30/mel-mel_P+H2/zhr+z30_z30Xzhr_mRNA_meta.mosaik.genes.FINAL.txt',sep="\t",quote=FALSE,row.names=FALSE)
write.table(data4, file = '/Final/zhr_z30/mel-mel_H1+H2/zhrXz30_z30Xzhr_mRNA_meta.mosaik.genes.FINAL.txt',sep="\t",quote=FALSE,row.names=FALSE)

write.table(data5, file = '/Final/sim_sec/sim-sec_P+H1/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta.mosaik.genes.FINAL.txt',sep="\t",quote=FALSE,row.names=FALSE)
write.table(data6, file = '/Final/sim_sec/sim-sec_P+H2/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA_meta.mosaik.genes.FINAL.txt',sep="\t",quote=FALSE,row.names=FALSE)
write.table(data7, file = '/Final/sim_sec/sim-sec_H1+H2/tsimbazazaXdroSec1_droSec1Xtsimbazaza_mRNA_meta.mosaik.genes.FINAL.txt',sep="\t",quote=FALSE,row.names=FALSE)

write.table(data8, file = '/Final/mel_sim/mel-sim_P+H1/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta.mosaik.genes.FINAL.txt',sep="\t",quote=FALSE,row.names=FALSE)
write.table(data9, file = '/Final/mel_sim/mel-sim_P+H2/zhr+tsimbazaza_tsimbazazaXzhr_mRNA_meta.mosaik.genes.FINAL.txt',sep="\t",quote=FALSE,row.names=FALSE)
write.table(data10, file = '/Final/mel_sim/mel-sim_H1+H2/zhrXtsimbazaza_tsimbazazaXzhr_mRNA_meta.mosaik.genes.FINAL.txt',sep="\t",quote=FALSE,row.names=FALSE)

rm(list = ls())

#read back in to check
data1<-read.delim('/Final/zhr_z30/mel-mel_P+H1/zhr+z30_zhrXz30_mRNA_meta.mosaik.genes.FINAL.txt', header = TRUE)
data2<-read.delim('/Final/zhr_z30/mel-mel_P+H2/zhr+z30_z30Xzhr_mRNA_meta.mosaik.genes.FINAL.txt', header = TRUE)
data3<-read.delim('/Final/zhr_z30/mel-mel_H1+H2/zhrXz30_z30Xzhr_mRNA_meta.mosaik.genes.FINAL.txt', header = TRUE)

data4<-read.delim('/Final/sim_sec/sim-sec_P+H1/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta.mosaik.genes.FINAL.txt', header = TRUE)
data5<-read.delim('/Final/sim_sec/sim-sec_P+H2/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA_meta.mosaik.genes.FINAL.txt', header = TRUE)
data6<-read.delim('/Final/sim_sec/sim-sec_H1+H2/tsimbazazaXdroSec1_droSec1Xtsimbazaza_mRNA_meta.mosaik.genes.FINAL.txt', header = TRUE)

data7<-read.delim('/Final/mel_sim/mel-sim_P+H1/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta.mosaik.genes.FINAL.txt', header = TRUE)
data8<-read.delim('/Final/mel_sim/mel-sim_P+H2/zhr+tsimbazaza_tsimbazazaXzhr_mRNA_meta.mosaik.genes.FINAL.txt', header = TRUE)
data9<-read.delim('/Final/mel_sim/mel-sim_H1+H2/zhrXtsimbazaza_tsimbazazaXzhr_mRNA_meta.mosaik.genes.FINAL.txt', header = TRUE)

rm(list=ls())

####################################################################################################
####################################################################################################
#mel-mel
####################################################################################################
####################################################################################################

#cis-trans and dominance stats

FixedPrefix1 = '/'

#pick one below
type1 = 'mRNA_meta'
#type1 = 'mapBias_cut20'
#type1 = 'seqDepth_cut20'
#type1 = 'gDNA_cut20'
#type1 = 'qnorm'
#type1 = 'qnorm_cut20'
#type1 = 'mRNA'

#pick one below
unit1 = 'mosaik.genes.FINAL'
#unit1 = 'mosaik.exons.FINAL'

#pick one below
unit2 = 'gene'
#unit2 = 'exon'

#pick one below
#significance
sig = 0.05
#sig = 0.01
#sig = 0.005

date = '120113'

FixedSuffix1 = '.pdf'
FixedSuffix2 = '.txt'

###################################################################################################

#mel-mel

FixedPrefix2a = '/Final/zhr_z30/mel-mel_P+H1/'
FixedPrefix2b = '/Final/zhr_z30/mel-mel_P+H2/'
FixedPrefix2c = '/Final/zhr_z30/mel-mel_H1+H2/'

FixedPrefix3a = '/Final/zhr_z30/mel-mel_P+H1/outputs/'
FixedPrefix3b = '/Final/zhr_z30/mel-mel_P+H2/outputs/'
FixedPrefix3c = '/Final/zhr_z30/mel-mel_H1+H2/outputs/'

#InputPrefix1a = 'zhr_z30.parHyb1_'
InputPrefix1a ='zhr+z30_zhrXz30_'
#InputPrefix1b = 'zhr_z30.parHyb2_'
InputPrefix1b = 'zhr+z30_z30Xzhr_'
#InputPrefix1c = 'zhr_z30.hyb1hyb2_'
InputPrefix1c = 'zhrXz30_z30Xzhr_'

#Direction
dir1 = 'HXM'
dir2 = 'MXH'

#species
cross1 = 'zhr/z30'
par1 = 'zhr'
par2 = 'z30'

###################################################################################################
###################################################################################################

# load packages to be used.

library(binom)
library(Hmisc)

# load data files to be used, change below according to the names of 
# files intended to be used. For parent of origin tests need two hyb files.
# data1 is parents + hyb1
# data2 is parents + hyb2
# data3 is hyb1 + hyb2

data1 <- read.delim(paste(FixedPrefix2a,InputPrefix1a,type1,".",unit1,FixedSuffix2, sep = ""));
data2 <- read.delim(paste(FixedPrefix2b,InputPrefix1b,type1,".",unit1,FixedSuffix2, sep = ""));
data3 <- read.delim(paste(FixedPrefix2c,InputPrefix1c,type1,".",unit1,FixedSuffix2, sep = ""));

# Run Binomial Exact Tests on the hybrids using the Pearson-Clopper Method 
# to determine cis-regulatory changes. Change output file names to whatever you want. 
# Tests for both directions of cross are included (hyb1 and hyb2).

# file decoding
# data1 genename(1) P1(2) P2(3) Pboth(4) H11(5) H12(6) H1both(7)
# data2 genename(1) P1(2) P2(3) Pboth(4) H21(5) H22(6) H2both(7)
# data3 genename(1) H11(2) H12(3) H1both(4) H21(5) H22(6) H2both(7)

# initiate variables 
pvalsHyb1 <- NULL; 
pvalsHyb1_Par <- NULL;
pvalsHyb2 <- NULL; 
pvalsHyb2_Par <- NULL;
pvalsPar1 <- NULL; 
pvalsPar2 <- NULL;
pvalsHyb1_Hyb2 <- NULL; 
pvalsHyb1_Hyb2_FET <- NULL;
pvalsHyb1_Hyb2_FET2 <- NULL;
pvalsHyb1_Bi <- NULL;
pvalsHyb2_Bi <- NULL;

#Par1_FET2 <- NULL;
#Par2_FET2 <- NULL;

tempH1_H2_2 <- NULL;
tempH1_all <- NULL;
tempH2_all <- NULL;
tempH1 <- NULL; 
tempH1w <- NULL; 
tempH1_P <- NULL;
tempH2 <- NULL; 
tempH2w <- NULL; 
tempH2_P <- NULL;
tempP1 <- NULL; 
tempP1w <- NULL; 
tempH1_H2 <- NULL;
tempP2 <- NULL; 
tempP2w <- NULL; 
tempH1_H2_all <- NULL;
tempH1H2w <-NULL;

sumA <- sum(data1[,2])
sumB <- sum(data1[,3])
sumC <- sum(data2[,2])
sumD <- sum(data2[,3])
sum1<- (sum(data3[,2])+sum(data3[,3])+sum(data3[,4]))
sum2<- (sum(data3[,5])+sum(data3[,6])+sum(data3[,7]))

###################################################################################################

# Analysis of Data1 Parents and hybrid 1
for (i in 1:nrow(data1)) 

{	
	Par1_Bi <- binom.test(data1[[i,2]], (data1[[i,2]]+data1[[i,3]]), p = 0.5, alternative = c("t"), conf.level = 0.95);
	#Par1_FET <- fisher.test(matrix(c(data1[[i,2]],(sumA-data1[[i,2]]),data1[[i,3]],(sumB-data1[[i,3]])),nr=2));

	Hyb1_Bi <- binom.test(data1[[i,5]], (data1[[i,5]]+data1[[i,6]]), p = 0.5, alternative = c("t"), conf.level = 0.95);
	
	# collect p-values from binomial tests
	pvalsHyb1 <- rbind(pvalsHyb1,Hyb1_Bi$p.value);
	pvalsPar1 <- rbind(pvalsPar1,Par1_Bi$p.value);
	#pvalsPar1 <- rbind(pvalsPar1, Par1_FET$p.value);
	
	tempH1 <- rbind(tempH1,c(Hyb1_Bi$estimate,Hyb1_Bi$conf.int[1],Hyb1_Bi$conf.int[2],Hyb1_Bi$p.value));
	tempP1 <- rbind(tempP1,c(Par1_Bi$estimate,Par1_Bi$conf.int[1],Par1_Bi$conf.int[2],Par1_Bi$p.value));
	#tempP1 <- rbind(tempP1,c(Par1_FET$estimate,Par1_FET$conf.int[1],Par1_FET$conf.int[2],Par1_FET$p.value));
	
	# collect Wilson confidence intervals for binomial tests (to be used later for plotting seq. vs pyro)
	Par1_Bi2 <- binconf(data1[[i,2]], (data1[[i,2]]+data1[[i,3]]), alpha = 0.05, method = c("wilson"));
	
	#create space filling columns (#11 and #12) to keep spacing constant for mel-mel and other comparisons (mel-sim, sim-sec), bascially a repeat of 7 and 8
	#Par1_FET2 <-rbind(Par1_FET2,c(Par1_FET$conf.int[1],Par1_FET$conf.int[2]));
	
	Hyb1_Bi2 <- binconf(data1[[i,5]], (data1[[i,5]]+data1[[i,6]]), alpha = 0.05, method = c("wilson"));
	
	tempH1w <- rbind(tempH1w,c(Hyb1_Bi2[2],Hyb1_Bi2[3]));
	tempP1w <- rbind(tempP1w,c(Par1_Bi2[2],Par1_Bi2[3]));
	
	
	# Fisher's exact test from 2x2 tables of counts
	hyb1_par.FET <- fisher.test(matrix(c(data1[[i,5]],data1[[i,6]],data1[[i,2]],data1[[i,3]]),nr=2));
	
	# collect p-values from FETs
	pvalsHyb1_Par <- rbind(pvalsHyb1_Par,hyb1_par.FET$p.value);
	
	tempH1_P <- rbind(tempH1_P,c(hyb1_par.FET$estimate,hyb1_par.FET$conf.int[1],hyb1_par.FET$conf.int[2],hyb1_par.FET$p.value));
}

#FDR correct pvalues
pvalsHyb1.adj <- p.adjust(pvalsHyb1,method="fdr");
pvalsPar1.adj <- p.adjust(pvalsPar1,method="fdr");
pvalsHyb1_Par.adj <- p.adjust(pvalsHyb1_Par,method="fdr");

###################################################################################################

#Column contents:

#1		2		3		4		5			6			7		8		9			10				
#gene	P1.s1	P1.s2	P1.both	P1.total	P1.BETEst	P1.LB	P1.UB	P1.BETP		P1.BETQ	
#11		12		13		14		15		16			17			18		19		20			
#P1.LBw	P1.UBw	H1.s1	H1.s2	H1.both	H1.total	H1.bETEst	H1.LB	H1.UB	H1.binomP	
#21			22		23		24			25		26		27		28	
#H1.binomQ	H1.LBw	H1.UBw	H1_P.fetEst	H1_P.LB	H1_P.UB	H1_P.P	H1_P.Q

###################################################################################################

# make output file1
data.output1 <- cbind(data1[,1:4],(data1[,2]+data1[,3]),tempP1,pvalsPar1.adj,tempP1w, data1[,5:7], (data1[,5]+data1[,6]),tempH1,pvalsHyb1.adj,tempH1w,tempH1_P,pvalsHyb1_Par.adj);
colnames(data.output1) <- c("gene", "P1.s1", "P1.s2", "P1.both", "P1.total", "P1.BETEst","P1.LB","P1.UB","P1.BETP","P1.BETQ","P1.LB2","P1.UB2","H1.s1","H1.s2","H1.both","H1.total","H1.BETEst","H1.LB","H1.UB","H1.BETP","H1.BETQ","H1.LBw","H1.UBw","H1_P.fetEst","H1_P.LB","H1_P.UB","H1_P.P","H1_P.Q");
write.table(data.output1,file = paste(FixedPrefix3a,InputPrefix1a,type1,"_",unit2,"_output","_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);

###################################################################################################

# Analysis of Data2 Parents and hybrid 2
for (j in 1:nrow(data2)) 

{	
	Par2_Bi <- binom.test(data2[[j,2]], (data2[[j,2]]+data2[[j,3]]), p = 0.5, alternative = c("t"), conf.level = 0.95);
	#Par2_FET <- fisher.test(matrix(c(data2[[j,2]],(sumC-data2[[j,2]]),data2[[j,3]],(sumD-data2[[j,3]])),nr=2));

	Hyb2_Bi <- binom.test(data2[[j,5]], (data2[[j,5]]+data2[[j,6]]), p = 0.5, alternative = c("t"), conf.level = 0.95);
	
	# collect p-values from binomial tests
	pvalsHyb2 <- rbind(pvalsHyb2,Hyb2_Bi$p.value);
	pvalsPar2 <- rbind(pvalsPar2,Par2_Bi$p.value);
	#pvalsPar2 <- rbind(pvalsPar2, Par2_FET$p.value);

	
	tempH2 <- rbind(tempH2,c(Hyb2_Bi$estimate,Hyb2_Bi$conf.int[1],Hyb2_Bi$conf.int[2],Hyb2_Bi$p.value));
	tempP2 <- rbind(tempP2,c(Par2_Bi$estimate,Par2_Bi$conf.int[1],Par2_Bi$conf.int[2],Par2_Bi$p.value));
	#tempP2 <- rbind(tempP2,c(Par2_FET$estimate,Par2_FET$conf.int[1],Par2_FET$conf.int[2],Par2_FET$p.value));
		
	# collect Wilson confidence intervals for binomial tests (to be used later for plotting seq. vs pyro)
	Par2_Bi2 <- binconf(data2[[j,2]], (data2[[j,2]]+data2[[j,3]]), alpha = 0.05, method = c("wilson"));
	
	#create space filling columns (#11 and #12) to keep spacing constant for mel-mel and other comparisons(mel-sim, sim-sec), bascially a repeat of 7 and 8
	#Par2_FET2 <-rbind(Par2_FET2,c(Par2_FET$conf.int[1],Par2_FET$conf.int[2]));
	
	Hyb2_Bi2 <- binconf(data2[[j,5]], (data2[[j,5]]+data2[[j,6]]), alpha = 0.05, method = c("wilson"));
	
	tempH2w <- rbind(tempH2w,c(Hyb2_Bi2[2],Hyb2_Bi2[3]));
	tempP2w <- rbind(tempP2w,c(Par2_Bi2[2],Par2_Bi2[3]));
	
	# Fisher's exact test from 2x2 tables of counts
	hyb2_par.FET <- fisher.test(matrix(c(data2[[j,5]],data2[[j,6]],data2[[j,2]],data2[[j,3]]),nr=2));
	
	# collect p-values from FETs
	pvalsHyb2_Par <- rbind(pvalsHyb2_Par,hyb2_par.FET$p.value);
	
	tempH2_P <- rbind(tempH2_P,c(hyb2_par.FET$estimate,hyb2_par.FET$conf.int[1],hyb2_par.FET$conf.int[2],hyb2_par.FET$p.value));
}

#FDR correct pvalues
pvalsHyb2.adj <- p.adjust(pvalsHyb2,method="fdr");
pvalsPar2.adj <- p.adjust(pvalsPar2,method="fdr");
pvalsHyb2_Par.adj <- p.adjust(pvalsHyb2_Par,method="fdr");

###################################################################################################

#Column contents:

#1		2		3		4		5			6			7		8		9			10				
#gene	P2.s1	P2.s2	P2.both	P2.total	P2.BETEst	P2.LB	P2.UB	P2.BETP	P2.BETQ	
#11		12		13		14		15		16			17			18		19		20			
#P2.LBw	P2.UBw	H2.s1	H2.s2	H2.both	H2.total	H2.BETEst	H2.LB	H2.UB	H2.binomP	
#21			22		23		24			25		26		27		28	
#H2.binomQ	H2.LBw	H2.UBw	H2_P.fetEst	H2_P.LB	H2_P.UB	H2_P.P	H2_P.Q

###################################################################################################

# make output file2
data.output2 <- cbind(data2[,1:4],(data2[,2]+data2[,3]),tempP2,pvalsPar2.adj,tempP2w, data2[,5:7], (data2[,5]+data2[,6]),tempH2,pvalsHyb2.adj,tempH2w,tempH2_P,pvalsHyb2_Par.adj);
colnames(data.output2) <- c("gene", "P2.s1", "P2.s2", "P2.both", "P2.total", "P2.BETEst","P2.LB","P2.UB","P2.BETP","P2.BETQ","P2.LB2","P2.UB2","H2.s1","H2.s2","H2.both","H2.total","H2.BETEst","H2.LB","H2.UB","H2.BETP","H2.BETQ","H2.LBw","H2.UBw","H2_P.fetEst","H2_P.LB","H2_P.UB","H2_P.P","H2_P.Q");
write.table(data.output2,file = paste(FixedPrefix3b,InputPrefix1b,type1,"_",unit2,"_output","_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);

###################################################################################################

# Analysis of Data3 hybrid 1 and hybrid 2
for (k in 1:nrow(data3)) 

{	
	Hyb1_Hyb2_Bi <- binom.test((data3[[k,2]]+data3[[k,3]]), (data3[[k,2]]+data3[[k,3]]+data3[[k,5]]+data3[[k,6]]), p = 0.5, alternative = c("t"), conf.level = 0.95);
	
	# collect p-values from binomial tests
	pvalsHyb1_Hyb2 <- rbind(pvalsHyb1_Hyb2,Hyb1_Hyb2_Bi$p.value);
	
	tempH1_H2_all <-rbind(tempH1_H2_all,c(Hyb1_Hyb2_Bi$estimate,Hyb1_Hyb2_Bi$conf.int[1],Hyb1_Hyb2_Bi$conf.int[2],Hyb1_Hyb2_Bi$p.value));
	
	# collect Wilson confidence intervals for binomial tests (to be used later for plotting seq. vs pyro)
	Hyb1_Hyb2_Bi2 <- binconf((data3[[k,2]]+data3[[k,3]]), (data3[[k,2]]+data3[[k,3]]+data3[[k,5]]+data3[[k,6]]), alpha =0.05, method = c("wilson"));
	
	tempH1H2w <- rbind(tempH1H2w,c(Hyb1_Hyb2_Bi2[2],Hyb1_Hyb2_Bi2[3]));
	
	# Fisher's exact test from 2x2 tables of counts
	hyb1_hyb2.FET <- fisher.test(matrix(c(data3[[k,2]],data3[[k,3]],data3[[k,5]],data3[[k,6]]),nr=2));
	
	# collect p-values from FETs
	pvalsHyb1_Hyb2_FET <- rbind(pvalsHyb1_Hyb2_FET,hyb1_hyb2.FET$p.value);
	
	tempH1_H2 <- rbind(tempH1_H2,c(hyb1_hyb2.FET$estimate,hyb1_hyb2.FET$conf.int[1],hyb1_hyb2.FET$conf.int[2],hyb1_hyb2.FET$p.value));

	# Fisher's exact test from 2x2 tables of counts for Parent of origin effects more appropriately
	hyb1_hyb2.FET2 <- fisher.test(matrix(c((data3[[k,2]]+data3[[k,3]]+data3[[k,4]]),(sum1-(data3[[k,2]]+data3[[k,3]]+data3[[k,4]])),(data3[[k,5]]+data3[[k,6]]+data3[[k,7]]),(sum2-(data3[[k,5]]+data3[[k,6]]+data3[[k,7]]))),nr=2));
	
	# collect p-values from FET 2
	pvalsHyb1_Hyb2_FET2 <- rbind(pvalsHyb1_Hyb2_FET2,hyb1_hyb2.FET2$p.value);
	
	tempH1_H2_2 <- rbind(tempH1_H2_2,c(hyb1_hyb2.FET2$estimate,hyb1_hyb2.FET2$conf.int[1],hyb1_hyb2.FET2$conf.int[2],hyb1_hyb2.FET2$p.value));
}

###################################################################################################

#Column contents:

#1		2		3		4		5			6		7		8		9			10				
#gene	H1.s1	H1.s2	H1.both	H1.total	H2.s1	H2.s2	H2.both	H2.total	H1H2.grandtotal
#11				12		13		14			15			16			17			18			19			
#H1H2.binomEst	H1H2.LB	H1H2.UB	H1H2.binomP	H1H2.binomQ	H1H2.LBw	H1H2.UBw	H1H2.UBw	H1_H2.fetEst
#20			21			22		23		24					25				26				27			
#H1_H2_P.LB	H1_H2.UB	H1_H2.P	H1_H2.Q	H1_H2_PoO.fetEst	H1_H2_PoO.LB	H1_H2_PoO.UB	H1_H2_PoO.P
#28
#H1_H2_PoO.Q

###################################################################################################

#FDR correct pvalues
pvalsHyb1_Hyb2.adj <- p.adjust(pvalsHyb1_Hyb2,method="fdr");
pvalsHyb1_Hyb2_FET.adj <- p.adjust(pvalsHyb1_Hyb2_FET,method="fdr");
pvalsHyb1_Hyb2_FET2.adj <- p.adjust(pvalsHyb1_Hyb2_FET2,method="fdr");

# make output file3
data.output3 <- cbind(data3[,1:4],(data3[,2]+data3[,3]),data3[,5:7],(data3[,5]+data3[,6]),(data3[,2]+data3[,3]+data3[,5]+data3[,6]),tempH1_H2_all,pvalsHyb1_Hyb2.adj,tempH1H2w,tempH1_H2,pvalsHyb1_Hyb2_FET.adj,tempH1_H2_2,pvalsHyb1_Hyb2_FET2.adj);
colnames(data.output3) <- c("gene", "H1.s1", "H1.s2", "H1.both", "H1.total", "H2.s1", "H2.s2", "H2.both", "H2.total", "H1H2.grandtotal", "H1H2.binomEst","H1H2.LB","H1H2.UB","H1H2.binomP","H1H2.binomQ","H1H2.LBw","H1H2.UBw", "H1_H2.fetEst","H1_H2_P.LB","H1_H2.UB","H1_H2.P","H1_H2.Q", "H1_H2_PoO.fetEst","H1_H2_PoO.LB","H1_H2_PoO.UB","H1_H2_PoO.P","H1_H2_PoO.Q");
write.table(data.output3,file = paste(FixedPrefix3c,InputPrefix1c,type1,"_",unit2,"_output","_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);


###################################################################################################
###################################################################################################
###################################################################################################

#Visualize the data with several plots

###################################################################################################
###################################################################################################
#cis-trans plots

#Hyb1 = dir1
#Hyb2 = dir2

# Read in the data (change below to reflect the datafile you want to use
data4<-read.delim(paste(FixedPrefix3a,InputPrefix1a,type1,"_",unit2,"_output","_",date,FixedSuffix2, sep = ""), header = TRUE);
data5<-read.delim(paste(FixedPrefix3b,InputPrefix1b,type1,"_",unit2,"_output","_",date,FixedSuffix2, sep = ""), header = TRUE);

#remove "imprinted" genes

# Read in the data from H1 vs H2
data6<-read.delim(paste(FixedPrefix3c,InputPrefix1c,type1,"_",unit2,"_output","_",date,FixedSuffix2, sep = ""), header = TRUE);
#subset data
#imprint<-c(data6$gene,data6$H1_H2.Q)
#subset not imprinted
imprinted<-subset(data6,(data6$H1_H2.Q > sig))

#Keep those not imprinted
data4<-merge(data4, imprinted, by = 'gene')
data4<-data4[1:28]
data4<-data.frame(data4)

data5<-merge(data5, imprinted, by = 'gene')
data5<-data5[1:28]
data5<-data.frame(data5)

#remove data6, add back later
rm(data6)

# Make zhr/z30 ratios for both parental and hybrid
hyb1_ratio<-(data4$H1.s1/data4$H1.s2)
Par1_ratio<-(data4$P1.s1/data4$P1.s2)
hyb2_ratio<-(data5$H2.s1/data5$H2.s2)
Par2_ratio<-(data5$P2.s1/data5$P2.s2)

#Log2 transfor the ratios
log_hyb1_ratio <-log2(hyb1_ratio)
log_Par1_ratio <-log2(Par1_ratio)
log_hyb2_ratio <-log2(hyb2_ratio)
log_Par2_ratio <-log2(Par2_ratio)

#Make par/hyb ratio to properly determine cis+trans and cisXtrans
logPar1_loghyb1_rat <- log_Par1_ratio/log_hyb1_ratio
logPar2_loghyb2_rat <- log_Par2_ratio/log_hyb2_ratio

#Plots for Hybrid 1

ratios1<-cbind(log_Par1_ratio, log_hyb1_ratio, data4$H1.BETQ, data4$P1.BETQ, data4$H1_P.Q, logPar1_loghyb1_rat)

#ratios1[,1] = log_Par1_ratio
#ratios1[,2] = log_hyb1_ratio
#ratios1[,3] = H1.binomQ
#ratios1[,4] = P1.FETQ
#ratios1[,5] = H1_P.Q
#ratios1[,6] = logpar1_loghyb1_rat

# Perform tests for determining classifications for each gene
a3<-subset(ratios1, ratios1[,3] > sig & ratios1[,4] > sig & ratios1[,5] > sig)
b3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] < sig & ratios1[,5] > sig)
c3<-subset(ratios1, ratios1[,3] > sig & ratios1[,4] < sig & ratios1[,5] < sig)
d3<-subset(ratios1, ratios1[,3] > sig & ratios1[,4] > sig & ratios1[,5] < sig)
e3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] > sig & ratios1[,5] > sig)
f3<-subset(ratios1, ratios1[,3] > sig & ratios1[,4] < sig & ratios1[,5] > sig)
g3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] > sig & ratios1[,5] < sig)
#cis+trans
h3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] < sig & ratios1[,5] < sig & ratios1[,1] > 0 &  ratios1[,2] > 0 & ratios1[,6] > 1)
i3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] < sig & ratios1[,5] < sig & ratios1[,1] < 0 &  ratios1[,2] < 0 & ratios1[,6] > 1)
#cisXtrans
j3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] < sig & ratios1[,5] < sig & ratios1[,1] > 0 &  ratios1[,2] < 0)
k3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] < sig & ratios1[,5] < sig & ratios1[,1] < 0 &  ratios1[,2] > 0)
l3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] < sig & ratios1[,5] < sig & ratios1[,1] > 0 &  ratios1[,2] > 0 & ratios1[,6] < 1)
m3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] < sig & ratios1[,5] < sig & ratios1[,1] < 0 &  ratios1[,2] < 0 & ratios1[,6] < 1)

var1<-c(nrow(a3),nrow(b3),nrow(c3),nrow(g3),(nrow(h3)+nrow(i3)),(nrow(j3)+nrow(k3)+nrow(l3)+nrow(m3)),(nrow(d3)+nrow(e3)+nrow(f3)),nrow(ratios1));
data.output4 <- matrix(data=var1,nrow=1, ncol=8, byrow=FALSE)
colnames(data.output4)<-c("Conserved","All cis","All trans","Compensatory","cis+trans","cisXtrans","Ambiguous","total");
write.table(data.output4, file = paste(FixedPrefix3a,InputPrefix1a,type1,"_",unit2,"_","cis-trans_classified_",dir1,"_",sig,"_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);

lbls1<-c("Conserved","All cis","All trans","Compensatory","cis+trans","cisXtrans","Ambiguous","total")
colors1<-c("yellow","black","red","orange","blue","green","gray")
slices1<-(var1[1:7]/var1[8])

pdf(file = paste(FixedPrefix3a,"cis-trans-pie_",type1,"_",InputPrefix1a,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

pie(slices1,labels = lbls1, col = colors1, main = "PH1 cis-trans pie")

dev.off()

pdf(file = paste(FixedPrefix3a,"cis-trans-plot_",type1,"_",InputPrefix1a,"10X10_",unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

plot(ratios1[,1], ratios1[,2], type="n", xlab= paste("log2(parental (",cross1,"))", sep = ""), ylab=paste("log2(hybrid ",dir1," (",cross1,")", sep = ""), xlim=c(-10,10),ylim=c(-10,10), main = paste("cis-trans plot",type1,dir1,InputPrefix1a,unit2,sig,date, sep = " "))

#Ambiguous
points(d3, col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(e3, col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(f3, col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#cis + trans
points(h3, col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(i3, col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#cis X trans
points(j3, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(k3, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(l3, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(m3, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#All cis
points(b3, col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#All trans
points(c3, col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#Compensatory
points(g3, col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#Conserved
points(a3, col=rgb(t(col2rgb("yellow")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

abline(h=c(0))
abline(v=c(0))
abline(a=0,b=1)
dev.off()


#Plots for Hybrid 2
ratios2<-cbind(log_Par2_ratio, log_hyb2_ratio, data5$H2.BETQ, data5$P2.BETQ, data5$H2_P.Q, logPar2_loghyb2_rat)

#ratios2[,1] = log_Par2_ratio
#ratios2[,2] = log_hyb2_ratio
#ratios2[,3] = H2.binomQ
#ratios2[,4] = P2.FETQ
#ratios2[,5] = H2_P.Q
#ratios2[,6] = logPar2_loghyb2_rat

# Perform tests for determining classifications for each gene
a4<-subset(ratios2, ratios2[,3] > sig & ratios2[,4] > sig & ratios2[,5] > sig)
b4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] < sig & ratios2[,5] > sig)
c4<-subset(ratios2, ratios2[,3] > sig & ratios2[,4] < sig & ratios2[,5] < sig)
d4<-subset(ratios2, ratios2[,3] > sig & ratios2[,4] > sig & ratios2[,5] < sig)
e4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] > sig & ratios2[,5] > sig)
f4<-subset(ratios2, ratios2[,3] > sig & ratios2[,4] < sig & ratios2[,5] > sig)
g4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] > sig & ratios2[,5] < sig)
#cis+trans
h4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] < sig & ratios2[,5] < sig & ratios2[,1] > 0 &  ratios2[,2] > 0 & ratios2[,6] > 1)
i4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] < sig & ratios2[,5] < sig & ratios2[,1] < 0 &  ratios2[,2] < 0 & ratios2[,6] > 1)
#cisXtrans
j4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] < sig & ratios2[,5] < sig & ratios2[,1] > 0 &  ratios2[,2] < 0)
k4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] < sig & ratios2[,5] < sig & ratios2[,1] < 0 &  ratios2[,2] > 0)
l4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] < sig & ratios2[,5] < sig & ratios2[,1] > 0 &  ratios2[,2] > 0 & ratios2[,6] < 1)
m4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] < sig & ratios2[,5] < sig & ratios2[,1] < 0 &  ratios2[,2] < 0 & ratios2[,6] < 1)

var2<-c(nrow(a4),nrow(b4),nrow(c4),nrow(g4),(nrow(h4)+nrow(i4)),(nrow(j4)+nrow(k4)+nrow(l4)+nrow(m4)),(nrow(d4)+nrow(e4)+nrow(f4)),nrow(ratios2))
data.output5 <- matrix(data=var2,nrow=1, ncol=8, byrow=FALSE)
colnames(data.output5)<-c("Conserved","All cis","All trans","Compensatory","cis+trans","cisXtrans","Ambiguous","total");
write.table(data.output5, file = paste(FixedPrefix3b,InputPrefix1b,type1,"_",unit2,"_","cis-trans_classified_",dir2,"_",sig,"_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);

lbls2<-c("Conserved","All cis","All trans","Compensatory","cis+trans","cisXtrans","Ambiguous","total")
colors2<-c("yellow","black","red","orange","blue","green","gray")
slices2<-(var2[1:7]/var2[8])

pdf(file = paste(FixedPrefix3b,"cis-trans-pie_",type1,"_",InputPrefix1b,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

pie(slices2,labels = lbls2, col = colors2, main = "PH2 cis-trans pie")

dev.off()


pdf(file = paste(FixedPrefix3b,"cis-trans-plot_",type1,"_",InputPrefix1b,"10X10_",unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

plot(ratios2[,1], ratios2[,2], type="n", xlab=paste("log2(parental (",cross1,"))", sep = ""), ylab=paste("log2(hybrid ",dir2," ",cross1,")", sep = ""), xlim=c(-10,10),ylim=c(-10,10),main = paste("cis-trans plot",type1,dir2,InputPrefix1b,unit2,sig,date, sep = " "))

#Ambiguous
points(d4, col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(e4, col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(f4, col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#cis + trans
points(h4, col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(i4, col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#cis X trans
points(j4, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(k4, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(l4, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(m4, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#All cis
points(b4, col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#All trans
points(c4, col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#Compensatory
points(g4, col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#Conserved
points(a4, col=rgb(t(col2rgb("yellow")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

abline(h=c(0))
abline(v=c(0))
abline(a=0,b=1)
dev.off()

###################################################################################################
###################################################################################################
#dominance plots

#H1=dir1
#H2=dir2

# Restrict to genes that are significantly differentially expressed 
# between the two parental species.

#div1<-subset(data4, data4$P1.FETQ < sig)
#div2<-subset(data5, data5$P2.FETQ < sig)

#Don't restrict to significantly differentially experssed between species

div1<-subset(data4)
div2<-subset(data5)

# Convert to proportion of total
#H.both=div[,15]
# H.total=div[,16]   ...(A1+A2)...
# P.s1=div[,2]
# P.s2=div[,3]
# P.S1=div[,4]

#29 = P1 total   # div1[,2]+((div1[,2]/(div1[,2]+div1[,3]))*div1[,4])) #

div1[,29] = (div1[,2]+((div1[,2]/(div1[,2]+div1[,3]))*div1[,4]))
div2[,29] = (div2[,2]+((div2[,2]/(div2[,2]+div2[,3]))*div2[,4]))

#30 = P2 total

div1[,30] = (div1[,3]+((div1[,3]/(div1[,2]+div1[,3]))*div1[,4]))
div2[,30] = (div2[,3]+((div2[,3]/(div2[,2]+div2[,3]))*div2[,4]))

Hyb1_pct<-((div1[,16]+div1[,15])/(sum(div1[,16])+sum(div1[,15])))
Hyb2_pct<-((div2[,16]+div2[,15])/(sum(div2[,16])+sum(div2[,15])))

Mix1_P1_pct<-(div1[,29]/sum(div1[,29]))
Mix1_P2_pct<-(div1[,30]/sum(div1[,30]))

Mix2_P1_pct<-div2[,29]/(sum(div2[,29]))
Mix2_P2_pct<-div2[,30]/(sum(div2[,30]))

#if decide to go back to old way it is retained (does not use boths)
#Hyb1_pct<-div1[,16]/(sum(div1[,16]))
#Hyb2_pct<-div2[,16]/(sum(div2[,16]))
#Mix1_P1_pct<-div1[,2]/(sum(div1[,2]))
#Mix1_P2_pct<-div1[,3]/(sum(div1[,3]))
#Mix2_P1_pct<-div2[,2]/(sum(div2[,2]))
#Mix2_P2_pct<-div2[,3]/(sum(div2[,3]))

# Calculate values for axis of dominance plot
P2diff1<-log2(Hyb1_pct*100)-log2(Mix1_P2_pct*100)
P1diff1<-log2(Hyb1_pct*100)-log2(Mix1_P1_pct*100)
P2diff2<-log2(Hyb2_pct*100)-log2(Mix2_P2_pct*100)
P1diff2<-log2(Hyb2_pct*100)-log2(Mix2_P1_pct*100)

# Make Dominance plot 1 (dir1)

#log2(1.25)=0.3219281

# Perform tests for determining classifications for each gene
test1<-cbind(P1diff1,P2diff1)
a1<-subset(test1,test1[,1]< -log2(1.25) & test1[,2]< -log2(1.25))
b1<-subset(test1,test1[,1]< -log2(1.25) & test1[,2]> -log2(1.25) & test1[,2]< log2(1.25))
c1<-subset(test1,test1[,1]< -log2(1.25) & test1[,2]> log2(1.25))
d1<-subset(test1,test1[,1]> -log2(1.25) & test1[,1]< log2(1.25) & test1[,2]< -log2(1.25))
e1<-subset(test1,test1[,1]> -log2(1.25) & test1[,1]< log2(1.25) & test1[,2]> -log2(1.25) & test1[,2]< log2(1.25))
f1<-subset(test1,test1[,1]> -log2(1.25) & test1[,1]< log2(1.25) & test1[,2]> log2(1.25))
g1<-subset(test1,test1[,1]> log2(1.25) & test1[,2]< -log2(1.25))
h1<-subset(test1,test1[,1]> log2(1.25) & test1[,2]> -log2(1.25) & test1[,2]< log2(1.25))
i1<-subset(test1,test1[,1]> log2(1.25) & test1[,2]> log2(1.25))

var3<-c(nrow(e1),(nrow(c1)+nrow(g1)),(nrow(d1)+nrow(f1)),(nrow(b1)+nrow(h1)),nrow(a1),nrow(i1),nrow(test1));
data.output6 <- matrix(data=var3,nrow=1, ncol=7, byrow=FALSE)
colnames(data.output6)<- c('Conserved','Additive',paste(par1," Dominant",sep = ""),paste(par2," Dominant", sep = ""),'Underdominant', 'Overdominant','total');

write.table(data.output6, file = paste(FixedPrefix3a,InputPrefix1a,type1,"_",unit2,"_","dominance_classified_",dir1,"_",sig,"_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);

lbls3<-c('Conserved','Additive',paste(par1," Dominant",sep = ""),paste(par2," Dominant", sep = ""),'Underdominant', 'Overdominant')
colors3<-c("5","orange","3","6","red","blue")
slices3<-(var3[1:6]/var3[7])

pdf(file = paste(FixedPrefix3a,"dominance-pie_",type1,"_",InputPrefix1a,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

pie(slices3,labels = lbls3, col = colors3, main = "PH1 dominance pie")

dev.off()

pdf(file = paste(FixedPrefix3a,"Dominance-plot_",type1,"_",dir1,"_",unit2,"_","10X10_",sig,"_",date,FixedSuffix1, sep = ""))

plot(test1, type="n", xlab=paste("log(Hyb1 exp)-log(",par1," exp)", sep = ""), ylab=paste("log(Hyb1 exp)-log(",par2," exp)", sep = ""), xlim=c(-10,10),ylim=c(-10,10), main = paste("Dominance plot",type1,dir1,unit2,"log2(1.25)",date, sep = " "))

#underdominant
points(a1, col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#additive
points(c1, col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(g1, col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#overdominant
points(i1, col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par1 dominant
points(d1, col=rgb(t(col2rgb("3")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(f1, col=rgb(t(col2rgb("3")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par2 dominant
points(b1,col=rgb(t(col2rgb("6")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(h1, col=rgb(t(col2rgb("6")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#conserved
points(e1, col=rgb(t(col2rgb("5")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
nrow(data4)-nrow(div1)

abline(h=c(0))
abline(v=c(0))
abline(a=0,b=1)

dev.off()

# Make Dominance plot 2 (dir2)

# Perform tests for determining classifications for each gene
test2<-cbind(P1diff2,P2diff2)
a2<-subset(test2,test2[,1]< -log2(1.25) & test2[,2]< -log2(1.25))
b2<-subset(test2,test2[,1]< -log2(1.25) & test2[,2]> -log2(1.25) & test2[,2]< log2(1.25))
c2<-subset(test2,test2[,1]< -log2(1.25) & test2[,2]> log2(1.25))
d2<-subset(test2,test2[,1]> -log2(1.25) & test2[,1]< log2(1.25) & test2[,2]< -log2(1.25))
e2<-subset(test2,test2[,1]> -log2(1.25) & test2[,1]< log2(1.25) & test2[,2]> -log2(1.25) & test2[,2]< log2(1.25))
f2<-subset(test2,test2[,1]> -log2(1.25) & test2[,1]< log2(1.25) & test2[,2]> log2(1.25))
g2<-subset(test2,test2[,1]> log2(1.25) & test2[,2]< -log2(1.25))
h2<-subset(test2,test2[,1]> log2(1.25) & test2[,2]> -log2(1.25) & test2[,2]< log2(1.25))
i2<-subset(test2,test2[,1]> log2(1.25) & test2[,2]> log2(1.25))

var4<-c(nrow(e2),(nrow(c2)+nrow(g2)),(nrow(d2)+nrow(f2)),(nrow(b2)+nrow(h2)),nrow(a2),nrow(i2),nrow(test2));
data.output7 <- matrix(data=var4,nrow=1, ncol=7, byrow=FALSE)
colnames(data.output7)<- c('Conserved','Additive',paste(par1," Dominant",sep = ""),paste(par2," Dominant", sep = ""),'Underdominant', 'Overdominant','total');

write.table(data.output7, file = paste(FixedPrefix3b,InputPrefix1b,type1,"_",unit2,"_","dominance_classified_",dir2,"_",sig,"_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);

lbls4<-c('Conserved','Additive',paste(par1," Dominant",sep = ""),paste(par2," Dominant", sep = ""),'Underdominant', 'Overdominant')
colors4<-c("5","orange","3","6","red","blue")
slices4<-(var4[1:6]/var4[7])

pdf(file = paste(FixedPrefix3b,"dominance-pie_",type1,"_",InputPrefix1b,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

pie(slices4,labels = lbls4, col = colors4, main = "PH2 dominance pie")

dev.off()

pdf(file = paste(FixedPrefix3b,"Dominance-plot_",type1,"_",dir2,"_",unit2,"_","10X10_",sig,"_",date,FixedSuffix1, sep = ""))

plot(test2, type="n", xlab=paste("log(Hyb2 exp)-log(",par1," exp)",sep=""), ylab=paste("log(Hyb2 exp)-log(",par2," exp)", sep = ""), xlim=c(-10,10),ylim=c(-10,10), main = paste("Dominance plot",type1,dir2,unit2,"log2(1.25)",date, sep = " "))

#underdominant
points(a2, col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#additive
points(c2, col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(g2, col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#overdominant
points(i2, col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par1 dominant
points(d2, col=rgb(t(col2rgb("3")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(f2, col=rgb(t(col2rgb("3")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par2 dominant
points(b2,col=rgb(t(col2rgb("6")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(h2, col=rgb(t(col2rgb("6")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#conserved
points(e2, col=rgb(t(col2rgb("5")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
nrow(data5)-nrow(div2)

abline(h=c(0))
abline(v=c(0))
abline(a=0,b=1)

dev.off()

###################################################################################################
###################################################################################################
#imprinting

# Read in the data (change below to reflect the datafile you want to use
data6<-read.delim(paste(FixedPrefix3c,InputPrefix1c,type1,"_",unit2,"_output","_",date,FixedSuffix2, sep = ""), header = TRUE);

# Make mel/sim ratios for both parental and hybrid
hyb1_ratio_Imprint<-(data6$H1.s1/data6$H1.s2)
hyb2_ratio_Imprint<-(data6$H2.s1/data6$H2.s2)

#Log2 transform the ratios
log_hyb1_ratio_Imprint <-log2(hyb1_ratio_Imprint)
log_hyb2_ratio_Imprint <-log2(hyb2_ratio_Imprint)

ratios3<-cbind(log_hyb1_ratio_Imprint, log_hyb2_ratio_Imprint, data6$H1_H2.Q)
#log_hyb1_ratio_Imprint = ratios3[,1]
#log_hyb2_ratio_Imprint = ratios3[,2]
#data6$H1_H2.Q = ratios3[,3]

# Perform tests for determining classifications for each gene
a5<-subset(ratios3, ratios3[,3] < sig)
b5<-subset(ratios3, ratios3[,3] > sig)

var5<-c(nrow(a5),nrow(b5),nrow(ratios3));
data.output8 <- matrix(data=var5,nrow=1, ncol=3, byrow=FALSE)
colnames(data.output8) <- c("Significant","Nonsignificant","Total");
write.table(data.output8, file = paste(FixedPrefix3c,InputPrefix1c,type1,"_",unit2,"_","Imprinting_classified_",sig,"_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);

lbls5<-c("imprinted","not imprinted")
colors5<-c("red","black")
slices5<-(var5[1:2]/var5[3])

pdf(file = paste(FixedPrefix3c,"imprinting-pie_",type1,"_",InputPrefix1c,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

pie(slices5,labels = lbls5, col = colors5, main = "H1H2 imprint pie")

dev.off()

# Plot Imprinting effects
pdf(file = paste(FixedPrefix3c,"Imprinting-plot_",type1,"_",InputPrefix1c,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

plot(ratios3[,1], ratios3[,2], type="n", xlab=paste("log2(Hybrid1 ",dir1," ",cross1,")", sep = ""), ylab=paste("log2(Hybrid2 ",dir2," ",cross1,")", sep = ""), xlim=c(-10,10),ylim=c(-10,10), main = paste("Imprinting plot",type1,InputPrefix1c,unit2,sig,date, sep = " "))

#nonsignificant Imprinting effects
points(b5, col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#significant Imprinting effects
points(a5, col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

abline(v=0)
abline(h=0)
abline(a=0,b=1)

dev.off()

###################################################################################################
###################################################################################################
# Plot Parent of Origin effects

###################################################################################################

#Column contents:

#1		2		3		4		5			6		7		8		9			10				
#gene	H1.s1	H1.s2	H1.both	H1.total	H2.s1	H2.s2	H2.both	H2.total	H1H2.grandtotal
#11				12		13		14			15			16			17			18			19			
#H1H2.binomEst	H1H2.LB	H1H2.UB	H1H2.binomP	H1H2.binomQ	H1H2.LBw	H1H2.UBw	H1H2.UBw	H1_H2.fetEst
#20			21			22		23		24					25				26				27			
#H1_H2_P.LB	H1_H2.UB	H1_H2.P	H1_H2.Q	H1_H2_PoO.fetEst	H1_H2_PoO.LB	H1_H2_PoO.UB	H1_H2_PoO.P
#28
#H1_H2_PoO.Q

###################################################################################################

#remove "imprinted genes"
data6<-subset(data6, data6$H1_H2.Q > sig)

ratios4<-cbind(log10((data6$H1.total) + data6[,4]), log10((data6$H2.total) + data6[,8]), data6$H1_H2_PoO.Q)

#data6$H1.total(A1+A2+both) = ratios4[,1]
#data6$H2.total(A1+A2+both) = ratios4[,2]
#data6$H1_H2_PoO.Q = ratios4[,3]

# Perform tests for determining classifications for each gene
a6<-subset(ratios4, ratios4[,3] < sig)
b6<-subset(ratios4, ratios4[,3] > sig)

var6 <- c(nrow(a6),nrow(b6),nrow(ratios4));
data.output9 <- matrix(data=var6,nrow=1, ncol=3, byrow=FALSE)
colnames(data.output9) <- c("Significant","Nonsignificant","Total");
write.table(data.output9, file = paste(FixedPrefix3c,InputPrefix1c,type1,"_",unit2,"_","PoO_classified_",sig,"_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);


lbls6<-c("Significant parent of origin effect","No parent of origin effect")
colors6<-c("red","black")
slices6<-(var6[1:2]/var6[3])

pdf(file = paste(FixedPrefix3c,"PoO-pie_",type1,"_",InputPrefix1c,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

pie(slices6,labels = lbls6, col = colors6, main = "H1H2 PoO pie")

dev.off()

#Plot Parent of Origin Effects
pdf(file = paste(FixedPrefix3c,"PoO-plot_",type1,"_",InputPrefix1c,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

plot(ratios4[,1], ratios4[,2], type="n", xlab=paste("log10(Hybrid1 total) (",dir1,")", sep = ""), ylab=paste("log10(Hybrid2 total) (",dir2,")", sep = ""), main = paste("Parent of Origin plot",type1,InputPrefix1c,unit2,sig,date, sep = " "))

#nonsignificant Parent of Origin effects
points(b6, col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#significant Parent of Origin effects
points(a6, col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#abline(h=c(0))
#abline(v=c(0))
abline(a=0,b=1)

dev.off()

rm(list=ls())

###################################################################################################
###################################################################################################
#sim-sec

#cis-trans and dominance stats

FixedPrefix1 = '/'

#pick one below
type1 = 'mRNA_meta'
#type1 = 'mapBias_cut20'
#type1 = 'seqDepth_cut20'
#type1 = 'gDNA_cut20'
#type1 = 'qnorm'
#type1 = 'qnorm_cut20'
#type1 = 'mRNA'

#pick one below
unit1 = 'mosaik.genes.FINAL'
#unit1 = 'mosaik.exons.FINAL'

#pick one below
unit2 = 'gene'
#unit2 = 'exon'

#pick one below
#significance
sig = 0.05
#sig = 0.01
#sig = 0.005

date = '120113'

FixedSuffix1 = '.pdf'
FixedSuffix2 = '.txt'

###################################################################################################
###################################################################################################

#sim-sec

FixedPrefix2a = '/Final/sim_sec/sim-sec_P+H1/'
FixedPrefix2b = '/Final/sim_sec/sim-sec_P+H2/'
FixedPrefix2c = '/Final/sim_sec/sim-sec_H1+H2/'

FixedPrefix3a = '/Final/sim_sec/sim-sec_P+H1/outputs/'
FixedPrefix3b = '/Final/sim_sec/sim-sec_P+H2/outputs/'
FixedPrefix3c = '/Final/sim_sec/sim-sec_H1+H2/outputs/'

#InputPrefix1a = 'tsimbazaza_droSec1.parHyb1_'
InputPrefix1a = 'tsimbazaza+droSec1_tsimbazazaXdroSec1_'
#InputPrefix1b = 'tsimbazaza_droSec1.parHyb2_'
InputPrefix1b = 'tsimbazaza+droSec1_droSec1Xtsimbazaza_'
#InputPrefix1c = 'tsimbazaza_droSec1.hyb1hyb2_'
InputPrefix1c = 'tsimbazazaXdroSec1_droSec1Xtsimbazaza_'

#Direction
dir1 = 'SiXSe'
dir2 = 'SeXSi'

#species
cross1 = 'sim/sec'
par1 = 'sim'
par2 = 'sec'

###################################################################################################
###################################################################################################

# load packages to be used.

library(binom)
library(Hmisc)

# load data files to be used, change below according to the names of 
# files intended to be used. For parent of origin tests need two hyb files.
# data1 is parents + hyb1
# data2 is parents + hyb2
# data3 is hyb1 + hyb2

data1 <- read.delim(paste(FixedPrefix2a,InputPrefix1a,type1,".",unit1,FixedSuffix2, sep = ""));
data2 <- read.delim(paste(FixedPrefix2b,InputPrefix1b,type1,".",unit1,FixedSuffix2, sep = ""));
data3 <- read.delim(paste(FixedPrefix2c,InputPrefix1c,type1,".",unit1,FixedSuffix2, sep = ""));

# Run Binomial Exact Tests on the hybrids using the Pearson-Clopper Method 
# to determine cis-regulatory changes. Change output file names to whatever you want. 
# Tests for both directions of cross are included (hyb1 and hyb2).

# file decoding
# data1 genename(1) P1(2) P2(3) Pboth(4) H11(5) H12(6) H1both(7)
# data2 genename(1) P1(2) P2(3) Pboth(4) H21(5) H22(6) H2both(7)
# data3 genename(1) H11(2) H12(3) H1both(4) H21(5) H22(6) H2both(7)

# initiate variables 
pvalsHyb1 <- NULL; 
pvalsHyb1_Par <- NULL;
pvalsHyb2 <- NULL; 
pvalsHyb2_Par <- NULL;
pvalsPar1 <- NULL; 
pvalsPar2 <- NULL;
pvalsHyb1_Hyb2 <- NULL; 
pvalsHyb1_Hyb2_FET <- NULL;
pvalsHyb1_Hyb2_FET2 <- NULL;
pvalsHyb1_Bi <- NULL;
pvalsHyb2_Bi <- NULL;

#Par1_FET2 <- NULL;
#Par2_FET2 <- NULL;

tempH1_H2_2 <- NULL;
tempH1_all <- NULL;
tempH2_all <- NULL;
tempH1 <- NULL; 
tempH1w <- NULL; 
tempH1_P <- NULL;
tempH2 <- NULL; 
tempH2w <- NULL; 
tempH2_P <- NULL;
tempP1 <- NULL; 
tempP1w <- NULL; 
tempH1_H2 <- NULL;
tempP2 <- NULL; 
tempP2w <- NULL; 
tempH1_H2_all <- NULL;
tempH1H2w <-NULL;

sumA <- sum(data1[,2])
sumB <- sum(data1[,3])
sumC <- sum(data2[,2])
sumD <- sum(data2[,3])
sum1<- (sum(data3[,2])+sum(data3[,3])+sum(data3[,4]))
sum2<- (sum(data3[,5])+sum(data3[,6])+sum(data3[,7]))

###################################################################################################

# Analysis of Data1 Parents and hybrid 1
for (i in 1:nrow(data1)) 

{	
	Par1_Bi <- binom.test(data1[[i,2]], (data1[[i,2]]+data1[[i,3]]), p = 0.5, alternative = c("t"), conf.level = 0.95);
	#Par1_FET <- fisher.test(matrix(c(data1[[i,2]],(sumA-data1[[i,2]]),data1[[i,3]],(sumB-data1[[i,3]])),nr=2));

	Hyb1_Bi <- binom.test(data1[[i,5]], (data1[[i,5]]+data1[[i,6]]), p = 0.5, alternative = c("t"), conf.level = 0.95);
	
	# collect p-values from binomial tests
	pvalsHyb1 <- rbind(pvalsHyb1,Hyb1_Bi$p.value);
	pvalsPar1 <- rbind(pvalsPar1,Par1_Bi$p.value);
	#pvalsPar1 <- rbind(pvalsPar1, Par1_FET$p.value);
	
	tempH1 <- rbind(tempH1,c(Hyb1_Bi$estimate,Hyb1_Bi$conf.int[1],Hyb1_Bi$conf.int[2],Hyb1_Bi$p.value));
	tempP1 <- rbind(tempP1,c(Par1_Bi$estimate,Par1_Bi$conf.int[1],Par1_Bi$conf.int[2],Par1_Bi$p.value));
	#tempP1 <- rbind(tempP1,c(Par1_FET$estimate,Par1_FET$conf.int[1],Par1_FET$conf.int[2],Par1_FET$p.value));
	
	# collect Wilson confidence intervals for binomial tests (to be used later for plotting seq. vs pyro)
	Par1_Bi2 <- binconf(data1[[i,2]], (data1[[i,2]]+data1[[i,3]]), alpha = 0.05, method = c("wilson"));
	
	#create space filling columns (#11 and #12) to keep spacing constant for mel-mel and other comparisons (mel-sim, sim-sec), bascially a repeat of 7 and 8
	#Par1_FET2 <-rbind(Par1_FET2,c(Par1_FET$conf.int[1],Par1_FET$conf.int[2]));
	
	Hyb1_Bi2 <- binconf(data1[[i,5]], (data1[[i,5]]+data1[[i,6]]), alpha = 0.05, method = c("wilson"));
	
	tempH1w <- rbind(tempH1w,c(Hyb1_Bi2[2],Hyb1_Bi2[3]));
	tempP1w <- rbind(tempP1w,c(Par1_Bi2[2],Par1_Bi2[3]));
	
	
	# Fisher's exact test from 2x2 tables of counts
	hyb1_par.FET <- fisher.test(matrix(c(data1[[i,5]],data1[[i,6]],data1[[i,2]],data1[[i,3]]),nr=2));
	
	# collect p-values from FETs
	pvalsHyb1_Par <- rbind(pvalsHyb1_Par,hyb1_par.FET$p.value);
	
	tempH1_P <- rbind(tempH1_P,c(hyb1_par.FET$estimate,hyb1_par.FET$conf.int[1],hyb1_par.FET$conf.int[2],hyb1_par.FET$p.value));
}

#FDR correct pvalues
pvalsHyb1.adj <- p.adjust(pvalsHyb1,method="fdr");
pvalsPar1.adj <- p.adjust(pvalsPar1,method="fdr");
pvalsHyb1_Par.adj <- p.adjust(pvalsHyb1_Par,method="fdr");

###################################################################################################

#Column contents:

#1		2		3		4		5			6			7		8		9			10				
#gene	P1.s1	P1.s2	P1.both	P1.total	P1.BETEst	P1.LB	P1.UB	P1.BETP		P1.BETQ	
#11		12		13		14		15		16			17			18		19		20			
#P1.LBw	P1.UBw	H1.s1	H1.s2	H1.both	H1.total	H1.bETEst	H1.LB	H1.UB	H1.binomP	
#21			22		23		24			25		26		27		28	
#H1.binomQ	H1.LBw	H1.UBw	H1_P.fetEst	H1_P.LB	H1_P.UB	H1_P.P	H1_P.Q

###################################################################################################

# make output file1
data.output1 <- cbind(data1[,1:4],(data1[,2]+data1[,3]),tempP1,pvalsPar1.adj,tempP1w, data1[,5:7], (data1[,5]+data1[,6]),tempH1,pvalsHyb1.adj,tempH1w,tempH1_P,pvalsHyb1_Par.adj);
colnames(data.output1) <- c("gene", "P1.s1", "P1.s2", "P1.both", "P1.total", "P1.BETEst","P1.LB","P1.UB","P1.BETP","P1.BETQ","P1.LB2","P1.UB2","H1.s1","H1.s2","H1.both","H1.total","H1.BETEst","H1.LB","H1.UB","H1.BETP","H1.BETQ","H1.LBw","H1.UBw","H1_P.fetEst","H1_P.LB","H1_P.UB","H1_P.P","H1_P.Q");
write.table(data.output1,file = paste(FixedPrefix3a,InputPrefix1a,type1,"_",unit2,"_output","_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);

###################################################################################################

# Analysis of Data2 Parents and hybrid 2
for (j in 1:nrow(data2)) 

{	
	Par2_Bi <- binom.test(data2[[j,2]], (data2[[j,2]]+data2[[j,3]]), p = 0.5, alternative = c("t"), conf.level = 0.95);
	#Par2_FET <- fisher.test(matrix(c(data2[[j,2]],(sumC-data2[[j,2]]),data2[[j,3]],(sumD-data2[[j,3]])),nr=2));

	Hyb2_Bi <- binom.test(data2[[j,5]], (data2[[j,5]]+data2[[j,6]]), p = 0.5, alternative = c("t"), conf.level = 0.95);
	
	# collect p-values from binomial tests
	pvalsHyb2 <- rbind(pvalsHyb2,Hyb2_Bi$p.value);
	pvalsPar2 <- rbind(pvalsPar2,Par2_Bi$p.value);
	#pvalsPar2 <- rbind(pvalsPar2, Par2_FET$p.value);

	
	tempH2 <- rbind(tempH2,c(Hyb2_Bi$estimate,Hyb2_Bi$conf.int[1],Hyb2_Bi$conf.int[2],Hyb2_Bi$p.value));
	tempP2 <- rbind(tempP2,c(Par2_Bi$estimate,Par2_Bi$conf.int[1],Par2_Bi$conf.int[2],Par2_Bi$p.value));
	#tempP2 <- rbind(tempP2,c(Par2_FET$estimate,Par2_FET$conf.int[1],Par2_FET$conf.int[2],Par2_FET$p.value));
		
	# collect Wilson confidence intervals for binomial tests (to be used later for plotting seq. vs pyro)
	Par2_Bi2 <- binconf(data2[[j,2]], (data2[[j,2]]+data2[[j,3]]), alpha = 0.05, method = c("wilson"));
	
	#create space filling columns (#11 and #12) to keep spacing constant for mel-mel and other comparisons(mel-sim, sim-sec), bascially a repeat of 7 and 8
	#Par2_FET2 <-rbind(Par2_FET2,c(Par2_FET$conf.int[1],Par2_FET$conf.int[2]));
	
	Hyb2_Bi2 <- binconf(data2[[j,5]], (data2[[j,5]]+data2[[j,6]]), alpha = 0.05, method = c("wilson"));
	
	tempH2w <- rbind(tempH2w,c(Hyb2_Bi2[2],Hyb2_Bi2[3]));
	tempP2w <- rbind(tempP2w,c(Par2_Bi2[2],Par2_Bi2[3]));
	
	# Fisher's exact test from 2x2 tables of counts
	hyb2_par.FET <- fisher.test(matrix(c(data2[[j,5]],data2[[j,6]],data2[[j,2]],data2[[j,3]]),nr=2));
	
	# collect p-values from FETs
	pvalsHyb2_Par <- rbind(pvalsHyb2_Par,hyb2_par.FET$p.value);
	
	tempH2_P <- rbind(tempH2_P,c(hyb2_par.FET$estimate,hyb2_par.FET$conf.int[1],hyb2_par.FET$conf.int[2],hyb2_par.FET$p.value));
}

#FDR correct pvalues
pvalsHyb2.adj <- p.adjust(pvalsHyb2,method="fdr");
pvalsPar2.adj <- p.adjust(pvalsPar2,method="fdr");
pvalsHyb2_Par.adj <- p.adjust(pvalsHyb2_Par,method="fdr");

###################################################################################################

#Column contents:

#1		2		3		4		5			6			7		8		9			10				
#gene	P2.s1	P2.s2	P2.both	P2.total	P2.BETEst	P2.LB	P2.UB	P2.BETP	P2.BETQ	
#11		12		13		14		15		16			17			18		19		20			
#P2.LBw	P2.UBw	H2.s1	H2.s2	H2.both	H2.total	H2.BETEst	H2.LB	H2.UB	H2.binomP	
#21			22		23		24			25		26		27		28	
#H2.binomQ	H2.LBw	H2.UBw	H2_P.fetEst	H2_P.LB	H2_P.UB	H2_P.P	H2_P.Q

###################################################################################################

# make output file2
data.output2 <- cbind(data2[,1:4],(data2[,2]+data2[,3]),tempP2,pvalsPar2.adj,tempP2w, data2[,5:7], (data2[,5]+data2[,6]),tempH2,pvalsHyb2.adj,tempH2w,tempH2_P,pvalsHyb2_Par.adj);
colnames(data.output2) <- c("gene", "P2.s1", "P2.s2", "P2.both", "P2.total", "P2.BETEst","P2.LB","P2.UB","P2.BETP","P2.BETQ","P2.LB2","P2.UB2","H2.s1","H2.s2","H2.both","H2.total","H2.BETEst","H2.LB","H2.UB","H2.BETP","H2.BETQ","H2.LBw","H2.UBw","H2_P.fetEst","H2_P.LB","H2_P.UB","H2_P.P","H2_P.Q");
write.table(data.output2,file = paste(FixedPrefix3b,InputPrefix1b,type1,"_",unit2,"_output","_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);

###################################################################################################

# Analysis of Data3 hybrid 1 and hybrid 2
for (k in 1:nrow(data3)) 

{	
	Hyb1_Hyb2_Bi <- binom.test((data3[[k,2]]+data3[[k,3]]), (data3[[k,2]]+data3[[k,3]]+data3[[k,5]]+data3[[k,6]]), p = 0.5, alternative = c("t"), conf.level = 0.95);
	
	# collect p-values from binomial tests
	pvalsHyb1_Hyb2 <- rbind(pvalsHyb1_Hyb2,Hyb1_Hyb2_Bi$p.value);
	
	tempH1_H2_all <-rbind(tempH1_H2_all,c(Hyb1_Hyb2_Bi$estimate,Hyb1_Hyb2_Bi$conf.int[1],Hyb1_Hyb2_Bi$conf.int[2],Hyb1_Hyb2_Bi$p.value));
	
	# collect Wilson confidence intervals for binomial tests (to be used later for plotting seq. vs pyro)
	Hyb1_Hyb2_Bi2 <- binconf((data3[[k,2]]+data3[[k,3]]), (data3[[k,2]]+data3[[k,3]]+data3[[k,5]]+data3[[k,6]]), alpha =0.05, method = c("wilson"));
	
	tempH1H2w <- rbind(tempH1H2w,c(Hyb1_Hyb2_Bi2[2],Hyb1_Hyb2_Bi2[3]));
	
	# Fisher's exact test from 2x2 tables of counts
	hyb1_hyb2.FET <- fisher.test(matrix(c(data3[[k,2]],data3[[k,3]],data3[[k,5]],data3[[k,6]]),nr=2));
	
	# collect p-values from FETs
	pvalsHyb1_Hyb2_FET <- rbind(pvalsHyb1_Hyb2_FET,hyb1_hyb2.FET$p.value);
	
	tempH1_H2 <- rbind(tempH1_H2,c(hyb1_hyb2.FET$estimate,hyb1_hyb2.FET$conf.int[1],hyb1_hyb2.FET$conf.int[2],hyb1_hyb2.FET$p.value));

	# Fisher's exact test from 2x2 tables of counts for Parent of origin effects more appropriately
	hyb1_hyb2.FET2 <- fisher.test(matrix(c((data3[[k,2]]+data3[[k,3]]+data3[[k,4]]),(sum1-(data3[[k,2]]+data3[[k,3]]+data3[[k,4]])),(data3[[k,5]]+data3[[k,6]]+data3[[k,7]]),(sum2-(data3[[k,5]]+data3[[k,6]]+data3[[k,7]]))),nr=2));
	
	# collect p-values from FET 2
	pvalsHyb1_Hyb2_FET2 <- rbind(pvalsHyb1_Hyb2_FET2,hyb1_hyb2.FET2$p.value);
	
	tempH1_H2_2 <- rbind(tempH1_H2_2,c(hyb1_hyb2.FET2$estimate,hyb1_hyb2.FET2$conf.int[1],hyb1_hyb2.FET2$conf.int[2],hyb1_hyb2.FET2$p.value));
}

###################################################################################################

#Column contents:

#1		2		3		4		5			6		7		8		9			10				
#gene	H1.s1	H1.s2	H1.both	H1.total	H2.s1	H2.s2	H2.both	H2.total	H1H2.grandtotal
#11				12		13		14			15			16			17			18			19			
#H1H2.binomEst	H1H2.LB	H1H2.UB	H1H2.binomP	H1H2.binomQ	H1H2.LBw	H1H2.UBw	H1H2.UBw	H1_H2.fetEst
#20			21			22		23		24					25				26				27			
#H1_H2_P.LB	H1_H2.UB	H1_H2.P	H1_H2.Q	H1_H2_PoO.fetEst	H1_H2_PoO.LB	H1_H2_PoO.UB	H1_H2_PoO.P
#28
#H1_H2_PoO.Q

###################################################################################################

#FDR correct pvalues
pvalsHyb1_Hyb2.adj <- p.adjust(pvalsHyb1_Hyb2,method="fdr");
pvalsHyb1_Hyb2_FET.adj <- p.adjust(pvalsHyb1_Hyb2_FET,method="fdr");
pvalsHyb1_Hyb2_FET2.adj <- p.adjust(pvalsHyb1_Hyb2_FET2,method="fdr");

# make output file3
data.output3 <- cbind(data3[,1:4],(data3[,2]+data3[,3]),data3[,5:7],(data3[,5]+data3[,6]),(data3[,2]+data3[,3]+data3[,5]+data3[,6]),tempH1_H2_all,pvalsHyb1_Hyb2.adj,tempH1H2w,tempH1_H2,pvalsHyb1_Hyb2_FET.adj,tempH1_H2_2,pvalsHyb1_Hyb2_FET2.adj);
colnames(data.output3) <- c("gene", "H1.s1", "H1.s2", "H1.both", "H1.total", "H2.s1", "H2.s2", "H2.both", "H2.total", "H1H2.grandtotal", "H1H2.binomEst","H1H2.LB","H1H2.UB","H1H2.binomP","H1H2.binomQ","H1H2.LBw","H1H2.UBw", "H1_H2.fetEst","H1_H2_P.LB","H1_H2.UB","H1_H2.P","H1_H2.Q", "H1_H2_PoO.fetEst","H1_H2_PoO.LB","H1_H2_PoO.UB","H1_H2_PoO.P","H1_H2_PoO.Q");
write.table(data.output3,file = paste(FixedPrefix3c,InputPrefix1c,type1,"_",unit2,"_output","_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);


###################################################################################################
###################################################################################################
###################################################################################################


#Visualize the data with several plots

###################################################################################################
###################################################################################################
#cis-trans plots

#Hyb1 = dir1
#Hyb2 = dir2

# Read in the data (change below to reflect the datafile you want to use
data4<-read.delim(paste(FixedPrefix3a,InputPrefix1a,type1,"_",unit2,"_output","_",date,FixedSuffix2, sep = ""), header = TRUE);
data5<-read.delim(paste(FixedPrefix3b,InputPrefix1b,type1,"_",unit2,"_output","_",date,FixedSuffix2, sep = ""), header = TRUE);

#remove "imprinted" genes

# Read in the data from H1 vs H2
data6<-read.delim(paste(FixedPrefix3c,InputPrefix1c,type1,"_",unit2,"_output","_",date,FixedSuffix2, sep = ""), header = TRUE);
#subset data
#imprint<-c(data6$gene,data6$H1_H2.Q)
#subset not imprinted
imprinted<-subset(data6,(data6$H1_H2.Q > sig))

#Keep those not imprinted
data4<-merge(data4, imprinted, by = 'gene')
data4<-data4[1:28]
data4<-data.frame(data4)

data5<-merge(data5, imprinted, by = 'gene')
data5<-data5[1:28]
data5<-data.frame(data5)

#remove data6, add back later
rm(data6)


# Make zhr/z30 ratios for both parental and hybrid
hyb1_ratio<-(data4$H1.s1/data4$H1.s2)
Par1_ratio<-(data4$P1.s1/data4$P1.s2)
hyb2_ratio<-(data5$H2.s1/data5$H2.s2)
Par2_ratio<-(data5$P2.s1/data5$P2.s2)

#Log2 transfor the ratios
log_hyb1_ratio <-log2(hyb1_ratio)
log_Par1_ratio <-log2(Par1_ratio)
log_hyb2_ratio <-log2(hyb2_ratio)
log_Par2_ratio <-log2(Par2_ratio)

#Make par/hyb ratio to properly determine cis+trans and cisXtrans
logPar1_loghyb1_rat <- log_Par1_ratio/log_hyb1_ratio
logPar2_loghyb2_rat <- log_Par2_ratio/log_hyb2_ratio

#Plots for Hybrid 1

ratios1<-cbind(log_Par1_ratio, log_hyb1_ratio, data4$H1.BETQ, data4$P1.BETQ, data4$H1_P.Q, logPar1_loghyb1_rat)

#ratios1[,1] = log_Par1_ratio
#ratios1[,2] = log_hyb1_ratio
#ratios1[,3] = H1.binomQ
#ratios1[,4] = P1.FETQ
#ratios1[,5] = H1_P.Q
#ratios1[,6] = logpar1_loghyb1_rat

# Perform tests for determining classifications for each gene
a3<-subset(ratios1, ratios1[,3] > sig & ratios1[,4] > sig & ratios1[,5] > sig)
b3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] < sig & ratios1[,5] > sig)
c3<-subset(ratios1, ratios1[,3] > sig & ratios1[,4] < sig & ratios1[,5] < sig)
d3<-subset(ratios1, ratios1[,3] > sig & ratios1[,4] > sig & ratios1[,5] < sig)
e3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] > sig & ratios1[,5] > sig)
f3<-subset(ratios1, ratios1[,3] > sig & ratios1[,4] < sig & ratios1[,5] > sig)
g3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] > sig & ratios1[,5] < sig)
#cis+trans
h3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] < sig & ratios1[,5] < sig & ratios1[,1] > 0 &  ratios1[,2] > 0 & ratios1[,6] > 1)
i3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] < sig & ratios1[,5] < sig & ratios1[,1] < 0 &  ratios1[,2] < 0 & ratios1[,6] > 1)
#cisXtrans
j3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] < sig & ratios1[,5] < sig & ratios1[,1] > 0 &  ratios1[,2] < 0)
k3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] < sig & ratios1[,5] < sig & ratios1[,1] < 0 &  ratios1[,2] > 0)
l3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] < sig & ratios1[,5] < sig & ratios1[,1] > 0 &  ratios1[,2] > 0 & ratios1[,6] < 1)
m3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] < sig & ratios1[,5] < sig & ratios1[,1] < 0 &  ratios1[,2] < 0 & ratios1[,6] < 1)

var1<-c(nrow(a3),nrow(b3),nrow(c3),nrow(g3),(nrow(h3)+nrow(i3)),(nrow(j3)+nrow(k3)+nrow(l3)+nrow(m3)),(nrow(d3)+nrow(e3)+nrow(f3)),nrow(ratios1));
data.output4 <- matrix(data=var1,nrow=1, ncol=8, byrow=FALSE)
colnames(data.output4)<-c("Conserved","All cis","All trans","Compensatory","cis+trans","cisXtrans","Ambiguous","total");
write.table(data.output4, file = paste(FixedPrefix3a,InputPrefix1a,type1,"_",unit2,"_","cis-trans_classified_",dir1,"_",sig,"_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);

lbls1<-c("Conserved","All cis","All trans","Compensatory","cis+trans","cisXtrans","Ambiguous","total")
colors1<-c("yellow","black","red","orange","blue","green","gray")
slices1<-(var1[1:7]/var1[8])

pdf(file = paste(FixedPrefix3a,"cis-trans-pie_",type1,"_",InputPrefix1a,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

pie(slices1,labels = lbls1, col = colors1, main = "PH1 cis-trans pie")

dev.off()

pdf(file = paste(FixedPrefix3a,"cis-trans-plot_",type1,"_",InputPrefix1a,"10X10_",unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

plot(ratios1[,1], ratios1[,2], type="n", xlab= paste("log2(parental (",cross1,"))", sep = ""), ylab=paste("log2(hybrid ",dir1," (",cross1,")", sep = ""), xlim=c(-10,10),ylim=c(-10,10), main = paste("cis-trans plot",type1,dir1,InputPrefix1a,unit2,sig,date, sep = " "))

#Ambiguous
points(d3, col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(e3, col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(f3, col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#cis + trans
points(h3, col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(i3, col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#cis X trans
points(j3, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(k3, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(l3, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(m3, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#All cis
points(b3, col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#All trans
points(c3, col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#Compensatory
points(g3, col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#Conserved
points(a3, col=rgb(t(col2rgb("yellow")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

abline(h=c(0))
abline(v=c(0))
abline(a=0,b=1)
dev.off()


#Plots for Hybrid 2
ratios2<-cbind(log_Par2_ratio, log_hyb2_ratio, data5$H2.BETQ, data5$P2.BETQ, data5$H2_P.Q, logPar2_loghyb2_rat)

#ratios2[,1] = log_Par2_ratio
#ratios2[,2] = log_hyb2_ratio
#ratios2[,3] = H2.binomQ
#ratios2[,4] = P2.FETQ
#ratios2[,5] = H2_P.Q
#ratios2[,6] = logPar2_loghyb2_rat

# Perform tests for determining classifications for each gene
a4<-subset(ratios2, ratios2[,3] > sig & ratios2[,4] > sig & ratios2[,5] > sig)
b4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] < sig & ratios2[,5] > sig)
c4<-subset(ratios2, ratios2[,3] > sig & ratios2[,4] < sig & ratios2[,5] < sig)
d4<-subset(ratios2, ratios2[,3] > sig & ratios2[,4] > sig & ratios2[,5] < sig)
e4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] > sig & ratios2[,5] > sig)
f4<-subset(ratios2, ratios2[,3] > sig & ratios2[,4] < sig & ratios2[,5] > sig)
g4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] > sig & ratios2[,5] < sig)
#cis+trans
h4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] < sig & ratios2[,5] < sig & ratios2[,1] > 0 &  ratios2[,2] > 0 & ratios2[,6] > 1)
i4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] < sig & ratios2[,5] < sig & ratios2[,1] < 0 &  ratios2[,2] < 0 & ratios2[,6] > 1)
#cisXtrans
j4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] < sig & ratios2[,5] < sig & ratios2[,1] > 0 &  ratios2[,2] < 0)
k4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] < sig & ratios2[,5] < sig & ratios2[,1] < 0 &  ratios2[,2] > 0)
l4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] < sig & ratios2[,5] < sig & ratios2[,1] > 0 &  ratios2[,2] > 0 & ratios2[,6] < 1)
m4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] < sig & ratios2[,5] < sig & ratios2[,1] < 0 &  ratios2[,2] < 0 & ratios2[,6] < 1)

var2<-c(nrow(a4),nrow(b4),nrow(c4),nrow(g4),(nrow(h4)+nrow(i4)),(nrow(j4)+nrow(k4)+nrow(l4)+nrow(m4)),(nrow(d4)+nrow(e4)+nrow(f4)),nrow(ratios2))
data.output5 <- matrix(data=var2,nrow=1, ncol=8, byrow=FALSE)
colnames(data.output5)<-c("Conserved","All cis","All trans","Compensatory","cis+trans","cisXtrans","Ambiguous","total");
write.table(data.output5, file = paste(FixedPrefix3b,InputPrefix1b,type1,"_",unit2,"_","cis-trans_classified_",dir2,"_",sig,"_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);

lbls2<-c("Conserved","All cis","All trans","Compensatory","cis+trans","cisXtrans","Ambiguous","total")
colors2<-c("yellow","black","red","orange","blue","green","gray")
slices2<-(var2[1:7]/var2[8])

pdf(file = paste(FixedPrefix3b,"cis-trans-pie_",type1,"_",InputPrefix1b,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

pie(slices2,labels = lbls2, col = colors2, main = "PH2 cis-trans pie")

dev.off()


pdf(file = paste(FixedPrefix3b,"cis-trans-plot_",type1,"_",InputPrefix1b,"10X10_",unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

plot(ratios2[,1], ratios2[,2], type="n", xlab=paste("log2(parental (",cross1,"))", sep = ""), ylab=paste("log2(hybrid ",dir2," ",cross1,")", sep = ""), xlim=c(-10,10),ylim=c(-10,10),main = paste("cis-trans plot",type1,dir2,InputPrefix1b,unit2,sig,date, sep = " "))

#Ambiguous
points(d4, col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(e4, col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(f4, col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#cis + trans
points(h4, col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(i4, col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#cis X trans
points(j4, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(k4, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(l4, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(m4, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#All cis
points(b4, col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#All trans
points(c4, col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#Compensatory
points(g4, col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#Conserved
points(a4, col=rgb(t(col2rgb("yellow")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

abline(h=c(0))
abline(v=c(0))
abline(a=0,b=1)
dev.off()

###################################################################################################
###################################################################################################
#dominance plots

#H1=dir1
#H2=dir2

# Restrict to genes that are significantly differentially expressed 
# between the two parental species.

#div1<-subset(data4, data4$P1.FETQ < sig)
#div2<-subset(data5, data5$P2.FETQ < sig)

#Don't restrict to significantly differentially experssed between species

div1<-subset(data4)
div2<-subset(data5)

# Convert to proportion of total
#H.both=div[,15]
# H.total=div[,16]   ...(A1+A2)...
# P.s1=div[,2]
# P.s2=div[,3]
# P.S1=div[,4]

#29 = P1 total   # div1[,2]+((div1[,2]/(div1[,2]+div1[,3]))*div1[,4])) #

div1[,29] = (div1[,2]+((div1[,2]/(div1[,2]+div1[,3]))*div1[,4]))
div2[,29] = (div2[,2]+((div2[,2]/(div2[,2]+div2[,3]))*div2[,4]))

#30 = P2 total

div1[,30] = (div1[,3]+((div1[,3]/(div1[,2]+div1[,3]))*div1[,4]))
div2[,30] = (div2[,3]+((div2[,3]/(div2[,2]+div2[,3]))*div2[,4]))

Hyb1_pct<-((div1[,16]+div1[,15])/(sum(div1[,16])+sum(div1[,15])))
Hyb2_pct<-((div2[,16]+div2[,15])/(sum(div2[,16])+sum(div2[,15])))

Mix1_P1_pct<-(div1[,29]/sum(div1[,29]))
Mix1_P2_pct<-(div1[,30]/sum(div1[,30]))

Mix2_P1_pct<-div2[,29]/(sum(div2[,29]))
Mix2_P2_pct<-div2[,30]/(sum(div2[,30]))

#if decide to go back to old way it is retained (does not use boths)
#Hyb1_pct<-div1[,16]/(sum(div1[,16]))
#Hyb2_pct<-div2[,16]/(sum(div2[,16]))
#Mix1_P1_pct<-div1[,2]/(sum(div1[,2]))
#Mix1_P2_pct<-div1[,3]/(sum(div1[,3]))
#Mix2_P1_pct<-div2[,2]/(sum(div2[,2]))
#Mix2_P2_pct<-div2[,3]/(sum(div2[,3]))

# Calculate values for axis of dominance plot
P2diff1<-log2(Hyb1_pct*100)-log2(Mix1_P2_pct*100)
P1diff1<-log2(Hyb1_pct*100)-log2(Mix1_P1_pct*100)
P2diff2<-log2(Hyb2_pct*100)-log2(Mix2_P2_pct*100)
P1diff2<-log2(Hyb2_pct*100)-log2(Mix2_P1_pct*100)

# Make Dominance plot 1 (dir1)

#log2(1.25)=0.3219281

# Perform tests for determining classifications for each gene
test1<-cbind(P1diff1,P2diff1)
a1<-subset(test1,test1[,1]< -log2(1.25) & test1[,2]< -log2(1.25))
b1<-subset(test1,test1[,1]< -log2(1.25) & test1[,2]> -log2(1.25) & test1[,2]< log2(1.25))
c1<-subset(test1,test1[,1]< -log2(1.25) & test1[,2]> log2(1.25))
d1<-subset(test1,test1[,1]> -log2(1.25) & test1[,1]< log2(1.25) & test1[,2]< -log2(1.25))
e1<-subset(test1,test1[,1]> -log2(1.25) & test1[,1]< log2(1.25) & test1[,2]> -log2(1.25) & test1[,2]< log2(1.25))
f1<-subset(test1,test1[,1]> -log2(1.25) & test1[,1]< log2(1.25) & test1[,2]> log2(1.25))
g1<-subset(test1,test1[,1]> log2(1.25) & test1[,2]< -log2(1.25))
h1<-subset(test1,test1[,1]> log2(1.25) & test1[,2]> -log2(1.25) & test1[,2]< log2(1.25))
i1<-subset(test1,test1[,1]> log2(1.25) & test1[,2]> log2(1.25))

var3<-c(nrow(e1),(nrow(c1)+nrow(g1)),(nrow(d1)+nrow(f1)),(nrow(b1)+nrow(h1)),nrow(a1),nrow(i1),nrow(test1));
data.output6 <- matrix(data=var3,nrow=1, ncol=7, byrow=FALSE)
colnames(data.output6)<- c('Conserved','Additive',paste(par1," Dominant",sep = ""),paste(par2," Dominant", sep = ""),'Underdominant', 'Overdominant','total');

write.table(data.output6, file = paste(FixedPrefix3a,InputPrefix1a,type1,"_",unit2,"_","dominance_classified_",dir1,"_",sig,"_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);

lbls3<-c('Conserved','Additive',paste(par1," Dominant",sep = ""),paste(par2," Dominant", sep = ""),'Underdominant', 'Overdominant')
colors3<-c("5","orange","3","6","red","blue")
slices3<-(var3[1:6]/var3[7])

pdf(file = paste(FixedPrefix3a,"dominance-pie_",type1,"_",InputPrefix1a,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

pie(slices3,labels = lbls3, col = colors3, main = "PH1 dominance pie")

dev.off()

pdf(file = paste(FixedPrefix3a,"Dominance-plot_",type1,"_",dir1,"_",unit2,"_","10X10_",sig,"_",date,FixedSuffix1, sep = ""))

plot(test1, type="n", xlab=paste("log(Hyb1 exp)-log(",par1," exp)", sep = ""), ylab=paste("log(Hyb1 exp)-log(",par2," exp)", sep = ""), xlim=c(-10,10),ylim=c(-10,10), main = paste("Dominance plot",type1,dir1,unit2,"log2(1.25)",date, sep = " "))

#underdominant
points(a1, col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#additive
points(c1, col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(g1, col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#overdominant
points(i1, col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par1 dominant
points(d1, col=rgb(t(col2rgb("3")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(f1, col=rgb(t(col2rgb("3")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par2 dominant
points(b1,col=rgb(t(col2rgb("6")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(h1, col=rgb(t(col2rgb("6")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#conserved
points(e1, col=rgb(t(col2rgb("5")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
nrow(data4)-nrow(div1)

abline(h=c(0))
abline(v=c(0))
abline(a=0,b=1)

dev.off()

# Make Dominance plot 2 (dir2)

# Perform tests for determining classifications for each gene
test2<-cbind(P1diff2,P2diff2)
a2<-subset(test2,test2[,1]< -log2(1.25) & test2[,2]< -log2(1.25))
b2<-subset(test2,test2[,1]< -log2(1.25) & test2[,2]> -log2(1.25) & test2[,2]< log2(1.25))
c2<-subset(test2,test2[,1]< -log2(1.25) & test2[,2]> log2(1.25))
d2<-subset(test2,test2[,1]> -log2(1.25) & test2[,1]< log2(1.25) & test2[,2]< -log2(1.25))
e2<-subset(test2,test2[,1]> -log2(1.25) & test2[,1]< log2(1.25) & test2[,2]> -log2(1.25) & test2[,2]< log2(1.25))
f2<-subset(test2,test2[,1]> -log2(1.25) & test2[,1]< log2(1.25) & test2[,2]> log2(1.25))
g2<-subset(test2,test2[,1]> log2(1.25) & test2[,2]< -log2(1.25))
h2<-subset(test2,test2[,1]> log2(1.25) & test2[,2]> -log2(1.25) & test2[,2]< log2(1.25))
i2<-subset(test2,test2[,1]> log2(1.25) & test2[,2]> log2(1.25))

var4<-c(nrow(e2),(nrow(c2)+nrow(g2)),(nrow(d2)+nrow(f2)),(nrow(b2)+nrow(h2)),nrow(a2),nrow(i2),nrow(test2));
data.output7 <- matrix(data=var4,nrow=1, ncol=7, byrow=FALSE)
colnames(data.output7)<- c('Conserved','Additive',paste(par1," Dominant",sep = ""),paste(par2," Dominant", sep = ""),'Underdominant', 'Overdominant','total');

write.table(data.output7, file = paste(FixedPrefix3b,InputPrefix1b,type1,"_",unit2,"_","dominance_classified_",dir2,"_",sig,"_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);

lbls4<-c('Conserved','Additive',paste(par1," Dominant",sep = ""),paste(par2," Dominant", sep = ""),'Underdominant', 'Overdominant')
colors4<-c("5","orange","3","6","red","blue")
slices4<-(var4[1:6]/var4[7])

pdf(file = paste(FixedPrefix3b,"dominance-pie_",type1,"_",InputPrefix1b,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

pie(slices4,labels = lbls4, col = colors4, main = "PH2 dominance pie")

dev.off()

pdf(file = paste(FixedPrefix3b,"Dominance-plot_",type1,"_",dir2,"_",unit2,"_","10X10_",sig,"_",date,FixedSuffix1, sep = ""))

plot(test2, type="n", xlab=paste("log(Hyb2 exp)-log(",par1," exp)",sep=""), ylab=paste("log(Hyb2 exp)-log(",par2," exp)", sep = ""), xlim=c(-10,10),ylim=c(-10,10), main = paste("Dominance plot",type1,dir2,unit2,"log2(1.25)",date, sep = " "))

#underdominant
points(a2, col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#additive
points(c2, col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(g2, col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#overdominant
points(i2, col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par1 dominant
points(d2, col=rgb(t(col2rgb("3")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(f2, col=rgb(t(col2rgb("3")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par2 dominant
points(b2,col=rgb(t(col2rgb("6")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(h2, col=rgb(t(col2rgb("6")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#conserved
points(e2, col=rgb(t(col2rgb("5")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
nrow(data5)-nrow(div2)

abline(h=c(0))
abline(v=c(0))
abline(a=0,b=1)

dev.off()

###################################################################################################
###################################################################################################
#imprinting

# Read in the data (change below to reflect the datafile you want to use
data6<-read.delim(paste(FixedPrefix3c,InputPrefix1c,type1,"_",unit2,"_output","_",date,FixedSuffix2, sep = ""), header = TRUE);

# Make mel/sim ratios for both parental and hybrid
hyb1_ratio_Imprint<-(data6$H1.s1/data6$H1.s2)
hyb2_ratio_Imprint<-(data6$H2.s1/data6$H2.s2)

#Log2 transform the ratios
log_hyb1_ratio_Imprint <-log2(hyb1_ratio_Imprint)
log_hyb2_ratio_Imprint <-log2(hyb2_ratio_Imprint)

ratios3<-cbind(log_hyb1_ratio_Imprint, log_hyb2_ratio_Imprint, data6$H1_H2.Q)
#log_hyb1_ratio_Imprint = ratios3[,1]
#log_hyb2_ratio_Imprint = ratios3[,2]
#data6$H1_H2.Q = ratios3[,3]

# Perform tests for determining classifications for each gene
a5<-subset(ratios3, ratios3[,3] < sig)
b5<-subset(ratios3, ratios3[,3] > sig)

var5<-c(nrow(a5),nrow(b5),nrow(ratios3));
data.output8 <- matrix(data=var5,nrow=1, ncol=3, byrow=FALSE)
colnames(data.output8) <- c("Significant","Nonsignificant","Total");
write.table(data.output8, file = paste(FixedPrefix3c,InputPrefix1c,type1,"_",unit2,"_","Imprinting_classified_",sig,"_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);

lbls5<-c("imprinted","not imprinted")
colors5<-c("red","black")
slices5<-(var5[1:2]/var5[3])

pdf(file = paste(FixedPrefix3c,"imprinting-pie_",type1,"_",InputPrefix1c,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

pie(slices5,labels = lbls5, col = colors5, main = "H1H2 imprint pie")

dev.off()

# Plot Imprinting effects
pdf(file = paste(FixedPrefix3c,"Imprinting-plot_",type1,"_",InputPrefix1c,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

plot(ratios3[,1], ratios3[,2], type="n", xlab=paste("log2(Hybrid1 ",dir1," ",cross1,")", sep = ""), ylab=paste("log2(Hybrid2 ",dir2," ",cross1,")", sep = ""), xlim=c(-10,10),ylim=c(-10,10), main = paste("Imprinting plot",type1,InputPrefix1c,unit2,sig,date, sep = " "))

#nonsignificant Imprinting effects
points(b5, col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#significant Imprinting effects
points(a5, col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

abline(v=0)
abline(h=0)
abline(a=0,b=1)

dev.off()

###################################################################################################
###################################################################################################
# Plot Parent of Origin effects

###################################################################################################

#Column contents:

#1		2		3		4		5			6		7		8		9			10				
#gene	H1.s1	H1.s2	H1.both	H1.total	H2.s1	H2.s2	H2.both	H2.total	H1H2.grandtotal
#11				12		13		14			15			16			17			18			19			
#H1H2.binomEst	H1H2.LB	H1H2.UB	H1H2.binomP	H1H2.binomQ	H1H2.LBw	H1H2.UBw	H1H2.UBw	H1_H2.fetEst
#20			21			22		23		24					25				26				27			
#H1_H2_P.LB	H1_H2.UB	H1_H2.P	H1_H2.Q	H1_H2_PoO.fetEst	H1_H2_PoO.LB	H1_H2_PoO.UB	H1_H2_PoO.P
#28
#H1_H2_PoO.Q

###################################################################################################

#remove "imprinted genes"
data6<-subset(data6, data6$H1_H2.Q > sig)

ratios4<-cbind(log10((data6$H1.total) + data6[,4]), log10((data6$H2.total) + data6[,8]), data6$H1_H2_PoO.Q)

#data6$H1.total(A1+A2+both) = ratios4[,1]
#data6$H2.total(A1+A2+both) = ratios4[,2]
#data6$H1_H2_PoO.Q = ratios4[,3]

# Perform tests for determining classifications for each gene
a6<-subset(ratios4, ratios4[,3] < sig)
b6<-subset(ratios4, ratios4[,3] > sig)

var6 <- c(nrow(a6),nrow(b6),nrow(ratios4));
data.output9 <- matrix(data=var6,nrow=1, ncol=3, byrow=FALSE)
colnames(data.output9) <- c("Significant","Nonsignificant","Total");
write.table(data.output9, file = paste(FixedPrefix3c,InputPrefix1c,type1,"_",unit2,"_","PoO_classified_",sig,"_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);


lbls6<-c("Significant parent of origin effect","No parent of origin effect")
colors6<-c("red","black")
slices6<-(var6[1:2]/var6[3])

pdf(file = paste(FixedPrefix3c,"PoO-pie_",type1,"_",InputPrefix1c,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

pie(slices6,labels = lbls6, col = colors6, main = "H1H2 PoO pie")

dev.off()

#Plot Parent of Origin Effects
pdf(file = paste(FixedPrefix3c,"PoO-plot_",type1,"_",InputPrefix1c,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

plot(ratios4[,1], ratios4[,2], type="n", xlab=paste("log10(Hybrid1 total) (",dir1,")", sep = ""), ylab=paste("log10(Hybrid2 total) (",dir2,")", sep = ""), main = paste("Parent of Origin plot",type1,InputPrefix1c,unit2,sig,date, sep = " "))

#nonsignificant Parent of Origin effects
points(b6, col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#significant Parent of Origin effects
points(a6, col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#abline(h=c(0))
#abline(v=c(0))
abline(a=0,b=1)

dev.off()

rm(list=ls())

###################################################################################################
###################################################################################################
#mel-sim
####################################################################################################
####################################################################################################

#cis-trans and dominance stats

FixedPrefix1 = '/'

#pick one below
type1 = 'mRNA_meta'
#type1 = 'mapBias_cut20'
#type1 = 'seqDepth_cut20'
#type1 = 'gDNA_cut20'
#type1 = 'qnorm'
#type1 = 'qnorm_cut20'
#type1 = 'mRNA'

#pick one below
unit1 = 'mosaik.genes.FINAL'
#unit1 = 'mosaik.exons.FINAL'

#pick one below
unit2 = 'gene'
#unit2 = 'exon'

#pick one below
#significance
sig = 0.05
#sig = 0.01
#sig = 0.005

date = '120113'

FixedSuffix1 = '.pdf'
FixedSuffix2 = '.txt'

###################################################################################################
###################################################################################################

#mel-sim-----comment all of sim-sec and mel-mel if using mel-sim

FixedPrefix2a = '/Final/mel_sim/mel-sim_P+H1/'
FixedPrefix2b = '/Final/mel_sim/mel-sim_P+H2/'
FixedPrefix2c = '/Final/mel_sim/mel-sim_H1+H2/'

FixedPrefix3a = '/Final/mel_sim/mel-sim_P+H1/outputs/'
FixedPrefix3b = '/Final/mel_sim/mel-sim_P+H2/outputs/'
FixedPrefix3c = '/Final/mel_sim/mel-sim_H1+H2/outputs/'

#InputPrefix1a = 'zhr_tsimbazaza.parHyb1_'
InputPrefix1a = 'zhr+tsimbazaza_zhrXtsimbazaza_'
#InputPrefix1b = 'zhr_tsimbazaza.parHyb2_'
InputPrefix1b = 'zhr+tsimbazaza_tsimbazazaXzhr_'
#InputPrefix1c = 'zhr_tsimbazaza.hyb1hyb2_'
InputPrefix1c = 'zhrXtsimbazaza_tsimbazazaXzhr_'

#Direction
dir1 = 'MXS'
dir2 = 'SXM'

#species
cross1 = 'mel/sim'
par1 = 'mel'
par2 = 'sim'

###################################################################################################
###################################################################################################

# load packages to be used.

library(binom)
library(Hmisc)

# load data files to be used, change below according to the names of 
# files intended to be used. For parent of origin tests need two hyb files.
# data1 is parents + hyb1
# data2 is parents + hyb2
# data3 is hyb1 + hyb2

data1 <- read.delim(paste(FixedPrefix2a,InputPrefix1a,type1,".",unit1,FixedSuffix2, sep = ""));
data2 <- read.delim(paste(FixedPrefix2b,InputPrefix1b,type1,".",unit1,FixedSuffix2, sep = ""));
data3 <- read.delim(paste(FixedPrefix2c,InputPrefix1c,type1,".",unit1,FixedSuffix2, sep = ""));

# Run Binomial Exact Tests on the hybrids using the Pearson-Clopper Method 
# to determine cis-regulatory changes. Change output file names to whatever you want. 
# Tests for both directions of cross are included (hyb1 and hyb2).

# file decoding
# data1 genename(1) P1(2) P2(3) Pboth(4) H11(5) H12(6) H1both(7)
# data2 genename(1) P1(2) P2(3) Pboth(4) H21(5) H22(6) H2both(7)
# data3 genename(1) H11(2) H12(3) H1both(4) H21(5) H22(6) H2both(7)

# initiate variables 
pvalsHyb1 <- NULL; 
pvalsHyb1_Par <- NULL;
pvalsHyb2 <- NULL; 
pvalsHyb2_Par <- NULL;
pvalsPar1 <- NULL; 
pvalsPar2 <- NULL;
pvalsHyb1_Hyb2 <- NULL; 
pvalsHyb1_Hyb2_FET <- NULL;
pvalsHyb1_Hyb2_FET2 <- NULL;
pvalsHyb1_Bi <- NULL;
pvalsHyb2_Bi <- NULL;

#Par1_FET2 <- NULL;
#Par2_FET2 <- NULL;

tempH1_H2_2 <- NULL;
tempH1_all <- NULL;
tempH2_all <- NULL;
tempH1 <- NULL; 
tempH1w <- NULL; 
tempH1_P <- NULL;
tempH2 <- NULL; 
tempH2w <- NULL; 
tempH2_P <- NULL;
tempP1 <- NULL; 
tempP1w <- NULL; 
tempH1_H2 <- NULL;
tempP2 <- NULL; 
tempP2w <- NULL; 
tempH1_H2_all <- NULL;
tempH1H2w <-NULL;

sumA <- sum(data1[,2])
sumB <- sum(data1[,3])
sumC <- sum(data2[,2])
sumD <- sum(data2[,3])
sum1<- (sum(data3[,2])+sum(data3[,3])+sum(data3[,4]))
sum2<- (sum(data3[,5])+sum(data3[,6])+sum(data3[,7]))

###################################################################################################

# Analysis of Data1 Parents and hybrid 1
for (i in 1:nrow(data1)) 

{	
	Par1_Bi <- binom.test(data1[[i,2]], (data1[[i,2]]+data1[[i,3]]), p = 0.5, alternative = c("t"), conf.level = 0.95);
	#Par1_FET <- fisher.test(matrix(c(data1[[i,2]],(sumA-data1[[i,2]]),data1[[i,3]],(sumB-data1[[i,3]])),nr=2));

	Hyb1_Bi <- binom.test(data1[[i,5]], (data1[[i,5]]+data1[[i,6]]), p = 0.5, alternative = c("t"), conf.level = 0.95);
	
	# collect p-values from binomial tests
	pvalsHyb1 <- rbind(pvalsHyb1,Hyb1_Bi$p.value);
	pvalsPar1 <- rbind(pvalsPar1,Par1_Bi$p.value);
	#pvalsPar1 <- rbind(pvalsPar1, Par1_FET$p.value);
	
	tempH1 <- rbind(tempH1,c(Hyb1_Bi$estimate,Hyb1_Bi$conf.int[1],Hyb1_Bi$conf.int[2],Hyb1_Bi$p.value));
	tempP1 <- rbind(tempP1,c(Par1_Bi$estimate,Par1_Bi$conf.int[1],Par1_Bi$conf.int[2],Par1_Bi$p.value));
	#tempP1 <- rbind(tempP1,c(Par1_FET$estimate,Par1_FET$conf.int[1],Par1_FET$conf.int[2],Par1_FET$p.value));
	
	# collect Wilson confidence intervals for binomial tests (to be used later for plotting seq. vs pyro)
	Par1_Bi2 <- binconf(data1[[i,2]], (data1[[i,2]]+data1[[i,3]]), alpha = 0.05, method = c("wilson"));
	
	#create space filling columns (#11 and #12) to keep spacing constant for mel-mel and other comparisons (mel-sim, sim-sec), bascially a repeat of 7 and 8
	#Par1_FET2 <-rbind(Par1_FET2,c(Par1_FET$conf.int[1],Par1_FET$conf.int[2]));
	
	Hyb1_Bi2 <- binconf(data1[[i,5]], (data1[[i,5]]+data1[[i,6]]), alpha = 0.05, method = c("wilson"));
	
	tempH1w <- rbind(tempH1w,c(Hyb1_Bi2[2],Hyb1_Bi2[3]));
	tempP1w <- rbind(tempP1w,c(Par1_Bi2[2],Par1_Bi2[3]));
	
	
	# Fisher's exact test from 2x2 tables of counts
	hyb1_par.FET <- fisher.test(matrix(c(data1[[i,5]],data1[[i,6]],data1[[i,2]],data1[[i,3]]),nr=2));
	
	# collect p-values from FETs
	pvalsHyb1_Par <- rbind(pvalsHyb1_Par,hyb1_par.FET$p.value);
	
	tempH1_P <- rbind(tempH1_P,c(hyb1_par.FET$estimate,hyb1_par.FET$conf.int[1],hyb1_par.FET$conf.int[2],hyb1_par.FET$p.value));
}

#FDR correct pvalues
pvalsHyb1.adj <- p.adjust(pvalsHyb1,method="fdr");
pvalsPar1.adj <- p.adjust(pvalsPar1,method="fdr");
pvalsHyb1_Par.adj <- p.adjust(pvalsHyb1_Par,method="fdr");

###################################################################################################

#Column contents:

#1		2		3		4		5			6			7		8		9			10				
#gene	P1.s1	P1.s2	P1.both	P1.total	P1.BETEst	P1.LB	P1.UB	P1.BETP		P1.BETQ	
#11		12		13		14		15		16			17			18		19		20			
#P1.LBw	P1.UBw	H1.s1	H1.s2	H1.both	H1.total	H1.bETEst	H1.LB	H1.UB	H1.binomP	
#21			22		23		24			25		26		27		28	
#H1.binomQ	H1.LBw	H1.UBw	H1_P.fetEst	H1_P.LB	H1_P.UB	H1_P.P	H1_P.Q

###################################################################################################

# make output file1
data.output1 <- cbind(data1[,1:4],(data1[,2]+data1[,3]),tempP1,pvalsPar1.adj,tempP1w, data1[,5:7], (data1[,5]+data1[,6]),tempH1,pvalsHyb1.adj,tempH1w,tempH1_P,pvalsHyb1_Par.adj);
colnames(data.output1) <- c("gene", "P1.s1", "P1.s2", "P1.both", "P1.total", "P1.BETEst","P1.LB","P1.UB","P1.BETP","P1.BETQ","P1.LB2","P1.UB2","H1.s1","H1.s2","H1.both","H1.total","H1.BETEst","H1.LB","H1.UB","H1.BETP","H1.BETQ","H1.LBw","H1.UBw","H1_P.fetEst","H1_P.LB","H1_P.UB","H1_P.P","H1_P.Q");
write.table(data.output1,file = paste(FixedPrefix3a,InputPrefix1a,type1,"_",unit2,"_output","_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);

###################################################################################################

# Analysis of Data2 Parents and hybrid 2
for (j in 1:nrow(data2)) 

{	
	Par2_Bi <- binom.test(data2[[j,2]], (data2[[j,2]]+data2[[j,3]]), p = 0.5, alternative = c("t"), conf.level = 0.95);
	#Par2_FET <- fisher.test(matrix(c(data2[[j,2]],(sumC-data2[[j,2]]),data2[[j,3]],(sumD-data2[[j,3]])),nr=2));

	Hyb2_Bi <- binom.test(data2[[j,5]], (data2[[j,5]]+data2[[j,6]]), p = 0.5, alternative = c("t"), conf.level = 0.95);
	
	# collect p-values from binomial tests
	pvalsHyb2 <- rbind(pvalsHyb2,Hyb2_Bi$p.value);
	pvalsPar2 <- rbind(pvalsPar2,Par2_Bi$p.value);
	#pvalsPar2 <- rbind(pvalsPar2, Par2_FET$p.value);

	
	tempH2 <- rbind(tempH2,c(Hyb2_Bi$estimate,Hyb2_Bi$conf.int[1],Hyb2_Bi$conf.int[2],Hyb2_Bi$p.value));
	tempP2 <- rbind(tempP2,c(Par2_Bi$estimate,Par2_Bi$conf.int[1],Par2_Bi$conf.int[2],Par2_Bi$p.value));
	#tempP2 <- rbind(tempP2,c(Par2_FET$estimate,Par2_FET$conf.int[1],Par2_FET$conf.int[2],Par2_FET$p.value));
		
	# collect Wilson confidence intervals for binomial tests (to be used later for plotting seq. vs pyro)
	Par2_Bi2 <- binconf(data2[[j,2]], (data2[[j,2]]+data2[[j,3]]), alpha = 0.05, method = c("wilson"));
	
	#create space filling columns (#11 and #12) to keep spacing constant for mel-mel and other comparisons(mel-sim, sim-sec), bascially a repeat of 7 and 8
	#Par2_FET2 <-rbind(Par2_FET2,c(Par2_FET$conf.int[1],Par2_FET$conf.int[2]));
	
	Hyb2_Bi2 <- binconf(data2[[j,5]], (data2[[j,5]]+data2[[j,6]]), alpha = 0.05, method = c("wilson"));
	
	tempH2w <- rbind(tempH2w,c(Hyb2_Bi2[2],Hyb2_Bi2[3]));
	tempP2w <- rbind(tempP2w,c(Par2_Bi2[2],Par2_Bi2[3]));
	
	# Fisher's exact test from 2x2 tables of counts
	hyb2_par.FET <- fisher.test(matrix(c(data2[[j,5]],data2[[j,6]],data2[[j,2]],data2[[j,3]]),nr=2));
	
	# collect p-values from FETs
	pvalsHyb2_Par <- rbind(pvalsHyb2_Par,hyb2_par.FET$p.value);
	
	tempH2_P <- rbind(tempH2_P,c(hyb2_par.FET$estimate,hyb2_par.FET$conf.int[1],hyb2_par.FET$conf.int[2],hyb2_par.FET$p.value));
}

#FDR correct pvalues
pvalsHyb2.adj <- p.adjust(pvalsHyb2,method="fdr");
pvalsPar2.adj <- p.adjust(pvalsPar2,method="fdr");
pvalsHyb2_Par.adj <- p.adjust(pvalsHyb2_Par,method="fdr");

###################################################################################################

#Column contents:

#1		2		3		4		5			6			7		8		9			10				
#gene	P2.s1	P2.s2	P2.both	P2.total	P2.BETEst	P2.LB	P2.UB	P2.BETP	P2.BETQ	
#11		12		13		14		15		16			17			18		19		20			
#P2.LBw	P2.UBw	H2.s1	H2.s2	H2.both	H2.total	H2.BETEst	H2.LB	H2.UB	H2.binomP	
#21			22		23		24			25		26		27		28	
#H2.binomQ	H2.LBw	H2.UBw	H2_P.fetEst	H2_P.LB	H2_P.UB	H2_P.P	H2_P.Q

###################################################################################################

# make output file2
data.output2 <- cbind(data2[,1:4],(data2[,2]+data2[,3]),tempP2,pvalsPar2.adj,tempP2w, data2[,5:7], (data2[,5]+data2[,6]),tempH2,pvalsHyb2.adj,tempH2w,tempH2_P,pvalsHyb2_Par.adj);
colnames(data.output2) <- c("gene", "P2.s1", "P2.s2", "P2.both", "P2.total", "P2.BETEst","P2.LB","P2.UB","P2.BETP","P2.BETQ","P2.LB2","P2.UB2","H2.s1","H2.s2","H2.both","H2.total","H2.BETEst","H2.LB","H2.UB","H2.BETP","H2.BETQ","H2.LBw","H2.UBw","H2_P.fetEst","H2_P.LB","H2_P.UB","H2_P.P","H2_P.Q");
write.table(data.output2,file = paste(FixedPrefix3b,InputPrefix1b,type1,"_",unit2,"_output","_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);

###################################################################################################

# Analysis of Data3 hybrid 1 and hybrid 2
for (k in 1:nrow(data3)) 

{	
	Hyb1_Hyb2_Bi <- binom.test((data3[[k,2]]+data3[[k,3]]), (data3[[k,2]]+data3[[k,3]]+data3[[k,5]]+data3[[k,6]]), p = 0.5, alternative = c("t"), conf.level = 0.95);
	
	# collect p-values from binomial tests
	pvalsHyb1_Hyb2 <- rbind(pvalsHyb1_Hyb2,Hyb1_Hyb2_Bi$p.value);
	
	tempH1_H2_all <-rbind(tempH1_H2_all,c(Hyb1_Hyb2_Bi$estimate,Hyb1_Hyb2_Bi$conf.int[1],Hyb1_Hyb2_Bi$conf.int[2],Hyb1_Hyb2_Bi$p.value));
	
	# collect Wilson confidence intervals for binomial tests (to be used later for plotting seq. vs pyro)
	Hyb1_Hyb2_Bi2 <- binconf((data3[[k,2]]+data3[[k,3]]), (data3[[k,2]]+data3[[k,3]]+data3[[k,5]]+data3[[k,6]]), alpha =0.05, method = c("wilson"));
	
	tempH1H2w <- rbind(tempH1H2w,c(Hyb1_Hyb2_Bi2[2],Hyb1_Hyb2_Bi2[3]));
	
	# Fisher's exact test from 2x2 tables of counts
	hyb1_hyb2.FET <- fisher.test(matrix(c(data3[[k,2]],data3[[k,3]],data3[[k,5]],data3[[k,6]]),nr=2));
	
	# collect p-values from FETs
	pvalsHyb1_Hyb2_FET <- rbind(pvalsHyb1_Hyb2_FET,hyb1_hyb2.FET$p.value);
	
	tempH1_H2 <- rbind(tempH1_H2,c(hyb1_hyb2.FET$estimate,hyb1_hyb2.FET$conf.int[1],hyb1_hyb2.FET$conf.int[2],hyb1_hyb2.FET$p.value));

	# Fisher's exact test from 2x2 tables of counts for Parent of origin effects more appropriately
	hyb1_hyb2.FET2 <- fisher.test(matrix(c((data3[[k,2]]+data3[[k,3]]+data3[[k,4]]),(sum1-(data3[[k,2]]+data3[[k,3]]+data3[[k,4]])),(data3[[k,5]]+data3[[k,6]]+data3[[k,7]]),(sum2-(data3[[k,5]]+data3[[k,6]]+data3[[k,7]]))),nr=2));
	
	# collect p-values from FET 2
	pvalsHyb1_Hyb2_FET2 <- rbind(pvalsHyb1_Hyb2_FET2,hyb1_hyb2.FET2$p.value);
	
	tempH1_H2_2 <- rbind(tempH1_H2_2,c(hyb1_hyb2.FET2$estimate,hyb1_hyb2.FET2$conf.int[1],hyb1_hyb2.FET2$conf.int[2],hyb1_hyb2.FET2$p.value));
}

###################################################################################################

#Column contents:

#1		2		3		4		5			6		7		8		9			10				
#gene	H1.s1	H1.s2	H1.both	H1.total	H2.s1	H2.s2	H2.both	H2.total	H1H2.grandtotal
#11				12		13		14			15			16			17			18			19			
#H1H2.binomEst	H1H2.LB	H1H2.UB	H1H2.binomP	H1H2.binomQ	H1H2.LBw	H1H2.UBw	H1H2.UBw	H1_H2.fetEst
#20			21			22		23		24					25				26				27			
#H1_H2_P.LB	H1_H2.UB	H1_H2.P	H1_H2.Q	H1_H2_PoO.fetEst	H1_H2_PoO.LB	H1_H2_PoO.UB	H1_H2_PoO.P
#28
#H1_H2_PoO.Q

###################################################################################################

#FDR correct pvalues
pvalsHyb1_Hyb2.adj <- p.adjust(pvalsHyb1_Hyb2,method="fdr");
pvalsHyb1_Hyb2_FET.adj <- p.adjust(pvalsHyb1_Hyb2_FET,method="fdr");
pvalsHyb1_Hyb2_FET2.adj <- p.adjust(pvalsHyb1_Hyb2_FET2,method="fdr");

# make output file3
data.output3 <- cbind(data3[,1:4],(data3[,2]+data3[,3]),data3[,5:7],(data3[,5]+data3[,6]),(data3[,2]+data3[,3]+data3[,5]+data3[,6]),tempH1_H2_all,pvalsHyb1_Hyb2.adj,tempH1H2w,tempH1_H2,pvalsHyb1_Hyb2_FET.adj,tempH1_H2_2,pvalsHyb1_Hyb2_FET2.adj);
colnames(data.output3) <- c("gene", "H1.s1", "H1.s2", "H1.both", "H1.total", "H2.s1", "H2.s2", "H2.both", "H2.total", "H1H2.grandtotal", "H1H2.binomEst","H1H2.LB","H1H2.UB","H1H2.binomP","H1H2.binomQ","H1H2.LBw","H1H2.UBw", "H1_H2.fetEst","H1_H2_P.LB","H1_H2.UB","H1_H2.P","H1_H2.Q", "H1_H2_PoO.fetEst","H1_H2_PoO.LB","H1_H2_PoO.UB","H1_H2_PoO.P","H1_H2_PoO.Q");
write.table(data.output3,file = paste(FixedPrefix3c,InputPrefix1c,type1,"_",unit2,"_output","_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);


###################################################################################################
###################################################################################################
###################################################################################################


#Visualize the data with several plots

###################################################################################################
###################################################################################################
#cis-trans plots

#Hyb1 = dir1
#Hyb2 = dir2

# Read in the data (change below to reflect the datafile you want to use
data4<-read.delim(paste(FixedPrefix3a,InputPrefix1a,type1,"_",unit2,"_output","_",date,FixedSuffix2, sep = ""), header = TRUE);
data5<-read.delim(paste(FixedPrefix3b,InputPrefix1b,type1,"_",unit2,"_output","_",date,FixedSuffix2, sep = ""), header = TRUE);

#remove "imprinted" genes

# Read in the data from H1 vs H2
data6<-read.delim(paste(FixedPrefix3c,InputPrefix1c,type1,"_",unit2,"_output","_",date,FixedSuffix2, sep = ""), header = TRUE);
#subset data
#imprint<-c(data6$gene,data6$H1_H2.Q)
#subset not imprinted
imprinted<-subset(data6,(data6$H1_H2.Q > sig))

#Keep those not imprinted
data4<-merge(data4, imprinted, by = 'gene')
data4<-data4[1:28]
data4<-data.frame(data4)

data5<-merge(data5, imprinted, by = 'gene')
data5<-data5[1:28]
data5<-data.frame(data5)

#remove data6, add back later
rm(data6)


# Make zhr/z30 ratios for both parental and hybrid
hyb1_ratio<-(data4$H1.s1/data4$H1.s2)
Par1_ratio<-(data4$P1.s1/data4$P1.s2)
hyb2_ratio<-(data5$H2.s1/data5$H2.s2)
Par2_ratio<-(data5$P2.s1/data5$P2.s2)

#Log2 transfor the ratios
log_hyb1_ratio <-log2(hyb1_ratio)
log_Par1_ratio <-log2(Par1_ratio)
log_hyb2_ratio <-log2(hyb2_ratio)
log_Par2_ratio <-log2(Par2_ratio)

#Make par/hyb ratio to properly determine cis+trans and cisXtrans
logPar1_loghyb1_rat <- log_Par1_ratio/log_hyb1_ratio
logPar2_loghyb2_rat <- log_Par2_ratio/log_hyb2_ratio

#Plots for Hybrid 1

ratios1<-cbind(log_Par1_ratio, log_hyb1_ratio, data4$H1.BETQ, data4$P1.BETQ, data4$H1_P.Q, logPar1_loghyb1_rat)

#ratios1[,1] = log_Par1_ratio
#ratios1[,2] = log_hyb1_ratio
#ratios1[,3] = H1.binomQ
#ratios1[,4] = P1.FETQ
#ratios1[,5] = H1_P.Q
#ratios1[,6] = logpar1_loghyb1_rat

# Perform tests for determining classifications for each gene
a3<-subset(ratios1, ratios1[,3] > sig & ratios1[,4] > sig & ratios1[,5] > sig)
b3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] < sig & ratios1[,5] > sig)
c3<-subset(ratios1, ratios1[,3] > sig & ratios1[,4] < sig & ratios1[,5] < sig)
d3<-subset(ratios1, ratios1[,3] > sig & ratios1[,4] > sig & ratios1[,5] < sig)
e3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] > sig & ratios1[,5] > sig)
f3<-subset(ratios1, ratios1[,3] > sig & ratios1[,4] < sig & ratios1[,5] > sig)
g3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] > sig & ratios1[,5] < sig)
#cis+trans
h3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] < sig & ratios1[,5] < sig & ratios1[,1] > 0 &  ratios1[,2] > 0 & ratios1[,6] > 1)
i3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] < sig & ratios1[,5] < sig & ratios1[,1] < 0 &  ratios1[,2] < 0 & ratios1[,6] > 1)
#cisXtrans
j3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] < sig & ratios1[,5] < sig & ratios1[,1] > 0 &  ratios1[,2] < 0)
k3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] < sig & ratios1[,5] < sig & ratios1[,1] < 0 &  ratios1[,2] > 0)
l3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] < sig & ratios1[,5] < sig & ratios1[,1] > 0 &  ratios1[,2] > 0 & ratios1[,6] < 1)
m3<-subset(ratios1, ratios1[,3] < sig & ratios1[,4] < sig & ratios1[,5] < sig & ratios1[,1] < 0 &  ratios1[,2] < 0 & ratios1[,6] < 1)

var1<-c(nrow(a3),nrow(b3),nrow(c3),nrow(g3),(nrow(h3)+nrow(i3)),(nrow(j3)+nrow(k3)+nrow(l3)+nrow(m3)),(nrow(d3)+nrow(e3)+nrow(f3)),nrow(ratios1));
data.output4 <- matrix(data=var1,nrow=1, ncol=8, byrow=FALSE)
colnames(data.output4)<-c("Conserved","All cis","All trans","Compensatory","cis+trans","cisXtrans","Ambiguous","total");
write.table(data.output4, file = paste(FixedPrefix3a,InputPrefix1a,type1,"_",unit2,"_","cis-trans_classified_",dir1,"_",sig,"_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);

lbls1<-c("Conserved","All cis","All trans","Compensatory","cis+trans","cisXtrans","Ambiguous","total")
colors1<-c("yellow","black","red","orange","blue","green","gray")
slices1<-(var1[1:7]/var1[8])

pdf(file = paste(FixedPrefix3a,"cis-trans-pie_",type1,"_",InputPrefix1a,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

pie(slices1,labels = lbls1, col = colors1, main = "PH1 cis-trans pie")

dev.off()

pdf(file = paste(FixedPrefix3a,"cis-trans-plot_",type1,"_",InputPrefix1a,"10X10_",unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

plot(ratios1[,1], ratios1[,2], type="n", xlab= paste("log2(parental (",cross1,"))", sep = ""), ylab=paste("log2(hybrid ",dir1," (",cross1,")", sep = ""), xlim=c(-10,10),ylim=c(-10,10), main = paste("cis-trans plot",type1,dir1,InputPrefix1a,unit2,sig,date, sep = " "))

#Ambiguous
points(d3, col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(e3, col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(f3, col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#cis + trans
points(h3, col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(i3, col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#cis X trans
points(j3, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(k3, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(l3, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(m3, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#All cis
points(b3, col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#All trans
points(c3, col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#Compensatory
points(g3, col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#Conserved
points(a3, col=rgb(t(col2rgb("yellow")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

abline(h=c(0))
abline(v=c(0))
abline(a=0,b=1)
dev.off()


#Plots for Hybrid 2
ratios2<-cbind(log_Par2_ratio, log_hyb2_ratio, data5$H2.BETQ, data5$P2.BETQ, data5$H2_P.Q, logPar2_loghyb2_rat)

#ratios2[,1] = log_Par2_ratio
#ratios2[,2] = log_hyb2_ratio
#ratios2[,3] = H2.binomQ
#ratios2[,4] = P2.FETQ
#ratios2[,5] = H2_P.Q
#ratios2[,6] = logPar2_loghyb2_rat

# Perform tests for determining classifications for each gene
a4<-subset(ratios2, ratios2[,3] > sig & ratios2[,4] > sig & ratios2[,5] > sig)
b4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] < sig & ratios2[,5] > sig)
c4<-subset(ratios2, ratios2[,3] > sig & ratios2[,4] < sig & ratios2[,5] < sig)
d4<-subset(ratios2, ratios2[,3] > sig & ratios2[,4] > sig & ratios2[,5] < sig)
e4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] > sig & ratios2[,5] > sig)
f4<-subset(ratios2, ratios2[,3] > sig & ratios2[,4] < sig & ratios2[,5] > sig)
g4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] > sig & ratios2[,5] < sig)
#cis+trans
h4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] < sig & ratios2[,5] < sig & ratios2[,1] > 0 &  ratios2[,2] > 0 & ratios2[,6] > 1)
i4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] < sig & ratios2[,5] < sig & ratios2[,1] < 0 &  ratios2[,2] < 0 & ratios2[,6] > 1)
#cisXtrans
j4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] < sig & ratios2[,5] < sig & ratios2[,1] > 0 &  ratios2[,2] < 0)
k4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] < sig & ratios2[,5] < sig & ratios2[,1] < 0 &  ratios2[,2] > 0)
l4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] < sig & ratios2[,5] < sig & ratios2[,1] > 0 &  ratios2[,2] > 0 & ratios2[,6] < 1)
m4<-subset(ratios2, ratios2[,3] < sig & ratios2[,4] < sig & ratios2[,5] < sig & ratios2[,1] < 0 &  ratios2[,2] < 0 & ratios2[,6] < 1)

var2<-c(nrow(a4),nrow(b4),nrow(c4),nrow(g4),(nrow(h4)+nrow(i4)),(nrow(j4)+nrow(k4)+nrow(l4)+nrow(m4)),(nrow(d4)+nrow(e4)+nrow(f4)),nrow(ratios2))
data.output5 <- matrix(data=var2,nrow=1, ncol=8, byrow=FALSE)
colnames(data.output5)<-c("Conserved","All cis","All trans","Compensatory","cis+trans","cisXtrans","Ambiguous","total");
write.table(data.output5, file = paste(FixedPrefix3b,InputPrefix1b,type1,"_",unit2,"_","cis-trans_classified_",dir2,"_",sig,"_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);

lbls2<-c("Conserved","All cis","All trans","Compensatory","cis+trans","cisXtrans","Ambiguous","total")
colors2<-c("yellow","black","red","orange","blue","green","gray")
slices2<-(var2[1:7]/var2[8])

pdf(file = paste(FixedPrefix3b,"cis-trans-pie_",type1,"_",InputPrefix1b,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

pie(slices2,labels = lbls2, col = colors2, main = "PH2 cis-trans pie")

dev.off()


pdf(file = paste(FixedPrefix3b,"cis-trans-plot_",type1,"_",InputPrefix1b,"10X10_",unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

plot(ratios2[,1], ratios2[,2], type="n", xlab=paste("log2(parental (",cross1,"))", sep = ""), ylab=paste("log2(hybrid ",dir2," ",cross1,")", sep = ""), xlim=c(-10,10),ylim=c(-10,10),main = paste("cis-trans plot",type1,dir2,InputPrefix1b,unit2,sig,date, sep = " "))

#Ambiguous
points(d4, col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(e4, col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(f4, col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#cis + trans
points(h4, col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(i4, col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#cis X trans
points(j4, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(k4, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(l4, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(m4, col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#All cis
points(b4, col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#All trans
points(c4, col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#Compensatory
points(g4, col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#Conserved
points(a4, col=rgb(t(col2rgb("yellow")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

abline(h=c(0))
abline(v=c(0))
abline(a=0,b=1)
dev.off()

###################################################################################################
###################################################################################################
#dominance plots

#H1=dir1
#H2=dir2

# Restrict to genes that are significantly differentially expressed 
# between the two parental species.

#div1<-subset(data4, data4$P1.FETQ < sig)
#div2<-subset(data5, data5$P2.FETQ < sig)

#Don't restrict to significantly differentially experssed between species

div1<-subset(data4)
div2<-subset(data5)

# Convert to proportion of total
#H.both=div[,15]
# H.total=div[,16]   ...(A1+A2)...
# P.s1=div[,2]
# P.s2=div[,3]
# P.S1=div[,4]

#29 = P1 total   # div1[,2]+((div1[,2]/(div1[,2]+div1[,3]))*div1[,4])) #

div1[,29] = (div1[,2]+((div1[,2]/(div1[,2]+div1[,3]))*div1[,4]))
div2[,29] = (div2[,2]+((div2[,2]/(div2[,2]+div2[,3]))*div2[,4]))

#30 = P2 total

div1[,30] = (div1[,3]+((div1[,3]/(div1[,2]+div1[,3]))*div1[,4]))
div2[,30] = (div2[,3]+((div2[,3]/(div2[,2]+div2[,3]))*div2[,4]))

Hyb1_pct<-((div1[,16]+div1[,15])/(sum(div1[,16])+sum(div1[,15])))
Hyb2_pct<-((div2[,16]+div2[,15])/(sum(div2[,16])+sum(div2[,15])))

Mix1_P1_pct<-(div1[,29]/sum(div1[,29]))
Mix1_P2_pct<-(div1[,30]/sum(div1[,30]))

Mix2_P1_pct<-div2[,29]/(sum(div2[,29]))
Mix2_P2_pct<-div2[,30]/(sum(div2[,30]))

#if decide to go back to old way it is retained (does not use boths)
#Hyb1_pct<-div1[,16]/(sum(div1[,16]))
#Hyb2_pct<-div2[,16]/(sum(div2[,16]))
#Mix1_P1_pct<-div1[,2]/(sum(div1[,2]))
#Mix1_P2_pct<-div1[,3]/(sum(div1[,3]))
#Mix2_P1_pct<-div2[,2]/(sum(div2[,2]))
#Mix2_P2_pct<-div2[,3]/(sum(div2[,3]))

# Calculate values for axis of dominance plot
P2diff1<-log2(Hyb1_pct*100)-log2(Mix1_P2_pct*100)
P1diff1<-log2(Hyb1_pct*100)-log2(Mix1_P1_pct*100)
P2diff2<-log2(Hyb2_pct*100)-log2(Mix2_P2_pct*100)
P1diff2<-log2(Hyb2_pct*100)-log2(Mix2_P1_pct*100)

# Make Dominance plot 1 (dir1)

#log2(1.25)=0.3219281

# Perform tests for determining classifications for each gene
test1<-cbind(P1diff1,P2diff1)
a1<-subset(test1,test1[,1]< -log2(1.25) & test1[,2]< -log2(1.25))
b1<-subset(test1,test1[,1]< -log2(1.25) & test1[,2]> -log2(1.25) & test1[,2]< log2(1.25))
c1<-subset(test1,test1[,1]< -log2(1.25) & test1[,2]> log2(1.25))
d1<-subset(test1,test1[,1]> -log2(1.25) & test1[,1]< log2(1.25) & test1[,2]< -log2(1.25))
e1<-subset(test1,test1[,1]> -log2(1.25) & test1[,1]< log2(1.25) & test1[,2]> -log2(1.25) & test1[,2]< log2(1.25))
f1<-subset(test1,test1[,1]> -log2(1.25) & test1[,1]< log2(1.25) & test1[,2]> log2(1.25))
g1<-subset(test1,test1[,1]> log2(1.25) & test1[,2]< -log2(1.25))
h1<-subset(test1,test1[,1]> log2(1.25) & test1[,2]> -log2(1.25) & test1[,2]< log2(1.25))
i1<-subset(test1,test1[,1]> log2(1.25) & test1[,2]> log2(1.25))

var3<-c(nrow(e1),(nrow(c1)+nrow(g1)),(nrow(d1)+nrow(f1)),(nrow(b1)+nrow(h1)),nrow(a1),nrow(i1),nrow(test1));
data.output6 <- matrix(data=var3,nrow=1, ncol=7, byrow=FALSE)
colnames(data.output6)<- c('Conserved','Additive',paste(par1," Dominant",sep = ""),paste(par2," Dominant", sep = ""),'Underdominant', 'Overdominant','total');

write.table(data.output6, file = paste(FixedPrefix3a,InputPrefix1a,type1,"_",unit2,"_","dominance_classified_",dir1,"_",sig,"_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);

lbls3<-c('Conserved','Additive',paste(par1," Dominant",sep = ""),paste(par2," Dominant", sep = ""),'Underdominant', 'Overdominant')
colors3<-c("5","orange","3","6","red","blue")
slices3<-(var3[1:6]/var3[7])

pdf(file = paste(FixedPrefix3a,"dominance-pie_",type1,"_",InputPrefix1a,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

pie(slices3,labels = lbls3, col = colors3, main = "PH1 dominance pie")

dev.off()

pdf(file = paste(FixedPrefix3a,"Dominance-plot_",type1,"_",dir1,"_",unit2,"_","10X10_",sig,"_",date,FixedSuffix1, sep = ""))

plot(test1, type="n", xlab=paste("log(Hyb1 exp)-log(",par1," exp)", sep = ""), ylab=paste("log(Hyb1 exp)-log(",par2," exp)", sep = ""), xlim=c(-10,10),ylim=c(-10,10), main = paste("Dominance plot",type1,dir1,unit2,"log2(1.25)",date, sep = " "))

#underdominant
points(a1, col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#additive
points(c1, col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(g1, col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#overdominant
points(i1, col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par1 dominant
points(d1, col=rgb(t(col2rgb("3")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(f1, col=rgb(t(col2rgb("3")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par2 dominant
points(b1,col=rgb(t(col2rgb("6")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(h1, col=rgb(t(col2rgb("6")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#conserved
points(e1, col=rgb(t(col2rgb("5")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
nrow(data4)-nrow(div1)

abline(h=c(0))
abline(v=c(0))
abline(a=0,b=1)

dev.off()

# Make Dominance plot 2 (dir2)

# Perform tests for determining classifications for each gene
test2<-cbind(P1diff2,P2diff2)
a2<-subset(test2,test2[,1]< -log2(1.25) & test2[,2]< -log2(1.25))
b2<-subset(test2,test2[,1]< -log2(1.25) & test2[,2]> -log2(1.25) & test2[,2]< log2(1.25))
c2<-subset(test2,test2[,1]< -log2(1.25) & test2[,2]> log2(1.25))
d2<-subset(test2,test2[,1]> -log2(1.25) & test2[,1]< log2(1.25) & test2[,2]< -log2(1.25))
e2<-subset(test2,test2[,1]> -log2(1.25) & test2[,1]< log2(1.25) & test2[,2]> -log2(1.25) & test2[,2]< log2(1.25))
f2<-subset(test2,test2[,1]> -log2(1.25) & test2[,1]< log2(1.25) & test2[,2]> log2(1.25))
g2<-subset(test2,test2[,1]> log2(1.25) & test2[,2]< -log2(1.25))
h2<-subset(test2,test2[,1]> log2(1.25) & test2[,2]> -log2(1.25) & test2[,2]< log2(1.25))
i2<-subset(test2,test2[,1]> log2(1.25) & test2[,2]> log2(1.25))

var4<-c(nrow(e2),(nrow(c2)+nrow(g2)),(nrow(d2)+nrow(f2)),(nrow(b2)+nrow(h2)),nrow(a2),nrow(i2),nrow(test2));
data.output7 <- matrix(data=var4,nrow=1, ncol=7, byrow=FALSE)
colnames(data.output7)<- c('Conserved','Additive',paste(par1," Dominant",sep = ""),paste(par2," Dominant", sep = ""),'Underdominant', 'Overdominant','total');

write.table(data.output7, file = paste(FixedPrefix3b,InputPrefix1b,type1,"_",unit2,"_","dominance_classified_",dir2,"_",sig,"_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);

lbls4<-c('Conserved','Additive',paste(par1," Dominant",sep = ""),paste(par2," Dominant", sep = ""),'Underdominant', 'Overdominant')
colors4<-c("5","orange","3","6","red","blue")
slices4<-(var4[1:6]/var4[7])

pdf(file = paste(FixedPrefix3b,"dominance-pie_",type1,"_",InputPrefix1b,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

pie(slices4,labels = lbls4, col = colors4, main = "PH2 dominance pie")

dev.off()

pdf(file = paste(FixedPrefix3b,"Dominance-plot_",type1,"_",dir2,"_",unit2,"_","10X10_",sig,"_",date,FixedSuffix1, sep = ""))

plot(test2, type="n", xlab=paste("log(Hyb2 exp)-log(",par1," exp)",sep=""), ylab=paste("log(Hyb2 exp)-log(",par2," exp)", sep = ""), xlim=c(-10,10),ylim=c(-10,10), main = paste("Dominance plot",type1,dir2,unit2,"log2(1.25)",date, sep = " "))

#underdominant
points(a2, col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#additive
points(c2, col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(g2, col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#overdominant
points(i2, col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par1 dominant
points(d2, col=rgb(t(col2rgb("3")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(f2, col=rgb(t(col2rgb("3")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#par2 dominant
points(b2,col=rgb(t(col2rgb("6")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
points(h2, col=rgb(t(col2rgb("6")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#conserved
points(e2, col=rgb(t(col2rgb("5")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
nrow(data5)-nrow(div2)

abline(h=c(0))
abline(v=c(0))
abline(a=0,b=1)

dev.off()

###################################################################################################
###################################################################################################
#imprinting

# Read in the data (change below to reflect the datafile you want to use
data6<-read.delim(paste(FixedPrefix3c,InputPrefix1c,type1,"_",unit2,"_output","_",date,FixedSuffix2, sep = ""), header = TRUE);

# Make mel/sim ratios for both parental and hybrid
hyb1_ratio_Imprint<-(data6$H1.s1/data6$H1.s2)
hyb2_ratio_Imprint<-(data6$H2.s1/data6$H2.s2)

#Log2 transform the ratios
log_hyb1_ratio_Imprint <-log2(hyb1_ratio_Imprint)
log_hyb2_ratio_Imprint <-log2(hyb2_ratio_Imprint)

ratios3<-cbind(log_hyb1_ratio_Imprint, log_hyb2_ratio_Imprint, data6$H1_H2.Q)
#log_hyb1_ratio_Imprint = ratios3[,1]
#log_hyb2_ratio_Imprint = ratios3[,2]
#data6$H1_H2.Q = ratios3[,3]

# Perform tests for determining classifications for each gene
a5<-subset(ratios3, ratios3[,3] < sig)
b5<-subset(ratios3, ratios3[,3] > sig)

var5<-c(nrow(a5),nrow(b5),nrow(ratios3));
data.output8 <- matrix(data=var5,nrow=1, ncol=3, byrow=FALSE)
colnames(data.output8) <- c("Significant","Nonsignificant","Total");
write.table(data.output8, file = paste(FixedPrefix3c,InputPrefix1c,type1,"_",unit2,"_","Imprinting_classified_",sig,"_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);

lbls5<-c("imprinted","not imprinted")
colors5<-c("red","black")
slices5<-(var5[1:2]/var5[3])

pdf(file = paste(FixedPrefix3c,"imprinting-pie_",type1,"_",InputPrefix1c,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

pie(slices5,labels = lbls5, col = colors5, main = "H1H2 imprint pie")

dev.off()

# Plot Imprinting effects
pdf(file = paste(FixedPrefix3c,"Imprinting-plot_",type1,"_",InputPrefix1c,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

plot(ratios3[,1], ratios3[,2], type="n", xlab=paste("log2(Hybrid1 ",dir1," ",cross1,")", sep = ""), ylab=paste("log2(Hybrid2 ",dir2," ",cross1,")", sep = ""), xlim=c(-10,10),ylim=c(-10,10), main = paste("Imprinting plot",type1,InputPrefix1c,unit2,sig,date, sep = " "))

#nonsignificant Imprinting effects
points(b5, col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#significant Imprinting effects
points(a5, col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

abline(v=0)
abline(h=0)
abline(a=0,b=1)

dev.off()

###################################################################################################
###################################################################################################
# Plot Parent of Origin effects

###################################################################################################

#Column contents:

#1		2		3		4		5			6		7		8		9			10				
#gene	H1.s1	H1.s2	H1.both	H1.total	H2.s1	H2.s2	H2.both	H2.total	H1H2.grandtotal
#11				12		13		14			15			16			17			18			19			
#H1H2.binomEst	H1H2.LB	H1H2.UB	H1H2.binomP	H1H2.binomQ	H1H2.LBw	H1H2.UBw	H1H2.UBw	H1_H2.fetEst
#20			21			22		23		24					25				26				27			
#H1_H2_P.LB	H1_H2.UB	H1_H2.P	H1_H2.Q	H1_H2_PoO.fetEst	H1_H2_PoO.LB	H1_H2_PoO.UB	H1_H2_PoO.P
#28
#H1_H2_PoO.Q

###################################################################################################

#remove "imprinted genes"
data6<-subset(data6, data6$H1_H2.Q > sig)

ratios4<-cbind(log10((data6$H1.total) + data6[,4]), log10((data6$H2.total) + data6[,8]), data6$H1_H2_PoO.Q)

#data6$H1.total(A1+A2+both) = ratios4[,1]
#data6$H2.total(A1+A2+both) = ratios4[,2]
#data6$H1_H2_PoO.Q = ratios4[,3]

# Perform tests for determining classifications for each gene
a6<-subset(ratios4, ratios4[,3] < sig)
b6<-subset(ratios4, ratios4[,3] > sig)

var6 <- c(nrow(a6),nrow(b6),nrow(ratios4));
data.output9 <- matrix(data=var6,nrow=1, ncol=3, byrow=FALSE)
colnames(data.output9) <- c("Significant","Nonsignificant","Total");
write.table(data.output9, file = paste(FixedPrefix3c,InputPrefix1c,type1,"_",unit2,"_","PoO_classified_",sig,"_",date,FixedSuffix2, sep = ""),sep="\t",quote=FALSE,row.names=FALSE);


lbls6<-c("Significant parent of origin effect","No parent of origin effect")
colors6<-c("red","black")
slices6<-(var6[1:2]/var6[3])

pdf(file = paste(FixedPrefix3c,"PoO-pie_",type1,"_",InputPrefix1c,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

pie(slices6,labels = lbls6, col = colors6, main = "H1H2 PoO pie")

dev.off()

#Plot Parent of Origin Effects
pdf(file = paste(FixedPrefix3c,"PoO-plot_",type1,"_",InputPrefix1c,unit2,"_",sig,"_",date,FixedSuffix1, sep = ""))

plot(ratios4[,1], ratios4[,2], type="n", xlab=paste("log10(Hybrid1 total) (",dir1,")", sep = ""), ylab=paste("log10(Hybrid2 total) (",dir2,")", sep = ""), main = paste("Parent of Origin plot",type1,InputPrefix1c,unit2,sig,date, sep = " "))

#nonsignificant Parent of Origin effects
points(b6, col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#significant Parent of Origin effects
points(a6, col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

#abline(h=c(0))
#abline(v=c(0))
abline(a=0,b=1)

dev.off()

rm(list=ls())

####################################################################################################
####################################################################################################
#Code to make new outputs that are classified according to statisitcal tests and data values.
####################################################################################################
####################################################################################################

#Load mel-mel data genes
data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/zhr+z30_zhrXz30_mRNA_meta_gene_output_120113.txt", header=TRUE)

####################################################################################################
####################################################################################################
#corresponding imprinting files to remove

# Read in the data from H1 v H2
data3<-read.delim("/Final/zhr_z30/mel-mel_H1+H2/outputs/zhrXz30_z30Xzhr_mRNA_meta_gene_output_120113.txt", header = TRUE);
data3<-subset(data3,(data3$H1_H2.Q > 0.05))

data4<-read.delim("/Final/mel_sim/mel-sim_H1+H2/outputs/zhrXtsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113.txt", header = TRUE);
data4<-subset(data4,(data4$H1_H2.Q > 0.05))

data5<-read.delim("/Final/sim_sec/sim-sec_H1+H2/outputs/tsimbazazaXdroSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113.txt", header = TRUE);
data5<-subset(data5,(data5$H1_H2.Q > 0.05))

data6<-merge(data3,data4, by = 'gene')
data7<-merge(data6,data5, by = 'gene')

dataGENES<-data7[,1]
dataGENES<-data.frame(dataGENES)
colnames(dataGENES)<-c('gene')

###################################################################################################

#Column contents:

#1		2		3		4		5			6			7		8		9			10				
#gene	P1.s1	P1.s2	P1.both	P1.total	P1.binomEst	P1.LB	P1.UB	P1.binomP	P1.binomQ	
#11		12		13		14		15		16			17			18		19		20			
#P1.LBw	P1.UBw	H1.s1	H1.s2	H1.both	H1.total	H1.binomEst	H1.LB	H1.UB	H1.binomP	
#21			22		23		24			25		26		27		28	
#H1.binomQ	H1.LBw	H1.UBw	H1_P.fetEst	H1_P.LB	H1_P.UB	H1_P.P	H1_P.Q

###################################################################################################

#use common set of non"imprinted" genes

data1<-merge(dataGENES, data1, by = 'gene')
data1<-data1[1:28]
data1<-data.frame(data1)

#for data 1:

for (i in 1:nrow(data1)) 
	{
	if (data1[i,2] == 0) {data1[i,2] = 1} else {data1[i,2] == data1[i,2]}
	if (data1[i,3] == 0) {data1[i,3] = 1} else {data1[i,3] == data1[i,3]}
	if (data1[i,13] == 0) {data1[i,13] = 1} else {data1[i,13] == data1[i,13]}
	if (data1[i,14] == 0) {data1[i,14] = 1} else {data1[i,14] == data1[i,14]}
	}

psum1 = (data1[,2]+((data1[,2]/(data1[,2]+data1[,3]))*data1[,4]))
psum2 = (data1[,3]+((data1[,3]/(data1[,2]+data1[,3]))*data1[,4]))

#29
data1$logPrat = log2(data1[,2]/data1[,3])
#30
data1$logHrat = log2(data1[,13]/data1[,14])
#31
data1$logPrat_logHrat_rat = data1$logPrat/data1$logHrat
#32
data1$percentcis = (abs(data1$logHrat)/(abs(data1$logHrat)+abs(data1$logPrat-data1$logHrat)))*100
#33
data1$H_P1diff = ((log2(((data1[,16]+data1[,15])/(sum(data1[,16])+sum(data1[,15])))*100)) - (log2(((data1[,2]+((data1[,2]/(data1[,2]+data1[,3]))*data1[,4]))/sum(psum1))*100)))
#34
data1$H_P2diff = ((log2(((data1[,16]+data1[,15])/(sum(data1[,16])+sum(data1[,15])))*100)) - (log2(((data1[,3]+((data1[,3]/(data1[,2]+data1[,3]))*data1[,4]))/sum(psum2))*100)))
#35
data1$Pdiff = c(2:2)
#36
data1$cis = c(2:2)
#37
data1$trans = c(2:2)
#38
data1$allcis = c(2:2)
#39
data1$alltrans = c(2:2)
#40
data1$conserved1 = c(2:2)
#41
data1$compensatory = c(2:2)
#42
data1$ambiguous = c(2:2)
#43
data1$cisplustrans = c(2:2)
#44
data1$cisXtrans = c(2:2)


for (j in 1:nrow(data1)) 
	{
	
	if (data1[j,10] < 0.05)  {data1[j,35] = 1} else {data1[j,35] = 0}
	if (data1[j,21] < 0.05)  {data1[j,36] = 1} else {data1[j,36] = 0}
	if (data1[j,28] < 0.05)  {data1[j,37] = 1} else {data1[j,37] = 0}
	
	if ((data1[j,10] < 0.05) && (data1[j,21] < 0.05) && (data1[j,28] > 0.05)) {data1[j,38] = 1} else {data1[j,38] = 0}
	if ((data1[j,10] < 0.05) && (data1[j,21] > 0.05) && (data1[j,28] < 0.05)) {data1[j,39] = 1} else {data1[j,39] = 0}
	if ((data1[j,10] > 0.05) && (data1[j,21] > 0.05) && (data1[j,28] > 0.05)) {data1[j,40] = 1} else {data1[j,40] = 0}
	if ((data1[j,10] > 0.05) && (data1[j,21] < 0.05) && (data1[j,28] < 0.05)) {data1[j,41] = 1} else {data1[j,41] = 0}
	if (((data1[j,10] > 0.05) && (data1[j,21] > 0.05) && (data1[j,28] < 0.05)) || ((data1[j,10] > 0.05) && (data1[j,21] < 0.05) && (data1[j,28] > 0.05)) || ((data1[j,10] < 0.05) && (data1[j,21] > 0.05) && (data1[j,28] > 0.05))) {data1[j,42] = 1} else {data1[j,42] = 0}
	
	if (((data1[j,10] < 0.05) && (data1[j,21] < 0.05) && (data1[j,28] < 0.05) && (data1[j,29] > 0) && (data1[j,30] > 0) && (data1[j,31] > 1)) || ((data1[j,10] < 0.05) && (data1[j,21] < 0.05) && (data1[j,28] < 0.05) && (data1[j,29] < 0) && (data1[j,30] < 0) && (data1[j,31] > 1))) {data1[j,43] = 1} else {data1[j,43] = 0}
	if (((data1[j,10] < 0.05) && (data1[j,21] < 0.05) && (data1[j,28] < 0.05) && (data1[j,29] > 0) && (data1[j,30] < 0)) || ((data1[j,10] < 0.05) && (data1[j,21] < 0.05) && (data1[j,28] < 0.05) && (data1[j,29] < 0) && (data1[j,30] > 0)) || ((data1[j,10] < 0.05) && (data1[j,21] < 0.05) && (data1[j,28] < 0.05) && (data1[j,29] > 0) && (data1[j,30] > 0) && (data1[j,31] < 1)) || ((data1[j,10] < 0.05) && (data1[j,21] < 0.05) && (data1[j,28] < 0.05) && (data1[j,29] < 0) && (data1[j,30] < 0) && (data1[j,31] < 1))) {data1[j,44] = 1} else {data1[j,44] = 0}
	
	}

write.table(data1, file = "/Final/zhr_z30/mel-mel_P+H1/outputs/zhr+z30_zhrXz30_mRNA_meta_gene_output_120113_classified.txt",sep="\t",quote=FALSE,row.names=FALSE)

sum(data1[,35])
sum(data1[,36])
sum(data1[,37])
sum(data1[,38])
sum(data1[,39])
sum(data1[,40])
sum(data1[,41])
sum(data1[,42])
sum(data1[,43])
sum(data1[,44])


rm(list=ls())

##################################################################################################
#Load mel-mel data genes

data2<-read.delim("/Final/zhr_z30/mel-mel_P+H2/outputs/zhr+z30_z30Xzhr_mRNA_meta_gene_output_120113.txt", header=TRUE)

####################################################################################################
####################################################################################################
#corresponding imprinting files to remove

# Read in the data from H1 v H2
data3<-read.delim("/Final/zhr_z30/mel-mel_H1+H2/outputs/zhrXz30_z30Xzhr_mRNA_meta_gene_output_120113.txt", header = TRUE);
data3<-subset(data3,(data3$H1_H2.Q > 0.05))

data4<-read.delim("/Final/mel_sim/mel-sim_H1+H2/outputs/zhrXtsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113.txt", header = TRUE);
data4<-subset(data4,(data4$H1_H2.Q > 0.05))

data5<-read.delim("/Final/sim_sec/sim-sec_H1+H2/outputs/tsimbazazaXdroSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113.txt", header = TRUE);
data5<-subset(data5,(data5$H1_H2.Q > 0.05))

data6<-merge(data3,data4, by = 'gene')
data7<-merge(data6,data5, by = 'gene')

dataGENES<-data7[,1]
dataGENES<-data.frame(dataGENES)
colnames(dataGENES)<-c('gene')

data2<-merge(dataGENES, data2, by = 'gene')
data2<-data2[1:28]
data2<-data.frame(data2)

#for data 2:

for (i in 1:nrow(data2)) 
	{
	if (data2[i,2] == 0) {data2[i,2] = 1} else {data2[i,2] == data2[i,2]}
	if (data2[i,3] == 0) {data2[i,3] = 1} else {data2[i,3] == data2[i,3]}
	if (data2[i,13] == 0) {data2[i,13] = 1} else {data2[i,13] == data2[i,13]}
	if (data2[i,14] == 0) {data2[i,14] = 1} else {data2[i,14] == data2[i,14]}
	}

psum1 = (data2[,2]+((data2[,2]/(data2[,2]+data2[,3]))*data2[,4]))
psum2 = (data2[,3]+((data2[,3]/(data2[,2]+data2[,3]))*data2[,4]))

#29
data2$logPrat = log2(data2[,2]/data2[,3])
#30
data2$logHrat = log2(data2[,13]/data2[,14])
#31
data2$logPrat_logHrat_rat = data2$logPrat/data2$logHrat
#32
data2$percentcis = (abs(data2$logHrat)/(abs(data2$logHrat)+abs(data2$logPrat-data2$logHrat)))*100
#33
data2$H_P1diff = ((log2(((data2[,16]+data2[,15])/(sum(data2[,16])+sum(data2[,15])))*100)) - (log2(((data2[,2]+((data2[,2]/(data2[,2]+data2[,3]))*data2[,4]))/sum(psum1))*100)))
#34
data2$H_P2diff = ((log2(((data2[,16]+data2[,15])/(sum(data2[,16])+sum(data2[,15])))*100)) - (log2(((data2[,3]+((data2[,3]/(data2[,2]+data2[,3]))*data2[,4]))/sum(psum2))*100)))
#35
data2$Pdiff = c(2:2)
#36
data2$cis = c(2:2)
#37
data2$trans = c(2:2)
#38
data2$allcis = c(2:2)
#39
data2$alltrans = c(2:2)
#40
data2$conserved1 = c(2:2)
#41
data2$compensatory = c(2:2)
#42
data2$ambiguous = c(2:2)
#43
data2$cisplustrans = c(2:2)
#44
data2$cisXtrans = c(2:2)

for (j in 1:nrow(data2)) 
	{
	
	if (data2[j,10] < 0.05)  {data2[j,35] = 1} else {data2[j,35] = 0}
	if (data2[j,21] < 0.05)  {data2[j,36] = 1} else {data2[j,36] = 0}
	if (data2[j,28] < 0.05)  {data2[j,37] = 1} else {data2[j,37] = 0}
	
	if ((data2[j,10] < 0.05) && (data2[j,21] < 0.05) && (data2[j,28] > 0.05)) {data2[j,38] = 1} else {data2[j,38] = 0}
	if ((data2[j,10] < 0.05) && (data2[j,21] > 0.05) && (data2[j,28] < 0.05)) {data2[j,39] = 1} else {data2[j,39] = 0}
	if ((data2[j,10] > 0.05) && (data2[j,21] > 0.05) && (data2[j,28] > 0.05)) {data2[j,40] = 1} else {data2[j,40] = 0}
	if ((data2[j,10] > 0.05) && (data2[j,21] < 0.05) && (data2[j,28] < 0.05)) {data2[j,41] = 1} else {data2[j,41] = 0}
	if (((data2[j,10] > 0.05) && (data2[j,21] > 0.05) && (data2[j,28] < 0.05)) || ((data2[j,10] > 0.05) && (data2[j,21] < 0.05) && (data2[j,28] > 0.05)) || ((data2[j,10] < 0.05) && (data2[j,21] > 0.05) && (data2[j,28] > 0.05))) {data2[j,42] = 1} else {data2[j,42] = 0}
	
	if (((data2[j,10] < 0.05) && (data2[j,21] < 0.05) && (data2[j,28] < 0.05) && (data2[j,29] > 0) && (data2[j,30] > 0) && (data2[j,31] > 1)) || ((data2[j,10] < 0.05) && (data2[j,21] < 0.05) && (data2[j,28] < 0.05) && (data2[j,29] < 0) && (data2[j,30] < 0) && (data2[j,31] > 1))) {data2[j,43] = 1} else {data2[j,43] = 0}
	if (((data2[j,10] < 0.05) && (data2[j,21] < 0.05) && (data2[j,28] < 0.05) && (data2[j,29] > 0) && (data2[j,30] < 0)) || ((data2[j,10] < 0.05) && (data2[j,21] < 0.05) && (data2[j,28] < 0.05) && (data2[j,29] < 0) && (data2[j,30] > 0)) || ((data2[j,10] < 0.05) && (data2[j,21] < 0.05) && (data2[j,28] < 0.05) && (data2[j,29] > 0) && (data2[j,30] > 0) && (data2[j,31] < 1)) || ((data2[j,10] < 0.05) && (data2[j,21] < 0.05) && (data2[j,28] < 0.05) && (data2[j,29] < 0) && (data2[j,30] < 0) && (data2[j,31] < 1))) {data2[j,44] = 1} else {data2[j,44] = 0}
	
	}

write.table(data2, file = "/Final/zhr_z30/mel-mel_P+H2/outputs/zhr+z30_z30Xzhr_mRNA_meta_gene_output_120113_classified.txt",sep="\t",quote=FALSE,row.names=FALSE)
	
sum(data2[,35])
sum(data2[,36])
sum(data2[,37])
sum(data2[,38])
sum(data2[,39])
sum(data2[,40])
sum(data2[,41])
sum(data2[,42])
sum(data2[,43])
sum(data2[,44])

rm(list=ls())

####################################################################################################
####################################################################################################
#Load sim-sech data gene

data1<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta_gene_output_120113.txt", header=TRUE)

####################################################################################################
####################################################################################################
#corresponding imprinting files to remove

# Read in the data from H1 v H2
data3<-read.delim("/Final/zhr_z30/mel-mel_H1+H2/outputs/zhrXz30_z30Xzhr_mRNA_meta_gene_output_120113.txt", header = TRUE);
data3<-subset(data3,(data3$H1_H2.Q > 0.05))

data4<-read.delim("/Final/mel_sim/mel-sim_H1+H2/outputs/zhrXtsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113.txt", header = TRUE);
data4<-subset(data4,(data4$H1_H2.Q > 0.05))

data5<-read.delim("/Final/sim_sec/sim-sec_H1+H2/outputs/tsimbazazaXdroSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113.txt", header = TRUE);
data5<-subset(data5,(data5$H1_H2.Q > 0.05))

data6<-merge(data3,data4, by = 'gene')
data7<-merge(data6,data5, by = 'gene')

dataGENES<-data7[,1]
dataGENES<-data.frame(dataGENES)
colnames(dataGENES)<-c('gene')


###################################################################################################

#Column contents:

#1		2		3		4		5			6			7		8		9			10				
#gene	P1.s1	P1.s2	P1.both	P1.total	P1.binomEst	P1.LB	P1.UB	P1.binomP	P1.binomQ	
#11		12		13		14		15		16			17			18		19		20			
#P1.LBw	P1.UBw	H1.s1	H1.s2	H1.both	H1.total	H1.binomEst	H1.LB	H1.UB	H1.binomP	
#21			22		23		24			25		26		27		28	
#H1.binomQ	H1.LBw	H1.UBw	H1_P.fetEst	H1_P.LB	H1_P.UB	H1_P.P	H1_P.Q

###################################################################################################

#use common set of non"imprinted" genes

data1<-merge(dataGENES, data1, by = 'gene')
data1<-data1[1:28]
data1<-data.frame(data1)

#for data 1:

for (i in 1:nrow(data1)) 
	{
	if (data1[i,2] == 0) {data1[i,2] = 1} else {data1[i,2] == data1[i,2]}
	if (data1[i,3] == 0) {data1[i,3] = 1} else {data1[i,3] == data1[i,3]}
	if (data1[i,13] == 0) {data1[i,13] = 1} else {data1[i,13] == data1[i,13]}
	if (data1[i,14] == 0) {data1[i,14] = 1} else {data1[i,14] == data1[i,14]}
	}

psum1 = (data1[,2]+((data1[,2]/(data1[,2]+data1[,3]))*data1[,4]))
psum2 = (data1[,3]+((data1[,3]/(data1[,2]+data1[,3]))*data1[,4]))

#29
data1$logPrat = log2(data1[,2]/data1[,3])
#30
data1$logHrat = log2(data1[,13]/data1[,14])
#31
data1$logPrat_logHrat_rat = data1$logPrat/data1$logHrat
#32
data1$percentcis = (abs(data1$logHrat)/(abs(data1$logHrat)+abs(data1$logPrat-data1$logHrat)))*100
#33
data1$H_P1diff = ((log2(((data1[,16]+data1[,15])/(sum(data1[,16])+sum(data1[,15])))*100)) - (log2(((data1[,2]+((data1[,2]/(data1[,2]+data1[,3]))*data1[,4]))/sum(psum1))*100)))
#34
data1$H_P2diff = ((log2(((data1[,16]+data1[,15])/(sum(data1[,16])+sum(data1[,15])))*100)) - (log2(((data1[,3]+((data1[,3]/(data1[,2]+data1[,3]))*data1[,4]))/sum(psum2))*100)))
#35
data1$Pdiff = c(2:2)
#36
data1$cis = c(2:2)
#37
data1$trans = c(2:2)
#38
data1$allcis = c(2:2)
#39
data1$alltrans = c(2:2)
#40
data1$conserved1 = c(2:2)
#41
data1$compensatory = c(2:2)
#42
data1$ambiguous = c(2:2)
#43
data1$cisplustrans = c(2:2)
#44
data1$cisXtrans = c(2:2)

for (j in 1:nrow(data1)) 
	{
	
	if (data1[j,10] < 0.05)  {data1[j,35] = 1} else {data1[j,35] = 0}
	if (data1[j,21] < 0.05)  {data1[j,36] = 1} else {data1[j,36] = 0}
	if (data1[j,28] < 0.05)  {data1[j,37] = 1} else {data1[j,37] = 0}
	
	if ((data1[j,10] < 0.05) && (data1[j,21] < 0.05) && (data1[j,28] > 0.05)) {data1[j,38] = 1} else {data1[j,38] = 0}
	if ((data1[j,10] < 0.05) && (data1[j,21] > 0.05) && (data1[j,28] < 0.05)) {data1[j,39] = 1} else {data1[j,39] = 0}
	if ((data1[j,10] > 0.05) && (data1[j,21] > 0.05) && (data1[j,28] > 0.05)) {data1[j,40] = 1} else {data1[j,40] = 0}
	if ((data1[j,10] > 0.05) && (data1[j,21] < 0.05) && (data1[j,28] < 0.05)) {data1[j,41] = 1} else {data1[j,41] = 0}
	if (((data1[j,10] > 0.05) && (data1[j,21] > 0.05) && (data1[j,28] < 0.05)) || ((data1[j,10] > 0.05) && (data1[j,21] < 0.05) && (data1[j,28] > 0.05)) || ((data1[j,10] < 0.05) && (data1[j,21] > 0.05) && (data1[j,28] > 0.05))) {data1[j,42] = 1} else {data1[j,42] = 0}
	
	if (((data1[j,10] < 0.05) && (data1[j,21] < 0.05) && (data1[j,28] < 0.05) && (data1[j,29] > 0) && (data1[j,30] > 0) && (data1[j,31] > 1)) || ((data1[j,10] < 0.05) && (data1[j,21] < 0.05) && (data1[j,28] < 0.05) && (data1[j,29] < 0) && (data1[j,30] < 0) && (data1[j,31] > 1))) {data1[j,43] = 1} else {data1[j,43] = 0}
	if (((data1[j,10] < 0.05) && (data1[j,21] < 0.05) && (data1[j,28] < 0.05) && (data1[j,29] > 0) && (data1[j,30] < 0)) || ((data1[j,10] < 0.05) && (data1[j,21] < 0.05) && (data1[j,28] < 0.05) && (data1[j,29] < 0) && (data1[j,30] > 0)) || ((data1[j,10] < 0.05) && (data1[j,21] < 0.05) && (data1[j,28] < 0.05) && (data1[j,29] > 0) && (data1[j,30] > 0) && (data1[j,31] < 1)) || ((data1[j,10] < 0.05) && (data1[j,21] < 0.05) && (data1[j,28] < 0.05) && (data1[j,29] < 0) && (data1[j,30] < 0) && (data1[j,31] < 1))) {data1[j,44] = 1} else {data1[j,44] = 0}
	
	}

write.table(data1, file = "/Final/sim_sec/sim-sec_P+H1/outputs/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta_gene_output_120113_classified.txt",sep="\t",quote=FALSE,row.names=FALSE)

sum(data1[,35])
sum(data1[,36])
sum(data1[,37])
sum(data1[,38])
sum(data1[,39])
sum(data1[,40])
sum(data1[,41])
sum(data1[,42])
sum(data1[,43])
sum(data1[,44])

rm(list=ls())

##################################################################################################
#Load sim-sech data gene

data2<-read.delim("/Final/sim_sec/sim-sec_P+H2/outputs/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113.txt", header=TRUE)

####################################################################################################
####################################################################################################
#corresponding imprinting files to remove

# Read in the data from H1 v H2
data3<-read.delim("/Final/zhr_z30/mel-mel_H1+H2/outputs/zhrXz30_z30Xzhr_mRNA_meta_gene_output_120113.txt", header = TRUE);
data3<-subset(data3,(data3$H1_H2.Q > 0.05))

data4<-read.delim("/Final/mel_sim/mel-sim_H1+H2/outputs/zhrXtsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113.txt", header = TRUE);
data4<-subset(data4,(data4$H1_H2.Q > 0.05))

data5<-read.delim("/Final/sim_sec/sim-sec_H1+H2/outputs/tsimbazazaXdroSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113.txt", header = TRUE);
data5<-subset(data5,(data5$H1_H2.Q > 0.05))

data6<-merge(data3,data4, by = 'gene')
data7<-merge(data6,data5, by = 'gene')

dataGENES<-data7[,1]
dataGENES<-data.frame(dataGENES)
colnames(dataGENES)<-c('gene')

data2<-merge(dataGENES, data2, by = 'gene')
data2<-data2[1:28]
data2<-data.frame(data2)

#for data 2:


for (i in 1:nrow(data2)) 
	{
	if (data2[i,2] == 0) {data2[i,2] = 1} else {data2[i,2] == data2[i,2]}
	if (data2[i,3] == 0) {data2[i,3] = 1} else {data2[i,3] == data2[i,3]}
	if (data2[i,13] == 0) {data2[i,13] = 1} else {data2[i,13] == data2[i,13]}
	if (data2[i,14] == 0) {data2[i,14] = 1} else {data2[i,14] == data2[i,14]}
	}

psum1 = (data2[,2]+((data2[,2]/(data2[,2]+data2[,3]))*data2[,4]))
psum2 = (data2[,3]+((data2[,3]/(data2[,2]+data2[,3]))*data2[,4]))

#29
data2$logPrat = log2(data2[,2]/data2[,3])
#30
data2$logHrat = log2(data2[,13]/data2[,14])
#31
data2$logPrat_logHrat_rat = data2$logPrat/data2$logHrat
#32
data2$percentcis = (abs(data2$logHrat)/(abs(data2$logHrat)+abs(data2$logPrat-data2$logHrat)))*100
#33
data2$H_P1diff = ((log2(((data2[,16]+data2[,15])/(sum(data2[,16])+sum(data2[,15])))*100)) - (log2(((data2[,2]+((data2[,2]/(data2[,2]+data2[,3]))*data2[,4]))/sum(psum1))*100)))
#34
data2$H_P2diff = ((log2(((data2[,16]+data2[,15])/(sum(data2[,16])+sum(data2[,15])))*100)) - (log2(((data2[,3]+((data2[,3]/(data2[,2]+data2[,3]))*data2[,4]))/sum(psum2))*100)))
#35
data2$Pdiff = c(2:2)
#36
data2$cis = c(2:2)
#37
data2$trans = c(2:2)
#38
data2$allcis = c(2:2)
#39
data2$alltrans = c(2:2)
#40
data2$conserved1 = c(2:2)
#41
data2$compensatory = c(2:2)
#42
data2$ambiguous = c(2:2)
#43
data2$cisplustrans = c(2:2)
#44
data2$cisXtrans = c(2:2)

for (j in 1:nrow(data2)) 
	{
	
	if (data2[j,10] < 0.05)  {data2[j,35] = 1} else {data2[j,35] = 0}
	if (data2[j,21] < 0.05)  {data2[j,36] = 1} else {data2[j,36] = 0}
	if (data2[j,28] < 0.05)  {data2[j,37] = 1} else {data2[j,37] = 0}
	
	if ((data2[j,10] < 0.05) && (data2[j,21] < 0.05) && (data2[j,28] > 0.05)) {data2[j,38] = 1} else {data2[j,38] = 0}
	if ((data2[j,10] < 0.05) && (data2[j,21] > 0.05) && (data2[j,28] < 0.05)) {data2[j,39] = 1} else {data2[j,39] = 0}
	if ((data2[j,10] > 0.05) && (data2[j,21] > 0.05) && (data2[j,28] > 0.05)) {data2[j,40] = 1} else {data2[j,40] = 0}
	if ((data2[j,10] > 0.05) && (data2[j,21] < 0.05) && (data2[j,28] < 0.05)) {data2[j,41] = 1} else {data2[j,41] = 0}
	if (((data2[j,10] > 0.05) && (data2[j,21] > 0.05) && (data2[j,28] < 0.05)) || ((data2[j,10] > 0.05) && (data2[j,21] < 0.05) && (data2[j,28] > 0.05)) || ((data2[j,10] < 0.05) && (data2[j,21] > 0.05) && (data2[j,28] > 0.05))) {data2[j,42] = 1} else {data2[j,42] = 0}
	
	if (((data2[j,10] < 0.05) && (data2[j,21] < 0.05) && (data2[j,28] < 0.05) && (data2[j,29] > 0) && (data2[j,30] > 0) && (data2[j,31] > 1)) || ((data2[j,10] < 0.05) && (data2[j,21] < 0.05) && (data2[j,28] < 0.05) && (data2[j,29] < 0) && (data2[j,30] < 0) && (data2[j,31] > 1))) {data2[j,43] = 1} else {data2[j,43] = 0}
	if (((data2[j,10] < 0.05) && (data2[j,21] < 0.05) && (data2[j,28] < 0.05) && (data2[j,29] > 0) && (data2[j,30] < 0)) || ((data2[j,10] < 0.05) && (data2[j,21] < 0.05) && (data2[j,28] < 0.05) && (data2[j,29] < 0) && (data2[j,30] > 0)) || ((data2[j,10] < 0.05) && (data2[j,21] < 0.05) && (data2[j,28] < 0.05) && (data2[j,29] > 0) && (data2[j,30] > 0) && (data2[j,31] < 1)) || ((data2[j,10] < 0.05) && (data2[j,21] < 0.05) && (data2[j,28] < 0.05) && (data2[j,29] < 0) && (data2[j,30] < 0) && (data2[j,31] < 1))) {data2[j,44] = 1} else {data2[j,44] = 0}
	
	}

write.table(data2, file = "/Final/sim_sec/sim-sec_P+H2/outputs/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113_classified.txt",sep="\t",quote=FALSE,row.names=FALSE)	
	
sum(data2[,35])
sum(data2[,36])
sum(data2[,37])
sum(data2[,38])
sum(data2[,39])
sum(data2[,40])
sum(data2[,41])
sum(data2[,42])
sum(data2[,43])
sum(data2[,44])

rm(list=ls())

####################################################################################################
####################################################################################################
#load mel-sim data genes

data1<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta_gene_output_120113.txt", header=TRUE)

####################################################################################################
####################################################################################################
#corresponding imprinting files to remove

# Read in the data from H1 v H2
data3<-read.delim("/Final/zhr_z30/mel-mel_H1+H2/outputs/zhrXz30_z30Xzhr_mRNA_meta_gene_output_120113.txt", header = TRUE);
data3<-subset(data3,(data3$H1_H2.Q > 0.05))

data4<-read.delim("/Final/mel_sim/mel-sim_H1+H2/outputs/zhrXtsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113.txt", header = TRUE);
data4<-subset(data4,(data4$H1_H2.Q > 0.05))

data5<-read.delim("/Final/sim_sec/sim-sec_H1+H2/outputs/tsimbazazaXdroSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113.txt", header = TRUE);
data5<-subset(data5,(data5$H1_H2.Q > 0.05))

data6<-merge(data3,data4, by = 'gene')
data7<-merge(data6,data5, by = 'gene')

dataGENES<-data7[,1]
dataGENES<-data.frame(dataGENES)
colnames(dataGENES)<-c('gene')

###################################################################################################

#Column contents:

#1		2		3		4		5			6			7		8		9			10				
#gene	P1.s1	P1.s2	P1.both	P1.total	P1.binomEst	P1.LB	P1.UB	P1.binomP	P1.binomQ	
#11		12		13		14		15		16			17			18		19		20			
#P1.LBw	P1.UBw	H1.s1	H1.s2	H1.both	H1.total	H1.binomEst	H1.LB	H1.UB	H1.binomP	
#21			22		23		24			25		26		27		28	
#H1.binomQ	H1.LBw	H1.UBw	H1_P.fetEst	H1_P.LB	H1_P.UB	H1_P.P	H1_P.Q

###################################################################################################

#use common set of non"imprinted" genes

data1<-merge(dataGENES, data1, by = 'gene')
data1<-data1[1:28]
data1<-data.frame(data1)

#for data 1:

for (i in 1:nrow(data1)) 
	{
	if (data1[i,2] == 0) {data1[i,2] = 1} else {data1[i,2] == data1[i,2]}
	if (data1[i,3] == 0) {data1[i,3] = 1} else {data1[i,3] == data1[i,3]}
	if (data1[i,13] == 0) {data1[i,13] = 1} else {data1[i,13] == data1[i,13]}
	if (data1[i,14] == 0) {data1[i,14] = 1} else {data1[i,14] == data1[i,14]}
	}

psum1 = (data1[,2]+((data1[,2]/(data1[,2]+data1[,3]))*data1[,4]))
psum2 = (data1[,3]+((data1[,3]/(data1[,2]+data1[,3]))*data1[,4]))

#29
data1$logPrat = log2(data1[,2]/data1[,3])
#30
data1$logHrat = log2(data1[,13]/data1[,14])
#31
data1$logPrat_logHrat_rat = data1$logPrat/data1$logHrat
#32
data1$percentcis = (abs(data1$logHrat)/(abs(data1$logHrat)+abs(data1$logPrat-data1$logHrat)))*100
#33
data1$H_P1diff = ((log2(((data1[,16]+data1[,15])/(sum(data1[,16])+sum(data1[,15])))*100)) - (log2(((data1[,2]+((data1[,2]/(data1[,2]+data1[,3]))*data1[,4]))/sum(psum1))*100)))
#34
data1$H_P2diff = ((log2(((data1[,16]+data1[,15])/(sum(data1[,16])+sum(data1[,15])))*100)) - (log2(((data1[,3]+((data1[,3]/(data1[,2]+data1[,3]))*data1[,4]))/sum(psum2))*100)))
#35
data1$Pdiff = c(2:2)
#36
data1$cis = c(2:2)
#37
data1$trans = c(2:2)
#38
data1$allcis = c(2:2)
#39
data1$alltrans = c(2:2)
#40
data1$conserved1 = c(2:2)
#41
data1$compensatory = c(2:2)
#42
data1$ambiguous = c(2:2)
#43
data1$cisplustrans = c(2:2)
#44
data1$cisXtrans = c(2:2)

for (j in 1:nrow(data1)) 
	{
	
	if (data1[j,10] < 0.05)  {data1[j,35] = 1} else {data1[j,35] = 0}
	if (data1[j,21] < 0.05)  {data1[j,36] = 1} else {data1[j,36] = 0}
	if (data1[j,28] < 0.05)  {data1[j,37] = 1} else {data1[j,37] = 0}
	
	if ((data1[j,10] < 0.05) && (data1[j,21] < 0.05) && (data1[j,28] > 0.05)) {data1[j,38] = 1} else {data1[j,38] = 0}
	if ((data1[j,10] < 0.05) && (data1[j,21] > 0.05) && (data1[j,28] < 0.05)) {data1[j,39] = 1} else {data1[j,39] = 0}
	if ((data1[j,10] > 0.05) && (data1[j,21] > 0.05) && (data1[j,28] > 0.05)) {data1[j,40] = 1} else {data1[j,40] = 0}
	if ((data1[j,10] > 0.05) && (data1[j,21] < 0.05) && (data1[j,28] < 0.05)) {data1[j,41] = 1} else {data1[j,41] = 0}
	if (((data1[j,10] > 0.05) && (data1[j,21] > 0.05) && (data1[j,28] < 0.05)) || ((data1[j,10] > 0.05) && (data1[j,21] < 0.05) && (data1[j,28] > 0.05)) || ((data1[j,10] < 0.05) && (data1[j,21] > 0.05) && (data1[j,28] > 0.05))) {data1[j,42] = 1} else {data1[j,42] = 0}
	
	if (((data1[j,10] < 0.05) && (data1[j,21] < 0.05) && (data1[j,28] < 0.05) && (data1[j,29] > 0) && (data1[j,30] > 0) && (data1[j,31] > 1)) || ((data1[j,10] < 0.05) && (data1[j,21] < 0.05) && (data1[j,28] < 0.05) && (data1[j,29] < 0) && (data1[j,30] < 0) && (data1[j,31] > 1))) {data1[j,43] = 1} else {data1[j,43] = 0}
	if (((data1[j,10] < 0.05) && (data1[j,21] < 0.05) && (data1[j,28] < 0.05) && (data1[j,29] > 0) && (data1[j,30] < 0)) || ((data1[j,10] < 0.05) && (data1[j,21] < 0.05) && (data1[j,28] < 0.05) && (data1[j,29] < 0) && (data1[j,30] > 0)) || ((data1[j,10] < 0.05) && (data1[j,21] < 0.05) && (data1[j,28] < 0.05) && (data1[j,29] > 0) && (data1[j,30] > 0) && (data1[j,31] < 1)) || ((data1[j,10] < 0.05) && (data1[j,21] < 0.05) && (data1[j,28] < 0.05) && (data1[j,29] < 0) && (data1[j,30] < 0) && (data1[j,31] < 1))) {data1[j,44] = 1} else {data1[j,44] = 0}
	
	}

write.table(data1, file = "/Final/mel_sim/mel-sim_P+H1/outputs/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta_gene_output_120113_classified.txt",sep="\t",quote=FALSE,row.names=FALSE)

sum(data1[,35])
sum(data1[,36])
sum(data1[,37])
sum(data1[,38])
sum(data1[,39])
sum(data1[,40])
sum(data1[,41])
sum(data1[,42])
sum(data1[,43])
sum(data1[,44])

rm(list=ls())

##################################################################################################
#load mel-sim data genes

data2<-read.delim("/Final/mel_sim/mel-sim_P+H2/outputs/zhr+tsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113.txt", header=TRUE)

####################################################################################################
####################################################################################################
#corresponding imprinting files to remove

# Read in the data from H1 v H2
data3<-read.delim("/Final/zhr_z30/mel-mel_H1+H2/outputs/zhrXz30_z30Xzhr_mRNA_meta_gene_output_120113.txt", header = TRUE);
data3<-subset(data3,(data3$H1_H2.Q > 0.05))

data4<-read.delim("/Final/mel_sim/mel-sim_H1+H2/outputs/zhrXtsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113.txt", header = TRUE);
data4<-subset(data4,(data4$H1_H2.Q > 0.05))

data5<-read.delim("/Final/sim_sec/sim-sec_H1+H2/outputs/tsimbazazaXdroSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113.txt", header = TRUE);
data5<-subset(data5,(data5$H1_H2.Q > 0.05))

data6<-merge(data3,data4, by = 'gene')
data7<-merge(data6,data5, by = 'gene')

dataGENES<-data7[,1]
dataGENES<-data.frame(dataGENES)
colnames(dataGENES)<-c('gene')

write.table(dataGENES, file = "/Final/ASE-genes.txt",sep="\t",quote=FALSE,row.names=FALSE)

data2<-merge(dataGENES, data2, by = 'gene')
data2<-data2[1:28]
data2<-data.frame(data2)

#for data 2:


for (i in 1:nrow(data2)) 
	{
	if (data2[i,2] == 0) {data2[i,2] = 1} else {data2[i,2] == data2[i,2]}
	if (data2[i,3] == 0) {data2[i,3] = 1} else {data2[i,3] == data2[i,3]}
	if (data2[i,13] == 0) {data2[i,13] = 1} else {data2[i,13] == data2[i,13]}
	if (data2[i,14] == 0) {data2[i,14] = 1} else {data2[i,14] == data2[i,14]}
	}

psum1 = (data2[,2]+((data2[,2]/(data2[,2]+data2[,3]))*data2[,4]))
psum2 = (data2[,3]+((data2[,3]/(data2[,2]+data2[,3]))*data2[,4]))

#29
data2$logPrat = log2(data2[,2]/data2[,3])
#30
data2$logHrat = log2(data2[,13]/data2[,14])
#31
data2$logPrat_logHrat_rat = data2$logPrat/data2$logHrat
#32
data2$percentcis = (abs(data2$logHrat)/(abs(data2$logHrat)+abs(data2$logPrat-data2$logHrat)))*100
#33
data2$H_P1diff = ((log2(((data2[,16]+data2[,15])/(sum(data2[,16])+sum(data2[,15])))*100)) - (log2(((data2[,2]+((data2[,2]/(data2[,2]+data2[,3]))*data2[,4]))/sum(psum1))*100)))
#34
data2$H_P2diff = ((log2(((data2[,16]+data2[,15])/(sum(data2[,16])+sum(data2[,15])))*100)) - (log2(((data2[,3]+((data2[,3]/(data2[,2]+data2[,3]))*data2[,4]))/sum(psum2))*100)))
#35
data2$Pdiff = c(2:2)
#36
data2$cis = c(2:2)
#37
data2$trans = c(2:2)
#38
data2$allcis = c(2:2)
#39
data2$alltrans = c(2:2)
#40
data2$conserved1 = c(2:2)
#41
data2$compensatory = c(2:2)
#42
data2$ambiguous = c(2:2)
#43
data2$cisplustrans = c(2:2)
#44
data2$cisXtrans = c(2:2)

for (j in 1:nrow(data2)) 
	{
	
	if (data2[j,10] < 0.05)  {data2[j,35] = 1} else {data2[j,35] = 0}
	if (data2[j,21] < 0.05)  {data2[j,36] = 1} else {data2[j,36] = 0}
	if (data2[j,28] < 0.05)  {data2[j,37] = 1} else {data2[j,37] = 0}
	
	if ((data2[j,10] < 0.05) && (data2[j,21] < 0.05) && (data2[j,28] > 0.05)) {data2[j,38] = 1} else {data2[j,38] = 0}
	if ((data2[j,10] < 0.05) && (data2[j,21] > 0.05) && (data2[j,28] < 0.05)) {data2[j,39] = 1} else {data2[j,39] = 0}
	if ((data2[j,10] > 0.05) && (data2[j,21] > 0.05) && (data2[j,28] > 0.05)) {data2[j,40] = 1} else {data2[j,40] = 0}
	if ((data2[j,10] > 0.05) && (data2[j,21] < 0.05) && (data2[j,28] < 0.05)) {data2[j,41] = 1} else {data2[j,41] = 0}
	if (((data2[j,10] > 0.05) && (data2[j,21] > 0.05) && (data2[j,28] < 0.05)) || ((data2[j,10] > 0.05) && (data2[j,21] < 0.05) && (data2[j,28] > 0.05)) || ((data2[j,10] < 0.05) && (data2[j,21] > 0.05) && (data2[j,28] > 0.05))) {data2[j,42] = 1} else {data2[j,42] = 0}
	
	if (((data2[j,10] < 0.05) && (data2[j,21] < 0.05) && (data2[j,28] < 0.05) && (data2[j,29] > 0) && (data2[j,30] > 0) && (data2[j,31] > 1)) || ((data2[j,10] < 0.05) && (data2[j,21] < 0.05) && (data2[j,28] < 0.05) && (data2[j,29] < 0) && (data2[j,30] < 0) && (data2[j,31] > 1))) {data2[j,43] = 1} else {data2[j,43] = 0}
	if (((data2[j,10] < 0.05) && (data2[j,21] < 0.05) && (data2[j,28] < 0.05) && (data2[j,29] > 0) && (data2[j,30] < 0)) || ((data2[j,10] < 0.05) && (data2[j,21] < 0.05) && (data2[j,28] < 0.05) && (data2[j,29] < 0) && (data2[j,30] > 0)) || ((data2[j,10] < 0.05) && (data2[j,21] < 0.05) && (data2[j,28] < 0.05) && (data2[j,29] > 0) && (data2[j,30] > 0) && (data2[j,31] < 1)) || ((data2[j,10] < 0.05) && (data2[j,21] < 0.05) && (data2[j,28] < 0.05) && (data2[j,29] < 0) && (data2[j,30] < 0) && (data2[j,31] < 1))) {data2[j,44] = 1} else {data2[j,44] = 0}
	
	}

write.table(data2, file = "/Final/mel_sim/mel-sim_P+H2/outputs/zhr+tsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113_classified.txt",sep="\t",quote=FALSE,row.names=FALSE)
	
sum(data2[,35])
sum(data2[,36])
sum(data2[,37])
sum(data2[,38])
sum(data2[,39])
sum(data2[,40])
sum(data2[,41])
sum(data2[,42])
sum(data2[,43])
sum(data2[,44])

rm(list=ls())


####################################################################################################
####################################################################################################
#CORRECT META DOMINANCE
####################################################################################################
####################################################################################################

#mel-mel
data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/zhr+z30_zhrXz30_mRNA_meta_gene_output_120113_classified.txt", header=TRUE)

data1B<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/total_dominance_MMH1_classified_B.txt",header = TRUE)

data1C<-read.delim("/Final/zhr_z30/mel-mel_P+H2/outputs/zhr+z30_z30Xzhr_mRNA_meta_gene_output_120113_classified.txt", header=TRUE)

data1D<-read.delim("/Final/zhr_z30/mel-mel_P+H2/outputs/total_dominance_MMH2_classified_B.txt",header = TRUE)


#sim-sec
data2<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta_gene_output_120113_classified.txt", header=TRUE)

data2B<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/total_dominance_SSH1_classified_B.txt",header = TRUE)

data2C<-read.delim("/Final/sim_sec/sim-sec_P+H2/outputs/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113_classified.txt", header=TRUE)

data2D<-read.delim("/Final/sim_sec/sim-sec_P+H2/outputs/total_dominance_SSH2_classified_B.txt",header = TRUE)


#mel-sim
data3<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta_gene_output_120113_classified.txt", header=TRUE)

data3B<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/total_dominance_MSH1_classified_B.txt",header = TRUE)

data3C<-read.delim("/Final/mel_sim/mel-sim_P+H2/outputs/zhr+tsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113_classified.txt", header=TRUE)

data3D<-read.delim("/Final/mel_sim/mel-sim_P+H2/outputs/total_dominance_MSH2_classified_B.txt",header = TRUE)

tot<-read.delim("/Final/total-genes.txt", header = TRUE)

ase<-read.delim("/Final/ASE-genes.txt", header = TRUE)

genes<-merge(tot,ase,by='gene')

write.table(genes, file = "/Final/ASE-genes.txt",sep="\t",quote=FALSE,row.names=FALSE)

####################################################################################################
####################################################################################################
#columns in total dominance classifications

#B and D

#5=data1$H_P1diff = ((log2(((data1[,4])/(sum(data1[,4])))*100)) - (log2(((data1[,2])/sum(data1[,2]))*100)))
#6=data1$H_P2diff = ((log2(((data1[,4])/(sum(data1[,4])))*100)) - (log2(((data1[,3])/sum(data1[,3]))*100)))
#7=data1$additive 
#8=data1$underdominant
#9=data1$overdominant
#10=data1$par1dominant
#11=data1$par2dominant
#12=data1$conserved2

#columns in cis-trans classified

#A and C

#29=data1$logPrat = log2(data1[,2]/data1[,3])
#30=data1$logHrat = log2(data1[,13]/data1[,14])
#31=data1$logPrat_logHrat_rat = data1$logPrat/data1$logHrat
#32=data1$percentcis = (abs(data1$logHrat)/(abs(data1$logHrat)+abs(data1$logPrat-data1$logHrat)))*100
#NEED TO FIX THIS #33=data1$H_P1diff = log2((data1[,16]/(sum(data1[,16])))*100)-log2((data1[,2]/(sum(data1[,2])))*100)
#NEED TO FIX THIS #34=data1$H_P2diff = log2((data1[,16]/(sum(data1[,16])))*100)-log2((data1[,3]/(sum(data1[,3])))*100)
#35=data1$Pdiff 
#36=data1$cis 
#37=data1$trans 
#38=data1$allcis 
#39=data1$alltrans 
#40=data1$conserved1 
#41=data1$compensatory 
#42=data1$ambiguous 
#43=data1$cisplustrans 
#44=data1$cisXtrans 


#add these columns
#45=data1$additive 
#46=data1$underdominant 
#47=data1$overdominant 
#48=data1$par2dominant 
#49=data1$par1dominant 
#50=data1$conserved2 

####################################################################################################
####################################################################################################

#E AND F (POST MERGE)

#29=data1$logPrat = log2(data1[,2]/data1[,3])
#30=data1$logHrat = log2(data1[,13]/data1[,14])
#31=data1$logPrat_logHrat_rat = data1$logPrat/data1$logHrat
#32=data1$percentcis = (abs(data1$logHrat)/(abs(data1$logHrat)+abs(data1$logPrat-data1$logHrat)))*100
#NEED TO FIX THIS #33=data1$H_P1diff = log2((data1[,16]/(sum(data1[,16])))*100)-log2((data1[,2]/(sum(data1[,2])))*100)
#NEED TO FIX THIS #34=data1$H_P2diff = log2((data1[,16]/(sum(data1[,16])))*100)-log2((data1[,3]/(sum(data1[,3])))*100)
#35=data1$Pdiff 
#36=data1$cis 
#37=data1$trans 
#38=data1$allcis 
#39=data1$alltrans 
#40=data1$conserved1 
#41=data1$compensatory 
#42=data1$ambiguous 
#43=data1$cisplustrans 
#44=data1$cisXtrans 
#45=2
#46=3
#47=4
#48=#5=data1$H_P1diff = ((log2(((data1[,4])/(sum(data1[,4])))*100)) - (log2(((data1[,2])/sum(data1[,2]))*100)))
#49=#6=data1$H_P2diff = ((log2(((data1[,4])/(sum(data1[,4])))*100)) - (log2(((data1[,3])/sum(data1[,3]))*100)))
#50=#7=data1$additive 
#51=#8=data1$underdominant
#52=#9=data1$overdominant
#53=#10=data1$par1dominant
#54=#11=data1$par2dominant
#55=#12=data1$conserved2

####################################################################################################
####################################################################################################

data1E<-merge(data1,data1B, by = 'gene')
data1F<-merge(data1C,data1D, by = 'gene')

data1G<-c(data1E[1:32],data1E[,48:49],data1E[,35:44],data1E[,50:55])
data1G<-data.frame(data1G)

data1G2<-c(data1F[1:32],data1F[48:49],data1F[35:44],data1F[50:55])
data1G2<-data.frame(data1G2)


data2E<-merge(data2,data2B, by = 'gene')
data2F<-merge(data2C,data2D, by = 'gene')

data2G<-c(data2E[1:32],data2E[,48:49],data2E[,35:44],data2E[,50:55])
data2G<-data.frame(data2G)

data2G2<-c(data2F[1:32],data2F[48:49],data2F[35:44],data2F[50:55])
data2G2<-data.frame(data2G2)


data3E<-merge(data3,data3B, by = 'gene')
data3F<-merge(data3C,data3D, by = 'gene')

data3G<-c(data3E[1:32],data3E[,48:49],data3E[,35:44],data3E[,50:55])
data3G<-data.frame(data3G)

data3G2<-c(data3F[1:32],data3F[48:49],data3F[35:44],data3F[50:55])
data3G2<-data.frame(data3G2)

####################################################################################################
####################################################################################################

#write out meta corrected files
write.table(data1G, file = "/Final/zhr_z30/mel-mel_P+H1/outputs/zhr+z30_zhrXz30_mRNA_meta_gene_output_120113_classified_B.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(data2G, file = "/Final/sim_sec/sim-sec_P+H1/outputs/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta_gene_output_120113_classified_B.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(data3G, file = "/Final/mel_sim/mel-sim_P+H1/outputs/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt",sep="\t",quote=FALSE,row.names=FALSE)

write.table(data1G2, file = "/Final/zhr_z30/mel-mel_P+H2/outputs/zhr+z30_z30Xzhr_mRNA_meta_gene_output_120113_classified_B.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(data2G2, file = "/Final/sim_sec/sim-sec_P+H2/outputs/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(data3G2, file = "/Final/mel_sim/mel-sim_P+H2/outputs/zhr+tsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113_classified_B.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################
#META PERCENT CIS MAGNITUDE BOXPLOTS

#mel-mel
data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/zhr+z30_zhrXz30_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)
data2<-read.delim("/Final/zhr_z30/mel-mel_P+H2/outputs/zhr+z30_z30Xzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

one<-subset(data1, abs(data1[,29]) <= 1)
two<-subset(data1, abs(data1[,29]) > 1 & abs(data1[,29]) <= 2)
three<-subset(data1, abs(data1[,29]) > 2 & abs(data1[,29]) <= 3)
four<-subset(data1, abs(data1[,29]) > 3 & abs(data1[,29]) <= 4)
five<-subset(data1, abs(data1[,29]) > 4)

one2<-subset(data2, abs(data2[,29]) <= 1)
two2<-subset(data2, abs(data2[,29]) > 1 & abs(data2[,29]) <= 2)
three2<-subset(data2, abs(data2[,29]) > 2 & abs(data2[,29]) <= 3)
four2<-subset(data2, abs(data2[,29]) > 3 & abs(data2[,29]) <= 4)
five2<-subset(data2, abs(data2[,29]) > 4)

nrow(data1)
nrow(one)+nrow(two)+nrow(three)+nrow(four)+nrow(five)

nrow(data2)
nrow(one2)+nrow(two2)+nrow(three2)+nrow(four2)+nrow(five2)

pdf(file = "/Final/zhr_z30/mel-mel_P+H1/outputs/mel-mel-meta_percentcis_mag_P-H1_SD_gene_120113.pdf")
boxplot(one[,32],two[,32],three[,32],four[,32],five[,32], ylab='% cis',xlab = 'zhrxz30 (abs(log2(zhr/z30)))', xaxt="n", notch = TRUE, varwidth=TRUE,ylim=c(0,100))
axis(1, at=1:5,lab=c("0-1","1-2","2-3","3-4",">"))
dev.off()

pdf(file = "/Final/zhr_z30/mel-mel_P+H2/outputs/mel-mel-meta_percentcis_mag_P-H2_SD_gene_120113.pdf")
boxplot(one2[,32],two2[,32],three2[,32],four2[,32],five2[,32], ylab='% cis', xlab = 'z30Xzhr (abs(log2(zhr/z30)))', xaxt="n", notch = TRUE, varwidth=TRUE,ylim=c(0,100))
axis(1, at=1:5,lab=c("0-1","1-2","2-3","3-4",">"))
dev.off()

######################mel-sim######################################################################
#mel-sim
data3<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)
data4<-read.delim("/Final/mel_sim/mel-sim_P+H2/outputs/zhr+tsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

one3<-subset(data3, abs(data3[,29]) <= 1)
two3<-subset(data3, abs(data3[,29]) > 1 & abs(data3[,29]) <= 2)
three3<-subset(data3, abs(data3[,29]) > 2 & abs(data3[,29]) <= 3)
four3<-subset(data3, abs(data3[,29]) > 3 & abs(data3[,29]) <= 4)
five3<-subset(data3, abs(data3[,29]) > 4)

one4<-subset(data4, abs(data4[,29]) <= 1)
two4<-subset(data4, abs(data4[,29]) > 1 & abs(data4[,29]) <= 2)
three4<-subset(data4, abs(data4[,29]) > 2 & abs(data4[,29]) <= 3)
four4<-subset(data4, abs(data4[,29]) > 3 & abs(data4[,29]) <= 4)
five4<-subset(data4, abs(data4[,29]) > 4)

nrow(data3)
nrow(one3)+nrow(two3)+nrow(three3)+nrow(four3)+nrow(five3)

nrow(data4)
nrow(one4)+nrow(two4)+nrow(three4)+nrow(four4)+nrow(five4)

pdf(file = "/Final/mel_sim/mel-sim_P+H1/outputs/mel-sim-meta_percentcis_mag_P-H1_SD_gene_120113.pdf")
boxplot(one3[,32],two3[,32],three3[,32],four3[,32],five3[,32], ylab='% cis',xlab='melXsim (abs(log2(mel/sim)))', xaxt="n", notch = TRUE, varwidth=TRUE,ylim=c(0,100))
axis(1, at=1:5,lab=c("0-1","1-2","2-3","3-4",">"))
dev.off()

pdf(file = "/Final/mel_sim/mel-sim_P+H2/outputs/mel-sim-meta_percentcis_mag_P-H2_SD_gene_120113.pdf")
boxplot(one4[,32],two4[,32],three4[,32],four4[,32],five4[,32], ylab='% cis',xlab='simXmel (abs(log2(mel/sim)))', xaxt="n", notch = TRUE, varwidth=TRUE,ylim=c(0,100))
axis(1, at=1:5,lab=c("0-1","1-2","2-3","3-4",">"))
dev.off()

######################sim-sec######################################################################
#sim-sec
data6<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)
data7<-read.delim("/Final/sim_sec/sim-sec_P+H2/outputs/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

one6<-subset(data6, abs(data6[,29]) <= 1)
two6<-subset(data6, abs(data6[,29]) > 1 & abs(data6[,29]) <= 2)
three6<-subset(data6, abs(data6[,29]) > 2 & abs(data6[,29]) <= 3)
four6<-subset(data6, abs(data6[,29]) > 3 & abs(data6[,29]) <= 4)
five6<-subset(data6, abs(data6[,29]) > 4)

one7<-subset(data7, abs(data7[,29]) <= 1)
two7<-subset(data7, abs(data7[,29]) > 1 & abs(data7[,29]) <= 2)
three7<-subset(data7, abs(data7[,29]) > 2 & abs(data7[,29]) <= 3)
four7<-subset(data7, abs(data7[,29]) > 3 & abs(data7[,29]) <= 4)
five7<-subset(data7, abs(data7[,29]) > 4)

nrow(data6)
nrow(one6)+nrow(two6)+nrow(three6)+nrow(four6)+nrow(five6)

nrow(data7)
nrow(one7)+nrow(two7)+nrow(three7)+nrow(four7)+nrow(five7)

pdf(file = "/Final/sim_sec/sim-sec_P+H1/outputs/sim-sec-meta_percentcis_mag_P-H1_SD_gene_120113.pdf")
boxplot(one6[,32],two6[,32],three6[,32],four6[,32],five6[,32], ylab='% cis',xlab='simXsec (abs(log2(sim/sec)))', xaxt="n", notch = TRUE, varwidth=TRUE,ylim=c(0,100))
axis(1, at=1:5,lab=c("0-1","1-2","2-3","3-4",">"))
dev.off()

pdf(file = "/Final/sim_sec/sim-sec_P+H2/outputs/sim-sec-meta_percentcis_mag_P-H2_SD_gene_120113.pdf")
boxplot(one7[,32],two7[,32],three7[,32],four7[,32],five7[,32], ylab='% cis',xlab='secXsim (abs(log2(sim/sec)))', xaxt="n", notch = TRUE, varwidth=TRUE,ylim=c(0,100))
axis(1, at=1:5,lab=c("0-1","1-2","2-3","3-4",">"))
dev.off()

rm(list=ls())

####################################################################################################
####################################################################################################
#boxplots of %cis

# percent cis

#   |H|/|H| + |P-H|
#   (|log2(A1/A2)|/|log2(A1/A2)|+|log2(P1/P2)-log2(A1/A2)|)*100

####################################################################################################
####################################################################################################
#load data

#meta

#mel-mel
data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/zhr+z30_zhrXz30_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)
data2<-read.delim("/Final/zhr_z30/mel-mel_P+H2/outputs/zhr+z30_z30Xzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

#mel-sim
data3<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)
data4<-read.delim("/Final/mel_sim/mel-sim_P+H2/outputs/zhr+tsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

#mel-sec
#data5<-read.delim("/mel_sec/mel-sec_P+H1/outputs/", header=TRUE)

#sim-sec
data6<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)
data7<-read.delim("/Final/sim_sec/sim-sec_P+H2/outputs/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

####################################################################################################
####################################################################################################


#make boxplot all 6
pdf(file = "/Final/Meta/percentcis_meta6_gene_120113.pdf")
boxplot(data1[,32],data2[,32],data6[,32],data7[,32],data3[,32],data4[,32], ylab='% cis', xaxt="n", notch = TRUE, varwidth=TRUE)
axis(1, at=1:6,lab=c("zhrXz30", "z30Xzhr","simXsec","secXsim","melXsim","simXmel"))
dev.off()

summary(data1[,32])
summary(data2[,32])
summary(data6[,32])
summary(data7[,32])
summary(data3[,32])
summary(data4[,32])

#make boxplot 3

pdf(file = "/Final/Meta/percentcis_meta3H1_gene_120113.pdf")
boxplot(data1[,32],data6[,32],data3[,32], ylab='% cis', xaxt="n", notch = TRUE, varwidth=TRUE)
axis(1, at=1:3,lab=c("zhrXz30","simXsec","melXsim"))
dev.off()

pdf(file = "/Final/Meta/percentcis_meta3H2_gene_120113.pdf")
boxplot(data2[,32],data7[,32],data4[,32], ylab='% cis', xaxt="n", notch = TRUE, varwidth=TRUE)
axis(1, at=1:3,lab=c("z30Xzhr","secXsim","simXmel"))
dev.off()

#############################################percent cis ttest####################################

t.test(data1[,32],data2[,32],alternative = c("t"),var.equal=FALSE, conf.level=0.95)
t.test(data1[,32],data3[,32],alternative = c("t"),var.equal=FALSE, conf.level=0.95)
t.test(data1[,32],data4[,32],alternative = c("t"),var.equal=FALSE, conf.level=0.95)
t.test(data1[,32],data6[,32],alternative = c("t"),var.equal=FALSE, conf.level=0.95)
t.test(data1[,32],data7[,32],alternative = c("t"),var.equal=FALSE, conf.level=0.95)

t.test(data2[,32],data3[,32],alternative = c("t"),var.equal=FALSE, conf.level=0.95)
t.test(data2[,32],data4[,32],alternative = c("t"),var.equal=FALSE, conf.level=0.95)
t.test(data2[,32],data6[,32],alternative = c("t"),var.equal=FALSE, conf.level=0.95)
t.test(data2[,32],data7[,32],alternative = c("t"),var.equal=FALSE, conf.level=0.95)

t.test(data3[,32],data4[,32],alternative = c("t"),var.equal=FALSE, conf.level=0.95)
t.test(data3[,32],data6[,32],alternative = c("t"),var.equal=FALSE, conf.level=0.95)
t.test(data3[,32],data7[,32],alternative = c("t"),var.equal=FALSE, conf.level=0.95)

t.test(data4[,32],data6[,32],alternative = c("t"),var.equal=FALSE, conf.level=0.95)
t.test(data4[,32],data7[,32],alternative = c("t"),var.equal=FALSE, conf.level=0.95)

t.test(data6[,32],data7[,32],alternative = c("t"),var.equal=FALSE, conf.level=0.95)

rm(list=ls())

####################################################################################################
####################################################################################################
#replot cis-trans

#mel-mel H1 all
data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/zhr+z30_zhrXz30_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,30]~data1[,29])
summary(fit1)

allcis<-subset(data1, data1[,38]==1)
alltrans<-subset(data1, data1[,39]==1)
conserved1<-subset(data1, data1[,40]==1)
compensatory<-subset(data1, data1[,41]==1)
ambiguous<-subset(data1, data1[,42]==1)
cisplustrans<-subset(data1, data1[,43]==1)
cisXtrans<-subset(data1, data1[,44]==1)

pdf(file = "/Final/Figs/MM_meta_CT_120113.pdf")

plot(data1[,29], data1[,30], type = "n", ylim = c(-6,6),xlim = c(-6,6),xlab="Parental", ylab="Hybrid")

#Ambiguous
points(ambiguous[,29],ambiguous[,30], col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#cis + trans
points(cisplustrans[,29], cisplustrans[,30],col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#cis X trans
points(cisXtrans[,29], cisXtrans[,30],col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#All cis
points(allcis[,29], allcis[,30],col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#All trans
points(alltrans[,29],alltrans[,30], col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#Compensatory
points(compensatory[,29], compensatory[,30],col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#Conserved
points(conserved1[,29], conserved1[,30],col=rgb(t(col2rgb("yellow")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

abline(h=0)
abline(v=0)

dev.off()

rm(list=ls())

###################################################################################################
###################################################################################################
#mel-mel H2 all

data1<-read.delim("/Final/zhr_z30/mel-mel_P+H2/outputs/zhr+z30_z30Xzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,30]~data1[,29])
summary(fit1)

allcis<-subset(data1, data1[,38]==1)
alltrans<-subset(data1, data1[,39]==1)
conserved1<-subset(data1, data1[,40]==1)
compensatory<-subset(data1, data1[,41]==1)
ambiguous<-subset(data1, data1[,42]==1)
cisplustrans<-subset(data1, data1[,43]==1)
cisXtrans<-subset(data1, data1[,44]==1)

pdf(file = "/Final/Figs/MM_meta_CT2_120113.pdf")

plot(data1[,29], data1[,30], type = "n", ylim = c(-6,6),xlim = c(-6,6),xlab="Parental", ylab="Hybrid")

#Ambiguous
points(ambiguous[,29],ambiguous[,30], col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#cis + trans
points(cisplustrans[,29], cisplustrans[,30],col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#cis X trans
points(cisXtrans[,29], cisXtrans[,30],col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#All cis
points(allcis[,29], allcis[,30],col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#All trans
points(alltrans[,29],alltrans[,30], col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#Compensatory
points(compensatory[,29], compensatory[,30],col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#Conserved
points(conserved1[,29], conserved1[,30],col=rgb(t(col2rgb("yellow")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

abline(h=0)
abline(v=0)

dev.off()

rm(list=ls())

###################################################################################################
###################################################################################################
#sim-sec H1 all

data1<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,30]~data1[,29])
summary(fit1)

allcis<-subset(data1, data1[,38]==1)
alltrans<-subset(data1, data1[,39]==1)
conserved1<-subset(data1, data1[,40]==1)
compensatory<-subset(data1, data1[,41]==1)
ambiguous<-subset(data1, data1[,42]==1)
cisplustrans<-subset(data1, data1[,43]==1)
cisXtrans<-subset(data1, data1[,44]==1)

pdf(file = "/Final/Figs/SS_meta_CT1_120113.pdf")

plot(data1[,29], data1[,30], type = "n", ylim = c(-6,6),xlim = c(-6,6),xlab="Parental", ylab="Hybrid")

#Ambiguous
points(ambiguous[,29],ambiguous[,30], col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#cis + trans
points(cisplustrans[,29], cisplustrans[,30],col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#cis X trans
points(cisXtrans[,29], cisXtrans[,30],col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#All cis
points(allcis[,29], allcis[,30],col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#All trans
points(alltrans[,29],alltrans[,30], col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#Compensatory
points(compensatory[,29], compensatory[,30],col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#Conserved
points(conserved1[,29], conserved1[,30],col=rgb(t(col2rgb("yellow")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

abline(h=0)
abline(v=0)

dev.off()

rm(list=ls())

###################################################################################################
###################################################################################################
#sim-sec H2 all
data1<-read.delim("/Final/sim_sec/sim-sec_P+H2/outputs/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,30]~data1[,29])
summary(fit1)

allcis<-subset(data1, data1[,38]==1)
alltrans<-subset(data1, data1[,39]==1)
conserved1<-subset(data1, data1[,40]==1)
compensatory<-subset(data1, data1[,41]==1)
ambiguous<-subset(data1, data1[,42]==1)
cisplustrans<-subset(data1, data1[,43]==1)
cisXtrans<-subset(data1, data1[,44]==1)

pdf(file = "/Final/Figs/SS_meta_CT2_120113.pdf")

plot(data1[,29], data1[,30], type = "n", ylim = c(-6,6),xlim = c(-6,6),xlab="Parental", ylab="Hybrid")

#Ambiguous
points(ambiguous[,29],ambiguous[,30], col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#cis + trans
points(cisplustrans[,29], cisplustrans[,30],col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#cis X trans
points(cisXtrans[,29], cisXtrans[,30],col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#All cis
points(allcis[,29], allcis[,30],col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#All trans
points(alltrans[,29],alltrans[,30], col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#Compensatory
points(compensatory[,29], compensatory[,30],col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#Conserved
points(conserved1[,29], conserved1[,30],col=rgb(t(col2rgb("yellow")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

abline(h=0)
abline(v=0)

dev.off()

rm(list=ls())

###################################################################################################
###################################################################################################

#mel-sim H1 all
data1<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,30]~data1[,29])
summary(fit1)

allcis<-subset(data1, data1[,38]==1)
alltrans<-subset(data1, data1[,39]==1)
conserved1<-subset(data1, data1[,40]==1)
compensatory<-subset(data1, data1[,41]==1)
ambiguous<-subset(data1, data1[,42]==1)
cisplustrans<-subset(data1, data1[,43]==1)
cisXtrans<-subset(data1, data1[,44]==1)

pdf(file = "/Final/Figs/MS_meta_CT1_120113.pdf")

plot(data1[,29], data1[,30], type = "n", ylim = c(-6,6),xlim = c(-6,6),xlab="Parental", ylab="Hybrid")

#Ambiguous
points(ambiguous[,29],ambiguous[,30], col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#cis + trans
points(cisplustrans[,29], cisplustrans[,30],col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#cis X trans
points(cisXtrans[,29], cisXtrans[,30],col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#All cis
points(allcis[,29], allcis[,30],col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#All trans
points(alltrans[,29],alltrans[,30], col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#Compensatory
points(compensatory[,29], compensatory[,30],col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#Conserved
points(conserved1[,29], conserved1[,30],col=rgb(t(col2rgb("yellow")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

abline(h=0)
abline(v=0)

dev.off()

rm(list=ls())

###################################################################################################
###################################################################################################
#mel-sim H2 ALL

data1<-read.delim("/Final/mel_sim/mel-sim_P+H2/outputs/zhr+tsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,30]~data1[,29])
summary(fit1)

allcis<-subset(data1, data1[,38]==1)
alltrans<-subset(data1, data1[,39]==1)
conserved1<-subset(data1, data1[,40]==1)
compensatory<-subset(data1, data1[,41]==1)
ambiguous<-subset(data1, data1[,42]==1)
cisplustrans<-subset(data1, data1[,43]==1)
cisXtrans<-subset(data1, data1[,44]==1)

pdf(file = "/Final/Figs/MS_meta_CT2_120113.pdf")

plot(data1[,29], data1[,30], type = "n", ylim = c(-6,6),xlim = c(-6,6),xlab="Parental", ylab="Hybrid")

#Ambiguous
points(ambiguous[,29],ambiguous[,30], col=rgb(t(col2rgb("gray")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#cis + trans
points(cisplustrans[,29], cisplustrans[,30],col=rgb(t(col2rgb("blue")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#cis X trans
points(cisXtrans[,29], cisXtrans[,30],col=rgb(t(col2rgb("green")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#All cis
points(allcis[,29], allcis[,30],col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#All trans
points(alltrans[,29],alltrans[,30], col=rgb(t(col2rgb("red")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#Compensatory
points(compensatory[,29], compensatory[,30],col=rgb(t(col2rgb("orange")),alpha=255,maxColorValue=255),pch=19,cex=0.305)
#Conserved
points(conserved1[,29], conserved1[,30],col=rgb(t(col2rgb("yellow")),alpha=255,maxColorValue=255),pch=19,cex=0.305)

abline(h=0)
abline(v=0)

dev.off()

rm(list=ls())

###################################################################################################
###################################################################################################

#rho for cis-trans

#mel-mel H1 all
data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/zhr+z30_zhrXz30_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,30]~0 +data1[,29])
summary(fit1)
cor(data1[,30],data1[,29],method = c("s"))

rm(list=ls())

###################################################################################################
###################################################################################################
#mel-mel H2 all

data1<-read.delim("/Final/zhr_z30/mel-mel_P+H2/outputs/zhr+z30_z30Xzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,30]~0 +data1[,29])
summary(fit1)
cor(data1[,30],data1[,29],method = c("s"))

rm(list=ls())

###################################################################################################
###################################################################################################
#sim-sec H1 all

data1<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,30]~0 +data1[,29])
summary(fit1)
cor(data1[,30],data1[,29],method = c("s"))

rm(list=ls())

###################################################################################################
###################################################################################################
#sim-sec H2 all
data1<-read.delim("/Final/sim_sec/sim-sec_P+H2/outputs/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,30]~0 +data1[,29])
summary(fit1)
cor(data1[,30],data1[,29],method = c("s"))

rm(list=ls())

###################################################################################################
###################################################################################################

#mel-sim H1 all
data1<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,30]~0 +data1[,29])
summary(fit1)
cor(data1[,30],data1[,29],method = c("s"))

rm(list=ls())

###################################################################################################
###################################################################################################
#mel-sim H2 ALL

data1<-read.delim("/Final/mel_sim/mel-sim_P+H2/outputs/zhr+tsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,30]~0 +data1[,29])
summary(fit1)
cor(data1[,30],data1[,29],method = c("s"))

rm(list=ls())


####################################################################################################
####################################################################################################
#dominance and cis-trans percentages

#mel-mel
data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/zhr+z30_zhrXz30_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)
data2<-read.delim("/Final/zhr_z30/mel-mel_P+H2/outputs/zhr+z30_z30Xzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

#sim-sec
data3<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)
data4<-read.delim("/Final/sim_sec/sim-sec_P+H2/outputs/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

#mel-sim
data5<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)
data6<-read.delim("/Final/mel_sim/mel-sim_P+H2/outputs/zhr+tsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

####################################################################################################
####################################################################################################

#column names for reference
#29=data$logPrat = log2(data[,2]/data[,3])
#30=data$logHrat = log2(data[,13]/data[,14])
#31=data$logPrat_logHrat_rat = data$logPrat/data$logHrat
#32=data$percentcis = (abs(data$logHrat)/(abs(data$logHrat)+abs(data$logPrat-data$logHrat)))*100
#33=data$H_P1diff = log2((data[,16]/(sum(data[,16])))*100)-log2((data[,2]/(sum(data[,2])))*100)
#34=data$H_P2diff = log2((data[,16]/(sum(data[,16])))*100)-log2((data[,3]/(sum(data[,3])))*100)
#35=data$Pdiff = c(2:2)
#36=data$cis = c(2:2)
#37=data$trans = c(2:2)
#38=data$allcis = c(2:2)
#39=data$alltrans = c(2:2)
#40=data$conserved1 = c(2:2)
#41=data$compensatory = c(2:2)
#42=data$ambiguous = c(2:2)
#43=data$cisplustrans = c(2:2)
#44=data$cisXtrans = c(2:2)
#45=data$additive = c(2:2)
#46=data$underdominant = c(2:2)
#47=data$overdominant = c(2:2)
#48=data$par1dominant = c(2:2)
#49=data$par2dominant = c(2:2)
#50=data$conserved2 = c(2:2)

###########################################################################################
###########################################################################################

#val =

#sum(data1[,val])/nrow(data1)
#sum(data2[,val])/nrow(data2)
#sum(data3[,val])/nrow(data3)
#sum(data4[,val])/nrow(data4)
#sum(data5[,val])/nrow(data5)
#sum(data6[,val])/nrow(data6)

#val =

#sum(data1[,val])
#sum(data2[,val])
#sum(data3[,val])
#sum(data4[,val])
#sum(data5[,val])
#sum(data6[,val])

subset1<-subset(data1, ((data1[,46] == 1) | (data1[,47] == 1)))
subset2<-subset(data2, ((data2[,46] == 1) | (data2[,47] == 1)))
subset3<-subset(data3, ((data3[,46] == 1) | (data3[,47] == 1)))
subset4<-subset(data4, ((data4[,46] == 1) | (data4[,47] == 1)))
subset5<-subset(data5, ((data5[,46] == 1) | (data5[,47] == 1)))
subset6<-subset(data6, ((data6[,46] == 1) | (data6[,47] == 1)))

nrow(subset1)
nrow(subset2)
nrow(subset3)
nrow(subset4)
nrow(subset5)
nrow(subset6)

subset1b<-subset(data1, ((data1[,48] == 1) | (data1[,49] == 1)))
subset2b<-subset(data2, ((data2[,48] == 1) | (data2[,49] == 1)))
subset3b<-subset(data3, ((data3[,48] == 1) | (data3[,49] == 1)))
subset4b<-subset(data4, ((data4[,48] == 1) | (data4[,49] == 1)))
subset5b<-subset(data5, ((data5[,48] == 1) | (data5[,49] == 1)))
subset6b<-subset(data6, ((data6[,48] == 1) | (data6[,49] == 1)))

nrow(subset1b)
nrow(subset2b)
nrow(subset3b)
nrow(subset4b)
nrow(subset5b)
nrow(subset6b)

val = 35

sum(data1[,val])
sum(data2[,val])
sum(data3[,val])
sum(data4[,val])
sum(data5[,val])
sum(data6[,val])

val = 36

sum(data1[,val])
sum(data2[,val])
sum(data3[,val])
sum(data4[,val])
sum(data5[,val])
sum(data6[,val])

val = 37

sum(data1[,val])
sum(data2[,val])
sum(data3[,val])
sum(data4[,val])
sum(data5[,val])
sum(data6[,val])

or1<-subset(data1, (data1[,36] == 1) | (data1[,37] == 1))
or3<-subset(data3, (data3[,36] == 1) | (data3[,37] == 1))
or5<-subset(data5, (data5[,36] == 1) | (data5[,37] == 1))

nrow(or1)
nrow(or3)
nrow(or5)

or2<-subset(data2, (data2[,36] == 1) | (data2[,37] == 1))
or4<-subset(data4, (data4[,36] == 1) | (data4[,37] == 1))
or6<-subset(data6, (data6[,36] == 1) | (data6[,37] == 1))

nrow(or2)
nrow(or4)
nrow(or6)

and1<-subset(data1, (data1[,36] == 1) & (data1[,37] == 1))
and3<-subset(data3, (data3[,36] == 1) & (data3[,37] == 1))
and5<-subset(data5, (data5[,36] == 1) & (data5[,37] == 1))

nrow(and1)
nrow(and3)
nrow(and5)

and2<-subset(data2, (data2[,36] == 1) & (data2[,37] == 1))
and4<-subset(data4, (data4[,36] == 1) & (data4[,37] == 1))
and6<-subset(data6, (data6[,36] == 1) & (data6[,37] == 1))

nrow(and2)
nrow(and4)
nrow(and6)


subset1c<-subset(data1, (data1[,41] == 1) | (data1[,44] == 1))
subset2c<-subset(data2, (data2[,41] == 1) | (data2[,44] == 1))
subset3c<-subset(data3, (data3[,41] == 1) | (data3[,44] == 1))
subset4c<-subset(data4, (data4[,41] == 1) | (data4[,44] == 1))
subset5c<-subset(data5, (data5[,41] == 1) | (data5[,44] == 1))
subset6c<-subset(data6, (data6[,41] == 1) | (data6[,44] == 1))

nrow(subset1c)
nrow(subset2c)
nrow(subset3c)
nrow(subset4c)
nrow(subset5c)
nrow(subset6c)

sum(subset1c[,46]+subset1c[,47])
sum(subset2c[,46]+subset2c[,47])
sum(subset3c[,46]+subset3c[,47])
sum(subset4c[,46]+subset4c[,47])
sum(subset5c[,46]+subset5c[,47])
sum(subset6c[,46]+subset6c[,47])


subset1d<-subset(data1, ((data1[,46] == 1) | (data1[,47] == 1)))
subset2d<-subset(data2, ((data2[,46] == 1) | (data2[,47] == 1)))
subset3d<-subset(data3, ((data3[,46] == 1) | (data3[,47] == 1)))
subset4d<-subset(data4, ((data4[,46] == 1) | (data4[,47] == 1)))
subset5d<-subset(data5, ((data5[,46] == 1) | (data5[,47] == 1)))
subset6d<-subset(data6, ((data6[,46] == 1) | (data6[,47] == 1)))

nrow(subset1d)
nrow(subset2d)
nrow(subset3d)
nrow(subset4d)
nrow(subset5d)
nrow(subset6d)

sum(subset1d[,44])+sum(subset1d[,41])
sum(subset2d[,44])+sum(subset2d[,41])
sum(subset3d[,44])+sum(subset3d[,41])
sum(subset4d[,44])+sum(subset4d[,41])
sum(subset5d[,44])+sum(subset5d[,41])
sum(subset6d[,44])+sum(subset6d[,41])

subset1e<-subset(data1, ((data1[,46] == 0) & (data1[,47] == 0)))
subset2e<-subset(data2, ((data2[,46] == 0) & (data2[,47] == 0)))
subset3e<-subset(data3, ((data3[,46] == 0) & (data3[,47] == 0)))
subset4e<-subset(data4, ((data4[,46] == 0) & (data4[,47] == 0)))
subset5e<-subset(data5, ((data5[,46] == 0) & (data5[,47] == 0)))
subset6e<-subset(data6, ((data6[,46] == 0) & (data6[,47] == 0)))

sum(subset1e[,44])+sum(subset1e[,41])
sum(subset2e[,44])+sum(subset2e[,41])
sum(subset3e[,44])+sum(subset3e[,41])
sum(subset4e[,44])+sum(subset4e[,41])
sum(subset5e[,44])+sum(subset5e[,41])
sum(subset6e[,44])+sum(subset6e[,41])

sum(subset1e[,44])
sum(subset2e[,44])
sum(subset3e[,44])
sum(subset4e[,44])
sum(subset5e[,44])
sum(subset6e[,44])

####################################################################################################
####################################################################################################

subset1f<-subset(data1, (data1[,45] == 1))
subset2f<-subset(data2, (data2[,45] == 1))
subset3f<-subset(data3, (data3[,45] == 1))
subset4f<-subset(data4, (data4[,45] == 1))
subset5f<-subset(data5, (data5[,45] == 1))
subset6f<-subset(data6, (data6[,45] == 1))

subset1g<-subset(data1, (data1[,45] == 0))
subset2g<-subset(data2, (data2[,45] == 0))
subset3g<-subset(data3, (data3[,45] == 0))
subset4g<-subset(data4, (data4[,45] == 0))
subset5g<-subset(data5, (data5[,45] == 0))
subset6g<-subset(data6, (data6[,45] == 0))


#make boxplot
pdf(file = "/Final/Meta/percentcis_additiveVSnonadditive_121312.pdf")
boxplot(subset1f[,32],subset1g[,32],subset3f[,32],subset3g[,32],subset5f[,32],subset5g[,32], ylab='% cis', xaxt="n", notch = TRUE, varwidth=TRUE)
axis(1, at=1:6,lab=c("zhr-z30 A", "zhr-z30 NA","sim-sec A","sim-sec NA","mel-sim A","mel-sim NA"))
dev.off()


pdf(file = "/Final/Meta/percentcis_additiveVSnonadditive_H2_121312.pdf")
boxplot(subset2f[,32],subset2g[,32],subset4f[,32],subset4g[,32],subset6f[,32],subset6g[,32], ylab='% cis', xaxt="n", notch = TRUE, varwidth=TRUE)
axis(1, at=1:6,lab=c("zhr-z30 A", "zhr-z30 NA","sim-sec A","sim-sec NA","mel-sim A","mel-sim NA"))
dev.off()


summary(subset1f[,32])
summary(subset1g[,32])
summary(subset3f[,32])
summary(subset3g[,32])
summary(subset5f[,32])
summary(subset5g[,32])

summary(subset2f[,32])
summary(subset2g[,32])
summary(subset4f[,32])
summary(subset4g[,32])
summary(subset6f[,32])
summary(subset6g[,32])

#############################################percent cis ttest####################################

t.test(subset1f[,32],subset1g[,32],alternative = c("t"),var.equal=FALSE, conf.level=0.95)
t.test(subset3f[,32],subset3g[,32],alternative = c("t"),var.equal=FALSE, conf.level=0.95)
t.test(subset5f[,32],subset5g[,32],alternative = c("t"),var.equal=FALSE, conf.level=0.95)


t.test(subset2f[,32],subset2g[,32],alternative = c("t"),var.equal=FALSE, conf.level=0.95)
t.test(subset4f[,32],subset4g[,32],alternative = c("t"),var.equal=FALSE, conf.level=0.95)
t.test(subset6f[,32],subset6g[,32],alternative = c("t"),var.equal=FALSE, conf.level=0.95)


rm(list=ls())

####################################################################################################
####################################################################################################
#rho for P1 vs P2 and A1 vs A2

#mel-mel H1 all
data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/zhr+z30_zhrXz30_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,3]~data1[,2])
fit2<-lm(data1[,14]~data1[,13])
summary(fit1)
summary(fit2)
cor(data1[,2],data1[,3],method = c("s"))
cor(data1[,13],data1[,14],method = c("s"))

#plot

#mel-mel P1 vs P2

pdf(file='/final/Figs/MMH1_P1vsP2_ASE_120113.pdf')
plot(log2(data1[,2]),log2(data1[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(melXsim)',ylab='log2(simXmel)')

dev.off()

#mel-mel H1 A1 vs A2

pdf(file='/final/Figs/MMH1_A1vsA2_ASE_120113.pdf')
plot(log2(data1[,13]),log2(data1[,14]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(melXsim)',ylab='log2(simXmel)')

dev.off()

rm(list=ls())

###################################################################################################
###################################################################################################
#mel-mel H2 all

data1<-read.delim("/Final/zhr_z30/mel-mel_P+H2/outputs/zhr+z30_z30Xzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,3]~data1[,2])
fit2<-lm(data1[,14]~data1[,13])
summary(fit1)
summary(fit2)
cor(data1[,2],data1[,3],method = c("s"))
cor(data1[,13],data1[,14],method = c("s"))

#mel-mel H2 A1 vs A2

pdf(file='/final/Figs/MMH2_A1vsA2_ASE_120113.pdf')
plot(log2(data1[,13]),log2(data1[,14]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(melXsim)',ylab='log2(simXmel)')

dev.off()

rm(list=ls())

###################################################################################################
###################################################################################################
#sim-sec H1 all

data1<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,3]~data1[,2])
fit2<-lm(data1[,14]~data1[,13])
summary(fit1)
summary(fit2)
cor(data1[,2],data1[,3],method = c("s"))
cor(data1[,13],data1[,14],method = c("s"))

#sim-sech P1 vs P2

pdf(file='/final/Figs/SSH1_P1vsP2_ASE_120113.pdf')
plot(log2(data1[,2]),log2(data1[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(melXsim)',ylab='log2(simXmel)')

dev.off()

#sim-sech H1 A1 vs A2

pdf(file='/final/Figs/SSH1_A1vsA2_ASE_120113.pdf')
plot(log2(data1[,13]),log2(data1[,14]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(melXsim)',ylab='log2(simXmel)')

dev.off()

rm(list=ls())

###################################################################################################
###################################################################################################
#sim-sec H2 all
data1<-read.delim("/Final/sim_sec/sim-sec_P+H2/outputs/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,3]~data1[,2])
fit2<-lm(data1[,14]~data1[,13])
summary(fit1)
summary(fit2)
cor(data1[,2],data1[,3],method = c("s"))
cor(data1[,13],data1[,14],method = c("s"))

#sim-sech H2 A1 vs A2

pdf(file='/final/Figs/SSH2_A1vsA2_ASE_120113.pdf')
plot(log2(data1[,13]),log2(data1[,14]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(melXsim)',ylab='log2(simXmel)')

dev.off()

rm(list=ls())

###################################################################################################
###################################################################################################

#mel-sim H1 all
data1<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,3]~data1[,2])
fit2<-lm(data1[,14]~data1[,13])
summary(fit1)
summary(fit2)
cor(data1[,2],data1[,3],method = c("s"))
cor(data1[,13],data1[,14],method = c("s"))

#mel-sim P1 vs P2

pdf(file='/final/Figs/MSH1_P1vsP2_ASE_120113.pdf')
plot(log2(data1[,2]),log2(data1[,3]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(melXsim)',ylab='log2(simXmel)')

dev.off()

#mel-sim H1 A1 vs A2

pdf(file='/final/Figs/MSH1_A1vsA2_ASE_120113.pdf')
plot(log2(data1[,13]),log2(data1[,14]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(melXsim)',ylab='log2(simXmel)')

dev.off()

rm(list=ls())

###################################################################################################
###################################################################################################
#mel-sim H2 ALL

data1<-read.delim("/Final/mel_sim/mel-sim_P+H2/outputs/zhr+tsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,3]~data1[,2])
fit2<-lm(data1[,14]~data1[,13])
summary(fit1)
summary(fit2)
cor(data1[,2],data1[,3],method = c("s"))
cor(data1[,13],data1[,14],method = c("s"))

#mel-sim H2 A1 vs A2

pdf(file='/final/Figs/MSH2_A1vsA2_ASE_120113.pdf')
plot(log2(data1[,13]),log2(data1[,14]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(melXsim)',ylab='log2(simXmel)')

dev.off()

rm(list=ls())

####################################################################################################
####################################################################################################
#Chromosome analyses ASE genes
####################################################################################################
####################################################################################################
#create files for each chromosome
####################################################################################################
####################################################################################################

#position data
allgenes<-read.delim("/gene_positions/allgenes.txt", header = TRUE)
#ASEgenes<-read.delim("/Final/ASE_genes.txt", header = TRUE)
#TOTALgenes<-read.delim("/Final/total-genes.txt", header = TRUE)

chrX<-read.delim("/gene_positions/chrX.genes.bed", header = TRUE)
chr2L<-read.delim("/gene_positions/chr2L.genes.bed", header = TRUE)
chr2R<-read.delim("/gene_positions/chr2R.genes.bed", header = TRUE)
chr3L<-read.delim("/gene_positions/chr3L.genes.bed", header = TRUE)
chr3R<-read.delim("/gene_positions/chr3R.genes.bed", header = TRUE)
chr4<-read.delim("/gene_positions/chr4.genes.bed", header = TRUE)

####################################################################################################
####################################################################################################

#mel-mel H1
data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/zhr+z30_zhrXz30_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

####################################################################################################
####################################################################################################

#unique filter
#columns
#chromosome	start	stop	gene	number	strand
#gene 	chr	position

chrX2<-unique(as.character(chrX$gene), incomparables = FALSE, fromLast = FALSE)
chrX2<-data.frame(chrX2)
colnames(chrX2) <- c('gene')
chrX3<-merge(allgenes,chrX2, by = 'gene')
chrX4<-subset(chrX3, chrX3[,2] != '-')

chr2L2<-unique(as.character(chr2L$gene), incomparables = FALSE, fromLast = FALSE)
chr2L2<-data.frame(chr2L2)
colnames(chr2L2) <- c('gene')
chr2L3<-merge(allgenes,chr2L2, by = 'gene')
chr2L4<-subset(chr2L3, chr2L3[,2] != '-')

chr2R2<-unique(as.character(chr2R$gene), incomparables = FALSE, fromLast = TRUE)
chr2R2<-data.frame(chr2R2)
colnames(chr2R2) <- c('gene')
chr2R3<-merge(allgenes,chr2R2, by = 'gene')
chr2R4<-subset(chr2R3, chr2R3[,2] != '-')

chr3L2<-unique(as.character(chr3L$gene), incomparables = FALSE, fromLast = FALSE)
chr3L2<-data.frame(chr3L2)
colnames(chr3L2) <- c('gene')
chr3L3<-merge(allgenes,chr3L2, by = 'gene')
chr3L4<-subset(chr3L3, chr3L3[,2] != '-')

chr3R2<-unique(as.character(chr3R$gene), incomparables = FALSE, fromLast = FALSE)
chr3R2<-data.frame(chr3R2)
colnames(chr3R2) <- c('gene')
chr3R3<-merge(allgenes,chr3R2, by = 'gene')
chr3R4<-subset(chr3R3, chr3R3[,2] != '-')

chr42<-unique(as.character(chr4$gene), incomparables = FALSE, fromLast = FALSE)
chr42<-data.frame(chr42)
colnames(chr42) <- c('gene')
chr43<-merge(allgenes,chr42, by = 'gene')
chr44<-subset(chr43, chr43[,2] != '-')

###################################################################################################

chrX5<-merge(chrX4, data1, by = 'gene')
chr2L5<-merge(chr2L4, data1, by = 'gene')
chr2R5<-merge(chr2R4, data1, by = 'gene')
chr3L5<-merge(chr3L4, data1, by = 'gene')
chr3R5<-merge(chr3R4, data1, by = 'gene')
chr45<-merge(chr44, data1, by = 'gene')

write.table(chrX5, file = "/gene_positions/chrX_mm_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr2L5, file = "/gene_positions/chr2L_mm_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr2R5, file = "/gene_positions/chr2R_mm_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr3L5, file = "/gene_positions/chr3L_mm_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr3R5, file = "/gene_positions/chr3R_mm_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr45, file = "/gene_positions/chr4_mm_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################

#position data
allgenes<-read.delim("/gene_positions/allgenes.txt", header = TRUE)
#ASEgenes<-read.delim("/Final/ASE_genes.txt", header = TRUE)
#TOTALgenes<-read.delim("/Final/total-genes.txt", header = TRUE)

chrX<-read.delim("/gene_positions/chrX.genes.bed", header = TRUE)
chr2L<-read.delim("/gene_positions/chr2L.genes.bed", header = TRUE)
chr2R<-read.delim("/gene_positions/chr2R.genes.bed", header = TRUE)
chr3L<-read.delim("/gene_positions/chr3L.genes.bed", header = TRUE)
chr3R<-read.delim("/gene_positions/chr3R.genes.bed", header = TRUE)
chr4<-read.delim("/gene_positions/chr4.genes.bed", header = TRUE)

####################################################################################################
####################################################################################################

#mel-mel H2
data1<-read.delim("/Final/zhr_z30/mel-mel_P+H2/outputs/zhr+z30_z30Xzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

####################################################################################################
####################################################################################################

#unique filter
#columns
#chromosome	start	stop	gene	number	strand
#gene 	chr	position

chrX2<-unique(as.character(chrX$gene), incomparables = FALSE, fromLast = FALSE)
chrX2<-data.frame(chrX2)
colnames(chrX2) <- c('gene')
chrX3<-merge(allgenes,chrX2, by = 'gene')
chrX4<-subset(chrX3, chrX3[,2] != '-')

chr2L2<-unique(as.character(chr2L$gene), incomparables = FALSE, fromLast = FALSE)
chr2L2<-data.frame(chr2L2)
colnames(chr2L2) <- c('gene')
chr2L3<-merge(allgenes,chr2L2, by = 'gene')
chr2L4<-subset(chr2L3, chr2L3[,2] != '-')

chr2R2<-unique(as.character(chr2R$gene), incomparables = FALSE, fromLast = TRUE)
chr2R2<-data.frame(chr2R2)
colnames(chr2R2) <- c('gene')
chr2R3<-merge(allgenes,chr2R2, by = 'gene')
chr2R4<-subset(chr2R3, chr2R3[,2] != '-')

chr3L2<-unique(as.character(chr3L$gene), incomparables = FALSE, fromLast = FALSE)
chr3L2<-data.frame(chr3L2)
colnames(chr3L2) <- c('gene')
chr3L3<-merge(allgenes,chr3L2, by = 'gene')
chr3L4<-subset(chr3L3, chr3L3[,2] != '-')

chr3R2<-unique(as.character(chr3R$gene), incomparables = FALSE, fromLast = FALSE)
chr3R2<-data.frame(chr3R2)
colnames(chr3R2) <- c('gene')
chr3R3<-merge(allgenes,chr3R2, by = 'gene')
chr3R4<-subset(chr3R3, chr3R3[,2] != '-')

chr42<-unique(as.character(chr4$gene), incomparables = FALSE, fromLast = FALSE)
chr42<-data.frame(chr42)
colnames(chr42) <- c('gene')
chr43<-merge(allgenes,chr42, by = 'gene')
chr44<-subset(chr43, chr43[,2] != '-')

###################################################################################################

chrX5<-merge(chrX4, data1, by = 'gene')
chr2L5<-merge(chr2L4, data1, by = 'gene')
chr2R5<-merge(chr2R4, data1, by = 'gene')
chr3L5<-merge(chr3L4, data1, by = 'gene')
chr3R5<-merge(chr3R4, data1, by = 'gene')
chr45<-merge(chr44, data1, by = 'gene')

write.table(chrX5, file = "/gene_positions/chrX_mm2_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr2L5, file = "/gene_positions/chr2L_mm2_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr2R5, file = "/gene_positions/chr2R_mm2_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr3L5, file = "/gene_positions/chr3L_mm2_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr3R5, file = "/gene_positions/chr3R_mm2_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr45, file = "/gene_positions/chr4_mm2_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################

#position data
allgenes<-read.delim("/gene_positions/allgenes.txt", header = TRUE)
#ASEgenes<-read.delim("/Final/ASE_genes.txt", header = TRUE)
#TOTALgenes<-read.delim("/Final/total-genes.txt", header = TRUE)

chrX<-read.delim("/gene_positions/chrX.genes.bed", header = TRUE)
chr2L<-read.delim("/gene_positions/chr2L.genes.bed", header = TRUE)
chr2R<-read.delim("/gene_positions/chr2R.genes.bed", header = TRUE)
chr3L<-read.delim("/gene_positions/chr3L.genes.bed", header = TRUE)
chr3R<-read.delim("/gene_positions/chr3R.genes.bed", header = TRUE)
chr4<-read.delim("/gene_positions/chr4.genes.bed", header = TRUE)

####################################################################################################
####################################################################################################

#sim-sec
data1<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

####################################################################################################
####################################################################################################

#unique filter
#columns
#chromosome	start	stop	gene	number	strand
#gene 	chr	position

chrX2<-unique(as.character(chrX$gene), incomparables = FALSE, fromLast = FALSE)
chrX2<-data.frame(chrX2)
colnames(chrX2) <- c('gene')
chrX3<-merge(allgenes,chrX2, by = 'gene')
chrX4<-subset(chrX3, chrX3[,2] != '-')

chr2L2<-unique(as.character(chr2L$gene), incomparables = FALSE, fromLast = FALSE)
chr2L2<-data.frame(chr2L2)
colnames(chr2L2) <- c('gene')
chr2L3<-merge(allgenes,chr2L2, by = 'gene')
chr2L4<-subset(chr2L3, chr2L3[,2] != '-')

chr2R2<-unique(as.character(chr2R$gene), incomparables = FALSE, fromLast = TRUE)
chr2R2<-data.frame(chr2R2)
colnames(chr2R2) <- c('gene')
chr2R3<-merge(allgenes,chr2R2, by = 'gene')
chr2R4<-subset(chr2R3, chr2R3[,2] != '-')

chr3L2<-unique(as.character(chr3L$gene), incomparables = FALSE, fromLast = FALSE)
chr3L2<-data.frame(chr3L2)
colnames(chr3L2) <- c('gene')
chr3L3<-merge(allgenes,chr3L2, by = 'gene')
chr3L4<-subset(chr3L3, chr3L3[,2] != '-')

chr3R2<-unique(as.character(chr3R$gene), incomparables = FALSE, fromLast = FALSE)
chr3R2<-data.frame(chr3R2)
colnames(chr3R2) <- c('gene')
chr3R3<-merge(allgenes,chr3R2, by = 'gene')
chr3R4<-subset(chr3R3, chr3R3[,2] != '-')

chr42<-unique(as.character(chr4$gene), incomparables = FALSE, fromLast = FALSE)
chr42<-data.frame(chr42)
colnames(chr42) <- c('gene')
chr43<-merge(allgenes,chr42, by = 'gene')
chr44<-subset(chr43, chr43[,2] != '-')

###################################################################################################

chrX5<-merge(chrX4, data1, by = 'gene')
chr2L5<-merge(chr2L4, data1, by = 'gene')
chr2R5<-merge(chr2R4, data1, by = 'gene')
chr3L5<-merge(chr3L4, data1, by = 'gene')
chr3R5<-merge(chr3R4, data1, by = 'gene')
chr45<-merge(chr44, data1, by = 'gene')

write.table(chrX5, file = "/gene_positions/chrX_ss_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr2L5, file = "/gene_positions/chr2L_ss_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr2R5, file = "/gene_positions/chr2R_ss_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr3L5, file = "/gene_positions/chr3L_ss_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr3R5, file = "/gene_positions/chr3R_ss_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr45, file = "/gene_positions/chr4_ss_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################

#position data
allgenes<-read.delim("/gene_positions/allgenes.txt", header = TRUE)
#ASEgenes<-read.delim("/Final/ASE_genes.txt", header = TRUE)
#TOTALgenes<-read.delim("/Final/total-genes.txt", header = TRUE)

chrX<-read.delim("/gene_positions/chrX.genes.bed", header = TRUE)
chr2L<-read.delim("/gene_positions/chr2L.genes.bed", header = TRUE)
chr2R<-read.delim("/gene_positions/chr2R.genes.bed", header = TRUE)
chr3L<-read.delim("/gene_positions/chr3L.genes.bed", header = TRUE)
chr3R<-read.delim("/gene_positions/chr3R.genes.bed", header = TRUE)
chr4<-read.delim("/gene_positions/chr4.genes.bed", header = TRUE)

####################################################################################################
####################################################################################################

#sim-sec h2
data1<-read.delim("/Final/sim_sec/sim-sec_P+H2/outputs/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

####################################################################################################
####################################################################################################

#unique filter
#columns
#chromosome	start	stop	gene	number	strand
#gene 	chr	position

chrX2<-unique(as.character(chrX$gene), incomparables = FALSE, fromLast = FALSE)
chrX2<-data.frame(chrX2)
colnames(chrX2) <- c('gene')
chrX3<-merge(allgenes,chrX2, by = 'gene')
chrX4<-subset(chrX3, chrX3[,2] != '-')

chr2L2<-unique(as.character(chr2L$gene), incomparables = FALSE, fromLast = FALSE)
chr2L2<-data.frame(chr2L2)
colnames(chr2L2) <- c('gene')
chr2L3<-merge(allgenes,chr2L2, by = 'gene')
chr2L4<-subset(chr2L3, chr2L3[,2] != '-')

chr2R2<-unique(as.character(chr2R$gene), incomparables = FALSE, fromLast = TRUE)
chr2R2<-data.frame(chr2R2)
colnames(chr2R2) <- c('gene')
chr2R3<-merge(allgenes,chr2R2, by = 'gene')
chr2R4<-subset(chr2R3, chr2R3[,2] != '-')

chr3L2<-unique(as.character(chr3L$gene), incomparables = FALSE, fromLast = FALSE)
chr3L2<-data.frame(chr3L2)
colnames(chr3L2) <- c('gene')
chr3L3<-merge(allgenes,chr3L2, by = 'gene')
chr3L4<-subset(chr3L3, chr3L3[,2] != '-')

chr3R2<-unique(as.character(chr3R$gene), incomparables = FALSE, fromLast = FALSE)
chr3R2<-data.frame(chr3R2)
colnames(chr3R2) <- c('gene')
chr3R3<-merge(allgenes,chr3R2, by = 'gene')
chr3R4<-subset(chr3R3, chr3R3[,2] != '-')

chr42<-unique(as.character(chr4$gene), incomparables = FALSE, fromLast = FALSE)
chr42<-data.frame(chr42)
colnames(chr42) <- c('gene')
chr43<-merge(allgenes,chr42, by = 'gene')
chr44<-subset(chr43, chr43[,2] != '-')

###################################################################################################

chrX5<-merge(chrX4, data1, by = 'gene')
chr2L5<-merge(chr2L4, data1, by = 'gene')
chr2R5<-merge(chr2R4, data1, by = 'gene')
chr3L5<-merge(chr3L4, data1, by = 'gene')
chr3R5<-merge(chr3R4, data1, by = 'gene')
chr45<-merge(chr44, data1, by = 'gene')

write.table(chrX5, file = "/gene_positions/chrX_ss2_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr2L5, file = "/gene_positions/chr2L_ss2_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr2R5, file = "/gene_positions/chr2R_ss2_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr3L5, file = "/gene_positions/chr3L_ss2_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr3R5, file = "/gene_positions/chr3R_ss2_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr45, file = "/gene_positions/chr4_ss2_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################

#position data
allgenes<-read.delim("/gene_positions/allgenes.txt", header = TRUE)
#ASEgenes<-read.delim("/Final/ASE_genes.txt", header = TRUE)
#TOTALgenes<-read.delim("/Final/total-genes.txt", header = TRUE)

chrX<-read.delim("/gene_positions/chrX.genes.bed", header = TRUE)
chr2L<-read.delim("/gene_positions/chr2L.genes.bed", header = TRUE)
chr2R<-read.delim("/gene_positions/chr2R.genes.bed", header = TRUE)
chr3L<-read.delim("/gene_positions/chr3L.genes.bed", header = TRUE)
chr3R<-read.delim("/gene_positions/chr3R.genes.bed", header = TRUE)
chr4<-read.delim("/gene_positions/chr4.genes.bed", header = TRUE)

####################################################################################################
####################################################################################################

#mel-sim
data1<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

####################################################################################################
####################################################################################################

#unique filter
#columns
#chromosome	start	stop	gene	number	strand
#gene 	chr	position

chrX2<-unique(as.character(chrX$gene), incomparables = FALSE, fromLast = FALSE)
chrX2<-data.frame(chrX2)
colnames(chrX2) <- c('gene')
chrX3<-merge(allgenes,chrX2, by = 'gene')
chrX4<-subset(chrX3, chrX3[,2] != '-')

chr2L2<-unique(as.character(chr2L$gene), incomparables = FALSE, fromLast = FALSE)
chr2L2<-data.frame(chr2L2)
colnames(chr2L2) <- c('gene')
chr2L3<-merge(allgenes,chr2L2, by = 'gene')
chr2L4<-subset(chr2L3, chr2L3[,2] != '-')

chr2R2<-unique(as.character(chr2R$gene), incomparables = FALSE, fromLast = TRUE)
chr2R2<-data.frame(chr2R2)
colnames(chr2R2) <- c('gene')
chr2R3<-merge(allgenes,chr2R2, by = 'gene')
chr2R4<-subset(chr2R3, chr2R3[,2] != '-')

chr3L2<-unique(as.character(chr3L$gene), incomparables = FALSE, fromLast = FALSE)
chr3L2<-data.frame(chr3L2)
colnames(chr3L2) <- c('gene')
chr3L3<-merge(allgenes,chr3L2, by = 'gene')
chr3L4<-subset(chr3L3, chr3L3[,2] != '-')

chr3R2<-unique(as.character(chr3R$gene), incomparables = FALSE, fromLast = FALSE)
chr3R2<-data.frame(chr3R2)
colnames(chr3R2) <- c('gene')
chr3R3<-merge(allgenes,chr3R2, by = 'gene')
chr3R4<-subset(chr3R3, chr3R3[,2] != '-')

chr42<-unique(as.character(chr4$gene), incomparables = FALSE, fromLast = FALSE)
chr42<-data.frame(chr42)
colnames(chr42) <- c('gene')
chr43<-merge(allgenes,chr42, by = 'gene')
chr44<-subset(chr43, chr43[,2] != '-')

###################################################################################################

chrX5<-merge(chrX4, data1, by = 'gene')
chr2L5<-merge(chr2L4, data1, by = 'gene')
chr2R5<-merge(chr2R4, data1, by = 'gene')
chr3L5<-merge(chr3L4, data1, by = 'gene')
chr3R5<-merge(chr3R4, data1, by = 'gene')
chr45<-merge(chr44, data1, by = 'gene')

write.table(chrX5, file = "/gene_positions/chrX_ms_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr2L5, file = "/gene_positions/chr2L_ms_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr2R5, file = "/gene_positions/chr2R_ms_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr3L5, file = "/gene_positions/chr3L_ms_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr3R5, file = "/gene_positions/chr3R_ms_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr45, file = "/gene_positions/chr4_ms_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################

#position data
allgenes<-read.delim("/gene_positions/allgenes.txt", header = TRUE)
#ASEgenes<-read.delim("/Final/ASE_genes.txt", header = TRUE)
#TOTALgenes<-read.delim("/Final/total-genes.txt", header = TRUE)

chrX<-read.delim("/gene_positions/chrX.genes.bed", header = TRUE)
chr2L<-read.delim("/gene_positions/chr2L.genes.bed", header = TRUE)
chr2R<-read.delim("/gene_positions/chr2R.genes.bed", header = TRUE)
chr3L<-read.delim("/gene_positions/chr3L.genes.bed", header = TRUE)
chr3R<-read.delim("/gene_positions/chr3R.genes.bed", header = TRUE)
chr4<-read.delim("/gene_positions/chr4.genes.bed", header = TRUE)

####################################################################################################
####################################################################################################

#mel-sim h2
data1<-read.delim("/Final/mel_sim/mel-sim_P+H2/outputs/zhr+tsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

####################################################################################################
####################################################################################################

#unique filter
#columns
#chromosome	start	stop	gene	number	strand
#gene 	chr	position

chrX2<-unique(as.character(chrX$gene), incomparables = FALSE, fromLast = FALSE)
chrX2<-data.frame(chrX2)
colnames(chrX2) <- c('gene')
chrX3<-merge(allgenes,chrX2, by = 'gene')
chrX4<-subset(chrX3, chrX3[,2] != '-')

chr2L2<-unique(as.character(chr2L$gene), incomparables = FALSE, fromLast = FALSE)
chr2L2<-data.frame(chr2L2)
colnames(chr2L2) <- c('gene')
chr2L3<-merge(allgenes,chr2L2, by = 'gene')
chr2L4<-subset(chr2L3, chr2L3[,2] != '-')

chr2R2<-unique(as.character(chr2R$gene), incomparables = FALSE, fromLast = TRUE)
chr2R2<-data.frame(chr2R2)
colnames(chr2R2) <- c('gene')
chr2R3<-merge(allgenes,chr2R2, by = 'gene')
chr2R4<-subset(chr2R3, chr2R3[,2] != '-')

chr3L2<-unique(as.character(chr3L$gene), incomparables = FALSE, fromLast = FALSE)
chr3L2<-data.frame(chr3L2)
colnames(chr3L2) <- c('gene')
chr3L3<-merge(allgenes,chr3L2, by = 'gene')
chr3L4<-subset(chr3L3, chr3L3[,2] != '-')

chr3R2<-unique(as.character(chr3R$gene), incomparables = FALSE, fromLast = FALSE)
chr3R2<-data.frame(chr3R2)
colnames(chr3R2) <- c('gene')
chr3R3<-merge(allgenes,chr3R2, by = 'gene')
chr3R4<-subset(chr3R3, chr3R3[,2] != '-')

chr42<-unique(as.character(chr4$gene), incomparables = FALSE, fromLast = FALSE)
chr42<-data.frame(chr42)
colnames(chr42) <- c('gene')
chr43<-merge(allgenes,chr42, by = 'gene')
chr44<-subset(chr43, chr43[,2] != '-')

####################################################################################################

chrX5<-merge(chrX4, data1, by = 'gene')
chr2L5<-merge(chr2L4, data1, by = 'gene')
chr2R5<-merge(chr2R4, data1, by = 'gene')
chr3L5<-merge(chr3L4, data1, by = 'gene')
chr3R5<-merge(chr3R4, data1, by = 'gene')
chr45<-merge(chr44, data1, by = 'gene')

write.table(chrX5, file = "/gene_positions/chrX_ms2_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr2L5, file = "/gene_positions/chr2L_ms2_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr2R5, file = "/gene_positions/chr2R_ms2_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr3L5, file = "/gene_positions/chr3L_ms2_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr3R5, file = "/gene_positions/chr3R_ms2_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(chr45, file = "/gene_positions/chr4_ms2_120113.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################
#rho by chromosome in each comparison in meta data
####################################################################################################
####################################################################################################

cX<-read.delim("/gene_positions/chrX_mm_120113.txt",header = TRUE)
c2L<-read.delim("/gene_positions/chr2L_mm_120113.txt",header = TRUE)
c2R<-read.delim("/gene_positions/chr2R_mm_120113.txt",header = TRUE)
c3L<-read.delim("/gene_positions/chr3L_mm_120113.txt",header = TRUE)
c3R<-read.delim("/gene_positions/chr3R_mm_120113.txt",header = TRUE)
c4<-read.delim("/gene_positions/chr4_mm_120113.txt",header = TRUE)

cX2<-read.delim("/gene_positions/chrX_ss_120113.txt",header = TRUE)
c2L2<-read.delim("/gene_positions/chr2L_ss_120113.txt",header = TRUE)
c2R2<-read.delim("/gene_positions/chr2R_ss_120113.txt",header = TRUE)
c3L2<-read.delim("/gene_positions/chr3L_ss_120113.txt",header = TRUE)
c3R2<-read.delim("/gene_positions/chr3R_ss_120113.txt",header = TRUE)
c42<-read.delim("/gene_positions/chr4_ss_120113.txt",header = TRUE)

cX3<-read.delim("/gene_positions/chrX_ms_120113.txt",header = TRUE)
c2L3<-read.delim("/gene_positions/chr2L_ms_120113.txt",header = TRUE)
c2R3<-read.delim("/gene_positions/chr2R_ms_120113.txt",header = TRUE)
c3L3<-read.delim("/gene_positions/chr3L_ms_120113.txt",header = TRUE)
c3R3<-read.delim("/gene_positions/chr3R_ms_120113.txt",header = TRUE)
c43<-read.delim("/gene_positions/chr4_ms_120113.txt",header = TRUE)

####################################################################################################
####################################################################################################

#plots pdiff

pdf(file='/final/separate/X_pdiff_120113.pdf')
plot(log2(cX[,4]), log2(cX[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2L_pdiff_120113.pdf')
plot(log2(c2L[,4]), log2(c2L[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2R_pdiff_120113.pdf')
plot(log2(c2R[,4]), log2(c2R[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3L_pdiff_120113.pdf')
plot(log2(c3L[,4]), log2(c3L[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3R_pdiff_120113.pdf')
plot(log2(c3R[,4]), log2(c3R[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/4_pdiff_120113.pdf')
plot(log2(c4[,4]), log2(c4[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

####################################################################################################

pdf(file='/final/separate/X2_pdiff_120113.pdf')
plot(log2(cX2[,4]), log2(cX2[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2L2_pdiff_120113.pdf')
plot(log2(c2L2[,4]), log2(c2L2[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2R2_pdiff_120113.pdf')
plot(log2(c2R2[,4]), log2(c2R2[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3L2_pdiff_120113.pdf')
plot(log2(c3L2[,4]), log2(c3L2[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3R2_pdiff_120113.pdf')
plot(log2(c3R2[,4]), log2(c3R2[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/42_pdiff_120113.pdf')
plot(log2(c42[,4]), log2(c42[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

####################################################################################################

#plots

pdf(file='/final/separate/X3_pdiff_120113.pdf')
plot(log2(cX3[,4]), log2(cX3[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2L3_pdiff_120113.pdf')
plot(log2(c2L3[,4]), log2(c2L3[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2R3_pdiff_120113.pdf')
plot(log2(c2R3[,4]), log2(c2R3[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3L3_pdiff_120113.pdf')
plot(log2(c3L3[,4]), log2(c3L3[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3R3_pdiff_120113.pdf')
plot(log2(c3R3[,4]), log2(c3R3[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/43_pdiff_120113.pdf')
plot(log2(c43[,4]), log2(c43[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

####################################################################################################
####################################################################################################

#fit<-lms

fit<-lm(cX[,4] ~ cX[,5])
summary(fit)
cor(cX[,4], cX[,5],method = c('s'))

fit<-lm(c2L[,4] ~ c2L[,5])
summary(fit)
cor(c2L[,4], c2L[,5],method = c('s'))

fit<-lm(c2R[,4] ~ c2R[,5])
summary(fit)
cor(c2R[,4], c2R[,5],method = c('s'))

fit<-lm(c3L[,4] ~ c3L[,5])
summary(fit)
cor(c3L[,4], c3L[,5],method = c('s'))

fit<-lm(c3R[,4] ~ c3R[,5])
summary(fit)
cor(c3R[,4], c3R[,5],method = c('s'))

fit<-lm(c4[,4] ~ c4[,5])
summary(fit)
cor(c4[,4], c4[,5],method = c('s'))

####################################################################################################

#fit<-lms

fit<-lm(cX2[,4] ~ cX2[,5])
summary(fit)
cor(cX2[,4], cX2[,5],method = c('s'))

fit<-lm(c2L2[,4] ~ c2L2[,5])
summary(fit)
cor(c2L2[,4], c2L2[,5],method = c('s'))

fit<-lm(c2R2[,4] ~ c2R2[,5])
summary(fit)
cor(c2R2[,4], c2R2[,5],method = c('s'))

fit<-lm(c3L2[,4] ~ c3L2[,5])
summary(fit)
cor(c3L2[,4], c3L2[,5],method = c('s'))

fit<-lm(c3R2[,4] ~ c3R2[,5])
summary(fit)
cor(c3R2[,4], c3R2[,5],method = c('s'))

fit<-lm(c42[,4] ~ c42[,5])
summary(fit)
cor(c42[,4], c42[,5],method = c('s'))

####################################################################################################

#fit<-lms

fit<-lm(cX3[,4] ~ cX3[,5])
summary(fit)
cor(cX3[,4], cX3[,5],method = c('s'))

fit<-lm(c2L3[,4] ~ c2L3[,5])
summary(fit)
cor(c2L3[,4], c2L3[,5],method = c('s'))

fit<-lm(c2R3[,4] ~ c2R3[,5])
summary(fit)
cor(c2R3[,4], c2R3[,5],method = c('s'))

fit<-lm(c3L3[,4] ~ c3L3[,5])
summary(fit)
cor(c3L3[,4], c3L3[,5],method = c('s'))

fit<-lm(c3R3[,4] ~ c3R3[,5])
summary(fit)
cor(c3R3[,4], c3R3[,5],method = c('s'))

fit<-lm(c43[,4] ~ c43[,5])
summary(fit)
cor(c43[,4], c43[,5],method = c('s'))

####################################################################################################
####################################################################################################

#plots cis

pdf(file='/final/separate/X_cis_120113.pdf')
plot(log2(cX[,15]), log2(cX[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2L_cis_120113.pdf')
plot(log2(c2L[,15]), log2(c2L[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2R_cis_120113.pdf')
plot(log2(c2R[,15]), log2(c2R[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3L_cis_120113.pdf')
plot(log2(c3L[,15]), log2(c3L[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3R_cis_120113.pdf')
plot(log2(c3R[,15]), log2(c3R[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/4_cis_120113.pdf')
plot(log2(c4[,15]), log2(c4[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

####################################################################################################

pdf(file='/final/separate/X2_cis_120113.pdf')
plot(log2(cX2[,15]), log2(cX2[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2L2_cis_120113.pdf')
plot(log2(c2L2[,15]), log2(c2L2[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2R2_cis_120113.pdf')
plot(log2(c2R2[,15]), log2(c2R2[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3L2_cis_120113.pdf')
plot(log2(c3L2[,15]), log2(c3L2[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3R2_cis_120113.pdf')
plot(log2(c3R2[,15]), log2(c3R2[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/42_cis_120113.pdf')
plot(log2(c42[,15]), log2(c42[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

####################################################################################################

#plots

pdf(file='/final/separate/X3_cis_120113.pdf')
plot(log2(cX3[,15]), log2(cX3[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2L3_cis_120113.pdf')
plot(log2(c2L3[,15]), log2(c2L3[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2R3_cis_120113.pdf')
plot(log2(c2R3[,15]), log2(c2R3[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3L3_cis_120113.pdf')
plot(log2(c3L3[,15]), log2(c3L3[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3R3_cis_120113.pdf')
plot(log2(c3R3[,15]), log2(c3R3[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/43_cis_120113.pdf')
plot(log2(c43[,15]), log2(c43[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

####################################################################################################
####################################################################################################

#fit<-lms

fit<-lm(cX[,15] ~ cX[,16])
summary(fit)
cor(cX[,15], cX[,16],method = c('s'))

fit<-lm(c2L[,15] ~ c2L[,16])
summary(fit)
cor(c2L[,15], c2L[,16],method = c('s'))

fit<-lm(c2R[,15] ~ c2R[,16])
summary(fit)
cor(c2R[,15], c2R[,16],method = c('s'))

fit<-lm(c3L[,15] ~ c3L[,16])
summary(fit)
cor(c3L[,15], c3L[,16],method = c('s'))

fit<-lm(c3R[,15] ~ c3R[,16])
summary(fit)
cor(c3R[,15], c3R[,16],method = c('s'))

fit<-lm(c4[,15] ~ c4[,16])
summary(fit)
cor(c4[,15], c4[,16],method = c('s'))

####################################################################################################

#fit<-lms

fit<-lm(cX2[,15] ~ cX2[,16])
summary(fit)
cor(cX2[,15], cX2[,16],method = c('s'))

fit<-lm(c2L2[,15] ~ c2L2[,16])
summary(fit)
cor(c2L2[,15], c2L2[,16],method = c('s'))

fit<-lm(c2R2[,15] ~ c2R2[,16])
summary(fit)
cor(c2R2[,15], c2R2[,16],method = c('s'))

fit<-lm(c3L2[,15] ~ c3L2[,16])
summary(fit)
cor(c3L2[,15], c3L2[,16],method = c('s'))

fit<-lm(c3R2[,15] ~ c3R2[,16])
summary(fit)
cor(c3R2[,15], c3R2[,16],method = c('s'))

fit<-lm(c42[,15] ~ c42[,16])
summary(fit)
cor(c42[,15], c42[,16],method = c('s'))

####################################################################################################

#fit<-lms

fit<-lm(cX3[,15] ~ cX3[,16])
summary(fit)
cor(cX3[,15], cX3[,16],method = c('s'))

fit<-lm(c2L3[,15] ~ c2L3[,16])
summary(fit)
cor(c2L3[,15], c2L3[,16],method = c('s'))

fit<-lm(c2R3[,15] ~ c2R3[,16])
summary(fit)
cor(c2R3[,15], c2R3[,16],method = c('s'))

fit<-lm(c3L3[,15] ~ c3L3[,16])
summary(fit)
cor(c3L3[,15], c3L3[,16],method = c('s'))

fit<-lm(c3R3[,15] ~ c3R3[,16])
summary(fit)
cor(c3R3[,15], c3R3[,16],method = c('s'))

fit<-lm(c43[,15] ~ c43[,16])
summary(fit)
cor(c43[,15], c43[,16],method = c('s'))

####################################################################################################
####################################################################################################
####################################################################################################
####################################################################################################

PERCENTCIS='PERCENTCIS'
PERCENTCIS
summary(cX[,34])
summary(c2L[,34])
summary(c2R[,34])
summary(c3L[,34])
summary(c3R[,34])
summary(c4[,34])

 
PDIFF='PDIFF'
PDIFF
sum(cX[,37])/nrow(cX)
sum(c2L[,37])/nrow(c2L)
sum(c2R[,37])/nrow(c2R)
sum(c3L[,37])/nrow(c3L)
sum(c3R[,37])/nrow(c3R)
sum(c4[,37])/nrow(c4)

CIS='CIS'
CIS
sum(cX[,38])/nrow(cX)
sum(c2L[,38])/nrow(c2L)
sum(c2R[,38])/nrow(c2R)
sum(c3L[,38])/nrow(c3L)
sum(c3R[,38])/nrow(c3R)
sum(c4[,38])/nrow(c4)

TRANS='TRANS'
TRANS
sum(cX[,39])/nrow(cX)
sum(c2L[,39])/nrow(c2L)
sum(c2R[,39])/nrow(c2R)
sum(c3L[,39])/nrow(c3L)
sum(c3R[,39])/nrow(c3R)
sum(c4[,39])/nrow(c4)

DIVERGEDREG='DIVERGEDREG'
DIVERGEDREG
nrow(subset(cX, (cX[,38] == 1 | cX[,39] == 1)))/nrow(cX)
nrow(subset(c2L, (c2L[,38] == 1 | c2L[,39] == 1)))/nrow(c2L)
nrow(subset(c2R, (c2R[,38] == 1 | c2R[,39] == 1)))/nrow(c2R)
nrow(subset(c3L, (c3L[,38] == 1 | c3L[,39] == 1)))/nrow(c3L)
nrow(subset(c3R, (c3R[,38] == 1 | c3R[,39] == 1)))/nrow(c3R)
nrow(subset(c4, (c4[,38] == 1 | c4[,39] == 1)))/nrow(c4)

ONECHANGE='ONECHANGE'
ONECHANGE
(sum(cX[,40])+sum(cX[,41]))/(nrow(cX)-sum(cX[,42])-sum(cX[,44]))
(sum(c2L[,40])+sum(c2L[,41]))/(nrow(c2L)-sum(c2L[,42])-sum(c2L[,44]))
(sum(c2R[,40])+sum(c2R[,41]))/(nrow(c2R)-sum(c2R[,42])-sum(c2R[,44]))
(sum(c3L[,40])+sum(c3L[,41]))/(nrow(c3L)-sum(c3L[,42])-sum(c3L[,44]))
(sum(c3R[,40])+sum(c3R[,41]))/(nrow(c3R)-sum(c3R[,42])-sum(c3R[,44]))
(sum(c4[,40])+sum(c4[,41]))/(nrow(c4)-sum(c4[,42])-sum(c4[,44]))


ALLCIS='ALLCIS'
ALLCIS
sum(cX[,40])/nrow(cX)
sum(c2L[,40])/nrow(c2L)
sum(c2R[,40])/nrow(c2R)
sum(c3L[,40])/nrow(c3L)
sum(c3R[,40])/nrow(c3R)
sum(c4[,40])/nrow(c4)

ALLTRANS='ALLTRANS'
ALLTRANS
sum(cX[,41])/nrow(cX)
sum(c2L[,41])/nrow(c2L)
sum(c2R[,41])/nrow(c2R)
sum(c3L[,41])/nrow(c3L)
sum(c3R[,41])/nrow(c3R)
sum(c4[,41])/nrow(c4)

CONSERVED='CONSERVED'
CONSERVED
sum(cX[,42])/nrow(cX)
sum(c2L[,42])/nrow(c2L)
sum(c2R[,42])/nrow(c2R)
sum(c3L[,42])/nrow(c3L)
sum(c3R[,42])/nrow(c3R)
sum(c4[,42])/nrow(c4)

TWOCHANGE='TWOCHANGE'
TWOCHANGE
(sum(cX[,43])+sum(cX[,45])+sum(cX[,46]))/(nrow(cX)-sum(cX[,42])-sum(cX[,44]))
(sum(c2L[,43])+sum(c2L[,45])+sum(c2L[,46]))/(nrow(c2L)-sum(c2L[,42])-sum(c2L[,44]))
(sum(c2R[,43])+sum(c2R[,45])+sum(c2R[,46]))/(nrow(c2R)-sum(c2R[,42])-sum(c2R[,44]))
(sum(c3L[,43])+sum(c3L[,45])+sum(c3L[,46]))/(nrow(c3L)-sum(c3L[,42])-sum(c3L[,44]))
(sum(c3R[,43])+sum(c3R[,45])+sum(c3R[,46]))/(nrow(c3R)-sum(c3R[,42])-sum(c3R[,44]))
(sum(c4[,43])+sum(c4[,45])+sum(c4[,46]))/(nrow(c4)-sum(c4[,42])-sum(c4[,44]))


COMPENSATORY='COMPENSATORY'
COMPENSATORY
sum(cX[,43])/nrow(cX)
sum(c2L[,43])/nrow(c2L)
sum(c2R[,43])/nrow(c2R)
sum(c3L[,43])/nrow(c3L)
sum(c3R[,43])/nrow(c3R)
sum(c4[,43])/nrow(c4)

AMBIGUOUS='AMBIGUOUS'
AMBIGUOUS
sum(cX[,44])/nrow(cX)
sum(c2L[,44])/nrow(c2L)
sum(c2R[,44])/nrow(c2R)
sum(c3L[,44])/nrow(c3L)
sum(c3R[,44])/nrow(c3R)
sum(c4[,44])/nrow(c4)

CISPLUSTRANS='CISPLUSTRANS'
CISPLUSTRANS
sum(cX[,45])/nrow(cX)
sum(c2L[,45])/nrow(c2L)
sum(c2R[,45])/nrow(c2R)
sum(c3L[,45])/nrow(c3L)
sum(c3R[,45])/nrow(c3R)
sum(c4[,45])/nrow(c4)

CISBYTRANS='CISBYTRANS'
CISBYTRANS
sum(cX[,46])/nrow(cX)
sum(c2L[,46])/nrow(c2L)
sum(c2R[,46])/nrow(c2R)
sum(c3L[,46])/nrow(c3L)
sum(c3R[,46])/nrow(c3R)
sum(c4[,46])/nrow(c4)

ADDITIVE='ADDITIVE'
ADDITIVE
sum(cX[,47])/nrow(cX)
sum(c2L[,47])/nrow(c2L)
sum(c2R[,47])/nrow(c2R)
sum(c3L[,47])/nrow(c3L)
sum(c3R[,47])/nrow(c3R)
sum(c4[,47])/nrow(c4)

UNDERDOMINANT='UNDERDOMINANT'
UNDERDOMINANT
sum(cX[,48])/nrow(cX)
sum(c2L[,48])/nrow(c2L)
sum(c2R[,48])/nrow(c2R)
sum(c3L[,48])/nrow(c3L)
sum(c3R[,48])/nrow(c3R)
sum(c4[,48])/nrow(c4)

OVERDOMINANT='OVERDOMINANT'
OVERDOMINANT
sum(cX[,49])/nrow(cX)
sum(c2L[,49])/nrow(c2L)
sum(c2R[,49])/nrow(c2R)
sum(c3L[,49])/nrow(c3L)
sum(c3R[,49])/nrow(c3R)
sum(c4[,49])/nrow(c4)

MISEXPRESSED='MISEXPRESSED'
MISEXPRESSED
(sum(cX[,49])+sum(cX[,50]))/nrow(cX)
(sum(c2L[,49])+sum(c2L[,50]))/nrow(c2L)
(sum(c2R[,49])+sum(c2R[,50]))/nrow(c2R)
(sum(c3L[,49])+sum(c3L[,50]))/nrow(c3L)
(sum(c3R[,49])+sum(c3R[,50]))/nrow(c3R)
(sum(c4[,49])+sum(c4[,50]))/nrow(c4)

PAR2DOMINANT='PAR2DOMINANT'
PAR2DOMINANT
sum(cX[,50])/nrow(cX)
sum(c2L[,50])/nrow(c2L)
sum(c2R[,50])/nrow(c2R)
sum(c3L[,50])/nrow(c3L)
sum(c3R[,50])/nrow(c3R)
sum(c4[,50])/nrow(c4)

PAR1DOMINANT='PAR1DOMINANT'
PAR1DOMINANT
sum(cX[,51])/nrow(cX)
sum(c2L[,51])/nrow(c2L)
sum(c2R[,51])/nrow(c2R)
sum(c3L[,51])/nrow(c3L)
sum(c3R[,51])/nrow(c3R)
sum(c4[,51])/nrow(c4)

CONSERVED2='CONSERVED2'
CONSERVED2
sum(cX[,52])/nrow(cX)
sum(c2L[,52])/nrow(c2L)
sum(c2R[,52])/nrow(c2R)
sum(c3L[,52])/nrow(c3L)
sum(c3R[,52])/nrow(c3R)
sum(c4[,52])/nrow(c4)


cor(cX[,4],cX[,5],method = "s")
cor(cX[,4],cX[,5],method = "p")
fit1<-lm(cX[,4]~cX[,5])
summary(fit1)

cor(c2L[,4],c2L[,5],method = "s")
cor(c2L[,4],c2L[,5],method = "p")
fit1<-lm(c2L[,4]~c2L[,5])
summary(fit1)

cor(c2R[,4],c2R[,5],method = "s")
cor(c2R[,4],c2R[,5],method = "p")
fit1<-lm(c2R[,4]~c2R[,5])
summary(fit1)

cor(c3L[,4],c3L[,5],method = "s")
cor(c3L[,4],c3L[,5],method = "p")
fit1<-lm(c3L[,4]~c3L[,5])
summary(fit1)

cor(c3R[,4],c3R[,5],method = "s")
cor(c3R[,4],c3R[,5],method = "p")
fit1<-lm(c3R[,4]~c3R[,5])
summary(fit1)

cor(c4[,4],c4[,5],method = "s")
cor(c4[,4],c4[,5],method = "p")
fit1<-lm(c4[,4]~c4[,5])
summary(fit1)

#cis

cor(cX[,15],cX[,16],method = "s")
cor(cX[,15],cX[,16],method = "p")
fit1<-lm(cX[,15]~cX[,16])
summary(fit1)

cor(c2L[,15],c2L[,16],method = "s")
cor(c2L[,15],c2L[,16],method = "p")
fit1<-lm(c2L[,15]~c2L[,16])
summary(fit1)

cor(c2R[,15],c2R[,16],method = "s")
cor(c2R[,15],c2R[,16],method = "p")
fit1<-lm(c2R[,15]~c2R[,16])
summary(fit1)

cor(c3L[,15],c3L[,16],method = "s")
cor(c3L[,15],c3L[,16],method = "p")
fit1<-lm(c3L[,15]~c3L[,16])
summary(fit1)

cor(c3R[,15],c3R[,16],method = "s")
cor(c3R[,15],c3R[,16],method = "p")
fit1<-lm(c3R[,15]~c3R[,16])
summary(fit1)

cor(c4[,15],c4[,16],method = "s")
cor(c4[,15],c4[,16],method = "p")
fit1<-lm(c4[,15]~c4[,16])
summary(fit1)

####################################################################################################
####################################################################################################

PERCENTCIS='PERCENTCIS'
PERCENTCIS
summary(cX2[,34])
summary(c2L2[,34])
summary(c2R2[,34])
summary(c3L2[,34])
summary(c3R2[,34])
summary(c42[,34])

 
PDIFF='PDIFF'
PDIFF
sum(cX2[,37])/nrow(cX2)
sum(c2L2[,37])/nrow(c2L2)
sum(c2R2[,37])/nrow(c2R2)
sum(c3L2[,37])/nrow(c3L2)
sum(c3R2[,37])/nrow(c3R2)
sum(c42[,37])/nrow(c42)

CIS='CIS'
CIS
sum(cX2[,38])/nrow(cX2)
sum(c2L2[,38])/nrow(c2L2)
sum(c2R2[,38])/nrow(c2R2)
sum(c3L2[,38])/nrow(c3L2)
sum(c3R2[,38])/nrow(c3R2)
sum(c42[,38])/nrow(c42)

TRANS='TRANS'
TRANS
sum(cX2[,39])/nrow(cX2)
sum(c2L2[,39])/nrow(c2L2)
sum(c2R2[,39])/nrow(c2R2)
sum(c3L2[,39])/nrow(c3L2)
sum(c3R2[,39])/nrow(c3R2)
sum(c42[,39])/nrow(c42)

DIVERGEDREG='DIVERGEDREG'
DIVERGEDREG
nrow(subset(cX2, (cX2[,38] == 1 | cX2[,39] == 1)))/nrow(cX2)
nrow(subset(c2L2, (c2L2[,38] == 1 | c2L2[,39] == 1)))/nrow(c2L2)
nrow(subset(c2R2, (c2R2[,38] == 1 | c2R2[,39] == 1)))/nrow(c2R2)
nrow(subset(c3L2, (c3L2[,38] == 1 | c3L2[,39] == 1)))/nrow(c3L2)
nrow(subset(c3R2, (c3R2[,38] == 1 | c3R2[,39] == 1)))/nrow(c3R2)
nrow(subset(c42, (c42[,38] == 1 | c42[,39] == 1)))/nrow(c42)

ONECHANGE='ONECHANGE'
ONECHANGE
(sum(cX2[,40])+sum(cX2[,41]))/(nrow(cX2)-sum(cX2[,42])-sum(cX2[,44]))
(sum(c2L2[,40])+sum(c2L2[,41]))/(nrow(c2L2)-sum(c2L2[,42])-sum(c2L2[,44]))
(sum(c2R2[,40])+sum(c2R2[,41]))/(nrow(c2R2)-sum(c2R2[,42])-sum(c2R2[,44]))
(sum(c3L2[,40])+sum(c3L2[,41]))/(nrow(c3L2)-sum(c3L2[,42])-sum(c3L2[,44]))
(sum(c3R2[,40])+sum(c3R2[,41]))/(nrow(c3R2)-sum(c3R2[,42])-sum(c3R2[,44]))
(sum(c42[,40])+sum(c42[,41]))/(nrow(c42)-sum(c42[,42])-sum(c42[,44]))


ALLCIS='ALLCIS'
ALLCIS
sum(cX2[,40])/nrow(cX2)
sum(c2L2[,40])/nrow(c2L2)
sum(c2R2[,40])/nrow(c2R2)
sum(c3L2[,40])/nrow(c3L2)
sum(c3R2[,40])/nrow(c3R2)
sum(c42[,40])/nrow(c42)

ALLTRANS='ALLTRANS'
ALLTRANS
sum(cX2[,41])/nrow(cX2)
sum(c2L2[,41])/nrow(c2L2)
sum(c2R2[,41])/nrow(c2R2)
sum(c3L2[,41])/nrow(c3L2)
sum(c3R2[,41])/nrow(c3R2)
sum(c42[,41])/nrow(c42)

CONSERVED='CONSERVED'
CONSERVED
sum(cX2[,42])/nrow(cX2)
sum(c2L2[,42])/nrow(c2L2)
sum(c2R2[,42])/nrow(c2R2)
sum(c3L2[,42])/nrow(c3L2)
sum(c3R2[,42])/nrow(c3R2)
sum(c42[,42])/nrow(c42)

TWOCHANGE='TWOCHANGE'
TWOCHANGE
(sum(cX2[,43])+sum(cX2[,45])+sum(cX2[,46]))/(nrow(cX2)-sum(cX2[,42])-sum(cX2[,44]))
(sum(c2L2[,43])+sum(c2L2[,45])+sum(c2L2[,46]))/(nrow(c2L2)-sum(c2L2[,42])-sum(c2L2[,44]))
(sum(c2R2[,43])+sum(c2R2[,45])+sum(c2R2[,46]))/(nrow(c2R2)-sum(c2R2[,42])-sum(c2R2[,44]))
(sum(c3L2[,43])+sum(c3L2[,45])+sum(c3L2[,46]))/(nrow(c3L2)-sum(c3L2[,42])-sum(c3L2[,44]))
(sum(c3R2[,43])+sum(c3R2[,45])+sum(c3R2[,46]))/(nrow(c3R2)-sum(c3R2[,42])-sum(c3R2[,44]))
(sum(c42[,43])+sum(c42[,45])+sum(c42[,46]))/(nrow(c42)-sum(c42[,42])-sum(c42[,44]))


COMPENSATORY='COMPENSATORY'
COMPENSATORY
sum(cX2[,43])/nrow(cX2)
sum(c2L2[,43])/nrow(c2L2)
sum(c2R2[,43])/nrow(c2R2)
sum(c3L2[,43])/nrow(c3L2)
sum(c3R2[,43])/nrow(c3R2)
sum(c42[,43])/nrow(c42)

AMBIGUOUS='AMBIGUOUS'
AMBIGUOUS
sum(cX2[,44])/nrow(cX2)
sum(c2L2[,44])/nrow(c2L2)
sum(c2R2[,44])/nrow(c2R2)
sum(c3L2[,44])/nrow(c3L2)
sum(c3R2[,44])/nrow(c3R2)
sum(c42[,44])/nrow(c42)

CISPLUSTRANS='CISPLUSTRANS'
CISPLUSTRANS
sum(cX2[,45])/nrow(cX2)
sum(c2L2[,45])/nrow(c2L2)
sum(c2R2[,45])/nrow(c2R2)
sum(c3L2[,45])/nrow(c3L2)
sum(c3R2[,45])/nrow(c3R2)
sum(c42[,45])/nrow(c42)

CISBYTRANS='CISBYTRANS'
CISBYTRANS
sum(cX2[,46])/nrow(cX2)
sum(c2L2[,46])/nrow(c2L2)
sum(c2R2[,46])/nrow(c2R2)
sum(c3L2[,46])/nrow(c3L2)
sum(c3R2[,46])/nrow(c3R2)
sum(c42[,46])/nrow(c42)

ADDITIVE='ADDITIVE'
ADDITIVE
sum(cX2[,47])/nrow(cX2)
sum(c2L2[,47])/nrow(c2L2)
sum(c2R2[,47])/nrow(c2R2)
sum(c3L2[,47])/nrow(c3L2)
sum(c3R2[,47])/nrow(c3R2)
sum(c42[,47])/nrow(c42)

UNDERDOMINANT='UNDERDOMINANT'
UNDERDOMINANT
sum(cX2[,48])/nrow(cX2)
sum(c2L2[,48])/nrow(c2L2)
sum(c2R2[,48])/nrow(c2R2)
sum(c3L2[,48])/nrow(c3L2)
sum(c3R2[,48])/nrow(c3R2)
sum(c42[,48])/nrow(c42)

OVERDOMINANT='OVERDOMINANT'
OVERDOMINANT
sum(cX2[,49])/nrow(cX2)
sum(c2L2[,49])/nrow(c2L2)
sum(c2R2[,49])/nrow(c2R2)
sum(c3L2[,49])/nrow(c3L2)
sum(c3R2[,49])/nrow(c3R2)
sum(c42[,49])/nrow(c42)

MISEXPRESSED='MISEXPRESSED'
MISEXPRESSED
(sum(cX2[,49])+sum(cX2[,50]))/nrow(cX2)
(sum(c2L2[,49])+sum(c2L2[,50]))/nrow(c2L2)
(sum(c2R2[,49])+sum(c2R2[,50]))/nrow(c2R2)
(sum(c3L2[,49])+sum(c3L2[,50]))/nrow(c3L2)
(sum(c3R2[,49])+sum(c3R2[,50]))/nrow(c3R2)
(sum(c42[,49])+sum(c42[,50]))/nrow(c42)

PAR2DOMINANT='PAR2DOMINANT'
PAR2DOMINANT
sum(cX2[,50])/nrow(cX2)
sum(c2L2[,50])/nrow(c2L2)
sum(c2R2[,50])/nrow(c2R2)
sum(c3L2[,50])/nrow(c3L2)
sum(c3R2[,50])/nrow(c3R2)
sum(c42[,50])/nrow(c42)

PAR1DOMINANT='PAR1DOMINANT'
PAR1DOMINANT
sum(cX2[,51])/nrow(cX2)
sum(c2L2[,51])/nrow(c2L2)
sum(c2R2[,51])/nrow(c2R2)
sum(c3L2[,51])/nrow(c3L2)
sum(c3R2[,51])/nrow(c3R2)
sum(c42[,51])/nrow(c42)

CONSERVED2='CONSERVED2'
CONSERVED2
sum(cX2[,52])/nrow(cX2)
sum(c2L2[,52])/nrow(c2L2)
sum(c2R2[,52])/nrow(c2R2)
sum(c3L2[,52])/nrow(c3L2)
sum(c3R2[,52])/nrow(c3R2)
sum(c42[,52])/nrow(c42)


cor(cX2[,4],cX2[,5],method = "s")
cor(cX2[,4],cX2[,5],method = "p")
fit1<-lm(cX2[,4]~cX2[,5])
summary(fit1)

cor(c2L2[,4],c2L2[,5],method = "s")
cor(c2L2[,4],c2L2[,5],method = "p")
fit1<-lm(c2L2[,4]~c2L2[,5])
summary(fit1)

cor(c2R2[,4],c2R2[,5],method = "s")
cor(c2R2[,4],c2R2[,5],method = "p")
fit1<-lm(c2R2[,4]~c2R2[,5])
summary(fit1)

cor(c3L2[,4],c3L2[,5],method = "s")
cor(c3L2[,4],c3L2[,5],method = "p")
fit1<-lm(c3L2[,4]~c3L2[,5])
summary(fit1)

cor(c3R2[,4],c3R2[,5],method = "s")
cor(c3R2[,4],c3R2[,5],method = "p")
fit1<-lm(c3R2[,4]~c3R2[,5])
summary(fit1)

cor(c42[,4],c42[,5],method = "s")
cor(c42[,4],c42[,5],method = "p")
fit1<-lm(c42[,4]~c42[,5])
summary(fit1)

#cis

cor(cX2[,15],cX2[,16],method = "s")
cor(cX2[,15],cX2[,16],method = "p")
fit1<-lm(cX2[,15]~cX2[,16])
summary(fit1)

cor(c2L2[,15],c2L2[,16],method = "s")
cor(c2L2[,15],c2L2[,16],method = "p")
fit1<-lm(c2L2[,15]~c2L2[,16])
summary(fit1)

cor(c2R2[,15],c2R2[,16],method = "s")
cor(c2R2[,15],c2R2[,16],method = "p")
fit1<-lm(c2R2[,15]~c2R2[,16])
summary(fit1)

cor(c3L2[,15],c3L2[,16],method = "s")
cor(c3L2[,15],c3L2[,16],method = "p")
fit1<-lm(c3L2[,15]~c3L2[,16])
summary(fit1)

cor(c3R2[,15],c3R2[,16],method = "s")
cor(c3R2[,15],c3R2[,16],method = "p")
fit1<-lm(c3R2[,15]~c3R2[,16])
summary(fit1)

cor(c42[,15],c42[,16],method = "s")
cor(c42[,15],c42[,16],method = "p")
fit1<-lm(c42[,15]~c42[,16])
summary(fit1)

####################################################################################################
####################################################################################################

PERCENTCIS='PERCENTCIS'
PERCENTCIS
summary(cX3[,34])
summary(c2L3[,34])
summary(c2R3[,34])
summary(c3L3[,34])
summary(c3R3[,34])
summary(c43[,34])

 
PDIFF='PDIFF'
PDIFF
sum(cX3[,37])/nrow(cX3)
sum(c2L3[,37])/nrow(c2L3)
sum(c2R3[,37])/nrow(c2R3)
sum(c3L3[,37])/nrow(c3L3)
sum(c3R3[,37])/nrow(c3R3)
sum(c43[,37])/nrow(c43)

CIS='CIS'
CIS
sum(cX3[,38])/nrow(cX3)
sum(c2L3[,38])/nrow(c2L3)
sum(c2R3[,38])/nrow(c2R3)
sum(c3L3[,38])/nrow(c3L3)
sum(c3R3[,38])/nrow(c3R3)
sum(c43[,38])/nrow(c43)

TRANS='TRANS'
TRANS
sum(cX3[,39])/nrow(cX3)
sum(c2L3[,39])/nrow(c2L3)
sum(c2R3[,39])/nrow(c2R3)
sum(c3L3[,39])/nrow(c3L3)
sum(c3R3[,39])/nrow(c3R3)
sum(c43[,39])/nrow(c43)

DIVERGEDREG='DIVERGEDREG'
DIVERGEDREG
nrow(subset(cX3, (cX3[,38] == 1 | cX3[,39] == 1)))/nrow(cX3)
nrow(subset(c2L3, (c2L3[,38] == 1 | c2L3[,39] == 1)))/nrow(c2L3)
nrow(subset(c2R3, (c2R3[,38] == 1 | c2R3[,39] == 1)))/nrow(c2R3)
nrow(subset(c3L3, (c3L3[,38] == 1 | c3L3[,39] == 1)))/nrow(c3L3)
nrow(subset(c3R3, (c3R3[,38] == 1 | c3R3[,39] == 1)))/nrow(c3R3)
nrow(subset(c43, (c43[,38] == 1 | c43[,39] == 1)))/nrow(c43)

ONECHANGE='ONECHANGE'
ONECHANGE
(sum(cX3[,40])+sum(cX3[,41]))/(nrow(cX3)-sum(cX3[,42])-sum(cX3[,44]))
(sum(c2L3[,40])+sum(c2L3[,41]))/(nrow(c2L3)-sum(c2L3[,42])-sum(c2L3[,44]))
(sum(c2R3[,40])+sum(c2R3[,41]))/(nrow(c2R3)-sum(c2R3[,42])-sum(c2R3[,44]))
(sum(c3L3[,40])+sum(c3L3[,41]))/(nrow(c3L3)-sum(c3L3[,42])-sum(c3L3[,44]))
(sum(c3R3[,40])+sum(c3R3[,41]))/(nrow(c3R3)-sum(c3R3[,42])-sum(c3R3[,44]))
(sum(c43[,40])+sum(c43[,41]))/(nrow(c43)-sum(c43[,42])-sum(c43[,44]))


ALLCIS='ALLCIS'
ALLCIS
sum(cX3[,40])/nrow(cX3)
sum(c2L3[,40])/nrow(c2L3)
sum(c2R3[,40])/nrow(c2R3)
sum(c3L3[,40])/nrow(c3L3)
sum(c3R3[,40])/nrow(c3R3)
sum(c43[,40])/nrow(c43)

ALLTRANS='ALLTRANS'
ALLTRANS
sum(cX3[,41])/nrow(cX3)
sum(c2L3[,41])/nrow(c2L3)
sum(c2R3[,41])/nrow(c2R3)
sum(c3L3[,41])/nrow(c3L3)
sum(c3R3[,41])/nrow(c3R3)
sum(c43[,41])/nrow(c43)

CONSERVED='CONSERVED'
CONSERVED
sum(cX3[,42])/nrow(cX3)
sum(c2L3[,42])/nrow(c2L3)
sum(c2R3[,42])/nrow(c2R3)
sum(c3L3[,42])/nrow(c3L3)
sum(c3R3[,42])/nrow(c3R3)
sum(c43[,42])/nrow(c43)

TWOCHANGE='TWOCHANGE'
TWOCHANGE
(sum(cX3[,43])+sum(cX3[,45])+sum(cX3[,46]))/(nrow(cX3)-sum(cX3[,42])-sum(cX3[,44]))
(sum(c2L3[,43])+sum(c2L3[,45])+sum(c2L3[,46]))/(nrow(c2L3)-sum(c2L3[,42])-sum(c2L3[,44]))
(sum(c2R3[,43])+sum(c2R3[,45])+sum(c2R3[,46]))/(nrow(c2R3)-sum(c2R3[,42])-sum(c2R3[,44]))
(sum(c3L3[,43])+sum(c3L3[,45])+sum(c3L3[,46]))/(nrow(c3L3)-sum(c3L3[,42])-sum(c3L3[,44]))
(sum(c3R3[,43])+sum(c3R3[,45])+sum(c3R3[,46]))/(nrow(c3R3)-sum(c3R3[,42])-sum(c3R3[,44]))
(sum(c43[,43])+sum(c43[,45])+sum(c43[,46]))/(nrow(c43)-sum(c43[,42])-sum(c43[,44]))


COMPENSATORY='COMPENSATORY'
COMPENSATORY
sum(cX3[,43])/nrow(cX3)
sum(c2L3[,43])/nrow(c2L3)
sum(c2R3[,43])/nrow(c2R3)
sum(c3L3[,43])/nrow(c3L3)
sum(c3R3[,43])/nrow(c3R3)
sum(c43[,43])/nrow(c43)

AMBIGUOUS='AMBIGUOUS'
AMBIGUOUS
sum(cX3[,44])/nrow(cX3)
sum(c2L3[,44])/nrow(c2L3)
sum(c2R3[,44])/nrow(c2R3)
sum(c3L3[,44])/nrow(c3L3)
sum(c3R3[,44])/nrow(c3R3)
sum(c43[,44])/nrow(c43)

CISPLUSTRANS='CISPLUSTRANS'
CISPLUSTRANS
sum(cX3[,45])/nrow(cX3)
sum(c2L3[,45])/nrow(c2L3)
sum(c2R3[,45])/nrow(c2R3)
sum(c3L3[,45])/nrow(c3L3)
sum(c3R3[,45])/nrow(c3R3)
sum(c43[,45])/nrow(c43)

CISBYTRANS='CISBYTRANS'
CISBYTRANS
sum(cX3[,46])/nrow(cX3)
sum(c2L3[,46])/nrow(c2L3)
sum(c2R3[,46])/nrow(c2R3)
sum(c3L3[,46])/nrow(c3L3)
sum(c3R3[,46])/nrow(c3R3)
sum(c43[,46])/nrow(c43)

ADDITIVE='ADDITIVE'
ADDITIVE
sum(cX3[,47])/nrow(cX3)
sum(c2L3[,47])/nrow(c2L3)
sum(c2R3[,47])/nrow(c2R3)
sum(c3L3[,47])/nrow(c3L3)
sum(c3R3[,47])/nrow(c3R3)
sum(c43[,47])/nrow(c43)

UNDERDOMINANT='UNDERDOMINANT'
UNDERDOMINANT
sum(cX3[,48])/nrow(cX3)
sum(c2L3[,48])/nrow(c2L3)
sum(c2R3[,48])/nrow(c2R3)
sum(c3L3[,48])/nrow(c3L3)
sum(c3R3[,48])/nrow(c3R3)
sum(c43[,48])/nrow(c43)

OVERDOMINANT='OVERDOMINANT'
OVERDOMINANT
sum(cX3[,49])/nrow(cX3)
sum(c2L3[,49])/nrow(c2L3)
sum(c2R3[,49])/nrow(c2R3)
sum(c3L3[,49])/nrow(c3L3)
sum(c3R3[,49])/nrow(c3R3)
sum(c43[,49])/nrow(c43)

MISEXPRESSED='MISEXPRESSED'
MISEXPRESSED
(sum(cX3[,49])+sum(cX3[,50]))/nrow(cX3)
(sum(c2L3[,49])+sum(c2L3[,50]))/nrow(c2L3)
(sum(c2R3[,49])+sum(c2R3[,50]))/nrow(c2R3)
(sum(c3L3[,49])+sum(c3L3[,50]))/nrow(c3L3)
(sum(c3R3[,49])+sum(c3R3[,50]))/nrow(c3R3)
(sum(c43[,49])+sum(c43[,50]))/nrow(c43)

PAR2DOMINANT='PAR2DOMINANT'
PAR2DOMINANT
sum(cX3[,50])/nrow(cX3)
sum(c2L3[,50])/nrow(c2L3)
sum(c2R3[,50])/nrow(c2R3)
sum(c3L3[,50])/nrow(c3L3)
sum(c3R3[,50])/nrow(c3R3)
sum(c43[,50])/nrow(c43)

PAR1DOMINANT='PAR1DOMINANT'
PAR1DOMINANT
sum(cX3[,51])/nrow(cX3)
sum(c2L3[,51])/nrow(c2L3)
sum(c2R3[,51])/nrow(c2R3)
sum(c3L3[,51])/nrow(c3L3)
sum(c3R3[,51])/nrow(c3R3)
sum(c43[,51])/nrow(c43)

CONSERVED2='CONSERVED2'
CONSERVED2
sum(cX3[,52])/nrow(cX3)
sum(c2L3[,52])/nrow(c2L3)
sum(c2R3[,52])/nrow(c2R3)
sum(c3L3[,52])/nrow(c3L3)
sum(c3R3[,52])/nrow(c3R3)
sum(c43[,52])/nrow(c43)


cor(cX3[,4],cX3[,5],method = "s")
cor(cX3[,4],cX3[,5],method = "p")
fit1<-lm(cX3[,4]~cX3[,5])
summary(fit1)

cor(c2L3[,4],c2L3[,5],method = "s")
cor(c2L3[,4],c2L3[,5],method = "p")
fit1<-lm(c2L3[,4]~c2L3[,5])
summary(fit1)

cor(c2R3[,4],c2R3[,5],method = "s")
cor(c2R3[,4],c2R3[,5],method = "p")
fit1<-lm(c2R3[,4]~c2R3[,5])
summary(fit1)

cor(c3L3[,4],c3L3[,5],method = "s")
cor(c3L3[,4],c3L3[,5],method = "p")
fit1<-lm(c3L3[,4]~c3L3[,5])
summary(fit1)

cor(c3R3[,4],c3R3[,5],method = "s")
cor(c3R3[,4],c3R3[,5],method = "p")
fit1<-lm(c3R3[,4]~c3R3[,5])
summary(fit1)

cor(c43[,4],c43[,5],method = "s")
cor(c43[,4],c43[,5],method = "p")
fit1<-lm(c43[,4]~c43[,5])
summary(fit1)

#cis

cor(cX3[,15],cX3[,16],method = "s")
cor(cX3[,15],cX3[,16],method = "p")
fit1<-lm(cX3[,15]~cX3[,16])
summary(fit1)

cor(c2L3[,15],c2L3[,16],method = "s")
cor(c2L3[,15],c2L3[,16],method = "p")
fit1<-lm(c2L3[,15]~c2L3[,16])
summary(fit1)

cor(c2R3[,15],c2R3[,16],method = "s")
cor(c2R3[,15],c2R3[,16],method = "p")
fit1<-lm(c2R3[,15]~c2R3[,16])
summary(fit1)

cor(c3L3[,15],c3L3[,16],method = "s")
cor(c3L3[,15],c3L3[,16],method = "p")
fit1<-lm(c3L3[,15]~c3L3[,16])
summary(fit1)

cor(c3R3[,15],c3R3[,16],method = "s")
cor(c3R3[,15],c3R3[,16],method = "p")
fit1<-lm(c3R3[,15]~c3R3[,16])
summary(fit1)

cor(c43[,15],c43[,16],method = "s")
cor(c43[,15],c43[,16],method = "p")
fit1<-lm(c43[,15]~c43[,16])
summary(fit1)

rm(list=ls())

###################################################################################################
###################################################################################################

cX<-read.delim("/gene_positions/chrX_mm2_120113.txt",header = TRUE)
c2L<-read.delim("/gene_positions/chr2L_mm2_120113.txt",header = TRUE)
c2R<-read.delim("/gene_positions/chr2R_mm2_120113.txt",header = TRUE)
c3L<-read.delim("/gene_positions/chr3L_mm2_120113.txt",header = TRUE)
c3R<-read.delim("/gene_positions/chr3R_mm2_120113.txt",header = TRUE)
c4<-read.delim("/gene_positions/chr4_mm2_120113.txt",header = TRUE)

cX2<-read.delim("/gene_positions/chrX_ss2_120113.txt",header = TRUE)
c2L2<-read.delim("/gene_positions/chr2L_ss2_120113.txt",header = TRUE)
c2R2<-read.delim("/gene_positions/chr2R_ss2_120113.txt",header = TRUE)
c3L2<-read.delim("/gene_positions/chr3L_ss2_120113.txt",header = TRUE)
c3R2<-read.delim("/gene_positions/chr3R_ss2_120113.txt",header = TRUE)
c42<-read.delim("/gene_positions/chr4_ss2_120113.txt",header = TRUE)

cX3<-read.delim("/gene_positions/chrX_ms2_120113.txt",header = TRUE)
c2L3<-read.delim("/gene_positions/chr2L_ms2_120113.txt",header = TRUE)
c2R3<-read.delim("/gene_positions/chr2R_ms2_120113.txt",header = TRUE)
c3L3<-read.delim("/gene_positions/chr3L_ms2_120113.txt",header = TRUE)
c3R3<-read.delim("/gene_positions/chr3R_ms2_120113.txt",header = TRUE)
c43<-read.delim("/gene_positions/chr4_ms2_120113.txt",header = TRUE)

###################################################################################################
###################################################################################################
#plots pdiff

pdf(file='/final/separate/X_pdiff_hyb2_120113.pdf')
plot(log2(cX[,4]), log2(cX[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2L_pdiff_hyb2_120113.pdf')
plot(log2(c2L[,4]), log2(c2L[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2R_pdiff_hyb2_120113.pdf')
plot(log2(c2R[,4]), log2(c2R[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3L_pdiff_hyb2_120113.pdf')
plot(log2(c3L[,4]), log2(c3L[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3R_pdiff_hyb2_120113.pdf')
plot(log2(c3R[,4]), log2(c3R[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/4_pdiff_hyb2_120113.pdf')
plot(log2(c4[,4]), log2(c4[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

####################################################################################################

pdf(file='/final/separate/X2_pdiff_hyb2_120113.pdf')
plot(log2(cX2[,4]), log2(cX2[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2L2_pdiff_hyb2_120113.pdf')
plot(log2(c2L2[,4]), log2(c2L2[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2R2_pdiff_hyb2_120113.pdf')
plot(log2(c2R2[,4]), log2(c2R2[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3L2_pdiff_hyb2_120113.pdf')
plot(log2(c3L2[,4]), log2(c3L2[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3R2_pdiff_hyb2_120113.pdf')
plot(log2(c3R2[,4]), log2(c3R2[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/42_pdiff_hyb2_120113.pdf')
plot(log2(c42[,4]), log2(c42[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

####################################################################################################

#plots

pdf(file='/final/separate/X3_pdiff_hyb2_120113.pdf')
plot(log2(cX3[,4]), log2(cX3[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2L3_pdiff_hyb2_120113.pdf')
plot(log2(c2L3[,4]), log2(c2L3[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2R3_pdiff_hyb2_120113.pdf')
plot(log2(c2R3[,4]), log2(c2R3[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3L3_pdiff_hyb2_120113.pdf')
plot(log2(c3L3[,4]), log2(c3L3[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3R3_pdiff_hyb2_120113.pdf')
plot(log2(c3R3[,4]), log2(c3R3[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/43_pdiff_hyb2_120113.pdf')
plot(log2(c43[,4]), log2(c43[,5]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

####################################################################################################
####################################################################################################

#fit<-lms

fit<-lm(cX[,4] ~ cX[,5])
summary(fit)
cor(cX[,4], cX[,5],method = c('s'))

fit<-lm(c2L[,4] ~ c2L[,5])
summary(fit)
cor(c2L[,4], c2L[,5],method = c('s'))

fit<-lm(c2R[,4] ~ c2R[,5])
summary(fit)
cor(c2R[,4], c2R[,5],method = c('s'))

fit<-lm(c3L[,4] ~ c3L[,5])
summary(fit)
cor(c3L[,4], c3L[,5],method = c('s'))

fit<-lm(c3R[,4] ~ c3R[,5])
summary(fit)
cor(c3R[,4], c3R[,5],method = c('s'))

fit<-lm(c4[,4] ~ c4[,5])
summary(fit)
cor(c4[,4], c4[,5],method = c('s'))

####################################################################################################

#fit<-lms

fit<-lm(cX2[,4] ~ cX2[,5])
summary(fit)
cor(cX2[,4], cX2[,5],method = c('s'))

fit<-lm(c2L2[,4] ~ c2L2[,5])
summary(fit)
cor(c2L2[,4], c2L2[,5],method = c('s'))

fit<-lm(c2R2[,4] ~ c2R2[,5])
summary(fit)
cor(c2R2[,4], c2R2[,5],method = c('s'))

fit<-lm(c3L2[,4] ~ c3L2[,5])
summary(fit)
cor(c3L2[,4], c3L2[,5],method = c('s'))

fit<-lm(c3R2[,4] ~ c3R2[,5])
summary(fit)
cor(c3R2[,4], c3R2[,5],method = c('s'))

fit<-lm(c42[,4] ~ c42[,5])
summary(fit)
cor(c42[,4], c42[,5],method = c('s'))

####################################################################################################

#fit<-lms

fit<-lm(cX3[,4] ~ cX3[,5])
summary(fit)
cor(cX3[,4], cX3[,5],method = c('s'))

fit<-lm(c2L3[,4] ~ c2L3[,5])
summary(fit)
cor(c2L3[,4], c2L3[,5],method = c('s'))

fit<-lm(c2R3[,4] ~ c2R3[,5])
summary(fit)
cor(c2R3[,4], c2R3[,5],method = c('s'))

fit<-lm(c3L3[,4] ~ c3L3[,5])
summary(fit)
cor(c3L3[,4], c3L3[,5],method = c('s'))

fit<-lm(c3R3[,4] ~ c3R3[,5])
summary(fit)
cor(c3R3[,4], c3R3[,5],method = c('s'))

fit<-lm(c43[,4] ~ c43[,5])
summary(fit)
cor(c43[,4], c43[,5],method = c('s'))

####################################################################################################
####################################################################################################

#plots cis

pdf(file='/final/separate/X_cis_hyb2_120113.pdf')
plot(log2(cX[,15]), log2(cX[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2L_cis_hyb2_120113.pdf')
plot(log2(c2L[,15]), log2(c2L[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2R_cis_hyb2_120113.pdf')
plot(log2(c2R[,15]), log2(c2R[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3L_cis_hyb2_120113.pdf')
plot(log2(c3L[,15]), log2(c3L[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3R_cis_hyb2_120113.pdf')
plot(log2(c3R[,15]), log2(c3R[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/4_cis_hyb2_120113.pdf')
plot(log2(c4[,15]), log2(c4[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

####################################################################################################

pdf(file='/final/separate/X2_cis_hyb2_120113.pdf')
plot(log2(cX2[,15]), log2(cX2[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2L2_cis_hyb2_120113.pdf')
plot(log2(c2L2[,15]), log2(c2L2[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2R2_cis_hyb2_120113.pdf')
plot(log2(c2R2[,15]), log2(c2R2[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3L2_cis_hyb2_120113.pdf')
plot(log2(c3L2[,15]), log2(c3L2[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3R2_cis_hyb2_120113.pdf')
plot(log2(c3R2[,15]), log2(c3R2[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/42_cis_hyb2_120113.pdf')
plot(log2(c42[,15]), log2(c42[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

####################################################################################################

#plots

pdf(file='/final/separate/X3_cis_hyb2_120113.pdf')
plot(log2(cX3[,15]), log2(cX3[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2L3_cis_hyb2_120113.pdf')
plot(log2(c2L3[,15]), log2(c2L3[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/2R3_cis_hyb2_120113.pdf')
plot(log2(c2R3[,15]), log2(c2R3[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3L3_cis_hyb2_120113.pdf')
plot(log2(c3L3[,15]), log2(c3L3[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/3R3_cis_hyb2_120113.pdf')
plot(log2(c3R3[,15]), log2(c3R3[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

pdf(file='/final/separate/43_cis_hyb2_120113.pdf')
plot(log2(c43[,15]), log2(c43[,16]), col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(P1)',ylab='log2(P2)')
dev.off()

####################################################################################################
####################################################################################################

#fit<-lms

fit<-lm(cX[,15] ~ cX[,16])
summary(fit)
cor(cX[,15], cX[,16],method = c('s'))

fit<-lm(c2L[,15] ~ c2L[,16])
summary(fit)
cor(c2L[,15], c2L[,16],method = c('s'))

fit<-lm(c2R[,15] ~ c2R[,16])
summary(fit)
cor(c2R[,15], c2R[,16],method = c('s'))

fit<-lm(c3L[,15] ~ c3L[,16])
summary(fit)
cor(c3L[,15], c3L[,16],method = c('s'))

fit<-lm(c3R[,15] ~ c3R[,16])
summary(fit)
cor(c3R[,15], c3R[,16],method = c('s'))

fit<-lm(c4[,15] ~ c4[,16])
summary(fit)
cor(c4[,15], c4[,16],method = c('s'))

####################################################################################################

#fit<-lms

fit<-lm(cX2[,15] ~ cX2[,16])
summary(fit)
cor(cX2[,15], cX2[,16],method = c('s'))

fit<-lm(c2L2[,15] ~ c2L2[,16])
summary(fit)
cor(c2L2[,15], c2L2[,16],method = c('s'))

fit<-lm(c2R2[,15] ~ c2R2[,16])
summary(fit)
cor(c2R2[,15], c2R2[,16],method = c('s'))

fit<-lm(c3L2[,15] ~ c3L2[,16])
summary(fit)
cor(c3L2[,15], c3L2[,16],method = c('s'))

fit<-lm(c3R2[,15] ~ c3R2[,16])
summary(fit)
cor(c3R2[,15], c3R2[,16],method = c('s'))

fit<-lm(c42[,15] ~ c42[,16])
summary(fit)
cor(c42[,15], c42[,16],method = c('s'))

####################################################################################################

#fit<-lms

fit<-lm(cX3[,15] ~ cX3[,16])
summary(fit)
cor(cX3[,15], cX3[,16],method = c('s'))

fit<-lm(c2L3[,15] ~ c2L3[,16])
summary(fit)
cor(c2L3[,15], c2L3[,16],method = c('s'))

fit<-lm(c2R3[,15] ~ c2R3[,16])
summary(fit)
cor(c2R3[,15], c2R3[,16],method = c('s'))

fit<-lm(c3L3[,15] ~ c3L3[,16])
summary(fit)
cor(c3L3[,15], c3L3[,16],method = c('s'))

fit<-lm(c3R3[,15] ~ c3R3[,16])
summary(fit)
cor(c3R3[,15], c3R3[,16],method = c('s'))

fit<-lm(c43[,15] ~ c43[,16])
summary(fit)
cor(c43[,15], c43[,16],method = c('s'))

rm(list = ls())


####################################################################################################
####################################################################################################
#cis genomics plots hybrid 1
####################################################################################################
####################################################################################################
#load data

#mel-mel
data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/zhr+z30_zhrXz30_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

#sim-sec
data2<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

#mel-sim
data3<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

####################################################################################################
####################################################################################################
#merge data

data4<-merge(data1,data2,by = 'gene')
data5<-merge(data4,data3,by= 'gene')

####################################################################################################
####################################################################################################
#9 patterns

#30-79-128=data$logHrat = log2(data[,13]/data[,14])

one<-subset(data5, (((abs(data5[,30]) - abs(data5[,79])) > log2(1.25)) & ((abs(data5[,79]) - abs(data5[,128])) > log2(1.25))))
two<-subset(data5, (((abs(data5[,30]) - abs(data5[,79])) > log2(1.25)) & ((abs(data5[,79]) - abs(data5[,128])) < -log2(1.25))))
three<-subset(data5, (((abs(data5[,30]) - abs(data5[,79])) > log2(1.25)) & (abs((abs(data5[,79]) - abs(data5[,128]))) < log2(1.25))))
four<-subset(data5, ((abs((abs(data5[,30]) - abs(data5[,79]))) < log2(1.25)) & ((abs(data5[,79]) - abs(data5[,128])) > log2(1.25))))
five<-subset(data5, ((abs((abs(data5[,30]) - abs(data5[,79]))) < log2(1.25)) & ((abs(data5[,79]) - abs(data5[,128])) < -log2(1.25))))
six<-subset(data5, ((abs((abs(data5[,30]) - abs(data5[,79]))) < log2(1.25)) & (abs((abs(data5[,79]) - abs(data5[,128]))) < log2(1.25))))
seven<-subset(data5, (((abs(data5[,30]) - abs(data5[,79])) < -log2(1.25)) & ((abs(data5[,79]) - abs(data5[,128])) > log2(1.25))))
eight<-subset(data5, (((abs(data5[,30]) - abs(data5[,79])) < -log2(1.25)) & ((abs(data5[,79]) - abs(data5[,128])) < -log2(1.25))))
nine<-subset(data5, (((abs(data5[,30]) - abs(data5[,79])) < -log2(1.25)) & (abs((abs(data5[,79]) - abs(data5[,128]))) < log2(1.25))))

nrow(one)
nrow(two)
nrow(three)
nrow(four)
nrow(five)
nrow(six)
nrow(seven)
nrow(eight)
nrow(nine)

summary(abs(one[,30]))
summary(abs(one[,79]))
summary(abs(one[,128]))

summary(abs(two[,30]))
summary(abs(two[,79]))
summary(abs(two[,128]))

summary(abs(three[,30]))
summary(abs(three[,79]))
summary(abs(three[,128]))

summary(abs(four[,30]))
summary(abs(four[,79]))
summary(abs(four[,128]))

summary(abs(five[,30]))
summary(abs(five[,79]))
summary(abs(five[,128]))

summary(abs(six[,30]))
summary(abs(six[,79]))
summary(abs(six[,128]))

summary(abs(seven[,30]))
summary(abs(seven[,79]))
summary(abs(seven[,128]))

summary(abs(eight[,30]))
summary(abs(eight[,79]))
summary(abs(eight[,128]))

summary(abs(nine[,30]))
summary(abs(nine[,79]))
summary(abs(nine[,128]))

####################################################################################################
####################################################################################################
#plots

pdf(file='/Final/Figs/one_hybrid_120113.pdf')

one1<-cbind(abs(one[,30]),abs(one[,79]),abs(one[,128]))
one1trans<-t(one1)
one1data<-data.frame(one1)
one1data$MM=0.4171861
one1data$SS=2.866096
one1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(one1data[,4],one1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(one1data[,5],one1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(one1data[,6],one1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(one1data[,4],one1data[,1],one1data[,5],one1data[,2])
segments(one1data[,5],one1data[,2],one1data[,6],one1data[,3])

points(0.4171861,1.47,col = 'red',pch=19,cex=2)
points(2.866096,0.72,col = 'red',pch=19,cex=2)
points(6.367003,0.12,col = 'red',pch=19,cex=2)

segments(0.4171861,1.47,2.866096,0.72, col = 'red',lwd = 8)
segments(2.866096,0.72,6.367003,0.12, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/two_hybrid_120113.pdf')

####################################################################################################

two1<-cbind(abs(two[,30]),abs(two[,79]),abs(two[,128]))
two1trans<-t(two1)
two1data<-data.frame(two1)
two1data$MM=0.4171861
two1data$SS=2.866096
two1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(two1data[,4],two1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(two1data[,5],two1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(two1data[,6],two1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(two1data[,4],two1data[,1],two1data[,5],two1data[,2])
segments(two1data[,5],two1data[,2],two1data[,6],two1data[,3])

points(0.4171861,0.65,col = 'red',pch=19,cex=2)
points(2.866096,0.078,col = 'red',pch=19,cex=2)
points(6.367003,0.72,col = 'red',pch=19,cex=2)

segments(0.4171861,0.65,2.866096,0.078, col = 'red',lwd = 8)
segments(2.866096,0.078,6.367003,0.72, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/three_hybrid_120113.pdf')

####################################################################################################

three1<-cbind(abs(three[,30]),abs(three[,79]),abs(three[,128]))
three1trans<-t(three1)
three1data<-data.frame(three1)
three1data$MM=0.4171861
three1data$SS=2.866096
three1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(three1data[,4],three1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(three1data[,5],three1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(three1data[,6],three1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(three1data[,4],three1data[,1],three1data[,5],three1data[,2])
segments(three1data[,5],three1data[,2],three1data[,6],three1data[,3])

points(0.4171861,0.67,col = 'red',pch=19,cex=2)
points(2.866096,0.12,col = 'red',pch=19,cex=2)
points(6.367003,0.20,col = 'red',pch=19,cex=2)

segments(0.4171861,0.67,2.866096,0.12, col = 'red',lwd = 8)
segments(2.866096,0.12,6.367003,0.20, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/four_hybrid_120113.pdf')

####################################################################################################

four1<-cbind(abs(four[,30]),abs(four[,79]),abs(four[,128]))
four1trans<-t(four1)
four1data<-data.frame(four1)
four1data$MM=0.4171861
four1data$SS=2.866096
four1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(four1data[,4],four1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(four1data[,5],four1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(four1data[,6],four1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(four1data[,4],four1data[,1],four1data[,5],four1data[,2])
segments(four1data[,5],four1data[,2],four1data[,6],four1data[,3])

points(0.4171861,0.43,col = 'red',pch=19,cex=2)
points(2.866096,0.52,col = 'red',pch=19,cex=2)
points(6.367003,0.064,col = 'red',pch=19,cex=2)

segments(0.4171861,0.43,2.866096,0.52, col = 'red',lwd = 8)
segments(2.866096,0.52,6.367003,0.064, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/five_hybrid_120113.pdf')

####################################################################################################

five1<-cbind(abs(five[,30]),abs(five[,79]),abs(five[,128]))
five1trans<-t(five1)
five1data<-data.frame(five1)
five1data$MM=0.4171861
five1data$SS=2.866096
five1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(five1data[,4],five1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(five1data[,5],five1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(five1data[,6],five1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(five1data[,4],five1data[,1],five1data[,5],five1data[,2])
segments(five1data[,5],five1data[,2],five1data[,6],five1data[,3])

points(0.4171861,0.15,col = 'red',pch=19,cex=2)
points(2.866096,0.11,col = 'red',pch=19,cex=2)
points(6.367003,0.68,col = 'red',pch=19,cex=2)

segments(0.4171861,0.15,2.866096,0.11, col = 'red',lwd = 8)
segments(2.866096,0.11,6.367003,0.68, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/six_hybrid_120113.pdf')

####################################################################################################

six1<-cbind(abs(six[,30]),abs(six[,79]),abs(six[,128]))
six1trans<-t(six1)
six1data<-data.frame(six1)
six1data$MM=0.4171861
six1data$SS=2.866096
six1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(six1data[,4],six1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(six1data[,5],six1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(six1data[,6],six1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(six1data[,4],six1data[,1],six1data[,5],six1data[,2])
segments(six1data[,5],six1data[,2],six1data[,6],six1data[,3])

points(0.4171861,0.14,col = 'red',pch=19,cex=2)
points(2.866096,0.16,col = 'red',pch=19,cex=2)
points(6.367003,0.18,col = 'red',pch=19,cex=2)

segments(0.4171861,0.14,2.866096,0.16, col = 'red',lwd = 8)
segments(2.866096,0.16,6.367003,0.18, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/seven_hybrid_120113.pdf')

####################################################################################################

seven1<-cbind(abs(seven[,30]),abs(seven[,79]),abs(seven[,128]))
seven1trans<-t(seven1)
seven1data<-data.frame(seven1)
seven1data$MM=0.4171861
seven1data$SS=2.866096
seven1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(seven1data[,4],seven1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(seven1data[,5],seven1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(seven1data[,6],seven1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(seven1data[,4],seven1data[,1],seven1data[,5],seven1data[,2])
segments(seven1data[,5],seven1data[,2],seven1data[,6],seven1data[,3])

points(0.4171861,0.18,col = 'red',pch=19,cex=2)
points(2.866096,0.99,col = 'red',pch=19,cex=2)
points(6.367003,0.21,col = 'red',pch=19,cex=2)

segments(0.4171861,0.18,2.866096,0.99, col = 'red',lwd = 8)
segments(2.866096,0.99,6.367003,0.21, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/eight_hybrid_120113.pdf')

####################################################################################################

eight1<-cbind(abs(eight[,30]),abs(eight[,79]),abs(eight[,128]))
eight1trans<-t(eight1)
eight1data<-data.frame(eight1)
eight1data$MM=0.4171861
eight1data$SS=2.866096
eight1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(eight1data[,4],eight1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(eight1data[,5],eight1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(eight1data[,6],eight1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(eight1data[,4],eight1data[,1],eight1data[,5],eight1data[,2])
segments(eight1data[,5],eight1data[,2],eight1data[,6],eight1data[,3])

points(0.4171861,0.084,col = 'red',pch=19,cex=2)
points(2.866096,0.66,col = 'red',pch=19,cex=2)
points(6.367003,1.26,col = 'red',pch=19,cex=2)

segments(0.4171861,0.084,2.866096,0.66, col = 'red',lwd = 8)
segments(2.866096,0.66,6.367003,1.26, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/nine_hybrid_120113.pdf')

####################################################################################################

nine1<-cbind(abs(nine[,30]),abs(nine[,79]),abs(nine[,128]))
nine1trans<-t(nine1)
nine1data<-data.frame(nine1)
nine1data$MM=0.4171861
nine1data$SS=2.866096
nine1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(nine1data[,4],nine1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(nine1data[,5],nine1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(nine1data[,6],nine1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(nine1data[,4],nine1data[,1],nine1data[,5],nine1data[,2])
segments(nine1data[,5],nine1data[,2],nine1data[,6],nine1data[,3])

points(0.4171861,0.093,col = 'red',pch=19,cex=2)
points(2.866096,0.56,col = 'red',pch=19,cex=2)
points(6.367003,0.48,col = 'red',pch=19,cex=2)

segments(0.4171861,0.093,2.866096,0.56, col = 'red',lwd = 8)
segments(2.866096,0.56,6.367003,0.48, col = 'red',lwd = 8)

dev.off()

rm(list=ls())


####################################################################################################
####################################################################################################
#cis genomics plots hybrid 2
####################################################################################################
####################################################################################################
#load data

#mel-mel
data1<-read.delim("/Final/zhr_z30/mel-mel_P+H2/outputs/zhr+z30_z30Xzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

#sim-sec
data2<-read.delim("/Final/sim_sec/sim-sec_P+H2/outputs/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

#mel-sim
data3<-read.delim("/Final/mel_sim/mel-sim_P+H2/outputs/zhr+tsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

####################################################################################################
####################################################################################################
#merge data

data4<-merge(data1,data2,by = 'gene')
data5<-merge(data4,data3,by= 'gene')

####################################################################################################
####################################################################################################
#9 patterns

#30-79-128=data$logHrat = log2(data[,13]/data[,14])

one<-subset(data5, (((abs(data5[,30]) - abs(data5[,79])) > log2(1.25)) & ((abs(data5[,79]) - abs(data5[,128])) > log2(1.25))))
two<-subset(data5, (((abs(data5[,30]) - abs(data5[,79])) > log2(1.25)) & ((abs(data5[,79]) - abs(data5[,128])) < -log2(1.25))))
three<-subset(data5, (((abs(data5[,30]) - abs(data5[,79])) > log2(1.25)) & (abs((abs(data5[,79]) - abs(data5[,128]))) < log2(1.25))))
four<-subset(data5, ((abs((abs(data5[,30]) - abs(data5[,79]))) < log2(1.25)) & ((abs(data5[,79]) - abs(data5[,128])) > log2(1.25))))
five<-subset(data5, ((abs((abs(data5[,30]) - abs(data5[,79]))) < log2(1.25)) & ((abs(data5[,79]) - abs(data5[,128])) < -log2(1.25))))
six<-subset(data5, ((abs((abs(data5[,30]) - abs(data5[,79]))) < log2(1.25)) & (abs((abs(data5[,79]) - abs(data5[,128]))) < log2(1.25))))
seven<-subset(data5, (((abs(data5[,30]) - abs(data5[,79])) < -log2(1.25)) & ((abs(data5[,79]) - abs(data5[,128])) > log2(1.25))))
eight<-subset(data5, (((abs(data5[,30]) - abs(data5[,79])) < -log2(1.25)) & ((abs(data5[,79]) - abs(data5[,128])) < -log2(1.25))))
nine<-subset(data5, (((abs(data5[,30]) - abs(data5[,79])) < -log2(1.25)) & (abs((abs(data5[,79]) - abs(data5[,128]))) < log2(1.25))))

nrow(one)
nrow(two)
nrow(three)
nrow(four)
nrow(five)
nrow(six)
nrow(seven)
nrow(eight)
nrow(nine)

summary(abs(one[,30]))
summary(abs(one[,79]))
summary(abs(one[,128]))

summary(abs(two[,30]))
summary(abs(two[,79]))
summary(abs(two[,128]))

summary(abs(three[,30]))
summary(abs(three[,79]))
summary(abs(three[,128]))

summary(abs(four[,30]))
summary(abs(four[,79]))
summary(abs(four[,128]))

summary(abs(five[,30]))
summary(abs(five[,79]))
summary(abs(five[,128]))

summary(abs(six[,30]))
summary(abs(six[,79]))
summary(abs(six[,128]))

summary(abs(seven[,30]))
summary(abs(seven[,79]))
summary(abs(seven[,128]))

summary(abs(eight[,30]))
summary(abs(eight[,79]))
summary(abs(eight[,128]))

summary(abs(nine[,30]))
summary(abs(nine[,79]))
summary(abs(nine[,128]))

####################################################################################################
####################################################################################################
#plots

pdf(file='/Final/Figs/one_hybrid2_120113.pdf')

one1<-cbind(abs(one[,30]),abs(one[,79]),abs(one[,128]))
one1trans<-t(one1)
one1data<-data.frame(one1)
one1data$MM=0.4171861
one1data$SS=2.866096
one1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(one1data[,4],one1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(one1data[,5],one1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(one1data[,6],one1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(one1data[,4],one1data[,1],one1data[,5],one1data[,2])
segments(one1data[,5],one1data[,2],one1data[,6],one1data[,3])

points(0.4171861,1.1930,col = 'red',pch=19,cex=2)
points(2.866096,0.6167,col = 'red',pch=19,cex=2)
points(6.367003,0.09020,col = 'red',pch=19,cex=2)

segments(0.4171861,1.1930,2.866096,0.6167, col = 'red',lwd = 8)
segments(2.866096,0.6167,6.367003,0.09020, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/two_hybrid2_120113.pdf')

####################################################################################################

two1<-cbind(abs(two[,30]),abs(two[,79]),abs(two[,128]))
two1trans<-t(two1)
two1data<-data.frame(two1)
two1data$MM=0.4171861
two1data$SS=2.866096
two1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(two1data[,4],two1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(two1data[,5],two1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(two1data[,6],two1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(two1data[,4],two1data[,1],two1data[,5],two1data[,2])
segments(two1data[,5],two1data[,2],two1data[,6],two1data[,3])

points(0.4171861,0.7105,col = 'red',pch=19,cex=2)
points(2.866096,0.1031,col = 'red',pch=19,cex=2)
points(6.367003,0.7521,col = 'red',pch=19,cex=2)

segments(0.4171861,0.7105,2.866096,0.1031, col = 'red',lwd = 8)
segments(2.866096,0.1031,6.367003,0.7521, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/three_hybrid2_120113.pdf')

####################################################################################################

three1<-cbind(abs(three[,30]),abs(three[,79]),abs(three[,128]))
three1trans<-t(three1)
three1data<-data.frame(three1)
three1data$MM=0.4171861
three1data$SS=2.866096
three1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(three1data[,4],three1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(three1data[,5],three1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(three1data[,6],three1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(three1data[,4],three1data[,1],three1data[,5],three1data[,2])
segments(three1data[,5],three1data[,2],three1data[,6],three1data[,3])

points(0.4171861,0.7030,col = 'red',pch=19,cex=2)
points(2.866096,0.1444,col = 'red',pch=19,cex=2)
points(6.367003,0.22240,col = 'red',pch=19,cex=2)

segments(0.4171861,0.7030,2.866096,0.1444, col = 'red',lwd = 8)
segments(2.866096,0.1444,6.367003,0.22240, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/four_hybrid2_120113.pdf')

####################################################################################################

four1<-cbind(abs(four[,30]),abs(four[,79]),abs(four[,128]))
four1trans<-t(four1)
four1data<-data.frame(four1)
four1data$MM=0.4171861
four1data$SS=2.866096
four1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(four1data[,4],four1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(four1data[,5],four1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(four1data[,6],four1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(four1data[,4],four1data[,1],four1data[,5],four1data[,2])
segments(four1data[,5],four1data[,2],four1data[,6],four1data[,3])

points(0.4171861,0.41500,col = 'red',pch=19,cex=2)
points(2.866096,0.5394,col = 'red',pch=19,cex=2)
points(6.367003,0.08746,col = 'red',pch=19,cex=2)

segments(0.4171861,0.41500,2.866096,0.5394, col = 'red',lwd = 8)
segments(2.866096,0.5394,6.367003,0.08746, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/five_hybrid2_120113.pdf')

####################################################################################################

five1<-cbind(abs(five[,30]),abs(five[,79]),abs(five[,128]))
five1trans<-t(five1)
five1data<-data.frame(five1)
five1data$MM=0.4171861
five1data$SS=2.866096
five1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(five1data[,4],five1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(five1data[,5],five1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(five1data[,6],five1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(five1data[,4],five1data[,1],five1data[,5],five1data[,2])
segments(five1data[,5],five1data[,2],five1data[,6],five1data[,3])

points(0.4171861,0.1844,col = 'red',pch=19,cex=2)
points(2.866096,0.1409,col = 'red',pch=19,cex=2)
points(6.367003,0.7119,col = 'red',pch=19,cex=2)

segments(0.4171861,0.1844,2.866096,0.1409, col = 'red',lwd = 8)
segments(2.866096,0.1409,6.367003,0.7119, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/six_hybrid2_120113.pdf')

####################################################################################################

six1<-cbind(abs(six[,30]),abs(six[,79]),abs(six[,128]))
six1trans<-t(six1)
six1data<-data.frame(six1)
six1data$MM=0.4171861
six1data$SS=2.866096
six1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(six1data[,4],six1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(six1data[,5],six1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(six1data[,6],six1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(six1data[,4],six1data[,1],six1data[,5],six1data[,2])
segments(six1data[,5],six1data[,2],six1data[,6],six1data[,3])

points(0.4171861,0.18220,col = 'red',pch=19,cex=2)
points(2.866096,0.2007,col = 'red',pch=19,cex=2)
points(6.367003,0.20650,col = 'red',pch=19,cex=2)

segments(0.4171861,0.18220,2.866096,0.2007, col = 'red',lwd = 8)
segments(2.866096,0.2007,6.367003,0.20650, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/seven_hybrid2_120113.pdf')

####################################################################################################

seven1<-cbind(abs(seven[,30]),abs(seven[,79]),abs(seven[,128]))
seven1trans<-t(seven1)
seven1data<-data.frame(seven1)
seven1data$MM=0.4171861
seven1data$SS=2.866096
seven1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(seven1data[,4],seven1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(seven1data[,5],seven1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(seven1data[,6],seven1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(seven1data[,4],seven1data[,1],seven1data[,5],seven1data[,2])
segments(seven1data[,5],seven1data[,2],seven1data[,6],seven1data[,3])

points(0.4171861,0.18060,col = 'red',pch=19,cex=2)
points(2.866096,0.8745,col = 'red',pch=19,cex=2)
points(6.367003,0.18060,col = 'red',pch=19,cex=2)

segments(0.4171861,0.18060,2.866096,0.8745, col = 'red',lwd = 8)
segments(2.866096,0.8745,6.367003,0.18060, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/eight_hybrid2_120113.pdf')

####################################################################################################

eight1<-cbind(abs(eight[,30]),abs(eight[,79]),abs(eight[,128]))
eight1trans<-t(eight1)
eight1data<-data.frame(eight1)
eight1data$MM=0.4171861
eight1data$SS=2.866096
eight1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(eight1data[,4],eight1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(eight1data[,5],eight1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(eight1data[,6],eight1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(eight1data[,4],eight1data[,1],eight1data[,5],eight1data[,2])
segments(eight1data[,5],eight1data[,2],eight1data[,6],eight1data[,3])

points(0.4171861,0.12050,col = 'red',pch=19,cex=2)
points(2.866096,0.6740,col = 'red',pch=19,cex=2)
points(6.367003,1.3420,col = 'red',pch=19,cex=2)

segments(0.4171861,0.12050,2.866096,0.6740, col = 'red',lwd = 8)
segments(2.866096,0.6740,6.367003,1.3420, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/nine_hybrid2_120113.pdf')

####################################################################################################

nine1<-cbind(abs(nine[,30]),abs(nine[,79]),abs(nine[,128]))
nine1trans<-t(nine1)
nine1data<-data.frame(nine1)
nine1data$MM=0.4171861
nine1data$SS=2.866096
nine1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(nine1data[,4],nine1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(nine1data[,5],nine1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(nine1data[,6],nine1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(nine1data[,4],nine1data[,1],nine1data[,5],nine1data[,2])
segments(nine1data[,5],nine1data[,2],nine1data[,6],nine1data[,3])

points(0.4171861,0.10690,col = 'red',pch=19,cex=2)
points(2.866096,0.5850,col = 'red',pch=19,cex=2)
points(6.367003,0.52080,col = 'red',pch=19,cex=2)

segments(0.4171861,0.10690,2.866096,0.5850, col = 'red',lwd = 8)
segments(2.866096,0.5850,6.367003,0.52080, col = 'red',lwd = 8)

dev.off()

rm(list=ls())

####################################################################################################
####################################################################################################
#pdiff genomics plots
####################################################################################################
####################################################################################################
#load data

#mel-mel
data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/zhr+z30_zhrXz30_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

#sim-sec
data2<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

#mel-sim
data3<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

####################################################################################################
####################################################################################################
#merge data

data4<-merge(data1,data2,by = 'gene')
data5<-merge(data4,data3,by= 'gene')

####################################################################################################
####################################################################################################

#29-78-127=data$logPrat = log2(data[,2]/data[,3])

one<-subset(data5, (((abs(data5[,29]) - abs(data5[,78])) > log2(1.25)) & ((abs(data5[,78]) - abs(data5[,127])) > log2(1.25))))
two<-subset(data5, (((abs(data5[,29]) - abs(data5[,78])) > log2(1.25)) & ((abs(data5[,78]) - abs(data5[,127])) < -log2(1.25))))
three<-subset(data5, (((abs(data5[,29]) - abs(data5[,78])) > log2(1.25)) & (abs((abs(data5[,78]) - abs(data5[,127]))) < log2(1.25))))
four<-subset(data5, ((abs((abs(data5[,29]) - abs(data5[,78]))) < log2(1.25)) & ((abs(data5[,78]) - abs(data5[,127])) > log2(1.25))))
five<-subset(data5, ((abs((abs(data5[,29]) - abs(data5[,78]))) < log2(1.25)) & ((abs(data5[,78]) - abs(data5[,127])) < -log2(1.25))))
six<-subset(data5, ((abs((abs(data5[,29]) - abs(data5[,78]))) < log2(1.25)) & (abs((abs(data5[,78]) - abs(data5[,127]))) < log2(1.25))))
seven<-subset(data5, (((abs(data5[,29]) - abs(data5[,78])) < -log2(1.25)) & ((abs(data5[,78]) - abs(data5[,127])) > log2(1.25))))
eight<-subset(data5, (((abs(data5[,29]) - abs(data5[,78])) < -log2(1.25)) & ((abs(data5[,78]) - abs(data5[,127])) < -log2(1.25))))
nine<-subset(data5, (((abs(data5[,29]) - abs(data5[,78])) < -log2(1.25)) & (abs((abs(data5[,78]) - abs(data5[,127]))) < log2(1.25))))

nrow(one)
nrow(two)
nrow(three)
nrow(four)
nrow(five)
nrow(six)
nrow(seven)
nrow(eight)
nrow(nine)

summary(abs(one[,29]))
summary(abs(one[,78]))
summary(abs(one[,127]))

summary(abs(two[,29]))
summary(abs(two[,78]))
summary(abs(two[,127]))

summary(abs(three[,29]))
summary(abs(three[,78]))
summary(abs(three[,127]))

summary(abs(four[,29]))
summary(abs(four[,78]))
summary(abs(four[,127]))

summary(abs(five[,29]))
summary(abs(five[,78]))
summary(abs(five[,127]))

summary(abs(six[,29]))
summary(abs(six[,78]))
summary(abs(six[,127]))

summary(abs(seven[,29]))
summary(abs(seven[,78]))
summary(abs(seven[,127]))

summary(abs(eight[,29]))
summary(abs(eight[,78]))
summary(abs(eight[,127]))

summary(abs(nine[,29]))
summary(abs(nine[,78]))
summary(abs(nine[,127]))




####################################################################################################
####################################################################################################
#plots

pdf(file='/Final/Figs/one_pdiff_120113.pdf')

one1<-cbind(abs(one[,29]),abs(one[,78]),abs(one[,127]))
one1trans<-t(one1)
one1data<-data.frame(one1)
one1data$MM=0.4171861
one1data$SS=2.866096
one1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(one1data[,4],one1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(one1data[,5],one1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(one1data[,6],one1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(one1data[,4],one1data[,1],one1data[,5],one1data[,2])
segments(one1data[,5],one1data[,2],one1data[,6],one1data[,3])

points(0.4171861,1.8550,col = 'red',pch=19,cex=2)
points(2.866096,0.9906,col = 'red',pch=19,cex=2)
points(6.367003,0.37070,col = 'red',pch=19,cex=2)

segments(0.4171861,1.8550,2.866096,0.9906, col = 'red',lwd = 8)
segments(2.866096,0.9906,6.367003,0.37070, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/two_pdiff_120113.pdf')

####################################################################################################

two1<-cbind(abs(two[,29]),abs(two[,78]),abs(two[,127]))
two1trans<-t(two1)
two1data<-data.frame(two1)
two1data$MM=0.4171861
two1data$SS=2.866096
two1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(two1data[,4],two1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(two1data[,5],two1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(two1data[,6],two1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(two1data[,4],two1data[,1],two1data[,5],two1data[,2])
segments(two1data[,5],two1data[,2],two1data[,6],two1data[,3])

points(0.4171861,1.0640,col = 'red',pch=19,cex=2)
points(2.866096,0.21150,col = 'red',pch=19,cex=2)
points(6.367003,1.0150,col = 'red',pch=19,cex=2)

segments(0.4171861,1.0640,2.866096,0.21150, col = 'red',lwd = 8)
segments(2.866096,0.21150,6.367003,1.0150, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/three_pdiff_120113.pdf')

####################################################################################################

three1<-cbind(abs(three[,29]),abs(three[,78]),abs(three[,127]))
three1trans<-t(three1)
three1data<-data.frame(three1)
three1data$MM=0.4171861
three1data$SS=2.866096
three1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(three1data[,4],three1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(three1data[,5],three1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(three1data[,6],three1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(three1data[,4],three1data[,1],three1data[,5],three1data[,2])
segments(three1data[,5],three1data[,2],three1data[,6],three1data[,3])

points(0.4171861,0.8074,col = 'red',pch=19,cex=2)
points(2.866096,0.2138,col = 'red',pch=19,cex=2)
points(6.367003,0.2942,col = 'red',pch=19,cex=2)

segments(0.4171861,0.8074,2.866096,0.2138, col = 'red',lwd = 8)
segments(2.866096,0.2138,6.367003,0.2942, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/four_pdiff_120113.pdf')

####################################################################################################

four1<-cbind(abs(four[,29]),abs(four[,78]),abs(four[,127]))
four1trans<-t(four1)
four1data<-data.frame(four1)
four1data$MM=0.4171861
four1data$SS=2.866096
four1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(four1data[,4],four1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(four1data[,5],four1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(four1data[,6],four1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(four1data[,4],four1data[,1],four1data[,5],four1data[,2])
segments(four1data[,5],four1data[,2],four1data[,6],four1data[,3])

points(0.4171861,0.6294,col = 'red',pch=19,cex=2)
points(2.866096,0.6674,col = 'red',pch=19,cex=2)
points(6.367003,0.1312,col = 'red',pch=19,cex=2)

segments(0.4171861,0.6294,2.866096,0.6674, col = 'red',lwd = 8)
segments(2.866096,0.6674,6.367003,0.1312, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/five_pdiff_120113.pdf')

####################################################################################################

five1<-cbind(abs(five[,29]),abs(five[,78]),abs(five[,127]))
five1trans<-t(five1)
five1data<-data.frame(five1)
five1data$MM=0.4171861
five1data$SS=2.866096
five1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(five1data[,4],five1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(five1data[,5],five1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(five1data[,6],five1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(five1data[,4],five1data[,1],five1data[,5],five1data[,2])
segments(five1data[,5],five1data[,2],five1data[,6],five1data[,3])

points(0.4171861,0.2866,col = 'red',pch=19,cex=2)
points(2.866096,0.22240,col = 'red',pch=19,cex=2)
points(6.367003,0.8202,col = 'red',pch=19,cex=2)

segments(0.4171861,0.2866,2.866096,0.22240, col = 'red',lwd = 8)
segments(2.866096,0.22240,6.367003,0.8202, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/six_pdiff_120113.pdf')

####################################################################################################

six1<-cbind(abs(six[,29]),abs(six[,78]),abs(six[,127]))
six1trans<-t(six1)
six1data<-data.frame(six1)
six1data$MM=0.4171861
six1data$SS=2.866096
six1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(six1data[,4],six1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(six1data[,5],six1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(six1data[,6],six1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(six1data[,4],six1data[,1],six1data[,5],six1data[,2])
segments(six1data[,5],six1data[,2],six1data[,6],six1data[,3])

points(0.4171861,0.2601,col = 'red',pch=19,cex=2)
points(2.866096,0.2630,col = 'red',pch=19,cex=2)
points(6.367003,0.2630,col = 'red',pch=19,cex=2)

segments(0.4171861,0.2601,2.866096,0.2630, col = 'red',lwd = 8)
segments(2.866096,0.2630,6.367003,0.2630, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/seven_pdiff_120113.pdf')

####################################################################################################

seven1<-cbind(abs(seven[,29]),abs(seven[,78]),abs(seven[,127]))
seven1trans<-t(seven1)
seven1data<-data.frame(seven1)
seven1data$MM=0.4171861
seven1data$SS=2.866096
seven1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(seven1data[,4],seven1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(seven1data[,5],seven1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(seven1data[,6],seven1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(seven1data[,4],seven1data[,1],seven1data[,5],seven1data[,2])
segments(seven1data[,5],seven1data[,2],seven1data[,6],seven1data[,3])

points(0.4171861,0.2630,col = 'red',pch=19,cex=2)
points(2.866096,1.0510,col = 'red',pch=19,cex=2)
points(6.367003,0.2630,col = 'red',pch=19,cex=2)

segments(0.4171861,0.2630,2.866096,1.0510, col = 'red',lwd = 8)
segments(2.866096,1.0510,6.367003,0.2630, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/eight_pdiff_120113.pdf')

####################################################################################################

eight1<-cbind(abs(eight[,29]),abs(eight[,78]),abs(eight[,127]))
eight1trans<-t(eight1)
eight1data<-data.frame(eight1)
eight1data$MM=0.4171861
eight1data$SS=2.866096
eight1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(eight1data[,4],eight1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(eight1data[,5],eight1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(eight1data[,6],eight1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(eight1data[,4],eight1data[,1],eight1data[,5],eight1data[,2])
segments(eight1data[,5],eight1data[,2],eight1data[,6],eight1data[,3])

points(0.4171861,0.2313,col = 'red',pch=19,cex=2)
points(2.866096,0.9434,col = 'red',pch=19,cex=2)
points(6.367003,1.8070,col = 'red',pch=19,cex=2)

segments(0.4171861,0.2313,2.866096,0.9434, col = 'red',lwd = 8)
segments(2.866096,0.9434,6.367003,1.8070, col = 'red',lwd = 8)

dev.off()

pdf(file='/Final/Figs/nine_pdiff_120113.pdf')

####################################################################################################

nine1<-cbind(abs(nine[,29]),abs(nine[,78]),abs(nine[,127]))
nine1trans<-t(nine1)
nine1data<-data.frame(nine1)
nine1data$MM=0.4171861
nine1data$SS=2.866096
nine1data$MS=6.367003

plot(c(0:7),c(0:7),type = 'n')
points(nine1data[,4],nine1data[,1],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(nine1data[,5],nine1data[,2],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
points(nine1data[,6],nine1data[,3],col=rgb(t(col2rgb("black")),maxColorValue=50),pch=19,cex=0.305)
segments(nine1data[,4],nine1data[,1],nine1data[,5],nine1data[,2])
segments(nine1data[,5],nine1data[,2],nine1data[,6],nine1data[,3])

points(0.4171861,0.1456,col = 'red',pch=19,cex=2)
points(2.866096,0.6879,col = 'red',pch=19,cex=2)
points(6.367003,0.64380,col = 'red',pch=19,cex=2)

segments(0.4171861,0.1456,2.866096,0.6879, col = 'red',lwd = 8)
segments(2.866096,0.6879,6.367003,0.64380, col = 'red',lwd = 8)

dev.off()

rm(list=ls())

####################################################################################################
####################################################################################################
#A1 vs A1
####################################################################################################
####################################################################################################
#read in data

#mel-mel
data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/zhr+z30_zhrXz30_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)
data2<-read.delim("/Final/zhr_z30/mel-mel_P+H2/outputs/zhr+z30_z30Xzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

#sim-sec
data3<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)
data4<-read.delim("/Final/sim_sec/sim-sec_P+H2/outputs/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

#mel-sim
data5<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)
data6<-read.delim("/Final/mel_sim/mel-sim_P+H2/outputs/zhr+tsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

####################################################################################################
####################################################################################################

#plots

#mel-mel H1 vs H2 zhr

pdf(file='/final/separate/MMH_zhrvszhr_120113.pdf')
plot(log2(data1[,13]),log2(data2[,13]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(zhr allele) zhrXz30',ylab='log2(zhr allele) z30Xzhr')

dev.off()

####################################################################################################

#mel-mel H1 vs H2 z30

pdf(file='/final/separate/MMH_z30vsz30_120113.pdf')
plot(log2(data1[,14]),log2(data2[,14]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(z30 allele) zhrXz30',ylab='log2(z30 allele) z30Xzhr')

dev.off()

####################################################################################################

#sim-sec H1 vs H2 sim

pdf(file='/final/separate/SSH_SIvsSI_120113.pdf')
plot(log2(data3[,13]),log2(data4[,13]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(sim allele) simXsec',ylab='log2(sim allele) secXsim')

dev.off()

####################################################################################################

#sim-sec H1 vs H2 sec

pdf(file='/final/separate/SSH_SEvsSE_120113.pdf')
plot(log2(data3[,14]),log2(data4[,14]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(sec allele) simXsec',ylab='log2(sec allele) secXsim')

dev.off()

####################################################################################################

#mel-sim H1 vs H2 mel

pdf(file='/final/separate/MSH_MvsM_120113.pdf')
plot(log2(data5[,13]),log2(data6[,13]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(mel allele) melXsim',ylab='log2(mel allele) simXmel')

dev.off()

####################################################################################################

#mel-sim H1 vs H2 sim

pdf(file='/final/separate/MSH_SvsS_120113.pdf')
plot(log2(data5[,14]),log2(data6[,14]),col=rgb(t(col2rgb("black")),alpha=255,maxColorValue=255),pch=19,cex=0.305,xlim=c(4,15),ylim=c(4,15),xlab='log2(sim allele) melXsim',ylab='log2(sim allele) simXmel')

dev.off()

####################################################################################################
####################################################################################################

#get rho

cor(data1[,13],data2[,13], method = 's')
cor(data1[,14],data2[,14], method = 's')

cor(data3[,13],data4[,13], method = 's')
cor(data3[,14],data4[,14], method = 's')

cor(data5[,13],data6[,13], method = 's')
cor(data5[,14],data6[,14], method = 's')

rm(list = ls())


####################################################################################################
####################################################################################################
#rho by chromosome in each comparison in meta data
####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chrX_mm_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MMHX_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MMHX_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr2L_mm_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MMH2L_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MMH2L_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr2R_mm_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MMH2R_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MMH2R_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr3L_mm_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MMH3L_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MMH3L_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr3R_mm_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MMH3R_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MMH3R_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr4_mm_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MMH4_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MMH4_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chrX_ss_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_SSHX_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_SSHX_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr2L_ss_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_SSH2L_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_SSH2L_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())
####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr2R_ss_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_SSH2R_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_SSH2R_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())
####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr3L_ss_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_SSH3L_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_SSH3L_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())
####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr3R_ss_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_SSH3R_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_SSH3R_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())
####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr4_ss_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_SSH4_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_SSH4_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())
####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chrX_ms_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MSHX_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MSHX_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())
####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr2L_ms_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MSH2L_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MSH2L_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())
####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr2R_ms_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MSH2R_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MSH2R_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())
####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr3L_ms_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MSH3L_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MSH3L_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())
####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr3R_ms_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MSH3R_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MSH3R_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())
####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr4_ms_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MSH4_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MSH4_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())
####################################################################################################
####################################################################################################

#rho by chromosome in each comparison in meta data
####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chrX_mm2_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MMH2X_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MMH2X_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr2L_mm2_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MMH22L_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MMH22L_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr2R_mm2_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MMH22R_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MMH22R_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr3L_mm2_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MMH23L_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MMH23L_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr3R_mm2_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MMH23R_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MMH23R_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr4_mm2_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MMH24_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MMH24_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chrX_ss2_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_SSH2X_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_SSH2X_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr2L_ss2_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_SSH22L_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_SSH22L_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())
####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr2R_ss2_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_SSH22R_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_SSH22R_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())
####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr3L_ss2_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_SSH23L_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_SSH23L_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())
####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr3R_ss2_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_SSH23R_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_SSH23R_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())
####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr4_ss2_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_SSH24_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_SSH24_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())
####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chrX_ms2_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MSH2X_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MSH2X_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())
####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr2L_ms2_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MSH22L_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MSH22L_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())
####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr2R_ms2_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MSH22R_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MSH22R_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())
####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr3L_ms2_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MSH23L_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MSH23L_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())
####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr3R_ms2_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MSH23R_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MSH23R_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())
####################################################################################################
####################################################################################################

data1<-read.delim("/gene_positions/chr4_ms2_120113.txt",header = TRUE)

cor(data1[,4],data1[,5],method = c("s"))
cor(data1[,15],data1[,16],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0


for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,5], data1_1B[,4], method = c('s'))
	value2<-cor(data1_1B[,16], data1_1B[,15], method = c('s'))
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MSH24_PB.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MSH24_HB.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

####################################################################################################
####################################################################################################
#rho by chromosome in each comparison in meta data
####################################################################################################
####################################################################################################
rm(list = ls)

dataMMX<-read.delim("/gene_positions/chrX_mm_120113.txt",header = TRUE)

data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/zhr+z30_zhrXz30_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

dataMMA<-data.frame(dataMMA<-data1[!(data1[,1] %in% dataMMX[,1]), 1])

colnames(dataMMA)<-c('gene')

dataMMA<-merge(dataMMA,data1,by = 'gene')

numberMMXP<-data.frame(numberMMXP<-cor(dataMMX[,5], dataMMX[,4], method = c('s')))
numberMMXH<-data.frame(numberMMXH<-cor(dataMMX[,16], dataMMX[,15], method = c('s')))
	
numberMMAP<-data.frame(numberMMAP<-cor(dataMMA[,3], dataMMA[,2], method = c('s')))
numberMMAH<-data.frame(numberMMAH<-cor(dataMMA[,14], dataMMA[,13], method = c('s')))
	
numberMMX_AP<-data.frame(numberMMX_AP<-(numberMMXP[,1]-numberMMAP[,1]))
numberMMX_AH<-data.frame(numberMMX_AH<-(numberMMXH[,1]-numberMMAH[,1]))

numberMMX_AP
numberMMX_AH

resultsMMXAP <- 1:20000 ; dim(resultsMMXAP) <- c(10000,2)
resultsMMXAP[,2]=0
resultsMMXAH <- 1:20000 ; dim(resultsMMXAH) <- c(10000,2)
resultsMMXAH[,2]=0


for (i in 1:10000) 
	{
	dataMMXB <- dataMMX[sample(nrow(dataMMX), replace = TRUE),]
	dataMMAB <- dataMMA[sample(nrow(dataMMA), replace = TRUE),]

	
	valueMMXP<-data.frame(valueMMXP<-cor(dataMMXB[,5], dataMMXB[,4], method = c('s')))
	valueMMXH<-data.frame(valueMMXH<-cor(dataMMXB[,16], dataMMXB[,15], method = c('s')))
	
	valueMMAP<-data.frame(valueMMAP<-cor(dataMMAB[,3], dataMMAB[,2], method = c('s')))
	valueMMAH<-data.frame(valueMMAH<-cor(dataMMAB[,14], dataMMAB[,13], method = c('s')))
	
	valueMMX_AP<-data.frame(valueMMX_AP<-(valueMMXP[,1]-valueMMAP[,1]))
	valueMMX_AH<-data.frame(valueMMX_AH<-(valueMMXH[,1]-valueMMAH[,1]))


	resultsMMXAP[i,2] = valueMMX_AP[,1]
	resultsMMXAH[i,2] = valueMMX_AH[,1]
	}
rm(i)

pvalue12<-(nrow(subset(resultsMMXAP,resultsMMXAP[,2] >=0)))
pvalue23<-(nrow(subset(resultsMMXAH,resultsMMXAH[,2] <=0)))

pvalue12
pvalue23

rm(list=ls())

####################################################################################################
####################################################################################################

dataSSX<-read.delim("/gene_positions/chrX_ss_120113.txt",header = TRUE)

data1<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

dataSSA<-data.frame(dataSSA<-data1[!(data1[,1] %in% dataSSX[,1]), 1])

colnames(dataSSA)<-c('gene')

dataSSA<-merge(dataSSA,data1,by = 'gene')

numberSSXP<-data.frame(numberSSXP<-cor(dataSSX[,5], dataSSX[,4], method = c('s')))
numberSSXH<-data.frame(numberSSXH<-cor(dataSSX[,16], dataSSX[,15], method = c('s')))
	
numberSSAP<-data.frame(numberSSAP<-cor(dataSSA[,3], dataSSA[,2], method = c('s')))
numberSSAH<-data.frame(numberSSAH<-cor(dataSSA[,14], dataSSA[,13], method = c('s')))
	
numberSSX_AP<-data.frame(numberSSX_AP<-(numberSSXP[,1]-numberSSAP[,1]))
numberSSX_AH<-data.frame(numberSSX_AH<-(numberSSXH[,1]-numberSSAH[,1]))

numberSSX_AP
numberSSX_AH

resultsSSXAP <- 1:20000 ; dim(resultsSSXAP) <- c(10000,2)
resultsSSXAP[,2]=0
resultsSSXAH <- 1:20000 ; dim(resultsSSXAH) <- c(10000,2)
resultsSSXAH[,2]=0


for (i in 1:10000) 
	{
	dataSSXB <- dataSSX[sample(nrow(dataSSX), replace = TRUE),]
	dataSSAB <- dataSSA[sample(nrow(dataSSA), replace = TRUE),]

	
	valueSSXP<-data.frame(valueSSXP<-cor(dataSSXB[,5], dataSSXB[,4], method = c('s')))
	valueSSXH<-data.frame(valueSSXH<-cor(dataSSXB[,16], dataSSXB[,15], method = c('s')))
	
	valueSSAP<-data.frame(valueSSAP<-cor(dataSSAB[,3], dataSSAB[,2], method = c('s')))
	valueSSAH<-data.frame(valueSSAH<-cor(dataSSAB[,14], dataSSAB[,13], method = c('s')))
	
	valueSSX_AP<-data.frame(valueSSX_AP<-(valueSSXP[,1]-valueSSAP[,1]))
	valueSSX_AH<-data.frame(valueSSX_AH<-(valueSSXH[,1]-valueSSAH[,1]))


	resultsSSXAP[i,2] = valueSSX_AP[,1]
	resultsSSXAH[i,2] = valueSSX_AH[,1]
	}
rm(i)

pvalue12<-(nrow(subset(resultsSSXAP,resultsSSXAP[,2] >=0)))
pvalue23<-(nrow(subset(resultsSSXAH,resultsSSXAH[,2] >=0)))

pvalue12
pvalue23

rm(list=ls())

####################################################################################################
####################################################################################################

dataMSX<-read.delim("/gene_positions/chrX_ms_120113.txt",header = TRUE)

data1<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

dataMSA<-data.frame(dataMSA<-data1[!(data1[,1] %in% dataMSX[,1]), 1])

colnames(dataMSA)<-c('gene')

dataMSA<-merge(dataMSA,data1,by = 'gene')

numberMSXP<-data.frame(numberMSXP<-cor(dataMSX[,5], dataMSX[,4], method = c('s')))
numberMSXH<-data.frame(numberMSXH<-cor(dataMSX[,16], dataMSX[,15], method = c('s')))
	
numberMSAP<-data.frame(numberMSAP<-cor(dataMSA[,3], dataMSA[,2], method = c('s')))
numberMSAH<-data.frame(numberMSAH<-cor(dataMSA[,14], dataMSA[,13], method = c('s')))
	
numberMSX_AP<-data.frame(numberMSX_AP<-(numberMSXP[,1]-numberMSAP[,1]))
numberMSX_AH<-data.frame(numberMSX_AH<-(numberMSXH[,1]-numberMSAH[,1]))

numberMSX_AP
numberMSX_AH

resultsMSXAP <- 1:20000 ; dim(resultsMSXAP) <- c(10000,2)
resultsMSXAP[,2]=0
resultsMSXAH <- 1:20000 ; dim(resultsMSXAH) <- c(10000,2)
resultsMSXAH[,2]=0


for (i in 1:10000) 
	{
	dataMSXB <- dataMSX[sample(nrow(dataMSX), replace = TRUE),]
	dataMSAB <- dataMSA[sample(nrow(dataMSA), replace = TRUE),]

	
	valueMSXP<-data.frame(valueMSXP<-cor(dataMSXB[,5], dataMSXB[,4], method = c('s')))
	valueMSXH<-data.frame(valueMSXH<-cor(dataMSXB[,16], dataMSXB[,15], method = c('s')))
	
	valueMSAP<-data.frame(valueMSAP<-cor(dataMSAB[,3], dataMSAB[,2], method = c('s')))
	valueMSAH<-data.frame(valueMSAH<-cor(dataMSAB[,14], dataMSAB[,13], method = c('s')))
	
	valueMSX_AP<-data.frame(valueMSX_AP<-(valueMSXP[,1]-valueMSAP[,1]))
	valueMSX_AH<-data.frame(valueMSX_AH<-(valueMSXH[,1]-valueMSAH[,1]))


	resultsMSXAP[i,2] = valueMSX_AP[,1]
	resultsMSXAH[i,2] = valueMSX_AH[,1]
	}
rm(i)

pvalue12<-(nrow(subset(resultsMSXAP,resultsMSXAP[,2] >=0)))
pvalue23<-(nrow(subset(resultsMSXAH,resultsMSXAH[,2] >=0)))

pvalue12
pvalue23

rm(list=ls())

####################################################################################################
####################################################################################################
#A1 VS A2 AND P1 VS P2
####################################################################################################
####################################################################################################

rm(list = ls())

#mel-mel H1 all
data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/zhr+z30_zhrXz30_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)
#sim-sec H1 all
data1B<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)
#mel-sim H1 all
data1C<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

#mel-mel H2 all
#data1<-read.delim("/Final/zhr_z30/mel-mel_P+H2/outputs/zhr+z30_z30Xzhr_mRNA_meta_gene_output_120113_classified_C.txt", header=TRUE)
#sim-sec H2 all
#data1B<-read.delim("/Final/sim_sec/sim-sec_P+H2/outputs/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113_classified_C.txt", header=TRUE)
#mel-sim H2 all
#data1C<-read.delim("/Final/mel_sim/mel-sim_P+H2/outputs/zhr+tsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113_classified_C.txt", header=TRUE)


data1<-cbind(data1[,1:3],data1[,13:14])
data1B<-cbind(data1B[,1:3],data1B[,13:14])
data1C<-cbind(data1C[,1:3],data1C[,13:14])

data2<-merge(data1,data1B,by = 'gene')
data3<-merge(data2,data1C, by  = 'gene')

resultsMM_SSP <- 1:20000 ; dim(resultsMM_SSP) <- c(10000,2)
resultsMM_SSP[,2]=0

resultsSS_MSP <- 1:20000 ; dim(resultsSS_MSP) <- c(10000,2)
resultsSS_MSP[,2]=0

resultsMM_MSP <- 1:20000 ; dim(resultsMM_MSP) <- c(10000,2)
resultsMM_MSP[,2]=0

resultsMM_SSH <- 1:20000 ; dim(resultsMM_SSH) <- c(10000,2)
resultsMM_SSH[,2]=0

resultsSS_MSH <- 1:20000 ; dim(resultsSS_MSH) <- c(10000,2)
resultsSS_MSH[,2]=0

resultsMM_MSH <- 1:20000 ; dim(resultsMM_MSH) <- c(10000,2)
resultsMM_MSH[,2]=0


for (i in 1:10000) 
	{
	data3B <- data3[sample(nrow(data3), replace = TRUE),]
	value<-cor(data3B[,3], data3B[,2], method = 's')
	valueB<-cor(data3B[,7], data3B[,6], method = 's')
	valueC<-cor(data3B[,11], data3B[,10], method = 's')
	valueD<-data.frame(valueD<-(value-valueB))
	valueE<-data.frame(valueE<-(valueB-valueC))
	valueF<-data.frame(valueF<-(value-valueC))

	value2<-cor(data3B[,5], data3B[,4], method = 's')
	value2B<-cor(data3B[,9], data3B[,8], method = 's')
	value2C<-cor(data3B[,12], data3B[,13], method = 's')
	value2D<-data.frame(value2D<-(value2-value2B))
	value2E<-data.frame(value2E<-(value2B-value2C))
	value2F<-data.frame(value2F<-(value2-value2C))

	resultsMM_SSP[i,2] = valueD[,1]
	resultsSS_MSP[i,2] = valueE[,1]
	resultsMM_MSP[i,2] = valueF[,1]

	resultsMM_SSH[i,2] = value2D[,1]
	resultsSS_MSH[i,2] = value2E[,1]
	resultsMM_MSH[i,2] = value2F[,1]
	}
	
rm(i)

pvalue12<-(nrow(subset(resultsMM_SSP,resultsMM_SSP[,2] <=0)))
pvalue23<-(nrow(subset(resultsSS_MSH,resultsSS_MSH[,2] <=0)))
pvalue13<-(nrow(subset(resultsMM_MSP,resultsMM_MSP[,2] <=0)))

pvalue12B<-(nrow(subset(resultsMM_SSH,resultsMM_SSH[,2] <=0)))
pvalue23B<-(nrow(subset(resultsSS_MSH,resultsSS_MSH[,2] <=0)))
pvalue13B<-(nrow(subset(resultsMM_MSH,resultsMM_MSH[,2] <=0)))

pvalue12
pvalue23
pvalue13

pvalue12B
pvalue23B
pvalue13B


rm(list=ls())

####################################################################################################
####################################################################################################
#A1 VS A2 AND P1 VS P2
####################################################################################################
####################################################################################################

rm(list = ls())

#mel-mel H1 all
#data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/zhr+z30_zhrXz30_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)
#sim-sec H1 all
#data1B<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)
#mel-sim H1 all
#data1C<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

#mel-mel H2 all
data1<-read.delim("/Final/zhr_z30/mel-mel_P+H2/outputs/zhr+z30_z30Xzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)
#sim-sec H2 all
data1B<-read.delim("/Final/sim_sec/sim-sec_P+H2/outputs/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)
#mel-sim H2 all
data1C<-read.delim("/Final/mel_sim/mel-sim_P+H2/outputs/zhr+tsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)


data1<-cbind(data1[,1:3],data1[,13:14])
data1B<-cbind(data1B[,1:3],data1B[,13:14])
data1C<-cbind(data1C[,1:3],data1C[,13:14])

data2<-merge(data1,data1B,by = 'gene')
data3<-merge(data2,data1C, by  = 'gene')

resultsMM_SSP <- 1:20000 ; dim(resultsMM_SSP) <- c(10000,2)
resultsMM_SSP[,2]=0

resultsSS_MSP <- 1:20000 ; dim(resultsSS_MSP) <- c(10000,2)
resultsSS_MSP[,2]=0

resultsMM_MSP <- 1:20000 ; dim(resultsMM_MSP) <- c(10000,2)
resultsMM_MSP[,2]=0

resultsMM_SSH <- 1:20000 ; dim(resultsMM_SSH) <- c(10000,2)
resultsMM_SSH[,2]=0

resultsSS_MSH <- 1:20000 ; dim(resultsSS_MSH) <- c(10000,2)
resultsSS_MSH[,2]=0

resultsMM_MSH <- 1:20000 ; dim(resultsMM_MSH) <- c(10000,2)
resultsMM_MSH[,2]=0


for (i in 1:10000) 
	{
	data3B <- data3[sample(nrow(data3), replace = TRUE),]
	value<-cor(data3B[,3], data3B[,2], method = 's')
	valueB<-cor(data3B[,7], data3B[,6], method = 's')
	valueC<-cor(data3B[,11], data3B[,10], method = 's')
	valueD<-data.frame(valueD<-(value-valueB))
	valueE<-data.frame(valueE<-(valueB-valueC))
	valueF<-data.frame(valueF<-(value-valueC))

	value2<-cor(data3B[,5], data3B[,4], method = 's')
	value2B<-cor(data3B[,9], data3B[,8], method = 's')
	value2C<-cor(data3B[,12], data3B[,13], method = 's')
	value2D<-data.frame(value2D<-(value2-value2B))
	value2E<-data.frame(value2E<-(value2B-value2C))
	value2F<-data.frame(value2F<-(value2-value2C))

	resultsMM_SSP[i,2] = valueD[,1]
	resultsSS_MSP[i,2] = valueE[,1]
	resultsMM_MSP[i,2] = valueF[,1]

	resultsMM_SSH[i,2] = value2D[,1]
	resultsSS_MSH[i,2] = value2E[,1]
	resultsMM_MSH[i,2] = value2F[,1]
	}
	
rm(i)

pvalue12<-(nrow(subset(resultsMM_SSP,resultsMM_SSP[,2] <=0)))
pvalue23<-(nrow(subset(resultsSS_MSH,resultsSS_MSH[,2] <=0)))
pvalue13<-(nrow(subset(resultsMM_MSP,resultsMM_MSP[,2] <=0)))

pvalue12B<-(nrow(subset(resultsMM_SSH,resultsMM_SSH[,2] <=0)))
pvalue23B<-(nrow(subset(resultsSS_MSH,resultsSS_MSH[,2] <=0)))
pvalue13B<-(nrow(subset(resultsMM_MSH,resultsMM_MSH[,2] <=0)))

pvalue12
pvalue23
pvalue13

pvalue12B
pvalue23B
pvalue13B


rm(list=ls())

####################################################################################################
####################################################################################################
#get CI for chromo plot
####################################################################################################
####################################################################################################

dataMMX<-read.delim("/gene_positions/chrX_mm_120113.txt",header = TRUE)

data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/zhr+z30_zhrXz30_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

dataMMA<-data.frame(dataMMA<-data1[!(data1[,1] %in% dataMMX[,1]), 1])

colnames(dataMMA)<-c('gene')

dataMMA<-merge(dataMMA,data1,by = 'gene')

numberMMXP<-data.frame(numberMMXP<-cor(dataMMX[,5], dataMMX[,4], method = c('s')))
numberMMXH<-data.frame(numberMMXH<-cor(dataMMX[,16], dataMMX[,15], method = c('s')))

numberMMXP
numberMMXH
	
numberMMAP<-data.frame(numberMMAP<-cor(dataMMA[,3], dataMMA[,2], method = c('s')))
numberMMAH<-data.frame(numberMMAH<-cor(dataMMA[,14], dataMMA[,13], method = c('s')))

numberMMAP
numberMMAH

resultsMMAP <- 1:20000 ; dim(resultsMMAP) <- c(10000,2)
resultsMMAP[,2]=0
resultsMMAH <- 1:20000 ; dim(resultsMMAH) <- c(10000,2)
resultsMMAH[,2]=0

for (i in 1:10000) 
	{
	dataMMAB <- dataMMA[sample(nrow(dataMMA), replace = TRUE),]

	valueMMAP<-data.frame(valueMMAP<-cor(dataMMAB[,3], dataMMAB[,2], method = c('s')))
	valueMMAH<-data.frame(valueMMAH<-cor(dataMMAB[,14], dataMMAB[,13], method = c('s')))

	resultsMMAP[i,2] = valueMMAP[,1]
	resultsMMAH[i,2] = valueMMAH[,1]
	}
rm(i)

quantile(resultsMMAP[,2], 0.025)
quantile(resultsMMAP[,2], 0.975)

quantile(resultsMMAH[,2], 0.025)
quantile(resultsMMAH[,2], 0.975)

####################################################################################################
####################################################################################################


dataSSX<-read.delim("/gene_positions/chrX_ss_120113.txt",header = TRUE)

data1<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

dataSSA<-data.frame(dataSSA<-data1[!(data1[,1] %in% dataSSX[,1]), 1])

colnames(dataSSA)<-c('gene')

dataSSA<-merge(dataSSA,data1,by = 'gene')

numberSSXP<-data.frame(numberSSXP<-cor(dataSSX[,5], dataSSX[,4], method = c('s')))
numberSSXH<-data.frame(numberSSXH<-cor(dataSSX[,16], dataSSX[,15], method = c('s')))

numberSSXP
numberSSXH
	
numberSSAP<-data.frame(numberSSAP<-cor(dataSSA[,3], dataSSA[,2], method = c('s')))
numberSSAH<-data.frame(numberSSAH<-cor(dataSSA[,14], dataSSA[,13], method = c('s')))

numberSSAP
numberSSAH

dataMSX<-read.delim("/gene_positions/chrX_ms_120113.txt",header = TRUE)

resultsSSAP <- 1:20000 ; dim(resultsSSAP) <- c(10000,2)
resultsSSAP[,2]=0
resultsSSAH <- 1:20000 ; dim(resultsSSAH) <- c(10000,2)
resultsSSAH[,2]=0

for (i in 1:10000) 
	{
	dataSSAB <- dataSSA[sample(nrow(dataSSA), replace = TRUE),]

	valueSSAP<-data.frame(valueSSAP<-cor(dataSSAB[,3], dataSSAB[,2], method = c('s')))
	valueSSAH<-data.frame(valueSSAH<-cor(dataSSAB[,14], dataSSAB[,13], method = c('s')))

	resultsSSAP[i,2] = valueSSAP[,1]
	resultsSSAH[i,2] = valueSSAH[,1]
	}
rm(i)


quantile(resultsSSAP[,2], 0.025)
quantile(resultsSSAP[,2], 0.975)

quantile(resultsSSAH[,2], 0.025)
quantile(resultsSSAH[,2], 0.975)



####################################################################################################
####################################################################################################


dataMSX<-read.delim("/gene_positions/chrX_ms_120113.txt",header = TRUE)

data1<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

dataMSA<-data.frame(dataMSA<-data1[!(data1[,1] %in% dataMSX[,1]), 1])

colnames(dataMSA)<-c('gene')

dataMSA<-merge(dataMSA,data1,by = 'gene')

numberMSXP<-data.frame(numberMSXP<-cor(dataMSX[,5], dataMSX[,4], method = c('s')))
numberMSXH<-data.frame(numberMSXH<-cor(dataMSX[,16], dataMSX[,15], method = c('s')))
	
numberMSAP<-data.frame(numberMSAP<-cor(dataMSA[,3], dataMSA[,2], method = c('s')))
numberMSAH<-data.frame(numberMSAH<-cor(dataMSA[,14], dataMSA[,13], method = c('s')))

resultsMSAP <- 1:20000 ; dim(resultsMSAP) <- c(10000,2)
resultsMSAP[,2]=0
resultsMSAH <- 1:20000 ; dim(resultsMSAH) <- c(10000,2)
resultsMSAH[,2]=0

for (i in 1:10000) 
	{
	dataMSAB <- dataMSA[sample(nrow(dataMSA), replace = TRUE),]

	valueMSAP<-data.frame(valueMSAP<-cor(dataMSAB[,3], dataMSAB[,2], method = c('s')))
	valueMSAH<-data.frame(valueMSAH<-cor(dataMSAB[,14], dataMSAB[,13], method = c('s')))

	resultsMSAP[i,2] = valueMSAP[,1]
	resultsMSAH[i,2] = valueMSAH[,1]
	}
rm(i)



quantile(resultsMSAP[,2], 0.025)
quantile(resultsMSAP[,2], 0.975)

quantile(resultsMSAH[,2], 0.025)
quantile(resultsMSAH[,2], 0.975)





###################################################################################################
###################################################################################################
#meta

#mel-mel H1 all
data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/zhr+z30_zhrXz30_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,30]~0 +data1[,29])
summary(fit1)
cor(data1[,30],data1[,29],method = c("s"))

#bootstrapping 

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0

val1<-data.frame(summary(fit1)[8])
val1

for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	fit2<-lm(data1_1B[,30] ~ data1_1B[,29])
	value<-summary(fit2)[8]
	value<-data.frame(value)
	results1[i,2] = value[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MMH1B.txt",sep="\t",quote=FALSE,row.names=FALSE)


rm(list=ls())

###################################################################################################
###################################################################################################
#mel-mel H2 all

data1<-read.delim("/Final/zhr_z30/mel-mel_P+H2/outputs/zhr+z30_z30Xzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,30]~0 +data1[,29])
summary(fit1)
cor(data1[,30],data1[,29],method = c("s"))

#bootstrapping 

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0

val1<-data.frame(summary(fit1)[8])
val1

for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	fit2<-lm(data1_1B[,30] ~ data1_1B[,29])
	value<-summary(fit2)[8]
	value<-data.frame(value)
	results1[i,2] = value[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MMH2B.txt",sep="\t",quote=FALSE,row.names=FALSE)


rm(list=ls())

###################################################################################################
###################################################################################################
#sim-sec H1 all

data1<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,30]~0 +data1[,29])
summary(fit1)
cor(data1[,30],data1[,29],method = c("s"))

#bootstrapping 

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0

val1<-data.frame(summary(fit1)[8])
val1

for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	fit2<-lm(data1_1B[,30] ~ data1_1B[,29])
	value<-summary(fit2)[8]
	value<-data.frame(value)
	results1[i,2] = value[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_SSH1B.txt",sep="\t",quote=FALSE,row.names=FALSE)


rm(list=ls())

###################################################################################################
###################################################################################################
#sim-sec H2 all
data1<-read.delim("/Final/sim_sec/sim-sec_P+H2/outputs/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,30]~0 +data1[,29])
summary(fit1)
cor(data1[,30],data1[,29],method = c("s"))

#bootstrapping 

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0

val1<-data.frame(summary(fit1)[8])
val1

for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	fit2<-lm(data1_1B[,30] ~ data1_1B[,29])
	value<-summary(fit2)[8]
	value<-data.frame(value)
	results1[i,2] = value[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_SSH2B.txt",sep="\t",quote=FALSE,row.names=FALSE)


rm(list=ls())

###################################################################################################
###################################################################################################

#mel-sim H1 all
data1<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,30]~0 +data1[,29])
summary(fit1)
cor(data1[,30],data1[,29],method = c("s"))

#bootstrapping 

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0

val1<-data.frame(summary(fit1)[8])
val1

for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	fit2<-lm(data1_1B[,30] ~ data1_1B[,29])
	value<-summary(fit2)[8]
	value<-data.frame(value)
	results1[i,2] = value[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MSH1B.txt",sep="\t",quote=FALSE,row.names=FALSE)


rm(list=ls())

###################################################################################################
###################################################################################################
#mel-sim H2 ALL

data1<-read.delim("/Final/mel_sim/mel-sim_P+H2/outputs/zhr+tsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

fit1<-lm(data1[,30]~0 +data1[,29])
summary(fit1)
cor(data1[,30],data1[,29],method = c("s"))

#bootstrapping 

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0

val1<-data.frame(summary(fit1)[8])
val1

for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	fit2<-lm(data1_1B[,30] ~ data1_1B[,29])
	value<-summary(fit2)[8]
	value<-data.frame(value)
	results1[i,2] = value[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MSH2B.txt",sep="\t",quote=FALSE,row.names=FALSE)


rm(list=ls())


###################################################################################################
###################################################################################################
#meta

#mel-mel H1 all
data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/zhr+z30_zhrXz30_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

cor(data1[,2],data1[,3],method = c("s"))
cor(data1[,13],data1[,14],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0

for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,3], data1_1B[,2], method = 's')
	value2<-cor(data1_1B[,14], data1_1B[,13], method = 's')
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MMH1B_P1P2B.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MMH1B_H1H2B.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

###################################################################################################
###################################################################################################
#mel-mel H2 all

data1<-read.delim("/Final/zhr_z30/mel-mel_P+H2/outputs/zhr+z30_z30Xzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

cor(data1[,2],data1[,3],method = c("s"))
cor(data1[,13],data1[,14],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0

for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,14], data1_1B[,13], method = 's')
	value<-data.frame(value)
	results1[i,2] = value[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MMH2B_H1H2B.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

###################################################################################################
###################################################################################################
#sim-sec H1 all

data1<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

cor(data1[,2],data1[,3],method = c("s"))
cor(data1[,13],data1[,14],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0

for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,3], data1_1B[,2], method = 's')
	value2<-cor(data1_1B[,14], data1_1B[,13], method = 's')
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_SSH1B_P1P2B.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_SSH1B_H1H2B.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

###################################################################################################
###################################################################################################
#sim-sec H2 all
data1<-read.delim("/Final/sim_sec/sim-sec_P+H2/outputs/tsimbazaza+droSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

cor(data1[,2],data1[,3],method = c("s"))
cor(data1[,13],data1[,14],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0

for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,14], data1_1B[,13], method = 's')
	value<-data.frame(value)
	results1[i,2] = value[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_SSH2B_H1H2B.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

###################################################################################################
###################################################################################################

#mel-sim H1 all
data1<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

cor(data1[,2],data1[,3],method = c("s"))
cor(data1[,13],data1[,14],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0
results2 <- 1:20000 ; dim(results2) <- c(10000,2)
results2[,2]=0

for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,3], data1_1B[,2], method = 's')
	value2<-cor(data1_1B[,14], data1_1B[,13], method = 's')
	value<-data.frame(value)
	value2<-data.frame(value2)
	results1[i,2] = value[,1]
	results2[i,2] = value2[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MSH1B_P1P2B.txt",sep="\t",quote=FALSE,row.names=FALSE)
write.table(results2, file = "/Final/Separate/results1_MSH1B_H1H2B.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())

###################################################################################################
###################################################################################################
#mel-sim H2 ALL

data1<-read.delim("/Final/mel_sim/mel-sim_P+H2/outputs/zhr+tsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################

cor(data1[,2],data1[,3],method = c("s"))
cor(data1[,13],data1[,14],method = c("s"))

data1_1 <-data1

results1 <- 1:20000 ; dim(results1) <- c(10000,2)
results1[,2]=0

for (i in 1:10000) 
	{
	data1_1B <- data1_1[sample(nrow(data1_1), replace = TRUE),]
	value<-cor(data1_1B[,14], data1_1B[,13], method = 's')
	value<-data.frame(value)
	results1[i,2] = value[,1]
	}
rm(i)

write.table(results1, file = "/Final/Separate/results1_MSH2B_H1H2B.txt",sep="\t",quote=FALSE,row.names=FALSE)

rm(list=ls())


####################################################################################################
####################################################################################################
#Rho bootstrapping results
####################################################################################################
####################################################################################################

results1<-read.delim("/Final/Separate/results1B.txt",header = TRUE)
results2<-read.delim("/Final/Separate/results2B.txt",header = TRUE)
results3<-read.delim("/Final/Separate/results3B.txt",header = TRUE)

results8<-read.delim("/Final/Separate/results8B.txt",header = TRUE)
results13<-read.delim("/Final/Separate/results13B.txt",header = TRUE)
results18<-read.delim("/Final/Separate/results18B.txt",header = TRUE)

resultsMMH3<-read.delim("/Final/Separate/resultsMMH3B.txt",header = TRUE)
resultsSSH3<-read.delim("/Final/Separate/resultsSSH3B.txt",header = TRUE)
resultsMSH3<-read.delim("/Final/Separate/resultsMSH3B.txt",header = TRUE)

W1<-wilcox.test(results1[,2],results2[,2],paired = FALSE,alternative = c("two.sided"),conf.int = 0.95)
W2<-wilcox.test(results2[,2],results3[,2],paired = FALSE,alternative = c("two.sided"),conf.int = 0.95)
W3<-wilcox.test(results1[,2],results3[,2],paired = FALSE,alternative = c("two.sided"),conf.int = 0.95)

W4<-wilcox.test(results8[,2],results13[,2],paired = FALSE,alternative = c("two.sided"),conf.int = 0.95)
W5<-wilcox.test(results13[,2],results18[,2],paired = FALSE,alternative = c("two.sided"),conf.int = 0.95)
W6<-wilcox.test(results8[,2],results18[,2],paired = FALSE,alternative = c("two.sided"),conf.int = 0.95)

W7<-wilcox.test(resultsMMH3[,2],resultsSSH3[,2],paired = FALSE,alternative = c("two.sided"),conf.int = 0.95)
W8<-wilcox.test(resultsSSH3[,2],resultsMSH3[,2],paired = FALSE,alternative = c("two.sided"),conf.int = 0.95)
W9<-wilcox.test(resultsMMH3[,2],resultsMSH3[,2],paired = FALSE,alternative = c("two.sided"),conf.int = 0.95)

quantile(results1[,2], 0.025)
quantile(results1[,2], 0.975)

quantile(results2[,2], 0.025)
quantile(results2[,2], 0.975)

quantile(results3[,2], 0.025)
quantile(results3[,2], 0.975)

quantile(results8[,2], 0.025)
quantile(results8[,2], 0.975)

quantile(results13[,2], 0.025)
quantile(results13[,2], 0.975)

quantile(results18[,2], 0.025)
quantile(results18[,2], 0.975)

quantile(resultsMMH3[,2], 0.025)
quantile(resultsMMH3[,2], 0.975)

quantile(resultsSSH3[,2], 0.025)
quantile(resultsSSH3[,2], 0.975)

quantile(resultsMSH3[,2], 0.025)
quantile(resultsMSH3[,2], 0.975)

W1
W2
W3
W4
W5
W6
W7
W8
W9

####################################################################################################
####################################################################################################
#
####################################################################################################
####################################################################################################

results1_MMH1B<-read.delim("/Final/Separate/results1_MMH1B.txt",header = TRUE)
results1_MMH2B<-read.delim("/Final/Separate/results1_MMH2B.txt",header = TRUE)
results1_SSH1B<-read.delim("/Final/Separate/results1_SSH1B.txt",header = TRUE)
results1_SSH2B<-read.delim("/Final/Separate/results1_SSH2B.txt",header = TRUE)
results1_MSH1B<-read.delim("/Final/Separate/results1_MSH1B.txt",header = TRUE)
results1_MSH2B<-read.delim("/Final/Separate/results1_MSH2B.txt",header = TRUE)

quantile(results1_MMH1B[,2], 0.025)
quantile(results1_MMH1B[,2], 0.975)

quantile(results1_MMH2B[,2], 0.025)
quantile(results1_MMH2B[,2], 0.975)

quantile(results1_SSH1B[,2], 0.025)
quantile(results1_SSH1B[,2], 0.975)

quantile(results1_SSH2B[,2], 0.025)
quantile(results1_SSH2B[,2], 0.975)

quantile(results1_MSH1B[,2], 0.025)
quantile(results1_MSH1B[,2], 0.975)

quantile(results1_MSH2B[,2], 0.025)
quantile(results1_MSH2B[,2], 0.975)


####################################################################################################
####################################################################################################
#
####################################################################################################
####################################################################################################


results1_MMHX_P<-read.delim("/Final/Separate/results1_MMHX_PB.txt",header = TRUE)
results1_MMHX_H<-read.delim("/Final/Separate/results1_MMHX_HB.txt",header = TRUE)

results1_MMH2L_P<-read.delim("/Final/Separate/results1_MMH2L_PB.txt",header = TRUE)
results1_MMH2L_H<-read.delim("/Final/Separate/results1_MMH2L_HB.txt",header = TRUE)

results1_MMH2R_P<-read.delim("/Final/Separate/results1_MMH2R_PB.txt",header = TRUE)
results1_MMH2R_H<-read.delim("/Final/Separate/results1_MMH2R_HB.txt",header = TRUE)

results1_MMH3L_P<-read.delim("/Final/Separate/results1_MMH3L_PB.txt",header = TRUE)
results1_MMH3L_H<-read.delim("/Final/Separate/results1_MMH3L_HB.txt",header = TRUE)

results1_MMH3R_P<-read.delim("/Final/Separate/results1_MMH3R_PB.txt",header = TRUE)
results1_MMH3R_H<-read.delim("/Final/Separate/results1_MMH3R_HB.txt",header = TRUE)

results1_MMH4_P<-read.delim("/Final/Separate/results1_MMH4_PB.txt",header = TRUE)
results1_MMH4_H<-read.delim("/Final/Separate/results1_MMH4_HB.txt",header = TRUE)

results1_SSHX_P<-read.delim("/Final/Separate/results1_SSHX_PB.txt",header = TRUE)
results1_SSHX_H<-read.delim("/Final/Separate/results1_SSHX_HB.txt",header = TRUE)

results1_SSH2L_P<-read.delim("/Final/Separate/results1_SSH2L_PB.txt",header = TRUE)
results1_SSH2L_H<-read.delim("/Final/Separate/results1_SSH2L_HB.txt",header = TRUE)

results1_SSH2R_P<-read.delim("/Final/Separate/results1_SSH2R_PB.txt",header = TRUE)
results1_SSH2R_H<-read.delim("/Final/Separate/results1_SSH2R_HB.txt",header = TRUE)

results1_SSH3L_P<-read.delim("/Final/Separate/results1_SSH3L_PB.txt",header = TRUE)
results1_SSH3L_H<-read.delim("/Final/Separate/results1_SSH3L_HB.txt",header = TRUE)

results1_SSH3R_P<-read.delim("/Final/Separate/results1_SSH3R_PB.txt",header = TRUE)
results1_SSH3R_H<-read.delim("/Final/Separate/results1_SSH3R_HB.txt",header = TRUE)

results1_SSH4_P<-read.delim("/Final/Separate/results1_SSH4_PB.txt",header = TRUE)
results1_SSH4_H<-read.delim("/Final/Separate/results1_SSH4_HB.txt",header = TRUE)

results1_MSHX_P<-read.delim("/Final/Separate/results1_MSHX_PB.txt",header = TRUE)
results1_MSHX_H<-read.delim("/Final/Separate/results1_MSHX_HB.txt",header = TRUE)

results1_MSH2L_P<-read.delim("/Final/Separate/results1_MSH2L_PB.txt",header = TRUE)
results1_MSH2L_H<-read.delim("/Final/Separate/results1_MSH2L_HB.txt",header = TRUE)

results1_MSH2R_P<-read.delim("/Final/Separate/results1_MSH2R_PB.txt",header = TRUE)
results1_MSH2R_H<-read.delim("/Final/Separate/results1_MSH2R_HB.txt",header = TRUE)

results1_MSH3L_P<-read.delim("/Final/Separate/results1_MSH3L_PB.txt",header = TRUE)
results1_MSH3L_H<-read.delim("/Final/Separate/results1_MSH3L_HB.txt",header = TRUE)

results1_MSH3R_P<-read.delim("/Final/Separate/results1_MSH3R_PB.txt",header = TRUE)
results1_MSH3R_H<-read.delim("/Final/Separate/results1_MSH3R_HB.txt",header = TRUE)

results1_MSH4_P<-read.delim("/Final/Separate/results1_MSH4_PB.txt",header = TRUE)
results1_MSH4_H<-read.delim("/Final/Separate/results1_MSH4_HB.txt",header = TRUE)


quantile(results1_MMHX_P[,2], 0.025)
quantile(results1_MMHX_P[,2], 0.975)

quantile(results1_MMH2L_P[,2], 0.025)
quantile(results1_MMH2L_P[,2], 0.975)

quantile(results1_MMH2R_P[,2], 0.025)
quantile(results1_MMH2R_P[,2], 0.975)

quantile(results1_MMH3L_P[,2], 0.025)
quantile(results1_MMH3L_P[,2], 0.975)

quantile(results1_MMH3R_P[,2], 0.025)
quantile(results1_MMH3R_P[,2], 0.975)

quantile(results1_MMH4_P[,2], 0.025)
quantile(results1_MMH4_P[,2], 0.975)

quantile(results1_SSHX_P[,2], 0.025)
quantile(results1_SSHX_P[,2], 0.975)

quantile(results1_SSH2L_P[,2], 0.025)
quantile(results1_SSH2L_P[,2], 0.975)

quantile(results1_SSH2R_P[,2], 0.025)
quantile(results1_SSH2R_P[,2], 0.975)

quantile(results1_SSH3L_P[,2], 0.025)
quantile(results1_SSH3L_P[,2], 0.975)

quantile(results1_SSH3R_P[,2], 0.025)
quantile(results1_SSH3R_P[,2], 0.975)

quantile(results1_SSH4_P[,2], 0.025)
quantile(results1_SSH4_P[,2], 0.975)

quantile(results1_MSHX_P[,2], 0.025)
quantile(results1_MSHX_P[,2], 0.975)

quantile(results1_MSH2L_P[,2], 0.025)
quantile(results1_MSH2L_P[,2], 0.975)

quantile(results1_MSH2R_P[,2], 0.025)
quantile(results1_MSH2R_P[,2], 0.975)

quantile(results1_MSH3L_P[,2], 0.025)
quantile(results1_MSH3L_P[,2], 0.975)

quantile(results1_MSH3R_P[,2], 0.025)
quantile(results1_MSH3R_P[,2], 0.975)

quantile(results1_MSH4_P[,2], 0.025)
quantile(results1_MSH4_P[,2], 0.975)



quantile(results1_MMHX_H[,2], 0.025)
quantile(results1_MMHX_H[,2], 0.975)

quantile(results1_MMH2L_H[,2], 0.025)
quantile(results1_MMH2L_H[,2], 0.975)

quantile(results1_MMH2R_H[,2], 0.025)
quantile(results1_MMH2R_H[,2], 0.975)

quantile(results1_MMH3L_H[,2], 0.025)
quantile(results1_MMH3L_H[,2], 0.975)

quantile(results1_MMH3R_H[,2], 0.025)
quantile(results1_MMH3R_H[,2], 0.975)

quantile(results1_MMH4_H[,2], 0.025)
quantile(results1_MMH4_H[,2], 0.975)

quantile(results1_SSHX_H[,2], 0.025)
quantile(results1_SSHX_H[,2], 0.975)

quantile(results1_SSH2L_H[,2], 0.025)
quantile(results1_SSH2L_H[,2], 0.975)

quantile(results1_SSH2R_H[,2], 0.025)
quantile(results1_SSH2R_H[,2], 0.975)

quantile(results1_SSH3L_H[,2], 0.025)
quantile(results1_SSH3L_H[,2], 0.975)

quantile(results1_SSH3R_H[,2], 0.025)
quantile(results1_SSH3R_H[,2], 0.975)

quantile(results1_SSH4_H[,2], 0.025)
quantile(results1_SSH4_H[,2], 0.975)

quantile(results1_MSHX_H[,2], 0.025)
quantile(results1_MSHX_H[,2], 0.975)

quantile(results1_MSH2L_H[,2], 0.025)
quantile(results1_MSH2L_H[,2], 0.975)

quantile(results1_MSH2R_H[,2], 0.025)
quantile(results1_MSH2R_H[,2], 0.975)

quantile(results1_MSH3L_H[,2], 0.025)
quantile(results1_MSH3L_H[,2], 0.975)

quantile(results1_MSH3R_H[,2], 0.025)
quantile(results1_MSH3R_H[,2], 0.975)

quantile(results1_MSH4_H[,2], 0.025)
quantile(results1_MSH4_H[,2], 0.975)

rm(list = ls())

results1_MMH2X_P<-read.delim("/Final/Separate/results1_MMH2X_PB.txt",header = TRUE)
results1_MMH2X_H<-read.delim("/Final/Separate/results1_MMH2X_HB.txt",header = TRUE)

results1_MMH22L_P<-read.delim("/Final/Separate/results1_MMH22L_PB.txt",header = TRUE)
results1_MMH22L_H<-read.delim("/Final/Separate/results1_MMH22L_HB.txt",header = TRUE)

results1_MMH22R_P<-read.delim("/Final/Separate/results1_MMH22R_PB.txt",header = TRUE)
results1_MMH22R_H<-read.delim("/Final/Separate/results1_MMH22R_HB.txt",header = TRUE)

results1_MMH23L_P<-read.delim("/Final/Separate/results1_MMH23L_PB.txt",header = TRUE)
results1_MMH23L_H<-read.delim("/Final/Separate/results1_MMH23L_HB.txt",header = TRUE)

results1_MMH23R_P<-read.delim("/Final/Separate/results1_MMH23R_PB.txt",header = TRUE)
results1_MMH23R_H<-read.delim("/Final/Separate/results1_MMH23R_HB.txt",header = TRUE)

results1_MMH24_P<-read.delim("/Final/Separate/results1_MMH24_PB.txt",header = TRUE)
results1_MMH24_H<-read.delim("/Final/Separate/results1_MMH24_HB.txt",header = TRUE)

results1_SSH2X_P<-read.delim("/Final/Separate/results1_SSH2X_PB.txt",header = TRUE)
results1_SSH2X_H<-read.delim("/Final/Separate/results1_SSH2X_HB.txt",header = TRUE)

results1_SSH22L_P<-read.delim("/Final/Separate/results1_SSH22L_PB.txt",header = TRUE)
results1_SSH22L_H<-read.delim("/Final/Separate/results1_SSH22L_HB.txt",header = TRUE)

results1_SSH22R_P<-read.delim("/Final/Separate/results1_SSH22R_PB.txt",header = TRUE)
results1_SSH22R_H<-read.delim("/Final/Separate/results1_SSH22R_HB.txt",header = TRUE)

results1_SSH23L_P<-read.delim("/Final/Separate/results1_SSH23L_PB.txt",header = TRUE)
results1_SSH23L_H<-read.delim("/Final/Separate/results1_SSH23L_HB.txt",header = TRUE)

results1_SSH23R_P<-read.delim("/Final/Separate/results1_SSH23R_PB.txt",header = TRUE)
results1_SSH23R_H<-read.delim("/Final/Separate/results1_SSH23R_HB.txt",header = TRUE)

results1_SSH24_P<-read.delim("/Final/Separate/results1_SSH24_PB.txt",header = TRUE)
results1_SSH24_H<-read.delim("/Final/Separate/results1_SSH24_HB.txt",header = TRUE)

results1_MSH2X_P<-read.delim("/Final/Separate/results1_MSH2X_PB.txt",header = TRUE)
results1_MSH2X_H<-read.delim("/Final/Separate/results1_MSH2X_HB.txt",header = TRUE)

results1_MSH22L_P<-read.delim("/Final/Separate/results1_MSH22L_PB.txt",header = TRUE)
results1_MSH22L_H<-read.delim("/Final/Separate/results1_MSH22L_HB.txt",header = TRUE)

results1_MSH22R_P<-read.delim("/Final/Separate/results1_MSH22R_PB.txt",header = TRUE)
results1_MSH22R_H<-read.delim("/Final/Separate/results1_MSH22R_HB.txt",header = TRUE)

results1_MSH23L_P<-read.delim("/Final/Separate/results1_MSH23L_PB.txt",header = TRUE)
results1_MSH23L_H<-read.delim("/Final/Separate/results1_MSH23L_HB.txt",header = TRUE)

results1_MSH23R_P<-read.delim("/Final/Separate/results1_MSH23R_PB.txt",header = TRUE)
results1_MSH23R_H<-read.delim("/Final/Separate/results1_MSH23R_HB.txt",header = TRUE)

results1_MSH24_P<-read.delim("/Final/Separate/results1_MSH24_PB.txt",header = TRUE)
results1_MSH24_H<-read.delim("/Final/Separate/results1_MSH24_HB.txt",header = TRUE)




quantile(results1_MMH2X_P[,2], 0.025)
quantile(results1_MMH2X_P[,2], 0.975)

quantile(results1_MMH22L_P[,2], 0.025)
quantile(results1_MMH22L_P[,2], 0.975)

quantile(results1_MMH22R_P[,2], 0.025)
quantile(results1_MMH22R_P[,2], 0.975)

quantile(results1_MMH23L_P[,2], 0.025)
quantile(results1_MMH23L_P[,2], 0.975)

quantile(results1_MMH23R_P[,2], 0.025)
quantile(results1_MMH23R_P[,2], 0.975)

quantile(results1_MMH24_P[,2], 0.025)
quantile(results1_MMH24_P[,2], 0.975)

quantile(results1_SSH2X_P[,2], 0.025)
quantile(results1_SSH2X_P[,2], 0.975)

quantile(results1_SSH22L_P[,2], 0.025)
quantile(results1_SSH22L_P[,2], 0.975)

quantile(results1_SSH22R_P[,2], 0.025)
quantile(results1_SSH22R_P[,2], 0.975)

quantile(results1_SSH23L_P[,2], 0.025)
quantile(results1_SSH23L_P[,2], 0.975)

quantile(results1_SSH23R_P[,2], 0.025)
quantile(results1_SSH23R_P[,2], 0.975)

quantile(results1_SSH24_P[,2], 0.025)
quantile(results1_SSH24_P[,2], 0.975)

quantile(results1_MSH2X_P[,2], 0.025)
quantile(results1_MSH2X_P[,2], 0.975)

quantile(results1_MSH22L_P[,2], 0.025)
quantile(results1_MSH22L_P[,2], 0.975)

quantile(results1_MSH22R_P[,2], 0.025)
quantile(results1_MSH22R_P[,2], 0.975)

quantile(results1_MSH23L_P[,2], 0.025)
quantile(results1_MSH23L_P[,2], 0.975)

quantile(results1_MSH23R_P[,2], 0.025)
quantile(results1_MSH23R_P[,2], 0.975)

quantile(results1_MSH24_P[,2], 0.025)
quantile(results1_MSH24_P[,2], 0.975)



quantile(results1_MMH2X_H[,2], 0.025)
quantile(results1_MMH2X_H[,2], 0.975)

quantile(results1_MMH22L_H[,2], 0.025)
quantile(results1_MMH22L_H[,2], 0.975)

quantile(results1_MMH22R_H[,2], 0.025)
quantile(results1_MMH22R_H[,2], 0.975)

quantile(results1_MMH23L_H[,2], 0.025)
quantile(results1_MMH23L_H[,2], 0.975)

quantile(results1_MMH23R_H[,2], 0.025)
quantile(results1_MMH23R_H[,2], 0.975)

quantile(results1_MMH24_H[,2], 0.025)
quantile(results1_MMH24_H[,2], 0.975)

quantile(results1_SSH2X_H[,2], 0.025)
quantile(results1_SSH2X_H[,2], 0.975)

quantile(results1_SSH22L_H[,2], 0.025)
quantile(results1_SSH22L_H[,2], 0.975)

quantile(results1_SSH22R_H[,2], 0.025)
quantile(results1_SSH22R_H[,2], 0.975)

quantile(results1_SSH23L_H[,2], 0.025)
quantile(results1_SSH23L_H[,2], 0.975)

quantile(results1_SSH23R_H[,2], 0.025)
quantile(results1_SSH23R_H[,2], 0.975)

quantile(results1_SSH24_H[,2], 0.025)
quantile(results1_SSH24_H[,2], 0.975)

quantile(results1_MSH2X_H[,2], 0.025)
quantile(results1_MSH2X_H[,2], 0.975)

quantile(results1_MSH22L_H[,2], 0.025)
quantile(results1_MSH22L_H[,2], 0.975)

quantile(results1_MSH22R_H[,2], 0.025)
quantile(results1_MSH22R_H[,2], 0.975)

quantile(results1_MSH23L_H[,2], 0.025)
quantile(results1_MSH23L_H[,2], 0.975)

quantile(results1_MSH23R_H[,2], 0.025)
quantile(results1_MSH23R_H[,2], 0.975)

quantile(results1_MSH24_H[,2], 0.025)
quantile(results1_MSH24_H[,2], 0.975)


results1_MMH1B_P1P2<-read.delim("/Final/Separate/results1_MMH1B_P1P2B.txt",header =TRUE)
results1_MMH1B_H1H2<-read.delim("/Final/Separate/results1_MMH1B_H1H2B.txt",header =TRUE)
results1_MMH2B_H1H2<-read.delim("/Final/Separate/results1_MMH2B_H1H2B.txt",header =TRUE)

results1_SSH1B_P1P2<-read.delim("/Final/Separate/results1_SSH1B_P1P2B.txt",header =TRUE)
results1_SSH1B_H1H2<-read.delim("/Final/Separate/results1_SSH1B_H1H2B.txt",header =TRUE)
results1_SSH2B_H1H2<-read.delim("/Final/Separate/results1_SSH2B_H1H2B.txt",header =TRUE)

results1_MSH1B_P1P2<-read.delim("/Final/Separate/results1_MSH1B_P1P2B.txt",header =TRUE)
results1_MSH1B_H1H2<-read.delim("/Final/Separate/results1_MSH1B_H1H2B.txt",header =TRUE)
results1_MSH2B_H1H2<-read.delim("/Final/Separate/results1_MSH2B_H1H2B.txt",header =TRUE)

quantile(results1_MMH1B_P1P2[,2], 0.025)
quantile(results1_MMH1B_P1P2[,2], 0.975)

quantile(results1_MMH1B_H1H2[,2], 0.025)
quantile(results1_MMH1B_H1H2[,2], 0.975)

quantile(results1_MMH2B_H1H2[,2], 0.025)
quantile(results1_MMH2B_H1H2[,2], 0.975)


quantile(results1_SSH1B_P1P2[,2], 0.025)
quantile(results1_SSH1B_P1P2[,2], 0.975)

quantile(results1_SSH1B_H1H2[,2], 0.025)
quantile(results1_SSH1B_H1H2[,2], 0.975)

quantile(results1_SSH2B_H1H2[,2], 0.025)
quantile(results1_SSH2B_H1H2[,2], 0.975)


quantile(results1_MSH1B_P1P2[,2], 0.025)
quantile(results1_MSH1B_P1P2[,2], 0.975)

quantile(results1_MSH1B_H1H2[,2], 0.025)
quantile(results1_MSH1B_H1H2[,2], 0.975)

quantile(results1_MSH2B_H1H2[,2], 0.025)
quantile(results1_MSH2B_H1H2[,2], 0.975)


####################################################################################################
####################################################################################################
#get expression difference for total and ase sets
####################################################################################################
####################################################################################################

data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/zhr+z30_zhrXz30_mRNA_meta_gene_output_120113_classified_B.txt",header = TRUE)
data3<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta_gene_output_120113_classified_B.txt",header = TRUE)
data5<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta_gene_output_120113_classified_B.txt",header = TRUE)

#aseGENES<-read.delim("/Final/ASE-genes.txt", header = TRUE)

#data1<-merge(aseGENES,data1, by = 'gene')
#data3<-merge(aseGENES,data3, by = 'gene')
#data5<-merge(aseGENES,data5, by = 'gene')

data1$abslog2rat=abs(data1[,29])
data3$abslog2rat=abs(data3[,29])
data5$abslog2rat=abs(data5[,29])

####################################################################################################
####################################################################################################

#29=data1$logPrat = log2(data1[,2]/data1[,3])
#30=data1$logHrat = log2(data1[,13]/data1[,14])
#31=data1$logPrat_logHrat_rat = data1$logPrat/data1$logHrat
#32=data1$percentcis = (abs(data1$logHrat)/(abs(data1$logHrat)+abs(data1$logPrat-data1$logHrat)))*100
#33=data1$H_P1diff = log2((data1[,16]/(sum(data1[,16])))*100)-log2((data1[,2]/(sum(data1[,2])))*100)
#34=data1$H_P2diff = log2((data1[,16]/(sum(data1[,16])))*100)-log2((data1[,3]/(sum(data1[,3])))*100)
#35=data1$Pdiff 
#36=data1$cis 
#37=data1$trans 
#38=data1$allcis 
#39=data1$alltrans 
#40=data1$conserved1 
#41=data1$compensatory 
#42=data1$ambiguous 
#43=data1$cisplustrans 
#44=data1$cisXtrans 
#45=data1$additive 
#46=data1$underdominant 
#47=data1$overdominant 
#48=data1$par2dominant 
#49=data1$par1dominant 
#50=data1$conserved2 
#51=abslog2prat

####################################################################################################
####################################################################################################

#mel-mel
data1B<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/total_dominance_MMH1_classified_B.txt", header=TRUE)

#sim-sec
data3B<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/total_dominance_SSH1_classified_B.txt", header=TRUE)

#mel-sim
data5B<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/total_dominance_MSH1_classified_B.txt", header=TRUE)

totalGENES<-read.delim("/Final/total-genes.txt", header = TRUE)

data1B<-merge(totalGENES,data1B, by = 'gene')
data3B<-merge(totalGENES,data3B, by = 'gene')
data5B<-merge(totalGENES,data5B, by = 'gene')

data1B$abslog2rat=abs(log2(data1B[,2]/data1B[,3]))
data3B$abslog2rat=abs(log2(data3B[,2]/data3B[,3]))
data5B$abslog2rat=abs(log2(data5B[,2]/data5B[,3]))

####################################################################################################
####################################################################################################

#2=zhr
#3=z30
#4=MMH1
#5=data1$H_P1diff = ((log2(((data1[,4])/(sum(data1[,4])))*100)) - (log2(((data1[,2])/sum(data1[,2]))*100)))
#6=data1$H_P2diff = ((log2(((data1[,4])/(sum(data1[,4])))*100)) - (log2(((data1[,3])/sum(data1[,3]))*100)))
#7=data1$additive 
#8=data1$underdominant
#9=data1$overdominant
#10=data1$par1dominant
#11=data1$par2dominant
#12=data1$conserved2
#13=abslog2prat

####################################################################################################
####################################################################################################

#make boxplot
pdf(file = "/Final/Meta/mag_pdiff_all-vs-meta_120113.pdf")
boxplot(data1B[,13],data1[,51],data3B[,13],data3[,51],data5B[,13],data5[,51], ylab='abs(log2(P1/P2))', xaxt="n", ylim = c(0,2.5), notch = TRUE, outline = F)
axis(1, at=1:6,lab=c("MM 7587", "MM 4851","SS 7587","SS 4851","MS 7587","MS 4851"))
dev.off()

summary(data1B[,13])
summary(data3B[,13])
summary(data5B[,13])
summary(data1[,45])
summary(data3[,45])
summary(data5[,45])

rm(list = ls())

####################################################################################################
####################################################################################################
# get % seq divergence for total and ase set
####################################################################################################
####################################################################################################

#read in data

data1<-read.delim("/final/seq_div_genes/zhr_z30_7660_genes.txt",header = TRUE)
data2<-read.delim("/final/seq_div_genes/sim_sec_7660_genes.txt",header = TRUE)
data3<-read.delim("/final/seq_div_genes/zhr_sim_7660_genes.txt",header = TRUE)

totalGENES<-read.delim("/Final/total-genes.txt", header = TRUE)


data1<-merge(totalGENES,data1, by = 'gene')
data2<-merge(totalGENES,data2, by = 'gene')
data3<-merge(totalGENES,data3, by = 'gene')


data1B<-read.delim("/final/seq_div_genes/zhr_z30_5036_genes.txt",header = TRUE)
data2B<-read.delim("/final/seq_div_genes/sim_sec_5036_genes.txt",header = TRUE)
data3B<-read.delim("/final/seq_div_genes/zhr_sim_5036_genes.txt",header = TRUE)

aseGENES<-read.delim("/Final/ASE-genes.txt", header = TRUE)

data1B<-merge(aseGENES,data1B, by = 'gene')
data2B<-merge(aseGENES,data2B, by = 'gene')
data3B<-merge(aseGENES,data3B, by = 'gene')


data1$PSD = (data1[,2]/data1[,3])*100
data2$PSD = (data2[,2]/data2[,3])*100
data3$PSD = (data3[,2]/data3[,3])*100

data1B$PSD = (data1B[,2]/data1B[,3])*100
data2B$PSD = (data2B[,2]/data2B[,3])*100
data3B$PSD = (data3B[,2]/data3B[,3])*100

pdf(file = "/Final/seq_div_genes/PERCENT_SEQ_DIV_BOXPLOT.pdf")
boxplot(data1[,6],data1B[,6],data2[,6],data2B[,6],data3[,6],data3B[,6], ylab='Sequence divergernce (%)', xaxt="n", notch = TRUE, outline = F)
axis(1, at=1:6,lab=c("MM 7587", "MM 4851","SS 7587","SS 4851","MS 7587","MS 4851"))
dev.off()

summary(data1[,6])
summary(data1B[,6])
summary(data2[,6])
summary(data2B[,6])
summary(data3[,6])
summary(data3B[,6])

rm(list = ls())


####################################################################################################
####################################################################################################

# Read in the data from H1 v H2
data1<-read.delim("/Final/zhr_z30/mel-mel_H1+H2/outputs/zhrXz30_z30Xzhr_mRNA_meta_gene_output_120113.txt", header = TRUE);

data2<-read.delim("/Final/mel_sim/mel-sim_H1+H2/outputs/zhrXtsimbazaza_tsimbazazaXzhr_mRNA_meta_gene_output_120113.txt", header = TRUE);

data3<-read.delim("/Final/sim_sec/sim-sec_H1+H2/outputs/tsimbazazaXdroSec1_droSec1Xtsimbazaza_mRNA_meta_gene_output_120113.txt", header = TRUE);

####################################################################################################
####################################################################################################

data1$LOGH1RAT<-log2(data1[,2]/data1[,3])
data1$LOGH2RAT<-log2(data1[,6]/data1[,7])

data2$LOGH1RAT<-log2(data2[,2]/data2[,3])
data2$LOGH2RAT<-log2(data2[,6]/data2[,7])

data3$LOGH1RAT<-log2(data3[,2]/data3[,3])
data3$LOGH2RAT<-log2(data3[,6]/data3[,7])

####################################################################################################
####################################################################################################

cor(data1[,28],data1[,29], method = 's')
cor(data2[,28],data2[,29], method = 's')
cor(data3[,28],data3[,29], method = 's')

data1<-subset(data1, data1[,2] > 0 & data1[,3] > 0 & data1[,6] > 0 & data1[,7] > 0)
data2<-subset(data2, data2[,2] > 0 & data2[,3] > 0 & data2[,6] > 0 & data2[,7] > 0)
data3<-subset(data3, data3[,2] > 0 & data3[,3] > 0 & data3[,6] > 0 & data3[,7] > 0)

fit1<-lm(data1[,29]~data1[,28])
fit2<-lm(data2[,29]~data2[,28])
fit3<-lm(data3[,29]~data3[,28])

cor(data1[,28],data1[,29], method = 's')
cor(data2[,28],data2[,29], method = 's')
cor(data3[,28],data3[,29], method = 's')

summary(fit1)
summary(fit2)
summary(fit3)

####################################################################################################
####################################################################################################

rm(list = ls())

####################################################################################################
####################################################################################################
#get counts for mitochondrial genes
####################################################################################################
####################################################################################################

# Read in the data from H1 v H2
data31<-read.delim("/Final/zhr_z30/mel-mel_H1+H2/zhrXz30_z30Xzhr_mRNA.mosaik.genes_ASE.txt",header = TRUE)

data61<-read.delim("/Final/sim_sec/sim-sec_H1+H2/tsimbazazaXdroSec1_droSec1Xtsimbazaza_mRNA.mosaik.genes_ASE.txt",header = TRUE)

data91<-read.delim("/Final/mel_sim/mel-sim_H1+H2/zhrXtsimbazaza_tsimbazazaXzhr_mRNA.mosaik.genes_ASE.txt",header = TRUE)

####################################################################################################
####################################################################################################
#subset mitochondrial genes

#mel-mel
mito1<- subset(data31, (data31[,1] == 'CG34063') | (data31[,1] == 'CG34067') | (data31[,1] == 'CG34069') | (data31[,1] == 'CG34072') | (data31[,1] == 'CG34073') | (data31[,1] == 'CG34074') | (data31[,1] == 'CG34076') | (data31[,1] == 'CG34083') | (data31[,1] == 'CG34085') | (data31[,1] == 'CG34086') | (data31[,1] == 'CG34089') | (data31[,1] == 'CG34090') | (data31[,1] == 'CG34092'))

#sim-sec
mito2<- subset(data61, (data61[,1] == 'CG34063') | (data61[,1] == 'CG34067') | (data61[,1] == 'CG34069') | (data61[,1] == 'CG34072') | (data61[,1] == 'CG34073') | (data61[,1] == 'CG34074') | (data61[,1] == 'CG34076') | (data61[,1] == 'CG34083') | (data61[,1] == 'CG34085') | (data61[,1] == 'CG34086') | (data61[,1] == 'CG34089') | (data61[,1] == 'CG34090') | (data61[,1] == 'CG34092'))

#mel-sim
mito3<- subset(data91, (data91[,1] == 'CG34063') | (data91[,1] == 'CG34067') | (data91[,1] == 'CG34069') | (data91[,1] == 'CG34072') | (data91[,1] == 'CG34073') | (data91[,1] == 'CG34074') | (data91[,1] == 'CG34076') | (data91[,1] == 'CG34083') | (data91[,1] == 'CG34085') | (data91[,1] == 'CG34086') | (data91[,1] == 'CG34089') | (data91[,1] == 'CG34090') | (data91[,1] == 'CG34092'))

sum(mito1[,2])
sum(mito1[,3])
sum(mito1[,5])
sum(mito1[,6])

sum(mito2[,2])
sum(mito2[,3])
sum(mito2[,5])
sum(mito2[,6])

sum(mito3[,2])
sum(mito3[,3])
sum(mito3[,5])
sum(mito3[,6])

rm(list = ls())

####################################################################################################
####################################################################################################
#quality control
####################################################################################################
####################################################################################################

#mito genes

#CG34063
#CG34067
#CG34069
#CG34072
#CG34073
#CG34074
#CG34076
#CG34083
#CG34085
#CG34086
#CG34089
#CG34090
#CG34092

####################################################################################################
####################################################################################################
#ASE informative reads distribution
####################################################################################################
####################################################################################################

#mel-mel
data1<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/zhr+z30_zhrXz30_mRNA_gene_output_121312_classified_B.txt", header=TRUE)

#mel-sim
data3<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_gene_output_121312_classified_B.txt", header=TRUE)

#sim-sec
data6<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_gene_output_121312_classified_B.txt", header=TRUE)

#mel-mel
data1B<-read.delim("/Final/zhr_z30/mel-mel_P+H1/outputs/zhr+z30_zhrXz30_mRNA_meta_gene_output_121312_classified_B.txt", header=TRUE)

#mel-sim
data3B<-read.delim("/Final/mel_sim/mel-sim_P+H1/outputs/zhr+tsimbazaza_zhrXtsimbazaza_mRNA_meta_gene_output_121312_classified_B.txt", header=TRUE)

#sim-sec
data6B<-read.delim("/Final/sim_sec/sim-sec_P+H1/outputs/tsimbazaza+droSec1_tsimbazazaXdroSec1_mRNA_meta_gene_output_121312_classified_B.txt", header=TRUE)

###################################################################################################
###################################################################################################
#proportion informative for ASE

hist1<-hist((data1[,5]/(data1[,5]+data1[,4])),breaks = 100, freq = TRUE, col=rgb(t(col2rgb("black")),alpha=150,maxColorValue=255), main = 'Proportion of reads that are allele-specific', xlab = 'Proportion of reads that are allele-specific',ylim = c(0,1000))
hist2<-hist((data6[,5]/(data6[,5]+data6[,4])),breaks = 100, freq = TRUE, col=rgb(t(col2rgb("blue")),alpha=150,maxColorValue=255),ylim = c(0,1000),add = T)
hist3<-hist((data3[,5]/(data3[,5]+data3[,4])),breaks = seq(0,1,0.01), freq = TRUE, col=rgb(t(col2rgb("red")),alpha=150,maxColorValue=255), add = T,ylim = c(0,1000))

names1<-seq(0.01,1,0.01)

pdf(file = "/Final/meta/ASE-informative-reads_021313.pdf")

barplot(hist1$counts/nrow(data1),names.arg=names1,ylim = c(0,0.12),axes=FALSE,axisnames=FALSE,col=rgb(t(col2rgb("blue3")),alpha=150,maxColorValue=255))
barplot(hist2$counts/nrow(data6),names.arg=names1,ylim = c(0,0.12),add = T,col=rgb(t(col2rgb("red")),alpha=150,maxColorValue=255),axes=FALSE,axisnames=FALSE)
barplot(hist3$counts/nrow(data3),names.arg=names1,ylim = c(0,0.12),add = T,col=rgb(t(col2rgb("green4")),alpha=150,maxColorValue=255),xlim = c(0,1), main = 'Proportion of reads that are allele-specific', xlab = 'Proportion of reads that are allele-specific',ylab= 'Density')

dev.off()

rm(list=ls())

####################################################################################################
###################################################################################################
#proportion informative for ASE in meta

data1C<-merge(data1B, data1, by = 'gene')
data3C<-merge(data3B, data3, by = 'gene')
data6C<-merge(data6B, data6, by = 'gene')

#1-50


hist1B<-hist((data1C[,5]/(data1C[,5]+data1C[,53])),breaks = 100, freq = TRUE, col=rgb(t(col2rgb("black")),alpha=150,maxColorValue=255), main = 'Proportion of reads that are allele-specific', xlab = 'Proportion of reads that are allele-specific',ylim = c(0,1000))
hist2B<-hist((data6C[,5]/(data6C[,5]+data6C[,53])),breaks = 100, freq = TRUE, col=rgb(t(col2rgb("blue")),alpha=150,maxColorValue=255),ylim = c(0,1000),add = T)
hist3B<-hist((data3C[,5]/(data3C[,5]+data3C[,53])),breaks = seq(0,1,0.01), freq = TRUE, col=rgb(t(col2rgb("red")),alpha=150,maxColorValue=255), add = T,ylim = c(0,1000))

names1<-seq(0.01,1,0.01)

pdf(file = "/Final/meta/ASE-informative-reads_meta_121312.pdf")

barplot(hist1B$counts/nrow(data1C),names.arg=names1,ylim = c(0,0.12),axes=FALSE,axisnames=FALSE,col=rgb(t(col2rgb("black")),alpha=150,maxColorValue=255))
barplot(hist2B$counts/nrow(data6C),names.arg=names1,ylim = c(0,0.12),add = T,col=rgb(t(col2rgb("blue")),alpha=150,maxColorValue=255),axes=FALSE,axisnames=FALSE)
barplot(hist3B$counts/nrow(data3C),names.arg=names1,ylim = c(0,0.12),add = T,col=rgb(t(col2rgb("red")),alpha=150,maxColorValue=255),xlim = c(0,1), main = 'Proportion of reads that are allele-specific', xlab = 'Proportion of reads that are allele-specific',ylab= 'Density')

dev.off()

rm(list=ls())


####################################################################################################
####################################################################################################

#THE END!!