/*
Copyright (c) 2011-2012 Daniel Marbach(1,2)

(1) Massachusetts Institute of Technology, Cambridge MA, USA
(2) Broad Institute of MIT and Harvard
 
We release this software open source under an MIT license (see below). If this
software was useful for your scientific work, please cite our paper available at:
http://compbio.mit.edu/flynet

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 */
package edu.mit.compbio.flynet.misc;

import edu.mit.compbio.flynet.*;


/**
 * Parses the HiC data.
 */
public class GenomeInteractionMapParser {
	
	
	// ============================================================================
	// PUBLIC METHODS
	
	/**  */
	public GenomeInteractionMapParser() {
		
	}
	
	
	// ----------------------------------------------------------------------------

	/** Parse Table S3 (mmc3.txt) and write it as a network */ 
	public void parseMmc3() {
		
		String inputFile = "resources_private/HiC/clusters_detailed.txt";
		String outputFile = "resources_private/HiC/long_range_interactions_unfiltered.txt";
		Flynet.println("Reading file: " + inputFile);
		Flynet.println("Writing file: " + outputFile);
		
		FileParser parser = new FileParser(inputFile);
		parser.skipLines(1); // the header
		FileExport writer = new FileExport(outputFile);
		
		while (true) {
			String[] line = parser.readLine();
			if (line == null)
				break;
			else if (line.length != 11)
				throw new RuntimeException("Line " + parser.getLineCounter() + " does not have 11 columns!");

			String[] genesX = line[9].split(",");
			String[] genesY = line[10].split(",");
			double w = Double.parseDouble(line[8]);
			
			for (int x=0; x<genesX.length; x++)
				for (int y=0; y<genesY.length; y++)
					writer.println(genesX[x] + "\t" + genesY[y] + "\t" + w);
		}
		parser.close();
		writer.close();
	}
	  	

	// ============================================================================
	// PRIVATE METHODS


}
