package edu.mit.compbio.flynet.genome;

import java.util.Iterator;


/**
 * Flybase genome annotation 
 */
public class FlyBase {

	/** The genome */
	Genome genome_ = null;

	
	// ============================================================================
	// PUBLIC METHODS
	
	/** Default constructor */
	public FlyBase(Genome genome) {
		genome_ = genome;
	}
	
	
	// ----------------------------------------------------------------------------

	/** Load the genes from the flybase gff file */
	@SuppressWarnings("unchecked")
	public void loadGenes(String filename) {
						
		// Start the TSV parser, there is no header
		ParserGff parser = new ParserGff(filename);
		
		while (true) {
			
			// The next gene
			Gene gene = new Gene();
			
			// Read the next line from the file, stop if there were no more lines
			if (!parser.readLineGff(gene))
				break;
			
			// Set the fbgn
			gene.setFbgn(parser.getFeature("ID"));
			
			genome_.addGene(parser.getChromosomeString(), gene);
		}

		// sort the genes according to their start
		Iterator<Chromosome> iter = genome_.getChromosomes().values().iterator();
		while (iter.hasNext()) {
			assert Region.isSorted(iter.next().getGenes());
			//Collections.sort(genes, new Region.CompareStart());
		}
		
	}

	

}
