package edu.mit.compbio.flynet.genome;

import java.util.ArrayList;


/**
 * Flybase genome annotation 
 */
public class Chromosome implements java.io.Serializable {

	/** Serial version UID, for serialization */
	private static final long serialVersionUID = 1;

	/** The name of the chromosome */
	String name_ = "";
	/** The FlyBase genes */
	private ArrayList<Gene> genes_ = new ArrayList<Gene>();
	
	
	// ============================================================================
	// PUBLIC METHODS
	
	/** Constructor */
	public Chromosome(String name) {
		name_ = name;
	}


	// ----------------------------------------------------------------------------

	/** Add the given gene */
	public void addGene(Gene gene) {
		genes_.add(gene);
	}
	

	// ----------------------------------------------------------------------------

	/** Print some statistics to the console */
	public void printStatistics() {
		String line = name_ + "\t" + genes_.size();
		System.out.println(line);
	}


	// ============================================================================
	// GETTERS AND SETTERS

	public String getName() { return name_; }
	
	@SuppressWarnings("rawtypes")
	public ArrayList getGenes() { return genes_; }

}
