/*
Copyright (c) 2011-2012 Daniel Marbach(1,2)

(1) Massachusetts Institute of Technology, Cambridge MA, USA
(2) Broad Institute of MIT and Harvard
 
We release this software open source under an MIT license (see below). If this
software was useful for your scientific work, please cite our paper available at:
http://compbio.mit.edu/flynet

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 */
package edu.mit.compbio.flynet;

import java.util.ArrayList;
import java.util.HashSet;


/**
 * Represents a node (gene/TF) of the network
 */
public class Node {

	/** A unique label/ID */
	private String label_ = null;
	
	/** The list of incoming edges of this gene */
	private ArrayList<Edge> incomingEdges_ = null;
	/** The list of outgoing edges of this TF */
	private ArrayList<Edge> outgoingEdges_ = null;
	
	
	// ============================================================================
	// PUBLIC METHODS
	    
	/** Constructor */
	public Node(String label) {
		
		label_ = label;
		incomingEdges_ = new ArrayList<Edge>();
		outgoingEdges_ = new ArrayList<Edge>();
	}
	
	
    // ----------------------------------------------------------------------------

	/** Add the given node to the set of regulators */
	public void addIncomingEdge(Edge e) {
		if (e.getTarget() != this)
			throw new IllegalArgumentException("Not an incoming edge of this TF");
		incomingEdges_.add(e);
	}

	
    // ----------------------------------------------------------------------------

	/** Add the given edge to the set of outgoing edges */
	public void addOutgoingEdge(Edge e) {
		if (e.getTf() != this)
			throw new IllegalArgumentException("Not an outgoing edge of this TF");
		outgoingEdges_.add(e);
	}

	
    // ----------------------------------------------------------------------------

	/** Get the set of regulators of this gene */
	public HashSet<String> getRegulators() {
		
		HashSet<String> tfs = new HashSet<String>();
		for (int i=0; i<incomingEdges_.size(); i++)
			tfs.add(incomingEdges_.get(i).getTf().getLabel());
		
		return tfs;
	}

	
	// ============================================================================
	// PRIVATE METHODS

    
	// ============================================================================
	// SETTERS AND GETTERS

	public String getLabel() { return label_; }
	public void setLabel(String label) { label_ = label; }
	
	public ArrayList<Edge> getIncomingEdges() { return incomingEdges_; }
	public ArrayList<Edge> getOutgoingEdges() { return outgoingEdges_; }
	
}
