/*
Copyright (c) 2011-2012 Daniel Marbach(1,2)

(1) Massachusetts Institute of Technology, Cambridge MA, USA
(2) Broad Institute of MIT and Harvard
 
We release this software open source under an MIT license (see below). If this
software was useful for your scientific work, please cite our paper available at:
http://compbio.mit.edu/flynet

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 */
package edu.mit.compbio.flynet;


/**
 * Interaction dataset (protein-protein or HiC long-range interactions)
 */
public class InteractionDataset extends Network implements FunctionalDataset {
	
	// ============================================================================
	// PUBLIC METHODS
	
	/** Load the interaction network */
	public void load(String filename) {
		load(filename, false);
	}

	
	// ----------------------------------------------------------------------------

	/** Returns true if the given gene is part of the network */
	public boolean contains(Node gene) {
		return getNodes().containsKey(gene.getLabel());
	}


	// ----------------------------------------------------------------------------

	/** Returns the weight of the interaction, 0 if there is no such interaction */
	public double functionalRelation(Node gene1, Node gene2) {

		// These networks are undirected, so we have to test for both edges
		
		Edge ppi1 = getEdge(gene1.getLabel(), gene2.getLabel());
		if (ppi1 != null)
			return ppi1.getWeight();
		
		Edge ppi2 = getEdge(gene2.getLabel(), gene1.getLabel());
		if (ppi2 != null)
			return ppi2.getWeight();
		
		return 0.0;
	}    
}
