/*
Copyright (c) 2011-2012 Daniel Marbach(1,2)

(1) Massachusetts Institute of Technology, Cambridge MA, USA
(2) Broad Institute of MIT and Harvard
 
We release this software open source under an MIT license (see below). If this
software was useful for your scientific work, please cite our paper available at:
http://compbio.mit.edu/flynet

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 */
package edu.mit.compbio.flynet;


/**
 * Interface for functional datasets (expression, annotation, etc.) 
 * used for the functional enrichment analysis.
 */
public interface FunctionalDataset {


	// ============================================================================
	// ABSTRACT PUBLIC METHODS
	
	/** Load the dataset from the given file */
	abstract public void load(String filename);
	/** Returns true if the given gene is present in this dataset */
	abstract public boolean contains(Node gene);
	/** Compute a "functional relation" between the two genes (co-annotation, co-expression, etc) */
	abstract public double functionalRelation(Node gene1, Node gene2);	
	/** Get the name of this dataset */
	abstract public void setName(String name);
	/** Get the name of this dataset */
	abstract public String getName();
	
}
