/*
Copyright (c) 2011-2012 Daniel Marbach(1,2)

(1) Massachusetts Institute of Technology, Cambridge MA, USA
(2) Broad Institute of MIT and Harvard
 
We release this software open source under an MIT license (see below). If this
software was useful for your scientific work, please cite our paper available at:
http://compbio.mit.edu/flynet

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 */
package edu.mit.compbio.flynet;


/**
 * Represents an undirected edge between two nodes
 */
public class Edge implements Comparable<Edge> {

	/** The TF */
	private Node tf_ = null;
	/** The target gene */
	private Node target_ = null;
	/** The weight */
	private double weight_ = -1;
	/** Different features supporting this edge - only used by the integrative networks */
	private double[] features_ = null;
	

	// ============================================================================
	// PUBLIC METHODS
	
	public Edge(Node tf, Node target, double weight) {
		tf_ = tf;
		target_ = target;
		weight_ = weight;
	}
	
	
	// ----------------------------------------------------------------------------
	
	/** Compare the weights of the two edges (used for sorting with the Comparable interface) */
	public int compareTo(Edge edge2) {
		if (this.weight_ == edge2.weight_)
			return 0;
		else if (this.weight_ < edge2.weight_)
			return 1;
		else
			return -1;
	}

	
	// ============================================================================
	// SETTERS AND GETTERS

    public Node getTf() { return tf_; }
    public Node getTarget() { return target_; }
    
    public void setWeight(double w) { weight_ =  w; }
    public double getWeight() { return weight_; }
    
    public void setFeatures(double[] f) { features_ = f; }
    public double[] getFeatures() { return features_; }
    
    
}
