/*
 * Decompiled with CFR 0.152.
 */
package jsc.util;

import java.util.BitSet;
import jsc.combinatorics.Selection;

public class BitVector
extends BitSet
implements Selection {
    private int n;

    public BitVector(int n) {
        super(n);
        this.n = n;
    }

    public BitVector(boolean[] blArray) {
        this(blArray.length);
        int n = 0;
        while (n < this.n) {
            this.set(n, blArray[n]);
            ++n;
        }
    }

    public BitVector(int[] nArray) {
        this(nArray.length);
        int n = 0;
        while (n < this.n) {
            if (nArray[n] == 0) {
                this.set(n, false);
            } else if (nArray[n] == 1) {
                this.set(n, true);
            } else {
                throw new IllegalArgumentException("Array must contain only 0 or 1.");
            }
            ++n;
        }
    }

    public int length() {
        return this.n;
    }

    public boolean[] toBooleanArray() {
        boolean[] blArray = new boolean[this.n];
        int n = 0;
        while (n < this.n) {
            blArray[n] = this.get(n);
            ++n;
        }
        return blArray;
    }

    public int[] toIntArray() {
        int[] nArray = new int[this.n];
        int n = 0;
        while (n < this.n) {
            nArray[n] = this.get(n) ? 1 : 0;
            ++n;
        }
        return nArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.n) {
            stringBuffer.append(this.get(n) ? 1 : 0);
            ++n;
        }
        return stringBuffer.toString();
    }
}

