/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.control;

import java.text.DecimalFormat;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;

public class RealLogSlider
extends JSlider {
    double minVal;
    double logRange;

    public RealLogSlider(double d, double d2, double d3, int n, double[] dArray, String string) {
        super(0);
        if (d <= 0.0 || d2 <= d) {
            throw new IllegalArgumentException("Illegal range for logarithmic slider.");
        }
        this.minVal = d;
        this.logRange = Math.log(d2 / d);
        this.setMinimum(0);
        this.setMaximum(n);
        this.setValue(this.getSliderValue(d3));
        this.setPaintTicks(false);
        int n2 = dArray.length;
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>(n2);
        DecimalFormat decimalFormat = new DecimalFormat(string);
        int n3 = 0;
        while (n3 < n2) {
            double d4 = dArray[n3];
            if (d4 >= d && d4 <= d2) {
                hashtable.put(new Integer(this.getSliderValue(d4)), new JLabel(decimalFormat.format(d4)));
            }
            ++n3;
        }
        this.setLabelTable(hashtable);
        this.setPaintLabels(true);
    }

    public double getRealValue() {
        return this.getRealValue(this.getValue());
    }

    double getRealValue(int n) {
        return this.minVal * Math.exp((double)n * this.logRange / (double)this.getMaximum());
    }

    int getSliderValue(double d) {
        double d2 = (double)this.getMaximum() * Math.log(d / this.minVal) / this.logRange;
        return (int)Math.round(d2);
    }

    public void setRealValue(double d) {
        this.setValue(this.getSliderValue(d));
    }
}

