/*
 * Decompiled with CFR 0.152.
 */
package jsc.onesample;

import jsc.ci.AbstractConfidenceInterval;
import jsc.descriptive.MeanVar;
import jsc.distributions.ChiSquared;

public class NormalVarianceCI
extends AbstractConfidenceInterval {
    private final double var;

    public NormalVarianceCI(double[] dArray, double d) {
        super(d);
        MeanVar meanVar = new MeanVar(dArray);
        int n = meanVar.getN() - 1;
        ChiSquared chiSquared = new ChiSquared(n);
        double d2 = 1.0 - d;
        double d3 = 0.5 * d2;
        double d4 = chiSquared.inverseCdf(d3);
        double d5 = chiSquared.inverseCdf(1.0 - d3);
        this.var = meanVar.getVariance();
        double d6 = (double)n * this.var;
        this.lowerLimit = d6 / d5;
        this.upperLimit = d6 / d4;
    }

    public double getVariance() {
        return this.var;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{293.7, 296.2, 296.4, 294.0, 297.3, 293.7, 294.3, 291.3, 295.1, 296.1};
            NormalVarianceCI normalVarianceCI = new NormalVarianceCI(dArray, 0.9);
            System.out.println("Variance = " + normalVarianceCI.getVariance() + " CI = [" + normalVarianceCI.getLowerLimit() + ", " + normalVarianceCI.getUpperLimit() + "]");
        }
    }
}

