/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.descriptive.Tally;
import jsc.distributions.AbstractDiscreteDistribution;
import jsc.distributions.Distribution;
import jsc.distributions.Normal;
import jsc.goodnessfit.ChiSquaredFitTest;
import jsc.util.Maths;

public class MannWhitneyU
extends AbstractDiscreteDistribution {
    public static final int MAX_PRODUCT = 10000;
    private int n;
    private int nA;
    private int nB;
    private double[] p;

    public MannWhitneyU(int n, int n2) {
        super(0L, n * n2);
        if (this.maxValue > 10000L) {
            throw new IllegalArgumentException("Cannot calculate exact distribution: try normal approximation.");
        }
        this.nA = n;
        this.nB = n2;
        this.n = (int)Math.ceil(0.5 * (double)this.maxValue);
        this.p = new double[1 + this.n];
        MannWhitneyU.harding(false, n, n2, this.n, this.p);
        double d = Maths.logBinomialCoefficient(n + n2, n);
        int n3 = 0;
        while (n3 <= this.n) {
            this.p[n3] = Math.exp(Math.log(this.p[n3]) - d);
            if (Double.isNaN(this.p[n3])) {
                throw new RuntimeException("Cannot calculate exact distribution: try normal approximation.");
            }
            ++n3;
        }
    }

    public long criticalValue(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        long l = this.minValue;
        double d2 = this.pdf(l);
        while (l < this.maxValue && d2 < d) {
            d2 += this.pdf(++l);
        }
        if (Math.abs(d2 - d) < 1.0E-11) {
            return l;
        }
        return --l;
    }

    public static void harding(boolean bl, int n, int n2, int n3, double[] dArray) {
        int n4;
        int n5;
        int n6;
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("Sample size too small.");
        }
        if (!bl) {
            dArray[0] = 1.0;
            n6 = 1;
            while (n6 <= n3) {
                dArray[n6] = 0.0;
                ++n6;
            }
        }
        if (n2 + 1 <= n3) {
            n5 = Math.min(n + n2, n3);
            n6 = n2 + 1;
            while (n6 <= n5) {
                n4 = n3;
                while (n4 >= n6) {
                    int n7 = n4;
                    dArray[n7] = dArray[n7] - dArray[n4 - n6];
                    --n4;
                }
                ++n6;
            }
        }
        n5 = Math.min(n, n3);
        n6 = 1;
        while (n6 <= n5) {
            n4 = n6;
            while (n4 <= n3) {
                int n8 = n4;
                dArray[n8] = dArray[n8] + dArray[n4 - n6];
                ++n4;
            }
            ++n6;
        }
    }

    public double mean() {
        return 0.5 * (double)this.nA * (double)this.nB;
    }

    public static Normal normalApproximation(int n, int n2, int n3) {
        double d = n + n2;
        double d2 = n * n2;
        double d3 = (d * d * d - d - (double)n3) / 12.0;
        if (n3 < 0 || d3 <= 0.0) {
            throw new IllegalArgumentException("Invalid samples sizes or correction factor.");
        }
        double d4 = 0.5 * d2;
        double d5 = Math.sqrt(d2 / (d * (d - 1.0)) * d3);
        return new Normal(d4, d5);
    }

    public double pdf(double d) {
        int n = (int)d;
        if ((long)n < this.minValue || (long)n > this.maxValue) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        if (n <= this.n) {
            return this.p[n];
        }
        return this.p[(int)(this.maxValue - (long)n)];
    }

    public String toString() {
        return new String("Mann-Whitney U distribution: nA = " + this.nA + ", nB = " + this.nB + ".");
    }

    public double variance() {
        return (double)(this.nA * this.nB) * ((double)(this.nA + this.nB) + 1.0) / 12.0;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            MannWhitneyU mannWhitneyU = new MannWhitneyU(50, 40);
            int n = 10000;
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = (int)mannWhitneyU.random();
                ++n2;
            }
            ChiSquaredFitTest chiSquaredFitTest = new ChiSquaredFitTest(new Tally(nArray), (Distribution)mannWhitneyU, 0);
            System.out.println("All E > 5 " + chiSquaredFitTest.poolBins());
            System.out.println("n = " + n + " Chi-squared = " + chiSquaredFitTest.getTestStatistic() + " SP = " + chiSquaredFitTest.getSP());
        }
    }
}

