/*
 * Decompiled with CFR 0.152.
 */
package jsc.util;

import jsc.swt.text.SigFigFormat;

public class Maths {
    public static final double EULER = 0.577215664901533;
    public static final double LOG2 = Math.log(2.0);
    public static final double LOG10 = Math.log(10.0);
    static final double[] R = new double[]{0.0, 0.0, LOG2, Math.log(6.0), Math.log(24.0), Math.log(120.0), Math.log(720.0)};
    static final double[] R1 = new double[]{0.0, -2.66685511495, -24.4387534237, -21.9698958928, 11.1667541262, 3.13060547623, 0.607771387771, 11.9400905721, 31.4690115749, 15.234687407};
    static final double[] R2 = new double[]{0.0, -78.3359299449, -142.046296688, 137.519416416, 78.6994924154, 4.16438922228, 47.066876606, 313.399215894, 263.505074721, 43.3400022514};
    static final double[] R3 = new double[]{0.0, -212159.572323, 230661.510616, 27464.7644705, -40262.1119975, -2296.6072978, -116328.495004, -146025.937511, -24235.7409629, -570.691009324};
    static final double[] R4 = new double[]{0.0, 0.279195317918525, 0.4917317610505968, 0.0692910599291889, 3.350343815022304, 6.012459259764103};
    static final double ALR2PI = 0.918938533204673;
    static final double XLGE = 5100000.0;
    static final double XLGST = 1.0E305;

    private Maths() {
    }

    public static double binomialCoefficient(long l, long l2) {
        return Math.rint(Math.exp(Maths.logBinomialCoefficient(l, l2)));
    }

    public static double factorial(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Invalid argument of factorial function.");
        }
        if (l > 8L) {
            return Math.rint(Math.exp(Maths.logFactorial(l)));
        }
        int n = 1;
        int n2 = 2;
        while ((long)n2 <= l) {
            n *= n2;
            ++n2;
        }
        return n;
    }

    public static double fmod(double d, double d2) {
        double d3 = d / Math.abs(d2);
        return d3 - Maths.truncate(d3);
    }

    public static boolean isNoneNegativeInteger(double d) {
        return d >= 0.0 && d == Math.floor(d);
    }

    public static boolean isPositiveInteger(double d) {
        return d > 0.0 && d == Math.floor(d);
    }

    public static double lnB(double d, double d2) {
        return Maths.logGamma(d) + Maths.logGamma(d2) - Maths.logGamma(d + d2);
    }

    public static double log2(double d) {
        return Math.log(d) / LOG2;
    }

    public static double log10(double d) {
        return Math.log(d) / LOG10;
    }

    public static double logBinomialCoefficient(long l, long l2) {
        return Maths.logFactorial(l) - Maths.logFactorial(l2) - Maths.logFactorial(l - l2);
    }

    public static double logFactorial(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Invalid argument of log factorial function.");
        }
        if (l < 7L) {
            return R[(int)l];
        }
        double d = l + 1L;
        double d2 = 1.0 / (d * d);
        return (d - 0.5) * Math.log(d) - d + 0.918938533205 + (((4.0 - 3.0 * d2) * d2 - 14.0) * d2 + 420.0) / (5040.0 * d);
    }

    public static double logGamma(double d) {
        double d2 = d;
        double d3 = 0.0;
        if (d2 <= 0.0 || d2 >= 1.0E305) {
            throw new IllegalArgumentException("Invalid argument of log Gamma function.");
        }
        if (d2 < 1.5) {
            double d4;
            if (d2 < 0.5) {
                d3 = -Math.log(d2);
                d4 = d2 + 1.0;
                if (d4 == 1.0) {
                    return d3;
                }
            } else {
                d3 = 0.0;
                d4 = d2;
                d2 = d2 - 0.5 - 0.5;
            }
            return d3 += d2 * ((((R1[5] * d4 + R1[4]) * d4 + R1[3]) * d4 + R1[2]) * d4 + R1[1]) / ((((d4 + R1[9]) * d4 + R1[8]) * d4 + R1[7]) * d4 + R1[6]);
        }
        if (d2 < 4.0) {
            double d5 = d2 - 1.0 - 1.0;
            d3 = d5 * ((((R2[5] * d2 + R2[4]) * d2 + R2[3]) * d2 + R2[2]) * d2 + R2[1]) / ((((d2 + R2[9]) * d2 + R2[8]) * d2 + R2[7]) * d2 + R2[6]);
            return d3;
        }
        if (d2 < 12.0) {
            d3 = ((((R3[5] * d2 + R3[4]) * d2 + R3[3]) * d2 + R3[2]) * d2 + R3[1]) / ((((d2 + R3[9]) * d2 + R3[8]) * d2 + R3[7]) * d2 + R3[6]);
            return d3;
        }
        double d6 = Math.log(d2);
        d3 = d2 * (d6 - 1.0) - 0.5 * d6 + 0.918938533204673;
        if (d2 > 5100000.0) {
            return d3;
        }
        double d7 = 1.0 / d2;
        double d8 = d7 * d7;
        return d3 += d7 * ((R4[3] * d8 + R4[2]) * d8 + R4[1]) / ((d8 + R4[5]) * d8 + R4[4]);
    }

    public static double logMultinomialCoefficient(int[] nArray) {
        int n = 0;
        double d = 0.0;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (nArray[n3] < 0) {
                throw new IllegalArgumentException("Negative number of objects.");
            }
            n += nArray[n3];
            d += Maths.logFactorial(nArray[n3]);
            ++n3;
        }
        return Maths.logFactorial(n) - d;
    }

    public static double multinomialCoefficient(int[] nArray) {
        return Math.rint(Math.exp(Maths.logMultinomialCoefficient(nArray)));
    }

    public static boolean multOverflow(double d, double d2) {
        if ((d = Math.abs(d)) > (d2 = Math.abs(d2))) {
            double d3 = d2;
            d2 = d;
            d = d3;
        }
        return !(d2 <= 1.0) && !(d < Double.MAX_VALUE / d2);
    }

    public static double round(double d, int n) {
        double d2 = Math.pow(10.0, n);
        return Math.floor(d * d2 + 0.5) / d2;
    }

    public static double roundSigFigs(double d, int n) {
        SigFigFormat sigFigFormat = new SigFigFormat(n);
        return sigFigFormat.round(d);
    }

    public static double sign(double d) {
        if (d > 0.0) {
            return 1.0;
        }
        if (d < 0.0) {
            return -1.0;
        }
        return 0.0;
    }

    public static double truncate(double d) {
        if (d >= 0.0) {
            return Math.floor(d);
        }
        return -Math.floor(Math.abs(d));
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 0;
            while (n <= 20) {
                System.out.println("j = " + n + " " + Maths.logFactorial(n));
                System.out.println("j = " + n + " " + Maths.logGamma((double)n + 1.0));
                ++n;
            }
        }
    }
}

