/*
 * Decompiled with CFR 0.152.
 */
package jsc.tests;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import jsc.distributions.Tail;
import jsc.event.StatisticEvent;
import jsc.event.StatisticListener;
import jsc.tests.SignificanceTest;

public abstract class ResampleTest
implements SignificanceTest {
    private long critCount = 0L;
    private long totalRepCount = 0L;
    private final double tObs;
    private double SP = 0.0;
    private final Tail tail;
    protected Random rand;
    protected Set statisticListeners;

    public ResampleTest(double d, Tail tail, StatisticListener statisticListener) {
        this.tail = tail;
        this.tObs = d;
        this.rand = new Random();
        this.statisticListeners = new HashSet(1);
        if (statisticListener != null) {
            this.addStatisticListener(statisticListener);
        }
    }

    protected abstract double bootstrapSample();

    public double calculateSP(int n) {
        int n2 = 0;
        while (n2 < n) {
            double d = this.bootstrapSample();
            if (!this.statisticListeners.isEmpty()) {
                this.fireStatisticEvent(new StatisticEvent(this, d));
            }
            if (this.tail == Tail.UPPER) {
                if (d >= this.tObs) {
                    ++this.critCount;
                }
            } else if (this.tail == Tail.LOWER) {
                if (d <= this.tObs) {
                    ++this.critCount;
                }
            } else if (Math.abs(d) >= Math.abs(this.tObs)) {
                ++this.critCount;
            }
            ++this.totalRepCount;
            ++n2;
        }
        this.SP = (double)this.critCount / (double)this.totalRepCount;
        return this.SP;
    }

    public double getSP() {
        return (double)this.critCount / (double)this.totalRepCount;
    }

    public double getTestStatistic() {
        return this.tObs;
    }

    public long getTotalRepCount() {
        return this.totalRepCount;
    }

    public void setSeed(long l) {
        this.rand.setSeed(l);
    }

    public void addStatisticListener(StatisticListener statisticListener) {
        this.statisticListeners.add(statisticListener);
    }

    public void removeStatisticListener(StatisticListener statisticListener) {
        this.statisticListeners.remove(statisticListener);
    }

    private void fireStatisticEvent(StatisticEvent statisticEvent) {
        Iterator iterator = this.statisticListeners.iterator();
        while (iterator.hasNext()) {
            StatisticListener statisticListener = (StatisticListener)iterator.next();
            statisticListener.statisticCreated(statisticEvent);
        }
    }
}

