/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.menu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LookAndFeelMenu
extends JMenu {
    static final String WINDOWS_LAF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    static final String MAC_LAF = "javax.swing.plaf.mac.MacLookAndFeel";
    static final String JAVA_LAF = UIManager.getCrossPlatformLookAndFeelClassName();
    static final String MOTIF_LAF = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    Component parent;

    public LookAndFeelMenu(Component component) {
        super("Look & feel");
        this.parent = component;
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Windows");
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem("Java");
        JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem("Motif");
        JRadioButtonMenuItem jRadioButtonMenuItem4 = new JRadioButtonMenuItem("Mac");
        LookAndFeelListener lookAndFeelListener = new LookAndFeelListener();
        jRadioButtonMenuItem.addActionListener(lookAndFeelListener);
        jRadioButtonMenuItem2.addActionListener(lookAndFeelListener);
        jRadioButtonMenuItem3.addActionListener(lookAndFeelListener);
        jRadioButtonMenuItem4.addActionListener(lookAndFeelListener);
        String string = UIManager.getSystemLookAndFeelClassName();
        if (string.equals(WINDOWS_LAF)) {
            jRadioButtonMenuItem.setSelected(true);
            jRadioButtonMenuItem4.setEnabled(false);
        } else if (string.equals(JAVA_LAF)) {
            jRadioButtonMenuItem2.setSelected(true);
        } else if (string.equals(MOTIF_LAF)) {
            jRadioButtonMenuItem3.setSelected(true);
        } else if (string.equals(MAC_LAF)) {
            jRadioButtonMenuItem4.setSelected(true);
        }
        buttonGroup.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem2);
        buttonGroup.add(jRadioButtonMenuItem3);
        buttonGroup.add(jRadioButtonMenuItem4);
        this.add(jRadioButtonMenuItem);
        this.add(jRadioButtonMenuItem2);
        this.add(jRadioButtonMenuItem3);
        this.add(jRadioButtonMenuItem4);
    }

    class LookAndFeelListener
    implements ActionListener {
        LookAndFeelListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            try {
                String string2;
                if (string.equals("Java")) {
                    string2 = JAVA_LAF;
                } else if (string.equals("Windows")) {
                    string2 = LookAndFeelMenu.WINDOWS_LAF;
                } else if (string.equals("Mac")) {
                    string2 = LookAndFeelMenu.MAC_LAF;
                } else if (string.equals("Motif")) {
                    string2 = LookAndFeelMenu.MOTIF_LAF;
                } else {
                    return;
                }
                UIManager.setLookAndFeel(string2);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(LookAndFeelMenu.this.parent, string + " look and feel unavailable on your system.", "Error", 0);
            }
            SwingUtilities.updateComponentTreeUI(LookAndFeelMenu.this.parent);
        }
    }
}

