/*
 * Decompiled with CFR 0.152.
 */
package jsc.regression;

import jsc.curvefitting.StraightLineFit;
import jsc.datastructures.PairedData;

public class PearsonCorrelation
implements StraightLineFit {
    private final int n;
    private final double r;
    private final double a;
    private final double b;

    public PearsonCorrelation(PairedData pairedData) {
        this.n = pairedData.getN();
        double[] dArray = pairedData.getX();
        double[] dArray2 = pairedData.getY();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n = 0;
        while (n < this.n) {
            d5 += dArray[n];
            d4 += dArray2[n];
            ++n;
        }
        d5 /= (double)this.n;
        d4 /= (double)this.n;
        n = 0;
        while (n < this.n) {
            double d6 = dArray[n] - d5;
            double d7 = dArray2[n] - d4;
            d3 += d6 * d6;
            d += d7 * d7;
            d2 += d6 * d7;
            ++n;
        }
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("X data are constant.");
        }
        this.b = d2 / d3;
        this.a = d4 - this.b * d5;
        if (d <= 0.0) {
            throw new IllegalArgumentException("Y data are constant.");
        }
        this.r = d2 / Math.sqrt(d3 * d);
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public int getN() {
        return this.n;
    }

    public double getR() {
        return this.r;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{8.000001, 8.000003, 8.000002, 8.000004, 8.000005};
            double[] dArray2 = new double[]{8.0, 9.0, 10.0, 11.0, 12.0};
            PearsonCorrelation pearsonCorrelation = new PearsonCorrelation(new PairedData(dArray, dArray2));
            System.out.println("n = " + pearsonCorrelation.getN());
            System.out.println("r = " + pearsonCorrelation.getR());
            System.out.println("a = " + pearsonCorrelation.getA());
            System.out.println("b = " + pearsonCorrelation.getB());
        }
    }
}

