/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.distributions.AbstractContinuousDistribution;
import jsc.distributions.Beta;
import jsc.goodnessfit.KolmogorovTest;
import jsc.numerical.Function;
import jsc.numerical.Integration;
import jsc.numerical.NumericalException;
import jsc.numerical.Spline;
import jsc.tests.H1;

public class SplineShape
extends AbstractContinuousDistribution {
    double pdfMax;
    Spline spline;
    double mean;
    double variance;

    public SplineShape(int n, double[] dArray, double[] dArray2) throws NumericalException {
        this(new Spline(n, dArray, dArray2));
    }

    public SplineShape(Spline spline) throws NumericalException {
        super(spline.getMinX(), spline.getMaxX(), false);
        int n = spline.getN();
        this.minX = spline.getMinX();
        this.maxX = spline.getMaxX();
        this.spline = spline;
        SplineCurve splineCurve = new SplineCurve();
        double d = Integration.romberg((Function)splineCurve, this.minX, this.maxX, this.tolerance, 20);
        if (d <= 0.0) {
            throw new IllegalArgumentException("Invalid spline shape.");
        }
        if (d != 1.0) {
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = spline.getX(n2);
                dArray2[n2] = spline.getY(n2);
                int n3 = n2++;
                dArray2[n3] = dArray2[n3] / d;
            }
            this.spline = new Spline(n, dArray, dArray2);
        }
        this.calculateMaxPdf();
        this.mean = Integration.romberg((Function)new SplineMean(), this.minX, this.maxX, this.tolerance, 20);
        this.variance = Integration.romberg((Function)new SplineVar(), this.minX, this.maxX, this.tolerance, 20);
    }

    private void calculateMaxPdf() {
        int n = 100;
        double d = (this.maxX - this.minX) / (double)n;
        this.pdfMax = 0.0;
        double d2 = this.minX;
        int n2 = 0;
        while (n2 <= n) {
            d2 = this.minX + (double)n2 * d;
            double d3 = this.spline.splint(d2);
            if (d3 > this.pdfMax) {
                this.pdfMax = d3;
            }
            ++n2;
        }
    }

    public Spline getSpline() {
        return this.spline;
    }

    public double mean() {
        return this.mean;
    }

    public double pdf(double d) {
        if (d < this.minX || d > this.maxX) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        return this.spline.splint(d);
    }

    public double random() {
        double d;
        double d2;
        do {
            d = this.minX + (this.maxX - this.minX) * this.rand.nextDouble();
        } while ((d2 = this.pdfMax * this.rand.nextDouble()) > this.spline.splint(d));
        return d;
    }

    public double variance() {
        return this.variance;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) throws NumericalException {
            int n = 11;
            double[] dArray = new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
            double[] dArray2 = new double[n];
            double d = 2.0;
            double d2 = 3.0;
            Beta beta = new Beta(d, d2);
            int n2 = 0;
            while (n2 < n) {
                dArray2[n2] = 2.0 * beta.pdf(dArray[n2]);
                ++n2;
            }
            SplineShape splineShape = new SplineShape(n, dArray, dArray2);
            int n3 = 1000;
            double[] dArray3 = new double[n3];
            n2 = 0;
            while (n2 < n3) {
                dArray3[n2] = splineShape.random();
                ++n2;
            }
            KolmogorovTest kolmogorovTest = new KolmogorovTest(dArray3, splineShape, H1.NOT_EQUAL, true);
            System.out.println("m = " + n3 + " D = " + kolmogorovTest.getTestStatistic() + " SP = " + kolmogorovTest.getSP());
        }
    }

    class SplineVar
    implements Function {
        SplineVar() {
        }

        public double function(double d) {
            double d2 = d - SplineShape.this.mean;
            return d2 * d2 * SplineShape.this.spline.splint(d);
        }
    }

    class SplineMean
    implements Function {
        SplineMean() {
        }

        public double function(double d) {
            return d * SplineShape.this.spline.splint(d);
        }
    }

    class SplineCurve
    implements Function {
        SplineCurve() {
        }

        public double function(double d) {
            return SplineShape.this.spline.splint(d);
        }
    }
}

