/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.distributions.Normal;
import jsc.distributions.RankSumOfSquares;

public class HotellingPabstS
extends RankSumOfSquares {
    public HotellingPabstS(int n) {
        super(2, n);
    }

    public double mean() {
        return (double)this.k * ((double)(this.k * this.k) - 1.0) / 6.0;
    }

    public double variance() {
        return this.mean() * this.mean() / ((double)this.k - 1.0);
    }

    public static double lowerTailProb(int n, int n2, boolean bl) {
        return HotellingPabstS.upperTailProb(n, (int)((double)n * ((double)(n * n) - 1.0) / 3.0 - (double)n2), bl);
    }

    public static double upperTailProb(int n, int n2, boolean bl) {
        double d = 1.0;
        if (n <= 1) {
            throw new IllegalArgumentException("Less than two observations.");
        }
        if (n2 <= 0) {
            return d;
        }
        d = 0.0;
        if (n2 > n * (n * n - 1) / 3) {
            return d;
        }
        int n3 = n2;
        if (n3 != 2 * (n3 / 2)) {
            ++n3;
        }
        if (bl) {
            double d2;
            double d3 = 1.0 / (double)n;
            double d4 = (6.0 * ((double)n3 - 1.0) * d3 / (1.0 / (d3 * d3) - 1.0) - 1.0) * Math.sqrt(1.0 / d3 - 1.0);
            double d5 = d4 * d3 * (0.2274 + d3 * (0.2531 + 0.1745 * d3) + (d2 = d4 * d4) * (-0.0758 + d3 * (0.1033 + 0.3932 * d3) - d2 * d3 * (0.0879 + 0.0151 * d3 - d2 * (0.0072 - 0.0831 * d3 + d2 * d3 * (0.0131 - 4.6E-4 * d2)))));
            d = d5 / Math.exp(d2 / 2.0) + Normal.standardTailProb(d4, true);
            if (d < 0.0) {
                d = 0.0;
            }
            if (d > 1.0) {
                d = 1.0;
            }
            return d;
        }
        int[] nArray = new int[n + 1];
        int n4 = 1;
        int n5 = 1;
        while (n5 <= n) {
            n4 *= n5;
            nArray[n5] = n5;
            ++n5;
        }
        d = 1.0 / (double)n4;
        if (n3 == n * (n * n - 1) / 3) {
            return d;
        }
        int n6 = 0;
        int n7 = 1;
        while (n7 <= n4) {
            int n8 = 0;
            n5 = 1;
            while (n5 <= n) {
                n8 += (n5 - nArray[n5]) * (n5 - nArray[n5]);
                ++n5;
            }
            if (n3 <= n8) {
                ++n6;
            }
            int n9 = n;
            do {
                int n10 = nArray[1];
                int n11 = n9 - 1;
                n5 = 1;
                while (n5 <= n11) {
                    nArray[n5] = nArray[n5 + 1];
                    ++n5;
                }
                nArray[n9] = n10;
                if (nArray[n9] != n9 || n9 == 2) break;
                --n9;
            } while (n7 != n4);
            ++n7;
        }
        return (double)n6 / (double)n4;
    }

    public String toString() {
        return new String("Hotelling-Pabst distribution: n = " + this.k + ".");
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            int n = 6;
            System.out.println("Discrete distribution");
            HotellingPabstS hotellingPabstS = new HotellingPabstS(4);
            int n2 = 0;
            while (n2 < hotellingPabstS.getValueCount()) {
                System.out.println("P( X = " + hotellingPabstS.getValue(n2) + " ) = " + hotellingPabstS.getProb(n2));
                ++n2;
            }
        }
    }
}

