/*
 * Decompiled with CFR 0.152.
 */
package jsc.contingencytables;

import jsc.contingencytables.ContingencyTable;
import jsc.util.Arrays;
import jsc.util.BitVector;

public class ContingencyTable2x2
extends ContingencyTable {
    public ContingencyTable2x2(String[] stringArray, String[] stringArray2) {
        super(stringArray, stringArray2);
        if (this.getRowCount() != 2 || this.getColumnCount() != 2) {
            throw new IllegalArgumentException("Data not dichotomous.");
        }
    }

    public ContingencyTable2x2(int[] nArray, int[] nArray2) {
        this(Arrays.toStringArray(nArray), Arrays.toStringArray(nArray2));
    }

    public ContingencyTable2x2(BitVector bitVector, BitVector bitVector2) {
        this(bitVector.toIntArray(), bitVector2.toIntArray());
    }

    public ContingencyTable2x2(String[] stringArray, String[] stringArray2, int[][] nArray) {
        super(stringArray, stringArray2, nArray);
        if (this.getRowCount() != 2 || this.getColumnCount() != 2) {
            throw new IllegalArgumentException("Matrix not 2 x 2.");
        }
    }

    public ContingencyTable2x2(int[] nArray, int[] nArray2, int[][] nArray3) {
        this(Arrays.toStringArray(nArray), Arrays.toStringArray(nArray2), nArray3);
    }

    public ContingencyTable2x2(int[][] nArray) {
        this(Arrays.sequence(0, 1), Arrays.sequence(0, 1), nArray);
    }

    public ContingencyTable2x2(String[] stringArray, String[] stringArray2, int n, int n2, int n3, int n4) {
        this(stringArray, stringArray2, new TwoByTwoMatrix(n, n2, n3, n4).getMatrix());
    }

    public ContingencyTable2x2(int n, int n2, int n3, int n4) {
        this(Arrays.sequence(0, 1), Arrays.sequence(0, 1), new TwoByTwoMatrix(n, n2, n3, n4).getMatrix());
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            String[] stringArray2 = new String[]{"Psychotics", "Neurotics"};
            String[] stringArray3 = new String[]{"Suicidal", "Not suicidal"};
            ContingencyTable2x2 contingencyTable2x2 = new ContingencyTable2x2(stringArray3, stringArray2, 2, 6, 18, 14);
            System.out.println(contingencyTable2x2.toString());
        }
    }

    static class TwoByTwoMatrix {
        int[][] A = new int[2][2];

        TwoByTwoMatrix(int n, int n2, int n3, int n4) {
            this.A[0][0] = n;
            this.A[0][1] = n2;
            this.A[1][0] = n3;
            this.A[1][1] = n4;
        }

        int[][] getMatrix() {
            return this.A;
        }
    }
}

