/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.compbio.flynet.misc;

import edu.mit.compbio.flynet.FileExport;
import edu.mit.compbio.flynet.FileParser;
import edu.mit.compbio.flynet.Flynet;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionDatasetParser {
    private String filename_ = null;
    private String tf_ = null;
    private int header_ = -1;
    private int numCols_ = -1;
    private int targetCol_ = -1;
    private ArrayList<Integer> exprCols_ = null;
    private HashMap<String, ArrayList<ArrayList<Double>>> expr_ = null;
    private double[] thresholds_ = new double[]{0.0, 0.7, 1.0, 1.5};

    public void parseBiniou() {
        this.expr_ = new HashMap();
        this.filename_ = "resources_private/Furlong/biniou/biniou_expr.txt";
        this.tf_ = "FBgn0045759";
        this.header_ = 1;
        this.numCols_ = 12;
        this.targetCol_ = 1;
        this.exprCols_ = new ArrayList();
        int i = 4;
        while (i <= 12) {
            this.exprCols_.add(i);
            ++i;
        }
        this.parse();
        String filename = "resources_private/Furlong/biniou/biniou_loss";
        int[][] cols1 = new int[][]{{1}, {2}, {3}, {4}, {5}, {6}};
        this.writeDifferentiallyExpressedGenes(cols1, filename);
        filename = "resources_private/Furlong/biniou/biniou_gain";
        int[][] cols2 = new int[][]{{7}, {8}, {9}};
        this.writeDifferentiallyExpressedGenes(cols2, filename);
    }

    public void parseTwist() {
        this.expr_ = new HashMap();
        this.filename_ = "resources_private/Furlong/twist/twist_loss_cDNA.txt";
        this.tf_ = "FBgn0003900";
        this.header_ = 2;
        this.numCols_ = 19;
        this.targetCol_ = 3;
        this.exprCols_ = new ArrayList();
        int i = 4;
        while (i <= 19) {
            this.exprCols_.add(i);
            ++i;
        }
        this.parse();
        String filename = "resources_private/Furlong/twist/twist_loss_cDNA";
        int[][] cols1 = new int[][]{{1, 2, 3, 4}, {5, 6, 7, 8}, {9, 10, 11, 12}, {13, 14, 15, 16}};
        this.writeDifferentiallyExpressedGenes(cols1, filename);
        this.expr_ = new HashMap();
        this.filename_ = "resources_private/Furlong/twist/twist_loss_indac.txt";
        this.header_ = 3;
        this.numCols_ = 20;
        this.targetCol_ = 4;
        this.exprCols_ = new ArrayList();
        int i2 = 5;
        while (i2 <= 20) {
            this.exprCols_.add(i2);
            ++i2;
        }
        this.parse();
        filename = "resources_private/Furlong/twist/twist_loss_indac";
        this.writeDifferentiallyExpressedGenes(cols1, filename);
        this.expr_ = new HashMap();
        this.filename_ = "resources_private/Furlong/twist/twist_gain.txt";
        this.header_ = 3;
        this.numCols_ = 16;
        this.targetCol_ = 4;
        this.exprCols_ = new ArrayList();
        i2 = 5;
        while (i2 <= 16) {
            this.exprCols_.add(i2);
            ++i2;
        }
        this.parse();
        filename = "resources_private/Furlong/twist/twist_gain";
        int[][] cols2 = new int[][]{{1, 2, 3, 4}, {5, 6, 7, 8}, {9, 10, 11, 12}};
        this.writeDifferentiallyExpressedGenes(cols2, filename);
    }

    public void parseMef2() {
        this.expr_ = new HashMap();
        this.filename_ = "resources_private/Furlong/mef2/mef2_loss.txt";
        this.tf_ = "FBgn0011656";
        this.header_ = 1;
        this.numCols_ = 78;
        this.targetCol_ = 4;
        this.exprCols_ = new ArrayList();
        int i = 55;
        while (i <= 66) {
            this.exprCols_.add(i);
            ++i;
        }
        this.parse();
        String filename = "resources_private/Furlong/mef2/mef2_loss";
        int[][] cols1 = new int[][]{{1}, {2}, {3}, {4}, {5}, {6}, {7}, {8}, {9}, {10}, {11}, {12}};
        this.writeDifferentiallyExpressedGenes(cols1, filename);
    }

    /*
     * Unable to fully structure code
     */
    private void parse() {
        Flynet.println("Reading file: " + this.filename_);
        parser = new FileParser(this.filename_);
        parser.skipLines(this.header_);
        l = this.header_;
        block0: while (true) {
            line = parser.readLine();
            ++l;
            if (line == null) break;
            if (line.length != this.numCols_) {
                throw new RuntimeException("Line " + l + ": expected " + this.numCols_ + " columns, found " + line.length);
            }
            x = new ArrayList<Double>();
            i = 0;
            while (i < this.exprCols_.size()) {
                str = line[this.exprCols_.get(i) - 1];
                if (str.equalsIgnoreCase("NA") || str.equalsIgnoreCase("")) {
                    x.add(NaN);
                } else {
                    x.add(Double.parseDouble(str));
                }
                ++i;
            }
            target = line[this.targetCol_ - 1];
            if (this.expr_.containsKey(target)) {
                expr = this.expr_.get(target);
                i = 0;
                while (true) {
                    if (i >= expr.size()) continue block0;
                    ((ArrayList)expr.get(i)).add((Double)x.get(i));
                    ++i;
                }
            }
            expr = new ArrayList<E>();
            this.expr_.put(target, expr);
            i = 0;
            while (true) {
                if (i < x.size()) ** break;
                continue block0;
                xi = new ArrayList<Double>();
                xi.add((Double)x.get(i));
                expr.add(xi);
                ++i;
            }
            break;
        }
    }

    private void writeDifferentiallyExpressedGenes(int[][] cols, String filename) {
        int i = 0;
        while (i < this.thresholds_.length) {
            this.writeDifferentiallyExpressedGenes(cols, this.thresholds_[i], filename);
            ++i;
        }
    }

    private void writeDifferentiallyExpressedGenes(int[][] cols, double threshold, String filename) {
        DecimalFormat oneDec = new DecimalFormat("0.0");
        filename = String.valueOf(filename) + "_" + oneDec.format(threshold) + ".txt";
        Flynet.println("Writing file " + filename);
        FileExport writer = new FileExport(filename);
        block0: for (String target : this.expr_.keySet()) {
            int t = 0;
            while (t < cols.length) {
                ArrayList<Double> repeats = new ArrayList<Double>();
                int k = 0;
                while (k < cols[t].length) {
                    ArrayList<Double> probes = this.expr_.get(target).get(cols[t][k] - 1);
                    double x = this.median(probes);
                    repeats.add(x);
                    ++k;
                }
                double mu = this.median(repeats);
                if (mu >= threshold || mu <= -threshold) {
                    writer.println(String.valueOf(this.tf_) + "\t" + target);
                    continue block0;
                }
                ++t;
            }
        }
        writer.close();
    }

    private double mean(ArrayList<Double> x) {
        double mu = 0.0;
        int i = 0;
        while (i < x.size()) {
            mu += x.get(i).doubleValue();
            ++i;
        }
        return mu / (double)x.size();
    }

    private double median(ArrayList<Double> x) {
        Collections.sort(x);
        if (x.size() % 2 == 1) {
            return x.get((x.size() + 1) / 2 - 1);
        }
        double lower = x.get(x.size() / 2 - 1);
        double upper = x.get(x.size() / 2);
        return (lower + upper) / 2.0;
    }

    private double maxAbs(ArrayList<Double> x) {
        double max = 0.0;
        int i = 0;
        while (i < x.size()) {
            double xi = Math.abs(x.get(i));
            if (xi > max) {
                max = xi;
            }
            ++i;
        }
        return max;
    }
}

