/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.compbio.flynet.genome;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Region
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int start_ = -1;
    protected int end_ = -1;
    protected double confidence_ = -1.0;

    public Region() {
    }

    public Region(int start, int end) {
        this.setRegion(start, end);
    }

    public Region(int start, int end, double confidence) {
        this.setRegion(start, end);
        this.confidence_ = confidence;
    }

    public void setRegion(int start, int end) {
        this.start_ = start;
        this.end_ = end;
        assert (start < end);
    }

    public boolean contains(Region region) {
        return this.start_ <= region.getStart() && region.getEnd() <= this.end_;
    }

    public static boolean isSorted(ArrayList<Region> regions) {
        int i = 0;
        while (i < regions.size() - 1) {
            if (regions.get(i).getStart() > regions.get(i + 1).getStart()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getStart() {
        return this.start_;
    }

    public int getEnd() {
        return this.end_;
    }

    public double getConfidence() {
        return this.confidence_;
    }

    public int getLength() {
        return this.end_ - this.start_;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompareStart
    implements Comparator<Region> {
        @Override
        public int compare(Region region1, Region region2) {
            return region1.getStart() - region2.getStart();
        }
    }
}

