/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.compbio.flynet.genome;

import edu.mit.compbio.flynet.FileParser;
import edu.mit.compbio.flynet.Flynet;
import edu.mit.compbio.flynet.genome.Region;

public class ParserGff
extends FileParser {
    String[] currentLine_ = null;
    private static final int CHROMOSOME = 0;
    private static final int START = 3;
    private static final int END = 4;
    private static final int FEATURES = 8;

    public ParserGff(String filename) {
        super(filename);
    }

    public boolean readLineGff(Region region) {
        this.currentLine_ = this.readLine();
        if (this.currentLine_ == null) {
            return false;
        }
        assert (this.currentLine_.length == 9);
        int start = Integer.parseInt(this.currentLine_[3]);
        int end = Integer.parseInt(this.currentLine_[4]);
        region.setRegion(start, end);
        return true;
    }

    public String getFeature(String key) {
        int start;
        int end;
        String featureStr = this.currentLine_[8];
        int index = featureStr.indexOf(key);
        if (index == -1) {
            Flynet.error(new RuntimeException("Key '" + key + "' not found in the features of line " + this.lineCounter_));
        }
        if (featureStr.charAt(index + key.length()) != '=') {
            Flynet.error(new RuntimeException("Key '" + key + "' not followed by '=' in line " + this.lineCounter_));
        }
        if ((end = featureStr.indexOf(59, start = index + key.length() + 1)) == -1) {
            Flynet.error(new RuntimeException("Feature of key '" + key + "' not delimited by ';' in line " + this.lineCounter_));
        }
        if (featureStr.charAt(start) == '\"') {
            ++start;
        }
        if (featureStr.charAt(end - 1) == '\"') {
            --end;
        }
        String feature = featureStr.substring(start, end);
        return feature;
    }

    public String getSubFeature(String key, String subkey) {
        int start;
        int end;
        String feature = this.getFeature(key);
        int index = feature.indexOf(subkey);
        if (index == -1) {
            Flynet.error(new RuntimeException("Subkey '" + subkey + "' not found in the subfeatures of line " + this.lineCounter_));
        }
        if (feature.charAt(index + subkey.length()) != ':') {
            Flynet.error(new RuntimeException("Subkey '" + subkey + "' not followed by ':' in line " + this.lineCounter_));
        }
        if ((end = feature.indexOf(44, start = index + subkey.length() + 1)) == -1) {
            end = feature.length() - 1;
        }
        if (feature.charAt(end - 1) == '\"') {
            --end;
        }
        String subfeature = feature.substring(start, end);
        return subfeature;
    }

    public String getChromosomeString() {
        return this.currentLine_[0];
    }

    public String[] getCurrentLine() {
        return this.currentLine_;
    }
}

