/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.compbio.flynet.genome;

import edu.mit.compbio.flynet.Flynet;
import edu.mit.compbio.flynet.Settings;
import edu.mit.compbio.flynet.genome.Chromosome;
import edu.mit.compbio.flynet.genome.Gene;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Genome
implements Serializable {
    private static final long serialVersionUID = 1L;
    LinkedHashMap<String, Chromosome> chromosomes_ = null;
    HashSet<String> excludedChromosomes_ = null;
    HashMap<String, Gene> genes_ = null;

    public Genome() {
        ArrayList<String> mainChromosomes = new ArrayList<String>();
        mainChromosomes.add("2L");
        mainChromosomes.add("2R");
        mainChromosomes.add("3L");
        mainChromosomes.add("3R");
        mainChromosomes.add("4");
        mainChromosomes.add("X");
        ArrayList<String> notSoInteresting = new ArrayList<String>();
        notSoInteresting.add("2LHet");
        notSoInteresting.add("2RHet");
        notSoInteresting.add("3LHet");
        notSoInteresting.add("3RHet");
        notSoInteresting.add("XHet");
        notSoInteresting.add("YHet");
        notSoInteresting.add("U");
        notSoInteresting.add("Uextra");
        notSoInteresting.add("dmel_mitochondrion_genome");
        ArrayList<String> chromosomes = new ArrayList<String>();
        chromosomes.addAll(mainChromosomes);
        chromosomes.addAll(notSoInteresting);
        this.excludedChromosomes_ = new HashSet();
        if (Settings.considerOnlyOneChromosome_ != null) {
            this.excludedChromosomes_.addAll(chromosomes);
            if (!this.excludedChromosomes_.remove(Settings.considerOnlyOneChromosome_)) {
                Flynet.error(new RuntimeException("The specified chromosome '" + Settings.considerOnlyOneChromosome_ + "' is not known"));
            }
        } else if (Settings.considerOnlyMainChromosomes_) {
            this.excludedChromosomes_.addAll(notSoInteresting);
        }
        this.chromosomes_ = new LinkedHashMap();
        int i = 0;
        while (i < chromosomes.size()) {
            String id = (String)chromosomes.get(i);
            this.chromosomes_.put(id, new Chromosome(id));
            ++i;
        }
        this.genes_ = new HashMap();
    }

    public Chromosome getChromosome(String id) {
        try {
            return this.chromosomes_.get(id);
        }
        catch (NullPointerException e) {
            Flynet.error(e);
            return null;
        }
    }

    public void addGene(String chromosome, Gene gene) {
        String fbgn = gene.getFbgn();
        if (this.genes_.containsKey(fbgn)) {
            Flynet.error(new RuntimeException("Gene " + fbgn + " has already been added"));
        }
        this.genes_.put(fbgn, gene);
        this.getChromosome(chromosome).addGene(gene);
    }

    public Gene getGene(String fbgn) {
        Gene gene = this.genes_.get(fbgn);
        if (gene == null) {
            Flynet.error(new RuntimeException("Unknown gene " + fbgn));
        }
        return this.genes_.get(fbgn);
    }

    public void printStatistics() {
        System.out.println();
        System.out.println("Printing genome statistics:");
        System.out.println();
        System.out.println("CHROM\t#GENES");
        System.out.println("-------------");
        for (Chromosome chrom : this.chromosomes_.values()) {
            if (this.chromosomeIsExcluded(chrom.getName())) continue;
            chrom.printStatistics();
        }
    }

    public void writeSerialization(String filename) {
        try {
            System.out.println();
            System.out.println("Writing genome to file " + filename + " ...");
            FileOutputStream f_out = new FileOutputStream(filename);
            ObjectOutputStream obj_out = new ObjectOutputStream(f_out);
            obj_out.writeObject(this);
        }
        catch (Exception e) {
            Flynet.error(e);
        }
    }

    public static Genome readSerialization(String filename) {
        Genome genome = null;
        try {
            System.out.println();
            System.out.println("Reading genome from file " + filename + " ...");
            FileInputStream f_in = new FileInputStream(filename);
            ObjectInputStream obj_in = new ObjectInputStream(f_in);
            genome = (Genome)obj_in.readObject();
        }
        catch (Exception e) {
            Flynet.error(e);
        }
        return genome;
    }

    public boolean chromosomeIsExcluded(String chromosome) {
        return this.excludedChromosomes_.contains(chromosome);
    }

    public LinkedHashMap<String, Chromosome> getChromosomes() {
        return this.chromosomes_;
    }
}

