/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.compbio.flynet;

import edu.mit.compbio.flynet.FileExport;
import edu.mit.compbio.flynet.FileParser;
import edu.mit.compbio.flynet.Flynet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Translator {
    private static Translator instance_ = null;
    String fbgnNamesFile_ = "resources/flybase/fbgn_annotation_ID_fb_2010_03.tsv";
    int numHeaderLinesFbgnNamesFile_ = 5;
    private HashMap<String, String> cg2fb_ = null;
    private HashMap<String, String> fb2cg_ = null;
    private HashMap<String, ArrayList<String>> secondaryCg2fb_ = null;
    private HashMap<String, ArrayList<String>> secondaryFb2fb_ = null;
    private HashMap<String, ArrayList<String>> customSymbol2fb_ = null;
    private LinkedHashSet<String> secondary2uniqueFbgn_ = null;
    private LinkedHashSet<String> secondary2multipleFbgns_ = null;
    private LinkedHashSet<String> notFound_ = null;

    public static Translator getInstance() {
        if (instance_ == null) {
            instance_ = new Translator();
        }
        return instance_;
    }

    private Translator() {
        this.initializeHashMaps();
    }

    public void clearWarningLists() {
        this.secondary2uniqueFbgn_ = new LinkedHashSet();
        this.secondary2multipleFbgns_ = new LinkedHashSet();
        this.notFound_ = new LinkedHashSet();
        this.notFound_.add("Not_found:");
        this.secondary2uniqueFbgn_.add("Mapped_to_unique_FBgn:");
        this.secondary2multipleFbgns_.add("Mapped_to_multiple_FBgns:");
    }

    public boolean isPrimaryFbgn(String fbgn) {
        return this.fb2cg_.containsKey(fbgn);
    }

    public boolean isPrimaryFbgn(ArrayList<String> fbgn) {
        int i = 0;
        while (i < fbgn.size()) {
            if (!this.isPrimaryFbgn(fbgn.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public ArrayList<String> toPrimaryFBgn(String label) {
        ArrayList<String> fbgns = null;
        if (this.isPrimaryFbgn(label)) {
            fbgns = new ArrayList<String>();
            fbgns.add(label);
            return fbgns;
        }
        if (this.cg2fb_.containsKey(label)) {
            fbgns = new ArrayList();
            fbgns.add(this.cg2fb_.get(label));
            return fbgns;
        }
        if (this.customSymbol2fb_.containsKey(label)) {
            fbgns = this.customSymbol2fb_.get(label);
        } else if (this.secondaryCg2fb_.containsKey(label)) {
            fbgns = this.secondaryCg2fb_.get(label);
        } else if (this.secondaryFb2fb_.containsKey(label)) {
            fbgns = this.secondaryFb2fb_.get(label);
        }
        if (fbgns == null) {
            this.notFound_.add(label);
        } else if (fbgns.size() == 1) {
            this.secondary2uniqueFbgn_.add(label);
        } else if (fbgns.size() > 1) {
            this.secondary2multipleFbgns_.add(label);
        } else assert (false);
        return fbgns;
    }

    public void toPrimaryFBgn(String filename, int column, int numHeaderLines, boolean deleteLines) {
        String[] currentLine;
        this.clearWarningLists();
        Flynet.println("Mapping column " + (column + 1) + " to primary FBgns, skipping the first " + numHeaderLines + " lines...");
        Flynet.println("Reading file " + filename + "...");
        FileParser parser = new FileParser(filename);
        String outputFile = Flynet.insertBeforeFileExtension(filename, "_mapped_c" + (column + 1));
        Flynet.println("Writing file " + outputFile + "...");
        FileExport writer = new FileExport(outputFile);
        int l = 0;
        int i = 0;
        while (i < numHeaderLines) {
            String line = parser.readRawLine();
            writer.println(line);
            ++l;
            ++i;
        }
        while ((currentLine = parser.readLine()) != null) {
            ++l;
            if (currentLine.length < column) {
                throw new RuntimeException("Translating column " + (column + 1) + ", line " + (l + 1) + " has only " + currentLine.length + " columns");
            }
            String currentLabel = currentLine[column];
            ArrayList<String> fbgns = this.toPrimaryFBgn(currentLine[column]);
            if (fbgns == null) {
                if (deleteLines) continue;
                fbgns = new ArrayList();
                fbgns.add(currentLabel);
            }
            int i2 = 0;
            while (i2 < fbgns.size()) {
                currentLine[column] = fbgns.get(i2);
                writer.println(currentLine);
                ++i2;
            }
        }
        writer.close();
        parser.close();
        String logFile = Flynet.insertBeforeFileExtension(filename, "_log_c" + (column + 1));
        this.printWarnings(logFile);
    }

    public void printWarnings(String filename) {
        ArrayList<String[]> log = new ArrayList<String[]>();
        log.add(this.notFound_.toArray(new String[0]));
        log.add(this.secondary2uniqueFbgn_.toArray(new String[0]));
        log.add(this.secondary2multipleFbgns_.toArray(new String[0]));
        System.out.println("Writing file " + filename + "...");
        FileExport writer = new FileExport(filename);
        int i = 0;
        while (i < log.size()) {
            writer.println((String[])log.get(i));
            ++i;
        }
        writer.close();
        Flynet.println("Warnings (see log for details):");
        Flynet.println(String.valueOf(this.notFound_.size() - 1) + "\tnot found");
        Flynet.println(String.valueOf(this.secondary2uniqueFbgn_.size() - 1) + "\tmapped to unique FBgn");
        Flynet.println(String.valueOf(this.secondary2multipleFbgns_.size() - 1) + "\tmapped to multiple FBgns");
    }

    private void initializeHashMaps() {
        String[] currentLine;
        this.cg2fb_ = new HashMap();
        this.fb2cg_ = new HashMap();
        this.secondaryCg2fb_ = new HashMap();
        this.secondaryFb2fb_ = new HashMap();
        this.initializeCustomSymbols();
        this.clearWarningLists();
        Flynet.println("Reading annotation file " + this.fbgnNamesFile_);
        FileParser parser = new FileParser(this.fbgnNamesFile_);
        parser.skipLines(this.numHeaderLinesFbgnNamesFile_);
        int colSymbol = 0;
        int colFbgn = 1;
        int col2ndFbgn = 2;
        int colCg = 3;
        int col2ndCg = 4;
        while ((currentLine = parser.readLine()) != null) {
            ArrayList<String> fbgnList;
            int j;
            if (!currentLine[colCg].startsWith("CG") && !currentLine[colCg].startsWith("CR")) continue;
            String fbgn = currentLine[colFbgn];
            String cg = currentLine[colCg];
            String symbol = currentLine[colSymbol];
            this.fb2cg_.put(fbgn, cg);
            this.cg2fb_.put(cg, fbgn);
            if (!cg.equals(symbol)) {
                this.cg2fb_.put(symbol, fbgn);
            }
            if (currentLine.length >= col2ndCg + 1 && !currentLine[col2ndCg].equals("")) {
                String[] cg2 = currentLine[col2ndCg].split(",");
                j = 0;
                while (j < cg2.length) {
                    fbgnList = this.secondaryCg2fb_.get(cg2[j]);
                    if (fbgnList == null) {
                        fbgnList = new ArrayList();
                        fbgnList.add(fbgn);
                        this.secondaryCg2fb_.put(cg2[j], fbgnList);
                    } else {
                        fbgnList.add(fbgn);
                    }
                    ++j;
                }
            }
            if (currentLine[col2ndFbgn].equals("")) continue;
            String[] fb2 = currentLine[col2ndFbgn].split(",");
            j = 0;
            while (j < fb2.length) {
                fbgnList = this.secondaryFb2fb_.get(fb2[j]);
                if (fbgnList == null) {
                    fbgnList = new ArrayList();
                    fbgnList.add(fbgn);
                    this.secondaryFb2fb_.put(fb2[j], fbgnList);
                } else {
                    fbgnList.add(fbgn);
                }
                ++j;
            }
        }
        parser.close();
    }

    private void initializeCustomSymbols() {
        this.customSymbol2fb_ = new HashMap(5);
        String symbol = "AP-1";
        ArrayList<String> ap1 = new ArrayList<String>();
        ap1.add("FBgn0001297");
        ap1.add("FBgn0001291");
        this.customSymbol2fb_.put(symbol, ap1);
        symbol = "Dif/Rel";
        ArrayList<String> difrel = new ArrayList<String>();
        difrel.add("FBgn0011274");
        difrel.add("FBgn0014018");
        this.customSymbol2fb_.put(symbol, difrel);
        symbol = "EcR/usp";
        ArrayList<String> ecrusp = new ArrayList<String>();
        ecrusp.add("FBgn0000546");
        ecrusp.add("FBgn0003964");
        this.customSymbol2fb_.put(symbol, ecrusp);
        symbol = "TorRE";
        ArrayList<String> torre = new ArrayList<String>();
        torre.add("FBgn0021796");
        this.customSymbol2fb_.put(symbol, torre);
        symbol = "Deb-A";
        ArrayList<String> deba = new ArrayList<String>();
        deba.add("FBgn0000425");
        this.customSymbol2fb_.put(symbol, deba);
        ArrayList<String> fbgns = new ArrayList<String>();
        fbgns.addAll(ap1);
        fbgns.addAll(difrel);
        fbgns.addAll(ecrusp);
        fbgns.addAll(torre);
        fbgns.addAll(deba);
        this.isPrimaryFbgn(fbgns);
    }
}

