/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.compbio.flynet;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import edu.mit.compbio.flynet.Flynet;

public class Settings {
    public static Flynet flynet_ = null;
    public static String networkDir_ = ".";
    public static String goldStandardNetwork_ = null;
    public static int numRandomized_ = 10;
    public static double missingValue_ = 0.1;
    public static double coregulationThreshold_ = 0.5;
    public static String considerOnlyOneChromosome_ = "2L";
    public static boolean considerOnlyMainChromosomes_ = true;
    public static JSAP jsap_ = null;
    public static JSAPResult config_ = null;
    public static boolean generateSup_ = false;
    public static boolean generateUnsup_ = false;
    public static boolean computeRecoveryRates_ = false;
    public static String tgFile_ = null;
    public static String computeEnrichment_ = null;
    public static boolean runTest_ = false;
    public static boolean computeIntersection_ = false;
    public static boolean computeUnion_ = false;
    public static double cutoff_ = -1.0;
    public static boolean filter_ = false;
    public static double wmin_ = -1.0;
    public static boolean cleanFBgns_ = false;
    public static int argColumn_ = 0;
    public static int argNumHeaderLines_ = 0;
    public static boolean argDelete_ = false;
    public static String[] argFileList_ = null;

    public static void printUsage() {
        Flynet.println("");
        Flynet.println("Usage: java flynet");
        Flynet.println("                " + jsap_.getUsage());
        Flynet.println("");
        Flynet.println("Tip: depending on the analysis that you run, you have to increase the java heap size using -Xmx");
        Flynet.println("Example: java -jar -Xmx4g flynet.jar -e GO");
        System.exit(0);
    }

    public static void parseArguments(String[] args) {
        config_ = jsap_.parse(args);
        if (!config_.success()) {
            Settings.printUsage();
            System.exit(1);
        }
        if (config_.contains("networkDir")) {
            networkDir_ = config_.getString("networkDir");
        }
        generateSup_ = config_.getBoolean("generateSup");
        generateUnsup_ = config_.getBoolean("generateUnsup");
        if (config_.contains("recovery")) {
            computeRecoveryRates_ = true;
            goldStandardNetwork_ = config_.getString("recovery");
        }
        if (config_.contains("tgs")) {
            tgFile_ = config_.getString("tgs");
        }
        computeEnrichment_ = config_.getString("enrichment");
        computeIntersection_ = config_.getBoolean("intersection");
        computeUnion_ = config_.getBoolean("union");
        if (config_.contains("cutoff")) {
            cutoff_ = config_.getDouble("cutoff");
        }
        filter_ = config_.getBoolean("filter");
        if (config_.contains("wmin")) {
            wmin_ = config_.getDouble("wmin");
        }
        cleanFBgns_ = config_.getBoolean("cleanFB");
        if (config_.contains("column")) {
            argColumn_ = config_.getInt("column") - 1;
        }
        if (config_.contains("numHeaderLines")) {
            argNumHeaderLines_ = config_.getInt("numHeaderLines");
        }
        argDelete_ = config_.getBoolean("delete");
        runTest_ = config_.getBoolean("test");
        argFileList_ = config_.getStringArray("fileList");
    }

    public static void initializeJsap() {
        jsap_ = new JSAP();
        FlaggedOption networkDir = new FlaggedOption("networkDir");
        networkDir.setLongFlag("dir");
        networkDir.setHelp("Specify the directory where the networks are located");
        networkDir.setUsageName("path");
        Switch generateSup = new Switch("generateSup");
        generateSup.setLongFlag("sup");
        generateSup.setHelp("Generate the supervised network using logistic regression");
        Switch generateUnsup = new Switch("generateUnsup");
        generateUnsup.setLongFlag("unsup");
        generateUnsup.setHelp("Generate the unsupervised network");
        FlaggedOption recovery = new FlaggedOption("recovery");
        recovery.setLongFlag("recovery");
        recovery.setHelp("Compute recovery rates");
        recovery.setUsageName("goldstandard");
        FlaggedOption tgs = new FlaggedOption("tgs");
        tgs.setLongFlag("tgs");
        tgs.setHelp("The file with the target genes (used only with --recovery)");
        tgs.setUsageName("file");
        FlaggedOption enrichment = new FlaggedOption("enrichment");
        enrichment.setShortFlag('e');
        enrichment.setHelp("Compute enrichment of co-regulated genes for GO, ImaGO, devExpr, or PPI");
        enrichment.setUsageName("type");
        Switch intersection = new Switch("intersection");
        intersection.setShortFlag('i');
        intersection.setHelp("Get the intersection of two or more networks");
        Switch union = new Switch("union");
        union.setShortFlag('u');
        union.setHelp("Get the union of two or more networks");
        FlaggedOption cutoff = new FlaggedOption("cutoff");
        cutoff.setLongFlag("cutoff");
        cutoff.setHelp("Truncate the networks to the given fraction of the total number of possible edges");
        cutoff.setStringParser(JSAP.DOUBLE_PARSER);
        Switch filter = new Switch("filter");
        filter.setLongFlag("filter");
        filter.setHelp("Filter the networks for the given list of TFs and targets: --filter tf.txt tg.txt net.txt");
        FlaggedOption wmin = new FlaggedOption("wmin");
        wmin.setLongFlag("wmin");
        wmin.setHelp("The minimal weight considered when loading networks (for intersection, union, cutoff; all edges are loaded if this flag is not specified");
        wmin.setStringParser(JSAP.DOUBLE_PARSER);
        Switch cleanFB = new Switch("cleanFB");
        cleanFB.setLongFlag("fbgn");
        cleanFB.setHelp("Map secondary FBgns to primary FBgns of the given annotation version");
        FlaggedOption column = new FlaggedOption("column");
        column.setShortFlag('c');
        column.setHelp("The column that should be translated (use with --fbgn)");
        column.setStringParser(JSAP.INTEGER_PARSER);
        FlaggedOption numHeaderLines = new FlaggedOption("numHeaderLines");
        numHeaderLines.setShortFlag('l');
        numHeaderLines.setHelp("The number of header lines that should be skipped (use with --fbgn)");
        numHeaderLines.setStringParser(JSAP.INTEGER_PARSER);
        Switch delete = new Switch("delete");
        delete.setShortFlag('d');
        delete.setHelp("Delete lines with an identifier that could not be translated (use with --fbgn)");
        Switch test = new Switch("test");
        test.setShortFlag('t');
        test.setHelp("Run the test() function");
        UnflaggedOption fileList = new UnflaggedOption("fileList");
        fileList.setHelp("A list of input files");
        fileList.setGreedy(true);
        fileList.setUsageName("file");
        try {
            jsap_.registerParameter(networkDir);
            jsap_.registerParameter(generateSup);
            jsap_.registerParameter(generateUnsup);
            jsap_.registerParameter(recovery);
            jsap_.registerParameter(tgs);
            jsap_.registerParameter(enrichment);
            jsap_.registerParameter(intersection);
            jsap_.registerParameter(union);
            jsap_.registerParameter(cutoff);
            jsap_.registerParameter(filter);
            jsap_.registerParameter(wmin);
            jsap_.registerParameter(cleanFB);
            jsap_.registerParameter(column);
            jsap_.registerParameter(numHeaderLines);
            jsap_.registerParameter(delete);
            jsap_.registerParameter(test);
            jsap_.registerParameter(fileList);
        }
        catch (JSAPException e) {
            Flynet.error(e);
        }
    }
}

