/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.compbio.flynet;

import edu.mit.compbio.flynet.Edge;
import edu.mit.compbio.flynet.FileExport;
import edu.mit.compbio.flynet.Flynet;
import edu.mit.compbio.flynet.Network;
import edu.mit.compbio.flynet.Node;
import edu.mit.compbio.flynet.Settings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecoveryRate {
    private Network goldStandard_ = null;
    private ArrayList<Network> networks_ = null;

    public RecoveryRate() {
        this.goldStandard_ = new Network();
        this.goldStandard_.loadEdgesAboveThreshold(Settings.goldStandardNetwork_, 1.0, false);
        if (Settings.tgFile_ != null) {
            this.goldStandard_.loadNodes(Settings.tgFile_, false);
        }
        String tffile = Flynet.insertBeforeFileExtension(Settings.goldStandardNetwork_, "_tfs");
        String tgfile = Flynet.insertBeforeFileExtension(Settings.goldStandardNetwork_, "_tgs");
        this.goldStandard_.saveRegulators(String.valueOf(Settings.networkDir_) + "/" + tffile);
        this.goldStandard_.saveTargets(String.valueOf(Settings.networkDir_) + "/" + tgfile);
        this.networks_ = new ArrayList();
        String[] fileList = Settings.argFileList_;
        int i = 0;
        while (i < fileList.length) {
            Network net = new Network();
            net.loadSubnet(fileList[i], tffile, tgfile, false);
            Collections.sort(net.getEdges());
            this.networks_.add(net);
            ++i;
        }
    }

    public RecoveryRate(Network goldStandard, ArrayList<Network> networks) {
        this.goldStandard_ = goldStandard;
        this.networks_ = networks;
    }

    public void run() {
        String filename = String.valueOf(Settings.networkDir_) + "/" + Flynet.insertBeforeFileExtension(this.goldStandard_.getName(), "_recovery");
        Flynet.println("Writing recovery rates to file: " + filename);
        FileExport writer = new FileExport(filename);
        this.writeFileHeader(writer);
        int numPossibleEdges = this.computeNumPossibleEdges();
        int[] numRecovered = new int[this.networks_.size()];
        int i = 0;
        while (i < this.networks_.size()) {
            numRecovered[i] = 0;
            ++i;
        }
        int k = 0;
        while (k < numPossibleEdges) {
            String nextLine = "";
            double fractionConsidered = (double)(k + 1) / (double)numPossibleEdges;
            nextLine = String.valueOf(nextLine) + fractionConsidered + "\t";
            int i2 = 0;
            while (i2 < this.networks_.size()) {
                Edge edge;
                if (this.networks_.get(i2).getNumEdges() > k && this.goldStandard_.contains(edge = this.networks_.get(i2).getEdge(k))) {
                    int n = i2;
                    numRecovered[n] = numRecovered[n] + 1;
                }
                nextLine = String.valueOf(nextLine) + numRecovered[i2] + "\t";
                ++i2;
            }
            double expectedByChance = (double)this.goldStandard_.getNumEdges() * fractionConsidered;
            nextLine = String.valueOf(nextLine) + expectedByChance;
            writer.println(nextLine);
            ++k;
        }
        writer.close();
    }

    private void writeFileHeader(FileExport writer) {
        String header = "#";
        header = String.valueOf(header) + "Fraction_considered";
        int i = 0;
        while (i < this.networks_.size()) {
            header = String.valueOf(header) + "\t" + this.networks_.get(i).getName();
            ++i;
        }
        header = String.valueOf(header) + "\tRandom";
        writer.println(header);
    }

    private int computeNumPossibleEdges() {
        HashSet<Node> regulators = this.goldStandard_.getRegulators();
        int numRegulatorsThatAreTargets = 0;
        for (Node tf : regulators) {
            if (tf.getIncomingEdges().size() <= 0) continue;
            ++numRegulatorsThatAreTargets;
        }
        return regulators.size() * this.goldStandard_.getTargets().size() - numRegulatorsThatAreTargets;
    }

    private void fractionPhysicallySupported() {
        Network unsup = this.networks_.get(0);
        Network sup = this.networks_.get(1);
        Network chip = this.networks_.get(2);
        Network motif = this.networks_.get(3);
        Flynet.println("Computing fraction of edges supported by chip, motif, or both ...");
        Flynet.println("IMPORTANT: Networks must be given in the right order!");
        Flynet.println("Type\tPassed as argument (should match the type of network)");
        Flynet.println("Unsup\t" + unsup.getName());
        Flynet.println("Sup\t" + sup.getName());
        Flynet.println("Chip\t" + chip.getName());
        Flynet.println("Motif\t" + motif.getName());
        int numEdges = unsup.getNumEdges();
        assert (sup.getNumEdges() == numEdges);
        int[] unsup_count = new int[4];
        int[] sup_count = new int[4];
        int i = 0;
        while (i < 4) {
            unsup_count[i] = 0;
            sup_count[i] = 0;
            ++i;
        }
        String filename = "fractionPhysicallySupported.tsv";
        Flynet.println("Writing fraction of physically supported edges to file: " + filename);
        FileExport writer = new FileExport(filename);
        String header = "#Fraction_considered\tunsup_chip\tunsup_chipAndMotif\tunsup_motif\tunsup_rest\tsup_chip\tsup_chipAndMotif\tsup_motif\tsup_rest";
        writer.println(header);
        int numPossibleEdges = this.computeNumPossibleEdges();
        int k = 0;
        while (k < numEdges) {
            int category;
            double motifWeight;
            double chipWeight;
            Edge edge = unsup.getEdge(k);
            if (this.goldStandard_.contains(edge)) {
                chipWeight = chip.getEdge(edge).getWeight();
                motifWeight = motif.getEdge(edge).getWeight();
                int n = category = this.getCategory(chipWeight > 0.999999, motifWeight > 0.100001);
                unsup_count[n] = unsup_count[n] + 1;
            }
            if (this.goldStandard_.contains(edge = sup.getEdge(k))) {
                chipWeight = chip.getEdge(edge).getWeight();
                motifWeight = motif.getEdge(edge).getWeight();
                int n = category = this.getCategory(chipWeight > 0.999999, motifWeight > 0.100001);
                sup_count[n] = sup_count[n] + 1;
            }
            String nextLine = "";
            double fractionConsidered = (double)(k + 1) / (double)numPossibleEdges;
            nextLine = String.valueOf(nextLine) + fractionConsidered;
            int c = 0;
            while (c < 4) {
                nextLine = String.valueOf(nextLine) + "\t" + unsup_count[c];
                ++c;
            }
            c = 0;
            while (c < 4) {
                nextLine = String.valueOf(nextLine) + "\t" + sup_count[c];
                ++c;
            }
            writer.println(nextLine);
            ++k;
        }
        writer.close();
    }

    private int getCategory(boolean isChip, boolean isMotif) {
        if (isChip && isMotif) {
            return 1;
        }
        if (isChip) {
            return 0;
        }
        if (isMotif) {
            return 2;
        }
        return 3;
    }
}

