/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.compbio.flynet;

import edu.mit.compbio.flynet.Edge;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node {
    private String label_ = null;
    private ArrayList<Edge> incomingEdges_ = null;
    private ArrayList<Edge> outgoingEdges_ = null;

    public Node(String label) {
        this.label_ = label;
        this.incomingEdges_ = new ArrayList();
        this.outgoingEdges_ = new ArrayList();
    }

    public void addIncomingEdge(Edge e) {
        if (e.getTarget() != this) {
            throw new IllegalArgumentException("Not an incoming edge of this TF");
        }
        this.incomingEdges_.add(e);
    }

    public void addOutgoingEdge(Edge e) {
        if (e.getTf() != this) {
            throw new IllegalArgumentException("Not an outgoing edge of this TF");
        }
        this.outgoingEdges_.add(e);
    }

    public HashSet<String> getRegulators() {
        HashSet<String> tfs = new HashSet<String>();
        int i = 0;
        while (i < this.incomingEdges_.size()) {
            tfs.add(this.incomingEdges_.get(i).getTf().getLabel());
            ++i;
        }
        return tfs;
    }

    public String getLabel() {
        return this.label_;
    }

    public void setLabel(String label) {
        this.label_ = label;
    }

    public ArrayList<Edge> getIncomingEdges() {
        return this.incomingEdges_;
    }

    public ArrayList<Edge> getOutgoingEdges() {
        return this.outgoingEdges_;
    }
}

