/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.compbio.flynet;

import edu.mit.compbio.flynet.Edge;
import edu.mit.compbio.flynet.Network;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkUtil {
    public static Network complement(Network net1, Network net2) {
        Network compl = new Network();
        int i = 0;
        while (i < net1.getNumEdges()) {
            Edge edge = net1.getEdge(i);
            if (!net2.contains(edge)) {
                compl.addCopyOfEdge(edge);
            }
            ++i;
        }
        return compl;
    }

    public static Network intersect(Network net1, Network net2, boolean addWeights) {
        Network inter = new Network();
        int i = 0;
        while (i < net1.getNumEdges()) {
            Edge edge1 = net1.getEdge(i);
            Edge edge2 = net2.getEdge(edge1);
            if (edge2 != null) {
                if (addWeights) {
                    inter.addEdge(edge1.getTf().getLabel(), edge1.getTarget().getLabel(), edge1.getWeight() + edge2.getWeight());
                } else {
                    inter.addCopyOfEdge(edge1);
                }
            }
            ++i;
        }
        Collections.sort(inter.getEdges());
        return inter;
    }

    public static Network union(Network net1, Network net2, boolean addWeights) {
        Network uni = new Network();
        int i = 0;
        while (i < net1.getNumEdges()) {
            uni.addCopyOfEdge(net1.getEdge(i));
            ++i;
        }
        i = 0;
        while (i < net2.getNumEdges()) {
            Edge edge2 = net2.getEdge(i);
            Edge edgeUni = uni.getEdge(edge2);
            if (edgeUni == null) {
                uni.addCopyOfEdge(edge2);
            } else if (addWeights) {
                edgeUni.setWeight(edgeUni.getWeight() + edge2.getWeight());
            }
            ++i;
        }
        Collections.sort(uni.getEdges());
        return uni;
    }

    public static double jaccardIndex(HashSet<String> set1, HashSet<String> set2) {
        if (set1.size() == 0 || set2.size() == 0) {
            return 0.0;
        }
        int intersection = NetworkUtil.intersection(set1, set2);
        return (double)intersection / (double)(set1.size() + set2.size() - intersection);
    }

    public static int intersection(HashSet<String> set1, HashSet<String> set2) {
        HashSet<String> biggerSet;
        HashSet<String> smallerSet;
        if (set1.size() <= set2.size()) {
            smallerSet = set1;
            biggerSet = set2;
        } else {
            smallerSet = set2;
            biggerSet = set1;
        }
        int intersection = 0;
        Iterator<String> iter = smallerSet.iterator();
        while (iter.hasNext()) {
            if (!biggerSet.contains(iter.next())) continue;
            ++intersection;
        }
        return intersection;
    }
}

