/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.compbio.flynet;

import edu.mit.compbio.flynet.Edge;
import edu.mit.compbio.flynet.FileExport;
import edu.mit.compbio.flynet.FileParser;
import edu.mit.compbio.flynet.Flynet;
import edu.mit.compbio.flynet.Node;
import edu.mit.compbio.flynet.Settings;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Network {
    private String name_ = null;
    private HashMap<String, Node> nodes_ = null;
    private ArrayList<Edge> edges_ = null;
    private HashSet<Node> regulators_ = null;
    private HashSet<Node> targets_ = null;
    private double minEdgeWeight_ = -1.0E12;
    private int numMultiEdgesRemoved_ = 0;
    private int numSelfEdgesRemoved_ = 0;

    public Network() {
        this.initialize();
    }

    public Network(String name) {
        this.initialize();
        this.name_ = name;
    }

    public void initialize() {
        this.nodes_ = new HashMap();
        this.edges_ = new ArrayList();
        this.regulators_ = new HashSet();
        this.targets_ = new HashSet();
        this.numMultiEdgesRemoved_ = 0;
        this.numSelfEdgesRemoved_ = 0;
    }

    public void loadEdgesAboveThreshold(String filename, double minWeight, boolean header) {
        this.minEdgeWeight_ = minWeight;
        this.load(filename, header);
    }

    public void load(String filename, boolean header) {
        this.initialize();
        this.name_ = filename;
        String path = String.valueOf(Settings.networkDir_) + "/" + filename;
        Flynet.println("Reading file: " + path);
        FileParser parser = new FileParser(path);
        String[] nextLine = parser.readLine();
        if (header) {
            nextLine = parser.readLine();
        }
        while (nextLine != null) {
            if (nextLine.length == 3) {
                this.addEdge(nextLine[0], nextLine[1], Double.parseDouble(nextLine[2]));
            } else if (nextLine.length == 2) {
                this.addEdge(nextLine[0], nextLine[1], 1.0);
            } else {
                throw new RuntimeException("Parse error at line " + parser.getLineCounter() + ": expected two or three columns");
            }
            nextLine = parser.readLine();
        }
        parser.close();
        Collections.sort(this.edges_);
        Flynet.println(String.valueOf(this.regulators_.size()) + "\tTFs");
        Flynet.println(String.valueOf(this.targets_.size()) + "\ttarget genes (may also be TFs)");
        if (this.minEdgeWeight_ == -1.0E12) {
            Flynet.println(String.valueOf(this.edges_.size()) + "\tunique edges (no minimal weight specified)");
        } else {
            Flynet.println(String.valueOf(this.edges_.size()) + "\tunique edges (minimal weight considered: " + this.minEdgeWeight_ + ")");
        }
        if (this.numMultiEdgesRemoved_ > 0) {
            Flynet.println(String.valueOf(this.numMultiEdgesRemoved_) + "\tmulti edges have been removed");
        }
        if (this.numSelfEdgesRemoved_ > 0) {
            Flynet.println(String.valueOf(this.numSelfEdgesRemoved_) + "\tself loops have been removed");
        }
        Flynet.println("");
    }

    public void loadSubnet(String filename, String regulatorFile, String targetFile, boolean header) {
        this.initialize();
        this.name_ = filename;
        this.loadNodes(regulatorFile, targetFile);
        String path = String.valueOf(Settings.networkDir_) + "/" + filename;
        Flynet.println("Reading file: " + path);
        FileParser parser = new FileParser(path);
        String[] nextLine = parser.readLine();
        if (header) {
            nextLine = parser.readLine();
        }
        while (nextLine != null) {
            if (nextLine.length == 3) {
                this.addEdgeBetweenExistingNodes(nextLine[0], nextLine[1], Double.parseDouble(nextLine[2]));
            } else if (nextLine.length == 2) {
                this.addEdgeBetweenExistingNodes(nextLine[0], nextLine[1], 1.0);
            } else {
                throw new RuntimeException("Parse error at line " + parser.getLineCounter() + ": expected two or three columns");
            }
            nextLine = parser.readLine();
        }
        parser.close();
        Collections.sort(this.edges_);
        Flynet.println(String.valueOf(this.regulators_.size()) + "\tTFs");
        Flynet.println(String.valueOf(this.targets_.size()) + "\ttarget genes (may also be TFs)");
        if (this.minEdgeWeight_ == -1.0E12) {
            Flynet.println(String.valueOf(this.edges_.size()) + "\tunique edges (no minimal weight specified)");
        } else {
            Flynet.println(String.valueOf(this.edges_.size()) + "\tunique edges (minimal weight considered: " + this.minEdgeWeight_ + ")");
        }
        if (this.numMultiEdgesRemoved_ > 0) {
            Flynet.println(String.valueOf(this.numMultiEdgesRemoved_) + "\tmulti edges have been removed");
        }
        if (this.numSelfEdgesRemoved_ > 0) {
            Flynet.println(String.valueOf(this.numSelfEdgesRemoved_) + "\tself loops have been removed");
        }
        Flynet.println("");
    }

    public void loadNodes(String regulatorFile, String targetFile) {
        this.loadNodes(regulatorFile, true);
        this.loadNodes(targetFile, false);
        Flynet.println(String.valueOf(this.regulators_.size()) + "\tTFs");
        Flynet.println(String.valueOf(this.targets_.size()) + "\ttarget genes (may also be TFs)\n");
    }

    public void printInfo() {
        Flynet.println(String.valueOf(this.regulators_.size()) + "\tTFs");
        Flynet.println(String.valueOf(this.targets_.size()) + "\ttarget genes (may also be TFs)");
        Flynet.println(String.valueOf(this.edges_.size()) + "\tedges");
        Flynet.println("");
    }

    public void loadNodes(String filename, boolean isRegulator) {
        String path = String.valueOf(Settings.networkDir_) + "/" + filename;
        Flynet.println("Reading file: " + path);
        FileParser parser = new FileParser(path);
        String[] nextLine = parser.readLine();
        while (nextLine != null) {
            if (nextLine.length != 1) {
                throw new RuntimeException("Parse error at line " + parser.getLineCounter() + ": expected one column");
            }
            Node node = this.nodes_.get(nextLine[0]);
            if (node == null) {
                node = new Node(nextLine[0]);
                this.nodes_.put(nextLine[0], node);
            }
            if (isRegulator) {
                this.regulators_.add(node);
            } else {
                this.targets_.add(node);
            }
            nextLine = parser.readLine();
        }
        parser.close();
    }

    public void filter(String regulatorFile, String targetFile) {
        Network filter = new Network();
        filter.loadNodes(regulatorFile, targetFile);
        HashMap<String, Node> filterNodes = filter.getNodes();
        HashSet<Node> filterTargets = filter.getTargets();
        HashSet<Node> filterRegulators = filter.getRegulators();
        Node[] nodeArray = this.nodes_.values().toArray(new Node[0]);
        int i = 0;
        while (i < nodeArray.length) {
            String label = nodeArray[i].getLabel();
            Node filterNode = filterNodes.get(label);
            if (filterNode == null) {
                this.removeNode(label);
            } else if (!filterTargets.contains(filterNode)) {
                this.removeTarget(label);
            } else if (!filterRegulators.contains(filterNode)) {
                this.removeRegulator(label);
            }
            ++i;
        }
    }

    public void removeNode(String label) {
        this.removeRegulator(label);
        this.removeTarget(label);
    }

    public void removeRegulator(String label) {
        Node node = this.nodes_.get(label);
        if (node == null) {
            return;
        }
        if (!this.targets_.contains(node)) {
            this.nodes_.remove(label);
        }
        this.regulators_.remove(node);
        this.edges_.removeAll(node.getOutgoingEdges());
    }

    public void removeTarget(String label) {
        Node node = this.nodes_.get(label);
        if (node == null) {
            return;
        }
        if (!this.regulators_.contains(node)) {
            this.nodes_.remove(label);
        }
        this.targets_.remove(node);
        this.edges_.removeAll(node.getIncomingEdges());
    }

    public void save(String filename) {
        FileExport writer = new FileExport(filename);
        DecimalFormat fiveDec = new DecimalFormat("0.00000");
        fiveDec.setGroupingUsed(false);
        int i = 0;
        while (i < this.edges_.size()) {
            Edge edge = this.edges_.get(i);
            String str = String.valueOf(edge.getTf().getLabel()) + "\t" + edge.getTarget().getLabel() + "\t" + fiveDec.format(edge.getWeight());
            double[] features = edge.getFeatures();
            if (features != null) {
                int f = 0;
                while (f < features.length) {
                    str = String.valueOf(str) + "\t" + fiveDec.format(features[f]);
                    ++f;
                }
            }
            writer.println(str);
            ++i;
        }
        writer.close();
    }

    public void saveRegulators(String filename) {
        FileExport writer = new FileExport(filename);
        Iterator<Node> iter = this.regulators_.iterator();
        while (iter.hasNext()) {
            writer.println(iter.next().getLabel());
        }
        writer.close();
    }

    public void saveTargets(String filename) {
        FileExport writer = new FileExport(filename);
        Iterator<Node> iter = this.targets_.iterator();
        while (iter.hasNext()) {
            writer.println(iter.next().getLabel());
        }
        writer.close();
    }

    public boolean contains(Edge edge) {
        Edge thisEdge = this.getEdge(edge);
        return thisEdge != null;
    }

    public Edge getEdge(Edge edge) {
        return this.getEdge(edge.getTf().getLabel(), edge.getTarget().getLabel());
    }

    public Edge getEdge(String regulatorId, String targetId) {
        Node target = this.nodes_.get(targetId);
        if (target == null) {
            return null;
        }
        ArrayList<Edge> incomingEdges = target.getIncomingEdges();
        int i = 0;
        while (i < incomingEdges.size()) {
            if (incomingEdges.get(i).getTf().getLabel().equals(regulatorId)) {
                return incomingEdges.get(i);
            }
            ++i;
        }
        return null;
    }

    public void addCopyOfEdge(Edge edge) {
        this.addEdge(edge.getTf().getLabel(), edge.getTarget().getLabel(), edge.getWeight());
    }

    public void addEdge(String tfLabel, String targetLabel, double weight) {
        if (tfLabel.equals(targetLabel)) {
            ++this.numSelfEdgesRemoved_;
            return;
        }
        Node tf = this.getOrCreateNode(tfLabel);
        Node target = this.getOrCreateNode(targetLabel);
        this.addEdge(tf, target, weight);
    }

    public void addEdgeBetweenExistingNodes(String tfLabel, String targetLabel, double weight) {
        if (tfLabel.equals(targetLabel)) {
            ++this.numSelfEdgesRemoved_;
            return;
        }
        Node tf = this.nodes_.get(tfLabel);
        if (tf == null || !this.regulators_.contains(tf)) {
            return;
        }
        Node target = this.nodes_.get(targetLabel);
        if (target == null || !this.targets_.contains(target)) {
            return;
        }
        this.addEdge(tf, target, weight);
    }

    public void addEdge(Node tf, Node target, double weight) {
        if (weight < this.minEdgeWeight_) {
            return;
        }
        Edge edge = new Edge(tf, target, weight);
        Edge existingEdge = this.getEdge(edge);
        if (existingEdge != null) {
            if (existingEdge.getWeight() < weight) {
                existingEdge.setWeight(weight);
            }
            ++this.numMultiEdgesRemoved_;
            return;
        }
        this.edges_.add(edge);
        target.addIncomingEdge(edge);
        tf.addOutgoingEdge(edge);
        this.regulators_.add(tf);
        this.targets_.add(target);
    }

    public void randomize() {
        HashSet<Node> notRegulators = new HashSet<Node>();
        for (Node gene : this.targets_) {
            if (gene.getOutgoingEdges().size() != 0) continue;
            notRegulators.add(gene);
        }
        assert (notRegulators.size() + this.regulators_.size() == this.nodes_.size());
        this.randomizeNodeLabels(this.regulators_);
        this.randomizeNodeLabels(notRegulators);
    }

    private Node getOrCreateNode(String label) {
        Node node = this.nodes_.get(label);
        if (node == null) {
            node = new Node(label);
            this.nodes_.put(label, node);
        }
        return node;
    }

    public void randomizeNodeLabels(HashSet<Node> nodes) {
        ArrayList<String> randomizedLabels = new ArrayList<String>();
        Iterator<Node> iter = nodes.iterator();
        while (iter.hasNext()) {
            randomizedLabels.add(iter.next().getLabel());
        }
        Collections.shuffle(randomizedLabels);
        int i = 0;
        iter = nodes.iterator();
        while (iter.hasNext()) {
            iter.next().setLabel((String)randomizedLabels.get(i++));
        }
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public String getName() {
        return this.name_;
    }

    public HashMap<String, Node> getNodes() {
        return this.nodes_;
    }

    public ArrayList<Edge> getEdges() {
        return this.edges_;
    }

    public HashSet<Node> getRegulators() {
        return this.regulators_;
    }

    public HashSet<Node> getTargets() {
        return this.targets_;
    }

    public int getNumEdges() {
        return this.edges_.size();
    }

    public Edge getEdge(int i) {
        return this.edges_.get(i);
    }
}

