/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.compbio.flynet;

import edu.mit.compbio.flynet.FileParser;
import edu.mit.compbio.flynet.Flynet;
import edu.mit.compbio.flynet.FunctionalDataset;
import edu.mit.compbio.flynet.Node;
import edu.mit.compbio.flynet.Settings;
import java.util.HashMap;
import jsc.util.Rank;

public class GeneExpression
implements FunctionalDataset {
    private String name_ = null;
    private HashMap<String, double[]> profiles_ = null;
    private int numMeasurements_ = -1;
    private HashMap<String, double[]> sums_ = null;
    private boolean rankTransform_ = false;

    public GeneExpression(boolean rankTransform) {
        this.rankTransform_ = rankTransform;
    }

    public void load(String filename) {
        this.loadData(filename);
        if (this.rankTransform_) {
            this.rankTransformData();
        }
        this.initializeSums();
        Flynet.println(String.valueOf(this.profiles_.size()) + "\tgene profiles");
        Flynet.println(String.valueOf(this.numMeasurements_) + "\tvalues each\n");
    }

    public boolean contains(Node gene) {
        return this.profiles_.containsKey(gene.getLabel());
    }

    public double functionalRelation(Node gene1, Node gene2) {
        double[] profile1 = this.profiles_.get(gene1.getLabel());
        double[] profile2 = this.profiles_.get(gene2.getLabel());
        double[] sum1 = this.sums_.get(gene1.getLabel());
        double[] sum2 = this.sums_.get(gene2.getLabel());
        if (profile1 == null || profile2 == null) {
            throw new RuntimeException("One of the given genes is not part of this dataset");
        }
        double sumOfProducts = 0.0;
        int i = 0;
        while (i < this.numMeasurements_) {
            sumOfProducts += profile1[i] * profile2[i];
            ++i;
        }
        double num = sumOfProducts - sum1[0] * sum2[0] / (double)this.numMeasurements_;
        double den1 = sum1[1] - sum1[0] * sum1[0] / (double)this.numMeasurements_;
        double den2 = sum2[1] - sum2[0] * sum2[0] / (double)this.numMeasurements_;
        if (den1 == 0.0 || den2 == 0.0) {
            return 0.0;
        }
        return num * num / (den1 * den2);
    }

    private void loadData(String filename) {
        this.name_ = filename.substring(0, filename.indexOf("."));
        this.profiles_ = new HashMap();
        String path = String.valueOf(Settings.networkDir_) + "/" + filename;
        Flynet.println("Reading file: " + path);
        FileParser parser = new FileParser(path);
        String[] nextLine = parser.readLine();
        nextLine = parser.readLine();
        this.numMeasurements_ = nextLine.length - 1;
        while (nextLine != null) {
            if (this.numMeasurements_ != nextLine.length - 1) {
                throw new IllegalArgumentException("The expression profiles must all have the same length");
            }
            String gene = nextLine[0];
            if (this.profiles_.get(gene) != null) {
                throw new IllegalArgumentException("A gene must have a single profile");
            }
            double[] expr = new double[this.numMeasurements_];
            int i = 0;
            while (i < this.numMeasurements_) {
                expr[i] = Double.parseDouble(nextLine[i + 1]);
                ++i;
            }
            this.profiles_.put(gene, expr);
            nextLine = parser.readLine();
        }
        parser.close();
    }

    private void initializeSums() {
        this.sums_ = new HashMap();
        for (String gene : this.profiles_.keySet()) {
            double[] expr = this.profiles_.get(gene);
            double[] sum = new double[]{0.0, 0.0};
            int i = 0;
            while (i < this.numMeasurements_) {
                sum[0] = sum[0] + expr[i];
                sum[1] = sum[1] + expr[i] * expr[i];
                ++i;
            }
            this.sums_.put(gene, sum);
        }
    }

    private void rankTransformData() {
        for (double[] profile : this.profiles_.values()) {
            Rank rank = new Rank(profile, 0.0);
            double[] rankedValues = rank.getRanks();
            assert (rankedValues.length == this.numMeasurements_);
            int i = 0;
            while (i < this.numMeasurements_) {
                profile[i] = rankedValues[i];
                ++i;
            }
        }
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public String getName() {
        return this.name_;
    }
}

