/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.compbio.flynet;

import edu.mit.compbio.flynet.FileParser;
import edu.mit.compbio.flynet.Flynet;
import edu.mit.compbio.flynet.FunctionalDataset;
import edu.mit.compbio.flynet.NetworkUtil;
import edu.mit.compbio.flynet.Node;
import edu.mit.compbio.flynet.Settings;
import java.util.HashMap;
import java.util.HashSet;

public class GeneAnnotation
implements FunctionalDataset {
    private String name_ = null;
    private HashMap<String, HashSet<String>> annotation_ = null;

    public void load(String filename) {
        this.name_ = filename.substring(0, filename.indexOf("."));
        this.annotation_ = new HashMap();
        String path = String.valueOf(Settings.networkDir_) + "/" + filename;
        Flynet.println("Reading file: " + path);
        FileParser parser = new FileParser(path);
        String[] nextLine = parser.readLine();
        while (nextLine != null) {
            String gene = nextLine[0];
            String term = nextLine[1];
            HashSet<String> annot = this.annotation_.get(gene);
            if (annot == null) {
                annot = new HashSet();
                this.annotation_.put(gene, annot);
            }
            annot.add(term);
            nextLine = parser.readLine();
        }
        parser.close();
    }

    public boolean contains(Node gene) {
        return this.annotation_.containsKey(gene.getLabel());
    }

    public double functionalRelation(Node gene1, Node gene2) {
        HashSet<String> terms1 = this.annotation_.get(gene1.getLabel());
        HashSet<String> terms2 = this.annotation_.get(gene2.getLabel());
        if (terms1 == null || terms2 == null) {
            throw new RuntimeException("One of the given genes is not annotated");
        }
        return NetworkUtil.jaccardIndex(terms1, terms2);
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public String getName() {
        return this.name_;
    }
}

