/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.compbio.flynet;

import edu.mit.compbio.flynet.FileExport;
import edu.mit.compbio.flynet.Flynet;
import edu.mit.compbio.flynet.FunctionalDataset;
import edu.mit.compbio.flynet.GeneAnnotation;
import edu.mit.compbio.flynet.GeneExpression;
import edu.mit.compbio.flynet.InteractionDataset;
import edu.mit.compbio.flynet.Network;
import edu.mit.compbio.flynet.NetworkUtil;
import edu.mit.compbio.flynet.Node;
import edu.mit.compbio.flynet.Settings;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionalEnrichment {
    private Network integrativeSup_ = null;
    private Network integrativeUnsup_ = null;
    private Network chip_ = null;
    private Network motif_ = null;
    private Network redfly_ = null;
    private FunctionalDataset functionalDataset_ = null;

    public void run(String type) {
        if (type.equalsIgnoreCase("GO")) {
            this.computeEnrichmentGO();
        } else if (type.equalsIgnoreCase("ImaGO")) {
            this.computeEnrichmentImaGO();
        } else if (type.equalsIgnoreCase("devExpr")) {
            this.computeEnrichmentDevExpression();
        } else if (type.equalsIgnoreCase("PPI")) {
            this.computeEnrichmentPPI();
        } else if (type.equalsIgnoreCase("HiC")) {
            this.computeEnrichmentHiCLongRange();
        } else {
            throw new RuntimeException("ERROR: Unknown enrichment type: " + type);
        }
    }

    public void computeEnrichmentGO() {
        this.loadNetworks();
        Settings.networkDir_ = "resources/functional_enrichment";
        this.functionalDataset_ = new GeneAnnotation();
        this.functionalDataset_.load("go.txt");
        this.functionalDataset_.setName("GO");
        Flynet.println("");
        Settings.numRandomized_ = 10;
        Settings.coregulationThreshold_ = 0.5;
        this.computeEnrichment();
    }

    public void computeEnrichmentImaGO() {
        this.loadNetworks();
        Settings.networkDir_ = "resources/functional_enrichment";
        this.functionalDataset_ = new GeneAnnotation();
        this.functionalDataset_.load("imago.txt");
        this.functionalDataset_.setName("ImaGO");
        Flynet.println("");
        Settings.numRandomized_ = 10;
        Settings.coregulationThreshold_ = 0.5;
        this.computeEnrichment();
    }

    public void computeEnrichmentDevExpression() {
        this.loadNetworks();
        Settings.networkDir_ = "resources/functional_enrichment";
        this.functionalDataset_ = new GeneExpression(false);
        this.functionalDataset_.load("rnaseq2.txt");
        this.functionalDataset_.setName("devExpression");
        Flynet.println("");
        Settings.numRandomized_ = 10;
        Settings.coregulationThreshold_ = 0.5;
        this.computeEnrichment();
    }

    public void computeEnrichmentPPI() {
        this.loadNetworks();
        Settings.networkDir_ = "resources/functional_enrichment";
        this.functionalDataset_ = new InteractionDataset();
        this.functionalDataset_.load("ppi.txt");
        this.functionalDataset_.setName("PPI");
        Flynet.println("");
        Settings.numRandomized_ = 100;
        Settings.coregulationThreshold_ = 0.25;
        this.computeEnrichment();
    }

    public void computeEnrichmentHiCLongRange() {
        this.loadNetworks();
        Settings.networkDir_ = "resources/functional_enrichment/HiC";
        this.functionalDataset_ = new InteractionDataset();
        this.functionalDataset_.load("long_range_interactions.txt");
        this.functionalDataset_.setName("HiC_long_range_interactions");
        Flynet.println("");
        Settings.numRandomized_ = 10;
        Settings.coregulationThreshold_ = 0.25;
        this.computeEnrichment();
    }

    public void computeEnrichment() {
        this.computeFunctionalEnrichment(this.integrativeSup_, this.functionalDataset_);
        this.computeFunctionalEnrichment(this.integrativeUnsup_, this.functionalDataset_);
    }

    private void loadNetworks() {
        Settings.networkDir_ = "resources/networks/integrative";
        this.integrativeSup_ = new Network();
        this.integrativeSup_.load("flynet_supervised_0.6.txt", false);
        this.integrativeSup_.setName("IntegrativeSup");
        this.integrativeUnsup_ = new Network();
        this.integrativeUnsup_.load("flynet_unsupervised_0.02.txt", false);
        this.integrativeUnsup_.setName("IntegrativeUnsup");
        Settings.networkDir_ = "resources/networks/physical";
        this.chip_ = new Network();
        this.chip_.load("chip_net.txt", true);
        this.chip_.setName("Chip");
        this.motif_ = new Network();
        this.motif_.load("motif_net.txt", false);
        this.motif_.setName("Motif");
        Settings.networkDir_ = "resources/networks";
        this.redfly_ = new Network();
        this.redfly_.load("redfly.txt", false);
        this.redfly_.setName("REDfly");
    }

    private double computeFunctionalEnrichment(Network network, FunctionalDataset dataset) {
        Flynet.println("Computing functional enrichment: " + network.getName() + "_" + dataset.getName());
        if (network.getNumEdges() == 0) {
            throw new RuntimeException("The network has no edges (maybe the network has been deleted because it was previously used and randomized by computeFunctionalEnrichment()");
        }
        ArrayList<Double> functionalRelation = this.computeFunctionalRelation(network, dataset);
        double networkAvg = this.mean(functionalRelation);
        FileExport writer = new FileExport(String.valueOf(network.getName()) + "_" + dataset.getName() + ".txt");
        writer.print(functionalRelation);
        writer.close();
        ArrayList<Double> functionalRelationRandom = new ArrayList<Double>();
        System.out.print("Randomization: ");
        int i = 0;
        while (i < Settings.numRandomized_) {
            System.out.print(".");
            network.randomize();
            ArrayList<Double> nextRandom = this.computeFunctionalRelation(network, dataset);
            functionalRelationRandom.addAll(nextRandom);
            ++i;
        }
        System.out.print("\n");
        double randomAvg = this.mean(functionalRelationRandom);
        writer = new FileExport(String.valueOf(network.getName()) + "_" + dataset.getName() + "_randomized.txt");
        writer.print(functionalRelationRandom);
        writer.close();
        double enrichment = networkAvg / randomAvg;
        Flynet.println("Enrichment:\t" + enrichment + "\n");
        network.initialize();
        return enrichment;
    }

    private double sum(ArrayList<Double> vect) {
        double sum = 0.0;
        int i = 0;
        while (i < vect.size()) {
            sum += vect.get(i).doubleValue();
            ++i;
        }
        return sum;
    }

    private double mean(ArrayList<Double> vect) {
        return this.sum(vect) / (double)vect.size();
    }

    private ArrayList<Double> computeFunctionalRelation(Network network, FunctionalDataset dataset) {
        ArrayList<Double> functionalRelation = new ArrayList<Double>();
        Node[] targets = network.getTargets().toArray(new Node[1]);
        int i = 0;
        while (i < targets.length - 1) {
            if (dataset.contains(targets[i])) {
                int j = i + 1;
                while (j < targets.length) {
                    double f;
                    HashSet<String> regulators_j;
                    HashSet<String> regulators_i;
                    if (dataset.contains(targets[j]) && NetworkUtil.jaccardIndex(regulators_i = targets[i].getRegulators(), regulators_j = targets[j].getRegulators()) > Settings.coregulationThreshold_ && (f = dataset.functionalRelation(targets[i], targets[j])) != Double.NaN) {
                        functionalRelation.add(f);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return functionalRelation;
    }
}

