/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.compbio.flynet;

import edu.mit.compbio.flynet.Edge;
import edu.mit.compbio.flynet.Flynet;
import edu.mit.compbio.flynet.GeneExpression;
import edu.mit.compbio.flynet.Network;
import edu.mit.compbio.flynet.Node;
import edu.mit.compbio.flynet.Settings;
import edu.mit.compbio.flynet.SupervisedLearning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

public class FlynetInference {
    private boolean supervised_ = false;
    private Network chip_ = null;
    private Network motif_ = null;
    private GeneExpression chromatinTC_ = null;
    private GeneExpression chromatinCL_ = null;
    private GeneExpression rnaSeq_ = null;
    private GeneExpression microarray_ = null;
    private Network network_ = null;
    private double[] coeffs_ = null;

    public void run() {
        this.supervised_ = Settings.generateSup_;
        if (this.supervised_) {
            this.loadInputDatasets(true);
            this.generateFeatures();
            this.runSupervisedLearning();
            this.generateNetwork("integrativeSupervised_redfly.txt");
        }
        this.loadInputDatasets(false);
        this.generateFeatures();
        if (this.supervised_) {
            this.generateNetwork("integrativeSupervised.txt");
        } else {
            this.generateNetwork("integrativeUnsupervised.txt");
        }
    }

    private void loadInputDatasets(boolean redflyUniverseOnly) {
        String tgFile;
        String tfFile;
        Settings.networkDir_ = "resources/input_data";
        if (redflyUniverseOnly) {
            tfFile = "../networks/redfly_tfs.txt";
            tgFile = "../networks/redfly_tgs.txt";
        } else {
            tfFile = "tf.txt";
            tgFile = "tg.txt";
        }
        this.network_ = new Network();
        this.network_.loadNodes(tfFile, tgFile);
        this.chip_ = new Network();
        this.chip_.load("chip_net.txt", true);
        this.chip_.setName("Chip");
        this.motif_ = new Network();
        this.motif_.load("motif_regnet_highestconf.txt", true);
        this.motif_.setName("Motif");
        this.chromatinTC_ = new GeneExpression(true);
        this.chromatinTC_.load("chrom-tc.txt");
        this.chromatinTC_.setName("ChromatinTC");
        this.chromatinCL_ = new GeneExpression(true);
        this.chromatinCL_.load("chrom-cl.txt");
        this.chromatinCL_.setName("ChromatinCL");
        this.rnaSeq_ = new GeneExpression(true);
        this.rnaSeq_.load("rnaseq.txt");
        this.rnaSeq_.setName("RNAseq");
        this.microarray_ = new GeneExpression(true);
        this.microarray_.load("microarray.txt");
        this.microarray_.setName("Microarray");
    }

    private void generateFeatures() {
        Flynet.println("Computing input features...\n");
        HashSet<Node> regulators = this.network_.getRegulators();
        HashSet<Node> targets = this.network_.getTargets();
        for (Node tf : regulators) {
            for (Node target : targets) {
                if (tf == target) continue;
                int numFeatures = 6;
                double[] features = new double[numFeatures];
                features[0] = this.motifWeight(tf, target);
                features[1] = this.chipWeight(tf, target);
                features[2] = this.correlation(tf, target, this.chromatinTC_);
                features[3] = this.correlation(tf, target, this.chromatinCL_);
                features[4] = this.correlation(tf, target, this.microarray_);
                features[5] = this.correlation(tf, target, this.rnaSeq_);
                Edge edge = new Edge(tf, target, -1.0);
                edge.setFeatures(features);
                this.network_.getEdges().add(edge);
            }
        }
    }

    private void runSupervisedLearning() {
        SupervisedLearning learner = new SupervisedLearning();
        this.coeffs_ = learner.run(this.network_.getEdges());
    }

    private void generateNetwork(String filename) {
        Flynet.println("Generating integrative network ...");
        ArrayList<Edge> edges = this.network_.getEdges();
        int i = 0;
        while (i < edges.size()) {
            double[] features = edges.get(i).getFeatures();
            double weight = 0.0;
            if (!this.supervised_) {
                int f = 0;
                while (f < features.length) {
                    weight += features[f];
                    ++f;
                }
                weight /= (double)features.length;
            } else {
                double z = this.coeffs_[0];
                int f = 0;
                while (f < features.length) {
                    int n = f;
                    features[n] = features[n] * this.coeffs_[f + 1];
                    z += features[f];
                    ++f;
                }
                weight = 1.0 / (1.0 + Math.exp(-z));
            }
            edges.get(i).setWeight(weight);
            ++i;
        }
        Collections.sort(this.network_.getEdges());
        Flynet.println("Saving network: " + filename);
        this.network_.save(filename);
    }

    private double chipWeight(Node tf, Node target) {
        Node chipTf = this.chip_.getNodes().get(tf.getLabel());
        if (chipTf == null || chipTf.getOutgoingEdges().size() == 0) {
            return Settings.missingValue_;
        }
        Edge edge = this.chip_.getEdge(tf.getLabel(), target.getLabel());
        if (edge != null) {
            return 0.95;
        }
        return 0.05;
    }

    private double motifWeight(Node tf, Node target) {
        Node motifTf = this.motif_.getNodes().get(tf.getLabel());
        if (motifTf == null) {
            return Settings.missingValue_;
        }
        Node motifTarget = this.motif_.getNodes().get(target.getLabel());
        if (motifTarget == null) {
            return Settings.missingValue_;
        }
        Edge edge = this.motif_.getEdge(tf.getLabel(), target.getLabel());
        if (edge != null) {
            return edge.getWeight();
        }
        return Settings.missingValue_;
    }

    private double correlation(Node tf, Node target, GeneExpression dataset) {
        if (!dataset.contains(tf) || !dataset.contains(target)) {
            return Settings.missingValue_;
        }
        return dataset.functionalRelation(tf, target);
    }
}

