/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.compbio.flynet;

import edu.mit.compbio.flynet.Edge;
import edu.mit.compbio.flynet.FlynetInference;
import edu.mit.compbio.flynet.FunctionalEnrichment;
import edu.mit.compbio.flynet.Network;
import edu.mit.compbio.flynet.NetworkUtil;
import edu.mit.compbio.flynet.RecoveryRate;
import edu.mit.compbio.flynet.Settings;
import edu.mit.compbio.flynet.Translator;
import java.util.ArrayList;
import java.util.Collections;

public class Flynet {
    public static void main(String[] args) {
        try {
            Flynet flynet;
            Settings.flynet_ = flynet = new Flynet();
            flynet.run(args);
        }
        catch (Exception e) {
            Flynet.error(e);
        }
    }

    public static void error(Exception e) {
        e.printStackTrace();
        System.exit(-1);
    }

    public static void println(String msg) {
        System.out.println(msg);
    }

    public static String insertBeforeFileExtension(String filename, String appendix) {
        int index = filename.lastIndexOf(46);
        if (index < 2) {
            index = filename.length();
        }
        return String.valueOf(filename.substring(0, index)) + appendix + ".txt";
    }

    public Flynet() {
        Settings.initializeJsap();
    }

    public void run(String[] args) {
        Settings.parseArguments(args);
        if (Settings.generateSup_ || Settings.generateUnsup_) {
            new FlynetInference().run();
        } else if (Settings.computeRecoveryRates_) {
            new RecoveryRate().run();
        } else if (Settings.computeEnrichment_ != null) {
            new FunctionalEnrichment().run(Settings.computeEnrichment_);
        } else if (Settings.computeIntersection_ || Settings.computeUnion_) {
            this.networkOperations();
        } else if (Settings.cutoff_ != -1.0) {
            this.runTruncate();
        } else if (Settings.filter_) {
            this.runFilter();
        } else if (Settings.cleanFBgns_) {
            this.cleanFBgns();
        } else if (Settings.runTest_) {
            this.tests();
        } else {
            Settings.printUsage();
        }
    }

    private void networkOperations() {
        String[] fileList = Settings.argFileList_;
        int numNetworks = fileList.length;
        if (numNetworks < 2) {
            throw new IllegalArgumentException("At least two networks are required");
        }
        ArrayList<Network> networks = new ArrayList<Network>();
        int i = 0;
        while (i < numNetworks) {
            Network net = new Network();
            if (Settings.wmin_ == -1.0) {
                net.load(fileList[i], false);
            } else {
                net.loadEdgesAboveThreshold(fileList[i], Settings.wmin_, false);
            }
            networks.add(net);
            ++i;
        }
        String filename = null;
        Network result = null;
        if (Settings.computeIntersection_) {
            result = NetworkUtil.intersect((Network)networks.get(0), (Network)networks.get(1), true);
            int i2 = 2;
            while (i2 < numNetworks) {
                result = NetworkUtil.intersect(result, (Network)networks.get(i2), true);
                ++i2;
            }
            filename = "intersection.txt";
            Flynet.println("Intersection:");
        } else if (Settings.computeUnion_) {
            result = NetworkUtil.union((Network)networks.get(0), (Network)networks.get(1), true);
            int i3 = 2;
            while (i3 < numNetworks) {
                result = NetworkUtil.union(result, (Network)networks.get(i3), true);
                ++i3;
            }
            filename = "union.txt";
            Flynet.println("Union:");
        }
        result.printInfo();
        Flynet.println("Writing file: " + filename);
        result.save(filename);
    }

    private void runTruncate() {
        String[] fileList = Settings.argFileList_;
        if (fileList == null || fileList.length < 1) {
            throw new IllegalArgumentException("Specify at least one network: --trunc <fraction> <net1> <net2> ...");
        }
        System.out.println("Truncating networks to top " + 100.0 * Settings.cutoff_ + "% of total edges...");
        if (Settings.cutoff_ <= 0.0 || Settings.cutoff_ > 1.0) {
            throw new IllegalArgumentException("The cutoff must be between 0 and 1");
        }
        int i = 0;
        while (i < fileList.length) {
            Network net = new Network();
            if (Settings.wmin_ == -1.0) {
                net.load(fileList[i], false);
            } else {
                net.loadEdgesAboveThreshold(fileList[i], Settings.wmin_, false);
            }
            ArrayList<Edge> edges = net.getEdges();
            int numEdgesBefore = edges.size();
            int numEdgesAfter = (int)Math.round(Settings.cutoff_ * (double)numEdgesBefore);
            Collections.shuffle(edges);
            Collections.sort(edges);
            edges.subList(numEdgesAfter, edges.size()).clear();
            assert (net.getNumEdges() == numEdgesAfter);
            Flynet.println("Num edges after cutoff: " + numEdgesAfter);
            Flynet.println("");
            String filename = Flynet.insertBeforeFileExtension(fileList[i], "_trunc");
            net.save(filename);
            ++i;
        }
    }

    private void runFilter() {
        String[] fileList = Settings.argFileList_;
        if (fileList == null || fileList.length < 3) {
            throw new IllegalArgumentException("Specify at least three files: --filter <TFs> <targets> <network> ...");
        }
        String tfList = fileList[0];
        String targetList = fileList[1];
        int i = 2;
        while (i < fileList.length) {
            String inputFile = fileList[i];
            Network net = new Network();
            net.loadSubnet(inputFile, tfList, targetList, false);
            String outputFile = Flynet.insertBeforeFileExtension(inputFile, "_filtered");
            net.save(outputFile);
            ++i;
        }
    }

    private void cleanFBgns() {
        String[] fileList = Settings.argFileList_;
        if (fileList == null || fileList.length != 1) {
            throw new RuntimeException("You must specify exactly one input file, use: --fbgn <inputfile>");
        }
        Translator translator = Translator.getInstance();
        translator.toPrimaryFBgn(fileList[0], Settings.argColumn_, Settings.argNumHeaderLines_, Settings.argDelete_);
    }

    private void tests() {
        System.exit(0);
    }
}

