/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.compbio.flynet;

import edu.mit.compbio.flynet.Flynet;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileParser {
    protected String separator_ = "\t";
    protected BufferedReader reader_ = null;
    protected int lineCounter_ = 0;
    protected String nextLine_ = null;

    public FileParser(String filename) {
        try {
            FileInputStream fstream = new FileInputStream(filename);
            DataInputStream in = new DataInputStream(fstream);
            this.reader_ = new BufferedReader(new InputStreamReader(in));
        }
        catch (Exception e) {
            Flynet.error(e);
        }
    }

    public String[] readLine() {
        try {
            ++this.lineCounter_;
            this.nextLine_ = this.reader_.readLine();
        }
        catch (IOException e) {
            Flynet.error(e);
        }
        if (this.nextLine_ == null) {
            return null;
        }
        return this.nextLine_.split(this.separator_, -1);
    }

    public ArrayList<String[]> readAll() {
        ArrayList<String[]> data = new ArrayList<String[]>();
        try {
            while (true) {
                this.nextLine_ = this.reader_.readLine();
                if (this.nextLine_ != null) {
                    ++this.lineCounter_;
                    data.add(this.nextLine_.split(this.separator_));
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            Flynet.error(e);
        }
        return data;
    }

    public String readRawLine() {
        try {
            ++this.lineCounter_;
            this.nextLine_ = this.reader_.readLine();
        }
        catch (IOException e) {
            Flynet.error(e);
        }
        return this.nextLine_;
    }

    public void close() {
        try {
            this.reader_.close();
        }
        catch (IOException e) {
            Flynet.error(e);
        }
    }

    public void skipLines(int N) {
        try {
            int i = 0;
            while (i < N) {
                this.reader_.readLine();
                ++i;
            }
        }
        catch (IOException e) {
            Flynet.error(e);
        }
    }

    public void setSeparator(String separator) {
        this.separator_ = separator;
    }

    public int getLineCounter() {
        return this.lineCounter_;
    }
}

