package util;



import java.io.*;
import java.util.*;
import org.apache.regexp.*;

/**
 * Probably not used anymore.
 * Superceded by Perl scripts!
 * 
 * @author Barbara Engelhardt
 * @deprecated
 */
public class PFunPFam {
	// Denotes whether these members of the proteins
    // should be pulled out of the SwissProt DB.
    private static boolean nameP;
    private static boolean idP;
    private static boolean descriptionP;
    private static boolean alignmentsP;
    private static String pfamFileName;
    private static String speciesFileName;
    
    private static Hashtable familyData; // list of PfunProteins, indexed by pnum
    private static int lineNum;
    private static String lastName;
    private static PfunFamily currentFamily;
    
    // Regular Expression Patterns
    public static Pattern reIdPattern;
    public static Pattern reNamePattern;			
    public static Pattern reDescriptionPattern;
    public static Pattern reTranslationPattern;
    public static Pattern reAlignmentPattern;
    public static Pattern reNotAlignmentPattern;
    public static Pattern reTreePattern;
    
    public static void setupRegex () {
	
        String go = "([0-9]+)";
        String id = "([A-Z0-9]+)";
        String nameId = "([a-zA-Z0-9\\-\\/_]+)";
        String sequence = "([ACDEFGHIKLMNPQRSTVWY.\\s\\-achp\\+sutol\\*]+)";
        String description = "([\\.]+)";
        String tree = "([^;]+)";
        String idPattern = "#=GF AC   "+nameId;
        String namePattern = "#=GF ID   "+id; 
        String descriptionPattern = "#=GF DE   "+description;
        String translationPattern = "#=GS "+nameId+"\\s+AC "+id;
        String notAlignmentPattern = "#|\\/\\/";
        String alignmentPattern = nameId+"\\s+";
    	String treePattern = "\\("+id+":";
         
	reIdPattern = Pattern.compile(idPattern);
	reNamePattern = Pattern.compile(namePattern);			
	reDescriptionPattern = Pattern.compile(descriptionPattern);
	reTranslationPattern = Pattern.compile(translationPattern);
	reNotAlignmentPattern = Pattern.compile(notAlignmentPattern);
	reAlignmentPattern = Pattern.compile(alignmentPattern);
	reTreePattern = Pattern.compile(treePattern);
    }

    public void processRegexResults (String s) 
    {
    	String paren0, paren1, paren2;

    	Matcher matchesIdPattern;
    	Matcher matchesNamePattern;
    	Matcher matchesDescriptionPattern;
    	Matcher matchesTranslationPattern;
	Matcher matchesNotAlignmentPattern;
	Matcher matchesAlignmentPattern;
	paren0 = paren1 = paren2 = null;

       	matchesNamePattern = reNamePattern.matcher(s);
	if(matchesNamePattern) {
	    paren0 = matchesNamePattern.group(0);
	    paren1 = matchesNamePattern.group(1);
	    if(paren1 != null) {
		lastName = paren1;
	    }
	}
	
    	matchesIdPattern = reIdPattern.matcher(s);
    	if(matchesIdPattern.matches()) {
	    paren0 = matchesIdPattern.group(0);
	    paren1 = matchesIdPattern.group(1);
	    if(paren1 != null) {
		if(currentFamily != null) {
		    familyData.put(currentFamily.getID(), currentFamily);
		    System.out.println(currentFamily.getID());
		}
		if(familyData.containsKey(paren1)) {
		    
		    currentFamily = (PfunFamily)familyData.get(paren1);
		} else {
		    currentFamily = new PfunFamily(paren1);
		}
		if(lastName != null)
		    currentFamily.setName(lastName);
	    }
	    return;
    	}
	
	
	
	if(descriptionP) {
	    matchesDescriptionPattern = reDescriptionPattern.matcher(s);
	    if(matchesDescriptionPattern.matches()) {
		paren0 = matchesDescriptionPattern.group(0);
		paren1 = matchesDescriptionPattern.group(1);
		if(paren1 != null) {
		    currentFamily.addPFamFunction(paren1);
		}
		return;
	    }    		
    	}
    	if(alignmentsP) {
	    matchesTranslationPattern = reTranslationPattern.matcher(s);
	    if(matchesTranslationPattern.matches()) {
		paren0 = matchesTranslationPattern.group(0);
		paren1 = matchesTranslationPattern.group(1);
		paren2 = matchesTranslationPattern.group(2);
		if(paren1 != null && paren2 != null) {
		    currentFamily.setProteinName(paren2, paren1);
		}
		return;
	    }
	    matchesAlignmentPattern = reAlignmentPattern.matcher(s);
	    matchesNotAlignmentPattern = reNotAlignmentPattern.matcher(s);
	    if(matchesAlignmentPattern.matches() 
	       && !matchesNotAlignmentPattern.matches()) {
		paren0 = matchesAlignmentPattern.group(0);
		paren1 = matchesAlignmentPattern.group(1);
		if(paren1 != null) 
		    paren2 = s.substring(paren1.length(), s.length());
		if(paren2 != null && paren2.lastIndexOf(' ') >= 0) 
		    paren2.substring(paren2.lastIndexOf(' ')+1, paren2.length());
		if(paren1 != null && paren2 != null) {
		    currentFamily.setProteinAlignment(paren1, paren2);
		}
		return;
	    }
    	}	
    }
    
    public void processRegexResultsSpeciesTree (String s) 
    {
    	String paren0, paren1;

    	boolean matchesTreePattern;

		paren0 = paren1 = null;

       	matchesTreePattern = reTreePattern.matcher(s);
		if(matchesTreePattern.matches()) {
    		paren0 = matchesTreePattern.group(0);
    		paren1 = matchesTreePattern.group(1);
    		//paren2 = matchesTreePattern.group(2);
			if(paren0 != null && paren1 != null) {
				PfunFamily pff = (PfunFamily)familyData.get(paren1);
				if(pff != null)
					pff.setSpeciesTree(s, "PFamDB");
			}
		}
    }
    
    public PFunPFam(String fileName, String speciesTreeName, boolean pName, 
    	boolean pFunction, boolean pAlignments)
    {
		nameP = pName;
		descriptionP = pFunction;
		alignmentsP = pAlignments;
		pfamFileName = fileName;
		speciesFileName = speciesTreeName;
		setupRegex();
   }

	// This function reads through the GO/Swissprot
	// file and fills out the fields specified in 
	// the constructor, and returns a vector of
	// PfunProteins.
    public Hashtable fillOutList(Vector spNums)
    {
    	return fillOutList(new Hashtable());
    }
    
    public Hashtable fillOutList(Hashtable fData)
    {
	familyData = fData;
	String str = null;
	BufferedReader fin;
	BufferedReader finSpecies;
	lineNum = 0;
	currentFamily = null;
	
        try {
            fin = new BufferedReader(new FileReader (pfamFileName));
            finSpecies = new BufferedReader(new FileReader (speciesFileName));
	    try {
            	while ((str=fin.readLine()) != null) {
		    lineNum++;
		    processRegexResults(str);
            	}
	    }
	    catch (Exception e) {
            	System.out.println("Error in ProcessFilePFam: " + str + " " + lineNum + " " + e.getMessage());
	    }
	    fin.close();
	    lineNum = 0;
	    try {
            	while ((str=finSpecies.readLine()) != null) {
		    lineNum++;
		    processRegexResultsSpeciesTree(str);
            	}
	    }
	    catch (Exception e) {
            	System.out.println("Error in ProcessFilePFam(Species): " + str + " " + lineNum + " " + e.getMessage());
	    }
	    finSpecies.close();
        }
        catch (Exception ioe) {
	    System.err.println("ProcessFilePFam: " + pfamFileName + " " +
			       ioe.getMessage());
            System.exit(1);
        }
        if(currentFamily != null) {
	    familyData.put(currentFamily.getID(), currentFamily);
	    System.out.println(currentFamily.getID());
        }
	return familyData;
    }
    
    // Need a utility to convert species tree to a species tree that
    // forester can read: prefix to postfix notation.
    
    private String postfixSpeciesTree()
    {
    	String postfix = new String();
    	return postfix;
    	
    }

}
