/*
 * Decompiled with CFR 0.152.
 */
package forester.tree;

import forester.tree.Branch;
import forester.tree.Node;
import forester.tree.PreorderTreeIterator;
import forester.tree.TreeHelper;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class Tree
implements Serializable {
    static final int MAX_LENGTH = 10;
    static final long serialVersionUID = -6847390332113L;
    private Node ext_node0_;
    private Node root_;
    private double highest_lnL_;
    private double lowest_lnL_;
    private double real_height_;
    private int external_nodes_;
    private int number_of_duplications_;
    private boolean rooted_;
    private boolean more_than_bin_nodes_in_NH_;
    private String name_;
    private Hashtable idhash_;
    private int j_;

    public Tree() {
        this.delete();
    }

    public Tree(String string) throws Exception {
        this.delete();
        boolean bl = true;
        int n = 0;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        StringBuffer stringBuffer = null;
        Stack<String> stack = null;
        String string6 = new String(":-100.0");
        string = TreeHelper.removeWhiteSpace(string);
        string = TreeHelper.removeComments(string);
        if (!TreeHelper.isEmpty(string) && string.charAt(0) != '(' && string.indexOf("(") != -1) {
            int n2 = string.indexOf("(");
            string = string.substring(n2);
        }
        if (!TreeHelper.isEmpty(string) && string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        if (TreeHelper.countAndCheckParantheses(string) <= -1) {
            String string7 = "Tree: Tree( String ): Error in NHX format: ";
            string7 = string7 + "open parantheses != close parantheses.";
            throw new Exception(string7);
        }
        if (!TreeHelper.checkCommas(string)) {
            String string8 = "Tree: Tree( String ): Error in NHX format: ";
            string8 = string8 + "Commas not properly set.";
            throw new Exception(string8);
        }
        if (string.length() < 1) {
            this.setExtNode0(null);
            this.setRoot(null);
        } else if (string.indexOf("(") != -1) {
            string5 = "";
            string4 = "";
            string3 = "";
            stack = new Stack<String>();
            block0: for (n = 0; n <= string.length() - 1; ++n) {
                if (string.charAt(n) == ',') {
                    stack.push(",");
                }
                if (string.charAt(n) == '(') {
                    stack.push("(");
                }
                if (string.charAt(n) != ',' && string.charAt(n) != '(' && string.charAt(n) != ')') {
                    stringBuffer = new StringBuffer("");
                    while (n <= string.length() - 1 && string.charAt(n) != ')' && string.charAt(n) != ',') {
                        stringBuffer.append(string.charAt(n));
                        ++n;
                    }
                    --n;
                    stack.push(stringBuffer.toString());
                }
                if (string.charAt(n) != ')') continue;
                string2 = "";
                if (n <= string.length() - 2 && string.charAt(n + 1) != ')' && string.charAt(n + 1) != ',') {
                    ++n;
                    stringBuffer = new StringBuffer("");
                    while (n <= string.length() - 1 && string.charAt(n) != ')' && string.charAt(n) != ',') {
                        stringBuffer.append(string.charAt(n));
                        ++n;
                    }
                    --n;
                    string2 = stringBuffer.toString();
                }
                bl = true;
                while (true) {
                    string3 = stack.pop().toString();
                    if (stack.empty()) {
                        this.connectInternal(string2);
                        continue block0;
                    }
                    string4 = stack.pop().toString();
                    if (stack.empty()) {
                        if (string3.equals("(")) {
                            this.connectInternal(string2);
                            stack.push("(");
                            continue;
                        }
                        if (string3.equals(",")) {
                            this.connectInternal(string2);
                            continue block0;
                        }
                        this.addNodeAndConnect(string3, string2);
                        continue block0;
                    }
                    string5 = stack.peek().toString();
                    if (!string5.equals("(") && string4.equals(",") && !string3.equals(",")) {
                        if (bl && !string5.equals(",")) {
                            this.addNode(string3);
                            stack.push(",");
                        } else {
                            this.addNodeAndConnect(string3, string6);
                        }
                        bl = false;
                        continue;
                    }
                    bl = false;
                    if (string5.equals(",") && !string4.equals(",") && !string4.equals("(") && string3.equals(",")) {
                        this.addNodeAndConnect(string4, string6);
                        continue;
                    }
                    if (!string5.equals("(") && string4.equals(",") && string3.equals(",")) {
                        this.connectInternal(string6);
                        stack.push(",");
                        continue;
                    }
                    if (string5.equals("(") && string4.equals(",") && !string3.equals("(") && !string3.equals(",")) {
                        this.addNodeAndConnect(string3, string2);
                        stack.pop();
                        continue block0;
                    }
                    if (string5.equals("(") && !string4.equals("(") && !string4.equals(",") && string3.equals(",")) {
                        this.addNodeAndConnect(string4, string2);
                        stack.pop();
                        continue block0;
                    }
                    if (string5.equals("(") && string4.equals(",") && string3.equals(",")) {
                        this.connectInternal(string6);
                        this.connectInternal(string2);
                        stack.pop();
                        continue block0;
                    }
                    if (string5.equals(",") && string4.equals("(") && !string3.equals("(") && !string3.equals(",")) {
                        this.addNodeAndConnect(string3, string2);
                        continue block0;
                    }
                    if (string5.equals(",") && string4.equals("(") && string3.equals(",")) {
                        this.connectInternal(string2);
                        continue block0;
                    }
                    if (string5.equals("(") && string4.equals("(") && !string3.equals("(")) {
                        if (string3.equals(",")) {
                            this.connectInternal(string2);
                            continue block0;
                        }
                        this.addNodeAndConnect(string3, string2);
                        continue block0;
                    }
                    if (string3.equals("(") && (string5.equals("(") && string4.equals(",") || string5.equals(",") && string4.equals("(") || string5.equals("(") && string4.equals("("))) break;
                }
                this.connectInternal(string2);
                stack.push("(");
            }
            if (!this.getExtNode0().getRoot().getChild1().isPseudoNode() && !this.getExtNode0().getRoot().getChild2().isPseudoNode()) {
                this.setRooted(true);
            }
        } else {
            this.addNode(string);
            this.setRooted(true);
        }
        if (!this.isEmpty()) {
            this.setRoot(this.getExtNode0().getRoot());
            if (!this.isRooted()) {
                this.getRoot().deleteData();
            }
            this.findExtremeLnL();
            this.calculateRealHeight();
            if (this.areBranchLenghtsBootstraps()) {
                this.moveBranchLenghtsToBootstrap();
            }
        }
    }

    public Tree copyTree() {
        Tree tree = new Tree();
        if (this.isEmpty()) {
            tree.delete();
            return tree;
        }
        tree.rooted_ = this.rooted_;
        tree.highest_lnL_ = this.highest_lnL_;
        tree.lowest_lnL_ = this.lowest_lnL_;
        tree.real_height_ = this.real_height_;
        tree.external_nodes_ = this.external_nodes_;
        tree.number_of_duplications_ = this.number_of_duplications_;
        tree.more_than_bin_nodes_in_NH_ = this.more_than_bin_nodes_in_NH_;
        tree.name_ = new String(this.name_);
        tree.idhash_ = this.idhash_;
        tree.root_ = Node.copyTree(this.root_);
        tree.getRoot().setParents();
        tree.adjustExtNode0();
        tree.adjustReferencesInExtNodes();
        return tree;
    }

    public void delete() {
        this.ext_node0_ = null;
        this.root_ = null;
        this.rooted_ = false;
        this.more_than_bin_nodes_in_NH_ = true;
        this.highest_lnL_ = 0.0;
        this.lowest_lnL_ = 0.0;
        this.real_height_ = 0.0;
        this.external_nodes_ = 0;
        this.number_of_duplications_ = -1;
        this.name_ = "";
        this.idhash_ = null;
        this.j_ = 0;
    }

    public Tree subTree(int n) {
        Tree tree = null;
        Node node = null;
        if (this.isEmpty()) {
            return null;
        }
        tree = this.copyTree();
        node = tree.getNode(n);
        if (node == null || node.isExternal()) {
            return null;
        }
        node.setParent(null);
        node.setDistanceToParent(-99.0);
        tree.setRooted(true);
        tree.setRoot(node);
        tree.adjustExtNode0();
        tree.adjustReferencesInExtNodes();
        tree.adjustNodeCount(true);
        tree.recalculateAndReset();
        tree.setExtNodes(tree.getRoot().getSumExtNodes());
        return tree;
    }

    public void unRootAndTrifurcate() {
        double d = 0.0;
        if (this.isEmpty()) {
            return;
        }
        this.unRoot();
        if (this.getNumberOfExtNodes() <= 2) {
            return;
        }
        d = this.getRoot().getChild2().getDistanceToParent() + this.getRoot().getChild1().getDistanceToParent();
        if (this.getRoot().getChild2().isExternal() || this.getRoot().getChild2().collapse()) {
            if (d >= 0.0) {
                this.getRoot().getChild2().setDistanceToParent(d);
            } else {
                this.getRoot().getChild2().setDistanceToParent(-99.0);
            }
            this.getRoot().getChild1().setDistanceToParent(-100.0);
        } else {
            if (d >= 0.0) {
                this.getRoot().getChild1().setDistanceToParent(d);
            } else {
                this.getRoot().getChild1().setDistanceToParent(-99.0);
            }
            this.getRoot().getChild2().setDistanceToParent(-100.0);
        }
        this.recalculateAndReset();
    }

    public void unRoot() {
        if (this.isEmpty()) {
            return;
        }
        this.setIndicatorsToZero();
        if (!this.isRooted() || this.getNumberOfExtNodes() <= 1) {
            return;
        }
        this.setRooted(false);
        this.recalculateAndReset();
    }

    public void removeExtNode(Node node) {
        Node node2 = null;
        Node node3 = null;
        Node node4 = null;
        if (this.isEmpty()) {
            return;
        }
        if (this.getNumberOfExtNodes() == 1 && node == this.getExtNode0()) {
            this.delete();
            return;
        }
        node2 = node;
        if (node2 == this.getExtNode0()) {
            this.setExtNode0(node2.getNextExtNode());
            node2.getNextExtNode().setPrevExtNode(null);
        } else if (node2.getNextExtNode() == null) {
            node2.getPrevExtNode().setNextExtNode(null);
        } else {
            node2.getNextExtNode().setPrevExtNode(node2.getPrevExtNode());
            node2.getPrevExtNode().setNextExtNode(node2.getNextExtNode());
        }
        node3 = node2.getParent();
        if (node3.isRoot()) {
            if (node2.isChild1()) {
                this.setRoot(this.getRoot().getChild2());
                this.getRoot().setParent(null);
            } else {
                this.setRoot(this.getRoot().getChild1());
                this.getRoot().setParent(null);
            }
        } else {
            node4 = node2.getParent().getParent();
            if (node3.isChild1()) {
                if (node2.isChild1()) {
                    node3.getChild2().setDistanceToParent(this.addDist(node3.getDistanceToParent(), node3.getChild2().getDistanceToParent()));
                    node4.setChild1(node3.getChild2());
                    node3.getChild2().setParent(node4);
                } else {
                    node3.getChild1().setDistanceToParent(this.addDist(node3.getDistanceToParent(), node3.getChild1().getDistanceToParent()));
                    node4.setChild1(node3.getChild1());
                    node3.getChild1().setParent(node4);
                }
            } else if (node2.isChild1()) {
                node3.getChild2().setDistanceToParent(this.addDist(node3.getDistanceToParent(), node3.getChild2().getDistanceToParent()));
                node4.setChild2(node3.getChild2());
                node3.getChild2().setParent(node4);
            } else {
                node3.getChild1().setDistanceToParent(this.addDist(node3.getDistanceToParent(), node3.getChild1().getDistanceToParent()));
                node4.setChild2(node3.getChild1());
                node3.getChild1().setParent(node4);
            }
            while (node4 != this.getRoot()) {
                node4.setSumExtNodes(node4.getSumExtNodes() - 1);
                node4 = node4.getParent();
            }
            node4.setSumExtNodes(node4.getSumExtNodes() - 1);
        }
        this.setExtNodes(this.getNumberOfExtNodes() - 1);
        this.idhash_ = null;
    }

    private double addDist(double d, double d2) {
        if (d >= 0.0 && d2 >= 0.0) {
            return d + d2;
        }
        if (d >= 0.0) {
            return d;
        }
        if (d2 >= 0.0) {
            return d2;
        }
        if (d == -100.0 && d2 == -100.0) {
            return -100.0;
        }
        return -99.0;
    }

    public void swapChildren(int n) {
        this.swapChildren(this.getNode(n));
    }

    public void swapChildren(Node node) {
        Node node2 = null;
        if (this.isEmpty()) {
            return;
        }
        if (node.isExternal()) {
            return;
        }
        node2 = node.getChild1();
        node.setChild1(node.getChild2());
        node.setChild2(node2);
        this.adjustExtNode0();
        this.adjustReferencesInExtNodes();
    }

    public void orderAppearance(boolean bl) {
        if (this.isEmpty()) {
            return;
        }
        this.orderAppearanceHelper(this.getRoot(), bl);
        this.adjustExtNode0();
        this.adjustReferencesInExtNodes();
    }

    private void orderAppearanceHelper(Node node, boolean bl) {
        if (node.isExternal()) {
            return;
        }
        Node node2 = null;
        if (node.getChild1().getSumExtNodes() != node.getChild2().getSumExtNodes() && node.getChild1().getSumExtNodes() < node.getChild2().getSumExtNodes() == bl) {
            node2 = node.getChild1();
            node.setChild1(node.getChild2());
            node.setChild2(node2);
        }
        this.orderAppearanceHelper(node.getChild1(), bl);
        this.orderAppearanceHelper(node.getChild2(), bl);
    }

    public void setAllNodesToNotCollapse() {
        if (this.isEmpty()) {
            return;
        }
        this.setAllNodesToNotCollapseHelper(this.getRoot());
    }

    private void setAllNodesToNotCollapseHelper(Node node) {
        if (node.isExternal()) {
            return;
        }
        node.setCollapse(false);
        this.setAllNodesToNotCollapseHelper(node.getChild1());
        this.setAllNodesToNotCollapseHelper(node.getChild2());
    }

    public void collapseToDeepestAnotNodes() {
        if (this.isEmpty()) {
            return;
        }
        this.setAllNodesToNotCollapse();
        this.collapseToDeepestAnotNodesHelper(this.getRoot());
        this.adjustNodeCount(true);
        this.recalculateAndReset();
    }

    private void collapseToDeepestAnotNodesHelper(Node node) {
        if (node.isExternal()) {
            return;
        }
        if (!(node.isPseudoNode() || node.getSpecies().equals("") && node.getSeqName().equals(""))) {
            node.setCollapse(true);
            return;
        }
        this.collapseToDeepestAnotNodesHelper(node.getChild1());
        this.collapseToDeepestAnotNodesHelper(node.getChild2());
    }

    public void reRoot(int n) throws Exception {
        this.reRoot(this.getNode(n));
    }

    public void reRoot(Node node) throws Exception {
        Node node2 = node;
        Node node3 = null;
        Node node4 = null;
        Node node5 = null;
        Node node6 = null;
        double d = 0.0;
        double d2 = 0.0;
        float f = 0.0f;
        float f2 = 0.0f;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        int n2 = 0;
        if (this.isEmpty() || this.getNumberOfExtNodes() < 2) {
            return;
        }
        if (node2.isPseudoNode()) {
            throw new Exception("Tree: reRoot(Node): Can not place root on parent branch of pseudo node.");
        }
        this.setRooted(true);
        if (node2.isRoot()) {
            this.moveRootToMiddle();
            return;
        }
        if (node2.getParent().isRoot()) {
            if (this.getRoot().getChild1().isPseudoNode() || this.getRoot().getChild2().isPseudoNode()) {
                if (this.getRoot().getChild1() == node2 && this.getRoot().getChild2().isPseudoNode()) {
                    node3 = this.getRoot().getChild2();
                }
                if (this.getRoot().getChild2() == node2 && this.getRoot().getChild1().isPseudoNode()) {
                    node3 = this.getRoot().getChild1();
                }
                if (node2.getDistanceToParent() == -99.0) {
                    node3.setDistanceToParent(-99.0);
                } else {
                    double d3 = node2.getDistanceToParent() / 2.0;
                    node3.setDistanceToParent(d3);
                    node2.setDistanceToParent(d3);
                }
                node3.setLnLonParentBranch(node2.getLnLonParentBranch());
                node3.setSignificantlyWorse(node2.significantlyWorse());
                node3.setLnLonParentBranchAssigned(node2.isLnLonParentBranchAssigned());
                node3.setBootstrap(node2.getBootstrap());
            } else {
                this.moveRootToMiddle();
            }
            return;
        }
        node4 = node2.getParent();
        node5 = node4.getParent();
        node6 = new Node();
        if (node4.getChild2() == node2) {
            node6.setChild1(node2);
            node6.setChild2(node4);
        } else {
            node6.setChild1(node4);
            node6.setChild2(node2);
        }
        d = node5.getDistanceToParent();
        f = node5.getLnLonParentBranch();
        bl = node5.significantlyWorse();
        bl3 = node5.isLnLonParentBranchAssigned();
        n = node5.getBootstrap();
        node5.setDistanceToParent(node4.getDistanceToParent());
        node5.setLnLonParentBranch(node4.getLnLonParentBranch());
        node5.setLnLonParentBranchAssigned(node4.isLnLonParentBranchAssigned());
        node5.setSignificantlyWorse(node4.significantlyWorse());
        node5.setBootstrap(node4.getBootstrap());
        node4.setLnLonParentBranch(node2.getLnLonParentBranch());
        node4.setLnLonParentBranchAssigned(node2.isLnLonParentBranchAssigned());
        node4.setSignificantlyWorse(node2.significantlyWorse());
        node4.setBootstrap(node2.getBootstrap());
        if (node2.getDistanceToParent() == -99.0) {
            node4.setDistanceToParent(-99.0);
        } else {
            double d4 = node2.getDistanceToParent() / 2.0;
            node4.setDistanceToParent(d4);
            node2.setDistanceToParent(d4);
        }
        node2.setParent(node6);
        if (node4.getChild1() == node2) {
            node4.setChild1(node5);
        } else {
            node4.setChild2(node5);
        }
        node4.setParent(node6);
        while (!node5.isRoot()) {
            node2 = node4;
            node4 = node5;
            node5 = node5.getParent();
            if (node4.getChild1() == node2) {
                node4.setChild1(node5);
            } else {
                node4.setChild2(node5);
            }
            node4.setParent(node2);
            d2 = node5.getDistanceToParent();
            f2 = node5.getLnLonParentBranch();
            bl2 = node5.significantlyWorse();
            bl4 = node5.isLnLonParentBranchAssigned();
            n2 = node5.getBootstrap();
            node5.setDistanceToParent(d);
            node5.setLnLonParentBranch(f);
            node5.setSignificantlyWorse(bl);
            node5.setLnLonParentBranchAssigned(bl3);
            node5.setBootstrap(n);
            d = d2;
            f = f2;
            bl = bl2;
            bl3 = bl4;
            n = n2;
        }
        node3 = node5.getChild1() == node4 ? node5.getChild2() : node5.getChild1();
        node3.setParent(node4);
        if (node5.getDistanceToParent() == -100.0 && node3.getDistanceToParent() == -100.0) {
            node3.setDistanceToParent(-100.0);
        } else if (!(node5.getDistanceToParent() != -99.0 && node5.getDistanceToParent() != -100.0 || node3.getDistanceToParent() != -99.0 && node3.getDistanceToParent() != -100.0)) {
            node3.setDistanceToParent(-99.0);
        } else {
            node3.setDistanceToParent((node5.getDistanceToParent() >= 0.0 ? node5.getDistanceToParent() : 0.0) + (node3.getDistanceToParent() >= 0.0 ? node3.getDistanceToParent() : 0.0));
        }
        if (node5.getDistanceToParent() != -100.0) {
            node3.setLnLonParentBranch(node5.getLnLonParentBranch());
            node3.setSignificantlyWorse(node5.significantlyWorse());
            node3.setLnLonParentBranchAssigned(node5.isLnLonParentBranchAssigned());
        }
        node3.setBootstrap(node5.getBootstrap());
        if (node4.getChild1() != node5) {
            node4.setChild2(node3);
        } else {
            node4.setChild1(node3);
        }
        this.setRoot(node6);
        this.adjustExtNode0();
        this.adjustReferencesInExtNodes();
    }

    public void reRoot(Branch branch) throws Exception {
        Node node = branch.getNode1();
        Node node2 = branch.getNode2();
        if (node2 == node.getChild1() || node2 == node.getChild2()) {
            this.reRoot(node2);
        } else if (node == node2.getChild1() || node == node2.getChild2()) {
            this.reRoot(node);
        } else if (node.getParent() != null && node.getParent().isRoot() && (node.getParent().getChild1() == node2 || node.getParent().getChild2() == node2)) {
            this.reRoot(node);
        } else {
            throw new Exception("reRoot( Branch b ): b is not a branch.");
        }
    }

    public void reRootSkeleton(Node node) throws Exception {
        Node node2 = node;
        Node node3 = null;
        Node node4 = null;
        Node node5 = null;
        Node node6 = null;
        double d = 0.0;
        double d2 = 0.0;
        if (this.isEmpty() || this.getNumberOfExtNodes() < 2) {
            return;
        }
        this.setRooted(true);
        if (node2.isRoot() || node2.getParent().isRoot()) {
            this.moveRootToMiddle();
            return;
        }
        node4 = node2.getParent();
        node5 = node4.getParent();
        node6 = new Node();
        if (node4.getChild2() == node2) {
            node6.setChild1(node2);
            node6.setChild2(node4);
        } else {
            node6.setChild1(node4);
            node6.setChild2(node2);
        }
        d = node5.getDistanceToParent();
        node5.setDistanceToParent(node4.getDistanceToParent());
        if (node2.getDistanceToParent() == -99.0) {
            node4.setDistanceToParent(-99.0);
        } else {
            double d3 = node2.getDistanceToParent() / 2.0;
            node4.setDistanceToParent(d3);
            node2.setDistanceToParent(d3);
        }
        node2.setParent(node6);
        if (node4.getChild1() == node2) {
            node4.setChild1(node5);
        } else {
            node4.setChild2(node5);
        }
        node4.setParent(node6);
        while (!node5.isRoot()) {
            node2 = node4;
            node4 = node5;
            node5 = node5.getParent();
            if (node4.getChild1() == node2) {
                node4.setChild1(node5);
            } else {
                node4.setChild2(node5);
            }
            node4.setParent(node2);
            d2 = node5.getDistanceToParent();
            node5.setDistanceToParent(d);
            d = d2;
        }
        node3 = node5.getChild1() == node4 ? node5.getChild2() : node5.getChild1();
        node3.setParent(node4);
        if (node5.getDistanceToParent() == -99.0 && node3.getDistanceToParent() == -99.0) {
            node3.setDistanceToParent(-99.0);
        } else {
            node3.setDistanceToParent((node5.getDistanceToParent() >= 0.0 ? node5.getDistanceToParent() : 0.0) + (node3.getDistanceToParent() >= 0.0 ? node3.getDistanceToParent() : 0.0));
        }
        if (node4.getChild1() != node5) {
            node4.setChild2(node3);
        } else {
            node4.setChild1(node3);
        }
        this.setRoot(node6);
    }

    public void reRootSkeleton(Branch branch) throws Exception {
        Node node = branch.getNode1();
        Node node2 = branch.getNode2();
        if (node2 == node.getChild1() || node2 == node.getChild2()) {
            this.reRootSkeleton(node2);
        } else if (node == node2.getChild1() || node == node2.getChild2()) {
            this.reRootSkeleton(node);
        } else if (node.getParent() != null && node.getParent().isRoot() && (node.getParent().getChild1() == node2 || node.getParent().getChild2() == node2)) {
            this.reRootSkeleton(node);
        } else {
            throw new Exception("reRootSkeleton( Branch b ): b is not a branch.");
        }
    }

    private void moveRootToMiddle() {
        if (this.getRoot().getChild1() != null && this.getRoot().getChild2() != null) {
            double d = this.getRoot().getChild1().getDistanceToParent();
            double d2 = this.getRoot().getChild2().getDistanceToParent();
            double d3 = 0.0;
            if (d < 0.0) {
                d = 0.0;
            }
            if (d2 < 0.0) {
                d2 = 0.0;
            }
            d3 = (d + d2) / 2.0;
            this.getRoot().getChild1().setDistanceToParent(d3);
            this.getRoot().getChild2().setDistanceToParent(d3);
        }
    }

    public Vector getOrthologousNodes(Node node) {
        Node node2 = node;
        Node node3 = null;
        Vector vector = new Vector();
        if (!node2.isExternal() || this.isEmpty()) {
            return null;
        }
        while (!node2.isRoot()) {
            node3 = node2;
            if ((node2 = node2.getParent()).isDuplication()) continue;
            if (node2.getChild1() == node3) {
                this.addIntoVector(node2.getChild2().getAllExternalChildren(), vector);
                continue;
            }
            this.addIntoVector(node2.getChild1().getAllExternalChildren(), vector);
        }
        vector.trimToSize();
        return vector;
    }

    private void addIntoVector(Vector vector, Vector vector2) {
        for (int i = 0; i < vector.size(); ++i) {
            vector2.addElement(vector.elementAt(i));
        }
    }

    public Vector getSuperOrthologousNodes(Node node) {
        Node node2 = node;
        Node node3 = null;
        Vector<Node> vector = new Vector<Node>();
        if (!node2.isExternal() || this.isEmpty()) {
            return null;
        }
        while (!node2.isRoot() && !node2.getParent().isDuplication()) {
            node2 = node2.getParent();
        }
        node3 = node2;
        node3.setIndicatorsToZero();
        do {
            if (!node2.isExternal()) {
                if (node2.getIndicator() == 0) {
                    node2.setIndicator(1);
                    if (!node2.isDuplication()) {
                        node2 = node2.getChild1();
                    }
                }
                if (node2.getIndicator() == 1) {
                    node2.setIndicator(2);
                    if (!node2.isDuplication()) {
                        node2 = node2.getChild2();
                    }
                }
                if (node2 == node3 || node2.getIndicator() != 2) continue;
                node2 = node2.getParent();
                continue;
            }
            if (node2 != node) {
                vector.addElement(node2);
            }
            if (node2 != node3) {
                node2 = node2.getParent();
                continue;
            }
            node2.setIndicator(2);
        } while (node2 != node3 || node3.getIndicator() != 2);
        vector.trimToSize();
        return vector;
    }

    public Vector getUltraParalogousNodes(Node node) {
        Node node2 = node;
        Vector vector = new Vector();
        if (!node2.isExternal() || this.isEmpty()) {
            return null;
        }
        while (!node2.isRoot() && node2.getParent().isDuplication() && this.areAllChildrenDuplications(node2.getParent())) {
            node2 = node2.getParent();
        }
        vector = node2.getAllExternalChildren();
        vector.removeElement(node);
        vector.trimToSize();
        return vector;
    }

    public boolean areAllChildrenDuplications(Node node) {
        if (node.isExternal()) {
            return true;
        }
        if (node.isDuplication()) {
            return this.areAllChildrenDuplications(node.getChild1()) && this.areAllChildrenDuplications(node.getChild2());
        }
        return false;
    }

    public Vector getSubtreeNeighbors(Node node) {
        Node node2 = node;
        Vector vector = new Vector();
        if (!node2.isExternal() || this.isEmpty()) {
            return null;
        }
        if (!node2.isRoot()) {
            node2 = node2.getParent();
        }
        if (!node2.isRoot()) {
            node2 = node2.getParent();
        }
        vector = node2.getAllExternalChildren();
        vector.removeElement(node);
        vector.trimToSize();
        return vector;
    }

    public Node getNode(String string) throws Exception {
        Vector vector = this.getNodes(string);
        if (this.isEmpty()) {
            return null;
        }
        if (vector == null || vector.size() < 1) {
            throw new Exception(string + " not found");
        }
        if (vector.size() > 1) {
            throw new Exception(string + " not unique");
        }
        return (Node)vector.elementAt(0);
    }

    public Node getNode(int n) {
        if (this.isEmpty()) {
            return null;
        }
        if (this.idhash_ != null) {
            return (Node)this.idhash_.get(new Integer(n));
        }
        return this.getNodeHelper(this.getRoot(), n);
    }

    private Node getNodeHelper(Node node, int n) {
        if (node == null || node.getID() == n) {
            return node;
        }
        Node node2 = this.getNodeHelper(node.getChild1(), n);
        Node node3 = this.getNodeHelper(node.getChild2(), n);
        if (node2 != null) {
            return node2;
        }
        return node3;
    }

    public Vector find(String string, String string2, String string3, int n) throws Exception {
        Vector<Node> vector = new Vector<Node>();
        PreorderTreeIterator preorderTreeIterator = null;
        Node node = null;
        Node node2 = null;
        boolean bl = false;
        if (this.isEmpty()) {
            return null;
        }
        string = string.toLowerCase().trim();
        string2 = string2.toLowerCase().trim();
        string3 = string3.toLowerCase().trim();
        preorderTreeIterator = new PreorderTreeIterator(this);
        while (!preorderTreeIterator.isDone()) {
            node = preorderTreeIterator.currentNode();
            if (string != null && !string.equals("")) {
                if (node.getSeqName().toLowerCase().equals(string)) {
                    node2 = node;
                } else {
                    bl = true;
                }
            }
            if (!bl && string2 != null && !string2.equals("")) {
                if (node.getSpecies().toLowerCase().equals(string2)) {
                    node2 = node;
                } else {
                    bl = true;
                }
            }
            if (!bl && string3 != null && !string3.equals("")) {
                if (node.getECnumber().toLowerCase().equals(string3)) {
                    node2 = node;
                } else {
                    bl = true;
                }
            }
            if (!bl && n != -99) {
                if (node.getTaxonomyID() == n) {
                    node2 = node;
                } else {
                    bl = true;
                }
            }
            if (!bl) {
                vector.addElement(node2);
            }
            preorderTreeIterator.next();
        }
        vector.trimToSize();
        return vector;
    }

    public Vector findInNameSpecECid(String string) throws Exception {
        Vector<Node> vector = new Vector<Node>();
        PreorderTreeIterator preorderTreeIterator = null;
        Node node = null;
        if (this.isEmpty()) {
            return null;
        }
        if ((string = string.toLowerCase().trim()).equals("")) {
            return null;
        }
        preorderTreeIterator = new PreorderTreeIterator(this);
        while (!preorderTreeIterator.isDone()) {
            node = preorderTreeIterator.currentNode();
            if (node.getSeqName().toLowerCase().indexOf(string) >= 0) {
                vector.addElement(node);
            } else if (node.getSpecies().toLowerCase().indexOf(string) >= 0) {
                vector.addElement(node);
            } else if (node.getECnumber().toLowerCase().indexOf(string) >= 0) {
                vector.addElement(node);
            } else {
                String string2 = new Integer(node.getTaxonomyID()).toString();
                if (string2 != null && string2.equals(string)) {
                    vector.addElement(node);
                }
            }
            preorderTreeIterator.next();
        }
        vector.trimToSize();
        return vector;
    }

    public Vector getNodes(String string) throws Exception {
        Vector<Node> vector = new Vector<Node>();
        PreorderTreeIterator preorderTreeIterator = null;
        if (this.isEmpty()) {
            return null;
        }
        preorderTreeIterator = new PreorderTreeIterator(this);
        while (!preorderTreeIterator.isDone()) {
            if (preorderTreeIterator.currentNode().getSeqName().equals(string)) {
                vector.addElement(preorderTreeIterator.currentNode());
            }
            preorderTreeIterator.next();
        }
        vector.trimToSize();
        return vector;
    }

    public Vector getNodesWithMatchingSpecies(String string) throws Exception {
        Vector<Node> vector = new Vector<Node>();
        PreorderTreeIterator preorderTreeIterator = null;
        if (this.isEmpty()) {
            return null;
        }
        preorderTreeIterator = new PreorderTreeIterator(this);
        while (!preorderTreeIterator.isDone()) {
            if (preorderTreeIterator.currentNode().getSpecies().equals(string)) {
                vector.addElement(preorderTreeIterator.currentNode());
            }
            preorderTreeIterator.next();
        }
        vector.trimToSize();
        return vector;
    }

    public String[] getAllExternalSeqNames() {
        int n = 0;
        if (this.isEmpty()) {
            return null;
        }
        String[] stringArray = new String[this.getNumberOfExtNodes()];
        for (Node node = this.getExtNode0(); node != null; node = node.getNextExtNode()) {
            stringArray[n++] = new String(node.getSeqName());
        }
        return stringArray;
    }

    public double calculateRealHeight() {
        Node node = null;
        Node node2 = null;
        Node node3 = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        if (this.isEmpty()) {
            this.setRealHeight(0.0);
            return 0.0;
        }
        node = this.getRoot();
        node2 = node.getChild1();
        node3 = node.getChild2();
        if (this.isRooted() && (d = node.getDistanceToParent()) < 0.0) {
            d = 0.0;
        }
        if (node2 != null && node3 != null) {
            d3 = this.calculateRealHeightHelper(node2);
            d4 = this.calculateRealHeightHelper(node3);
            d5 = d3 - d4;
            d2 = d3 > d4 ? d3 : d4;
        }
        this.setRealHeight(d2 + d);
        return d5;
    }

    private double calculateRealHeightHelper(Node node) {
        if (node == null) {
            return 0.0;
        }
        if (node.collapse()) {
            double d = node.getDistanceToParent();
            if (d < 0.0) {
                d = 0.0;
            }
            return d;
        }
        double d = this.calculateRealHeightHelper(node.getChild1());
        double d2 = this.calculateRealHeightHelper(node.getChild2());
        double d3 = node.getDistanceToParent();
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        return d3 + (d > d2 ? d : d2);
    }

    public void findExtremeLnL() {
        if (this.isEmpty()) {
            return;
        }
        this.lowest_lnL_ = Double.MAX_VALUE;
        this.highest_lnL_ = -1.7976931348623157E308;
        this.findExtremeLnLHelper(this.getRoot());
    }

    private void findExtremeLnLHelper(Node node) {
        if (node == null) {
            return;
        }
        if (node.isLnLonParentBranchAssigned() && !node.isPseudoNode()) {
            if ((double)node.getLnLonParentBranch() > this.highest_lnL_) {
                this.highest_lnL_ = node.getLnLonParentBranch();
            }
            if ((double)node.getLnLonParentBranch() < this.lowest_lnL_) {
                this.lowest_lnL_ = node.getLnLonParentBranch();
            }
        }
        this.findExtremeLnLHelper(node.getChild1());
        this.findExtremeLnLHelper(node.getChild2());
    }

    public void copyBranchLengthValuesFrom(Tree tree) throws Exception {
        Node node;
        Node node2;
        Node node3 = null;
        Node node4 = null;
        Node node5 = null;
        Node[] nodeArray = null;
        Node[] nodeArray2 = null;
        int n = 0;
        if (this.isEmpty() || tree.isEmpty()) {
            return;
        }
        this.setIndicatorsToZero();
        tree.setIndicatorsToZero();
        for (node2 = this.getExtNode0(); node2 != null; node2 = node2.getNextExtNode()) {
            for (node = node2; node != null; node = node.getParent()) {
                if (node.isExternal()) continue;
                node.setDistanceToParent(0.0);
            }
        }
        for (node2 = tree.getExtNode0(); node2 != null; node2 = node2.getNextExtNode()) {
            for (node = node2; node != null; node = node.getParent()) {
                if (node.getIndicator() != 0 || node.isPseudoNode()) continue;
                node.setIndicator(1);
                nodeArray2 = node.copyAllExtChildren();
                node3 = nodeArray2[0];
                ++n;
                for (node5 = this.getExtNode0(); node5 != null; node5 = node5.getNextExtNode()) {
                    if (!node3.equals(node5)) continue;
                    for (node4 = node5; node4 != null; node4 = node4.getParent()) {
                        if (node4.getIndicator() == n || node4.getIndicator() == -1) continue;
                        node4.setIndicator(n);
                        if (nodeArray2.length != node4.getSumExtNodes()) continue;
                        nodeArray = node4.copyAllExtChildren();
                        if (Node.compareArraysOfNodes(nodeArray2, nodeArray)) {
                            node4.setIndicator(-1);
                            node4.setDistanceToParent(node.getDistanceToParent());
                            continue;
                        }
                        String string = "Trees were ";
                        string = string + "not identical.";
                        throw new Exception(string);
                    }
                }
            }
        }
        if (!tree.isRooted()) {
            this.setRooted(false);
        } else {
            this.setRooted(true);
        }
        this.recalculateAndReset();
        this.reassignIDs();
    }

    public void moveBranchLenghtsToBootstrap() {
        Node node = null;
        Node node2 = null;
        if (this.isEmpty()) {
            return;
        }
        this.setIndicatorsToZero();
        for (node = this.getExtNode0(); node != null; node = node.getNextExtNode()) {
            for (node2 = node; node2 != null; node2 = node2.getParent()) {
                if (node2.getIndicator() != 0) continue;
                if (node2.getDistanceToParent() > 0.0) {
                    if (!node2.isExternal()) {
                        node2.setBootstrap((int)node2.getDistanceToParent());
                    }
                    node2.setDistanceToParent(-99.0);
                } else {
                    node2.setBootstrap(-99);
                }
                node2.setIndicator(1);
            }
        }
        this.recalculateAndReset();
    }

    public boolean isEmpty() {
        return this.getExtNode0() == null;
    }

    public boolean isCompletelyBinary() {
        if (this.isEmpty()) {
            return false;
        }
        return this.isCompletelyBinaryHelper(this.getRoot());
    }

    private boolean isCompletelyBinaryHelper(Node node) {
        if (node == null) {
            return true;
        }
        if (node.isPseudoNode()) {
            return false;
        }
        boolean bl = this.isCompletelyBinaryHelper(node.getChild1());
        boolean bl2 = this.isCompletelyBinaryHelper(node.getChild2());
        return bl && bl2;
    }

    public boolean areBranchLenghtsBootstraps() {
        Node node = null;
        double d = 0.0;
        double d2 = 0.0;
        if (this.isEmpty()) {
            return false;
        }
        if (this.getNumberOfExtNodes() <= 1) {
            return false;
        }
        if (this.getRoot().getBootstrap() != -99) {
            return false;
        }
        node = this.getExtNode0();
        while (node != null) {
            d = node.getDistanceToParent();
            if (d <= 0.0 || d % 10.0 != 0.0) {
                return false;
            }
            if ((node = node.getNextExtNode()) == null) continue;
            d2 = node.getDistanceToParent();
            if (d2 <= 0.0 || d2 % 10.0 != 0.0) {
                return false;
            }
            if (d == d2) continue;
            return false;
        }
        return true;
    }

    public void levelOrderReID(int n) {
        this.idhash_ = null;
        this.levelOrderReIDHelper(this.getRoot(), n);
    }

    private void levelOrderReIDHelper(Node node, int n) {
        node.setID(n);
        ++n;
        if (node.getChild1() != null) {
            this.levelOrderReIDHelper(node.getChild1(), n);
        }
        if (node.getChild2() != null) {
            this.levelOrderReIDHelper(node.getChild2(), n);
        }
    }

    public int preorderReID(int n) {
        Stack<Node> stack = null;
        Node node = null;
        if (this.isEmpty()) {
            return n;
        }
        stack = new Stack<Node>();
        node = this.getRoot();
        stack.push(node);
        while (!stack.empty()) {
            node = (Node)stack.pop();
            node.setID(n++);
            if (node.getChild2() != null) {
                stack.push(node.getChild2());
            }
            if (node.getChild1() == null) continue;
            stack.push(node.getChild1());
        }
        this.idhash_ = null;
        return n;
    }

    public Node getRoot() {
        return this.root_;
    }

    void setRoot(Node node) {
        this.root_ = node;
    }

    public boolean isRooted() {
        return this.rooted_;
    }

    public void setRooted(boolean bl) {
        this.rooted_ = bl;
    }

    private void setHighestLnL(double d) {
        this.highest_lnL_ = d;
    }

    public double getHighestLnL() {
        return this.highest_lnL_;
    }

    private void setLowestLnL(double d) {
        this.lowest_lnL_ = d;
    }

    public double getLowestLnL() {
        return this.lowest_lnL_;
    }

    public double getRealHeight() {
        return this.real_height_;
    }

    public void setRealHeight(double d) {
        this.real_height_ = d;
    }

    public int getNumberOfDuplications() {
        return this.number_of_duplications_;
    }

    public void setNumberOfDuplications(int n) {
        this.number_of_duplications_ = n < 0 ? -1 : n;
    }

    public Node getExtNode0() {
        return this.ext_node0_;
    }

    private void setExtNode0(Node node) {
        this.ext_node0_ = node;
    }

    public int getNumberOfExtNodes() {
        return this.external_nodes_;
    }

    public void setExtNodes(int n) {
        this.external_nodes_ = n;
    }

    private boolean allowMoreThanBinaryNodesInNHoutput() {
        return this.more_than_bin_nodes_in_NH_;
    }

    public void allowMoreThanBinaryNodesInNHoutput(boolean bl) {
        this.more_than_bin_nodes_in_NH_ = bl;
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String string) {
        this.name_ = string;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        return this.toNewHampshireX();
    }

    public String toNewHampshire(boolean bl) {
        int n = 0;
        String string = "";
        String string2 = "";
        Stack<String> stack = null;
        Stack stack2 = null;
        Node node = null;
        if (this.isEmpty()) {
            return "";
        }
        stack = new Stack<String>();
        stack2 = new Stack();
        node = this.getRoot();
        this.adjustNodeCount(false);
        this.setIndicatorsToZero();
        do {
            if (!node.isExternal()) {
                if (node.getIndicator() == 0) {
                    node.setIndicator(1);
                    node = node.getChild1();
                }
                if (node.getIndicator() == 1) {
                    node.setIndicator(2);
                    node = node.getChild2();
                }
                if (node.getIndicator() != 2) continue;
                if (!(node.isPseudoNode() && (this.allowMoreThanBinaryNodesInNHoutput() || node.getParent().isRoot() || node.getParent().getChild1().isPseudoNode() && node.getParent().getChild2().isPseudoNode() && node.getParent().getChild1() != node))) {
                    n = 0;
                    while (n < 2 * node.getSumExtNodes() - 2) {
                        stack2.push(stack.pop());
                        if (stack2.peek().toString().equals("(") || stack2.peek().toString().equals(")")) continue;
                        ++n;
                    }
                    stack.push("(");
                    while (!stack2.empty()) {
                        stack.push((String)stack2.pop());
                    }
                    stack.push(")");
                }
                string = node.getDistanceToParent() >= 0.0 && !node.isPseudoNode() ? ":" + node.getDistanceToParent() + "," : (node.isPseudoNode() && !this.allowMoreThanBinaryNodesInNHoutput() && !node.getParent().isRoot() && (!node.getParent().getChild1().isPseudoNode() || !node.getParent().getChild2().isPseudoNode() || node.getParent().getChild1() == node) ? ":0.0," : ",");
                stack.push(string);
                node = node.getParent();
                continue;
            }
            if (bl && !node.getSeqName().equals("")) {
                String string3 = node.getSeqName();
                try {
                    if (string3.length() > 10) {
                        string3 = string3.substring(0, 11);
                    }
                    if (string3.indexOf(47) > 0) {
                        string3 = string3.substring(0, string3.indexOf(47));
                    }
                }
                catch (Exception exception) {
                    System.err.println("\ntoNewHampshire()Unexpected Exception.\n");
                }
                string = "," + string3;
            } else {
                string = !bl && !node.getSeqName().equals("") ? "," + node.getSeqName() : (!bl && !node.getSpecies().equals("") ? "," + node.getSpecies() : (!bl && !node.getECnumber().equals("") ? "," + node.getECnumber() : ",\t"));
            }
            if (node.getDistanceToParent() >= 0.0) {
                string = string + ":" + node.getDistanceToParent();
            }
            stack.push(string);
            if (!node.isRoot()) {
                node = node.getParent();
                continue;
            }
            node.setIndicator(2);
        } while (!node.isRoot() || node.getIndicator() != 2);
        while (!stack.empty()) {
            stack2.push(stack.pop());
        }
        string2 = this.stackToString(stack2);
        this.adjustNodeCount(true);
        if (string2.indexOf("(") == -1) {
            return "";
        }
        return string2;
    }

    public String toNewHampshireX() {
        int n = 0;
        String string = "";
        String string2 = "";
        Stack<String> stack = null;
        Stack stack2 = null;
        Node node = null;
        if (this.isEmpty()) {
            return "";
        }
        stack = new Stack<String>();
        stack2 = new Stack();
        node = this.getRoot();
        this.adjustNodeCount(false);
        this.setIndicatorsToZero();
        do {
            if (!node.isExternal()) {
                if (node.getIndicator() == 0) {
                    node.setIndicator(1);
                    node = node.getChild1();
                }
                if (node.getIndicator() == 1) {
                    node.setIndicator(2);
                    node = node.getChild2();
                }
                if (node.getIndicator() != 2) continue;
                if (!(node.isPseudoNode() && (this.allowMoreThanBinaryNodesInNHoutput() || node.getParent().isRoot() || node.getParent().getChild1().isPseudoNode() && node.getParent().getChild2().isPseudoNode() && node.getParent().getChild1() != node))) {
                    n = 0;
                    while (n < 2 * node.getSumExtNodes() - 2) {
                        stack2.push(stack.pop());
                        if (stack2.peek().toString().equals("(") || stack2.peek().toString().equals(")")) continue;
                        ++n;
                    }
                    stack.push("(");
                    while (!stack2.empty()) {
                        stack.push((String)stack2.pop());
                    }
                    stack.push(")");
                }
                string = "";
                if (!node.isPseudoNode()) {
                    string = node.toNewHampshireX();
                } else if (!(!node.isPseudoNode() || this.allowMoreThanBinaryNodesInNHoutput() || node.getParent().isRoot() || node.getParent().getChild1().isPseudoNode() && node.getParent().getChild2().isPseudoNode() && node.getParent().getChild1() != node)) {
                    string = ":0.0";
                }
                if (string.length() >= 1) {
                    string = string + ",";
                }
                stack.push(string);
                node = node.getParent();
                continue;
            }
            string = ",";
            string = string + node.toNewHampshireX();
            stack.push(string);
            if (!node.isRoot()) {
                node = node.getParent();
                continue;
            }
            node.setIndicator(2);
        } while (!node.isRoot() || node.getIndicator() != 2);
        while (!stack.empty()) {
            stack2.push(stack.pop());
        }
        string2 = this.stackToString(stack2);
        if (!(this.getNumberOfExtNodes() < 2 || this.root_.getSeqName().equals("") && this.root_.getDistanceToParent() == 0.0 && this.root_.getSpecies().equals("") && this.root_.getECnumber().equals("") && !this.root_.isLnLonParentBranchAssigned() && !this.root_.isDuplicationOrSpecAssigned() && this.root_.getBootstrap() == 0)) {
            string2 = string2.substring(0, string2.length() - 1);
            string2 = string2 + node.toNewHampshireX();
            string2 = string2 + ";";
        }
        this.adjustNodeCount(true);
        return string2;
    }

    private String stackToString(Stack stack) {
        int n = 0;
        String string = "";
        StringBuffer stringBuffer = new StringBuffer(10000);
        if (this.getNumberOfExtNodes() >= 2) {
            stringBuffer.append("(");
        } else {
            stringBuffer.append("");
        }
        while (!stack.empty()) {
            string = stack.pop().toString();
            if (string.startsWith("(") && stringBuffer.charAt(stringBuffer.length() - 1) == ')') {
                stringBuffer.append(",");
                stringBuffer.append(string);
                continue;
            }
            if (string.startsWith("(") && stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) != '(' && stringBuffer.charAt(stringBuffer.length() - 1) != ',') {
                stringBuffer.append(",");
                stringBuffer.append(string);
                continue;
            }
            if (string.startsWith(",") && stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == '(') {
                stringBuffer.append(string.substring(1));
                continue;
            }
            if (string.startsWith(")") && stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == ',') {
                stringBuffer = new StringBuffer(stringBuffer.toString().substring(0, stringBuffer.length() - 1));
                stringBuffer.append(string);
                continue;
            }
            if (string.startsWith(",") && stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == ',') {
                stringBuffer.append(string.substring(1));
                continue;
            }
            stringBuffer.append(string);
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) == ',') {
            stringBuffer = new StringBuffer(stringBuffer.toString().substring(0, stringBuffer.length() - 1));
        }
        if (this.getNumberOfExtNodes() >= 2) {
            stringBuffer.append(");");
        } else {
            stringBuffer.append(";");
        }
        if (stringBuffer.charAt(0) == ',') {
            stringBuffer = new StringBuffer(stringBuffer.toString().substring(1));
        }
        for (n = 0; n <= stringBuffer.length() - 1; ++n) {
            if (stringBuffer.charAt(n) != '\t') continue;
            stringBuffer = new StringBuffer(stringBuffer.toString().substring(0, n) + stringBuffer.toString().substring(n + 1));
            --n;
        }
        return stringBuffer.toString();
    }

    public void printExtNodes() {
        if (this.isEmpty()) {
            return;
        }
        for (Node node = this.getExtNode0(); node != null; node = node.getNextExtNode()) {
            System.out.println(node + "\n");
        }
    }

    public void printAllNodes() {
        if (this.isEmpty()) {
            return;
        }
        this.getRoot().preorderPrint();
    }

    public void setIndicatorsToZero() {
        if (this.isEmpty()) {
            return;
        }
        this.getRoot().setIndicatorsToZero();
    }

    public void hashIDs() {
        this.idhash_ = null;
        Stack<Node> stack = null;
        Node node = null;
        if (this.isEmpty()) {
            return;
        }
        this.idhash_ = new Hashtable();
        stack = new Stack<Node>();
        node = this.getRoot();
        stack.push(node);
        while (!stack.empty()) {
            node = (Node)stack.pop();
            this.idhash_.put(new Integer(node.getID()), node);
            if (node.getChild1() != null) {
                stack.push(node.getChild1());
            }
            if (node.getChild2() == null) continue;
            stack.push(node.getChild2());
        }
    }

    public void recalculateAndReset() {
        if (this.isEmpty()) {
            return;
        }
        this.findExtremeLnL();
        this.calculateRealHeight();
        this.setExtNodes(this.getRoot().getSumExtNodes());
    }

    public void adjustNodeCount(boolean bl) {
        Node node = null;
        Node node2 = null;
        if (this.isEmpty()) {
            return;
        }
        this.adjustNodeCountHelper(this.getRoot());
        node2 = this.getExtNode0();
        block0: do {
            node = node2;
            do {
                if (bl && node.collapse()) {
                    if (node.getIndicator() != 1) {
                        node.setIndicator(1);
                    } else {
                        node2 = node2.getNextExtNode();
                        continue block0;
                    }
                }
                node.setSumExtNodes(node.getSumExtNodes() + 1);
            } while ((node = node.getParent()) != null);
            node2 = node2.getNextExtNode();
        } while (node2 != null);
    }

    private void adjustNodeCountHelper(Node node) {
        if (node == null) {
            return;
        }
        node.setSumExtNodes(0);
        node.setIndicator(0);
        this.adjustNodeCountHelper(node.getChild1());
        this.adjustNodeCountHelper(node.getChild2());
    }

    private void reassignIDs() {
        PreorderTreeIterator preorderTreeIterator = null;
        if (this.isEmpty()) {
            return;
        }
        try {
            preorderTreeIterator = new PreorderTreeIterator(this);
        }
        catch (Exception exception) {
            System.err.println("Unexpected failure: Could not create Iterator.");
            exception.printStackTrace();
            System.exit(-1);
        }
        while (!preorderTreeIterator.isDone()) {
            Node.setNodeCount(Node.getNodeCount() + 1);
            preorderTreeIterator.currentNode().setID(Node.getNodeCount());
            preorderTreeIterator.next();
        }
        this.idhash_ = null;
    }

    private void adjustReferencesInExtNodes() {
        Node node = null;
        Node node2 = null;
        if (this.isEmpty()) {
            return;
        }
        this.getRoot().setIndicatorsToZero();
        node = this.getRoot();
        if (this.getNumberOfExtNodes() <= 1) {
            return;
        }
        do {
            if (node.getIndicator() == 0 && !node.isExternal()) {
                node.setIndicator(1);
                node = node.getChild1();
            }
            if (node.getIndicator() == 1 && !node.isExternal()) {
                node.setIndicator(2);
                node = node.getChild2();
            }
            if (node.isExternal()) {
                node.setNextExtNode(null);
                node.setPrevExtNode(node2);
                if (node2 != null) {
                    node2.setNextExtNode(node);
                }
                node2 = node;
                node.setIndicator(2);
            }
            if (node.getIndicator() != 2) continue;
            node = node.getParent();
        } while (!node.isRoot() || node.getIndicator() != 2);
    }

    private void adjustExtNode0() {
        Node node = this.getRoot();
        if (node == null) {
            return;
        }
        while (!node.isExternal()) {
            node = node.getChild1();
        }
        this.setExtNode0(node);
    }

    void addNodeAndConnect(String string, String string2) throws Exception {
        if (this.getExtNode0() == null) {
            System.err.println("addNodeAndConnect( String, String ): Error: Cannot add and connect one node to empty tree.");
            System.exit(-1);
        }
        this.getExtNode0().addExtNode(string);
        this.getExtNode0().connect(string2);
        ++this.external_nodes_;
    }

    private void addNode(String string) throws Exception {
        if (this.getExtNode0() == null) {
            this.setExtNode0(new Node(string));
        } else {
            this.getExtNode0().addExtNode(string);
        }
        ++this.external_nodes_;
    }

    private void connectInternal(String string) throws Exception {
        if (this.isEmpty()) {
            return;
        }
        this.getExtNode0().connect(string);
    }
}

