/*
 * Decompiled with CFR 0.152.
 */
package forester.tree;

import forester.tree.Iterator;
import forester.tree.Node;
import forester.tree.StackItem;
import forester.tree.Tree;
import java.util.Stack;

public class PreorderTreeIterator
implements Iterator {
    private Tree tree;
    private Node node;
    private StackItem si;
    private boolean is_done;
    private Stack stack;

    public PreorderTreeIterator(Tree tree) throws Exception {
        if (tree.isEmpty()) {
            String string = "PreorderTreeIterator: Tree is empty.";
            throw new Exception(string);
        }
        this.tree = tree;
        this.first();
    }

    public void first() {
        this.is_done = false;
        this.node = null;
        this.stack = new Stack();
        this.stack.push(new StackItem(this.tree.getRoot(), 1));
        this.next();
    }

    public void next() {
        if (this.node != null && this.node.isExternal() && this.node.getNextExtNode() == null) {
            this.is_done = true;
            return;
        }
        while (true) {
            StackItem stackItem;
            if ((stackItem = (StackItem)this.stack.pop()).getNode() == null) {
                continue;
            }
            switch (stackItem.getPhase()) {
                case 1: {
                    this.stack.push(new StackItem(stackItem.getNode(), 2));
                    this.node = stackItem.getNode();
                    return;
                }
                case 2: {
                    this.stack.push(new StackItem(stackItem.getNode(), 3));
                    this.stack.push(new StackItem(stackItem.getNode().getChild1(), 1));
                    break;
                }
                case 3: {
                    this.stack.push(new StackItem(stackItem.getNode().getChild2(), 1));
                }
            }
        }
    }

    public boolean isDone() {
        return this.is_done;
    }

    public Node currentNode() {
        if (this.is_done) {
            return null;
        }
        return this.node;
    }
}

