/*
 * Decompiled with CFR 0.152.
 */
package forester.tools;

import forester.datastructures.BasketDataStructure;
import forester.tools.SDI;
import forester.tree.Node;
import forester.tree.Tree;
import java.util.HashMap;
import java.util.Vector;

public class OE
extends SDI {
    private BasketDataStructure b;

    public OE(Tree tree, Tree tree2) throws Exception {
        super(tree, tree2);
    }

    public int infer(boolean bl) throws Exception {
        this.setDuplicationsToZero();
        if (bl) {
            OE.stripTree(this.getGeneTree(), this.getSpeciesTree());
        }
        int n = this.getSpeciesTree().preorderReID(0);
        this.getGeneTree().preorderReID(n);
        this.getSpeciesTree().hashIDs();
        this.getGeneTree().setIndicatorsToZero();
        this.linkExtNodesOfS();
        this.b = new BasketDataStructure(this.getGeneTree().getNumberOfExtNodes() * 2 + this.getSpeciesTree().getNumberOfExtNodes() * 2 - 2);
        this.DFS(this.getSpeciesTree().getRoot());
        this.determine(this.getGeneTree().getRoot());
        return this.getDuplications();
    }

    public int computeMappingCost() throws Exception {
        this.linkExtNodesOfG();
        return super.computeMappingCost();
    }

    void DFS(Node node) {
        Vector vector = null;
        if (!node.isExternal()) {
            this.DFS(node.getChild1());
            this.b.moveBasket(node.getChild1().getID(), node.getID());
            this.DFS(node.getChild2());
            this.b.mergeBasket(node.getChild2().getID(), node.getID());
        } else {
            vector = node.getVector();
            for (int i = 0; i < vector.size(); ++i) {
                Node node2 = (Node)vector.elementAt(i);
                this.b.createBasket(node2.getID(), node.getID());
                this.geneTreeWalk(node2);
            }
        }
    }

    private void geneTreeWalk(Node node) {
        while (!node.isRoot() && node.getParent().getIndicator() == 1) {
            int n;
            int n2 = this.b.findBasket((node = node.getParent()).getChild1().getID());
            if (n2 < (n = this.b.findBasket(node.getChild2().getID()))) {
                node.setLink(this.getSpeciesTree().getNode(n2));
            } else {
                node.setLink(this.getSpeciesTree().getNode(n));
            }
            this.b.insertIntoBasket(node.getID(), node.getLink().getID());
        }
        if (!node.isRoot()) {
            node.getParent().setIndicator(1);
        }
    }

    void linkExtNodesOfS() throws Exception {
        Node node = this.getSpeciesTree().getExtNode0();
        String string = null;
        Vector<Node> vector = null;
        HashMap hashMap = new HashMap();
        for (Node node2 = this.getGeneTree().getExtNode0(); node2 != null; node2 = node2.getNextExtNode()) {
            string = node2.getSpecies();
            if (!hashMap.containsKey(string)) {
                vector = new Vector<Node>();
                vector.addElement(node2);
                hashMap.put(string, vector);
                continue;
            }
            ((Vector)hashMap.get(string)).addElement(node2);
        }
        while (node != null) {
            vector = (Vector<Node>)hashMap.get(node.getSpecies());
            if (vector == null) {
                String string2 = "SDI: species \"" + node.getSpecies();
                string2 = string2 + "\" not present in Tree genetree.";
                throw new Exception(string2);
            }
            node.setVector(vector);
            node = node.getNextExtNode();
        }
    }

    void determine(Node node) {
        if (!node.isExternal()) {
            this.determine(node.getChild1());
            this.determine(node.getChild2());
            node.setDuplicationOrSpecAssigned(true);
            if (node.getChild1().isExternal() && node.getChild2().isExternal() && node.getChild1().getSpecies().equals(node.getChild2().getSpecies())) {
                node.setDuplication(true);
                this.increaseDuplications();
            } else if (node.getLink() == node.getChild1().getLink() || node.getLink() == node.getChild2().getLink()) {
                node.setDuplication(true);
                this.increaseDuplications();
            } else {
                node.setDuplication(false);
            }
        }
    }
}

