function varargout = manualAnalyse(varargin)
% MANUALANALYSE M-file for manualAnalyse.fig
%      MANUALANALYSE, by itself, creates a new MANUALANALYSE or raises the existing
%      singleton*.
%
%      H = MANUALANALYSE returns the handle to a new MANUALANALYSE or the handle to
%      the existing singleton*.
%
%      MANUALANALYSE('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in MANUALANALYSE.M with the given input arguments.
%
%      MANUALANALYSE('Property','Value',...) creates a new MANUALANALYSE or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before manualAnalyse_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to manualAnalyse_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help manualAnalyse

% Last Modified by GUIDE v2.5 18-Dec-2007 11:53:04

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @manualAnalyse_OpeningFcn, ...
                   'gui_OutputFcn',  @manualAnalyse_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before manualAnalyse is made visible.
function manualAnalyse_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to manualAnalyse (see VARARGIN)

% Choose default command line output for manualAnalyse
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes manualAnalyse wait for user response (see UIRESUME)
% uiwait(handles.figure1);


%%%ADDED GLOBAL VARIABLES%%%
global StrSavePath;   % in 1
global filesManual;   % in 1
global resultManual;  % in 1
global amountFiles;
global i;
global cellImage;
global validFiles;
%%%%%%%%%%%

set(handles.figure1,'WindowStyle','modal');

cellImage = zeros(200,100);

set(handles.savePath,'String', StrSavePath);

filesManual = dir(StrSavePath);

amountFiles = size((filesManual),1);

amountCells = amountFiles-2;

validFiles =  [];

%check the file names . and .. should not be considered
for j = 1:amountFiles
    if size(filesManual(j).name,2)  > 5 
        validFiles = [validFiles j];
    end %if1
end %for1

set(handles.amountFiles, 'String', num2str(amountCells));

% 1=invalid 2 = cyto 3 = golgi 4 = membran 5 = golgi strong
resultManual = ones(amountFiles, 1);
 
if amountFiles > 2
    %analyse can start
    
    i = 1;
else
    %no analyse possible
    set(handles.buttonAllInvalid,'Visible','off');
    set(handles.buttonStart,'Visible','off');

    set(handles.buttonClose,'Visible','on');
    i = 1;
end

% --- Outputs from this function are returned to the command line.
function varargout = manualAnalyse_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

% --- Executes on button press in buttonClose.
function buttonClose_Callback(hObject, eventdata, handles) %done
% hObject    handle to buttonClose (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


%uiresume(gcbf);
    
close(handles.figure1);


function savePath_Callback(hObject, eventdata, handles) %done
% hObject    handle to savePath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of savePath as text
%        str2double(get(hObject,'String')) returns contents of savePath as a double


% --- Executes during object creation, after setting all properties.
function savePath_CreateFcn(hObject, eventdata, handles)
% hObject    handle to savePath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function amountFiles_Callback(hObject, eventdata, handles) %done
% hObject    handle to amountFiles (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of amountFiles as text
%        str2double(get(hObject,'String')) returns contents of amountFiles as a double


% --- Executes during object creation, after setting all properties.
function amountFiles_CreateFcn(hObject, eventdata, handles)
% hObject    handle to amountFiles (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in buttonStart.
function buttonStart_Callback(hObject, eventdata, handles)
% hObject    handle to buttonStart (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


%start analyses
global StrSavePath;   
global filesManual;   
global i;
global amountFiles;
global cellImage;
global validFiles;

set(handles.buttonAllInvalid,'Visible','off');
set(handles.buttonStart,'Visible','off');

%no rating, only start everything

%visibility
set(handles.CellImage,'Visible','on');
set(handles.text4,'Visible','on');
set(handles.cellNumber,'Visible','on');
set(handles.fileName,'Visible','on');
set(handles.checkCyto,'Visible','on');
set(handles.checkGolgi,'Visible','on');
set(handles.checkGolgiStr,'Visible','on');
set(handles.checkMem,'Visible','on');
set(handles.checkInvalid,'Visible','on');
set(handles.buttonRestInvalid,'Visible','on');

%values
set(handles.cellNumber, 'String', num2str(i));

set(handles.fileName, 'String', filesManual(validFiles(i)).name);

loadFile = strcat(StrSavePath, '\', filesManual(validFiles(i)).name);
fid2 = fopen(loadFile,'r');
fileSize = [100,200];
cellImage = fread(fid2, fileSize, 'double');
fclose(fid2);

axes(handles.CellImage);

imagesc(cellImage);
colormap(gray);

set(handles.checkInvalid, 'Value', 1);
set(handles.checkMem, 'Value', 0);
set(handles.checkGolgi, 'Value', 0);
set(handles.checkGolgiStr, 'Value', 0);
set(handles.checkCyto, 'Value', 0);

set(handles.buttonNext,'Visible','on');


% --- Executes on button press in buttonAllInvalid.
function buttonAllInvalid_Callback(hObject, eventdata, handles)  %done
% hObject    handle to buttonAllInvalid (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%set all files invalid and stop further manual analyses
set(handles.buttonClose,'Visible','on');
set(handles.buttonAllInvalid,'Visible','off');
set(handles.buttonStart,'Visible','off');

% --- Executes on button press in buttonNext.
function buttonNext_Callback(hObject, eventdata, handles)  %done
% hObject    handle to buttonNext (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global StrSavePath;   % in 1
global filesManual;   % in 1
global i;
global amountFiles;
global resultManual;  % in 1
global cellImage;
global validFiles;

%save result for last analyses

Inval    = get(handles.checkInvalid, 'Value');
Mem      = get(handles.checkMem, 'Value');
Golgi    = get(handles.checkGolgi, 'Value');
GolgiStr = get(handles.checkGolgiStr, 'Value');
Cyto     = get(handles.checkCyto, 'Value'); 

if Inval == 1
    resultManual(validFiles(i)) = 1;
elseif Mem ==1
    resultManual(validFiles(i)) = 4;
elseif Golgi ==1
    resultManual(validFiles(i)) = 3;
elseif GolgiStr ==1
    resultManual(validFiles(i)) = 5;
elseif Cyto ==1
    resultManual(validFiles(i)) = 2;
else
    resultManual(validFiles(i)) = 1;  %fehler -> invalid
end

%ende
i = i+1;

if i > amountFiles-2  %stop analyses
    
    %close on
    set(handles.buttonClose,'Visible','on');
    
    %rest off
    set(handles.CellImage,'Visible','off');
    set(handles.text4,'Visible','off');
    set(handles.fileName,'Visible','off');
    set(handles.checkCyto,'Visible','off');
    set(handles.checkGolgi,'Visible','off');
    set(handles.checkGolgiStr,'Visible','off');
    set(handles.checkMem,'Visible','off');
    set(handles.checkInvalid,'Visible','off');
    set(handles.buttonRestInvalid,'Visible','off');
    set(handles.buttonNext,'Visible','off');

else %load new data
    set(handles.cellNumber, 'String', num2str(i));

    set(handles.fileName, 'String', filesManual(validFiles(i)).name);

    loadFile = strcat(StrSavePath, '\', filesManual(validFiles(i)).name);
    fid2 = fopen(loadFile,'r');
    fileSize = [100,200];
    cellImage = fread(fid2, fileSize, 'double');
    fclose(fid2);

    axes(handles.CellImage);

    imagesc(cellImage);
    colormap(gray);
    
    set(handles.checkInvalid, 'Value', 1);
    set(handles.checkMem, 'Value', 0);
    set(handles.checkGolgi, 'Value', 0);
    set(handles.checkGolgiStr, 'Value', 0);
    set(handles.checkCyto, 'Value', 0);
end
    
% --- Executes on button press in checkCyto.
function checkCyto_Callback(hObject, eventdata, handles)    %done
% hObject    handle to checkCyto (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkCyto

value = get(handles.checkCyto, 'Value');

if value == 1
    set(handles.checkInvalid, 'Value', 0);
    set(handles.checkMem, 'Value', 0);
    set(handles.checkGolgi, 'Value', 0);
    set(handles.checkGolgiStr, 'Value', 0);
else
    set(handles.checkInvalid, 'Value', 1);
    set(handles.checkMem, 'Value', 0);
    set(handles.checkGolgi, 'Value', 0);
    set(handles.checkGolgiStr, 'Value', 0);
    set(handles.checkCyto, 'Value', 0); 
end

% --- Executes on button press in checkGolgi.
function checkGolgi_Callback(hObject, eventdata, handles)    %done
% hObject    handle to checkGolgi (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkGolgi
value = get(handles.checkGolgi, 'Value');

if value == 1
    set(handles.checkInvalid, 'Value', 0);
    set(handles.checkMem, 'Value', 0);
    set(handles.checkCyto, 'Value', 0);
    set(handles.checkGolgiStr, 'Value', 0);
else
    set(handles.checkInvalid, 'Value', 1);
    set(handles.checkMem, 'Value', 0);
    set(handles.checkGolgi, 'Value', 0);
    set(handles.checkGolgiStr, 'Value', 0);
    set(handles.checkCyto, 'Value', 0); 
end

% --- Executes on button press in checkMem.
function checkMem_Callback(hObject, eventdata, handles)   %done
% hObject    handle to checkMem (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkMem
value = get(handles.checkMem, 'Value');

if value == 1
    set(handles.checkInvalid, 'Value', 0);
    set(handles.checkGolgi, 'Value', 0);
    set(handles.checkGolgiStr, 'Value', 0);
    set(handles.checkCyto, 'Value', 0);
else
    set(handles.checkInvalid, 'Value', 1);
    set(handles.checkMem, 'Value', 0);
    set(handles.checkGolgi, 'Value', 0);
    set(handles.checkGolgiStr, 'Value', 0);
    set(handles.checkCyto, 'Value', 0); 
end

% --- Executes on button press in checkInvalid.
function checkInvalid_Callback(hObject, eventdata, handles)  %done
% hObject    handle to checkInvalid (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkInvalid
value = get(handles.checkMem, 'Value');

if value == 1
    set(handles.checkMem, 'Value', 0);
    set(handles.checkGolgiStr, 'Value', 0);
    set(handles.checkGolgi, 'Value', 0);
    set(handles.checkCyto, 'Value', 0);
else
    set(handles.checkInvalid, 'Value', 1);
    set(handles.checkMem, 'Value', 0);
    set(handles.checkGolgi, 'Value', 0);
    set(handles.checkGolgiStr, 'Value', 0);
    set(handles.checkCyto, 'Value', 0); 
end

function fileName_Callback(hObject, eventdata, handles)   %done
% hObject    handle to fileName (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of fileName as text
%        str2double(get(hObject,'String')) returns contents of fileName as a double

% --- Executes during object creation, after setting all properties.
function fileName_CreateFcn(hObject, eventdata, handles)
% hObject    handle to fileName (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in buttonRestInvalid.
function buttonRestInvalid_Callback(hObject, eventdata, handles)   %done
% hObject    handle to buttonRestInvalid (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global StrSavePath;   
global filesManual;   
global i;
global amountFiles;
global resultManual; 
global cellImage;
global validFiles;

%save result for last analyses

Inval    = get(handles.checkInvalid, 'Value');
Mem      = get(handles.checkMem, 'Value');
Golgi    = get(handles.checkGolgi, 'Value');
GolgiStr = get(handles.checkGolgiStr, 'Value');
Cyto     = get(handles.checkCyto, 'Value'); 

if Inval == 1
    resultManual(validFiles(i)) = 1;
elseif Mem ==1
    resultManual(validFiles(i)) = 4;
elseif Golgi ==1
    resultManual(validFiles(i)) = 3;
elseif GolgiStr ==1
    resultManual(validFiles(i)) = 5;
elseif Cyto ==1
    resultManual(validFiles(i)) = 2;
else
    resultManual(validFiles(i)) = 1;  %fehler -> invalid
end

%ende rest ist standardmig invalid
%close on
set(handles.buttonClose,'Visible','on');
    
%rest off
set(handles.CellImage,'Visible','off');
set(handles.text4,'Visible','off');
set(handles.cellNumber,'Visible','off');
set(handles.fileName,'Visible','off');
set(handles.checkCyto,'Visible','off');
set(handles.checkGolgi,'Visible','off');
set(handles.checkGolgiStr,'Visible','off');
set(handles.checkMem,'Visible','off');
set(handles.checkInvalid,'Visible','off');
set(handles.buttonRestInvalid,'Visible','off');
set(handles.CellImage,'Visible','off');
set(handles.buttonNext,'Visible','off');

function cellNumber_Callback(hObject, eventdata, handles)   %done
% hObject    handle to cellNumber (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of cellNumber as text
%        str2double(get(hObject,'String')) returns contents of cellNumber as a double

% --- Executes during object creation, after setting all properties.
function cellNumber_CreateFcn(hObject, eventdata, handles)
% hObject    handle to cellNumber (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on button press in checkGolgiStr.
function checkGolgiStr_Callback(hObject, eventdata, handles)
% hObject    handle to checkGolgiStr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkGolgiStr
value = get(handles.checkGolgiStr, 'Value');

if value == 1
    set(handles.checkInvalid, 'Value', 0);
    set(handles.checkMem, 'Value', 0);
    set(handles.checkCyto, 'Value', 0);
    set(handles.checkGolgi, 'Value', 0);
else
    set(handles.checkInvalid, 'Value', 1);
    set(handles.checkMem, 'Value', 0);
    set(handles.checkGolgi, 'Value', 0);
    set(handles.checkGolgiStr, 'Value', 0);
    set(handles.checkCyto, 'Value', 0); 
end


